/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.serializer.JSONSerializer;
import com.alibaba.fastjson.serializer.SerializeWriter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class FieldSerializer
implements Comparable<FieldSerializer> {
    protected final String name;
    private final Method method;
    private final Field field;
    private final String double_quoted_fieldPrefix;
    private final String single_quoted_fieldPrefix;
    private final String un_quoted_fieldPrefix;

    public FieldSerializer(String name, Method method, Field field) {
        this.name = name;
        this.method = method;
        this.field = field;
        method.setAccessible(true);
        this.double_quoted_fieldPrefix = '\"' + name + "\":";
        this.single_quoted_fieldPrefix = '\'' + name + "':";
        this.un_quoted_fieldPrefix = name + ":";
    }

    public Field getField() {
        return this.field;
    }

    public String getName() {
        return this.name;
    }

    public Method getMethod() {
        return this.method;
    }

    public void writePrefix(JSONSerializer serializer) throws IOException {
        SerializeWriter out = serializer.getWriter();
        if (serializer.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (serializer.isEnabled(SerializerFeature.UseSingleQuotes)) {
                out.write(this.single_quoted_fieldPrefix);
            } else {
                out.write(this.double_quoted_fieldPrefix);
            }
        } else {
            out.write(this.un_quoted_fieldPrefix);
        }
    }

    @Override
    public int compareTo(FieldSerializer o) {
        return this.name.compareTo(o.name);
    }

    public Object getPropertyValue(Object object) throws Exception {
        return this.method.invoke(object, new Object[0]);
    }

    public abstract void writeProperty(JSONSerializer var1, Object var2) throws Exception;
}

