/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.serializer.SerializeWriter;

public class ManualSerializer {
    protected static final int TYPE_ROOT = 0;
    protected static final int TYPE_ARRAY = 1;
    protected static final int TYPE_OBJECT = 2;
    public static final int STATUS_OK = 0;
    public static final int STATUS_OK_AFTER_COMMA = 1;
    public static final int STATUS_OK_AFTER_COLON = 2;
    public static final int STATUS_EXPECT_VALUE = 4;
    public static final int STATUS_EXPECT_NAME = 5;
    private SerializeWriter out = new SerializeWriter();
    private Context context = new Context(null, 0, 0);

    public void writeStartObject() {
        this.writeValueBefore();
        this.context = new Context(this.context, 2, 5);
        this.out.writeStartObject();
    }

    public void writeEndObject() {
        this.out.writeEndObject();
        this.context = this.context.parent;
        this.context.status = 0;
    }

    public void writeStartArray() {
        this.writeValueBefore();
        this.context = new Context(this.context, 1, 4);
        this.out.writeStartArray();
    }

    public void writeEndArray() {
        this.out.writeEndArray();
        this.context = this.context.parent;
        this.context.status = 0;
    }

    public void writeFieldName(String key) {
        this.writeFieldNameBefore();
        this.out.writeFieldName(key);
        this.context.status = 4;
        this.context.currentName = key;
    }

    private void writeFieldNameBefore() {
        if (this.context.type != 2) {
            throw new JSONException("error status");
        }
        if (this.context.status != 5) {
            if (this.context.status == 0) {
                this.out.write(',');
            } else {
                throw new JSONException("error status");
            }
        }
    }

    public void writeField(String fieldName, int value) {
        this.writeFieldName(fieldName);
        this.out.writeInt(value);
        this.context.status = 0;
    }

    public void writeField(String fieldName, long value) {
        this.writeFieldName(fieldName);
        this.out.writeLong(value);
        this.context.status = 0;
    }

    public void writeField(String fieldName, String value) {
        this.writeFieldName(fieldName);
        this.out.writeString(value);
        this.context.status = 0;
    }

    public void writeString(String value) {
        this.writeValueBefore();
        this.out.writeString(value);
        this.context.status = 0;
    }

    private void writeValueBefore() {
        if (this.context.type == 2) {
            if (this.context.status != 4) {
                throw new JSONException("error status");
            }
        } else if (this.context.type == 1 && this.context.status != 4) {
            if (this.context.status != 0) {
                throw new JSONException("error status");
            }
            this.out.write(',');
        }
    }

    public void close() {
        this.out.close();
    }

    public String toString() {
        return this.out.toString();
    }

    public byte[] toBytes(String charsetName) {
        return this.out.toBytes(charsetName);
    }

    static class Context {
        public final Context parent;
        public int status;
        public final int type;
        public String currentName;

        public Context(Context parent, int type, int status) {
            this.parent = parent;
            this.type = type;
            this.status = status;
        }

        public String toString() {
            String text = this.parent != null ? this.parent.toString() + "." : "";
            text = this.type == 0 ? text + "root" : (this.type == 2 ? text + "object" : text + "array");
            switch (this.status) {
                case 0: {
                    text = text + "_ok";
                    break;
                }
                case 5: {
                    text = text + "_expectName";
                    break;
                }
                case 4: {
                    text = text + "_expectValue";
                    break;
                }
                default: {
                    text = text + "_";
                }
            }
            return text;
        }
    }
}

