/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;

class SerialWriterStringEncoder {
    private final Charset charset;
    private final CharsetEncoder encoder;
    private final String charsetName;
    public static SerialWriterStringEncoder UTF8 = new SerialWriterStringEncoder(Charset.forName("UTF-8"), "UTF-8");
    public static SerialWriterStringEncoder ISO88591 = new SerialWriterStringEncoder(Charset.forName("ISO-8859-1"), "ISO-8859-1");
    public static SerialWriterStringEncoder GBK = new SerialWriterStringEncoder(Charset.forName("GBK"), "GBK");
    private static final int CACHE_SIZE = 4096;
    private static final ThreadLocal<byte[]> bufLocal = new ThreadLocal();

    public SerialWriterStringEncoder(Charset cs, String charsetName) {
        this.charsetName = charsetName;
        this.charset = cs;
        this.encoder = cs.newEncoder().onMalformedInput(CodingErrorAction.REPLACE).onUnmappableCharacter(CodingErrorAction.REPLACE);
    }

    public final String getCharsetName() {
        return this.charsetName;
    }

    public byte[] encode(char[] chars, int off, int len) {
        byte[] bytes;
        if (len == 0) {
            return new byte[0];
        }
        this.encoder.reset();
        int bytesLength = SerialWriterStringEncoder.scale(len, this.encoder.maxBytesPerChar());
        if (bytesLength > 4096) {
            bytes = new byte[bytesLength];
        } else {
            byte[] localByteBuf = bufLocal.get();
            if (localByteBuf == null) {
                bytes = new byte[4096];
                bufLocal.set(bytes);
            } else {
                bytes = localByteBuf;
            }
        }
        ByteBuffer byteBuf = ByteBuffer.wrap(bytes);
        CharBuffer charBuf = CharBuffer.wrap(chars, off, len);
        try {
            CoderResult cr = this.encoder.encode(charBuf, byteBuf, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = this.encoder.flush(byteBuf)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new Error(x);
        }
        return SerialWriterStringEncoder.safeTrim(bytes, byteBuf.position(), this.charset);
    }

    private static int scale(int len, float expansionFactor) {
        return (int)((double)len * (double)expansionFactor);
    }

    private static byte[] safeTrim(byte[] bytes, int len, Charset cs) {
        if (len == bytes.length && (System.getSecurityManager() == null || cs.getClass().getClassLoader() == null)) {
            return bytes;
        }
        byte[] copy = new byte[len];
        System.arraycopy(bytes, 0, copy, 0, len);
        return copy;
    }
}

