/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson.serializer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.CharTypes;
import com.alibaba.fastjson.serializer.IOUtils;
import com.alibaba.fastjson.serializer.SerialWriterStringEncoder;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.nio.charset.Charset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SerializeWriter
extends Writer {
    protected char[] buf;
    protected int count;
    private static final ThreadLocal<char[]> bufLocal = new ThreadLocal();
    private int features;

    public SerializeWriter() {
        this.features = JSON.DEFAULT_GENERATE_FEATURE;
        this.buf = bufLocal.get();
        if (this.buf == null) {
            this.buf = new char[1024];
        } else {
            bufLocal.set(null);
        }
    }

    public SerializeWriter(SerializerFeature ... features) {
        this.buf = bufLocal.get();
        if (this.buf == null) {
            this.buf = new char[1024];
        } else {
            bufLocal.set(null);
        }
        int featuresValue = 0;
        for (SerializerFeature feature : features) {
            featuresValue |= feature.getMask();
        }
        this.features = featuresValue;
    }

    public SerializeWriter(int initialSize) {
        if (initialSize < 0) {
            throw new IllegalArgumentException("Negative initial size: " + initialSize);
        }
        this.buf = new char[initialSize];
    }

    public void config(SerializerFeature feature, boolean state) {
        this.features = state ? (this.features |= feature.getMask()) : (this.features &= ~feature.getMask());
    }

    public boolean isEnabled(SerializerFeature feature) {
        return SerializerFeature.isEnabled(this.features, feature);
    }

    @Override
    public void write(int c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = (char)c;
        this.count = newcount;
    }

    public void write(char c) {
        int newcount = this.count + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = c;
        this.count = newcount;
    }

    public void writeStartObject() {
        this.write('{');
    }

    public void writeEndObject() {
        this.write('}');
    }

    public void writeStartArray() {
        this.write('[');
    }

    public void writeEndArray() {
        this.write(']');
    }

    @Override
    public void write(char[] c, int off, int len) {
        if (off < 0 || off > c.length || len < 0 || off + len > c.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        System.arraycopy(c, off, this.buf, this.count, len);
        this.count = newcount;
    }

    public void expandCapacity(int minimumCapacity) {
        int newCapacity = (this.buf.length + 1) * 2;
        if (newCapacity < minimumCapacity) {
            newCapacity = minimumCapacity;
        }
        char[] newValue = new char[newCapacity];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        this.buf = newValue;
    }

    @Override
    public void write(String str, int off, int len) {
        int newcount = this.count + len;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        str.getChars(off, off + len, this.buf, this.count);
        this.count = newcount;
    }

    public void writeTo(Writer out) throws IOException {
        out.write(this.buf, 0, this.count);
    }

    public void writeTo(OutputStream out, String charset) throws IOException {
        byte[] bytes = new String(this.buf, 0, this.count).getBytes(charset);
        out.write(bytes);
    }

    @Override
    public SerializeWriter append(CharSequence csq) {
        String s = csq == null ? "null" : ((Object)csq).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(CharSequence csq, int start, int end) {
        String s = ((Object)(csq == null ? "null" : csq).subSequence(start, end)).toString();
        this.write(s, 0, s.length());
        return this;
    }

    @Override
    public SerializeWriter append(char c) {
        this.write(c);
        return this;
    }

    public void reset() {
        this.count = 0;
    }

    public char[] toCharArray() {
        char[] newValue = new char[this.count];
        System.arraycopy(this.buf, 0, newValue, 0, this.count);
        return newValue;
    }

    public byte[] toBytes(String charsetName) {
        SerialWriterStringEncoder encoder;
        if (charsetName == null) {
            encoder = SerialWriterStringEncoder.ISO88591;
        } else if (charsetName.equals(SerialWriterStringEncoder.UTF8.getCharsetName())) {
            encoder = SerialWriterStringEncoder.UTF8;
        } else {
            Charset cs = Charset.forName(charsetName);
            encoder = new SerialWriterStringEncoder(cs, charsetName);
        }
        return encoder.encode(this.buf, 0, this.count);
    }

    public int size() {
        return this.count;
    }

    public String toString() {
        return new String(this.buf, 0, this.count);
    }

    @Override
    public void flush() {
    }

    @Override
    public void close() {
        bufLocal.set(this.buf);
    }

    public void writeBooleanArray(boolean[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            boolean val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) ? 4 : 5;
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            boolean val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if (val = array[i]) {
                this.buf[currentSize++] = 116;
                this.buf[currentSize++] = 114;
                this.buf[currentSize++] = 117;
                this.buf[currentSize++] = 101;
                continue;
            }
            this.buf[currentSize++] = 102;
            this.buf[currentSize++] = 97;
            this.buf[currentSize++] = 108;
            this.buf[currentSize++] = 115;
            this.buf[currentSize++] = 101;
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    @Override
    public void write(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        int length = text.length();
        int newcount = this.count + length;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        text.getChars(0, length, this.buf, this.count);
        this.count = newcount;
    }

    public void writeInt(int i) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            return;
        }
        int size = i < 0 ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeShortArray(short[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            int size;
            if (i != 0) {
                ++totalSize;
            }
            short val = array[i];
            sizeArray[i] = size = IOUtils.stringSize(val);
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            short val = array[i];
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeByteArray(byte[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            int size;
            if (i != 0) {
                ++totalSize;
            }
            byte val = array[i];
            sizeArray[i] = size = IOUtils.stringSize(val);
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            byte val = array[i];
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeIntArray(int[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            int val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == Integer.MIN_VALUE ? "-2147483648".length() : (val < 0 ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val));
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            int val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i]) == Integer.MIN_VALUE) {
                System.arraycopy("-2147483648".toCharArray(), 0, this.buf, currentSize, sizeArray[i]);
                currentSize += sizeArray[i];
                continue;
            }
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeIntArray(Integer[] array) throws IOException {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            Integer val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == null ? "null".length() : (val == Integer.MIN_VALUE ? "-2147483648".length() : (val < 0 ? IOUtils.stringSize(-val.intValue()) + 1 : IOUtils.stringSize(val)));
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            Integer val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i]) == null) {
                System.arraycopy("null".toCharArray(), 0, this.buf, currentSize, sizeArray[i]);
                currentSize += sizeArray[i];
                continue;
            }
            if (val == Integer.MIN_VALUE) {
                System.arraycopy("-2147483648".toCharArray(), 0, this.buf, currentSize, sizeArray[i]);
                currentSize += sizeArray[i];
                continue;
            }
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    public void writeIntAndChar(int i, char c) {
        if (i == Integer.MIN_VALUE) {
            this.write("-2147483648");
            this.write(c);
            return;
        }
        int size = i < 0 ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLongAndChar(long i, char c) throws IOException {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            this.write(c);
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount0 = this.count + size;
        int newcount1 = newcount0 + 1;
        if (newcount1 > this.buf.length) {
            this.expandCapacity(newcount1);
        }
        IOUtils.getChars(i, newcount0, this.buf);
        this.buf[newcount0] = c;
        this.count = newcount1;
    }

    public void writeLong(long i) {
        if (i == Long.MIN_VALUE) {
            this.write("-9223372036854775808");
            return;
        }
        int size = i < 0L ? IOUtils.stringSize(-i) + 1 : IOUtils.stringSize(i);
        int newcount = this.count + size;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        IOUtils.getChars(i, newcount, this.buf);
        this.count = newcount;
    }

    public void writeNull() {
        int newcount = this.count + 4;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 110;
        this.buf[this.count + 1] = 117;
        this.buf[this.count + 2] = 108;
        this.buf[this.count + 3] = 108;
        this.count = newcount;
    }

    public void writeLongArray(long[] array) {
        int[] sizeArray = new int[array.length];
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            long val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == Long.MIN_VALUE ? "-9223372036854775808".length() : (val < 0L ? IOUtils.stringSize(-val) + 1 : IOUtils.stringSize(val));
            sizeArray[i] = size;
            totalSize += size;
        }
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = 91;
        int currentSize = this.count + 1;
        for (int i = 0; i < array.length; ++i) {
            long val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i]) == Long.MIN_VALUE) {
                System.arraycopy("-9223372036854775808".toCharArray(), 0, this.buf, currentSize, sizeArray[i]);
                currentSize += sizeArray[i];
                continue;
            }
            IOUtils.getChars(val, currentSize += sizeArray[i], this.buf);
        }
        this.buf[currentSize] = 93;
        this.count = newcount;
    }

    private void writeStringWithDoubleQuote(String text) {
        if (text == null) {
            this.writeNull();
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"' && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial))) continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++end;
            int handleCount = 1;
            for (int i = lastSpecialIndex - 2; i >= start; --i) {
                char ch = this.buf[i];
                if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"') continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = CharTypes.replaceChars[ch];
                ++end;
                ++handleCount;
            }
        }
        this.buf[this.count - 1] = 34;
    }

    public void writeKeyWithDoubleQuote(String text) {
        boolean[] specicalFlags_doubleQuotes = CharTypes.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 3;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 34;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if ((ch >= specicalFlags_doubleQuotes.length || !specicalFlags_doubleQuotes[ch]) && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial))) continue;
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[this.count - 2] = 34;
        this.buf[this.count - 1] = 58;
    }

    public void writeFieldNull(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeNull();
    }

    public void writeFieldNullString(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullStringAsEmpty)) {
            this.writeString("");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullBoolean(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullBooleanAsFalse)) {
            this.write("false");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullList(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullListAsEmpty)) {
            this.write("[]");
        } else {
            this.writeNull();
        }
    }

    public void writeFieldNullNumber(char seperator, String name) {
        this.write(seperator);
        this.writeFieldName(name);
        if (this.isEnabled(SerializerFeature.WriteNullNumberAsZero)) {
            this.write('0');
        } else {
            this.writeNull();
        }
    }

    public void writeFieldValue(String name, int value) {
        this.writeString(name);
        this.write(':');
        this.writeInt(value);
    }

    public void writeFieldValue(char seperator, String name, char value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == '\u0000') {
            this.writeString("\u0000");
        } else {
            this.writeString(Character.toString(value));
        }
    }

    public void writeFieldValue(char seperator, String name, boolean value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value) {
            this.write("true");
        } else {
            this.write("false");
        }
    }

    public void writeFieldValue(char seperator, String name, int value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeInt(value);
    }

    public void writeFieldValue(char seperator, String name, long value) {
        this.write(seperator);
        this.writeFieldName(name);
        this.writeLong(value);
    }

    public void writeFieldValue(char seperator, String name, float value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0f) {
            this.write('0');
        } else if (Float.isNaN(value)) {
            this.writeNull();
        } else if (Float.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Float.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, double value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == 0.0) {
            this.write('0');
        } else if (Double.isNaN(value)) {
            this.writeNull();
        } else if (Double.isInfinite(value)) {
            this.writeNull();
        } else {
            String text = Double.toString(value);
            if (text.endsWith(".0")) {
                text = text.substring(0, text.length() - 2);
            }
            this.write(text);
        }
    }

    public void writeFieldValue(char seperator, String name, String value) {
        if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
                this.write(seperator);
                this.writeFieldName(name);
                if (value == null) {
                    this.writeNull();
                } else {
                    this.writeString(value);
                }
            } else {
                this.writeFieldValuewriteStringWithDoubleQuote(seperator, name, value);
            }
        } else {
            this.write(seperator);
            this.writeFieldName(name);
            if (value == null) {
                this.writeNull();
            } else {
                this.writeString(value);
            }
        }
    }

    public void writeFieldValuewriteStringWithDoubleQuote(char seperator, String name, String value) {
        int valueLen;
        int nameLen = name.length();
        int newcount = this.count;
        if (value == null) {
            valueLen = 4;
            newcount += nameLen + 10;
        } else {
            valueLen = value.length();
            newcount += nameLen + valueLen + 6;
        }
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.buf[this.count] = seperator;
        int nameStart = this.count + 2;
        int nameEnd = nameStart + nameLen;
        this.buf[this.count + 1] = 34;
        name.getChars(0, nameLen, this.buf, nameStart);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        for (int i = nameStart; i < nameEnd; ++i) {
            char ch = this.buf[i];
            if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"') continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
        }
        if (specialCount > 0) {
            if ((newcount += specialCount) > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
        }
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, nameEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, nameEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++nameEnd;
            int handleCount = 1;
            for (int i = lastSpecialIndex - 2; i >= nameStart; --i) {
                char ch = this.buf[i];
                if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"') continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, nameEnd - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = CharTypes.replaceChars[ch];
                ++nameEnd;
                ++handleCount;
            }
        }
        this.buf[nameEnd] = 34;
        int index = nameEnd + 1;
        this.buf[index++] = 58;
        if (value == null) {
            this.buf[index++] = 110;
            this.buf[index++] = 117;
            this.buf[index++] = 108;
            this.buf[index++] = 108;
            return;
        }
        this.buf[index++] = 34;
        int valueStart = index;
        int valueEnd = valueStart + valueLen;
        value.getChars(0, valueLen, this.buf, valueStart);
        specialCount = 0;
        lastSpecialIndex = -1;
        lastSpecial = '\u0000';
        for (int i = valueStart; i < valueEnd; ++i) {
            char ch = this.buf[i];
            if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"') continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
        }
        if (specialCount > 0) {
            if ((newcount += specialCount) > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
        }
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, valueEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, valueEnd - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++valueEnd;
            int handleCount = 1;
            for (int i = lastSpecialIndex - 2; i >= nameStart; --i) {
                char ch = this.buf[i];
                if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\"') continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, valueEnd - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = CharTypes.replaceChars[ch];
                ++valueEnd;
                ++handleCount;
            }
        }
        this.buf[valueEnd] = 34;
    }

    public void writeFieldValue(char seperator, String name, Enum<?> value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == null) {
            this.writeNull();
        } else if (this.isEnabled(SerializerFeature.WriteEnumUsingToString)) {
            this.writeString(value.name());
        } else {
            this.writeInt(value.ordinal());
        }
    }

    public void writeFieldValue(char seperator, String name, BigDecimal value) {
        this.write(seperator);
        this.writeFieldName(name);
        if (value == null) {
            this.writeNull();
        } else {
            this.write(value.toString());
        }
    }

    public void writeString(String text, char seperator) {
        this.writeString(text);
        this.write(seperator);
    }

    public void writeString(String text) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            this.writeStringWithSingleQuote(text);
        } else {
            this.writeStringWithDoubleQuote(text);
        }
    }

    private void writeStringWithSingleQuote(String text) {
        if (text == null) {
            int newcount = this.count + 4;
            if (newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            "null".getChars(0, 4, this.buf, this.count);
            this.count = newcount;
            return;
        }
        int len = text.length();
        int newcount = this.count + len + 2;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        int specialCount = 0;
        int lastSpecialIndex = -1;
        char lastSpecial = '\u0000';
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\'' && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial))) continue;
            ++specialCount;
            lastSpecialIndex = i;
            lastSpecial = ch;
        }
        if ((newcount += specialCount) > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        if (specialCount == 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
        } else if (specialCount > 1) {
            System.arraycopy(this.buf, lastSpecialIndex + 1, this.buf, lastSpecialIndex + 2, end - lastSpecialIndex - 1);
            this.buf[lastSpecialIndex] = 92;
            this.buf[++lastSpecialIndex] = CharTypes.replaceChars[lastSpecial];
            ++end;
            int handleCount = 1;
            for (int i = lastSpecialIndex - 2; i >= start; --i) {
                char ch = this.buf[i];
                if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '\'') continue;
                System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
                this.buf[i] = 92;
                this.buf[i + 1] = CharTypes.replaceChars[ch];
                ++end;
                ++handleCount;
            }
        }
        this.buf[this.count - 1] = 39;
    }

    public void writeStringArray(String[] array) {
        int totalSize = 2;
        for (int i = 0; i < array.length; ++i) {
            String val;
            if (i != 0) {
                ++totalSize;
            }
            int size = (val = array[i]) == null ? 4 : val.length() + 2;
            totalSize += size;
        }
        int currentSize = this.count;
        int newcount = this.count + totalSize;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        this.count = newcount;
        this.buf[currentSize++] = 91;
        for (int i = 0; i < array.length; ++i) {
            String val;
            if (i != 0) {
                this.buf[currentSize++] = 44;
            }
            if ((val = array[i]) == null) {
                this.buf[currentSize++] = 110;
                this.buf[currentSize++] = 117;
                this.buf[currentSize++] = 108;
                this.buf[currentSize++] = 108;
                continue;
            }
            this.buf[currentSize++] = 34;
            int start = currentSize;
            int len = val.length();
            val.getChars(0, len, this.buf, currentSize);
            int end = currentSize += len;
            this.buf[currentSize++] = 34;
            for (int j = start; j < end; ++j) {
                char ch = this.buf[j];
                if (ch != '\b' && ch != '\n' && ch != '\r' && ch != '\f' && ch != '\\' && ch != '/' && ch != '\"') continue;
                ++currentSize;
                if (++newcount > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, j + 1, this.buf, j + 2, end - j);
                this.buf[j] = 92;
                this.buf[++j] = CharTypes.replaceChars[ch];
                ++end;
            }
        }
        this.buf[currentSize] = 93;
    }

    public void writeFieldName(String key) {
        if (this.isEnabled(SerializerFeature.UseSingleQuotes)) {
            if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
                this.writeKeyWithSingleQuote(key);
            } else {
                this.writeKeyWithSingleQuoteIfHasSpecial(key);
            }
        } else if (this.isEnabled(SerializerFeature.QuoteFieldNames)) {
            this.writeKeyWithDoubleQuote(key);
        } else {
            this.writeKeyWithDoubleQuoteIfHasSpecial(key);
        }
    }

    public void writeKeyWithSingleQuote(String text) {
        boolean[] specicalFlags_singleQuotes = CharTypes.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 3;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count + 1;
        int end = start + len;
        this.buf[this.count] = 39;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if ((ch >= specicalFlags_singleQuotes.length || !specicalFlags_singleQuotes[ch]) && (ch != '\t' || !this.isEnabled(SerializerFeature.WriteTabAsSpecial))) continue;
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i - 1);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[this.count - 2] = 39;
        this.buf[this.count - 1] = 58;
    }

    public void writeKeyWithDoubleQuoteIfHasSpecial(String text) {
        boolean[] specicalFlags_doubleQuotes = CharTypes.specicalFlags_doubleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch >= specicalFlags_doubleQuotes.length || !specicalFlags_doubleQuotes[ch]) continue;
            if (!hasSpecial) {
                if ((newcount += 3) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[start] = 34;
                this.buf[++i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                end += 2;
                this.buf[this.count - 2] = 34;
                hasSpecial = true;
                continue;
            }
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[this.count - 1] = 58;
    }

    public void writeKeyWithSingleQuoteIfHasSpecial(String text) {
        boolean[] specicalFlags_singleQuotes = CharTypes.specicalFlags_singleQuotes;
        int len = text.length();
        int newcount = this.count + len + 1;
        if (newcount > this.buf.length) {
            this.expandCapacity(newcount);
        }
        int start = this.count;
        int end = start + len;
        text.getChars(0, len, this.buf, start);
        this.count = newcount;
        boolean hasSpecial = false;
        for (int i = start; i < end; ++i) {
            char ch = this.buf[i];
            if (ch >= specicalFlags_singleQuotes.length || !specicalFlags_singleQuotes[ch]) continue;
            if (!hasSpecial) {
                if ((newcount += 3) > this.buf.length) {
                    this.expandCapacity(newcount);
                }
                this.count = newcount;
                System.arraycopy(this.buf, i + 1, this.buf, i + 3, end - i - 1);
                System.arraycopy(this.buf, 0, this.buf, 1, i);
                this.buf[start] = 39;
                this.buf[++i] = 92;
                this.buf[++i] = CharTypes.replaceChars[ch];
                end += 2;
                this.buf[this.count - 2] = 39;
                hasSpecial = true;
                continue;
            }
            if (++newcount > this.buf.length) {
                this.expandCapacity(newcount);
            }
            this.count = newcount;
            System.arraycopy(this.buf, i + 1, this.buf, i + 2, end - i);
            this.buf[i] = 92;
            this.buf[++i] = CharTypes.replaceChars[ch];
            ++end;
        }
        this.buf[newcount - 1] = 58;
    }
}

