-- ----------------------------
-- Table structure for admin
-- ----------------------------
DROP TABLE IF EXISTS `admin`;
CREATE TABLE `admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `juri` int(11) NOT NULL DEFAULT '0',
  `lastLoginIp` varchar(255) DEFAULT NULL,
  `lastLoginTime` datetime DEFAULT NULL,
  `loginCount` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `adminwebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of admin
-- ----------------------------
INSERT INTO `admin` VALUES ('1', now(), '1', '127.0.0.1', now(), '0', 'admin', '21232f297a57a5a743894a0e4a801fc3', '1', '1');

-- ----------------------------
-- Table structure for agent
-- ----------------------------
DROP TABLE IF EXISTS `agent`;
CREATE TABLE `agent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `gonggao` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `siteDescription` varchar(255) DEFAULT NULL,
  `siteKeys` varchar(255) DEFAULT NULL,
  `siteName` varchar(255) DEFAULT NULL,
  `siteUrl` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `weibo` varchar(255) DEFAULT NULL,
  `weixin` varchar(255) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of agent
-- ----------------------------

-- ----------------------------
-- Table structure for article
-- ----------------------------
DROP TABLE IF EXISTS `article`;
CREATE TABLE `article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `content` text,
  `picture` varchar(255) DEFAULT NULL,
  `sortid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of article
-- ----------------------------

-- ----------------------------
-- Table structure for config
-- ----------------------------
DROP TABLE IF EXISTS `config`;
CREATE TABLE `config` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `alertContent` varchar(255) DEFAULT NULL,
  `gonggao` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `siteDescription` varchar(255) DEFAULT NULL,
  `siteKeys` varchar(255) DEFAULT NULL,
  `siteName` varchar(255) DEFAULT NULL,
  `siteUrl` varchar(255) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  `backgroundImg` varchar(255) DEFAULT NULL,
  `mp3` varchar(255) DEFAULT NULL,
  `softgonggao` varchar(255) DEFAULT NULL,
  `qrcode` varchar(255) DEFAULT NULL,
  `isopen` int(11) DEFAULT '1',
  `closeMessage` varchar(255) DEFAULT NULL,
   softcode VARCHAR(255),
   softkey VARCHAR(255),
   softdomain VARCHAR(255),
  PRIMARY KEY (`id`),
  KEY `configwebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of config
-- ----------------------------
INSERT INTO `config` VALUES ('1', now(), null, '凌夕网络', '凌夕网络全新系统11月16号部分业务开放：1.增加卡密缩放功能 2.增加批量充值、 3.永久保存订单 4.前台账号密码自动保存 5.各种人性化设计，给客户最好的下单体验 .', 'upload/file/20151019/P9030023.JPG', null, '582866070', '凌夕网络是一个综合性的多功能自助下单平台，以专业的团队、良好的售后屹立在网络之林！', '凌夕网络是一个综合性的多功能自助下单平台，以专业的团队、良好的售后屹立在网络之林！', '凌夕网络自助下单系统', 'http://www.9srdz.com/', '1', 'upload/img/20151212/1449907561113.jpg', 'http://up.mcyt.net/md5/17/NzEwOTM2MQ_Qq4329912.mp3', '所有软件都支持自动开单和手工开单,支持只开1个软件对接无数个卡盟!', null, '1',null,null,null,null);

-- ----------------------------
-- Table structure for financial
-- ----------------------------
DROP TABLE IF EXISTS `financial`;
CREATE TABLE `financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `balance` double DEFAULT NULL,
  `money` double DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL,
  `operator` varchar(255) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK154FDC893519E4C2` (`user`),
  KEY `financialwebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for gonggao
-- ----------------------------
DROP TABLE IF EXISTS `gonggao`;
CREATE TABLE `gonggao` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `noticewebsite` (`website`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=2056 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;

-- ----------------------------
-- Records of gonggao
-- ----------------------------

-- ----------------------------
-- Table structure for kami
-- ----------------------------
DROP TABLE IF EXISTS `kami`;
CREATE TABLE `kami` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `money` double DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `product` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  `userid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK321D725CEC6D32` (`product`),
  KEY `kamiwebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of kami
-- ----------------------------

-- ----------------------------
-- Table structure for message
-- ----------------------------
DROP TABLE IF EXISTS `message`;
CREATE TABLE `message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `deleted` bit(1) NOT NULL,
  `version` int(11) NOT NULL,
  `content` varchar(255) DEFAULT NULL,
  `reply` varchar(255) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of message
-- ----------------------------

-- ----------------------------
-- Table structure for notice
-- ----------------------------
DROP TABLE IF EXISTS `notice`;
CREATE TABLE `notice` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `content` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FKC20796D83519E4C2` (`user`),
  KEY `noticewebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of notice
-- ----------------------------

-- ----------------------------
-- Table structure for orders
-- ----------------------------
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `days` int(11) DEFAULT NULL,
  `dijitiao` int(11) DEFAULT NULL,
  `everydayNum` int(11) DEFAULT NULL,
  `kaitou` text,
  `meitiaoshuliang` int(11) DEFAULT NULL,
  `money` double DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL,
  `num` int(11) DEFAULT NULL,
  `payDate` datetime DEFAULT NULL,
  `productId` varchar(255) DEFAULT NULL,
  `productName` varchar(255) DEFAULT NULL,
  `qq` varchar(255) DEFAULT NULL,
  `qqmima` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `summary` varchar(255) DEFAULT NULL,
  `xiangcemingchen` varchar(255) DEFAULT NULL,
  `user` int(11) DEFAULT NULL,
  `xiangceshangchuanshijian` varchar(255) DEFAULT NULL,
  `duixingneirong` text,
  `ssid` varchar(255) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  `websitecost` double(11,2) NOT NULL DEFAULT '0.00',
  `handleWebsite` int(11) NOT NULL DEFAULT '0',
  `tiaoshu` int(11) DEFAULT NULL,
  `startNum` int(11) DEFAULT '0',
  `endNum` int(11) DEFAULT '0',
  `gequid` varchar(255) DEFAULT NULL,
  `xianhuashu` int(11) DEFAULT '0',
  `yingkeid` varchar(255) DEFAULT '0',
  `isedit` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FKC3DF62E53519E4C2` (`user`),
  KEY `orderswebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for order_template
-- ----------------------------
DROP TABLE IF EXISTS `order_template`;
CREATE TABLE `order_template` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `filepath` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('1', now(), 'template_1.ftl', 'QQ-说说条数-每天数量-天数');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('2', now(), 'template_2.ftl', 'QQ-QQ密码-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('3', now(), 'template_3.ftl', 'QQ-队型内容-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('4', now(), 'template_4.ftl', 'QQ-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('5', now(), 'template_5.ftl', 'QQ-QQ密码-下单天数');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('6', now(), 'template_6.ftl', 'QQ-QQ密码');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('7', now(), 'template_7.ftl', '歌曲ID-鲜花数');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('8', now(), 'template_8.ftl', 'QQ');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('9', now(), 'template_9.ftl', 'QQ-开头内容-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('10', now(), 'template_10.ftl', 'QQ-第几条-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('11', now(), 'template_11.ftl', 'QQ-相册名称-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('12', now(), 'template_12.ftl', 'QQ-相册名称-相册上传时间-下单数量');
INSERT INTO `order_template` (`id`, `createDate`, `filepath`, `name`) VALUES ('13', now(), 'template_13.ftl', '映客用户ID-下单数量');


-- ----------------------------
-- Table structure for product
-- ----------------------------
DROP TABLE IF EXISTS `product`;
CREATE TABLE `product` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `content` text,
  `picture` varchar(255) DEFAULT NULL,
  `scale` double(11,2) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `unit` varchar(255) DEFAULT NULL,
  `productCate` int(11) DEFAULT NULL,
  `template` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  `sortid` int(11) NOT NULL DEFAULT '0',
  `salewebsite` varchar(1000) DEFAULT NULL,
  `leastNum` int(11) NOT NULL DEFAULT '0',
  `status` int(1) NOT NULL DEFAULT '1' COMMENT '0禁止下单，1正常下单',
  PRIMARY KEY (`id`),
  KEY `FKED8DCCEF9F4FDAD1` (`productCate`),
  KEY `FKED8DCCEFD3365AB6` (`template`),
  KEY `productwebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for product_cate
-- ----------------------------
DROP TABLE IF EXISTS `product_cate`;
CREATE TABLE `product_cate` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `fatherId` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `productcatewebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;


-- ----------------------------
-- Table structure for user
-- ----------------------------
DROP TABLE IF EXISTS `user`;
CREATE TABLE `user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `balance` double DEFAULT NULL,
  `commission` double DEFAULT NULL,
  `lastLoginIp` varchar(255) DEFAULT NULL,
  `lastLoginTime` datetime DEFAULT NULL,
  `loginCount` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `nickname` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `phone` varchar(255) DEFAULT NULL,
  `registerIp` varchar(255) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `statusDate` datetime DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `product` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `FK36EBCB5CEC6D32` (`product`),
  KEY `userwebsite` (`website`)
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Table structure for website
-- ----------------------------
DROP TABLE IF EXISTS `website`;
CREATE TABLE `website` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `domain` varchar(255) DEFAULT NULL,
  `status` int(11) NOT NULL DEFAULT '0' COMMENT '0禁用，1启用',
  `balance` double(11,2) NOT NULL DEFAULT '0.00',
  `showQrcode` int(1) DEFAULT '0' COMMENT '是否显示二维码，0不显示，1显示',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- ----------------------------
-- Records of website
-- ----------------------------
INSERT INTO `website` VALUES ('1', now(), '主站', 'localhost', '1', '0.0', '0');


-- ----------------------------
-- Table structure for website_financial
-- ----------------------------
DROP TABLE IF EXISTS `website_financial`;
CREATE TABLE `website_financial` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `createDate` datetime DEFAULT NULL,
  `money` double(11,2) DEFAULT NULL,
  `no` varchar(255) DEFAULT NULL,
  `remark` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `website` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `financialwebsite` (`website`) USING BTREE
) ENGINE=MyISAM AUTO_INCREMENT=1 DEFAULT CHARSET=utf8 ROW_FORMAT=COMPACT;
