/*
 * Decompiled with CFR 0.152.
 */
package tot.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.bean.DataField;
import tot.db.DBUtils;
import tot.exception.DatabaseException;
import tot.exception.ObjectNotFoundException;

public class AbstractDao {
    private static Log log = LogFactory.getLog(AbstractDao.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findByPrimaryKey(int keyid, String table) {
        boolean retVal;
        block6: {
            Connection conn = null;
            PreparedStatement ps = null;
            ResultSet rs = null;
            retVal = false;
            try {
                conn = DBUtils.getConnection();
                StringBuffer sql = new StringBuffer(512);
                sql.append("SELECT " + keyid);
                sql.append(" FROM " + table);
                sql.append(" WHERE " + keyid + " = ?");
                ps = conn.prepareStatement(sql.toString());
                ps.setInt(1, keyid);
                rs = ps.executeQuery();
                if (rs.next()) {
                    retVal = true;
                }
                DBUtils.closeResultSet(rs);
            }
            catch (SQLException e) {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
                break block6;
            }
            finally {
                DBUtils.closeResultSet(rs);
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getData(String sqlStr, String fieldArr) {
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        ArrayList<DataField> returnList = new ArrayList<DataField>();
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sqlStr);
            String[] splitStr = null;
            splitStr = fieldArr.split(",");
            while (rs.next()) {
                DataField df = new DataField();
                for (int i = 0; i < splitStr.length; ++i) {
                    df.setField(splitStr[i], rs.getString(i + 1), 0);
                }
                returnList.add(df);
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sqlStr), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnList;
    }

    public Collection getDataList_mysqlLimit(String sqlStr, String fieldArr, int rowsNum, int offset) {
        StringBuffer sb = new StringBuffer(512);
        sb.append(sqlStr);
        sb.append(" limit " + offset + "," + rowsNum);
        return this.getData(sb.toString(), fieldArr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection getDataList_Limit_Normal(String sqlStr, String fieldArr, int rowsNum, int offset) {
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        ArrayList<DataField> returnList = new ArrayList<DataField>();
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sqlStr, 1004, 1007);
            ps.setMaxRows(offset + rowsNum);
            try {
                ps.setFetchSize(rowsNum);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            rs = ps.executeQuery();
            boolean loop = rs.absolute(offset + 1);
            String[] splitStr = null;
            splitStr = fieldArr.split(",");
            while (loop) {
                DataField df = new DataField();
                for (int i = 0; i < splitStr.length; ++i) {
                    df.setField(splitStr[i], rs.getString(i + 1), 0);
                }
                returnList.add(df);
                if (returnList.size() >= rowsNum) break;
                loop = rs.next();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)("Sql Exception Error:" + sqlStr), (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closeResultSet(rs);
                DBUtils.resetStatement(ps);
                DBUtils.closeStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closeResultSet(rs);
            DBUtils.resetStatement(ps);
            DBUtils.closeStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closeResultSet(rs);
        DBUtils.resetStatement(ps);
        DBUtils.closeStatement(ps);
        DBUtils.closeConnection(conn);
        return returnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataField getFirstData(String sqlStr, String fieldArr) {
        DataField df;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block5: {
            conn = null;
            stmt = null;
            rs = null;
            df = null;
            try {
                conn = DBUtils.getConnection();
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlStr);
                String[] splitStr = null;
                splitStr = fieldArr.split(",");
                if (!rs.next()) break block5;
                df = new DataField();
                for (int i = 0; i < splitStr.length; ++i) {
                    df.setField(splitStr[i], rs.getString(i + 1), 0);
                }
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"Sql Exception Error:", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(stmt);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return df;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getDataCount(String sqlStr) {
        int returnInt;
        ResultSet rs;
        Statement stmt;
        Connection conn;
        block4: {
            conn = null;
            stmt = null;
            rs = null;
            returnInt = 0;
            try {
                conn = DBUtils.getConnection();
                Object resultSet = null;
                stmt = conn.createStatement();
                rs = stmt.executeQuery(sqlStr);
                if (!rs.next()) break block4;
                returnInt = rs.getInt(1);
            }
            catch (SQLException e) {
                try {
                    log.error((Object)"Sql Exception Error:", (Throwable)e);
                }
                catch (Throwable throwable) {
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(stmt);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
                DBUtils.closeResultSet(rs);
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
            }
        }
        DBUtils.closeResultSet(rs);
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnInt;
    }

    public boolean exe(String sqlStr) throws ObjectNotFoundException, DatabaseException {
        Connection conn = null;
        Statement stmt = null;
        boolean returnValue = true;
        try {
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            returnValue = stmt.executeUpdate(sqlStr) == 1;
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
                throw new DatabaseException("Got Exception on Call Medthod exe in tot.dao.AbstractDao");
            }
            catch (Throwable throwable) {
                DBUtils.closeStatement(stmt);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
        }
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean exeTransaction(String sqlStr) throws ObjectNotFoundException, DatabaseException {
        boolean returnValue;
        Statement stmt;
        Connection conn;
        block12: {
            conn = null;
            stmt = null;
            returnValue = true;
            try {
                conn = DBUtils.getConnection();
                conn.setAutoCommit(false);
                stmt = conn.createStatement();
                returnValue = stmt.executeUpdate(sqlStr) == 1;
                conn.commit();
                if (conn == null) break block12;
            }
            catch (SQLException e) {
                try {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    log.error((Object)"Sql Exception Error:", (Throwable)e);
                    throw new DatabaseException("Got Exception on Call Medthod exeTransaction in tot.dao.AbstractDao");
                }
                catch (Throwable throwable) {
                    if (conn != null) {
                        try {
                            conn.rollback();
                        }
                        catch (SQLException e1) {
                            e1.printStackTrace();
                        }
                    }
                    DBUtils.closeStatement(stmt);
                    DBUtils.closeConnection(conn);
                    throw throwable;
                }
            }
            try {
                conn.rollback();
            }
            catch (SQLException e1) {
                e1.printStackTrace();
            }
        }
        DBUtils.closeStatement(stmt);
        DBUtils.closeConnection(conn);
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bat(String sqlStr, String[] fieldvalue) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnInt = false;
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sqlStr);
            for (int i = 0; i < fieldvalue.length; ++i) {
                int f = Integer.parseInt(fieldvalue[i]);
                ps.setInt(1, f);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            try {
                log.error((Object)"Sql Exception Error:", (Throwable)e);
            }
            catch (Throwable throwable) {
                DBUtils.closePrepareStatement(ps);
                DBUtils.closeConnection(conn);
                throw throwable;
            }
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        DBUtils.closePrepareStatement(ps);
        DBUtils.closeConnection(conn);
    }
}

