/*
 * Decompiled with CFR 0.152.
 */
package tot.filter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.regexp.RE;
import tot.global.Sysconfig;
import tot.util.StringUtils;

public final class IpFilter {
    private static Log log = LogFactory.getLog(IpFilter.class);
    private static RE[] blockedIPs = null;

    private IpFilter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean filter(String ip) {
        if (ip == null) {
            return false;
        }
        String checkIP = ip;
        for (int i = 0; i < blockedIPs.length; ++i) {
            RE currentBlockedIP = blockedIPs[i];
            if (currentBlockedIP == null) continue;
            RE rE = currentBlockedIP;
            synchronized (rE) {
                if (currentBlockedIP.match(checkIP)) {
                    return false;
                }
                continue;
            }
        }
        return true;
    }

    static {
        String[] blockedIPArray = StringUtils.split(Sysconfig.getBlockedIPs(), ";");
        blockedIPs = new RE[blockedIPArray.length];
        for (int i = 0; i < blockedIPArray.length; ++i) {
            String currentIPRegExp = StringUtils.replaceString(blockedIPArray[i], "*", "(\\d{1,3})");
            currentIPRegExp = "^" + currentIPRegExp + "$";
            try {
                log.debug((Object)("currentIPRegExp = " + currentIPRegExp));
                IpFilter.blockedIPs[i] = new RE(currentIPRegExp);
                continue;
            }
            catch (Exception ex) {
                log.error((Object)("Cannot parse the regular expression = " + currentIPRegExp), (Throwable)ex);
            }
        }
    }
}

