/*
 * Decompiled with CFR 0.152.
 */
package tot.global;

import java.io.File;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.util.FileUtil;
import tot.xml.DOM4JConfiguration;

public class Sysconfig {
    private static Log log = LogFactory.getLog(Sysconfig.class);
    static final String OPTION_FILE_NAME = "search-config.xml";
    private static String totcms_version = "TotSearch 2.0";
    private static boolean useDataSource = false;
    private static String dataSourceName = "";
    private static int databaseType = 0;
    private static String driverClassName = "org.gjt.mm.mysql.Driver";
    private static String databaseURL = "jdbc:mysql://127.0.0.1/totcms?useUnicode=true&characterEncoding=utf-8";
    private static String databaseUser = "root";
    private static String databasePassword = "";
    private static int maxConnection = 20;
    private static int maxTimeToWait = 2000;
    private static int minutesBetweenRefresh = 30;
    private static String indexdir = "";
    private static String luceneAnalyzerClassName = "org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer";
    private static boolean saveDb = false;
    private static int serverHourOffset = 0;
    private static String blockedIPs = "";
    private static String username = "";
    private static String password = "";

    public static String getTotCmsVersion() {
        return totcms_version;
    }

    public static boolean isUseDataSource() {
        return useDataSource;
    }

    public static String getDataSourceName() {
        return dataSourceName;
    }

    public static int getDatabaseType() {
        return databaseType;
    }

    public static String getDriverClassName() {
        return driverClassName;
    }

    public static String getDatabaseURL() {
        return databaseURL;
    }

    public static String getDatabaseUser() {
        return databaseUser;
    }

    public static String getDatabasePassword() {
        return databasePassword;
    }

    public static int getMaxConnection() {
        return maxConnection;
    }

    public static int getMaxTimeToWait() {
        return maxTimeToWait;
    }

    public static int getMinutesBetweenRefresh() {
        return minutesBetweenRefresh;
    }

    public static String getIndexDir() {
        indexdir = FileUtil.getServletClassesPath() + FileUtil.getSeparator() + "index";
        return indexdir;
    }

    public static String getLuceneAnalyzerClassName() {
        return luceneAnalyzerClassName;
    }

    public static boolean isSaveDb() {
        return saveDb;
    }

    public static int getServerHourOffset() {
        return serverHourOffset;
    }

    public static String getBlockedIPs() {
        return blockedIPs;
    }

    public static String getUserName() {
        return username;
    }

    public static String getPassword() {
        return password;
    }

    public static void load() {
        Sysconfig.reload();
    }

    public static void reload() {
        String classPath = FileUtil.getServletClassesPath();
        String configFilename = classPath + OPTION_FILE_NAME;
        try {
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));
            totcms_version = conf.getString("global_options.totsearch_version");
            useDataSource = conf.getBoolean("dboptions.use_datasource", false);
            databaseType = conf.getInt("dboptions.database_type", 0);
            if (useDataSource) {
                dataSourceName = conf.getString("dboptions.datasource_name");
            } else {
                driverClassName = conf.getString("dboptions.driver_class_name", driverClassName);
                databaseURL = conf.getString("dboptions.database_url", databaseURL);
                databaseUser = conf.getString("dboptions.database_user", databaseUser);
                databasePassword = conf.getString("dboptions.database_password", databasePassword);
                maxConnection = conf.getInt("dboptions.max_connection", maxConnection);
                maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", maxTimeToWait);
                if ((minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", minutesBetweenRefresh)) < 1) {
                    minutesBetweenRefresh = 1;
                }
            }
            indexdir = conf.getString("searchindex.indexdir", indexdir);
            luceneAnalyzerClassName = conf.getString("searchindex.lucene_analyzer_implementation", luceneAnalyzerClassName);
            saveDb = conf.getBoolean("searchindex.save_db");
            serverHourOffset = conf.getInt("dateoptions.server_hour_offset", serverHourOffset);
            if (serverHourOffset < -13 || serverHourOffset > 13) {
                serverHourOffset = 0;
            }
            blockedIPs = conf.getString("ipoptions.blocked_ip", blockedIPs);
            username = conf.getString("account.username", username);
            password = conf.getString("account.password", password);
        }
        catch (Exception e) {
            String message = "global.Sysconfig: Can't read the configuration file: '" + configFilename + "'. Make sure the file is in your CLASSPATH";
            log.error((Object)message, (Throwable)e);
        }
    }

    static {
        Sysconfig.load();
    }
}

