/*
 * Decompiled with CFR 0.152.
 */
package tot.i18n;

import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.i18n.EmptyResourceBundle;

public class ResourceBundleCache {
    private static Log log = LogFactory.getLog(ResourceBundleCache.class);
    private String bundleName = null;
    private Hashtable cacheResourceBundle = new Hashtable();

    public ResourceBundleCache(String bundleName) {
        if (bundleName == null) {
            throw new IllegalArgumentException("bundleName cannot be null.");
        }
        this.bundleName = bundleName;
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle resourceBundle;
        if (locale == null) {
            locale = Locale.ENGLISH;
        }
        if ((resourceBundle = (ResourceBundle)this.cacheResourceBundle.get(locale)) == null) {
            try {
                resourceBundle = ResourceBundle.getBundle(this.bundleName, locale);
            }
            catch (MissingResourceException e) {
                log.error((Object)("Cannot load the ResourceBundle = " + this.bundleName));
                log.info((Object)("Using EmptyResourceBundle because cannot load ResourceBundle = " + this.bundleName));
                resourceBundle = new EmptyResourceBundle();
            }
            this.cacheResourceBundle.put(locale, resourceBundle);
        }
        return resourceBundle;
    }

    public String getString(Locale locale, String key) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        try {
            return resourceBundle.getString(key);
        }
        catch (Exception ex) {
            return "[[" + key + "]]";
        }
    }

    public String getString(Locale locale, String key, Object[] args) {
        ResourceBundle resourceBundle = this.getResourceBundle(locale);
        try {
            String message = resourceBundle.getString(key);
            MessageFormat formatter = new MessageFormat(message);
            if (locale != null) {
                formatter.setLocale(locale);
            }
            message = formatter.format(args);
            return message;
        }
        catch (Exception ex) {
            return "[[[" + key + "]]]";
        }
    }
}

