/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.db.DBUtils;
import tot.global.Sysconfig;
import tot.search.ArticleIndex;
import tot.search.SearchService;
import tot.util.DateUtil;
import tot.util.FileUtil;

public class AddUpdateIndexTask
implements Runnable {
    private static Log log = LogFactory.getLog(AddUpdateIndexTask.class);
    public static final int OPERATION_ADD = 0;
    public static final int OPERATION_UPDATE = 1;
    String db_url = "jdbc:jtds:sqlserver://127.0.0.1:1433;DatabaseName=ekaid;";
    String db_user = "sys_u_ekaid";
    String db_password = "sys_u_ekaid_";
    private DataField df;
    private int operation;

    AddUpdateIndexTask() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        System.out.println(DateUtil.getCurrentGMTTimestamp() + "\u5b9a\u65f6\u7d22\u5f15\u5f00\u59cb");
        long start = System.currentTimeMillis();
        Directory directory = null;
        IndexWriter writer = null;
        int indexNum = 1;
        Connection conn = null;
        Statement stmt = null;
        ResultSet rs = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            writer = ArticleIndex.getIndexWriter(directory, false);
            String channel_pah = "";
            String tblname = "";
            String lastindexid = "0";
            String idfile = "";
            long id_next = 0L;
            try {
                Class.forName("net.sourceforge.jtds.jdbc.Driver");
                conn = DriverManager.getConnection(this.db_url, this.db_user, this.db_password);
                for (int ClassId = 1; ClassId <= 4; ++ClassId) {
                    long last_id;
                    tblname = "t_bid";
                    tblname = tblname + ClassId;
                    idfile = Sysconfig.getIndexDir() + FileUtil.getSeparator() + "id" + FileUtil.getSeparator();
                    switch (ClassId) {
                        case 1: {
                            channel_pah = "/zhaobiao/";
                            break;
                        }
                        case 2: {
                            channel_pah = "/caigou/";
                            break;
                        }
                        case 3: {
                            channel_pah = "/biangeng/";
                            break;
                        }
                        case 4: {
                            channel_pah = "/zhongbiao/";
                        }
                    }
                    idfile = idfile + tblname + "_id.txt";
                    if (FileUtil.exitsFile(idfile)) {
                        lastindexid = FileUtil.readFile(idfile, "UTF-8");
                    }
                    System.out.println(idfile + "\u4e0a\u6b21\u7d22\u5f15id:" + lastindexid);
                    id_next = last_id = Long.parseLong(lastindexid);
                    String fields = "id,ClassId,Title,Demons,PubDate,CityT,FromUrl";
                    String sql = "select " + fields + " from " + tblname + " where id>" + last_id;
                    stmt = conn.createStatement();
                    rs = stmt.executeQuery(sql);
                    String[] splitStr = null;
                    splitStr = fields.split(",");
                    int i = 0;
                    String linkurl = "";
                    while (rs.next()) {
                        DataField df = new DataField();
                        id_next = rs.getLong(1);
                        linkurl = channel_pah + rs.getString(1) + ".html";
                        df.setField("id", rs.getString(1), 0);
                        df.setField("classid", rs.getString(2), 0);
                        df.setField("title", rs.getString(3), 0);
                        df.setField("content", rs.getString(4), 0);
                        df.setField("demons", "", 0);
                        df.setField("newstime", rs.getString(5), 0);
                        df.setField("linkurl", linkurl, 0);
                        df.setField("author", rs.getString(6), 0);
                        ArticleIndex.doIndex(df, writer, tblname);
                        ++indexNum;
                        ++i;
                    }
                    System.out.println("\u7d22\u5f15:" + i + "\u6761<br>");
                    DBUtils.closeResultSet(rs);
                    DBUtils.closeStatement(stmt);
                    FileUtil.createFile(id_next + "", idfile, "UTF-8");
                }
                DBUtils.closeConnection(conn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                DBUtils.closeConnection(conn);
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while rebuilding index", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (directory != null) {
                    directory.close();
                    log.debug((Object)"Cannot close directory.");
                }
            }
            catch (IOException e) {
                log.debug((Object)"Close directory case exception:", (Throwable)e);
            }
        }
    }
}

