/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.exception.SearchException;
import tot.global.Sysconfig;
import tot.search.AddUpdateIndexTask;
import tot.search.SearchService;
import tot.util.StringUtils;
import tot.util.TimerUtil;

public class ArticleIndex {
    private static Log log = LogFactory.getLog(ArticleIndex.class);
    private static Analyzer analyzer;
    private static String searchArticleIndexDir;
    private static long lastOptimizeTime;

    public static void scheduleAddTask() {
        AddUpdateIndexTask task = new AddUpdateIndexTask();
        TimerUtil.getInstance().schedule(task, 10L, 300L);
    }

    public static void scheduleUpdateTask() {
        AddUpdateIndexTask task = new AddUpdateIndexTask();
        TimerUtil.getInstance().schedule(task, 10L, 300L);
    }

    public static void emptyIndex() {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            writer = ArticleIndex.getIndexWriter(directory, true);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void delIndex(String keyid) {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            writer.deleteDocuments(new Term[]{new Term("id", keyid)});
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    static Analyzer getAnalyzer() {
        return analyzer;
    }

    private static void initializeAnalyzer() {
        String analyzerClassName = Sysconfig.getLuceneAnalyzerClassName();
        analyzer = new SmartChineseAnalyzer();
        log.debug((Object)"Using StandardAnalyzer for indexing");
    }

    public static IndexWriter getIndexWriter(Directory directory, boolean create) {
        IndexWriter writer = null;
        IndexWriterConfig iwc = new IndexWriterConfig(analyzer);
        if (create) {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE);
        } else {
            iwc.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        }
        try {
            writer = new IndexWriter(directory, iwc);
        }
        catch (IOException e) {
            log.warn((Object)"Cannot open existed index. New index will be created.", (Throwable)e);
        }
        return writer;
    }

    public static void doIndex(DataField df, IndexWriter writer, String table) throws SearchException {
        if (df == null) {
            return;
        }
        String id = df.getFieldValue("id");
        String classid = df.getFieldValue("classid");
        String title = df.getFieldValue("title");
        String datetime = df.getFieldValue("newstime");
        String linkurl = df.getFieldValue("linkurl");
        String content = df.getFieldValue("content");
        String demons = df.getFieldValue("demons");
        String author = df.getFieldValue("author");
        if (title == null || title.equals("") || content == null || content.equals("")) {
            return;
        }
        if (demons == null || demons.equals("")) {
            demons = StringUtils.removeHtml(content);
        }
        if (demons.length() > 100) {
            demons = demons.substring(0, 100);
        }
        Document dfDocument = new Document();
        dfDocument.add((IndexableField)new StringField("id", id, Field.Store.YES));
        dfDocument.add((IndexableField)new StringField("Table", table, Field.Store.YES));
        dfDocument.add((IndexableField)new StringField("CategoryId", classid, Field.Store.YES));
        if (Sysconfig.isSaveDb()) {
            DaoFactory.getArticleDAO().add(table + "_" + id, title, demons, linkurl, author);
            dfDocument.add((IndexableField)new TextField("Title", title, Field.Store.NO));
            dfDocument.add((IndexableField)new TextField("Content", content, Field.Store.NO));
        } else {
            dfDocument.add((IndexableField)new TextField("Title", title, Field.Store.YES));
            dfDocument.add((IndexableField)new TextField("Content", demons, Field.Store.YES));
            dfDocument.add((IndexableField)new TextField("Author", author, Field.Store.YES));
            dfDocument.add((IndexableField)new TextField("LinkUrl", linkurl, Field.Store.YES));
        }
        dfDocument.add((IndexableField)new NumericDocValuesField("SortId", Long.parseLong(id)));
        dfDocument.add((IndexableField)new LongField("ModiTime", Timestamp.valueOf(datetime).getTime(), Field.Store.YES));
        try {
            writer.addDocument((Iterable)dfDocument);
        }
        catch (IOException e) {
            log.error((Object)"ArticleIndexer.doIndex failed", (Throwable)e);
        }
    }

    public static void optimizeIndex() throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            log.debug((Object)"writer.optimize() called in addToIndex");
        }
        catch (Exception e) {
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    static void addToIndex(DataField df) throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            ArticleIndex.doIndex(df, writer, "");
        }
        catch (SearchException ex) {
            throw ex;
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deleteFromIndex(String dfID) throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            writer = ArticleIndex.getIndexWriter(directory, false);
            if (writer == null) {
                log.warn((Object)"Cannot get the IndexWriter");
                return;
            }
            Term term = new Term("id", dfID);
            writer.deleteDocuments(new Term[]{term});
        }
        catch (Exception ex) {
            log.error((Object)("Error while performing index delete operation by id:" + dfID), (Throwable)ex);
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexWriter", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNumDocs() {
        int numDocs = -1;
        Directory directory = null;
        DirectoryReader reader = null;
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            reader = DirectoryReader.open((Directory)directory);
            if (reader == null) {
                log.warn((Object)"Cannot get the IndexReader");
                int n = -1;
                return n;
            }
            numDocs = reader.numDocs();
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Error closing Lucene IndexReader", (Throwable)e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                }
                catch (IOException e) {
                    log.debug((Object)"Cannot close directory.", (Throwable)e);
                }
            }
        }
        return numDocs;
    }

    static {
        lastOptimizeTime = 0L;
        searchArticleIndexDir = Sysconfig.getIndexDir();
        ArticleIndex.initializeAnalyzer();
    }
}

