/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import tot.search.ArticleIndex;
import tot.search.SearchService;

public class CreateEmptyIndexTask
extends TimerTask {
    private static Log log = LogFactory.getLog(CreateEmptyIndexTask.class);
    public static final int Articles_PER_FETCH = 200;
    public static final int MERGE_FACTOR = 20;
    private int maxArticleID = 0;
    private static boolean isRebuilding = false;

    public static boolean isRebuilding() {
        return isRebuilding;
    }

    CreateEmptyIndexTask(int maxArticleID) {
        this.maxArticleID = maxArticleID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        isRebuilding = true;
        long start = System.currentTimeMillis();
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchDirectory("");
            writer = ArticleIndex.getIndexWriter(directory, true);
            log.info((Object)"Success create empty index file.");
        }
        catch (Exception e) {
            log.error((Object)"Error while rebuilding index", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (directory != null) {
                    directory.close();
                    log.debug((Object)"Cannot close directory.");
                }
            }
            catch (IOException e) {
                log.debug((Object)"Close directory case exception:", (Throwable)e);
            }
        }
        log.info((Object)("RebuildIndexTask took " + (System.currentTimeMillis() - start) + " ms"));
        isRebuilding = false;
    }
}

