/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.util.Collection;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.search.ArticleIndex;
import tot.search.SearchService;

public class RebuildIndexTask
extends TimerTask {
    private static Log log = LogFactory.getLog(RebuildIndexTask.class);
    public static final int Articles_PER_FETCH = 200;
    public static final int MERGE_FACTOR = 20;
    private String sql = "";
    private String fields = "";
    private static boolean isRebuilding = false;

    public static boolean isRebuilding() {
        return isRebuilding;
    }

    RebuildIndexTask(String s, String f) {
        this.sql = s;
        this.fields = f;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        isRebuilding = true;
        long start = System.currentTimeMillis();
        Directory directory = null;
        IndexWriter writer = null;
        int indexNum = 1;
        try {
            directory = SearchService.getSearchDirectory("");
            writer = ArticleIndex.getIndexWriter(directory, false);
            Collection articles = null;
            for (DataField df : articles) {
                ArticleIndex.doIndex(df, writer, "");
                ++indexNum;
            }
            log.info((Object)("Rebuilt index finished successfully! " + indexNum + " article(s) indexed."));
        }
        catch (Exception e) {
            log.error((Object)"Error while rebuilding index", (Throwable)e);
        }
        finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (directory != null) {
                    directory.close();
                    log.debug((Object)"Cannot close directory.");
                }
            }
            catch (IOException e) {
                log.debug((Object)"Close directory case exception:", (Throwable)e);
            }
        }
        log.info((Object)("RebuildIndexTask took " + (System.currentTimeMillis() - start) + " ms"));
        isRebuilding = false;
    }
}

