/*
 * Decompiled with CFR 0.152.
 */
package tot.search;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.QueryScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.store.Directory;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.global.Sysconfig;
import tot.search.SearchService;

public class SearchQuery {
    private static Log log = LogFactory.getLog(SearchQuery.class);
    public static final int SEARCH_ANY_DATE = 0;
    public static final int SEARCH_NEWER = 1;
    public static final int SEARCH_OLDER = 2;
    public static final int SEARCH_ONLY_TITLE = 1;
    public static final int SEARCH_ONLY_BODY = 2;
    public static final int SEARCH_SORT_DEFAULT = 0;
    public static final int SEARCH_SORT_TIME_DESC = 1;
    public static final int SEARCH_SORT_TIME_ASC = 2;
    private String userName = null;
    private int catalogid = -1;
    private int b2b = -1;
    private String table = null;
    private int province = -1;
    private int city = -1;
    private String searchString = null;
    private Timestamp fromDate = null;
    private Timestamp toDate = null;
    private String searchIndexDir = Sysconfig.getIndexDir();
    private int hitCount = 0;
    private Collection searchResult = null;
    Analyzer analyzer = null;
    private int scopeInArticle = 3;
    private int sort = 0;
    private int search_and_or;

    public void setCatalogId(int catalogid) {
        this.catalogid = catalogid;
    }

    public void setTable(String t) {
        this.table = t;
    }

    public void setSearchAndOr(int sao) {
        this.search_and_or = sao;
    }

    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setScopeInArticle(int scopeInArticle) {
        this.scopeInArticle = scopeInArticle;
    }

    public void setFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Timestamp toDate) {
        this.toDate = toDate;
    }

    public void setSortType(int stype) {
        this.sort = stype;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void searchDocuments(int offset, int rowsToReturn) throws IOException {
        if (this.searchString == null || this.searchString.equals("")) {
            return;
        }
        this.analyzer = new SmartChineseAnalyzer();
        BooleanQuery query = null;
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        try {
            Query tableQuery;
            Query catalogQuery;
            Query topicBodyQuery = this.getTopicBodyQuery();
            if (topicBodyQuery != null) {
                builder.add(topicBodyQuery, BooleanClause.Occur.MUST);
                log.debug((Object)("topicBodyQuery = " + topicBodyQuery));
            }
            if ((catalogQuery = this.getCatalogQuery()) != null) {
                log.debug((Object)("categoryForumQuery = " + catalogQuery));
                builder.add(catalogQuery, BooleanClause.Occur.MUST);
            }
            if ((tableQuery = this.getTableQuery()) != null) {
                log.debug((Object)("tableQuery = " + tableQuery));
                builder.add(tableQuery, BooleanClause.Occur.MUST);
            }
        }
        catch (Exception pe) {
            log.error((Object)"Cannot parse the search query", (Throwable)pe);
        }
        log.debug((Object)("booleanQuery = " + builder));
        if (this.fromDate != null && this.toDate != null) {
            Query daterange = this.getRangeQuery();
            builder.add(daterange, BooleanClause.Occur.MUST);
        }
        query = builder.build();
        Directory directory = null;
        IndexSearcher searcher = null;
        DirectoryReader reader = null;
        int cachetops = offset + rowsToReturn;
        if (cachetops <= 0) {
            cachetops = 20;
        }
        try {
            directory = SearchService.getSearchDirectory(Sysconfig.getIndexDir());
            reader = DirectoryReader.open((Directory)directory);
            searcher = new IndexSearcher((IndexReader)reader);
            TopFieldDocs docs = null;
            docs = searcher.search((Query)query, cachetops, this.getQuerySort());
            this.hitCount = docs.totalHits;
            this.searchResult = new ArrayList(this.hitCount);
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            String fields = "keyid,title,demons,linkurl,author";
            SimpleHTMLFormatter htmlFormatter = new SimpleHTMLFormatter("<span class=\"red\">", "</span>");
            Highlighter highlighter = new Highlighter((Formatter)htmlFormatter, (Scorer)new QueryScorer((Query)query));
            String Title = "";
            String Content = "";
            StringBuffer hlStr = null;
            for (int i = offset; i < offset + rowsToReturn && i < this.hitCount; ++i) {
                Document doc = searcher.doc(scoreDocs[i].doc);
                String id = doc.get("id");
                String tbl = doc.get("Table");
                String dates = doc.get("ModiTime");
                DataField df = null;
                if (Sysconfig.isSaveDb()) {
                    String sql = "select " + fields + "  from tot_search where keyid='" + tbl + "_" + id + "'";
                    df = DaoFactory.getArticleDAO().getFirstData(sql, fields);
                    Title = df.getStr("title");
                    Content = df.getStr("demons");
                } else {
                    df = new DataField();
                    Title = doc.get("Title");
                    Content = doc.get("Content");
                    df.setField("title", Title, 0);
                    df.setField("demons", Content, 0);
                    df.setField("linkurl", doc.get("LinkUrl"), 0);
                    df.setField("author", doc.get("Author"), 0);
                }
                df.setField("moditime", dates, 0);
                df.setField("table", tbl, 0);
                hlStr = new StringBuffer();
                try {
                    int j;
                    TokenStream tokenStream = this.analyzer.tokenStream("Title", (Reader)new StringReader(Title));
                    TextFragment[] frag = highlighter.getBestTextFragments(tokenStream, Title, false, 10);
                    for (j = 0; j < frag.length; ++j) {
                        hlStr.append(frag[j].toString());
                        if (frag[j] != null && !(frag[j].getScore() > 0.0f)) continue;
                    }
                    df.setField("title", hlStr.toString(), 0);
                    hlStr = new StringBuffer();
                    tokenStream = this.analyzer.tokenStream("Content", (Reader)new StringReader(Content));
                    frag = highlighter.getBestTextFragments(tokenStream, Content, false, 10);
                    for (j = 0; j < frag.length; ++j) {
                        hlStr.append(frag[j].toString());
                        if (frag[j] != null && !(frag[j].getScore() > 0.0f)) continue;
                    }
                    df.setField("demons", hlStr.toString(), 0);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
                this.searchResult.add(df);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public int getHitCount() {
        return this.hitCount;
    }

    public Collection getArticleResult() {
        if (this.searchResult == null) {
            this.searchResult = new ArrayList();
        }
        return this.searchResult;
    }

    private Query getTopicBodyQuery() throws ParseException {
        if (this.searchString == null || this.searchString.equals("")) {
            return null;
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        String fieldname = "Title";
        if (this.scopeInArticle == 1) {
            fieldname = "Title";
        } else if (this.scopeInArticle == 2) {
            fieldname = "Content";
        }
        if (this.scopeInArticle > 0) {
            return this.GetParse(fieldname, this.searchString, this.analyzer);
        }
        builder.add(this.GetParse("Title", this.searchString, this.analyzer), BooleanClause.Occur.SHOULD);
        builder.add(this.GetParse("Content", this.searchString, this.analyzer), BooleanClause.Occur.SHOULD);
        builder.setMinimumNumberShouldMatch(1);
        return builder.build();
    }

    private Query GetParse(String fieldname, String s, Analyzer analyzer) throws ParseException {
        QueryParser parse = new QueryParser(fieldname, analyzer);
        if (this.search_and_or == 1) {
            parse.setDefaultOperator(QueryParser.AND_OPERATOR);
        } else {
            parse.setDefaultOperator(QueryParser.OR_OPERATOR);
        }
        return parse.parse(s);
    }

    private Query getRangeQuery() {
        NumericRangeQuery query = null;
        query = NumericRangeQuery.newLongRange((String)"ModiTime", (Long)this.fromDate.getTime(), (Long)this.toDate.getTime(), (boolean)true, (boolean)true);
        return query;
    }

    private Query getCatalogQuery() {
        TermQuery catalogQuery = null;
        if (this.catalogid > 0) {
            Term catalogTerm = new Term("CategoryId", String.valueOf(this.catalogid));
            catalogQuery = new TermQuery(catalogTerm);
        }
        return catalogQuery;
    }

    private Query getTableQuery() {
        TermQuery tableQuery = null;
        if (this.table != null) {
            Term tableTerm = new Term("Table", String.valueOf(this.table));
            tableQuery = new TermQuery(tableTerm);
        }
        return tableQuery;
    }

    public void setSort(int sort) {
        if (sort != 0 && sort != 2 && sort != 1) {
            throw new IllegalArgumentException("Does not support sort = " + sort);
        }
        this.sort = sort;
    }

    public int getSort() {
        return this.sort;
    }

    private Sort getQuerySort() {
        Sort sortObj = null;
        switch (this.sort) {
            case 2: {
                sortObj = new Sort(new SortField("SortId", SortField.Type.LONG, false));
                break;
            }
            case 1: {
                sortObj = new Sort(new SortField("SortId", SortField.Type.LONG, true));
                break;
            }
            default: {
                sortObj = new Sort();
            }
        }
        return sortObj;
    }
}

