/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.exception.FloodException;
import tot.util.ControlledAction;

public class FloodControl {
    private static Log log = LogFactory.getLog(FloodControl.class);
    private static Map actionControlMap = new TreeMap();
    static final long REMOVE_INTERVAL = 2000L;

    private FloodControl() {
    }

    public static void setOption(Integer action, int actionsPerHour) {
        FloodControl.getControlledAction(action).setActionsPerHour(actionsPerHour);
    }

    public static int getActionsPerHour(Integer action) {
        return FloodControl.getControlledAction(action).getActionsPerHour();
    }

    public static boolean reachMaximum(Integer action, String strIP) {
        return FloodControl.getControlledAction(action).reachMaximum(strIP);
    }

    public static void ensureNotReachMaximum(Integer action, String strIP) throws FloodException {
        if (FloodControl.reachMaximum(action, strIP)) {
            log.info((Object)("Attempt to exceed the maximum number of actions: ActionID = " + action + " and IP = " + strIP));
            throw new FloodException("You have reached the maximum number of actions for this page (actionID = " + action + "). Please try this page later.");
        }
    }

    public static void increaseCount(Integer action, String strIP) {
        FloodControl.getControlledAction(action).increaseCount(strIP);
    }

    public static void resetActionHistory(Integer action, String strIP) {
        FloodControl.getControlledAction(action).resetActionHistory(strIP);
    }

    private static synchronized ControlledAction getControlledAction(Integer action) {
        ControlledAction controlledAction = (ControlledAction)actionControlMap.get(action);
        if (controlledAction == null) {
            controlledAction = new ControlledAction();
            actionControlMap.put(action, controlledAction);
        }
        return controlledAction;
    }
}

