/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FormatUtil {
    private static Log log = LogFactory.getLog(FormatUtil.class);

    public static String formatNumber(double d, String pattern, Locale l) {
        String s = "";
        try {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getInstance(l);
            nf.applyPattern(pattern);
            s = nf.format(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)" formatNumber is error!");
        }
        return s;
    }

    public static String formatNumber(double d, String pattern) {
        return FormatUtil.formatNumber(d, pattern, Locale.getDefault());
    }

    public static String formatCurrency(double d, String pattern, Locale l) {
        String s = "";
        try {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getCurrencyInstance(l);
            nf.applyPattern(pattern);
            s = nf.format(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)" formatNumber is error!");
        }
        return s;
    }

    public static String formatCurrency(double d, String pattern) {
        return FormatUtil.formatCurrency(d, pattern, Locale.getDefault());
    }

    public static String formatCurrency(double d) {
        String s = "";
        try {
            DecimalFormat nf = (DecimalFormat)NumberFormat.getCurrencyInstance();
            s = nf.format(d);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error((Object)" formatNumber is error!");
        }
        return s;
    }

    public static String formatPercent(double d, String pattern, Locale l) {
        String s = "";
        try {
            DecimalFormat df = (DecimalFormat)NumberFormat.getPercentInstance(l);
            df.applyPattern(pattern);
            s = df.format(d);
        }
        catch (Exception e) {
            log.error((Object)"formatPercent is error!");
        }
        return s;
    }

    public static String formatPercent(double d, String pattern) {
        return FormatUtil.formatPercent(d, pattern, Locale.getDefault());
    }

    public static String formatPercent(double d) {
        String s = "";
        try {
            DecimalFormat df = (DecimalFormat)NumberFormat.getPercentInstance();
            s = df.format(d);
        }
        catch (Exception e) {
            log.error((Object)"formatPercent is error!");
        }
        return s;
    }

    public static String numberFormat(BigDecimal bd, String format) {
        if (bd == null || "0".equals(bd.toString())) {
            return "";
        }
        DecimalFormat bf = new DecimalFormat(format);
        return bf.format(bd);
    }

    public static void main(String[] args) {
        String s = FormatUtil.formatCurrency(11123.89343, "$##,##.000");
        System.out.println(s);
    }
}

