/*
 * Decompiled with CFR 0.152.
 */
package tot.util;

import java.util.Date;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TimerUtil {
    private static Log log = LogFactory.getLog(TimerUtil.class);
    private static TimerUtil instance = null;
    private static boolean isCanceled = false;
    private ScheduledExecutorService timer = null;

    private TimerUtil() {
        log.debug((Object)"TimerUtil is instantiated.");
        this.timer = Executors.newScheduledThreadPool(1);
    }

    private void reloadTimer() {
        log.info((Object)"Reload Timer in TimerUtil.");
        if (!isCanceled) {
            this.timer.shutdown();
            try {
                this.timer.awaitTermination(2L, TimeUnit.SECONDS);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (this.timer.isTerminated()) {
                this.timer.shutdownNow();
            }
        }
    }

    public static synchronized TimerUtil getInstance() {
        if (instance == null) {
            instance = new TimerUtil();
        }
        return instance;
    }

    public void cancel() {
        isCanceled = true;
        this.timer.shutdown();
    }

    public void schedule(Runnable task, long delay, long period) {
        if (!isCanceled) {
            try {
                this.timer.scheduleAtFixedRate(task, delay, period, TimeUnit.SECONDS);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void scheduleAtFixedRate(TimerTask task, Date firstTime, long period) {
        if (!isCanceled) {
            try {
                this.timer.scheduleAtFixedRate(task, firstTime.getTime(), period, TimeUnit.SECONDS);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }

    public void scheduleAtFixedRate(TimerTask task, long delay, long period) {
        if (!isCanceled) {
            try {
                this.timer.scheduleAtFixedRate(task, delay, period, TimeUnit.SECONDS);
            }
            catch (IllegalStateException ex) {
                log.error((Object)"Cannot schedule task!", (Throwable)ex);
                this.reloadTimer();
            }
        }
    }
}

