/*
 * Decompiled with CFR 0.152.
 */
package tot.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.xml.BaseConfiguration;
import tot.xml.Configuration;

public abstract class AbstractConfiguration
implements Configuration {
    private static final int INITIAL_LIST_SIZE = 2;
    private static Log log = LogFactory.getLog(AbstractConfiguration.class);
    protected Configuration defaults = null;
    protected static final String START_TOKEN = "${";
    protected static final String END_TOKEN = "}";

    public AbstractConfiguration() {
    }

    public AbstractConfiguration(Configuration defaults) {
        this();
        this.defaults = defaults;
    }

    @Override
    public void addProperty(String key, Object token) {
        if (token instanceof String) {
            Iterator it = this.processString((String)token).iterator();
            while (it.hasNext()) {
                this.addPropertyDirect(key, it.next());
            }
        } else if (token instanceof Collection) {
            Iterator it = ((Collection)token).iterator();
            while (it.hasNext()) {
                this.addProperty(key, it.next());
            }
        } else {
            this.addPropertyDirect(key, token);
        }
    }

    protected abstract Object getPropertyDirect(String var1);

    protected abstract void addPropertyDirect(String var1, Object var2);

    protected String interpolate(String base) {
        return this.interpolateHelper(base, null);
    }

    protected String interpolateHelper(String base, List priorVariables) {
        if (base == null) {
            return null;
        }
        if (priorVariables == null) {
            priorVariables = new ArrayList<String>();
            priorVariables.add(base);
        }
        int begin = -1;
        int end = -1;
        int prec = 0 - END_TOKEN.length();
        String variable = null;
        StringBuffer result = new StringBuffer();
        while ((begin = base.indexOf(START_TOKEN, prec + END_TOKEN.length())) > -1 && (end = base.indexOf(END_TOKEN, begin)) > -1) {
            result.append(base.substring(prec + END_TOKEN.length(), begin));
            variable = base.substring(begin + START_TOKEN.length(), end);
            if (priorVariables.contains(variable)) {
                String initialBase = priorVariables.remove(0).toString();
                priorVariables.add(variable);
                StringBuffer priorVariableSb = new StringBuffer();
                Iterator it = priorVariables.iterator();
                while (it.hasNext()) {
                    priorVariableSb.append(it.next());
                    if (!it.hasNext()) continue;
                    priorVariableSb.append("->");
                }
                throw new IllegalStateException("infinite loop in property interpolation of " + initialBase + ": " + priorVariableSb.toString());
            }
            priorVariables.add(variable);
            Object value = this.getProperty(variable);
            if (value != null) {
                result.append(this.interpolateHelper(value.toString(), priorVariables));
                priorVariables.remove(priorVariables.size() - 1);
            } else if (this.defaults != null && this.defaults.getString(variable, null) != null) {
                result.append(this.defaults.getString(variable));
            } else {
                result.append(START_TOKEN).append(variable).append(END_TOKEN);
            }
            prec = end;
        }
        result.append(base.substring(prec + END_TOKEN.length(), base.length()));
        return result.toString();
    }

    protected List processString(String token) {
        ArrayList<String> retList = new ArrayList<String>(2);
        if (token.indexOf(",") > 0) {
            PropertiesTokenizer tokenizer = new PropertiesTokenizer(token);
            while (tokenizer.hasMoreTokens()) {
                String value = tokenizer.nextToken();
                retList.add(value);
            }
        } else {
            retList.add(token);
        }
        return retList;
    }

    protected final Boolean testBoolean(String value) {
        String s = value.toLowerCase();
        if (s.equals("true") || s.equals("on") || s.equals("yes")) {
            return Boolean.TRUE;
        }
        if (s.equals("false") || s.equals("off") || s.equals("no")) {
            return Boolean.FALSE;
        }
        return null;
    }

    @Override
    public Configuration subset(String prefix) {
        BaseConfiguration c = new BaseConfiguration();
        Iterator keys = this.getKeys();
        boolean validSubset = false;
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            if (!validSubset) {
                validSubset = true;
            }
            String newKey = null;
            newKey = ((String)key).length() == prefix.length() ? prefix : ((String)key).substring(prefix.length() + 1);
            Object value = this.getProperty((String)key);
            if (value instanceof String) {
                c.addPropertyDirect(newKey, this.interpolate((String)value));
                continue;
            }
            c.addProperty(newKey, value);
        }
        if (validSubset) {
            return c;
        }
        return null;
    }

    @Override
    public abstract boolean isEmpty();

    @Override
    public abstract boolean containsKey(String var1);

    @Override
    public void setProperty(String key, Object value) {
        this.clearProperty(key);
        this.addProperty(key, value);
    }

    @Override
    public abstract void clearProperty(String var1);

    @Override
    public abstract Iterator getKeys();

    @Override
    public Iterator getKeys(String prefix) {
        Iterator keys = this.getKeys();
        ArrayList matchingKeys = new ArrayList();
        while (keys.hasNext()) {
            Object key = keys.next();
            if (!(key instanceof String) || !((String)key).startsWith(prefix)) continue;
            matchingKeys.add(key);
        }
        return matchingKeys.iterator();
    }

    @Override
    public Properties getProperties(String key) {
        return this.getProperties(key, null);
    }

    public Properties getProperties(String key, Properties defaults) {
        String[] tokens = this.getStringArray(key);
        Properties props = defaults == null ? new Properties() : new Properties(defaults);
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            int equalSign = token.indexOf(61);
            if (equalSign <= 0) {
                if (tokens.length == 1 && "".equals(token)) break;
                throw new IllegalArgumentException('\'' + token + "' does not contain an equals sign");
            }
            String pkey = token.substring(0, equalSign).trim();
            String pvalue = token.substring(equalSign + 1).trim();
            props.put(pkey, pvalue);
        }
        return props;
    }

    @Override
    public Object getProperty(String key) {
        Object o = this.getPropertyDirect(key);
        if (o == null && this.defaults != null) {
            o = this.defaults.getProperty(key);
        }
        if (o instanceof Container) {
            o = ((Container)o).asVector();
        }
        return o;
    }

    @Override
    public boolean getBoolean(String key) {
        Boolean b = this.getBoolean(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public boolean getBoolean(String key, boolean defaultValue) {
        return this.getBoolean(key, new Boolean(defaultValue));
    }

    @Override
    public Boolean getBoolean(String key, Boolean defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof String) {
            return this.testBoolean((String)value);
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getBoolean(key, defaultValue);
            }
            log.warn((Object)("Use Boolean default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Boolean object");
    }

    @Override
    public byte getByte(String key) {
        Byte b = this.getByte(key, null);
        if (b != null) {
            return b;
        }
        throw new NoSuchElementException('\'' + key + " doesn't map to an existing object");
    }

    @Override
    public byte getByte(String key, byte defaultValue) {
        return this.getByte(key, new Byte(defaultValue));
    }

    @Override
    public Byte getByte(String key, Byte defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof String) {
            Byte b = new Byte((String)value);
            return b;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getByte(key, defaultValue);
            }
            log.warn((Object)("Use Byte default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Byte object");
    }

    @Override
    public double getDouble(String key) {
        Double d = this.getDouble(key, null);
        if (d != null) {
            return d;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public double getDouble(String key, double defaultValue) {
        return this.getDouble(key, new Double(defaultValue));
    }

    @Override
    public Double getDouble(String key, Double defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof String) {
            Double d = new Double((String)value);
            return d;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getDouble(key, defaultValue);
            }
            log.warn((Object)("Use Double default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Double object");
    }

    @Override
    public float getFloat(String key) {
        Float f = this.getFloat(key, null);
        if (f != null) {
            return f.floatValue();
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public float getFloat(String key, float defaultValue) {
        return this.getFloat(key, new Float(defaultValue)).floatValue();
    }

    @Override
    public Float getFloat(String key, Float defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Float) {
            return (Float)value;
        }
        if (value instanceof String) {
            Float f = new Float((String)value);
            return f;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getFloat(key, defaultValue);
            }
            log.warn((Object)("Use Float default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Float object");
    }

    @Override
    public int getInt(String key) {
        Integer i = this.getInteger(key, null);
        if (i != null) {
            return i;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public int getInt(String key, int defaultValue) {
        Integer i = this.getInteger(key, null);
        if (i == null) {
            return defaultValue;
        }
        return i;
    }

    @Override
    public Integer getInteger(String key, Integer defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            Integer i = new Integer((String)value);
            return i;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getInteger(key, defaultValue);
            }
            log.warn((Object)("Use Integer default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Integer object");
    }

    @Override
    public long getLong(String key) {
        Long l = this.getLong(key, null);
        if (l != null) {
            return l;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public long getLong(String key, long defaultValue) {
        return this.getLong(key, new Long(defaultValue));
    }

    @Override
    public Long getLong(String key, Long defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof String) {
            Long l = new Long((String)value);
            return l;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getLong(key, defaultValue);
            }
            log.warn((Object)("Use Long default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Long object");
    }

    @Override
    public short getShort(String key) {
        Short s = this.getShort(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public short getShort(String key, short defaultValue) {
        return this.getShort(key, new Short(defaultValue));
    }

    @Override
    public Short getShort(String key, Short defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof String) {
            Short s = new Short((String)value);
            return s;
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.defaults.getShort(key, defaultValue);
            }
            log.warn((Object)("Use Short default value for key '" + key + "' (" + defaultValue + ")"));
            return defaultValue;
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a Short object");
    }

    @Override
    public String getString(String key) {
        String s = this.getString(key, null);
        if (s != null) {
            return s;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public String getString(String key, String defaultValue) {
        Object value = this.resolveContainerStore(key);
        if (value instanceof String) {
            return this.interpolate((String)value);
        }
        if (value == null) {
            if (this.defaults != null) {
                return this.interpolate(this.defaults.getString(key, defaultValue));
            }
            log.warn((Object)("Use String default value for key '" + key + "' (" + defaultValue + ")"));
            return this.interpolate(defaultValue);
        }
        throw new ClassCastException('\'' + key + "' doesn't map to a String object");
    }

    @Override
    public String[] getStringArray(String key) {
        String[] tokens;
        Object value = this.getPropertyDirect(key);
        if (value instanceof String) {
            tokens = new String[]{this.interpolate((String)value)};
        } else if (value instanceof Container) {
            tokens = new String[((Container)value).size()];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = this.interpolate((String)((Container)value).get(i));
            }
        } else if (value == null) {
            tokens = this.defaults != null ? this.defaults.getStringArray(key) : new String[]{};
        } else {
            throw new ClassCastException('\'' + key + "' doesn't map to a String/Vector object");
        }
        return tokens;
    }

    @Override
    public Vector getVector(String key) {
        Vector v = this.getVector(key, null);
        if (v != null) {
            return v;
        }
        throw new NoSuchElementException('\'' + key + "' doesn't map to an existing object");
    }

    @Override
    public Vector getVector(String key, Vector defaultValue) {
        Object value = this.getPropertyDirect(key);
        Vector v = null;
        if (value instanceof String) {
            v = new Vector(1);
            v.addElement(value);
        } else if (value instanceof Container) {
            v = ((Container)value).asVector();
        } else if (value == null) {
            v = this.defaults != null ? this.defaults.getVector(key, defaultValue) : (defaultValue == null ? new Vector() : defaultValue);
        } else {
            throw new ClassCastException('\'' + key + "' doesn't map to a Vector object: " + value + ", a " + value.getClass().getName());
        }
        return v;
    }

    private Object resolveContainerStore(String key) {
        Object value = this.getPropertyDirect(key);
        if (value != null && value instanceof Container) {
            value = ((Container)value).get(0);
        }
        return value;
    }

    static class Container {
        private List l = new Vector(2);

        public void add(Object o) {
            this.l.add(o);
        }

        public int size() {
            return this.l.size();
        }

        public Object get(int index) {
            return this.l.get(index);
        }

        public Iterator iterator() {
            return this.l.iterator();
        }

        public Vector asVector() {
            Vector v = new Vector(this.l.size());
            Iterator it = this.l.iterator();
            while (it.hasNext()) {
                v.add(it.next());
            }
            return v;
        }
    }

    class PropertiesTokenizer
    extends StringTokenizer {
        static final String DELIMITER = ",";

        public PropertiesTokenizer(String string) {
            super(string, DELIMITER);
        }

        @Override
        public boolean hasMoreTokens() {
            return super.hasMoreTokens();
        }

        @Override
        public String nextToken() {
            StringBuffer buffer = new StringBuffer();
            while (this.hasMoreTokens()) {
                String token = super.nextToken();
                if (token.endsWith("\\")) {
                    buffer.append(token.substring(0, token.length() - 1));
                    buffer.append(DELIMITER);
                    continue;
                }
                buffer.append(token);
                break;
            }
            return buffer.toString().trim();
        }
    }
}

