/*
 * AbstractDao.java
 *
 * Created on 2006725, 4:32
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.dao;

import java.io.StringReader;
import java.sql.*;
import java.util.*;

import tot.bean.DataBean;
import tot.bean.DataField;
import tot.db.*;
import tot.util.*;
import tot.exception.*;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author totcms
 */
public class AbstractDao {
    private static Log log = LogFactory.getLog(AbstractDao.class);
    /**
     * Creates a new instance of AbstractDao
     */
    public AbstractDao() {
    }
    /** fine by primary key
     * @param keyid ID
     * @param table 
     * @return boolean ֵ,bool(/)
     */
    public boolean findByPrimaryKey(int keyid,String table){
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        boolean retVal=false;
        try{
            conn = DBUtils.getConnection();            
            StringBuffer sql = new StringBuffer(512);
            sql.append("SELECT "+keyid);
            sql.append(" FROM " + table);
            sql.append(" WHERE "+keyid+" = ?");
            ps=conn.prepareStatement(sql.toString());
            ps.setInt(1,keyid);
            rs = ps.executeQuery();
            if(rs.next()) {
                retVal=true;
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);            
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return retVal;
    }
    /** get data by sql
     * @param sqlStr  ѯݿSQL.
     * @param fieldArr ҪصֶΣֶԶŷָ.
     * @return Collection
     */
    public Collection getData(String sqlStr,String fieldArr){
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        Collection returnList = new ArrayList();
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery(sqlStr);
            DataField df;
            String[] splitStr=null;
            splitStr=fieldArr.split(",");
            while(rs.next()) {
                df=new DataField();
                for(int i=0;i<splitStr.length;i++){
                    df.setField(splitStr[i], rs.getString(i+1),0);
                }
                returnList.add(df);
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:"+sqlStr,e);
        } finally{
            DBUtils.closeResultSet(rs);
            //DBUtils.resetStatement(stmt);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return returnList;
    }
    /**
     * ʾҳ
     * @param sqlStr ݿѯSQL.
     * @param fieldArr Ҫصֶ.
     * @param rowsNum ÿҳʾ.
     * @param offset ǰλ.
     * @return Collection.
     */
    public Collection getDataList_mysqlLimit(String sqlStr,String fieldArr,int rowsNum, int offset){
        StringBuffer sb=new StringBuffer(512);
        sb.append(sqlStr);
        sb.append(" limit "+offset+","+rowsNum);
        return this.getData(sb.toString(),fieldArr);
    }
    public Collection getDataList_Limit_Normal(String sqlStr,String fieldArr,int rowsNum,int offset){
        Connection conn = null;
        PreparedStatement ps = null;
        ResultSet rs = null;
        Collection returnList = new ArrayList();
        try{
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sqlStr, ResultSet.TYPE_SCROLL_INSENSITIVE, ResultSet.CONCUR_READ_ONLY);
            ps.setMaxRows(offset+rowsNum);
            try {
                ps.setFetchSize(rowsNum);
            } catch (SQLException sqle) {
                //do nothing, postgreSQL doesnt support this method
            }
            rs=ps.executeQuery();
            boolean loop = rs.absolute(offset + 1);
            DataField df;
            String[] splitStr=null;
            splitStr=fieldArr.split(",");
            while(loop) {
                df=new DataField();
                for(int i=0;i<splitStr.length;i++){
                    df.setField(splitStr[i], rs.getString(i+1),0);
                }
                returnList.add(df);
                if (returnList.size() >= rowsNum) break;// Fix the Sybase bug
                loop = rs.next();
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:"+sqlStr,e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.resetStatement(ps);
            DBUtils.closeStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnList;
    }
    /**
     * SQLѯõһ¼
     * @param sqlStr SQLѯ
     * @param fieldArr Ҫصֶ
     * @return DataFild.
     */
    public DataField getFirstData(String sqlStr,String fieldArr){
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        DataField df=null;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            rs=stmt.executeQuery(sqlStr);
            String[] splitStr=null;
            splitStr=fieldArr.split(",");
            if(rs.next()) {
                df=new DataField();
                for(int i=0;i<splitStr.length;i++){
                    df.setField(splitStr[i], rs.getString(i+1),0);
                }
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            //DBUtils.resetStatement(stmt);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return df;
    }
    /**
     * ȡ¼.
     * @param sqlStr SQLѯ.
     * @return int.
     */
    public int getDataCount(String sqlStr){
        Connection conn = null;
        Statement stmt=null;
        ResultSet rs = null;
        int returnInt=0;
        try{
            conn = DBUtils.getConnection();
            ResultSet resultSet = null;
            stmt = conn.createStatement();
            rs=stmt.executeQuery(sqlStr);
            if(rs.next()) {
                returnInt=rs.getInt(1);
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closeResultSet(rs);
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return returnInt;
    }
    
    /**
     * ִи²
     * @param sqlStr ִиµSQL
     * @return boolean
     */
    public boolean exe(String sqlStr) throws ObjectNotFoundException,DatabaseException{
        Connection conn = null;
        Statement stmt=null;
        boolean returnValue=true;
        try{
            conn = DBUtils.getConnection();
            stmt = conn.createStatement();
            if (stmt.executeUpdate(sqlStr) != 1) {
                returnValue=false;
            } else{
                returnValue=true;
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
            throw new DatabaseException("Got Exception on Call Medthod exe in tot.dao.AbstractDao");
        } finally{
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /**
     * ִи²-(Ҫϸʹ)
     * @param sqlStr ִиµSQL
     * @return boolean
     */
    public boolean exeTransaction(String sqlStr) throws ObjectNotFoundException,DatabaseException{
        Connection conn = null;
        Statement stmt=null;
        boolean returnValue=true;
        try{
            conn = DBUtils.getConnection();
            conn.setAutoCommit(false);
            stmt = conn.createStatement();
            if (stmt.executeUpdate(sqlStr) != 1) {
                returnValue=false;
            } else{
                returnValue=true;
            }
            conn.commit();
        } catch(SQLException e){
            if(conn!=null){
               try {
                   conn.rollback();
               } catch (SQLException e1) {
                   e1.printStackTrace();
               }
           }
            log.error("Sql Exception Error:",e);
            throw new DatabaseException("Got Exception on Call Medthod exeTransaction in tot.dao.AbstractDao");
        } finally{
            if(conn!=null){
               try {
                   conn.rollback();
               } catch (SQLException e1) {
                   e1.printStackTrace();
               }
           }
            DBUtils.closeStatement(stmt);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /**
     * ִв
     * @param sqlStr ִеSQL
     * @param fieldvalue ֶεڵֵ
     */
    public void bat(String sqlStr,String[] fieldvalue){
        Connection conn = null;
        PreparedStatement ps = null;
        int returnInt=0;
        try{
            conn = DBUtils.getConnection();
            ps=conn.prepareStatement(sqlStr);
            for(int i=0;i<fieldvalue.length;i++){
                int f=Integer.parseInt(fieldvalue[i]);
                ps.setInt(1,f);
                ps.executeUpdate();
            }
        } catch(SQLException e){
            log.error("Sql Exception Error:",e);
        } finally{
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
    }
}
