/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package tot.dao.jdbc;

import tot.dao.AbstractDao;
import tot.dao.DaoFactory;
import tot.db.DBUtils;
import tot.util.StringUtils;
import tot.bean.*;
import tot.exception.ObjectNotFoundException;
import tot.exception.DatabaseException;
import java.sql.*;
import java.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 *
 * @author Administrator
 */
public class SearchDaoImplJDBC extends AbstractDao {

    private static Log log = LogFactory.getLog(SearchDaoImplJDBC.class);

    /**
     * Creates a new instance of EduVersionDaoImplJDBC
     */
    public SearchDaoImplJDBC() {
    }

    /** add Keywords */
    public boolean add(String id, String title, String demons, String linkurl,String author) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "insert into tot_search(keyid,title,demons,linkurl,author) values(?,?,?,?,?)";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, id);
            ps.setString(2, title);
            ps.setString(3, demons);
            ps.setString(4, linkurl);
            ps.setString(5, author);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        } catch (SQLException e) {
            log.error("add error", e);
        } finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }
    /*
     * mod Keywords
     */

    public boolean mod(int id, String title, String demons, String linkurl) {
        Connection conn = null;
        PreparedStatement ps = null;
        boolean returnValue = true;
        String sql = "update tot_search set title=?,demons=?,linkurl=? where id=?";
        try {
            conn = DBUtils.getConnection();
            ps = conn.prepareStatement(sql);
            ps.setString(1, title);
            ps.setString(2, demons);
            ps.setString(3, linkurl);
            ps.setInt(4, id);
            if (ps.executeUpdate() != 1) {
                returnValue = false;
            }
        } catch (SQLException e) {
            log.error("mod  error", e);
        } finally {
            DBUtils.closePrepareStatement(ps);
            DBUtils.closeConnection(conn);
        }
        return returnValue;
    }

    public Collection getList(int id,  int currentpage, int pagesize) {
        String fields="id,tbname,title,demons,linkurl";
        StringBuffer sql = new StringBuffer(512);
        sql.append("SELECT "+fields+" from tot_search where 1=1");
        if (id > 0) {
            sql.append(" and id=" + id);
        }
        sql.append(" order by id desc");
        //System.out.println(sql.toString());
        return getDataList_mysqlLimit(sql.toString(),fields, pagesize, (currentpage - 1) * pagesize);
    }

    public DataField get(int id) {
        String fields = "tbname,title,demons,linkurl";
        return getFirstData("select " + fields + " from tot_search where id=" + id, fields);
    }    
    public int getTotalCount(int id) {
        StringBuffer sql = new StringBuffer(512);
        sql.append("SELECT  count(*) FROM tot_search where 1=1");
        if (id > 0) {
                sql.append(" and id=" + id);
            }
        return (this.getDataCount(sql.toString()));
    }

    public void batDel(String[] s) {
        this.bat("delete from tot_search where id=?", s);
    }
    
    public boolean del(int id) throws ObjectNotFoundException, DatabaseException {
        return exe("delete from tot_search where id=" + id);
    }
    
    public boolean del() throws ObjectNotFoundException, DatabaseException {
        return exe("delete from tot_search");
    }

}
