/*
 * Sysconfig.java
 *
 * Created on 2006��7��25��, ����11:25
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.global;
import java.io.File;
import tot.xml.DOM4JConfiguration;
import tot.util.FileUtil;
import java.net.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Sysconfig {

    private static Log log = LogFactory.getLog(Sysconfig.class);

    final static String OPTION_FILE_NAME = "search-config.xml";
    /*<global_options> */
    private static String totcms_version="TotSearch 2.0";
    public static String getTotCmsVersion() {
        return totcms_version;
    }
    /* <Database Options> */
    private static boolean useDataSource = false;
    public static boolean isUseDataSource() {
        return useDataSource;
    }

    private static String dataSourceName = "";
    public static String getDataSourceName() {
        return dataSourceName;
    }

    // MUST NOT refer to DBUtils, or we will get an infinite recurse ???
    private static int databaseType = 0;//DATABASE_UNKNOWN
    public static int getDatabaseType() {
        return databaseType;
    }

    private static String driverClassName = "org.gjt.mm.mysql.Driver";
    public static String getDriverClassName() {
        return driverClassName;
    }

    private static String databaseURL = "jdbc:mysql://127.0.0.1/totcms?useUnicode=true&characterEncoding=utf-8";
    public static String getDatabaseURL() {
        return databaseURL;
    }

    private static String databaseUser = "root";
    public static String getDatabaseUser() {
        return databaseUser;
    }

    private static String databasePassword = "";
    public static String getDatabasePassword() {
        return databasePassword;
    }

    private static int maxConnection = 20;
    public static int getMaxConnection() {
        return maxConnection;
    }

    /* by default, the unit of time is milisecond */
    private static int maxTimeToWait = 2000;// 2 seconds
    public static int getMaxTimeToWait() {
        return maxTimeToWait;
    }

    private static int minutesBetweenRefresh = 30;// 30 minutes
    public static int getMinutesBetweenRefresh() {
        return minutesBetweenRefresh;
    }
    /* </Database Options> */
    
    /* search index options */
    private static String indexdir="";
    public static String getIndexDir(){
        return indexdir;
    }
    private static String luceneAnalyzerClassName    = "org.apache.lucene.analysis.standard.StandardAnalyzer";
    public static String getLuceneAnalyzerClassName(){
        return luceneAnalyzerClassName;
    }
    /* the unit of the server offset is hour*/
    private static int serverHourOffset = 0; /* GMT timezone */
    public static int getServerHourOffset() {
        return serverHourOffset;
    }    
    /* <IP Options>*/
    private static String blockedIPs = "";
    public static String getBlockedIPs() {
        return blockedIPs;
    }
    /* account set*/
    private static String username = "";
    public static String getUserName() {
        return username;
    }
    private static String password = "";
    public static String getPassword() {
        return password;
    }
    static {
        load();
    }

    public static void load() {
        reload();
    }   
    public static void reload() {
        String classPath = FileUtil.getServletClassesPath();        
        String configFilename = classPath + OPTION_FILE_NAME;        
        try {
            DOM4JConfiguration conf = new DOM4JConfiguration(new File(configFilename));
            totcms_version=conf.getString("global_options.totsearch_version");
            /* <Database Options> */
            useDataSource = conf.getBoolean("dboptions.use_datasource", false);
            databaseType = conf.getInt("dboptions.database_type", 0);           
            if (useDataSource) {
                dataSourceName = conf.getString("dboptions.datasource_name");
            } else {
                driverClassName = conf.getString("dboptions.driver_class_name", driverClassName);
                databaseURL = conf.getString("dboptions.database_url", databaseURL);
                databaseUser = conf.getString("dboptions.database_user", databaseUser);
                databasePassword = conf.getString("dboptions.database_password",databasePassword);
                maxConnection = conf.getInt("dboptions.max_connection", maxConnection);
                maxTimeToWait = conf.getInt("dboptions.max_time_to_wait", maxTimeToWait);
                minutesBetweenRefresh = conf.getInt("dboptions.minutes_between_refresh", minutesBetweenRefresh);
                if (minutesBetweenRefresh < 1) {
                    minutesBetweenRefresh = 1; //min is 1 minute
                }                
            }
            /* <Database Options> */      
            
            /* search index*/
            indexdir=conf.getString("searchindex.indexdir", indexdir);
            luceneAnalyzerClassName    = conf.getString("searchindex.lucene_analyzer_implementation", luceneAnalyzerClassName);
            /* <Date Time Options> */
            serverHourOffset = conf.getInt("dateoptions.server_hour_offset", serverHourOffset);
            if ((serverHourOffset < -13) || (serverHourOffset > 13)) {
                serverHourOffset = 0;
            }
            /* </Date Time Options> */           
            /* <IP Options>*/
            blockedIPs = conf.getString("ipoptions.blocked_ip", blockedIPs);
            /* account */
            username = conf.getString("account.username", username);
            password = conf.getString("account.password", password);
        } catch (Exception e) {
            String message = "global.Sysconfig: Can't read the configuration file: '" + configFilename + "'. Make sure the file is in your CLASSPATH";
            log.error(message, e);
        }
    }
}