/*
 * AddUpdateIndexTask.java
 *
 * Created on 2006126, 5:21
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.search;
import java.util.TimerTask;

import tot.bean.DataField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class AddUpdateIndexTask extends TimerTask
{
    private static Log log = LogFactory.getLog(AddUpdateIndexTask.class);

    //Constants used for operations
    public static final int OPERATION_ADD    = 0;
    public static final int OPERATION_UPDATE = 1;

    private DataField df;
    private int operation;

    /*
     * Contructor with default access, prevent new an instance from outside package
     */
     AddUpdateIndexTask(DataField article, int operation) {
        this.df = article;
        this.operation = operation;
    }

    public void run() {
        log.debug("AddUpdateIndexTask.run : op = " + operation + " for article = " + df.getFieldValue("id"));
        try {
            switch (operation) {
                case OPERATION_UPDATE:
                    ArticleIndex.deleteFromIndex(df.getFieldValue("id"));
                    // fall through
                case OPERATION_ADD:
                    ArticleIndex.addToIndex(df);
                    break;
                default:
                    log.warn("Cannot process the AddUpdateIndexTask with operation = " + operation);
            }
        } catch (Exception ex) {
            log.error("Error while performing index operation", ex);
        }
    }
}