/*
 * ArticleIndex.java
 *
 * Created on 2006??12??6??, ????5:09
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */

package tot.search;
import tot.global.Sysconfig;
import tot.bean.DataField;
import tot.dao.DaoFactory;
import tot.dao.jdbc.SearchDaoImplJDBC;
import tot.util.*;
import tot.exception.SearchException;
import java.io.IOException;
import java.sql.Timestamp;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig.OpenMode;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;

/**
 *
 * @author Administrator
 */
public class ArticleIndex {
    private static Log log = LogFactory.getLog(ArticleIndex.class);
    /** Creates a new instance of ArticleIndex */
    private static Analyzer analyzer;
    private static String searchArticleIndexDir;
    private static long lastOptimizeTime = 0;
    static {
        searchArticleIndexDir = Sysconfig.getIndexDir();
        initializeAnalyzer();
    }
    public static void scheduleAddTask(DataField df) {
        AddUpdateIndexTask task =new AddUpdateIndexTask(df,AddUpdateIndexTask.OPERATION_ADD);
        TimerUtil.getInstance().schedule(task, 0);
    }

    public static void scheduleUpdateTask(DataField df) {
        AddUpdateIndexTask task = new AddUpdateIndexTask(df, AddUpdateIndexTask.OPERATION_UPDATE);
        TimerUtil.getInstance().schedule(task, 0);
    }
    public static void scheduleDeleteTask(String objectID) {
        DeleteIndexTask task = new DeleteIndexTask(objectID);
        TimerUtil.getInstance().schedule(task, 0);
    }
    public static void scheduleRebuildIndexTask(String sql,String fields) {
        RebuildIndexTask task = new RebuildIndexTask(sql,fields);
        TimerUtil.getInstance().schedule(task, 0);
    }
    public static void scheduleCreateEmptyIndexTask() {
        int maxPostID = 0;
        CreateEmptyIndexTask task = new CreateEmptyIndexTask(maxPostID);
        TimerUtil.getInstance().schedule(task, 0);
    }
    static Analyzer getAnalyzer() {
        return analyzer;
    }

    /**
     * This class will load analyzer when starting. If specified analyzer class
     * cannot be loaded then default analyzer will be used.
     */
    private static void initializeAnalyzer() {
        String analyzerClassName = Sysconfig.getLuceneAnalyzerClassName();
        analyzer = new SmartChineseAnalyzer(Version.LUCENE_47);
            log.debug("Using StandardAnalyzer for indexing");
    }

    /**
     * This method is used for getting new IndexWriter. It can create new index
     * or add df to existing index. Creating new index will delete previous so it
     * should be used for rebuilding index.
     * @param create - true if new index should be created.
     *               - false for adding dfs to existing index
     * @return IndexWriter object that is used for adding dfs to index
     */
    public static IndexWriter getIndexWriter(Directory directory, boolean create) {
        IndexWriter writer = null;
        //If create = false, we will create IndexWriter with false argument
        IndexWriterConfig iwc = new IndexWriterConfig(Version.LUCENE_47, analyzer);

        if (create) {
          // Create a new index in the directory, removing any
          // previously indexed documents:
          iwc.setOpenMode(OpenMode.CREATE);
        } else {
          // Add new documents to an existing index:
          iwc.setOpenMode(OpenMode.CREATE_OR_APPEND);
        }
        try {
            writer = new IndexWriter(directory, iwc);
        } catch (IOException e) {
            log.warn("Cannot open existed index. New index will be created.", e);
            //Ignore Exception. We will try to create index with true parameter
        }
        return writer;
    }

    /**
     * This method is used for adding single df to index
     * Note: this method doesnt close the writer
     * @param df A df that should be indexed
     * @param writer IndexWriter that is used for storing
     * @throws SearchException
     */
    public static void doIndex(DataField df, IndexWriter writer,String table) throws SearchException {
        //System.out.println("");
        if (df == null) return;
        //ֶб
        //id,classid,newspath,filename,title,newstime,region,smalltext,b2b
        String id=df.getFieldValue("id");
        String classid=df.getFieldValue("classid");
        String title=df.getFieldValue("title");
        String datetime=df.getFieldValue("newstime");
        String linkurl=df.getFieldValue("linkurl");
        String content=df.getFieldValue("content");
        String demons=df.getFieldValue("demons");
        String author=df.getFieldValue("author");
        // must include topic and body. If not then we have nothing to index.
        if ( (title == null || title.equals("")) ||
                (content == null || content.equals(""))) {
            return;
        }
        if(demons==null || demons.equals("")){
          demons=StringUtils.removeHtml(content);
        }
        if(demons.length()>100){
                demons=demons.substring(0,100);
        }
        //Each df will be represented as a document
        Document dfDocument = new Document();
        //Document has following fields that could be queried on
        DaoFactory.getArticleDAO().add(table+"_"+id,title,demons,linkurl,author);
        dfDocument.add(new LongField("id", Long.parseLong(id),Field.Store.YES));
        dfDocument.add(new StringField("Table", table,Field.Store.YES));
        dfDocument.add(new StringField("CategoryId", classid,Field.Store.YES));
        dfDocument.add(new TextField("Title", title,Field.Store.NO));
        dfDocument.add(new TextField("Content", content,Field.Store.NO));    
        dfDocument.add(new LongField("ModiTime", Timestamp.valueOf(datetime).getTime(),Field.Store.YES));        
        //now we have created document with fields so we can store it
        try {
            writer.addDocument(dfDocument);
        } catch (IOException e) {
            log.error("ArticleIndexer.doIndex failed", e);
            //@todo : localize me
            //throw new SearchException("Error writing new df to index");
        }
    }

    public static void optimizeIndex() throws SearchException, IOException {
         Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = getIndexWriter(directory,false);
            if (writer == null) {
                log.warn("Cannot get the IndexWriter");
                return;
            }
            log.debug("writer.optimize() called in addToIndex");
            
        } catch (Exception ex) {

        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    log.debug("Error closing Lucene IndexWriter", e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                } catch (IOException e) {
                    log.debug("Cannot close directory.", e);
                }
            }
        }
    }
    /**
     * Add single df to index
     * @param df
     * @throws SearchException
     */
    static void addToIndex(DataField df) throws SearchException, IOException {
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = getIndexWriter(directory,false);
            if (writer == null) {
                log.warn("Cannot get the IndexWriter");
                return;
            }
            doIndex(df, writer,"");            
        } catch (SearchException ex) {
            throw ex;
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    log.debug("Error closing Lucene IndexWriter", e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                } catch (IOException e) {
                    log.debug("Cannot close directory.", e);
                }
            }
        }
    }

    /**
     * This method is used for deleting df from index.
     * @param dfID id of the df that should be deleted
     * @throws SearchException
     */
    static void deleteFromIndex(String dfID) throws SearchException,IOException {
      Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = getIndexWriter(directory,false);
            if (writer == null) {
                log.warn("Cannot get the IndexWriter");
                return;
            }
            Term term = new Term("id", dfID);
            writer.deleteDocuments(term);
        } catch (Exception ex) {
            log.error("Error while performing index delete operation by id:"+dfID, ex);
        } finally {
            if (writer != null) {
                try {
                    writer.close();
                } catch (IOException e) {
                    log.debug("Error closing Lucene IndexWriter", e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                } catch (IOException e) {
                    log.debug("Cannot close directory.", e);
                }
            }
        }
    }

    public static int getNumDocs() {
        int numDocs = -1;
        Directory directory = null;
        IndexReader reader = null;
        try {
            directory = SearchService.getSearchIndexDir();
            reader = DirectoryReader.open(directory);
            if (reader == null) {
                log.warn("Cannot get the IndexReader");
                return -1;
            }
            numDocs = reader.numDocs();
        } catch ( IOException ioe) {
            //ignore
        } finally {
            if (reader != null) {
                try {
                    reader.close();
                } catch (IOException e) {
                    log.debug("Error closing Lucene IndexReader", e);
                }
            }
            if (directory != null) {
                try {
                    directory.close();
                } catch (IOException e) {
                    log.debug("Cannot close directory.", e);
                }
            }
        }
        return numDocs;
    }

}
