/*
 * RebuildArticleIndexTask.java
 *
 * Created on 2006��12��7��, ����12:06
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */
package tot.search;

import java.io.IOException;
import java.util.*;
import tot.dao.DaoFactory;
import tot.bean.DataField;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;

/**
 *
 * @author Administrator
 */
public class CreateEmptyIndexTask extends TimerTask {

    /** Creates a new instance of RebuildArticleIndexTask */
    private static Log log = LogFactory.getLog(CreateEmptyIndexTask.class);
    public static final int Articles_PER_FETCH = 200;
    public static final int MERGE_FACTOR = 20;
    private int maxArticleID = 0;
    private static boolean isRebuilding = false;

    public static boolean isRebuilding() {
        return isRebuilding;
    }

    /*
     * Contructor with default access, prevent new an instance from outside package
     */
    CreateEmptyIndexTask(int maxArticleID) {
        this.maxArticleID = maxArticleID;
    }

    /**
     * Create new index. If anything exist already - delete it
     */
    public void run() {
        isRebuilding = true;
        long start = System.currentTimeMillis();
        Directory directory = null;
        IndexWriter writer = null;
        try {
            directory = SearchService.getSearchIndexDir();
            writer = ArticleIndex.getIndexWriter(directory, true);            
            log.info("Success create empty index file.");
        } catch (Exception e) {
            log.error("Error while rebuilding index", e);
        } finally {
            try {
                if (writer != null) {
                    writer.close();
                }
                if (directory != null) {
                    directory.close();
                    log.debug("Cannot close directory.");
                }
            } catch (IOException e) {
                log.debug("Close directory case exception:",e);
            }
        }
        log.info("RebuildIndexTask took " + (System.currentTimeMillis() - start) + " ms");
        isRebuilding = false;
    }
}
