/*
 * SearchQuery.java
 *
 * Created on 2006127, 2:28
 *
 * To change this template, choose Tools | Options and locate the template under
 * the Source Creation and Management node. Right-click the template and choose
 * Open. You can then make changes to the template in the Source Editor.
 */
package tot.search;

import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import tot.global.Sysconfig;
import tot.dao.DaoFactory;
import tot.bean.DataField;
import tot.util.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.cn.smart.SmartChineseAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.NumericRangeFilter;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.FieldDoc;
/**
 *
 * @author Administrator
 */
public class SearchQuery {
    private static Log log = LogFactory.getLog(SearchQuery.class);
    // constant for search by time
    public static final int SEARCH_ANY_DATE = 0;
    public static final int SEARCH_NEWER = 1;
    public static final int SEARCH_OLDER = 2;
    // constant for search by the blog title/body
    public static final int SEARCH_ONLY_TITLE = 1;
    public static final int SEARCH_ONLY_BODY = 2;
    // constant for sorting option by time
    public static final int SEARCH_SORT_DEFAULT = 0;
    public static final int SEARCH_SORT_TIME_DESC = 1;
    public static final int SEARCH_SORT_TIME_ASC = 2;
    private String userName = null;
    private int catalogid = -1;
    private int b2b = -1;
    private String table=null;
    private int province = -1;
    private int city = -1;
    private String searchString = null;
    private Timestamp fromDate = null;
    private Timestamp toDate = null;
    private String searchIndexDir = null;
    private int hitCount = 0;
    private Collection searchResult = null;
    // 1|2 = 3;
    private int scopeInArticle = SEARCH_ONLY_TITLE | SEARCH_ONLY_BODY;
    private int sort = SEARCH_SORT_DEFAULT;//sort type 1=by key 2=by id
    private int search_and_or;//0=and,1=or
    /** Creates a new instance of ArticleSearchQuery */
    public SearchQuery() {
        searchIndexDir = Sysconfig.getIndexDir();
    }
    /**
     * Id of forum where post belongs. Set to -1 if all forums should be searched
     * @param catalogid
     */
    public void setCatalogId(int catalogid) {
        this.catalogid = catalogid;
    }
    public void setTable(String t){
      this.table=t;
    }
    public void setSearchAndOr(int sao){
        this.search_and_or=sao;
    }
    /**
     * Set string that should be searched for.
     * @param searchString
     */
    public void setSearchString(String searchString) {
        this.searchString = searchString;
    }

    public void setScopeInArticle(int scopeInArticle) {
        this.scopeInArticle = scopeInArticle;
    }    

    public void setFromDate(Timestamp fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Timestamp toDate) {
        this.toDate = toDate;
    }

    public void setSortType(int stype) {
        this.sort = stype;
    }
    public void searchDocuments(int offset, int rowsToReturn) throws IOException {
        // Now check if at least one of these input is present: key, member, attachment
        if (searchString == null || searchString.equals("")) {
            return;
        }
        //Build the query
        BooleanQuery query = new BooleanQuery();
        try {
            Query topicBodyQuery = getTopicBodyQuery();            
            if (topicBodyQuery != null) {
                query.add(topicBodyQuery, BooleanClause.Occur.MUST);
                log.debug("topicBodyQuery = " + topicBodyQuery);
            }
            Query catalogQuery = getCatalogQuery();
            if (catalogQuery != null) {
                log.debug("categoryForumQuery = " + catalogQuery);
                query.add(catalogQuery, BooleanClause.Occur.MUST);
            }            
            Query tableQuery = getTableQuery();
            if (tableQuery != null) {
                log.debug("tableQuery = " + tableQuery);
                query.add(tableQuery, BooleanClause.Occur.MUST);
            }            
        } catch (Exception pe) {
            log.error("Cannot parse the search query", pe);
        }
        log.debug("booleanQuery = " + query);
        Filter  dateFilter = null;
        //Add date filter if some of dates provided
        if (fromDate != null && toDate != null) {
          dateFilter= NumericRangeFilter.newLongRange("ModiTime", fromDate.getTime(),toDate.getTime(), true, true);
            log.debug("dateFilter = " + fromDate+"~"+toDate);
        }
        //Now search the documents
        Directory directory = null;
        IndexSearcher searcher = null;
        IndexReader reader =null;
        int cachetops=offset + rowsToReturn;
        if(cachetops<=0) cachetops=20;
        try {
            directory = SearchService.getSearchIndexDir();
            reader = DirectoryReader.open(directory);
            searcher = new IndexSearcher(reader);
            TopFieldDocs docs = null;
            docs =searcher.search(query, dateFilter, cachetops, getQuerySort());            
            hitCount = docs.totalHits;
            searchResult=new ArrayList(hitCount);
            ScoreDoc[] scoreDocs = docs.scoreDocs;
            /*get collections */
            String fields="keyid,title,demons,linkurl,author";
            for (int i = offset; (i < offset + rowsToReturn) && (i < hitCount); i++) {              
              Document doc = searcher.doc(scoreDocs[i].doc);
              String id=doc.get("id");
              String tbl=doc.get("Table");              
              String dates=doc.get("ModiTime");            
              DataField df=null;
              String sql="select "+fields+"  from tot_search where keyid='"+tbl+"_"+id+"'";              
              df=DaoFactory.getArticleDAO().getFirstData(sql, fields);
              df.setField("moditime", dates,0);
              df.setField("table", tbl,0);            
              searchResult.add(df);
            }
        } catch (IOException ex) {
            throw ex;
        } finally {
            reader.close();;
        }
    }

    public int getHitCount() {
        return hitCount;
    }

    public Collection getArticleResult() {
        if (searchResult == null) {
            //create an empty list, in case result is null
            searchResult = new ArrayList();
        }
        return searchResult;
    }

    private Query getTopicBodyQuery() throws ParseException{
        if (searchString == null || searchString.equals("")) {
            return null;
        }
        Analyzer analyzer = new SmartChineseAnalyzer(Version.LUCENE_47);
        BooleanQuery topicBodyQuery = new BooleanQuery();
        String fieldname="Title";

        if (scopeInArticle == 1) {
            fieldname="Title";
        } else if (scopeInArticle == 2) {
            fieldname="Content";
        }
        if(scopeInArticle>0){
           return GetParse(fieldname,searchString,analyzer);
        }else{
            topicBodyQuery.add(GetParse("Title",searchString,analyzer), BooleanClause.Occur.SHOULD);
            topicBodyQuery.add(GetParse("Content",searchString,analyzer), BooleanClause.Occur.SHOULD);            
            return topicBodyQuery;
        }
    }

    private Query GetParse(String fieldname,String s,Analyzer analyzer) throws ParseException{
       QueryParser parse=new QueryParser(Version.LUCENE_47,fieldname,analyzer);
       if(search_and_or==1){
           parse.setDefaultOperator(QueryParser.AND_OPERATOR);
       }else{
           parse.setDefaultOperator(QueryParser.OR_OPERATOR);
       }
       return parse.parse(s);
    }

    private Query getCatalogQuery() {
        Query catalogQuery = null;
        if (catalogid > 0) {
            // search in forum
            Term catalogTerm = new Term("CategoryId", String.valueOf(catalogid));
            catalogQuery = new TermQuery(catalogTerm);
        }
        return catalogQuery;
    }

    private Query getTableQuery() {
        Query tableQuery = null;
        if (table!=null) {
            // search in forum
            Term tableTerm = new Term("Table", String.valueOf(table));
            tableQuery = new TermQuery(tableTerm);
        }
        return tableQuery;
    }

    public void setSort(int sort) {
        if ( (sort != SEARCH_SORT_DEFAULT) && (sort != SEARCH_SORT_TIME_ASC) && (sort != SEARCH_SORT_TIME_DESC)) {
            throw new IllegalArgumentException("Does not support sort = " + sort);
        }
        this.sort = sort;
    }
    public int getSort() {
        return sort;
    }
    private Sort getQuerySort() {
        Sort sortObj = null;
        switch (sort) {
            case SEARCH_SORT_TIME_ASC:
                sortObj = new Sort(new SortField("ModiTime", SortField.Type.LONG, false));
                break;
            case SEARCH_SORT_TIME_DESC:
                sortObj = new Sort(new SortField("ModiTime", SortField.Type.LONG, true));
                break;
            default:
                sortObj = new Sort();
                break;
        }
        return sortObj;
    }
}
