/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tot.service;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import javax.servlet.ServletContextEvent;
import tot.db.DBUtils;
import tot.util.TimerUtil;
/**
 *
 * @author Administrator
 */
public class TotCmsServiceImpl {
    private static Log log = LogFactory.getLog(TotCmsServiceImpl.class);
    public void contextInitialized(ServletContextEvent event) {
        log.debug("Begin calling contextInitialized()");
        // call this method will print the database type to logger with level INFO
        DBUtils.getDatabaseType();
    }
    public void contextDestroyed(ServletContextEvent event) {

        // cancel the TimerUtil
        log.debug("About to cancel the TimerUtil");
        TimerUtil.getInstance().cancel();
        
        /*try {
            log.debug("About to shutdown the Whirly CacheManager");
            CacheManager.getInstance().shutdown();
        } catch (CacheException e) {
            // ignore this
        }*/

        // This code will release all connections currently pooled.
        // The next call to #getConnection will recreate the pool.
        log.debug("About to close all connectons from db");
        DBUtils.closeAllConnections();
        
        // Note that we could consider to sleep 5 seconds to make sure all the background tasks is finished

    }
}
