/*
 * FormatUtil.java
 *
 * Created on 2008225, 2:32
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.util;
import java.text.*;
import java.util.*;
import java.math.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class FormatUtil {
    private static Log log = LogFactory.getLog(FormatUtil.class);
    /** Creates a new instance of FormatUtil */
    public FormatUtil() {
    }
    /**
     * ְʽ
     * @param d double
     * @param pattern String
     *       #:ʾ֣ûգλڣλ
     *          򳬳
     *       0:֣ûв0
     *          См0ͱλС
     *       磺 "###.00" -->ʾֵλСλ
     *                          0λ
     *              "###.0#" -->ʾֵԱһλλС
     *                               ʾΪһλСһλλС
     *                               İԭʾλ룻
     *              "###" --->ʾΪС
     *              ".###" -->12.234ʾΪ.234
     *              "#,###.0#" -->ʾÿ3λһ"";
     * @param l Locale
     * @return String
     */
    public static String formatNumber(double d,String pattern,Locale l){
        String s = "";
        try{
            DecimalFormat nf = (DecimalFormat) NumberFormat.getInstance(l);
            nf.applyPattern(pattern);
            s = nf.format(d);
            
        }catch(Exception e){
            e.printStackTrace();
            log.error(" formatNumber is error!");
        }
        return s;
        
    }
    
    /**
     * ȱʡʽ
     * @param d double
     * @param pattern String
     * @return String
     */
    public static String formatNumber(double d,String pattern){
        return formatNumber(d,pattern,Locale.getDefault());
    }
    
    /**
     * ʽ
     * @param d double
     * @param pattern String
     *        "\u00A4#,###.00" :ʾΪ 1234234.10
     * @param l Locale
     * @return String
     */
    public static String formatCurrency(double d,String pattern,Locale l){
        String s = "";
        try{
            DecimalFormat nf = (DecimalFormat) NumberFormat.getCurrencyInstance(l);
            nf.applyPattern(pattern);
            s = nf.format(d);
            
        }catch(Exception e){
            e.printStackTrace();
            log.error(" formatNumber is error!");
        }
        return s;
        
    }
    /**
     * ʹĬָʽʾ
     * @param d double
     * @param pattern String
     * @return String
     */
    public static String formatCurrency(double d,String pattern){
        return formatCurrency(d,pattern,Locale.getDefault());
    }
    
    /**
     * ʹĬϷʽʾң
     *     :12,345.46 Ĭϱ2λС
     * @param d double
     * @return String
     */
    public static String formatCurrency(double d){
        String s = "";
        try{
            DecimalFormat nf = (DecimalFormat) NumberFormat.getCurrencyInstance();
            s = nf.format(d);
            
        }catch(Exception e){
            e.printStackTrace();
            log.error(" formatNumber is error!");
        }
        return s;
        
    }
    
    /**
     * ָʽٷ
     * @param d
     * @param pattern :"##,##.000%"-->Ҫǡ%
     * @param l
     * @return
     */
    public static String formatPercent(double d,String pattern,Locale l){
        String s = "";
        try{
            DecimalFormat df = (DecimalFormat)NumberFormat.getPercentInstance(l);
            df.applyPattern(pattern);
            s = df.format(d);
        }catch(Exception e){
            log.error("formatPercent is error!");
        }
        return s;
    }
    /**
     * ʹĬʽٷ
     * @param d
     * @param pattern
     * @return
     */
    public static String formatPercent(double d,String pattern){
        return formatPercent(d,pattern,Locale.getDefault());
    }
    
    /**
     * ʽٷ
     * @param d
     * @return
     */
    public static String formatPercent(double d){
        String s = "";
        try{
            DecimalFormat df = (DecimalFormat)NumberFormat.getPercentInstance();
            s = df.format(d);
        }catch(Exception e){
            log.error("formatPercent is error!");
        }
        return s;
    }
    
    /**
     * ֵĸʽ,:1,234,567.89
     * @param bd BigDecimal Ҫʽ
     * @param format String ʽ "###,##0"
     * @return String
     */
    public static String numberFormat(BigDecimal bd, String format) {
        
        if (bd == null || "0".equals(bd.toString())) {
            return "";
        }
        
        DecimalFormat bf = new DecimalFormat(format);
        return bf.format(bd);
    }
    
    public static void main(String[] args) {
        String s = formatCurrency(11123.89343,"$##,##.000");
        System.out.println(s);
    }
    
    
}
