/*
 * ImageUtil.java
 *
 * Created on 2007629, 3:15
 *
 * To change this template, choose Tools | Template Manager
 * and open the template in the editor.
 */

package tot.util;
import java.io.*;
import java.net.*;
import java.awt.*;
import java.awt.image.*;
import javax.imageio.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
/**
 *
 * @author Administrator
 */
public class ImageUtil {
    private static Log log = LogFactory.getLog(ImageUtil.class);
    public static int TOP_LEFT=0;
    public static int TOP_CENTER=1;
    public static int TOP_RIGHT=2;
    public static int CENTER=3;
    public static int BOTTOM_LEFT=4;
    public static int BOTTOM_CENTER=5;
    public static int BOTTOM_RIHGHT=6;
    /** Creates a new instance of ImageUtil */
    public ImageUtil() {
    }
    /*
     * ͼƬˮӡ
     * @param source ԴͼƬҪˮӡͼƬ
     * @param fromimage ˮӡͼƬӵԴͼƬ
     * @x  ˮӡx
     * @y  ˮӡy
     */
    public static void waterMarkImage(String source,String fromimage,int pos){
        try{
            File _file = new File(source);
            String filename=_file.getName();
            String format="jpeg";
            if(filename!=null && filename.lastIndexOf(".")>0){
                format=filename.substring(filename.lastIndexOf(".")+1,filename.length());
            }
            Image src = ImageIO.read(_file);
            int wideth = src.getWidth(null);
            int height = src.getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height,BufferedImage.TYPE_INT_RGB);
            Graphics g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            // ˮӡļ
            File watermark = new File(fromimage);
            Image src_mark = ImageIO.read(watermark);
            int wideth_mark = src_mark.getWidth(null);
            int height_mark = src_mark.getHeight(null);
            int pos_x=wideth-wideth_mark;
            int pos_y=height-height_mark;
            //ˮӡλ
            switch(pos){
                case(0):
                    pos_x=0;
                    pos_y=0;
                    break;
                case(1):
                    pos_x=pos_x/2;
                    pos_y=0;
                    break;
                case(2):                    
                    pos_y=0;
                    break;
                case(3):
                    pos_x=pos_x/2;
                    pos_y=pos_y/2;
                    break;                
                case(4):
                    pos_x=0;                    
                    break;
                case(5):
                    pos_x=pos_x/2;                    
                    break;
                case(6):                                
                    break;
            }
            pos_x=pos_x<0?0:pos_x;
            pos_y=pos_y<0?0:pos_y;
            g.drawImage(src_mark,pos_x,pos_y, wideth_mark,height_mark, null);
            // /
            g.dispose();
            FileOutputStream out = new FileOutputStream(source);
            ImageIO.write(image,format,out);
            out.close();
        }catch(Exception e){
            log.error("make waterMarkImage error:"+source,e);
        }
    }
    /*
     * ͼƬˮӡ
     * @param source ԴͼƬҪˮӡͼƬ
     * @param text   ˮӡ
     * @x  ˮӡx
     * @y  ˮӡy
     */
    public static void waterMarkText(String source,String text,String font,int style,Color color,int size,int pos){
        int x=0;
        int y=0;
        try{
            File _file = new File(source);
            String filename=_file.getName();
            String format="jpeg";
            /*if(filename!=null && filename.lastIndexOf(".")>0){
                format=filename.substring(filename.lastIndexOf(".")+1,filename.length());
            }*/
            Image src = ImageIO.read(_file);
            int wideth = src.getWidth(null);
            int height = src.getHeight(null);
            BufferedImage image = new BufferedImage(wideth, height,BufferedImage.TYPE_INT_RGB);
            Graphics g = image.createGraphics();
            g.drawImage(src, 0, 0, wideth, height, null);
            int ch_w=text.length()*size/2;
            //ˮӡλ
            switch(pos){
                case(0):
                    x=5;
                    y=size;
                    break;
                case(1):
                    x=(wideth-ch_w)/2;
                    y=size;
                    break;
                case(2):
                    x=wideth-ch_w<0?0:wideth-ch_w;
                    y=size;
                    break;
                case(3):
                    x=(wideth-ch_w)/2;
                    y=(height-size)/2;
                    break;                
                case(4):
                    x=5;
                    y=height-5;
                    break;
                case(5):
                    x=(wideth-ch_w)/2;
                    y=height-5;
                    break;
                case(6):                    
                    x=wideth-ch_w<0?0:wideth-ch_w;                    
                    y=height-5;                    
                    break;
            }
            x=x<0?0:x;
            y=y<0?0:y;
            //System.out.print("X:"+x+"Y:"+y);
            // ˮӡļ
            g.setColor(color);
            g.setFont(new Font(font, style, size));
            g.drawString(text,x,y);
            g.dispose();
            FileOutputStream out = new FileOutputStream(source);
            ImageIO.write(image,format,out);
            out.close();
        }catch(Exception e){
            log.error("make waterMarkText error:"+source,e);
        }
    }
}
