/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package tot.util;
import java.sql.Timestamp;
import javax.servlet.*;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import tot.service.TotCmsServiceImpl;
/**
 *
 * @author Administrator
 */
public class TotCmsContextListener implements ServletContextListener{
    private static Log log = LogFactory.getLog(TotCmsContextListener.class);
    private static TotCmsContextListener instance;
    private Timestamp startTimestamp;
    public TotCmsContextListener() {
        instance = this;
    }
    /**
     * Notification that the web application is ready to process requests.
     *
     * @param event ServletContextEvent
     */
    public void contextInitialized(ServletContextEvent event) {
        log.debug("contextInitialized");
        // We MUST initialize FileUtil's ServletClassesPath first before call any ServiceFactory
        // because ServiceFactory need the correct servlet path first before it can be initialized
        String realPath = event.getServletContext().getRealPath("/WEB-INF/classes");// Add '/' before WEB-INF to fix the Oracle 10G bug
        FileUtil.setServletClassesPath(realPath);
        TotCmsServiceImpl service=new TotCmsServiceImpl();
        service.contextInitialized(event);
        startTimestamp = DateUtil.getCurrentGMTTimestamp();
    }
    /**
     * Notification that the servlet context is about to be shut down.
     *
     * @param event ServletContextEvent
     */
    public void contextDestroyed(ServletContextEvent event) {
        TotCmsServiceImpl service=new TotCmsServiceImpl();
        service.contextDestroyed(event);
        instance = null;

        try {
            //we will sleep 2 seconds, so the background thread of TimerUtil and WhirlyCache could be destroyed
            log.debug("About to sleep 2 seconds.");
            Thread.sleep(2000); 
        } catch (InterruptedException e) {
            //ignore
        }

        log.debug("contextDestroyed");
        
    }

    // below are add on method

    public static TotCmsContextListener getInstance() {
        return instance;
    }

    public Timestamp getStartTimestamp() {
        return startTimestamp;
    }
}
