package com.shanpayapi.cn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.shanpayapi.cn.exception.PayException;
import com.shanpayapi.cn.util.ShanPayUtil;
/**
 * 
 * Description： 验证订单信息<br>
 * 
 * ClassName：Shanpay <br>
 * 
 * Date：2016年6月25日下午11:37:18 <br>
 * 
 * Version：v1.0 <br>
 * 
 */
public class Shanpay extends HttpServlet {

	/**
	*
	**/
	private static final long serialVersionUID = 1L;

	/**
	 * Constructor of the object.
	 */
	public Shanpay() {
		super();
	}

	/**
	 * Destruction of the servlet. <br>
	 */
	public void destroy() {
		super.destroy(); // Just puts "destroy" string in log
		// Put your code here
	}

	public void doGet(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		doPost(request, response);
	}

	public void doPost(HttpServletRequest request, HttpServletResponse response)
			throws ServletException, IOException {
		request.setCharacterEncoding("UTF-8");
		Map<String,Object> requestParams = getParameter(request);
		String signMd5 = ShanPayUtil.buildRequestParaShan(requestParams, Constant.KEY);
		requestParams.put("sign", signMd5);
		request.setAttribute("data", requestParams);
		request.setAttribute("gateway_new", Constant.GATEWAY_NEW);
		request.getRequestDispatcher("shanpay.jsp").forward(request,response);
	}

	/**
	 * Initialization of the servlet. <br>
	 *
	 * @throws ServletException if an error occurs
	 */
	public void init() throws ServletException {
		// Put your code here
	}

	/**
	 * 
	 * Function：获取request中的订单信息<br>
	 * 
	 * MethodName：getParameter<br>
	 * 
	 * Date：2016年6月26日上午10:30:59<br>
	 * @param request
	 * @throws PayException
	 */
	private Map<String,Object> getParameter(HttpServletRequest request) throws PayException{
		
		/**************************请求参数**************************/
		 //商户订单号
		String out_order_no = request.getParameter("WIDout_trade_no");
		//订单名称
		String subject = request.getParameter("WIDsubject");
		//付款金额
		String total_fee = request.getParameter("WIDtotal_fee");
		//订单描述
		String body = request.getParameter("WIDbody");
		if(out_order_no==null||subject==null||total_fee==null){
			throw new PayException("必要参数不能为空!");
		}
		//服务器异步通知页面路径
		String notify_url = Constant.NOTIFY_URL;
		if("".equals(notify_url)){
			throw new PayException("notify_url不能为空!");
		}
       //需http://格式的完整路径，不能加?id=123这类自定义参数
       //页面跳转同步通知页面路径
		String return_url = Constant.RETURN_URL;
		if("".equals(return_url)){
			throw new PayException("return_url不能为空!");
		}
		if("".equals(Constant.USER_SELLER)){
			throw new PayException("商户号不能为空!");
		}
		Map<String,Object> parameter = new HashMap<String,Object>(); 
		parameter.put("body", body);
		parameter.put("notify_url", Constant.NOTIFY_URL);
		parameter.put("out_order_no", out_order_no);
		parameter.put("partner", Constant.PARTNER);
		parameter.put("return_url", Constant.RETURN_URL);
		parameter.put("subject", subject);
		parameter.put("total_fee", total_fee);
		parameter.put("user_seller", Constant.USER_SELLER);
		return parameter;
	}
}
