/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.dbcp.AbandonedTrace;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.DelegatingResultSet;

public class DelegatingCallableStatement
extends AbandonedTrace
implements CallableStatement {
    protected CallableStatement _stmt = null;
    protected DelegatingConnection _conn = null;

    public DelegatingCallableStatement(DelegatingConnection c, CallableStatement s) {
        super(c);
        this._conn = c;
        this._stmt = s;
    }

    public CallableStatement getDelegate() {
        return this._stmt;
    }

    public boolean equals(Object obj) {
        CallableStatement delegate = this.getInnermostDelegate();
        if (delegate == null) {
            return false;
        }
        if (obj instanceof DelegatingCallableStatement) {
            DelegatingCallableStatement s = (DelegatingCallableStatement)obj;
            return delegate.equals(s.getInnermostDelegate());
        }
        return delegate.equals(obj);
    }

    public int hashCode() {
        CallableStatement obj = this.getInnermostDelegate();
        if (obj == null) {
            return 0;
        }
        return obj.hashCode();
    }

    public CallableStatement getInnermostDelegate() {
        CallableStatement s = this._stmt;
        while (s != null && s instanceof DelegatingPreparedStatement) {
            if (this != (s = ((DelegatingCallableStatement)s).getDelegate())) continue;
            return null;
        }
        return s;
    }

    public void close() throws SQLException {
        List resultSets;
        if (this._conn != null) {
            this._conn.removeTrace(this);
            this._conn = null;
        }
        if ((resultSets = this.getTrace()) != null) {
            ResultSet[] set = new ResultSet[resultSets.size()];
            resultSets.toArray(set);
            int i = 0;
            while (i < set.length) {
                set[i].close();
                ++i;
            }
            this.clearTrace();
        }
        this._stmt.close();
    }

    public Connection getConnection() throws SQLException {
        return this._conn;
    }

    public ResultSet executeQuery() throws SQLException {
        return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery());
    }

    public ResultSet getResultSet() throws SQLException {
        return DelegatingResultSet.wrapResultSet(this, this._stmt.getResultSet());
    }

    public ResultSet executeQuery(String sql) throws SQLException {
        return DelegatingResultSet.wrapResultSet(this, this._stmt.executeQuery(sql));
    }

    public void registerOutParameter(int parameterIndex, int sqlType) throws SQLException {
        this._stmt.registerOutParameter(parameterIndex, sqlType);
    }

    public void registerOutParameter(int parameterIndex, int sqlType, int scale) throws SQLException {
        this._stmt.registerOutParameter(parameterIndex, sqlType, scale);
    }

    public boolean wasNull() throws SQLException {
        return this._stmt.wasNull();
    }

    public String getString(int parameterIndex) throws SQLException {
        return this._stmt.getString(parameterIndex);
    }

    public boolean getBoolean(int parameterIndex) throws SQLException {
        return this._stmt.getBoolean(parameterIndex);
    }

    public byte getByte(int parameterIndex) throws SQLException {
        return this._stmt.getByte(parameterIndex);
    }

    public short getShort(int parameterIndex) throws SQLException {
        return this._stmt.getShort(parameterIndex);
    }

    public int getInt(int parameterIndex) throws SQLException {
        return this._stmt.getInt(parameterIndex);
    }

    public long getLong(int parameterIndex) throws SQLException {
        return this._stmt.getLong(parameterIndex);
    }

    public float getFloat(int parameterIndex) throws SQLException {
        return this._stmt.getFloat(parameterIndex);
    }

    public double getDouble(int parameterIndex) throws SQLException {
        return this._stmt.getDouble(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex, int scale) throws SQLException {
        return this._stmt.getBigDecimal(parameterIndex, scale);
    }

    public byte[] getBytes(int parameterIndex) throws SQLException {
        return this._stmt.getBytes(parameterIndex);
    }

    public Date getDate(int parameterIndex) throws SQLException {
        return this._stmt.getDate(parameterIndex);
    }

    public Time getTime(int parameterIndex) throws SQLException {
        return this._stmt.getTime(parameterIndex);
    }

    public Timestamp getTimestamp(int parameterIndex) throws SQLException {
        return this._stmt.getTimestamp(parameterIndex);
    }

    public Object getObject(int parameterIndex) throws SQLException {
        return this._stmt.getObject(parameterIndex);
    }

    public BigDecimal getBigDecimal(int parameterIndex) throws SQLException {
        return this._stmt.getBigDecimal(parameterIndex);
    }

    public Object getObject(int i, Map map) throws SQLException {
        return this._stmt.getObject(i, map);
    }

    public Ref getRef(int i) throws SQLException {
        return this._stmt.getRef(i);
    }

    public Blob getBlob(int i) throws SQLException {
        return this._stmt.getBlob(i);
    }

    public Clob getClob(int i) throws SQLException {
        return this._stmt.getClob(i);
    }

    public Array getArray(int i) throws SQLException {
        return this._stmt.getArray(i);
    }

    public Date getDate(int parameterIndex, Calendar cal) throws SQLException {
        return this._stmt.getDate(parameterIndex, cal);
    }

    public Time getTime(int parameterIndex, Calendar cal) throws SQLException {
        return this._stmt.getTime(parameterIndex, cal);
    }

    public Timestamp getTimestamp(int parameterIndex, Calendar cal) throws SQLException {
        return this._stmt.getTimestamp(parameterIndex, cal);
    }

    public void registerOutParameter(int paramIndex, int sqlType, String typeName) throws SQLException {
        this._stmt.registerOutParameter(paramIndex, sqlType, typeName);
    }

    public int executeUpdate() throws SQLException {
        return this._stmt.executeUpdate();
    }

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        this._stmt.setNull(parameterIndex, sqlType);
    }

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this._stmt.setBoolean(parameterIndex, x);
    }

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this._stmt.setByte(parameterIndex, x);
    }

    public void setShort(int parameterIndex, short x) throws SQLException {
        this._stmt.setShort(parameterIndex, x);
    }

    public void setInt(int parameterIndex, int x) throws SQLException {
        this._stmt.setInt(parameterIndex, x);
    }

    public void setLong(int parameterIndex, long x) throws SQLException {
        this._stmt.setLong(parameterIndex, x);
    }

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this._stmt.setFloat(parameterIndex, x);
    }

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this._stmt.setDouble(parameterIndex, x);
    }

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this._stmt.setBigDecimal(parameterIndex, x);
    }

    public void setString(int parameterIndex, String x) throws SQLException {
        this._stmt.setString(parameterIndex, x);
    }

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this._stmt.setBytes(parameterIndex, x);
    }

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this._stmt.setDate(parameterIndex, x);
    }

    public void setTime(int parameterIndex, Time x) throws SQLException {
        this._stmt.setTime(parameterIndex, x);
    }

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this._stmt.setTimestamp(parameterIndex, x);
    }

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._stmt.setAsciiStream(parameterIndex, x, length);
    }

    public void setUnicodeStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._stmt.setUnicodeStream(parameterIndex, x, length);
    }

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        this._stmt.setBinaryStream(parameterIndex, x, length);
    }

    public void clearParameters() throws SQLException {
        this._stmt.clearParameters();
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale) throws SQLException {
        this._stmt.setObject(parameterIndex, x, targetSqlType, scale);
    }

    public void setObject(int parameterIndex, Object x, int targetSqlType) throws SQLException {
        this._stmt.setObject(parameterIndex, x, targetSqlType);
    }

    public void setObject(int parameterIndex, Object x) throws SQLException {
        this._stmt.setObject(parameterIndex, x);
    }

    public boolean execute() throws SQLException {
        return this._stmt.execute();
    }

    public void addBatch() throws SQLException {
        this._stmt.addBatch();
    }

    public void setCharacterStream(int parameterIndex, Reader reader, int length) throws SQLException {
        this._stmt.setCharacterStream(parameterIndex, reader, length);
    }

    public void setRef(int i, Ref x) throws SQLException {
        this._stmt.setRef(i, x);
    }

    public void setBlob(int i, Blob x) throws SQLException {
        this._stmt.setBlob(i, x);
    }

    public void setClob(int i, Clob x) throws SQLException {
        this._stmt.setClob(i, x);
    }

    public void setArray(int i, Array x) throws SQLException {
        this._stmt.setArray(i, x);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this._stmt.getMetaData();
    }

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this._stmt.setDate(parameterIndex, x, cal);
    }

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this._stmt.setTime(parameterIndex, x, cal);
    }

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this._stmt.setTimestamp(parameterIndex, x, cal);
    }

    public void setNull(int paramIndex, int sqlType, String typeName) throws SQLException {
        this._stmt.setNull(paramIndex, sqlType, typeName);
    }

    public int executeUpdate(String sql) throws SQLException {
        return this._stmt.executeUpdate(sql);
    }

    public int getMaxFieldSize() throws SQLException {
        return this._stmt.getMaxFieldSize();
    }

    public void setMaxFieldSize(int max) throws SQLException {
        this._stmt.setMaxFieldSize(max);
    }

    public int getMaxRows() throws SQLException {
        return this._stmt.getMaxRows();
    }

    public void setMaxRows(int max) throws SQLException {
        this._stmt.setMaxRows(max);
    }

    public void setEscapeProcessing(boolean enable) throws SQLException {
        this._stmt.setEscapeProcessing(enable);
    }

    public int getQueryTimeout() throws SQLException {
        return this._stmt.getQueryTimeout();
    }

    public void setQueryTimeout(int seconds) throws SQLException {
        this._stmt.setQueryTimeout(seconds);
    }

    public void cancel() throws SQLException {
        this._stmt.cancel();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this._stmt.getWarnings();
    }

    public void clearWarnings() throws SQLException {
        this._stmt.clearWarnings();
    }

    public void setCursorName(String name) throws SQLException {
        this._stmt.setCursorName(name);
    }

    public boolean execute(String sql) throws SQLException {
        return this._stmt.execute(sql);
    }

    public int getUpdateCount() throws SQLException {
        return this._stmt.getUpdateCount();
    }

    public boolean getMoreResults() throws SQLException {
        return this._stmt.getMoreResults();
    }

    public void setFetchDirection(int direction) throws SQLException {
        this._stmt.setFetchDirection(direction);
    }

    public int getFetchDirection() throws SQLException {
        return this._stmt.getFetchDirection();
    }

    public void setFetchSize(int rows) throws SQLException {
        this._stmt.setFetchSize(rows);
    }

    public int getFetchSize() throws SQLException {
        return this._stmt.getFetchSize();
    }

    public int getResultSetConcurrency() throws SQLException {
        return this._stmt.getResultSetConcurrency();
    }

    public int getResultSetType() throws SQLException {
        return this._stmt.getResultSetType();
    }

    public void addBatch(String sql) throws SQLException {
        this._stmt.addBatch(sql);
    }

    public void clearBatch() throws SQLException {
        this._stmt.clearBatch();
    }

    public int[] executeBatch() throws SQLException {
        return this._stmt.executeBatch();
    }

    public boolean getMoreResults(int current) throws SQLException {
        return this._stmt.getMoreResults(current);
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        return this._stmt.getGeneratedKeys();
    }

    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        return this._stmt.executeUpdate(sql, autoGeneratedKeys);
    }

    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this._stmt.executeUpdate(sql, columnIndexes);
    }

    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this._stmt.executeUpdate(sql, columnNames);
    }

    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this._stmt.execute(sql, autoGeneratedKeys);
    }

    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this._stmt.execute(sql, columnIndexes);
    }

    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this._stmt.execute(sql, columnNames);
    }

    public int getResultSetHoldability() throws SQLException {
        return this._stmt.getResultSetHoldability();
    }

    public void setURL(int parameterIndex, URL x) throws SQLException {
        this._stmt.setURL(parameterIndex, x);
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        return this._stmt.getParameterMetaData();
    }

    public void registerOutParameter(String parameterName, int sqlType) throws SQLException {
        this._stmt.registerOutParameter(parameterName, sqlType);
    }

    public void registerOutParameter(String parameterName, int sqlType, int scale) throws SQLException {
        this._stmt.registerOutParameter(parameterName, sqlType, scale);
    }

    public void registerOutParameter(String parameterName, int sqlType, String typeName) throws SQLException {
        this._stmt.registerOutParameter(parameterName, sqlType, typeName);
    }

    public URL getURL(int parameterIndex) throws SQLException {
        return this._stmt.getURL(parameterIndex);
    }

    public void setURL(String parameterName, URL val) throws SQLException {
        this._stmt.setURL(parameterName, val);
    }

    public void setNull(String parameterName, int sqlType) throws SQLException {
        this._stmt.setNull(parameterName, sqlType);
    }

    public void setBoolean(String parameterName, boolean x) throws SQLException {
        this._stmt.setBoolean(parameterName, x);
    }

    public void setByte(String parameterName, byte x) throws SQLException {
        this._stmt.setByte(parameterName, x);
    }

    public void setShort(String parameterName, short x) throws SQLException {
        this._stmt.setShort(parameterName, x);
    }

    public void setInt(String parameterName, int x) throws SQLException {
        this._stmt.setInt(parameterName, x);
    }

    public void setLong(String parameterName, long x) throws SQLException {
        this._stmt.setLong(parameterName, x);
    }

    public void setFloat(String parameterName, float x) throws SQLException {
        this._stmt.setFloat(parameterName, x);
    }

    public void setDouble(String parameterName, double x) throws SQLException {
        this._stmt.setDouble(parameterName, x);
    }

    public void setBigDecimal(String parameterName, BigDecimal x) throws SQLException {
        this._stmt.setBigDecimal(parameterName, x);
    }

    public void setString(String parameterName, String x) throws SQLException {
        this._stmt.setString(parameterName, x);
    }

    public void setBytes(String parameterName, byte[] x) throws SQLException {
        this._stmt.setBytes(parameterName, x);
    }

    public void setDate(String parameterName, Date x) throws SQLException {
        this._stmt.setDate(parameterName, x);
    }

    public void setTime(String parameterName, Time x) throws SQLException {
        this._stmt.setTime(parameterName, x);
    }

    public void setTimestamp(String parameterName, Timestamp x) throws SQLException {
        this._stmt.setTimestamp(parameterName, x);
    }

    public void setAsciiStream(String parameterName, InputStream x, int length) throws SQLException {
        this._stmt.setAsciiStream(parameterName, x, length);
    }

    public void setBinaryStream(String parameterName, InputStream x, int length) throws SQLException {
        this._stmt.setBinaryStream(parameterName, x, length);
    }

    public void setObject(String parameterName, Object x, int targetSqlType, int scale) throws SQLException {
        this._stmt.setObject(parameterName, x, targetSqlType, scale);
    }

    public void setObject(String parameterName, Object x, int targetSqlType) throws SQLException {
        this._stmt.setObject(parameterName, x, targetSqlType);
    }

    public void setObject(String parameterName, Object x) throws SQLException {
        this._stmt.setObject(parameterName, x);
    }

    public void setCharacterStream(String parameterName, Reader reader, int length) throws SQLException {
        this._stmt.setCharacterStream(parameterName, reader, length);
    }

    public void setDate(String parameterName, Date x, Calendar cal) throws SQLException {
        this._stmt.setDate(parameterName, x, cal);
    }

    public void setTime(String parameterName, Time x, Calendar cal) throws SQLException {
        this._stmt.setTime(parameterName, x, cal);
    }

    public void setTimestamp(String parameterName, Timestamp x, Calendar cal) throws SQLException {
        this._stmt.setTimestamp(parameterName, x, cal);
    }

    public void setNull(String parameterName, int sqlType, String typeName) throws SQLException {
        this._stmt.setNull(parameterName, sqlType, typeName);
    }

    public String getString(String parameterName) throws SQLException {
        return this._stmt.getString(parameterName);
    }

    public boolean getBoolean(String parameterName) throws SQLException {
        return this._stmt.getBoolean(parameterName);
    }

    public byte getByte(String parameterName) throws SQLException {
        return this._stmt.getByte(parameterName);
    }

    public short getShort(String parameterName) throws SQLException {
        return this._stmt.getShort(parameterName);
    }

    public int getInt(String parameterName) throws SQLException {
        return this._stmt.getInt(parameterName);
    }

    public long getLong(String parameterName) throws SQLException {
        return this._stmt.getLong(parameterName);
    }

    public float getFloat(String parameterName) throws SQLException {
        return this._stmt.getFloat(parameterName);
    }

    public double getDouble(String parameterName) throws SQLException {
        return this._stmt.getDouble(parameterName);
    }

    public byte[] getBytes(String parameterName) throws SQLException {
        return this._stmt.getBytes(parameterName);
    }

    public Date getDate(String parameterName) throws SQLException {
        return this._stmt.getDate(parameterName);
    }

    public Time getTime(String parameterName) throws SQLException {
        return this._stmt.getTime(parameterName);
    }

    public Timestamp getTimestamp(String parameterName) throws SQLException {
        return this._stmt.getTimestamp(parameterName);
    }

    public Object getObject(String parameterName) throws SQLException {
        return this._stmt.getObject(parameterName);
    }

    public BigDecimal getBigDecimal(String parameterName) throws SQLException {
        return this._stmt.getBigDecimal(parameterName);
    }

    public Object getObject(String parameterName, Map map) throws SQLException {
        return this._stmt.getObject(parameterName, map);
    }

    public Ref getRef(String parameterName) throws SQLException {
        return this._stmt.getRef(parameterName);
    }

    public Blob getBlob(String parameterName) throws SQLException {
        return this._stmt.getBlob(parameterName);
    }

    public Clob getClob(String parameterName) throws SQLException {
        return this._stmt.getClob(parameterName);
    }

    public Array getArray(String parameterName) throws SQLException {
        return this._stmt.getArray(parameterName);
    }

    public Date getDate(String parameterName, Calendar cal) throws SQLException {
        return this._stmt.getDate(parameterName, cal);
    }

    public Time getTime(String parameterName, Calendar cal) throws SQLException {
        return this._stmt.getTime(parameterName, cal);
    }

    public Timestamp getTimestamp(String parameterName, Calendar cal) throws SQLException {
        return this._stmt.getTimestamp(parameterName, cal);
    }

    public URL getURL(String parameterName) throws SQLException {
        return this._stmt.getURL(parameterName);
    }
}

