-- --------------------------------------------------------
-- 主机:                           127.0.0.1
-- 服务器版本:                        5.6.10 - MySQL Community Server (GPL)
-- 服务器操作系统:                      Win32
-- HeidiSQL 版本:                  9.1.0.4867
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8mb4 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

-- 导出 infocomb2b 的数据库结构
DROP DATABASE IF EXISTS `infocomb2b`;
CREATE DATABASE IF NOT EXISTS `infocomb2b` /*!40100 DEFAULT CHARACTER SET gb2312 */;
USE `infocomb2b`;


-- 导出  表 infocomb2b.ad 结构
DROP TABLE IF EXISTS `ad`;
CREATE TABLE IF NOT EXISTS `ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(50) DEFAULT NULL,
  `pic` varchar(50) DEFAULT NULL,
  `remark` longtext,
  `url` varchar(255) DEFAULT NULL,
  `inputdatetime` datetime DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.ad 的数据：~5 rows (大约)
DELETE FROM `ad`;
/*!40000 ALTER TABLE `ad` DISABLE KEYS */;
INSERT INTO `ad` (`id`, `title`, `pic`, `remark`, `url`, `inputdatetime`) VALUES
	(1, '首页广告1', 'upload/images/1434314453776.jpg', '<p>\r\n	首页广告1</p>', '#', '2015-06-15 19:43:12'),
	(2, '江西省抚州市信通网络科技有限公司', 'upload/images/1453115242957.jpg', '<p>\r\n	江西省抚州市信通网络科技有限公司广告</p>', 'http://localhost:8080/jxfzinfocomnet', '2016-01-18 19:07:29'),
	(3, '信通购物网', 'upload/images/1434369043728.jpg', '<p>\r\n	信通购物网广告</p>', 'http://localhost:8080/infocomshop', '2016-01-18 19:05:41'),
	(4, '公司广告4', 'upload/images/1434312823674.jpg', '<p>\r\n	公司广告4</p>', '#', '2015-06-15 19:47:41'),
	(5, '公司广告5', 'upload/images/1434314516547.jpg', '<p>\r\n	公司广告5</p>', '#', '2015-06-15 19:47:49');
/*!40000 ALTER TABLE `ad` ENABLE KEYS */;


-- 导出  表 infocomb2b.admin 结构
DROP TABLE IF EXISTS `admin`;
CREATE TABLE IF NOT EXISTS `admin` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `managername` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.admin 的数据：~0 rows (大约)
DELETE FROM `admin`;
/*!40000 ALTER TABLE `admin` DISABLE KEYS */;
INSERT INTO `admin` (`Id`, `managername`, `password`) VALUES
	(1, 'admin', '123456789');
/*!40000 ALTER TABLE `admin` ENABLE KEYS */;


-- 导出  表 infocomb2b.archives 结构
DROP TABLE IF EXISTS `archives`;
CREATE TABLE IF NOT EXISTS `archives` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `username` char(50) NOT NULL DEFAULT '0',
  `number of people` char(50) NOT NULL DEFAULT '0',
  ` business volume` char(50) NOT NULL DEFAULT '0',
  `foundtime` year(4) NOT NULL DEFAULT '2000',
  `brand` char(50) NOT NULL DEFAULT '0',
  `corporate representative` char(50) DEFAULT NULL,
  `yearinportamount` char(50) DEFAULT NULL,
  `manage system identification` char(50) DEFAULT NULL,
  `bank` char(50) DEFAULT NULL,
  `account number` char(50) DEFAULT NULL,
  `registered capital` char(50) DEFAULT NULL,
  `mainclients` char(50) DEFAULT NULL,
  `yearexportamount` int(11) DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.archives 的数据：~0 rows (大约)
DELETE FROM `archives`;
/*!40000 ALTER TABLE `archives` DISABLE KEYS */;
/*!40000 ALTER TABLE `archives` ENABLE KEYS */;


-- 导出  表 infocomb2b.b2border 结构
DROP TABLE IF EXISTS `b2border`;
CREATE TABLE IF NOT EXISTS `b2border` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `orderid` varchar(255) DEFAULT NULL,
  `username` varchar(50) DEFAULT NULL,
  `product_id` int(11) DEFAULT NULL,
  `count` int(11) DEFAULT NULL,
  `totalprice` int(11) DEFAULT NULL,
  `payment` varchar(255) DEFAULT NULL,
  `postway` varchar(255) DEFAULT NULL,
  `order_check` enum('0','1') DEFAULT NULL,
  `member` varchar(50) DEFAULT NULL,
  `orderdate` datetime DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=269 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.b2border 的数据：~82 rows (大约)
DELETE FROM `b2border`;
/*!40000 ALTER TABLE `b2border` DISABLE KEYS */;
INSERT INTO `b2border` (`Id`, `orderid`, `username`, `product_id`, `count`, `totalprice`, `payment`, `postway`, `order_check`, `member`, `orderdate`) VALUES
	(187, '2014030606480673', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(188, '2014030606520168', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(189, '2014030606592426', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(190, '2014030607005139', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(191, '2014030607005776', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(192, '2014030607010156', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(193, '2014030607011915', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(194, '2014030607041588', 'jxfzinfocomnet', 1, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(195, '2014030607061643', 'jxfzinfocomnet', 1, 3, 14400, '银行柜台支付', '邮政包裹/平邮', NULL, 'ncxt', NULL),
	(196, '2015042806502890', 'infocomnet', 5, 5, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(197, '2015042806502953', 'infocomnet', 4, 3, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(198, '2015070809480078', 'infocomnet', 1, 1, 3800, '网上在线支付', '圆通快递', NULL, 'infocomnet', NULL),
	(199, '2015070810110322', 'infocomnet', 12, 1, 100, '银行柜台支付', '邮政包裹/平邮', NULL, 'fds111', NULL),
	(200, '2015070810110393', 'infocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(201, '2015070908434742', 'fds111', 8, 1, 0, '网上在线支付', '德邦物流', NULL, 'jxmdbz', NULL),
	(202, '201507090845396', 'fds111', 8, 1, 0, '网上在线支付', '德邦物流', NULL, 'jxmdbz', NULL),
	(203, '2015070908463159', 'fds111', 8, 1, 0, '网上在线支付', '德邦物流', NULL, 'jxmdbz', NULL),
	(204, '2015070908484984', 'fds111', 10, 1, 300, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(205, '2015070908494287', 'fds111', 10, 1, 300, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(206, '2015070908502641', 'fds111', 10, 1, 300, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(207, '2015070908504882', 'fds111', 10, 1, 300, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(208, '2015080305180625', 'jxfzinfocomnet', 1, 1, 3800, '网上在线支付', '圆通快递', NULL, 'infocomnet', NULL),
	(209, '2015110903491498', 'jxfzinfocomnet', 5, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(210, '2015110903491450', 'jxfzinfocomnet', 4, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(211, '2015110903491432', 'jxfzinfocomnet', 1, 2, 7600, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(212, '2015110903491489', 'jxfzinfocomnet', 8, 2, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(213, '2015110903491451', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(214, '2015110903501255', 'jxfzinfocomnet', 5, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(215, '2015110903501289', 'jxfzinfocomnet', 4, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(216, '2015110903501292', 'jxfzinfocomnet', 1, 2, 7600, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(217, '2015110903501218', 'jxfzinfocomnet', 8, 2, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(218, '2015110903501267', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(219, '2015110903553917', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(220, '2015110903553948', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(221, '2015110903572624', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(222, '2015110903572690', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(223, '2015110903572739', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(224, '2015110903572847', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(225, '2015110903572865', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(226, '2015110903572981', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(227, '2015110903574148', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(228, '2015110903574189', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(229, '2015110903574580', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(230, '2015110903574513', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(231, '2015110903583295', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(232, '2015110903583389', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(233, '2015110903583442', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(234, '2015110903583441', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(235, '201511090403541', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(236, '2015110904035448', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(237, '2015110904070598', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(238, '2015110904070579', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(239, '2015110904091069', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(240, '2015110904091021', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(241, '2015110904094498', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(242, '2015110904094450', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(243, '2015110904103894', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(244, '2015110904103862', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(245, '2015110904104754', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(246, '201511090410474', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(247, '2015110904193164', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(248, '2015110904193164', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(249, '2015110904200560', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(250, '2015110904200538', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(251, '2015110904201110', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(252, '2015110904201153', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(253, '2015110904211720', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(254, '2015110904211732', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(255, '2015110904214577', 'jxfzinfocomnet', 2, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(256, '2015110904214573', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(257, '2015110904330880', 'jxfzinfocomnet', 2, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(258, '2015110904330933', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(259, '2015110904345332', 'jxfzinfocomnet', 2, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(260, '2015110904345573', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(261, '2015110904362562', 'jxfzinfocomnet', 4, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL),
	(262, '2015110904362567', 'jxfzinfocomnet', 2, 2, 9600, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(263, '2015110904362517', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(264, '201511090438315', 'jxfzinfocomnet', 2, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(265, '2015110904383135', 'jxfzinfocomnet', 1, 1, 3800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(266, '2015110904463269', 'jxfzinfocomnet', 2, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(267, '2015110904470317', 'jxfzinfocomnet', 2, 1, 4800, '银行柜台支付', '邮政包裹/平邮', NULL, 'infocomnet', NULL),
	(268, '2015110905294068', 'jxfzinfocomnet', 7, 1, 0, '银行柜台支付', '邮政包裹/平邮', NULL, 'jxmdbz', NULL);
/*!40000 ALTER TABLE `b2border` ENABLE KEYS */;


-- 导出  表 infocomb2b.city 结构
DROP TABLE IF EXISTS `city`;
CREATE TABLE IF NOT EXISTS `city` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `provinceid` int(11) DEFAULT NULL,
  `cityname` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `Id` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=363 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.city 的数据：~337 rows (大约)
DELETE FROM `city`;
/*!40000 ALTER TABLE `city` DISABLE KEYS */;
INSERT INTO `city` (`Id`, `provinceid`, `cityname`) VALUES
	(1, 1, '广州市'),
	(4, 5, '南昌市'),
	(5, 1, '佛山市'),
	(6, 5, '抚州市'),
	(7, 29, '北京市'),
	(8, 29, '上海市'),
	(9, 10, '杭州市'),
	(10, 5, '鹰潭市'),
	(11, 1, '东莞市'),
	(13, 5, '吉安市'),
	(15, 5, '赣州市'),
	(16, 9, '合肥市'),
	(17, 11, '南京市'),
	(19, 4, '福州市'),
	(20, 5, '九江市'),
	(21, 20, '长春市'),
	(22, 7, '成都市'),
	(23, 6, '长沙市'),
	(24, 18, '石家庄市'),
	(25, 4, '三明市'),
	(26, 14, '西安市'),
	(27, 13, '武汉市'),
	(29, 29, '重庆市'),
	(30, 30, '深圳市'),
	(31, 30, '珠海市'),
	(32, 30, '厦门市'),
	(33, 30, '汕头市'),
	(34, 30, '海南省'),
	(35, 30, '喀什市'),
	(36, 31, '香港'),
	(37, 31, '澳门'),
	(40, 11, '苏州市'),
	(41, 6, '株洲市'),
	(42, 19, '沈阳市'),
	(43, 29, '天津市'),
	(44, 19, '大连市'),
	(47, 1, '惠州市'),
	(49, 2, '南宁市'),
	(50, 16, '太原市'),
	(51, 17, '郑州市'),
	(52, 2, '柳州市'),
	(53, 12, '济南市'),
	(54, 2, '桂林市'),
	(56, 5, '萍乡市'),
	(57, 5, '新余市'),
	(58, 5, '上饶市'),
	(59, 10, '金华市'),
	(60, 1, '肇庆市'),
	(61, 1, '揭阳市'),
	(62, 1, '茂名市'),
	(63, 1, '湛江市'),
	(64, 12, '青岛市'),
	(65, 16, '大同市'),
	(66, 14, '宝鸡市'),
	(67, 16, '运城市'),
	(68, 16, '晋城市'),
	(69, 16, '临汾市'),
	(70, 1, '中山市'),
	(72, 24, '呼和浩特市'),
	(73, 24, '包头市'),
	(74, 26, '乌鲁木齐市'),
	(75, 25, '拉萨市'),
	(76, 25, '昌都市'),
	(77, 3, '贵阳市'),
	(81, 10, '宁波市'),
	(82, 10, '台州市'),
	(83, 10, '衢州市'),
	(84, 10, '温州市'),
	(85, 7, '绵阳市'),
	(86, 11, '南通市'),
	(87, 11, '连云巷市'),
	(88, 11, '常州市'),
	(89, 11, '扬州市'),
	(90, 8, '昆明市'),
	(91, 8, '丽江市'),
	(94, 11, '无锡市'),
	(95, 21, '哈尔滨市'),
	(97, 15, '兰州市'),
	(98, 22, '银川市'),
	(99, 23, '西宁市'),
	(101, 7, '南充市'),
	(102, 19, '抚顺市'),
	(103, 19, '锦州市'),
	(104, 5, '宜春市'),
	(105, 4, '蒲田市'),
	(106, 10, '嘉兴市'),
	(107, 5, '景德镇市'),
	(108, 1, '江门市'),
	(110, 1, '梅州市'),
	(111, 1, '河源市'),
	(112, 1, '韶关市'),
	(113, 3, '遵义市'),
	(114, 3, '六盘水市'),
	(115, 2, '梧州市'),
	(116, 2, '北海市'),
	(117, 2, '防城港市'),
	(118, 2, '钦州市'),
	(119, 2, '贵港市'),
	(120, 2, '玉林市'),
	(121, 2, '贺州市'),
	(122, 2, '百色市'),
	(123, 10, '绍兴市'),
	(124, 10, '舟山市'),
	(125, 10, '丽水市'),
	(126, 9, '芜湖市'),
	(127, 9, '蚌埠市'),
	(128, 4, '泉州市'),
	(129, 4, '漳州市'),
	(130, 4, '龙岩市'),
	(131, 4, '南平市'),
	(132, 20, '吉林市'),
	(133, 6, '张家界市'),
	(134, 6, '郴州市'),
	(135, 13, '黄石市'),
	(136, 13, '宜昌市'),
	(137, 13, '鄂州市'),
	(138, 13, '十堰市'),
	(139, 13, '襄樊市'),
	(141, 19, '本溪市'),
	(142, 19, '营口市'),
	(143, 19, '丹东市'),
	(144, 19, '阜新市'),
	(145, 19, '辽阳市'),
	(146, 17, '开封市'),
	(147, 17, '洛阳市'),
	(148, 17, '新乡市'),
	(149, 17, '焦作市'),
	(150, 17, '许昌市'),
	(151, 17, '商丘市'),
	(152, 17, '周口市'),
	(153, 12, '淄博市'),
	(154, 12, '枣庄市'),
	(155, 12, '烟台市'),
	(156, 12, '潍坊市'),
	(157, 12, '威海市'),
	(158, 12, '临沂市'),
	(159, 21, '伊春市'),
	(160, 21, '牡丹江市'),
	(161, 15, '金昌市'),
	(162, 15, '白银市'),
	(163, 15, '天水市'),
	(164, 22, '石嘴山市'),
	(165, 18, '秦皇岛市'),
	(166, 18, '邯郸市'),
	(167, 18, '保定市'),
	(168, 18, '廊坊市'),
	(169, 18, '张家口市'),
	(170, 18, '沧州市'),
	(171, 20, '四平市'),
	(173, 20, '辽源市'),
	(174, 20, '通化市'),
	(175, 20, '松原市'),
	(176, 20, '延边朝鲜族自治州'),
	(177, 7, '自贡市'),
	(178, 7, '攀枝花市'),
	(179, 7, '泸州市'),
	(180, 7, '德阳市'),
	(181, 7, '广元市'),
	(182, 7, '内江市'),
	(183, 7, '乐山市'),
	(184, 7, '宜宾市'),
	(185, 7, '广安市'),
	(186, 7, '资阳地区'),
	(187, 7, '巴中地区'),
	(188, 9, '淮南市'),
	(189, 9, '马鞍山市'),
	(190, 9, '淮北市'),
	(191, 9, '铜陵市'),
	(192, 9, '安庆市'),
	(193, 9, '黄山市'),
	(195, 9, '滁州市'),
	(196, 9, '阜阳市'),
	(197, 9, '宿州市'),
	(198, 9, '六安市'),
	(199, 9, '宣城市'),
	(200, 9, '巢湖市'),
	(201, 9, '池州市'),
	(202, 6, '湘潭市'),
	(203, 6, '衡阳市'),
	(204, 6, '邵阳市'),
	(205, 6, '岳阳市'),
	(206, 6, '常德市'),
	(207, 6, '益阳市'),
	(208, 6, '永州市'),
	(209, 6, '怀化市'),
	(210, 6, '娄底地区'),
	(211, 6, '湘西土家族苗族自治州'),
	(212, 14, '铜川市'),
	(213, 14, '咸阳市'),
	(214, 14, '渭南市'),
	(215, 14, '延安市'),
	(216, 14, '汉中市'),
	(217, 14, '安康地区'),
	(218, 14, '商洛地区'),
	(219, 14, '榆林地区'),
	(220, 3, '铜仁地区'),
	(221, 3, '黔西南布依族苗族自治州'),
	(222, 3, '毕节地区'),
	(223, 3, '安顺地区'),
	(224, 3, '黔东南苗族侗族自治州'),
	(225, 3, '黔南布依族苗族自治州'),
	(226, 8, '曲靖市'),
	(227, 8, '玉溪市'),
	(228, 8, '昭通地区'),
	(229, 8, '思茅市'),
	(230, 8, '西双版纳傣族自治州'),
	(231, 8, '大理白族自治州'),
	(232, 8, '保山地区'),
	(233, 8, '临沧地区'),
	(234, 8, '德宏傣族景颇族自治州'),
	(235, 8, '文山壮族苗族自治州'),
	(236, 8, '迪庆藏族自治州'),
	(237, 21, '齐齐哈尔市'),
	(238, 21, '大庆市'),
	(239, 21, '黑河市'),
	(240, 21, '鸡西市'),
	(241, 21, '鹤岗市'),
	(242, 21, '七台河市'),
	(243, 21, '绥化市'),
	(244, 21, '大兴安岭地区'),
	(245, 24, '乌海市'),
	(246, 24, '赤峰市'),
	(247, 24, '呼伦贝尔市'),
	(248, 24, '通辽市'),
	(249, 24, '兴安盟'),
	(250, 24, '锡林郭勒盟'),
	(251, 24, '乌兰察布盟'),
	(252, 24, '伊克昭盟'),
	(253, 20, '白城市'),
	(254, 20, '白山市'),
	(255, 13, '荆门市'),
	(256, 13, '孝感市'),
	(257, 13, '荆州市'),
	(258, 13, '黄冈市'),
	(259, 13, '咸宁市'),
	(260, 18, '承德市'),
	(261, 18, '衡水市'),
	(262, 23, '海东地区'),
	(263, 26, '克拉玛依市'),
	(264, 26, '吐鲁番地区'),
	(265, 26, '哈密地区'),
	(266, 26, '阿克苏地区'),
	(267, 26, '喀什地区'),
	(268, 26, '和田地区'),
	(269, 26, '塔城地区'),
	(270, 26, '阿勒泰地区'),
	(271, 22, '吴忠市'),
	(272, 22, '固原地区'),
	(273, 22, '中卫市'),
	(274, 25, '山南地区'),
	(275, 25, '日喀则地区'),
	(276, 25, '那曲地区'),
	(277, 25, '阿里地区'),
	(278, 25, '林芝地区'),
	(279, 15, '酒泉地区'),
	(280, 15, '张掖地区'),
	(281, 15, '武威地区'),
	(282, 15, '定西地区'),
	(283, 15, '陇南地区'),
	(284, 15, '平凉地区'),
	(285, 15, '庆阳地区'),
	(286, 13, '恩施土家族苗族自治州'),
	(287, 13, '仙桃市'),
	(288, 13, '潜江市'),
	(289, 13, '天门市'),
	(290, 13, '神农架林区'),
	(291, 11, '淮阴市'),
	(292, 11, '盐城市'),
	(293, 11, '镇江市'),
	(294, 11, '泰州市'),
	(295, 4, '宁德市'),
	(296, 16, '阳泉市'),
	(297, 16, '长治市'),
	(298, 16, '朔州市'),
	(299, 16, '忻州市'),
	(300, 16, '吕梁市'),
	(301, 19, '鞍山市'),
	(302, 19, '盘锦市'),
	(303, 19, '铁岭市'),
	(304, 19, '朝阳市'),
	(305, 19, '葫芦岛市'),
	(306, 18, '邢台市'),
	(307, 10, '湖州市'),
	(308, 17, '平顶山市'),
	(309, 17, '安阳市'),
	(310, 17, '鹤壁市'),
	(311, 17, '濮阳市'),
	(313, 17, '三门峡市'),
	(314, 12, '济宁市'),
	(315, 12, '泰安市'),
	(316, 12, '日照市'),
	(317, 12, '莱芜市'),
	(318, 12, '德州市'),
	(319, 12, '聊城市'),
	(320, 12, '滨州地区'),
	(321, 12, '菏泽地区'),
	(322, 2, '崇左市'),
	(323, 2, '来宾市'),
	(324, 2, '河池市'),
	(325, 1, '汕尾市'),
	(326, 1, '阳江市'),
	(327, 1, '清远市'),
	(328, 1, '潮州市'),
	(329, 1, '云浮市'),
	(330, 7, '遂宁市'),
	(331, 7, '达川地区'),
	(332, 7, '雅安地区'),
	(333, 7, '阿坝藏族羌族自治州'),
	(334, 7, '甘孜藏族自治州'),
	(335, 7, '凉山彝族自治州'),
	(336, 7, '眉山地区'),
	(337, 23, '玉树藏族自治州'),
	(338, 23, '海北藏族自治州'),
	(339, 23, '海南藏族自治州'),
	(340, 23, '海西蒙古族藏族自治州'),
	(341, 23, '黄南藏族自治州'),
	(342, 23, '果洛藏族自治州'),
	(343, 8, '楚雄彝族自治州'),
	(344, 8, '红河哈尼族彝族自治州'),
	(345, 8, '怒江傈僳族自治州'),
	(346, 15, '临夏回族自治州'),
	(347, 15, '甘南藏族自治州'),
	(348, 24, '巴彦淖尔盟'),
	(349, 24, '阿拉善盟'),
	(350, 26, '昌吉回族自治州'),
	(351, 26, '博尔塔拉蒙古自治州'),
	(352, 26, '巴音郭楞蒙古自治州'),
	(353, 26, '克孜勒苏柯尔克孜自治州'),
	(354, 26, '伊犁哈萨克自治州'),
	(355, 26, '石河子市'),
	(356, 26, '阿拉尔市'),
	(357, 26, '图木舒克市'),
	(358, 26, '五家渠市'),
	(359, 21, '佳木斯市'),
	(360, 17, '信阳市'),
	(361, 16, '晋中市'),
	(362, 17, '南阳市');
/*!40000 ALTER TABLE `city` ENABLE KEYS */;


-- 导出  表 infocomb2b.class 结构
DROP TABLE IF EXISTS `class`;
CREATE TABLE IF NOT EXISTS `class` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `class` char(50) DEFAULT '0',
  `username` char(50) NOT NULL DEFAULT '0',
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=26 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.class 的数据：~18 rows (大约)
DELETE FROM `class`;
/*!40000 ALTER TABLE `class` DISABLE KEYS */;
INSERT INTO `class` (`id`, `class`, `username`) VALUES
	(4, '网站建\r\n	设', 'bjinfocomnet'),
	(9, '企业电子商务网', 'bjinfocomnet'),
	(10, '购物网', 'bjinfocomnet'),
	(11, '企业管理软件', 'bjinfocomnet'),
	(12, '虚拟主机', 'bjinfocomnet'),
	(13, '域名注册', 'bjinfocomnet'),
	(14, '网站建设', 'bjinfocomnet'),
	(15, '网站建设', 'bjinfocomnet'),
	(16, '购物网', 'bjinfocomnet'),
	(17, 'dgdg', 'bjinfocomnet'),
	(18, 'dzxc', 'bjinfocomnet'),
	(19, '热收缩包装机', 'jxmdbz'),
	(20, '电子商务软件', 'ncicnet'),
	(21, 'vcbvcb', 'ncicnet'),
	(22, 'vcbvcbc', 'ncicnet'),
	(23, 'aaaaaa', 'infocomnet'),
	(24, 'xcvxcv', 'fds111'),
	(25, '下雨', 'jxfzinfocomnet');
/*!40000 ALTER TABLE `class` ENABLE KEYS */;


-- 导出  表 infocomb2b.districtcounty 结构
DROP TABLE IF EXISTS `districtcounty`;
CREATE TABLE IF NOT EXISTS `districtcounty` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `provinceid` int(11) DEFAULT NULL,
  `cityid` int(11) DEFAULT NULL,
  `districtcountyname` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`Id`),
  KEY `Id` (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=2680 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.districtcounty 的数据：~2,665 rows (大约)
DELETE FROM `districtcounty`;
/*!40000 ALTER TABLE `districtcounty` DISABLE KEYS */;
INSERT INTO `districtcounty` (`Id`, `provinceid`, `cityid`, `districtcountyname`) VALUES
	(2, 1, 1, '天河区'),
	(3, 5, 4, '东湖区'),
	(4, 5, 6, '临川区'),
	(5, 1, 5, '禅城区'),
	(6, 5, 7, '海淀区'),
	(7, 29, 8, '浦东新区'),
	(8, 10, 9, '拱墅区'),
	(9, 5, 10, '月湖区'),
	(10, 5, 6, '金溪县'),
	(11, 1, 5, '顺德区'),
	(12, 1, 11, '莞城区'),
	(13, 1, 11, '南城区'),
	(14, 1, 12, '罗湖区'),
	(15, 1, 12, '南山区'),
	(16, 4, 18, '杏林区'),
	(17, 1, 1, '白云区'),
	(18, 1, 1, '罗岗区'),
	(19, 1, 1, '黄埔区'),
	(20, 1, 1, '番禺区'),
	(21, 1, 11, '东城区'),
	(22, 30, 30, '龙岗区'),
	(23, 10, 4, '西湖区'),
	(27, 5, 6, '南城县'),
	(28, 5, 6, '南丰县'),
	(29, 5, 6, '资溪县'),
	(30, 5, 6, '广丰县'),
	(31, 1, 5, '高明区'),
	(33, 1, 1, '荔湾区'),
	(34, 30, 30, '宝安区'),
	(35, 30, 30, '福田区'),
	(36, 30, 30, '罗湖区'),
	(37, 30, 32, '思明区'),
	(38, 30, 32, '杏林区'),
	(39, 30, 32, '集美区'),
	(40, 5, 4, '新建区'),
	(41, 5, 4, '湾里区'),
	(42, 5, 4, '安义县'),
	(43, 5, 4, '青云谱区'),
	(44, 1, 5, '南海区'),
	(45, 29, 7, '昌平区'),
	(46, 30, 34, '海口市'),
	(47, 5, 4, '青山湖区'),
	(48, 5, 4, '进贤县'),
	(49, 5, 4, '南昌县'),
	(50, 1, 1, '越秀区'),
	(51, 5, 10, '贵溪市'),
	(52, 5, 10, '余江县'),
	(53, 1, 93, '福田区'),
	(54, 5, 6, '东乡县'),
	(55, 13, 27, '青山区'),
	(56, 13, 27, '武昌区'),
	(57, 13, 27, '洪山区'),
	(58, 13, 27, '江汉区'),
	(59, 13, 27, '乔口区'),
	(60, 13, 27, '汉阳区'),
	(61, 13, 27, '东西湖区'),
	(65, 5, 6, '广昌县'),
	(66, 29, 7, '朝阳区'),
	(67, 29, 7, '丰台区'),
	(68, 29, 7, '通州区'),
	(69, 29, 7, '东城区'),
	(70, 29, 7, '西城区'),
	(71, 29, 7, '石景山区'),
	(72, 29, 7, '门头沟区'),
	(73, 29, 8, '静安区'),
	(74, 29, 8, '徐汇区'),
	(75, 29, 8, '普陀区'),
	(76, 29, 8, '长宁区'),
	(77, 29, 8, '杨浦区'),
	(78, 29, 43, '开津滨海新区'),
	(79, 29, 43, '天津经济技术开发区'),
	(80, 29, 43, '红桥区'),
	(81, 29, 43, '津南区'),
	(82, 29, 43, '北辰区'),
	(83, 7, 22, '青羊区'),
	(84, 7, 22, '金牛区'),
	(85, 7, 22, '锦江区'),
	(86, 7, 22, '武候区'),
	(87, 7, 22, '成华区'),
	(88, 29, 42, '和平区'),
	(89, 29, 42, '皇姑区'),
	(90, 29, 42, '沈河区'),
	(91, 29, 42, '铁西区'),
	(92, 29, 42, '大东区'),
	(93, 29, 42, '于洪区'),
	(94, 29, 42, '东陵区'),
	(95, 29, 42, '苏家屯区'),
	(96, 14, 26, '未央区'),
	(97, 14, 26, '莲湖区'),
	(98, 14, 26, '新城区'),
	(99, 14, 26, '碑林区'),
	(100, 14, 26, '雁塔区'),
	(101, 14, 26, '灞桥区'),
	(102, 14, 26, '长安区'),
	(103, 30, 34, '三亚市'),
	(104, 29, 8, '闽行区'),
	(105, 29, 8, '松江区'),
	(106, 5, 6, '崇仁县'),
	(107, 5, 6, '宜黄县'),
	(111, 5, 13, '吉州区'),
	(112, 5, 13, '青原区'),
	(113, 5, 13, '吉安县'),
	(114, 5, 13, '吉水县'),
	(115, 5, 13, '泰和县'),
	(116, 5, 13, '安福县'),
	(117, 5, 13, '遂川县'),
	(118, 5, 13, '永丰县'),
	(119, 5, 13, '永新县'),
	(120, 5, 13, '万安县'),
	(121, 5, 13, '峡江县'),
	(122, 5, 13, '新干县'),
	(123, 5, 13, '井冈山市'),
	(124, 5, 15, '章贡区'),
	(125, 5, 15, '赣县'),
	(126, 5, 15, '于都县'),
	(127, 5, 15, '宁都县'),
	(128, 5, 15, '龙南县'),
	(129, 5, 15, '全南县'),
	(130, 5, 15, '定南县'),
	(131, 5, 15, '大余县'),
	(132, 5, 15, '上犹县'),
	(133, 5, 15, '兴国县'),
	(134, 5, 15, '信丰县'),
	(135, 5, 15, '寻乌县'),
	(136, 5, 15, '安远县'),
	(137, 5, 15, '石城县'),
	(138, 5, 15, '崇义县'),
	(139, 5, 15, '瑞金市'),
	(140, 5, 15, '南康市'),
	(141, 5, 6, '黎川县'),
	(142, 5, 20, '浔阳区'),
	(143, 5, 20, '庐山区'),
	(144, 5, 20, '九江县'),
	(145, 5, 20, '星子县'),
	(146, 5, 20, '湖口县'),
	(147, 5, 20, '修水县'),
	(148, 5, 20, '永修县'),
	(149, 5, 20, '德安县'),
	(150, 5, 20, '都昌县'),
	(151, 5, 20, '武宁县'),
	(152, 5, 20, '澎泽县'),
	(153, 5, 20, '瑞昌市'),
	(154, 5, 20, '共青城'),
	(155, 5, 56, '安源区'),
	(156, 5, 56, '湘东区'),
	(157, 5, 56, '上栗县'),
	(158, 5, 56, '莲花县'),
	(159, 5, 56, '芦溪县'),
	(160, 5, 57, '渝水区'),
	(161, 5, 57, '分宜县'),
	(162, 5, 58, '信州区'),
	(163, 5, 58, '上饶县'),
	(164, 5, 58, '玉山县'),
	(165, 5, 58, '余干县'),
	(166, 5, 58, '万年县'),
	(167, 5, 58, '万年县'),
	(168, 5, 58, '横峰县'),
	(169, 5, 58, '广丰县'),
	(170, 5, 58, '鄱阳县'),
	(171, 5, 58, '婺源县'),
	(172, 5, 58, '弋阳县'),
	(173, 5, 58, '波阳县'),
	(174, 5, 58, '德兴市'),
	(175, 5, 104, '袁州区'),
	(176, 5, 104, '奉新县'),
	(177, 5, 104, '万载县'),
	(178, 5, 104, '上高县'),
	(179, 5, 104, '宜丰县'),
	(180, 5, 104, '靖安县'),
	(181, 5, 104, '铜鼓县'),
	(182, 5, 104, '丰城市'),
	(183, 5, 104, '樟树市'),
	(184, 5, 104, '高安市'),
	(185, 5, 107, '昌江区'),
	(186, 5, 107, '珠山区'),
	(187, 5, 107, '浮梁县'),
	(188, 5, 107, '乐平市'),
	(189, 1, 1, '东山区'),
	(190, 1, 1, '海珠区'),
	(191, 1, 1, '花都区'),
	(192, 1, 1, '芳村区'),
	(193, 1, 1, '增城市'),
	(194, 1, 1, '从化市'),
	(195, 1, 5, '三水区'),
	(196, 1, 11, '万江区'),
	(197, 1, 11, '长安镇'),
	(198, 1, 11, '石碣镇'),
	(199, 1, 11, '虎门镇'),
	(200, 1, 11, '石龙镇'),
	(201, 1, 11, '常平镇'),
	(202, 1, 11, '大朗镇'),
	(203, 1, 11, '麻涌镇'),
	(204, 1, 11, '厚街镇'),
	(205, 1, 5, '道?镇'),
	(206, 1, 11, '樟木头镇'),
	(207, 1, 11, '望牛墩镇'),
	(208, 1, 11, '大岭山镇'),
	(209, 1, 11, '沙田镇'),
	(210, 1, 47, '惠城区'),
	(211, 1, 47, '惠阳区'),
	(212, 1, 47, '惠东县'),
	(213, 1, 47, '龙门县'),
	(214, 1, 47, '博罗县'),
	(215, 30, 33, '濠江区'),
	(216, 30, 33, '龙湖区'),
	(217, 30, 33, '金平区'),
	(218, 30, 33, '潮南区'),
	(219, 30, 33, '澄海区'),
	(220, 30, 33, '潮阳区'),
	(221, 30, 33, '南澳县'),
	(222, 1, 60, '鼎湖区'),
	(223, 1, 60, '端州区'),
	(224, 1, 60, '广宁县'),
	(225, 1, 60, '怀集县'),
	(226, 1, 60, '封开县'),
	(227, 1, 60, '德庆县'),
	(228, 1, 60, '高要市'),
	(229, 1, 60, '四会市'),
	(230, 1, 61, '榕城区'),
	(231, 1, 61, '揭东县'),
	(232, 1, 61, '揭西县'),
	(233, 1, 61, '惠来县'),
	(234, 1, 61, '普宁市'),
	(235, 1, 62, '茂南区'),
	(236, 1, 62, '茂港区'),
	(237, 1, 62, '电白县'),
	(238, 1, 62, '高州市'),
	(239, 1, 62, '化州市'),
	(240, 1, 62, '信宜市'),
	(241, 1, 63, '赤坎区'),
	(242, 1, 63, '霞山区'),
	(243, 1, 63, '坡头区'),
	(244, 1, 63, '麻章区'),
	(245, 1, 63, '遂溪县'),
	(246, 1, 63, '徐闻县'),
	(247, 1, 63, '廉江市'),
	(248, 1, 63, '雷州市'),
	(249, 1, 63, '吴川市'),
	(250, 1, 70, '石岐区'),
	(251, 1, 70, '东区'),
	(252, 1, 70, '西区'),
	(253, 1, 70, '南区'),
	(254, 1, 70, '五桂山区'),
	(255, 1, 70, '火炬开发区'),
	(256, 1, 70, '小榄镇'),
	(257, 1, 70, '古镇镇'),
	(258, 1, 70, '大涌镇'),
	(259, 1, 70, '黄圃镇'),
	(260, 1, 108, '蓬江区'),
	(261, 1, 108, '江海区'),
	(262, 1, 108, '台山市'),
	(263, 1, 108, '新会市'),
	(264, 1, 108, '开平市'),
	(265, 1, 108, '鹤山市'),
	(266, 1, 108, '恩平市'),
	(267, 30, 31, '香洲区'),
	(268, 30, 31, '斗门区'),
	(269, 30, 31, '金湾区'),
	(270, 1, 110, '梅江区'),
	(271, 1, 110, '梅县'),
	(272, 1, 110, '大埔县'),
	(273, 1, 110, '丰顺县'),
	(274, 1, 110, '五华县'),
	(275, 1, 110, '平远县'),
	(276, 1, 110, '蕉岭县'),
	(277, 1, 110, '兴宁市'),
	(278, 1, 111, '源城区'),
	(279, 1, 111, '紫金县'),
	(280, 1, 111, '龙川县'),
	(281, 1, 111, '连平县'),
	(282, 1, 111, '和平县'),
	(283, 1, 111, '东源县'),
	(284, 1, 112, '武江区'),
	(285, 1, 112, '浈江区'),
	(286, 1, 112, '曲江区'),
	(287, 1, 112, '始兴县'),
	(288, 1, 112, '仁化县'),
	(289, 1, 112, '翁源县'),
	(290, 1, 112, '新丰县'),
	(291, 1, 112, '乐昌市'),
	(292, 1, 112, '南雄市'),
	(293, 3, 77, '南明区'),
	(294, 3, 77, '云岩区'),
	(295, 3, 77, '花溪区'),
	(296, 3, 77, '乌当区'),
	(297, 3, 77, '白云区'),
	(298, 3, 77, '开阳县'),
	(299, 3, 77, '息烽县'),
	(300, 3, 77, '修文县'),
	(301, 3, 77, '清镇市'),
	(302, 3, 113, '红花岗区'),
	(303, 3, 113, '汇川区'),
	(304, 3, 113, '遵义县'),
	(305, 3, 113, '桐梓县'),
	(306, 3, 113, '绥阳县'),
	(307, 3, 113, '正安县'),
	(308, 3, 113, '凤冈县'),
	(309, 3, 113, '湄潭县'),
	(310, 3, 113, '余庆县'),
	(311, 3, 113, '习水县'),
	(312, 3, 113, '赤水市'),
	(313, 3, 113, '仁怀市'),
	(314, 3, 114, '钟山区'),
	(315, 3, 114, '盘县特区'),
	(316, 3, 114, '六枝特区'),
	(317, 3, 114, '水城县'),
	(318, 2, 49, '兴宁区'),
	(319, 2, 49, '青秀区'),
	(320, 2, 49, '西乡塘区'),
	(321, 2, 49, '江南区'),
	(322, 2, 49, '良庆区'),
	(323, 2, 49, '邕宁区'),
	(324, 2, 49, '武鸣县'),
	(325, 2, 49, '隆安县'),
	(326, 2, 49, '马山县'),
	(327, 2, 49, '上林县'),
	(328, 2, 49, '宾阳县'),
	(329, 2, 49, '横县'),
	(330, 2, 52, '城中区'),
	(331, 2, 52, '鱼峰区'),
	(332, 2, 52, '柳南区'),
	(333, 2, 52, '柳北区'),
	(334, 2, 52, '柳江县'),
	(335, 2, 52, '柳城县'),
	(336, 2, 52, '鹿寨县'),
	(337, 2, 52, '融安县'),
	(338, 2, 54, '秀峰区'),
	(339, 2, 54, '叠彩区'),
	(340, 2, 54, '象山区'),
	(341, 2, 54, '七星区'),
	(342, 2, 54, '雁山区'),
	(343, 2, 54, '阳朔县'),
	(344, 2, 54, '临桂县'),
	(345, 2, 54, '灵川县'),
	(346, 2, 54, '全州县'),
	(347, 2, 54, '兴安县'),
	(348, 2, 54, '永福县'),
	(349, 2, 54, '灌阳县'),
	(350, 2, 54, '龙胜各县自治区'),
	(351, 2, 54, '资源县'),
	(352, 2, 54, '平乐县'),
	(353, 2, 54, '荔蒲县'),
	(354, 2, 115, '万秀区'),
	(355, 2, 115, '蝶山区'),
	(356, 2, 115, '市郊区'),
	(357, 2, 115, '苍梧县'),
	(358, 2, 115, '藤县'),
	(359, 2, 115, '蒙山县'),
	(360, 2, 115, '岑溪市'),
	(361, 2, 116, '海城区'),
	(362, 2, 116, '银海区'),
	(363, 2, 116, '铁山港区'),
	(364, 2, 116, '合浦县'),
	(365, 2, 117, '港口区'),
	(366, 2, 117, '防城区'),
	(367, 2, 117, '上思县'),
	(368, 2, 117, '东兴市'),
	(369, 2, 118, '钦南区'),
	(370, 2, 118, '钦北区'),
	(371, 2, 118, '浦北县'),
	(372, 2, 118, '灵山县'),
	(373, 2, 119, '港北区'),
	(374, 2, 119, '港南区'),
	(375, 2, 119, '覃塘区'),
	(376, 2, 119, '平南县'),
	(377, 2, 119, '桂平市'),
	(378, 2, 120, '玉州区'),
	(379, 2, 120, '容县'),
	(380, 2, 120, '陆川县'),
	(381, 2, 120, '博白县'),
	(382, 2, 120, '兴县'),
	(383, 2, 120, '北流市'),
	(384, 2, 121, '八步区'),
	(385, 2, 121, '昭平县'),
	(386, 2, 121, '钟山县'),
	(387, 2, 122, '右江区'),
	(388, 2, 122, '田阳县'),
	(389, 2, 122, '田东县'),
	(390, 2, 122, '平果县'),
	(391, 2, 122, '德保县'),
	(392, 2, 122, '靖西县'),
	(393, 2, 122, '那坡县'),
	(394, 2, 122, '凌云县'),
	(395, 2, 122, '乐县'),
	(396, 2, 122, '田林县'),
	(397, 2, 122, '西林县'),
	(398, 10, 9, '上城区'),
	(399, 10, 9, '下城区'),
	(400, 10, 9, '江干区'),
	(401, 10, 9, '西湖区'),
	(402, 10, 9, '滨江区'),
	(403, 10, 9, '桐庐县'),
	(404, 10, 9, '淳安县'),
	(405, 10, 9, '萧山市'),
	(406, 10, 9, '建德市'),
	(407, 10, 9, '富阳市'),
	(408, 10, 9, '余杭市'),
	(409, 10, 9, '临安市'),
	(410, 10, 59, '婺城区'),
	(411, 10, 59, '金华县'),
	(412, 10, 59, '武义县'),
	(413, 10, 59, '浦江县'),
	(414, 10, 59, '磐安县'),
	(415, 10, 59, '兰溪市'),
	(416, 10, 59, '义乌市'),
	(417, 10, 59, '东阳市'),
	(418, 10, 59, '永康市'),
	(419, 10, 81, '海曙区'),
	(420, 10, 81, '江东区'),
	(421, 10, 81, '江北区'),
	(422, 10, 81, '北仑区'),
	(423, 10, 81, '镇海区'),
	(424, 10, 81, '象山县'),
	(425, 10, 81, '宁海县'),
	(426, 10, 81, '鄞县'),
	(427, 10, 81, '余姚市'),
	(428, 10, 81, '慈溪市'),
	(429, 10, 81, '奉化市'),
	(430, 10, 82, '椒江区'),
	(431, 10, 82, '黄岩区'),
	(432, 10, 82, '路桥区'),
	(433, 10, 82, '玉环县'),
	(434, 10, 82, '三门县'),
	(435, 10, 82, '天台县'),
	(436, 10, 82, '仙居县'),
	(437, 10, 82, '温岭市'),
	(438, 10, 82, '临海市'),
	(439, 10, 83, '柯城区'),
	(440, 10, 83, '衢县'),
	(441, 10, 83, '常山县'),
	(442, 10, 83, '开化县'),
	(443, 10, 83, '龙游县'),
	(444, 10, 83, '江山市'),
	(445, 10, 84, '鹿城区'),
	(446, 10, 84, '龙湾区'),
	(447, 10, 84, '瓯海区'),
	(448, 10, 84, '洞头县'),
	(449, 10, 84, '永嘉县'),
	(450, 10, 84, '平阳县'),
	(451, 10, 84, '苍南县'),
	(452, 10, 84, '文成县'),
	(453, 10, 84, '泰顺县'),
	(454, 10, 84, '瑞安市'),
	(455, 10, 84, '乐清市'),
	(456, 10, 106, '秀城区'),
	(457, 10, 106, '郊区'),
	(458, 10, 106, '嘉善县'),
	(459, 10, 106, '海盐县'),
	(460, 10, 106, '海宁市'),
	(461, 10, 106, '平湖市'),
	(462, 10, 106, '桐乡市'),
	(463, 10, 123, '越城区'),
	(464, 10, 123, '绍兴县'),
	(465, 10, 123, '新昌县'),
	(466, 10, 123, '诸暨市'),
	(467, 10, 123, '上虞市'),
	(468, 10, 123, '嵊州市'),
	(469, 10, 124, '定海区'),
	(470, 10, 124, '普陀区'),
	(471, 10, 124, '岱山县'),
	(472, 10, 124, '嵊泗县'),
	(473, 10, 125, '莲都区'),
	(474, 10, 125, '龙泉市'),
	(475, 10, 125, '青田县'),
	(476, 10, 125, '云和县'),
	(477, 10, 125, '庆元县'),
	(478, 10, 125, '缙云县'),
	(479, 10, 125, '遂昌县'),
	(480, 10, 125, '松阳县'),
	(481, 9, 16, '东市区'),
	(482, 9, 16, '中市区'),
	(483, 9, 16, '西市区'),
	(484, 9, 16, '郊区'),
	(485, 9, 16, '长丰县'),
	(486, 9, 16, '肥东县'),
	(487, 9, 16, '肥西县'),
	(488, 9, 126, '镜湖区'),
	(489, 9, 126, '马塘区'),
	(490, 9, 126, '新芜区'),
	(491, 9, 126, '鸠江区'),
	(492, 9, 126, '芜湖县'),
	(493, 9, 126, '繁昌县'),
	(494, 9, 126, '南陵县'),
	(495, 9, 127, '东市区'),
	(496, 9, 127, '中市区'),
	(497, 9, 127, '西市区'),
	(498, 9, 127, '郊区'),
	(499, 9, 127, '怀远县'),
	(500, 9, 127, '五河县'),
	(501, 9, 127, '固镇县'),
	(502, 11, 17, '玄武区'),
	(503, 11, 17, '白下区'),
	(504, 11, 17, '秦淮区'),
	(505, 11, 17, '建邺区'),
	(506, 11, 17, '鼓楼区'),
	(507, 11, 17, '下关区'),
	(508, 11, 17, '浦口区'),
	(509, 11, 17, '栖霞区'),
	(510, 11, 17, '雨花台区'),
	(511, 11, 17, '江宁区'),
	(512, 11, 17, '六合区'),
	(513, 11, 17, '溧水县'),
	(514, 11, 17, '高淳县'),
	(515, 11, 40, '沧浪区'),
	(516, 11, 40, '平江区'),
	(517, 11, 40, '金阊区'),
	(518, 11, 40, '郊区'),
	(519, 11, 40, '常熟市'),
	(520, 11, 40, '张家港市'),
	(521, 11, 40, '昆山市'),
	(522, 11, 40, '吴江市'),
	(523, 11, 40, '太仓市'),
	(524, 11, 40, '吴县市'),
	(525, 11, 86, '崇川区'),
	(526, 11, 86, '港闸区'),
	(527, 11, 86, '海安县'),
	(528, 11, 86, '如东县'),
	(529, 11, 86, '启东市'),
	(530, 11, 86, '如皋市'),
	(531, 11, 86, '通州市'),
	(532, 11, 86, '海门市'),
	(533, 11, 87, '连云区'),
	(534, 11, 87, '云台区'),
	(535, 11, 87, '新浦区'),
	(536, 11, 87, '海州区'),
	(537, 11, 87, '赣榆县'),
	(538, 11, 87, '东海县'),
	(539, 11, 87, '灌云县'),
	(540, 11, 87, '灌南县'),
	(541, 11, 88, '天宁区'),
	(542, 11, 88, '钟楼区'),
	(543, 11, 88, '戚墅堰区'),
	(544, 11, 40, '郊区'),
	(545, 11, 88, '溧阳市'),
	(546, 11, 88, '金坛市'),
	(547, 11, 88, '武进市'),
	(548, 11, 89, '广陵区'),
	(549, 11, 89, '郊区'),
	(550, 11, 89, '宝应县'),
	(551, 11, 89, '邗江县'),
	(552, 11, 89, '仪征市'),
	(553, 11, 89, '高邮市'),
	(554, 11, 89, '江都市'),
	(555, 11, 94, '崇安区'),
	(556, 11, 94, '南长区'),
	(557, 11, 94, '北塘区'),
	(558, 11, 94, '郊区'),
	(559, 11, 94, '马山区'),
	(560, 11, 94, '江阴市'),
	(561, 11, 94, '宜兴市'),
	(562, 11, 94, '锡山市'),
	(563, 4, 19, '鼓楼区'),
	(564, 4, 19, '台江区'),
	(565, 4, 19, '仓山区'),
	(566, 4, 19, '马尾区'),
	(567, 4, 19, '晋安区'),
	(568, 4, 19, '闽侯县'),
	(569, 4, 19, '连江县'),
	(570, 4, 19, '罗源县'),
	(571, 4, 19, '闽清县'),
	(572, 4, 19, '永泰县'),
	(573, 4, 19, '平潭县'),
	(574, 4, 19, '福清市'),
	(575, 4, 19, '长乐市'),
	(576, 4, 25, '梅列区'),
	(577, 4, 25, '三元区'),
	(578, 4, 25, '明溪县'),
	(579, 4, 25, '清流县'),
	(580, 4, 25, '宁化县'),
	(581, 4, 25, '大田县'),
	(582, 4, 25, '尤溪县'),
	(583, 4, 25, '沙县'),
	(584, 4, 25, '将乐县'),
	(585, 4, 25, '泰宁县'),
	(586, 4, 25, '建宁县'),
	(587, 4, 25, '永安市'),
	(588, 4, 105, '城厢区'),
	(589, 4, 105, '涵江区'),
	(590, 4, 105, '荔城区'),
	(591, 4, 105, '秀屿区'),
	(592, 4, 105, '仙游县'),
	(593, 4, 128, '鲤城区'),
	(594, 4, 128, '丰泽区'),
	(595, 4, 128, '洛江区'),
	(596, 4, 128, '泉港区'),
	(597, 4, 128, '惠安县'),
	(598, 4, 128, '安溪县'),
	(599, 4, 128, '永春县'),
	(600, 4, 128, '德化县'),
	(601, 4, 128, '金门县'),
	(602, 4, 128, '石狮市'),
	(603, 4, 128, '晋江市'),
	(604, 4, 128, '南安市'),
	(605, 4, 129, '芗城区'),
	(606, 4, 129, '龙文区'),
	(607, 4, 129, '云霄县'),
	(608, 4, 129, '漳浦县'),
	(609, 4, 129, '诏安县'),
	(610, 4, 129, '长泰县'),
	(611, 4, 129, '东山县'),
	(612, 4, 129, '南靖县'),
	(613, 4, 129, '平和县'),
	(614, 4, 129, '华安县'),
	(615, 4, 129, '龙海市'),
	(616, 4, 130, '新罗区'),
	(617, 4, 130, '长汀县'),
	(618, 4, 130, '永定县'),
	(619, 4, 130, '上杭县'),
	(620, 4, 130, '武平县'),
	(621, 4, 130, '连城县'),
	(622, 4, 130, '漳平市'),
	(623, 4, 131, '延平区'),
	(624, 4, 131, '顺昌县'),
	(625, 4, 131, '浦城县'),
	(626, 4, 131, '光泽县'),
	(627, 4, 131, '松溪县'),
	(628, 4, 131, '政和县'),
	(629, 4, 131, '邵武市'),
	(630, 4, 131, '武夷山市'),
	(631, 4, 131, '建瓯市'),
	(632, 4, 131, '建阳市'),
	(633, 18, 24, '长安区'),
	(634, 18, 24, '桥东区'),
	(635, 18, 24, '桥西区'),
	(636, 18, 24, '新华区'),
	(637, 18, 24, '郊区'),
	(638, 18, 24, '井陉矿区'),
	(639, 18, 24, '井陉县'),
	(640, 18, 24, '正定县'),
	(641, 18, 24, '栾城县'),
	(642, 18, 24, '辛集市'),
	(643, 18, 24, '藁城市'),
	(644, 18, 24, '晋州市'),
	(645, 18, 24, '新乐市'),
	(646, 18, 24, '鹿泉市'),
	(647, 20, 21, '南关区'),
	(648, 20, 21, '宽城区'),
	(649, 20, 21, '朝阳区'),
	(650, 20, 21, '二道区'),
	(651, 20, 21, '绿园区'),
	(652, 20, 21, '双阳区'),
	(653, 20, 21, '农安县'),
	(654, 20, 21, '九台市'),
	(655, 20, 21, '榆树市'),
	(656, 20, 21, '德惠市'),
	(657, 20, 132, '昌邑区'),
	(658, 20, 132, '龙潭区'),
	(659, 20, 132, '船营区'),
	(660, 20, 132, '丰满区'),
	(661, 20, 132, '永吉县'),
	(662, 20, 132, '蛟河市'),
	(663, 20, 132, '桦甸市'),
	(664, 20, 132, '舒兰市'),
	(665, 20, 132, '磐石市'),
	(666, 7, 22, '龙泉驿区'),
	(667, 7, 22, '青白江区'),
	(668, 7, 22, '金堂县'),
	(669, 7, 22, '双流县'),
	(670, 7, 22, '温江县'),
	(671, 7, 22, '新都县'),
	(672, 7, 22, '大邑县'),
	(673, 7, 22, '蒲江县'),
	(674, 7, 22, '新津县'),
	(675, 7, 22, '都江堰市'),
	(676, 7, 22, '彭州市'),
	(677, 7, 22, '邛崃市'),
	(678, 7, 22, '崇州市'),
	(679, 7, 85, '涪城区'),
	(680, 7, 85, '游仙区'),
	(681, 7, 85, '三台县'),
	(682, 7, 85, '盐亭县'),
	(683, 7, 85, '安县'),
	(684, 7, 85, '梓潼县'),
	(685, 7, 85, '北川县'),
	(686, 7, 85, '平武县'),
	(687, 7, 85, '江油市'),
	(688, 7, 101, '顺庆区'),
	(689, 7, 101, '高坪区'),
	(690, 7, 101, '嘉陵区'),
	(691, 7, 101, '南部县'),
	(692, 7, 101, '营山县'),
	(693, 7, 101, '蓬安县'),
	(694, 7, 101, '仪陇县'),
	(695, 7, 101, '西充县'),
	(696, 7, 101, '阆中市'),
	(697, 6, 23, '芙蓉区'),
	(698, 6, 23, '天心区'),
	(699, 6, 23, '岳麓区'),
	(700, 6, 23, '开福区'),
	(701, 6, 23, '雨花区'),
	(702, 6, 23, '长沙县'),
	(703, 6, 23, '望城县'),
	(704, 6, 23, '宁乡县'),
	(705, 6, 23, '浏阳市'),
	(706, 6, 41, '荷塘区'),
	(707, 6, 41, '芦淞区'),
	(708, 6, 41, '石峰区'),
	(709, 6, 41, '天元区'),
	(710, 6, 41, '株洲县'),
	(711, 6, 41, '攸县'),
	(712, 6, 41, '茶陵县'),
	(713, 6, 41, '炎陵县'),
	(714, 6, 41, '醴陵市'),
	(715, 6, 133, '永定区'),
	(716, 6, 133, '武陵源区'),
	(717, 6, 133, '慈利县'),
	(718, 6, 133, '桑植县'),
	(719, 6, 134, '北湖区'),
	(720, 6, 134, '苏仙区'),
	(721, 6, 134, '桂阳县'),
	(722, 6, 134, '宜章县'),
	(723, 6, 134, '永兴县'),
	(724, 6, 134, '嘉禾县'),
	(725, 6, 134, '临武县'),
	(726, 6, 134, '汝城县'),
	(727, 6, 134, '桂东县'),
	(728, 6, 134, '安仁县'),
	(729, 6, 134, '资兴市'),
	(730, 14, 26, '临潼区'),
	(731, 14, 26, '长安县'),
	(732, 14, 26, '蓝田县'),
	(733, 14, 26, '周至县'),
	(734, 14, 26, '户县'),
	(735, 14, 26, '高陵县'),
	(736, 14, 66, '渭滨区'),
	(737, 14, 66, '金台区'),
	(738, 14, 66, '宝鸡县'),
	(739, 14, 66, '凤翔县'),
	(740, 14, 66, '岐山县'),
	(741, 14, 66, '扶风县'),
	(742, 14, 66, '眉县'),
	(743, 14, 66, '陇县'),
	(744, 14, 66, '千阳县'),
	(745, 14, 66, '麟游县'),
	(746, 14, 66, '凤县'),
	(747, 14, 66, '太白县'),
	(748, 13, 27, '江岸区'),
	(749, 13, 27, '江岸区'),
	(750, 13, 27, '蔡甸区'),
	(751, 13, 27, '江夏区'),
	(752, 13, 27, '黄陂区'),
	(753, 13, 27, '新洲区'),
	(754, 13, 135, '黄石港区'),
	(755, 13, 135, '石灰窑区'),
	(756, 13, 135, '下陆区'),
	(757, 13, 135, '铁山区'),
	(758, 13, 135, '阳新县'),
	(759, 13, 135, '大冶市'),
	(760, 13, 136, '西陵区'),
	(761, 13, 136, '伍家岗区'),
	(762, 13, 136, '点军区'),
	(763, 13, 136, '虎亭区'),
	(764, 13, 136, '宜昌县'),
	(765, 13, 136, '远安县'),
	(766, 13, 136, '兴山县'),
	(767, 13, 136, '秭归县'),
	(768, 13, 136, '宜都市'),
	(769, 13, 136, '当阳市'),
	(770, 13, 136, '枝江市'),
	(771, 13, 137, '梁子湖区'),
	(772, 13, 137, '华容区'),
	(773, 13, 137, '鄂城区'),
	(774, 13, 139, '襄城区'),
	(775, 13, 139, '樊城区'),
	(776, 13, 139, '襄阳县'),
	(777, 13, 139, '南漳县'),
	(778, 13, 139, '宜城市'),
	(779, 19, 42, '新城子区'),
	(780, 19, 42, '辽中县'),
	(781, 19, 42, '康平县'),
	(782, 19, 42, '新民市'),
	(783, 19, 44, '中山区'),
	(784, 19, 44, '西岗区'),
	(785, 19, 44, '沙河口区'),
	(786, 19, 44, '甘井子区'),
	(787, 19, 44, '旅顺口区'),
	(788, 19, 44, '金州区'),
	(789, 19, 44, '长海县'),
	(790, 19, 44, '瓦房店市'),
	(791, 19, 44, '普兰店市'),
	(792, 19, 44, '庄河市'),
	(793, 19, 102, '新抚区'),
	(794, 19, 102, '露天区'),
	(795, 19, 102, '望花区'),
	(796, 19, 102, '顺城区'),
	(797, 19, 102, '抚顺县'),
	(798, 19, 103, '古塔区'),
	(799, 19, 103, '凌河区'),
	(800, 19, 103, '太和区'),
	(801, 19, 103, '黑山县'),
	(802, 19, 103, '义县'),
	(803, 19, 103, '凌海市'),
	(804, 19, 103, '北宁市'),
	(805, 19, 141, '平山区'),
	(806, 19, 141, '溪湖区'),
	(807, 19, 141, '明山区'),
	(808, 19, 141, '南芬区'),
	(809, 19, 142, '站前区'),
	(810, 19, 142, '站前区'),
	(811, 19, 142, '西市区'),
	(812, 19, 142, '鲅鱼圈区'),
	(813, 19, 142, '老边区'),
	(814, 19, 142, '盖州市'),
	(815, 19, 142, '大石桥市'),
	(816, 19, 143, '元宝区'),
	(817, 19, 143, '振兴区'),
	(818, 19, 143, '振安区'),
	(819, 19, 143, '东港市'),
	(820, 19, 143, '凤城市'),
	(821, 19, 144, '海州区'),
	(822, 19, 144, '新邱区'),
	(823, 19, 144, '太平区'),
	(824, 19, 144, '清河门区'),
	(825, 19, 144, '细河区'),
	(826, 19, 144, '彰武县'),
	(827, 19, 145, '白塔区'),
	(828, 19, 145, '文圣区'),
	(829, 19, 145, '宏伟区'),
	(830, 19, 145, '弓长岭区'),
	(831, 19, 145, '太子河区'),
	(832, 19, 145, '辽阳县'),
	(833, 19, 145, '灯塔市'),
	(834, 16, 50, '小店区'),
	(835, 16, 50, '迎泽区'),
	(836, 16, 50, '杏花岭区'),
	(837, 16, 50, '尖草坪区'),
	(838, 16, 50, '万柏林区'),
	(839, 16, 50, '晋源区'),
	(840, 16, 50, '清徐县'),
	(841, 16, 65, '城区'),
	(842, 16, 67, '运城市'),
	(843, 16, 67, '永济市'),
	(844, 16, 67, '河津市'),
	(845, 16, 67, '芮城县'),
	(846, 16, 67, '临猗县'),
	(847, 16, 67, '万荣县'),
	(848, 16, 67, '新绛县'),
	(849, 16, 67, '稷山县'),
	(850, 16, 67, '闻喜县'),
	(851, 16, 67, '夏县'),
	(852, 16, 68, '绛县'),
	(853, 16, 67, '平陆县'),
	(854, 16, 67, '垣曲县'),
	(855, 16, 68, '城区'),
	(856, 16, 68, '沁水县'),
	(857, 16, 68, '阳城县'),
	(858, 16, 69, '临汾市'),
	(859, 16, 69, '侯马市'),
	(860, 17, 51, '中原区'),
	(861, 17, 51, '二七区'),
	(862, 17, 51, '管城回族区'),
	(863, 17, 51, '金水区'),
	(864, 17, 51, '上街区'),
	(865, 17, 51, '邙山区'),
	(866, 17, 51, '中牟县'),
	(867, 17, 51, '巩义市'),
	(868, 17, 51, '荥阳市'),
	(869, 17, 51, '新密市'),
	(870, 17, 51, '新郑市'),
	(871, 17, 51, '登封市'),
	(872, 17, 146, '龙亭区'),
	(873, 17, 146, '顺河回族区'),
	(874, 17, 146, '鼓楼区'),
	(875, 17, 146, '南关区'),
	(876, 17, 146, '郊区'),
	(877, 17, 146, '杞县'),
	(878, 17, 146, '通许县'),
	(879, 17, 146, '尉氏县'),
	(880, 17, 146, '开封县'),
	(881, 17, 146, '兰考县'),
	(882, 17, 147, '老城区'),
	(883, 17, 147, '西工区'),
	(884, 17, 147, '廛河回族区'),
	(885, 17, 147, '涧西区'),
	(886, 17, 147, '吉利区'),
	(887, 17, 147, '郊区'),
	(888, 17, 147, '孟津县'),
	(889, 17, 147, '新安县'),
	(890, 17, 147, '栾川县'),
	(891, 17, 147, '宜阳县'),
	(892, 17, 147, '洛宁县'),
	(893, 17, 147, '伊川县'),
	(894, 17, 147, '偃师市'),
	(895, 17, 148, '红旗区'),
	(896, 17, 148, '新华区'),
	(897, 17, 148, '北站区'),
	(898, 17, 148, '郊区'),
	(899, 17, 148, '新乡县'),
	(900, 17, 148, '获嘉县'),
	(901, 17, 148, '原阳县'),
	(902, 17, 148, '延津县'),
	(903, 17, 148, '封丘县'),
	(904, 17, 148, '长垣县'),
	(905, 17, 148, '卫辉市'),
	(906, 17, 148, '辉县市'),
	(907, 17, 149, '解放区'),
	(908, 17, 149, '中站区'),
	(909, 17, 149, '马村区'),
	(910, 17, 149, '山阳区'),
	(911, 17, 149, '修武县'),
	(912, 17, 149, '博爱县'),
	(913, 17, 149, '武陟县'),
	(914, 17, 149, '温县'),
	(915, 17, 149, '沁阳市'),
	(916, 17, 149, '孟州市'),
	(917, 17, 150, '魏都区'),
	(918, 17, 150, '许昌县'),
	(919, 17, 150, '鄢陵县'),
	(920, 17, 150, '襄城县'),
	(921, 17, 150, '禹州市'),
	(922, 17, 150, '长葛市'),
	(923, 17, 151, '梁园区'),
	(924, 17, 151, '睢阳区'),
	(925, 17, 151, '民权县'),
	(926, 17, 151, '睢县'),
	(927, 17, 151, '宁陵县'),
	(928, 17, 151, '柘城县'),
	(929, 17, 151, '虞城县'),
	(930, 17, 151, '夏邑县'),
	(931, 17, 151, '永城市'),
	(932, 17, 152, '周口市'),
	(933, 17, 152, '项城市'),
	(934, 17, 152, '扶沟县'),
	(935, 17, 152, '西华县'),
	(936, 17, 152, '商水县'),
	(937, 17, 152, '太康县'),
	(938, 17, 152, '鹿邑县'),
	(939, 17, 152, '郸城县'),
	(940, 17, 152, '淮阳县'),
	(941, 17, 152, '沈丘县'),
	(942, 12, 64, '市南区'),
	(943, 12, 64, '市北区'),
	(944, 12, 64, '四方区'),
	(945, 12, 64, '黄岛区'),
	(946, 12, 64, '崂山区'),
	(947, 12, 64, '李沧区'),
	(948, 12, 64, '城阳区'),
	(949, 12, 64, '胶州市'),
	(950, 12, 64, '即墨市'),
	(951, 12, 64, '平度市'),
	(952, 12, 64, '胶南市'),
	(953, 12, 64, '莱西市'),
	(954, 12, 53, '历下区'),
	(955, 12, 53, '市中区'),
	(956, 12, 53, '天桥区'),
	(957, 12, 53, '历城区'),
	(958, 12, 53, '长清县'),
	(960, 12, 53, '济阳县'),
	(961, 12, 53, '商河县'),
	(962, 12, 53, '章丘市'),
	(963, 12, 153, '淄川区'),
	(964, 12, 153, '张店区'),
	(965, 12, 153, '博山区'),
	(966, 12, 153, '临淄区'),
	(967, 12, 153, '周村区'),
	(968, 12, 153, '桓台县'),
	(969, 12, 153, '高青县'),
	(970, 12, 153, '沂源县'),
	(971, 12, 154, '市中区'),
	(972, 12, 154, '薛城区'),
	(973, 12, 154, '峄城区'),
	(974, 12, 154, '台儿庄区'),
	(975, 12, 154, '山亭区'),
	(976, 12, 154, '滕州市'),
	(977, 12, 155, '芝罘区'),
	(978, 12, 155, '福山区'),
	(979, 12, 155, '牟平区'),
	(980, 12, 155, '莱山区'),
	(981, 12, 155, '长岛县'),
	(982, 12, 155, '龙口市'),
	(983, 12, 155, '莱阳市'),
	(984, 12, 155, '莱州市'),
	(985, 12, 155, '蓬莱市'),
	(986, 12, 155, '招远市'),
	(987, 12, 155, '栖霞市'),
	(988, 12, 155, '海阳市'),
	(989, 12, 156, '潍城区'),
	(990, 12, 156, '寒亭区'),
	(991, 12, 156, '坊子区'),
	(992, 12, 156, '奎文区'),
	(993, 12, 156, '临朐县'),
	(994, 12, 156, '昌乐县'),
	(995, 12, 156, '青州市'),
	(996, 12, 156, '诸城市'),
	(997, 12, 157, '环翠区'),
	(998, 12, 157, '文登市'),
	(999, 12, 157, '荣成市'),
	(1000, 12, 158, '兰山区'),
	(1001, 12, 158, '罗庄区'),
	(1002, 12, 158, '河东区'),
	(1003, 12, 158, '沂南县'),
	(1004, 12, 158, '郯城县'),
	(1005, 12, 158, '沂水县'),
	(1006, 12, 158, '苍山县'),
	(1008, 12, 158, '费县'),
	(1009, 12, 158, '平邑县'),
	(1010, 24, 72, '新城区'),
	(1011, 24, 72, '回民区'),
	(1012, 24, 72, '玉泉区'),
	(1013, 24, 72, '清水河县'),
	(1014, 24, 72, '武川县'),
	(1015, 24, 73, '东河区'),
	(1016, 24, 73, '昆都伦区'),
	(1017, 24, 73, '青山区'),
	(1018, 24, 73, '固阳县'),
	(1019, 26, 74, '天山区'),
	(1020, 26, 74, '新市区'),
	(1021, 26, 74, '东山区'),
	(1022, 26, 74, '乌鲁木齐县'),
	(1023, 25, 75, '城关区'),
	(1024, 25, 76, '昌都县'),
	(1025, 8, 90, '五华区'),
	(1026, 8, 90, '盘龙区'),
	(1027, 8, 90, '官渡区'),
	(1028, 8, 90, '西山区'),
	(1029, 8, 90, '东川区'),
	(1030, 8, 90, '呈贡县'),
	(1031, 8, 90, '晋宁县'),
	(1032, 8, 90, '富民县'),
	(1033, 8, 90, '宜良县'),
	(1034, 8, 90, '嵩明县'),
	(1035, 8, 90, '安宁市'),
	(1036, 8, 91, '丽江纳西族自治县'),
	(1037, 8, 91, '永胜县'),
	(1038, 8, 91, '华坪县'),
	(1039, 21, 95, '道里区'),
	(1040, 21, 95, '南岗区'),
	(1041, 21, 95, '道外区'),
	(1042, 21, 95, '松北区'),
	(1043, 21, 95, '香坊区'),
	(1044, 21, 95, '阿成区'),
	(1045, 21, 95, '平房区'),
	(1046, 21, 95, '呼兰区'),
	(1047, 21, 95, '依兰县'),
	(1048, 21, 95, '方正县'),
	(1049, 21, 95, '宾县'),
	(1050, 21, 95, '巴彦县'),
	(1051, 21, 95, '木兰县'),
	(1052, 21, 95, '通河县'),
	(1053, 21, 95, '双城市'),
	(1054, 21, 95, '尚志市'),
	(1055, 21, 95, '五常市'),
	(1056, 21, 159, '伊春区'),
	(1057, 21, 159, '伊春区'),
	(1058, 21, 159, '南岔区'),
	(1059, 21, 159, '友好区'),
	(1060, 21, 159, '西林区'),
	(1061, 21, 159, '翠峦区'),
	(1062, 21, 159, '新青区'),
	(1063, 21, 159, '美溪区'),
	(1064, 21, 159, '金山屯区'),
	(1065, 21, 159, '五营区'),
	(1066, 21, 159, '乌马河区'),
	(1067, 21, 159, '汤旺河区'),
	(1068, 21, 159, '带岭区'),
	(1069, 21, 159, '乌伊岭区'),
	(1070, 21, 159, '红星区'),
	(1071, 21, 159, '上甘岭区'),
	(1072, 21, 159, '嘉荫县'),
	(1073, 21, 159, '铁力市'),
	(1074, 21, 160, '东安区'),
	(1075, 21, 160, '阳明区'),
	(1076, 21, 160, '爱民区'),
	(1077, 21, 160, '西安区'),
	(1078, 21, 160, '东宁县'),
	(1079, 21, 160, '林口县'),
	(1080, 21, 160, '绥芬河市'),
	(1081, 21, 160, '海林市'),
	(1082, 21, 160, '宁安市'),
	(1083, 21, 160, '穆棱市'),
	(1084, 15, 97, '城关区'),
	(1085, 15, 97, '七里河区'),
	(1086, 15, 97, '西固区'),
	(1087, 15, 97, '安宁区'),
	(1088, 15, 97, '红古区'),
	(1089, 15, 97, '永登县'),
	(1090, 15, 97, '皋兰县'),
	(1091, 15, 97, '榆中县'),
	(1092, 15, 161, '金川区'),
	(1093, 15, 161, '永昌县'),
	(1094, 15, 162, '白银区'),
	(1095, 15, 162, '平川区'),
	(1096, 15, 162, '靖远县'),
	(1097, 15, 162, '会宁县'),
	(1098, 15, 162, '景泰县'),
	(1099, 15, 163, '秦城区'),
	(1100, 15, 163, '北道区'),
	(1101, 15, 163, '清水县'),
	(1102, 15, 163, '秦安县'),
	(1103, 15, 163, '甘谷县'),
	(1104, 15, 163, '武山县'),
	(1105, 22, 98, '兴庆区'),
	(1106, 22, 98, '西夏区'),
	(1107, 22, 98, '金凤区'),
	(1108, 22, 98, '永宁县'),
	(1109, 22, 98, '贺兰县'),
	(1110, 23, 99, '城东区'),
	(1111, 23, 99, '城中区'),
	(1112, 23, 99, '城西区'),
	(1113, 23, 99, '城北区'),
	(1114, 22, 164, '大武口区'),
	(1115, 22, 164, '惠农区'),
	(1116, 22, 164, '平罗县'),
	(1117, 29, 7, '崇文区'),
	(1118, 29, 7, '宣武区'),
	(1119, 29, 7, '顺义区'),
	(1120, 29, 7, '大兴区'),
	(1121, 29, 7, '平谷区'),
	(1122, 29, 7, '怀柔区'),
	(1123, 29, 7, '密云县'),
	(1124, 29, 7, '延庆县'),
	(1125, 29, 8, '嘉定区'),
	(1126, 29, 8, '南汇区'),
	(1127, 29, 8, '金山区'),
	(1128, 29, 8, '青浦区'),
	(1129, 29, 8, '宝山区'),
	(1130, 29, 8, '黄浦区'),
	(1131, 29, 8, '虹口区'),
	(1132, 29, 8, '闸北区'),
	(1133, 29, 8, '卢湾区'),
	(1134, 29, 8, '奉贤区'),
	(1135, 29, 8, '崇明县'),
	(1136, 29, 29, '万州区'),
	(1137, 29, 29, '涪陵区'),
	(1138, 29, 29, '渝中区'),
	(1139, 29, 29, '大渡口区'),
	(1140, 29, 29, '江北区'),
	(1141, 29, 29, '沙坪坝区'),
	(1142, 29, 29, '九龙坡区'),
	(1143, 29, 29, '南岸区'),
	(1144, 29, 29, '北碚区'),
	(1145, 29, 29, '万盛区'),
	(1146, 29, 29, '双桥区'),
	(1147, 29, 29, '渝北区'),
	(1148, 29, 29, '巴南区'),
	(1149, 29, 29, '荣昌县'),
	(1150, 29, 29, '城口县'),
	(1151, 29, 29, '丰都县'),
	(1152, 29, 29, '武隆县'),
	(1153, 29, 29, '云阳县'),
	(1154, 29, 29, '江津市'),
	(1155, 29, 29, '合川市'),
	(1156, 29, 29, '永川市'),
	(1157, 29, 29, '南川市'),
	(1158, 29, 43, '和平区'),
	(1159, 29, 43, '河东区'),
	(1160, 29, 43, '河西区'),
	(1161, 29, 43, '南开区'),
	(1162, 29, 43, '河北区'),
	(1163, 29, 43, '塘沽区'),
	(1164, 29, 43, '汉沽区'),
	(1165, 29, 43, '大港区'),
	(1166, 29, 43, '东丽区'),
	(1167, 29, 43, '西青区'),
	(1168, 29, 43, '武清区'),
	(1169, 29, 43, '宝坻区'),
	(1170, 29, 43, '宁河县'),
	(1171, 29, 43, '静海县'),
	(1172, 29, 43, '蓟县'),
	(1173, 30, 30, '南山区'),
	(1174, 30, 30, '盐田区'),
	(1175, 30, 32, '海沧区'),
	(1176, 30, 32, '湖里区'),
	(1177, 30, 32, '同安区'),
	(1178, 30, 32, '翔安区'),
	(1179, 30, 34, '琼海市'),
	(1180, 30, 34, '儋州市'),
	(1181, 30, 34, '五指山市'),
	(1182, 30, 34, '文昌市'),
	(1183, 30, 34, '万宁市'),
	(1184, 30, 34, '东方市'),
	(1185, 30, 34, '定安县'),
	(1186, 30, 34, '屯昌县'),
	(1187, 30, 34, '澄迈县'),
	(1188, 30, 34, '临高县'),
	(1189, 30, 35, '喀什市'),
	(1190, 30, 35, '疏附县'),
	(1191, 30, 35, '疏勒县'),
	(1192, 30, 35, '泽普县'),
	(1193, 30, 35, '叶城县'),
	(1194, 30, 35, '巴楚县'),
	(1195, 18, 165, '海港区'),
	(1196, 18, 165, '山海关区'),
	(1197, 18, 165, '北戴河区'),
	(1198, 18, 165, '青龙满族自治县'),
	(1199, 18, 165, '昌黎县'),
	(1200, 18, 165, '抚宁县'),
	(1201, 18, 165, '卢龙县'),
	(1202, 18, 166, '邯山区'),
	(1203, 18, 166, '丛台区'),
	(1204, 18, 166, '复兴区'),
	(1205, 18, 166, '峰峰矿区'),
	(1206, 18, 166, '邯郸县'),
	(1207, 18, 166, '临漳县'),
	(1208, 18, 166, '成安县'),
	(1209, 18, 166, '大名县'),
	(1210, 18, 166, '涉县'),
	(1211, 18, 166, '磁县'),
	(1212, 18, 166, '肥乡县'),
	(1213, 18, 166, '永年县'),
	(1214, 18, 166, '邱县'),
	(1215, 18, 166, '鸡泽县'),
	(1216, 18, 166, '广平县'),
	(1217, 18, 166, '馆陶县'),
	(1218, 18, 166, '曲周县'),
	(1219, 18, 166, '武安市'),
	(1220, 18, 167, '新市区'),
	(1221, 18, 167, '北市区'),
	(1222, 18, 167, '南市区'),
	(1223, 18, 167, '徐水县'),
	(1224, 18, 167, '定兴县'),
	(1225, 18, 167, '望都县'),
	(1226, 18, 167, '安新县'),
	(1227, 18, 167, '顺平县'),
	(1228, 18, 167, '博野县'),
	(1229, 18, 167, '涿州市'),
	(1230, 18, 167, '定州市'),
	(1231, 18, 167, '安国市'),
	(1232, 18, 168, '安次区'),
	(1233, 18, 168, '固安县'),
	(1234, 18, 168, '永清县'),
	(1235, 18, 168, '香河县'),
	(1236, 18, 168, '大城县'),
	(1237, 18, 168, '文安县'),
	(1238, 18, 168, '霸州市'),
	(1239, 18, 168, '三河市'),
	(1240, 18, 169, '桥东区'),
	(1241, 18, 169, '桥西区'),
	(1242, 18, 169, '宣化区'),
	(1243, 18, 169, '下花园区'),
	(1244, 18, 169, '宣化县'),
	(1245, 18, 169, '张北县'),
	(1246, 18, 169, '怀安县'),
	(1247, 18, 169, '万全县'),
	(1248, 18, 169, '怀来县'),
	(1249, 18, 169, '涿鹿县'),
	(1250, 18, 169, '赤城县'),
	(1251, 18, 169, '崇礼县'),
	(1252, 18, 170, '新华区'),
	(1253, 18, 170, '运河区'),
	(1254, 18, 170, '沧县'),
	(1255, 18, 170, '青县'),
	(1256, 18, 170, '东光县'),
	(1257, 18, 170, '海兴县'),
	(1258, 18, 170, '盐山县'),
	(1259, 18, 170, '肃宁县'),
	(1260, 18, 170, '南皮县'),
	(1261, 18, 170, '吴桥县'),
	(1262, 18, 170, '献县'),
	(1263, 18, 170, '泊头市'),
	(1264, 18, 170, '任丘市'),
	(1265, 18, 170, '黄骅市'),
	(1266, 18, 170, '河间市'),
	(1267, 19, 171, '铁西区'),
	(1268, 19, 171, '铁东区'),
	(1269, 19, 171, '梨树县'),
	(1270, 19, 171, '双辽市'),
	(1271, 19, 173, '龙山区'),
	(1272, 19, 173, '西安区'),
	(1273, 19, 173, '东丰县'),
	(1274, 19, 173, '东辽县'),
	(1275, 19, 174, '东昌区'),
	(1276, 19, 174, '二道江区'),
	(1277, 19, 174, '通化县'),
	(1278, 19, 174, '辉南县'),
	(1279, 19, 174, '柳河县'),
	(1280, 19, 174, '梅河口市'),
	(1281, 19, 174, '集安市'),
	(1282, 19, 175, '宁江区'),
	(1283, 19, 175, '长岭县'),
	(1284, 19, 175, '乾安县'),
	(1285, 19, 175, '扶余县'),
	(1286, 19, 176, '延吉市'),
	(1287, 19, 176, '图们市'),
	(1288, 19, 176, '敦化市'),
	(1289, 19, 176, '珲春市'),
	(1290, 19, 176, '龙井市'),
	(1291, 19, 176, '和龙市'),
	(1292, 19, 176, '汪清县'),
	(1293, 19, 176, '安图县'),
	(1294, 7, 177, '自流井区'),
	(1295, 7, 177, '贡井区'),
	(1296, 7, 177, '大安区'),
	(1297, 7, 177, '沿滩区'),
	(1298, 7, 177, '荣县'),
	(1299, 7, 177, '富顺县'),
	(1300, 7, 178, '东区'),
	(1301, 7, 178, '西区'),
	(1302, 7, 178, '仁和区'),
	(1303, 7, 178, '米易县'),
	(1304, 7, 178, '盐边县'),
	(1305, 7, 179, '江阳区'),
	(1306, 7, 179, '纳溪区'),
	(1307, 7, 179, '龙马潭区'),
	(1308, 7, 179, '泸县'),
	(1309, 7, 179, '合江县'),
	(1310, 7, 179, '叙永县'),
	(1311, 7, 179, '古蔺县'),
	(1312, 7, 180, '旌阳区'),
	(1313, 7, 180, '中江县'),
	(1314, 7, 180, '罗江县'),
	(1315, 7, 180, '广汉市'),
	(1316, 7, 180, '什邡市'),
	(1317, 7, 180, '绵竹市'),
	(1318, 7, 181, '利州区'),
	(1319, 7, 181, '元坝区'),
	(1320, 7, 181, '朝天区'),
	(1321, 7, 181, '旺苍县'),
	(1322, 7, 181, '青川县'),
	(1323, 7, 182, '市中区'),
	(1324, 7, 182, '东兴区'),
	(1325, 7, 182, '威远县'),
	(1326, 7, 182, '资中县'),
	(1327, 7, 182, '隆昌县'),
	(1328, 7, 183, '市中区'),
	(1329, 7, 183, '沙湾区'),
	(1330, 7, 183, '五通桥区'),
	(1331, 7, 183, '金口河区'),
	(1332, 7, 183, '犍为县'),
	(1333, 7, 183, '夹江县'),
	(1334, 7, 183, '峨眉山市'),
	(1335, 7, 184, '翠屏区'),
	(1336, 7, 184, '宜宾县'),
	(1337, 7, 184, '宜宾县'),
	(1338, 7, 184, '南溪县'),
	(1339, 7, 184, '江安县'),
	(1340, 7, 184, '长宁县'),
	(1341, 7, 184, '高县'),
	(1342, 7, 184, '珙县'),
	(1343, 7, 184, '筠连县'),
	(1344, 7, 184, '兴文县'),
	(1345, 7, 184, '屏山县'),
	(1346, 7, 185, '广安区'),
	(1347, 7, 185, '岳池县'),
	(1348, 7, 185, '武胜县'),
	(1349, 7, 185, '邻水县'),
	(1350, 7, 185, '华莹市'),
	(1351, 7, 186, '资阳市'),
	(1352, 7, 186, '简阳市'),
	(1353, 7, 186, '安岳县'),
	(1354, 7, 186, '乐至县'),
	(1355, 7, 187, '巴中市'),
	(1356, 7, 187, '通江县'),
	(1357, 7, 187, '南江县'),
	(1358, 7, 187, '平昌县'),
	(1359, 9, 188, '大通区'),
	(1360, 9, 188, '田家庵区'),
	(1361, 9, 188, '谢家集区'),
	(1362, 9, 188, '八公山区'),
	(1363, 9, 188, '潘集区'),
	(1364, 9, 188, '凤台县'),
	(1365, 9, 189, '金家庄区'),
	(1366, 9, 189, '花山区'),
	(1367, 9, 189, '雨山区'),
	(1368, 9, 189, '当涂县'),
	(1369, 9, 190, '杜集区'),
	(1370, 9, 190, '相山区'),
	(1371, 9, 190, '烈山区'),
	(1372, 9, 190, '濉溪县'),
	(1373, 9, 191, '铜官山区'),
	(1374, 9, 191, '狮子山区'),
	(1375, 9, 191, '郊区'),
	(1376, 9, 191, '铜陵县'),
	(1377, 9, 192, '迎江区'),
	(1378, 9, 192, '大观区'),
	(1379, 9, 192, '郊区'),
	(1380, 9, 191, '怀宁县'),
	(1381, 9, 192, '枞阳县'),
	(1382, 9, 192, '潜山县'),
	(1383, 9, 192, '太湖县'),
	(1384, 9, 192, '宿松县'),
	(1385, 9, 192, '望江县'),
	(1386, 9, 192, '岳西县'),
	(1387, 9, 192, '桐城市'),
	(1388, 9, 193, '屯溪区'),
	(1389, 9, 192, '黄山区'),
	(1390, 9, 193, '徽州区'),
	(1391, 9, 193, '歙县'),
	(1392, 9, 193, '休宁县'),
	(1393, 9, 193, '黟县'),
	(1394, 9, 193, '祁门县'),
	(1395, 9, 195, '琅琊区'),
	(1396, 9, 195, '南谯区'),
	(1397, 9, 195, '来安县'),
	(1398, 9, 195, '全椒县'),
	(1399, 9, 195, '定远县'),
	(1400, 9, 195, '凤阳县'),
	(1401, 9, 195, '天长市'),
	(1402, 9, 195, '明光市'),
	(1403, 9, 196, '颍州区'),
	(1404, 9, 196, '颍东区'),
	(1405, 9, 196, '颍泉区'),
	(1406, 9, 196, '临泉县'),
	(1407, 9, 196, '太和县'),
	(1408, 9, 196, '阜南县'),
	(1409, 9, 196, '颍上县'),
	(1410, 9, 196, '界首市'),
	(1411, 9, 197, '墉桥区'),
	(1412, 9, 197, '砀山县'),
	(1413, 9, 197, '萧县'),
	(1414, 9, 197, '灵璧县'),
	(1415, 9, 197, '泗县'),
	(1416, 9, 198, '金安区'),
	(1417, 9, 198, '裕安区'),
	(1418, 9, 198, '寿县'),
	(1419, 9, 198, '霍邱县'),
	(1420, 9, 198, '舒城县'),
	(1421, 9, 198, '金寨县'),
	(1422, 9, 198, '霍山县'),
	(1423, 9, 199, '宣州区'),
	(1424, 9, 199, '宁国市'),
	(1425, 9, 199, '郎溪县'),
	(1426, 9, 198, '广德县'),
	(1427, 9, 199, '泾县'),
	(1428, 9, 198, '旌德县'),
	(1429, 9, 199, '绩溪县'),
	(1430, 9, 200, '巢湖区'),
	(1431, 9, 200, '庐江县'),
	(1432, 9, 200, '无为县'),
	(1433, 9, 200, '含山县'),
	(1434, 9, 200, '和县'),
	(1435, 9, 201, '贵池区'),
	(1436, 9, 201, '东至县'),
	(1437, 9, 201, '石台县'),
	(1438, 9, 201, '青阳县'),
	(1439, 6, 202, '雨湖区'),
	(1440, 6, 202, '岳塘区'),
	(1441, 6, 202, '湘潭县'),
	(1442, 6, 202, '湘乡市'),
	(1443, 6, 202, '韶山市'),
	(1444, 6, 203, '江东区'),
	(1445, 6, 203, '城南区'),
	(1446, 6, 203, '城北区'),
	(1447, 6, 203, '郊区'),
	(1448, 6, 203, '南岳区'),
	(1449, 6, 203, '衡阳县'),
	(1450, 6, 203, '衡南县'),
	(1451, 6, 202, '衡山县'),
	(1452, 6, 203, '衡东县'),
	(1453, 6, 203, '祁东县'),
	(1454, 6, 203, '耒阳市'),
	(1455, 6, 203, '常宁市'),
	(1456, 6, 204, '双清区'),
	(1457, 6, 204, '大祥区'),
	(1458, 6, 204, '北塔区'),
	(1459, 6, 204, '邵东县'),
	(1460, 6, 204, '新邵县'),
	(1461, 6, 204, '邵阳县'),
	(1462, 6, 204, '隆回县'),
	(1463, 6, 204, '洞口县'),
	(1464, 6, 204, '绥宁县'),
	(1465, 6, 204, '新宁县'),
	(1466, 6, 204, '城步苗族自治县'),
	(1467, 6, 204, '武冈市'),
	(1468, 6, 205, '岳阳楼区'),
	(1469, 6, 205, '云溪区'),
	(1470, 6, 205, '君山区'),
	(1471, 6, 205, '岳阳县'),
	(1472, 6, 205, '华容县'),
	(1473, 6, 205, '湘阴县'),
	(1474, 6, 205, '平江县'),
	(1475, 6, 204, '汨罗市'),
	(1476, 6, 205, '临湘市'),
	(1477, 6, 206, '武陵区'),
	(1478, 6, 206, '鼎城区'),
	(1479, 6, 206, '安乡县'),
	(1480, 6, 206, '汉寿县'),
	(1481, 6, 206, '澧县'),
	(1482, 6, 206, '临澧县'),
	(1483, 6, 206, '桃源县'),
	(1484, 6, 206, '石门县'),
	(1485, 6, 206, '津市市'),
	(1486, 6, 207, '资阳区'),
	(1487, 6, 207, '赫山区'),
	(1488, 6, 207, '南县'),
	(1489, 6, 206, '桃江县'),
	(1490, 6, 207, '安化县'),
	(1491, 6, 206, '沅江市'),
	(1492, 6, 208, '芝山区'),
	(1493, 6, 208, '冷水滩区'),
	(1494, 6, 208, '祁阳县'),
	(1495, 6, 208, '东安县'),
	(1496, 6, 208, '双牌县'),
	(1497, 6, 208, '道县'),
	(1498, 6, 208, '江永县'),
	(1499, 6, 208, '宁远县'),
	(1500, 6, 208, '蓝山县'),
	(1501, 6, 208, '新田县'),
	(1502, 6, 208, '江华瑶族自治县'),
	(1503, 6, 209, '鹤城区'),
	(1504, 6, 209, '中方县'),
	(1505, 6, 209, '沅陵县'),
	(1506, 6, 209, '辰溪县'),
	(1507, 6, 209, '溆浦县'),
	(1508, 6, 209, '会同县'),
	(1509, 6, 209, '麻阳苗族自治县'),
	(1510, 6, 209, '新晃侗族自治县'),
	(1511, 6, 209, '芷江侗族自治县'),
	(1512, 6, 209, '靖州苗族侗族自治县'),
	(1513, 6, 209, '通道侗族自治县'),
	(1514, 6, 209, '洪江市'),
	(1515, 6, 210, '娄底市'),
	(1516, 6, 210, '冷水江市'),
	(1517, 6, 210, '涟源市'),
	(1518, 6, 210, '双峰县'),
	(1519, 6, 210, '新化县'),
	(1520, 6, 211, '吉首市'),
	(1521, 6, 211, '泸溪县'),
	(1522, 6, 211, '凤凰县'),
	(1523, 6, 211, '花垣县'),
	(1524, 6, 211, '保靖县'),
	(1525, 6, 211, '古丈县'),
	(1526, 6, 211, '永顺县'),
	(1527, 6, 211, '龙山县'),
	(1528, 14, 212, '城区'),
	(1529, 14, 212, '郊区'),
	(1530, 14, 212, '耀县'),
	(1531, 14, 212, '宜君县'),
	(1532, 14, 213, '秦都区'),
	(1533, 14, 213, '杨陵区'),
	(1534, 14, 213, '渭城区'),
	(1535, 14, 213, '三原县'),
	(1536, 14, 213, '泾阳县'),
	(1537, 14, 213, '乾县'),
	(1538, 14, 213, '礼泉县'),
	(1539, 14, 213, '永寿县'),
	(1540, 14, 213, '彬 县'),
	(1541, 14, 213, '长武县'),
	(1542, 14, 213, '旬邑县'),
	(1543, 14, 213, '淳化县'),
	(1544, 14, 213, '武功县'),
	(1545, 14, 213, '兴平市'),
	(1546, 14, 214, '临渭区'),
	(1547, 14, 214, '华县'),
	(1548, 14, 214, '潼关县'),
	(1549, 14, 214, '大荔县'),
	(1550, 14, 214, '合阳县'),
	(1551, 14, 214, '澄城县'),
	(1552, 14, 214, '蒲城县'),
	(1553, 14, 214, '白水县'),
	(1554, 14, 214, '富平县'),
	(1555, 14, 214, '韩城市'),
	(1556, 14, 214, '华阴市'),
	(1557, 14, 215, '宝塔区'),
	(1558, 14, 215, '延长县'),
	(1559, 14, 215, '延川县'),
	(1560, 14, 215, '子长县'),
	(1561, 14, 215, '安塞县'),
	(1562, 14, 215, '志丹县'),
	(1563, 14, 215, '吴旗县'),
	(1564, 14, 215, '甘泉县'),
	(1565, 14, 215, '富县'),
	(1566, 14, 215, '洛川县'),
	(1567, 14, 215, '宜川县'),
	(1568, 14, 215, '黄龙县'),
	(1569, 14, 215, '黄陵县'),
	(1570, 14, 216, '汉台区'),
	(1571, 14, 216, '南郑县'),
	(1572, 14, 216, '城固县'),
	(1573, 14, 216, '洋县'),
	(1574, 14, 216, '西乡县'),
	(1575, 14, 216, '勉县'),
	(1576, 14, 216, '宁强县'),
	(1577, 14, 216, '略阳县'),
	(1578, 14, 216, '镇巴县'),
	(1579, 14, 216, '留坝县'),
	(1580, 14, 216, '佛坪县'),
	(1581, 14, 217, '安康市'),
	(1582, 14, 216, '汉阴县'),
	(1583, 14, 217, '石泉县'),
	(1584, 14, 217, '宁陕县'),
	(1585, 14, 217, '紫阳县'),
	(1586, 14, 217, '岚皋县'),
	(1587, 14, 217, '平利县'),
	(1588, 14, 217, '镇坪县'),
	(1589, 14, 217, '旬阳县'),
	(1590, 14, 217, '白河县'),
	(1591, 14, 218, '商州市'),
	(1592, 14, 218, '洛南县'),
	(1593, 14, 218, '丹凤县'),
	(1594, 14, 218, '商南县'),
	(1595, 14, 218, '山阳县'),
	(1596, 14, 218, '镇安县'),
	(1597, 14, 218, '柞水县'),
	(1598, 14, 219, '榆林市'),
	(1599, 14, 219, '神木县'),
	(1600, 14, 219, '府谷县'),
	(1601, 14, 219, '横山县'),
	(1602, 14, 219, '靖边县'),
	(1603, 14, 219, '定边县'),
	(1604, 14, 219, '绥德县'),
	(1605, 14, 219, '米脂县'),
	(1606, 14, 219, '佳县'),
	(1607, 14, 219, '吴堡县'),
	(1608, 14, 219, '清涧县'),
	(1609, 14, 219, '子洲县'),
	(1610, 3, 220, '铜仁市'),
	(1611, 3, 220, '江口县'),
	(1612, 3, 220, '玉屏侗族自治县'),
	(1613, 3, 220, '石阡县'),
	(1614, 3, 220, '思南县'),
	(1615, 3, 220, '印江土家族苗族自治县'),
	(1616, 3, 220, '德江县'),
	(1617, 3, 220, '沿河土家族自治县'),
	(1618, 3, 220, '松桃苗族自治县'),
	(1619, 3, 220, '万山特区'),
	(1620, 3, 221, '兴义市'),
	(1621, 3, 221, '兴仁县'),
	(1622, 3, 221, '普安县'),
	(1623, 3, 221, '晴隆县'),
	(1624, 3, 221, '贞丰县'),
	(1625, 3, 221, '望谟县'),
	(1626, 3, 221, '册亨县'),
	(1627, 3, 221, '安龙县'),
	(1628, 3, 222, '毕节市'),
	(1629, 3, 222, '大方县'),
	(1630, 3, 222, '黔西县'),
	(1631, 3, 222, '金沙县'),
	(1632, 3, 222, '织金县'),
	(1633, 3, 222, '纳雍县'),
	(1634, 3, 222, '威宁彝族回族苗族自治县'),
	(1635, 3, 222, '赫章县'),
	(1636, 3, 223, '安顺市'),
	(1637, 3, 223, '平坝县'),
	(1638, 3, 223, '普定县'),
	(1639, 3, 223, '关岭布依族苗族自治县'),
	(1640, 3, 223, '镇宁布依族苗族自治县'),
	(1641, 3, 223, '紫云苗族布依族自治县'),
	(1642, 3, 224, '凯里市'),
	(1643, 3, 224, '黄平县'),
	(1644, 3, 224, '施秉县'),
	(1645, 3, 224, '三穗县'),
	(1646, 3, 224, '镇远县'),
	(1647, 3, 224, '岑巩县'),
	(1648, 3, 224, '天柱县'),
	(1649, 3, 224, '锦屏县'),
	(1650, 3, 224, '剑河县'),
	(1651, 3, 224, '台江县'),
	(1652, 3, 224, '黎平县'),
	(1653, 3, 224, '榕江县'),
	(1654, 3, 224, '从江县'),
	(1655, 3, 224, '雷山县'),
	(1656, 3, 224, '麻江县'),
	(1657, 3, 224, '丹寨县'),
	(1658, 3, 225, '都匀市'),
	(1659, 3, 225, '福泉市'),
	(1660, 3, 225, '荔波县'),
	(1661, 3, 225, '贵定县'),
	(1662, 3, 225, '瓮安县'),
	(1663, 3, 225, '独山县'),
	(1664, 3, 225, '平塘县'),
	(1665, 3, 225, '罗甸县'),
	(1666, 3, 225, '长顺县'),
	(1667, 3, 225, '龙里县'),
	(1668, 3, 225, '惠水县'),
	(1669, 3, 225, '三都水族自治县'),
	(1670, 8, 226, '麒麟区'),
	(1671, 8, 226, '马龙县'),
	(1672, 8, 226, '陆良县'),
	(1673, 8, 226, '师宗县'),
	(1674, 8, 226, '罗平县'),
	(1675, 8, 226, '富源县'),
	(1676, 8, 226, '会泽县'),
	(1677, 8, 226, '沾益县'),
	(1678, 8, 226, '宣威市'),
	(1679, 8, 227, '红塔区'),
	(1680, 8, 227, '江川县'),
	(1681, 8, 227, '澄江县'),
	(1682, 8, 227, '通海县'),
	(1683, 8, 227, '华宁县'),
	(1684, 8, 227, '易门县'),
	(1685, 8, 227, '峨山彝族自治县'),
	(1686, 8, 227, '新平彝族傣族自治县'),
	(1687, 8, 227, '元江哈尼族彝族傣族自治县'),
	(1688, 8, 228, '昭通市'),
	(1689, 8, 228, '鲁甸县'),
	(1690, 8, 228, '巧家县'),
	(1691, 8, 228, '盐津县'),
	(1692, 8, 228, '大关县'),
	(1693, 8, 228, '永善县'),
	(1694, 8, 228, '绥江县'),
	(1695, 8, 228, '镇雄县'),
	(1696, 8, 228, '彝良县'),
	(1697, 8, 228, '威信县'),
	(1698, 8, 228, '水富县'),
	(1699, 8, 229, '思茅市'),
	(1700, 8, 229, '普洱哈尼族彝族自治县'),
	(1701, 8, 229, '墨江哈尼族自治县'),
	(1702, 8, 229, '景东彝族自治县'),
	(1703, 8, 229, '景谷傣族彝族自治县'),
	(1704, 8, 229, '镇沅彝族哈尼族拉祜族自治县'),
	(1705, 8, 229, '江城哈尼族彝族自治县'),
	(1706, 8, 229, '孟连傣族拉祜族佤族自治县'),
	(1707, 8, 229, '澜沧拉祜族自治县'),
	(1708, 8, 229, '西盟佤族自治县'),
	(1709, 8, 230, '景洪市'),
	(1710, 8, 230, '勐海县'),
	(1711, 8, 230, '勐腊县'),
	(1712, 8, 231, '大理市'),
	(1713, 8, 231, '漾濞彝族自治县'),
	(1714, 8, 231, '祥云县'),
	(1715, 8, 231, '宾川县'),
	(1716, 8, 231, '弥渡县'),
	(1717, 8, 231, '南涧彝族自治县'),
	(1718, 8, 231, '巍山彝族回族自治县'),
	(1719, 8, 231, '永平县'),
	(1720, 8, 231, '云龙县'),
	(1721, 8, 231, '洱源县'),
	(1722, 8, 231, '剑川县'),
	(1723, 8, 231, '鹤庆县'),
	(1724, 8, 232, '保山市'),
	(1725, 8, 232, '施甸县'),
	(1726, 8, 232, '腾冲县'),
	(1727, 8, 232, '龙陵县'),
	(1728, 8, 232, '昌宁县'),
	(1729, 8, 233, '临沧县'),
	(1730, 8, 233, '凤庆县'),
	(1731, 8, 233, '云县'),
	(1732, 8, 233, '永德县'),
	(1733, 8, 233, '镇康县'),
	(1734, 8, 233, '双江拉祜族佤族布朗族傣族自治县'),
	(1735, 8, 233, '耿马傣族佤族自治县'),
	(1736, 8, 233, '沧源佤族自治县'),
	(1737, 8, 234, '畹町市'),
	(1738, 8, 234, '瑞丽市'),
	(1739, 8, 234, '潞西市'),
	(1740, 8, 234, '梁河县'),
	(1741, 8, 234, '盈江县'),
	(1742, 8, 234, '陇川县'),
	(1743, 8, 235, '文山县'),
	(1744, 8, 235, '砚山县'),
	(1745, 8, 235, '西畴县'),
	(1746, 8, 235, '麻栗坡县'),
	(1747, 8, 235, '马关县'),
	(1748, 8, 235, '丘北县'),
	(1749, 8, 235, '广南县'),
	(1750, 8, 235, '富宁县'),
	(1751, 8, 236, '中甸县'),
	(1752, 8, 236, '德钦县'),
	(1753, 8, 236, '维西傈僳族自治县'),
	(1754, 21, 237, '龙沙区'),
	(1755, 21, 237, '建华区'),
	(1756, 21, 237, '铁锋区'),
	(1757, 21, 237, '昂昂溪区'),
	(1758, 21, 237, '富拉尔基区'),
	(1759, 21, 237, '碾子山区'),
	(1760, 21, 237, '梅里斯达斡尔族区'),
	(1761, 21, 237, '龙江县'),
	(1762, 21, 237, '依安县'),
	(1763, 21, 237, '泰来县'),
	(1764, 21, 237, '甘南县'),
	(1765, 21, 237, '富裕县'),
	(1766, 21, 237, '克山县'),
	(1767, 21, 237, '克东县'),
	(1768, 21, 237, '拜泉县'),
	(1769, 21, 237, '讷河市'),
	(1770, 21, 238, '萨尔图区'),
	(1771, 21, 238, '龙凤区'),
	(1772, 21, 238, '让胡路区'),
	(1773, 21, 238, '红岗区'),
	(1774, 21, 238, '大同区'),
	(1775, 21, 238, '肇州县'),
	(1776, 21, 238, '肇源县'),
	(1777, 21, 238, '林甸县'),
	(1778, 21, 238, '杜尔伯特蒙古族自治县'),
	(1779, 21, 239, '爱辉区'),
	(1780, 21, 239, '嫩江县'),
	(1781, 21, 239, '逊克县'),
	(1782, 21, 239, '孙吴县'),
	(1783, 21, 239, '北安市'),
	(1784, 21, 239, '五大连池市'),
	(1785, 21, 240, '鸡冠区'),
	(1786, 21, 240, '恒山区'),
	(1787, 21, 240, '滴道区'),
	(1788, 21, 240, '梨树区'),
	(1789, 21, 240, '城子河区'),
	(1790, 21, 240, '麻山区'),
	(1791, 21, 240, '鸡东县'),
	(1792, 21, 240, '虎林市'),
	(1793, 21, 240, '密山市'),
	(1794, 21, 241, '向阳区'),
	(1795, 21, 241, '工农区'),
	(1796, 21, 241, '南山区'),
	(1797, 21, 241, '兴安区'),
	(1798, 21, 241, '东山区'),
	(1799, 21, 241, '兴山区'),
	(1800, 21, 241, '萝北县'),
	(1801, 21, 241, '绥滨县'),
	(1802, 21, 242, '新兴区'),
	(1803, 21, 242, '桃山区'),
	(1804, 21, 242, '茄子河区'),
	(1805, 21, 242, '勃利县'),
	(1806, 21, 243, '绥化市'),
	(1807, 21, 243, '安达市'),
	(1808, 21, 243, '肇东市'),
	(1809, 21, 243, '海伦市'),
	(1810, 21, 243, '望奎县'),
	(1811, 21, 242, '兰西县'),
	(1812, 21, 243, '青冈县'),
	(1813, 21, 243, '庆安县'),
	(1814, 21, 243, '明水县'),
	(1815, 21, 242, '绥棱县'),
	(1816, 21, 244, '呼玛县'),
	(1817, 21, 244, '塔河县'),
	(1818, 21, 244, '漠河县'),
	(1819, 24, 245, '海勃湾区'),
	(1820, 24, 245, '海南区'),
	(1821, 24, 245, '乌达区'),
	(1822, 24, 246, '红山区'),
	(1823, 24, 246, '元宝山区'),
	(1824, 24, 246, '松山区'),
	(1825, 24, 246, '阿鲁科尔沁旗'),
	(1826, 24, 246, '巴林左旗'),
	(1827, 24, 246, '巴林右旗'),
	(1828, 24, 246, '林西县'),
	(1829, 24, 246, '克什克腾旗'),
	(1830, 24, 246, '翁牛特旗'),
	(1831, 24, 246, '喀喇沁旗'),
	(1832, 24, 246, '宁城县'),
	(1833, 24, 246, '敖汉旗'),
	(1834, 24, 247, '海拉尔市'),
	(1835, 24, 247, '满洲里市'),
	(1836, 24, 247, '扎兰屯市'),
	(1837, 24, 247, '牙克石市'),
	(1838, 24, 247, '根河市'),
	(1839, 24, 247, '额尔古纳市'),
	(1840, 24, 247, '阿荣旗'),
	(1841, 24, 247, '莫力达瓦达斡尔族自治旗'),
	(1842, 24, 247, '鄂伦春自治旗'),
	(1843, 24, 247, '鄂温克族自治旗'),
	(1844, 24, 247, '新巴尔虎右旗'),
	(1845, 24, 247, '新巴尔虎左旗'),
	(1846, 24, 247, '陈巴尔虎旗'),
	(1847, 24, 248, '科尔沁区'),
	(1848, 24, 248, '霍林郭勒市'),
	(1849, 24, 248, '科尔沁左翼中旗'),
	(1850, 24, 248, '科尔沁左翼后旗'),
	(1851, 24, 248, '开鲁县'),
	(1852, 24, 248, '库伦旗'),
	(1853, 24, 248, '奈曼旗'),
	(1854, 24, 248, '扎鲁特旗'),
	(1855, 24, 249, '乌兰浩特市'),
	(1856, 24, 249, '阿尔山市'),
	(1857, 24, 249, '科尔沁右翼前旗'),
	(1858, 24, 249, '科尔沁右翼中旗'),
	(1859, 24, 249, '扎赉特旗'),
	(1860, 24, 249, '突泉县'),
	(1861, 24, 250, '二连浩特市'),
	(1862, 24, 250, '锡林浩特市'),
	(1863, 24, 250, '阿巴嘎旗'),
	(1864, 24, 250, '苏尼特左旗'),
	(1865, 24, 250, '苏尼特右旗'),
	(1866, 24, 250, '东乌珠穆沁旗'),
	(1867, 24, 250, '西乌珠穆沁旗'),
	(1868, 24, 250, '太仆寺旗'),
	(1869, 24, 250, '镶黄旗'),
	(1870, 24, 250, '正镶白旗'),
	(1871, 24, 250, '正蓝旗'),
	(1872, 24, 250, '多伦县'),
	(1873, 24, 251, '集宁市'),
	(1874, 24, 251, '丰镇市'),
	(1875, 24, 251, '卓资县'),
	(1876, 24, 251, '化德县'),
	(1877, 24, 251, '商都县'),
	(1878, 24, 251, '兴和县'),
	(1879, 24, 251, '凉城县'),
	(1880, 24, 251, '察哈尔右翼前旗'),
	(1881, 24, 251, '察哈尔右翼中旗'),
	(1882, 24, 251, '察哈尔右翼后旗'),
	(1883, 24, 251, '四子王旗'),
	(1884, 24, 252, '东胜市'),
	(1885, 24, 252, '达拉特旗'),
	(1886, 24, 252, '准格尔旗'),
	(1887, 24, 252, '鄂托克前旗'),
	(1888, 24, 252, '鄂托克旗'),
	(1889, 24, 252, '杭锦旗'),
	(1890, 24, 252, '乌审旗'),
	(1891, 24, 252, '伊金霍洛旗'),
	(1892, 30, 34, '白沙黎族自治县'),
	(1893, 30, 34, '昌江黎族自治县'),
	(1894, 30, 34, '乐东黎族自治县'),
	(1895, 30, 34, '陵水黎族自治县'),
	(1896, 30, 34, '保亭黎族苗族自治县'),
	(1897, 30, 34, '琼中黎族苗族自治县'),
	(1898, 30, 34, '西南中沙群岛办事处'),
	(1899, 20, 253, '洮北区'),
	(1900, 20, 253, '镇赉县'),
	(1901, 20, 253, '通榆县'),
	(1902, 20, 253, '洮南市'),
	(1903, 20, 253, '大安市'),
	(1904, 20, 254, '八道江区'),
	(1905, 20, 254, '抚松县'),
	(1906, 20, 254, '靖宇县'),
	(1907, 20, 254, '长白朝鲜族自治县'),
	(1908, 20, 254, '江源县'),
	(1909, 20, 254, '临江市'),
	(1910, 13, 255, '东宝区'),
	(1911, 13, 255, '掇刀区'),
	(1912, 13, 255, '京山县'),
	(1913, 13, 255, '沙洋县'),
	(1914, 13, 255, '钟祥市'),
	(1915, 13, 256, '孝南区'),
	(1916, 13, 256, '孝昌县'),
	(1917, 13, 256, '大悟县'),
	(1918, 13, 256, '云梦县'),
	(1919, 13, 256, '应城市'),
	(1920, 13, 256, '安陆市'),
	(1921, 13, 256, '汉川市'),
	(1922, 13, 257, '沙市区'),
	(1923, 13, 257, '荆州区'),
	(1924, 13, 257, '公安县'),
	(1925, 13, 257, '监利县'),
	(1926, 13, 257, '江陵县'),
	(1927, 13, 257, '石首市'),
	(1928, 13, 257, '洪湖市'),
	(1929, 13, 257, '松滋市'),
	(1930, 13, 258, '黄州区'),
	(1931, 13, 258, '团风县'),
	(1932, 13, 258, '红安县'),
	(1933, 13, 258, '罗田县'),
	(1934, 13, 258, '英山县'),
	(1935, 13, 258, '浠水县'),
	(1936, 13, 258, '蕲春县'),
	(1937, 13, 258, '黄梅县'),
	(1938, 13, 258, '麻城市'),
	(1939, 13, 258, '武穴市'),
	(1940, 13, 259, '咸安区'),
	(1941, 13, 259, '嘉鱼县'),
	(1942, 13, 259, '通城县'),
	(1943, 13, 259, '崇阳县'),
	(1944, 13, 259, '通山县'),
	(1945, 13, 259, '赤壁市'),
	(1946, 18, 260, '双桥区'),
	(1947, 18, 260, '双滦区'),
	(1948, 18, 260, '鹰手营子矿区'),
	(1949, 18, 260, '承德县'),
	(1950, 18, 260, '兴隆县'),
	(1951, 18, 260, '平泉县'),
	(1952, 18, 260, '滦平县'),
	(1953, 18, 260, '隆化县'),
	(1954, 18, 261, '桃城区'),
	(1955, 18, 261, '枣强县'),
	(1956, 18, 261, '武邑县'),
	(1957, 18, 261, '武强县'),
	(1958, 18, 261, '饶阳县'),
	(1959, 18, 261, '安平县'),
	(1960, 18, 261, '故城县'),
	(1961, 18, 261, '景县'),
	(1962, 18, 261, '阜城县'),
	(1963, 18, 260, '冀州市'),
	(1964, 18, 261, '深州市'),
	(1965, 5, 15, '会昌县'),
	(1966, 5, 4, '效区'),
	(1967, 22, 271, '利通区'),
	(1968, 22, 271, '红寺堡区'),
	(1969, 22, 271, '盐池县'),
	(1970, 22, 271, '同心县'),
	(1971, 22, 271, '青铜峡市'),
	(1972, 22, 272, '原州区'),
	(1973, 22, 272, '西吉县'),
	(1974, 22, 272, '隆德县'),
	(1975, 22, 272, '泾源县'),
	(1977, 22, 272, '彭阳县'),
	(1978, 22, 273, '沙坡头区'),
	(1979, 22, 273, '中宁县'),
	(1980, 22, 273, '海原县'),
	(1981, 25, 75, '林周县'),
	(1982, 25, 75, '当雄县'),
	(1983, 25, 75, '尼木县'),
	(1984, 25, 75, '曲水县'),
	(1985, 25, 75, '堆龙德庆县'),
	(1986, 25, 75, '达孜县'),
	(1987, 25, 75, '墨竹工卡县'),
	(1988, 25, 76, '昌都县'),
	(1989, 25, 76, '江达县'),
	(1990, 25, 76, '贡觉县'),
	(1991, 25, 76, '类乌齐县'),
	(1992, 25, 76, '丁青县'),
	(1993, 25, 76, '察雅县'),
	(1994, 25, 76, '八宿县'),
	(1995, 25, 76, '左贡县'),
	(1996, 25, 76, '左贡县'),
	(1997, 25, 76, '芒康县'),
	(1998, 25, 76, '洛隆县'),
	(1999, 25, 76, '边坝县'),
	(2000, 25, 274, '乃东县'),
	(2001, 25, 274, '扎囊县'),
	(2002, 25, 274, '贡嘎县'),
	(2003, 25, 274, '桑日县'),
	(2004, 25, 274, '琼结县'),
	(2005, 25, 274, '曲松县'),
	(2006, 25, 274, '措美县'),
	(2007, 25, 274, '洛扎县'),
	(2008, 25, 274, '加查县'),
	(2009, 25, 274, '隆子县'),
	(2010, 25, 274, '错那县'),
	(2011, 25, 274, '浪卡子县'),
	(2012, 25, 275, '日喀则市'),
	(2013, 25, 275, '南木林县'),
	(2014, 25, 275, '江孜县'),
	(2015, 25, 275, '定日县'),
	(2016, 25, 275, '萨迦县'),
	(2017, 25, 275, '拉孜县'),
	(2018, 25, 275, '昂仁县'),
	(2019, 25, 275, '谢通门县'),
	(2020, 25, 275, '白朗县'),
	(2021, 25, 275, '仁布县'),
	(2022, 25, 275, '康马县'),
	(2023, 25, 275, '定结县'),
	(2024, 25, 275, '仲巴县'),
	(2025, 25, 275, '亚东县'),
	(2026, 25, 275, '吉隆县'),
	(2027, 25, 275, '聂拉木县'),
	(2028, 25, 275, '萨嘎县'),
	(2029, 25, 275, '岗巴县'),
	(2030, 25, 276, '那曲县'),
	(2031, 25, 276, '嘉黎县'),
	(2032, 25, 276, '比如县'),
	(2033, 25, 276, '聂荣县'),
	(2034, 25, 276, '安多县'),
	(2035, 25, 276, '申扎县'),
	(2036, 25, 276, '索县'),
	(2037, 25, 276, '班戈县'),
	(2038, 25, 276, '巴青县'),
	(2039, 25, 276, '尼玛县'),
	(2040, 25, 277, '普兰县'),
	(2041, 25, 277, '札达县'),
	(2042, 25, 277, '噶尔县'),
	(2043, 25, 277, '日土县'),
	(2044, 25, 277, '革吉县'),
	(2045, 25, 277, '改则县'),
	(2046, 25, 277, '措勤县'),
	(2047, 25, 278, '林芝县'),
	(2048, 25, 278, '工布江达县'),
	(2049, 25, 278, '米林县'),
	(2050, 25, 278, '墨脱县'),
	(2051, 25, 278, '波密县'),
	(2052, 25, 278, '察隅县'),
	(2053, 25, 278, '朗县'),
	(2054, 26, 74, '沙依巴克区'),
	(2055, 26, 74, '水磨沟区'),
	(2056, 26, 74, '头屯河区'),
	(2057, 26, 74, '南山矿区'),
	(2058, 26, 263, '独山子区'),
	(2059, 26, 263, '克拉玛依区'),
	(2060, 26, 263, '白碱滩区'),
	(2061, 26, 263, '乌尔禾区'),
	(2062, 26, 264, '吐鲁番市'),
	(2063, 26, 264, '鄯善县'),
	(2064, 26, 264, '托克逊县'),
	(2065, 26, 265, '哈密市'),
	(2066, 26, 265, '巴里坤哈萨克自治县'),
	(2067, 26, 265, '伊吾县'),
	(2068, 26, 266, '阿克苏市'),
	(2069, 26, 266, '温宿县'),
	(2070, 26, 266, '库车县'),
	(2071, 26, 266, '沙雅县'),
	(2072, 26, 266, '新和县'),
	(2073, 26, 266, '拜城县'),
	(2074, 26, 266, '乌什县'),
	(2075, 26, 266, '阿瓦提县'),
	(2076, 26, 266, '柯坪县'),
	(2077, 26, 267, '喀什市'),
	(2078, 26, 267, '疏附县'),
	(2079, 26, 267, '疏勒县'),
	(2080, 26, 267, '英吉沙县'),
	(2081, 26, 267, '泽普县'),
	(2082, 26, 267, '莎车县'),
	(2083, 26, 267, '叶城县'),
	(2084, 26, 267, '麦盖提县'),
	(2085, 26, 267, '岳普湖县'),
	(2086, 26, 267, '伽师县'),
	(2087, 26, 267, '巴楚县'),
	(2088, 26, 267, '塔什库尔干塔吉克自治县'),
	(2089, 26, 268, '和田市'),
	(2090, 26, 268, '和田县'),
	(2091, 26, 268, '墨玉县'),
	(2092, 26, 268, '皮山县'),
	(2093, 26, 268, '洛浦县'),
	(2094, 26, 268, '策勒县'),
	(2095, 26, 268, '于田县'),
	(2096, 26, 268, '民丰县'),
	(2097, 26, 269, '塔城市'),
	(2098, 26, 269, '乌苏市'),
	(2099, 26, 269, '额敏县'),
	(2100, 26, 269, '沙湾县'),
	(2101, 26, 269, '托里县'),
	(2102, 26, 269, '裕民县'),
	(2103, 26, 269, '和布克赛尔蒙古自治县'),
	(2104, 26, 270, '阿勒泰市'),
	(2105, 26, 270, '布尔津县'),
	(2106, 26, 270, '富蕴县'),
	(2107, 26, 270, '福海县'),
	(2108, 26, 270, '哈巴河县'),
	(2109, 26, 270, '青河县'),
	(2110, 26, 270, '吉木乃县'),
	(2111, 23, 262, '平安县'),
	(2112, 23, 262, '乐都县'),
	(2113, 23, 262, '湟中县'),
	(2114, 23, 262, '湟源县'),
	(2115, 23, 99, '大通回族土族自治县'),
	(2116, 23, 262, '民和回族土族自治县'),
	(2117, 23, 262, '互助土族自治县'),
	(2118, 23, 262, '化隆回族自治县'),
	(2119, 23, 262, '循化撒拉族自治县'),
	(2120, 13, 286, '恩施市'),
	(2121, 13, 286, '利川市'),
	(2122, 13, 286, '建始县'),
	(2123, 13, 286, '巴东县'),
	(2124, 13, 286, '宣恩县'),
	(2125, 13, 286, '咸丰县'),
	(2126, 13, 286, '来凤县'),
	(2127, 13, 286, '鹤峰县'),
	(2128, 1, 325, '城区'),
	(2129, 1, 325, '海丰县'),
	(2130, 1, 325, '陆河县'),
	(2131, 1, 325, '陆丰市'),
	(2132, 1, 326, '江城区'),
	(2133, 1, 326, '阳西县'),
	(2134, 1, 326, '阳东县'),
	(2135, 1, 326, '阳春市'),
	(2136, 1, 327, '清城区'),
	(2137, 1, 327, '佛冈县'),
	(2138, 1, 327, '阳山县'),
	(2139, 1, 327, '连山壮族瑶族自治县'),
	(2140, 1, 327, '连南瑶族自治县'),
	(2141, 1, 327, '清新县'),
	(2142, 1, 327, '英德市'),
	(2143, 1, 327, '连州市'),
	(2144, 1, 328, '湘桥区'),
	(2145, 1, 328, '潮安县'),
	(2146, 1, 328, '饶平县'),
	(2147, 1, 329, '云城区'),
	(2148, 1, 329, '新兴县'),
	(2149, 1, 329, '郁南县'),
	(2150, 1, 329, '云安县'),
	(2151, 1, 329, '罗定市'),
	(2152, 2, 322, '江州区'),
	(2153, 2, 322, '凭祥市'),
	(2154, 2, 322, '扶绥县'),
	(2155, 2, 322, '宁明县'),
	(2156, 2, 322, '龙州县'),
	(2157, 2, 322, '大新县'),
	(2158, 2, 322, '天等县'),
	(2159, 2, 323, '兴宾区'),
	(2160, 2, 323, '合山市'),
	(2161, 2, 323, '忻城县'),
	(2162, 2, 323, '象州县'),
	(2163, 2, 323, '武宣县'),
	(2164, 2, 323, '金秀瑶族自治县'),
	(2165, 2, 324, '金城江区'),
	(2166, 2, 324, '宜州市'),
	(2167, 2, 324, '罗城仫佬族自治县'),
	(2168, 2, 324, '环江毛南族自治县'),
	(2169, 2, 324, '南丹县'),
	(2170, 2, 324, '天峨县'),
	(2171, 2, 324, '凤山县'),
	(2172, 2, 324, '东兰县'),
	(2173, 2, 324, '巴马瑶族自治县'),
	(2174, 2, 324, '都安瑶族自治县'),
	(2175, 2, 324, '大化瑶族自治县'),
	(2176, 4, 295, '蕉城区'),
	(2177, 4, 295, '霞浦县'),
	(2178, 4, 295, '古田县'),
	(2179, 4, 295, '屏南县'),
	(2180, 4, 295, '寿宁县'),
	(2181, 4, 295, '周宁县'),
	(2182, 4, 295, '柘荣县'),
	(2183, 4, 295, '福安市'),
	(2184, 4, 295, '福鼎市'),
	(2185, 7, 330, '船山区'),
	(2186, 7, 330, '安居区'),
	(2187, 7, 330, '蓬溪县'),
	(2188, 7, 330, '射洪县'),
	(2189, 7, 330, '大英县'),
	(2190, 7, 331, '达川市'),
	(2191, 7, 331, '万源市'),
	(2192, 7, 331, '达县'),
	(2193, 7, 331, '宣汉县'),
	(2194, 7, 331, '开江县'),
	(2195, 7, 331, '大竹县'),
	(2196, 7, 331, '渠县'),
	(2197, 7, 332, '雅安市'),
	(2198, 7, 331, '名山县'),
	(2199, 7, 332, '荥经县'),
	(2200, 7, 332, '汉源县'),
	(2201, 7, 332, '石棉县'),
	(2202, 7, 332, '天全县'),
	(2203, 7, 332, '芦山县'),
	(2204, 7, 332, '宝兴县'),
	(2205, 7, 333, '汶川县'),
	(2206, 7, 333, '理县'),
	(2207, 7, 333, '茂县'),
	(2208, 7, 333, '松潘县'),
	(2209, 7, 333, '九寨沟县'),
	(2210, 7, 333, '金川县'),
	(2211, 7, 333, '小金县'),
	(2212, 7, 333, '黑水县'),
	(2213, 7, 333, '马尔康县'),
	(2214, 7, 333, '壤塘县'),
	(2215, 7, 333, '阿坝县'),
	(2216, 7, 333, '若尔盖县'),
	(2217, 7, 333, '红原县'),
	(2218, 7, 334, '康定县'),
	(2219, 7, 334, '泸定县'),
	(2220, 7, 334, '丹巴县'),
	(2221, 7, 334, '九龙县'),
	(2222, 7, 334, '雅江县'),
	(2223, 7, 334, '道孚县'),
	(2224, 7, 334, '炉霍县'),
	(2225, 7, 334, '甘孜县'),
	(2226, 7, 334, '新龙县'),
	(2227, 7, 334, '德格县'),
	(2228, 7, 334, '白玉县'),
	(2229, 7, 334, '石渠县'),
	(2230, 7, 334, '色达县'),
	(2231, 7, 334, '理塘县'),
	(2232, 7, 334, '巴塘县'),
	(2233, 7, 334, '乡城县'),
	(2234, 7, 334, '稻城县'),
	(2235, 7, 334, '得荣县'),
	(2236, 7, 335, '西昌市'),
	(2237, 7, 335, '木里藏族自治县'),
	(2238, 7, 335, '盐源县'),
	(2239, 7, 335, '德昌县'),
	(2240, 7, 335, '会理县'),
	(2241, 7, 335, '会东县'),
	(2242, 7, 335, '宁南县'),
	(2243, 7, 335, '普格县'),
	(2244, 7, 335, '布拖县'),
	(2245, 7, 335, '金阳县'),
	(2246, 7, 335, '昭觉县'),
	(2247, 7, 335, '喜德县'),
	(2248, 7, 335, '冕宁县'),
	(2249, 7, 335, '越西县'),
	(2250, 7, 335, '甘洛县'),
	(2251, 7, 335, '美姑县'),
	(2252, 7, 335, '雷波县'),
	(2253, 7, 336, '眉山县'),
	(2254, 7, 336, '仁寿县'),
	(2255, 7, 336, '彭山县'),
	(2256, 7, 336, '洪雅县'),
	(2257, 7, 336, '丹棱县'),
	(2258, 7, 336, '青神县'),
	(2259, 8, 343, '楚雄市'),
	(2260, 8, 343, '双柏县'),
	(2261, 8, 343, '牟定县'),
	(2262, 8, 343, '南华县'),
	(2263, 8, 343, '姚安县'),
	(2264, 8, 343, '大姚县'),
	(2265, 8, 343, '永仁县'),
	(2266, 8, 343, '元谋县'),
	(2267, 8, 343, '武定县'),
	(2268, 8, 343, '禄丰县'),
	(2269, 8, 344, '个旧市'),
	(2270, 8, 344, '开远市'),
	(2271, 8, 344, '蒙自县'),
	(2272, 8, 344, '屏边苗族自治县'),
	(2273, 8, 344, '建水县'),
	(2274, 8, 344, '石屏县'),
	(2275, 8, 344, '弥勒县'),
	(2276, 8, 344, '泸西县'),
	(2277, 8, 344, '元阳县'),
	(2278, 8, 344, '红河县'),
	(2279, 8, 344, '金平苗族瑶族傣族自治县'),
	(2280, 8, 344, '绿春县'),
	(2281, 8, 344, '河口瑶族自治县'),
	(2282, 8, 345, '泸水县'),
	(2283, 8, 345, '福贡县'),
	(2284, 8, 345, '贡山独龙族怒族自治县'),
	(2285, 8, 345, '兰坪白族普米族自治县'),
	(2286, 10, 307, '吴兴区'),
	(2287, 10, 307, '南浔区'),
	(2288, 10, 307, '德清县'),
	(2289, 10, 307, '长兴县'),
	(2290, 10, 307, '安吉县'),
	(2291, 11, 291, '清河区'),
	(2292, 11, 291, '清浦区'),
	(2293, 11, 291, '淮阴县'),
	(2294, 11, 291, '涟水县'),
	(2295, 11, 291, '洪泽县'),
	(2296, 11, 291, '盱眙县'),
	(2297, 11, 291, '金湖县'),
	(2298, 11, 291, '淮安市'),
	(2299, 11, 292, '城区'),
	(2300, 11, 292, '响水县'),
	(2301, 11, 292, '滨海县'),
	(2302, 11, 292, '阜宁县'),
	(2303, 11, 292, '射阳县'),
	(2304, 11, 292, '建湖县'),
	(2305, 11, 292, '盐都县'),
	(2306, 11, 292, '东台市'),
	(2307, 11, 292, '东台市'),
	(2308, 11, 292, '大丰市'),
	(2309, 11, 293, '京口区'),
	(2310, 11, 293, '润州区'),
	(2311, 11, 293, '丹徒县'),
	(2312, 11, 293, '丹阳市'),
	(2313, 11, 293, '扬中市'),
	(2314, 11, 293, '句容市'),
	(2315, 11, 294, '海陵区'),
	(2316, 11, 294, '高港区'),
	(2317, 11, 294, '兴化市'),
	(2318, 11, 294, '靖江市'),
	(2319, 11, 294, '泰兴市'),
	(2320, 11, 294, '姜堰市'),
	(2321, 12, 314, '市中区'),
	(2322, 12, 314, '任城区'),
	(2323, 12, 314, '微山县'),
	(2324, 12, 314, '鱼台县'),
	(2325, 12, 314, '金乡县'),
	(2326, 12, 314, '嘉祥县'),
	(2327, 12, 314, '汶上县'),
	(2328, 12, 314, '泗水县'),
	(2329, 12, 314, '梁山县'),
	(2330, 12, 314, '曲阜市'),
	(2331, 12, 314, '兖州市'),
	(2332, 12, 314, '邹城市'),
	(2333, 12, 315, '泰山区'),
	(2334, 12, 315, '郊区'),
	(2335, 12, 315, '宁阳县'),
	(2336, 12, 315, '东平县'),
	(2337, 12, 315, '新泰市'),
	(2338, 12, 315, '肥城市'),
	(2339, 12, 316, '东港区'),
	(2340, 12, 316, '岚山区'),
	(2341, 12, 316, '五莲县'),
	(2342, 12, 316, '莒县'),
	(2343, 12, 317, '莱城区'),
	(2344, 12, 317, '钢城区'),
	(2345, 12, 318, '德城区'),
	(2346, 12, 318, '陵县'),
	(2347, 12, 318, '宁津县'),
	(2348, 12, 318, '庆云县'),
	(2349, 12, 318, '临邑县'),
	(2350, 12, 318, '齐河县'),
	(2351, 12, 318, '平原县'),
	(2352, 12, 318, '夏津县'),
	(2353, 12, 318, '武城县'),
	(2354, 12, 318, '乐陵市'),
	(2355, 12, 318, '禹城市'),
	(2356, 12, 319, '东昌府区'),
	(2357, 12, 319, '阳谷县'),
	(2358, 12, 319, '莘县'),
	(2359, 12, 319, '莘县'),
	(2360, 12, 319, '茌平县'),
	(2361, 12, 319, '东阿县'),
	(2362, 12, 319, '冠县'),
	(2363, 12, 319, '高唐县'),
	(2364, 12, 319, '临清市'),
	(2365, 12, 320, '滨州市'),
	(2366, 12, 320, '惠民县'),
	(2367, 12, 320, '阳信县'),
	(2368, 12, 320, '无棣县'),
	(2369, 12, 320, '沾化县'),
	(2370, 12, 320, '博兴县'),
	(2371, 12, 320, '邹平县'),
	(2372, 12, 321, '菏泽市'),
	(2373, 12, 321, '曹县'),
	(2374, 12, 321, '定陶县'),
	(2375, 12, 321, '成武县'),
	(2376, 12, 321, '单县'),
	(2377, 12, 321, '巨野县'),
	(2378, 12, 321, '郓城县'),
	(2379, 12, 321, '鄄城县'),
	(2380, 12, 321, '东明县'),
	(2381, 15, 279, '玉门市'),
	(2382, 15, 279, '酒泉市'),
	(2383, 15, 279, '敦煌市'),
	(2384, 15, 279, '金塔县'),
	(2385, 15, 279, '肃北蒙古族自治县'),
	(2386, 15, 279, '阿克塞哈萨克族自治县'),
	(2387, 15, 279, '安西县'),
	(2388, 15, 280, '张掖市'),
	(2389, 15, 280, '肃南裕固族自治县'),
	(2390, 15, 280, '民乐县'),
	(2391, 15, 280, '临泽县'),
	(2392, 15, 280, '高台县'),
	(2393, 15, 280, '山丹县'),
	(2394, 15, 281, '武威市'),
	(2395, 15, 281, '民勤县'),
	(2396, 15, 281, '古浪县'),
	(2397, 15, 281, '天祝藏族自治县'),
	(2398, 15, 282, '定西县'),
	(2399, 15, 282, '通渭县'),
	(2400, 15, 282, '陇西县'),
	(2401, 15, 282, '渭源县'),
	(2402, 15, 282, '临洮县'),
	(2403, 15, 282, '漳县'),
	(2404, 15, 282, '岷县'),
	(2405, 15, 283, '武都县'),
	(2406, 15, 283, '宕昌县'),
	(2407, 15, 283, '成县'),
	(2408, 15, 283, '康县'),
	(2409, 15, 283, '文县'),
	(2410, 15, 283, '西和县'),
	(2411, 15, 283, '礼县'),
	(2412, 15, 283, '两当县'),
	(2413, 15, 283, '徽县'),
	(2414, 15, 284, '平凉市'),
	(2415, 15, 284, '泾川县'),
	(2416, 15, 284, '灵台县'),
	(2417, 15, 284, '崇信县'),
	(2418, 15, 284, '华亭县'),
	(2419, 15, 284, '庄浪县'),
	(2420, 15, 284, '静宁县'),
	(2421, 15, 285, '西峰市'),
	(2422, 15, 285, '庆阳县'),
	(2423, 15, 285, '环县'),
	(2424, 15, 285, '华池县'),
	(2425, 15, 285, '合水县'),
	(2426, 15, 285, '正宁县'),
	(2427, 15, 285, '宁县'),
	(2428, 15, 285, '镇原县'),
	(2429, 15, 346, '临夏市'),
	(2430, 15, 346, '临夏县'),
	(2431, 15, 346, '康乐县'),
	(2432, 15, 346, '永靖县'),
	(2433, 15, 346, '广河县'),
	(2434, 15, 346, '和政县'),
	(2435, 15, 346, '东乡族自治县'),
	(2436, 15, 346, '积石山保安族东乡族撒拉族自治县'),
	(2437, 15, 347, '合作市'),
	(2438, 15, 347, '临潭县'),
	(2439, 15, 347, '卓尼县'),
	(2440, 15, 347, '舟曲县'),
	(2441, 15, 347, '迭部县'),
	(2442, 15, 347, '玛曲县'),
	(2443, 15, 347, '碌曲县'),
	(2444, 15, 347, '夏河县'),
	(2445, 16, 69, '霍州市'),
	(2446, 16, 69, '曲沃县'),
	(2447, 16, 69, '翼城县'),
	(2448, 16, 69, '襄汾县'),
	(2449, 16, 69, '洪洞县'),
	(2450, 16, 69, '古县'),
	(2451, 16, 69, '安泽县'),
	(2452, 16, 69, '浮山县'),
	(2453, 16, 69, '吉县'),
	(2454, 16, 69, '乡宁县'),
	(2455, 16, 69, '蒲县'),
	(2456, 16, 69, '大宁县'),
	(2457, 16, 69, '永和县'),
	(2458, 16, 69, '隰县'),
	(2459, 16, 69, '汾西县'),
	(2460, 16, 296, '城区'),
	(2461, 16, 296, '矿区'),
	(2462, 16, 296, '郊区'),
	(2463, 16, 296, '平定县'),
	(2464, 16, 296, '盂县'),
	(2465, 16, 297, '城区'),
	(2466, 16, 297, '郊区'),
	(2467, 16, 297, '长治县'),
	(2468, 16, 297, '襄垣县'),
	(2469, 16, 297, '屯留县'),
	(2470, 16, 297, '平顺县'),
	(2471, 16, 297, '黎城县'),
	(2472, 16, 297, '壶关县'),
	(2473, 16, 297, '长子县'),
	(2474, 16, 297, '武乡县'),
	(2475, 16, 297, '沁县'),
	(2476, 16, 297, '沁源县'),
	(2477, 16, 297, '潞城市'),
	(2478, 16, 298, '朔城区'),
	(2479, 16, 298, '平鲁区'),
	(2480, 16, 298, '山阴县'),
	(2481, 16, 298, '应县'),
	(2482, 16, 298, '右玉县'),
	(2483, 16, 298, '怀仁县'),
	(2484, 16, 299, '忻府区'),
	(2485, 16, 299, '原平市'),
	(2486, 16, 299, '定襄县'),
	(2487, 16, 299, '五台县'),
	(2488, 16, 299, '代县'),
	(2489, 16, 299, '繁峙县'),
	(2490, 16, 299, '宁武县'),
	(2491, 16, 299, '静乐县'),
	(2492, 16, 299, '神池县'),
	(2493, 16, 299, '五寨县'),
	(2494, 16, 299, '岢岚县'),
	(2495, 16, 299, '河曲县'),
	(2496, 16, 299, '保德县'),
	(2497, 16, 299, '偏关县'),
	(2498, 16, 300, '离石区'),
	(2499, 16, 300, '孝义市'),
	(2500, 16, 300, '汾阳市'),
	(2501, 16, 299, '文水县'),
	(2502, 16, 300, '交城县'),
	(2503, 16, 300, '兴县'),
	(2504, 16, 300, '临县'),
	(2505, 16, 299, '柳林县'),
	(2506, 16, 300, '石楼县'),
	(2507, 16, 300, '岚县'),
	(2508, 16, 300, '方山县'),
	(2509, 16, 300, '中阳县'),
	(2510, 16, 300, '中阳县'),
	(2511, 16, 361, '榆次市'),
	(2512, 16, 361, '介休市'),
	(2513, 16, 361, '榆社县'),
	(2514, 16, 361, '左权县'),
	(2515, 16, 361, '和顺县'),
	(2516, 16, 361, '昔阳县'),
	(2517, 16, 361, '寿阳县'),
	(2518, 16, 361, '太谷县'),
	(2519, 16, 361, '祁县'),
	(2520, 16, 361, '平遥县'),
	(2521, 16, 361, '灵石县'),
	(2522, 17, 308, '新华区'),
	(2523, 17, 308, '卫东区'),
	(2524, 17, 308, '石龙区'),
	(2525, 17, 308, '湛河区'),
	(2526, 17, 308, '宝丰县'),
	(2527, 17, 308, '叶县'),
	(2528, 17, 308, '鲁山县'),
	(2529, 17, 308, '郏县'),
	(2530, 17, 308, '舞钢市'),
	(2531, 17, 308, '汝州市'),
	(2532, 17, 309, '文峰区'),
	(2533, 17, 309, '北关区'),
	(2534, 17, 309, '铁西区'),
	(2535, 17, 309, '郊区'),
	(2536, 17, 309, '安阳县'),
	(2537, 17, 309, '汤阴县'),
	(2538, 17, 309, '滑县'),
	(2539, 17, 309, '内黄县'),
	(2540, 17, 309, '林州市'),
	(2541, 17, 310, '鹤山区'),
	(2542, 17, 310, '山城区'),
	(2543, 17, 310, '郊区'),
	(2544, 17, 310, '浚县'),
	(2545, 17, 310, '淇县'),
	(2546, 17, 311, '华龙区'),
	(2547, 17, 311, '清丰县'),
	(2548, 17, 311, '南乐县'),
	(2549, 17, 311, '范县'),
	(2550, 17, 311, '台前县'),
	(2551, 17, 311, '濮阳县'),
	(2552, 17, 313, '湖滨区'),
	(2553, 17, 313, '渑池县'),
	(2554, 17, 313, '陕县'),
	(2555, 17, 313, '卢氏县'),
	(2556, 17, 313, '义马市'),
	(2557, 17, 313, '灵宝市'),
	(2558, 17, 362, '宛城区'),
	(2559, 17, 362, '卧龙区'),
	(2560, 17, 360, '南召县'),
	(2561, 17, 362, '方城县'),
	(2562, 17, 362, '西峡县'),
	(2563, 17, 362, '镇平县'),
	(2564, 17, 360, '内乡县'),
	(2565, 17, 362, '淅川县'),
	(2566, 17, 360, '社旗县'),
	(2567, 17, 362, '唐河县'),
	(2568, 17, 362, '新野县'),
	(2569, 17, 362, '桐柏县'),
	(2570, 17, 362, '邓州市'),
	(2571, 17, 360, '?河区'),
	(2572, 17, 360, '平桥区'),
	(2573, 17, 360, '罗山县'),
	(2574, 17, 360, '光山县'),
	(2575, 17, 360, '新县'),
	(2576, 17, 360, '商城县'),
	(2577, 17, 360, '固始县'),
	(2578, 17, 360, '潢川县'),
	(2579, 17, 360, '淮滨县'),
	(2580, 17, 360, '息县'),
	(2581, 18, 306, '桥东区'),
	(2582, 18, 306, '桥西区'),
	(2583, 18, 306, '邢台县'),
	(2584, 18, 306, '临城县'),
	(2585, 18, 306, '内丘县'),
	(2586, 18, 306, '柏乡县'),
	(2587, 18, 306, '隆尧县'),
	(2588, 18, 306, '任县'),
	(2589, 18, 306, '南和县'),
	(2590, 18, 306, '宁晋县'),
	(2591, 18, 306, '巨鹿县'),
	(2592, 18, 306, '新河县'),
	(2593, 18, 306, '广宗县'),
	(2594, 18, 306, '平乡县'),
	(2595, 18, 261, '威县'),
	(2596, 18, 306, '清河县'),
	(2597, 18, 306, '临西县'),
	(2598, 18, 306, '南宫市'),
	(2599, 18, 306, '沙河市'),
	(2600, 19, 305, '连山区'),
	(2601, 19, 305, '龙港区'),
	(2602, 19, 305, '南票区'),
	(2603, 19, 305, '绥中县'),
	(2604, 19, 305, '建昌县'),
	(2605, 19, 305, '兴城市'),
	(2606, 23, 337, '玉树县'),
	(2607, 23, 337, '杂多县'),
	(2608, 23, 337, '称多县'),
	(2609, 23, 337, '治多县'),
	(2610, 23, 337, '囊谦县'),
	(2611, 23, 337, '曲麻莱县'),
	(2612, 23, 338, '门源回族自治县'),
	(2613, 23, 338, '祁连县'),
	(2614, 23, 338, '海晏县'),
	(2615, 23, 338, '刚察县'),
	(2616, 23, 341, '同仁县'),
	(2617, 23, 341, '尖扎县'),
	(2618, 23, 341, '泽库县'),
	(2619, 23, 341, '河南蒙古族自治县'),
	(2620, 23, 339, '共和县'),
	(2621, 23, 339, '同德县'),
	(2622, 23, 339, '贵德县'),
	(2623, 23, 339, '兴海县'),
	(2624, 23, 339, '贵南县'),
	(2625, 23, 340, '格尔木市'),
	(2626, 23, 340, '德令哈市'),
	(2627, 23, 340, '乌兰县'),
	(2628, 23, 340, '都兰县'),
	(2629, 23, 340, '天峻县'),
	(2630, 23, 342, '玛沁县'),
	(2631, 23, 342, '班玛县'),
	(2632, 23, 342, '甘德县'),
	(2633, 23, 342, '达日县'),
	(2634, 23, 342, '久治县'),
	(2635, 23, 342, '玛多县'),
	(2636, 24, 348, '临河市'),
	(2637, 24, 348, '五原县'),
	(2638, 24, 348, '磴口县'),
	(2639, 24, 348, '乌拉特前旗'),
	(2640, 24, 348, '乌拉特中旗'),
	(2641, 24, 348, '乌拉特后旗'),
	(2642, 24, 348, '杭锦后旗'),
	(2643, 24, 349, '阿拉善左旗'),
	(2644, 24, 349, '阿拉善右旗'),
	(2645, 24, 349, '额济纳旗'),
	(2646, 26, 350, '昌吉市'),
	(2647, 26, 350, '阜康市'),
	(2648, 26, 350, '呼图壁县'),
	(2649, 26, 350, '玛纳斯县'),
	(2650, 26, 350, '奇台县'),
	(2651, 26, 350, '吉木萨尔县'),
	(2652, 26, 350, '木垒哈萨克自治县'),
	(2653, 26, 351, '博乐市'),
	(2654, 26, 351, '精河县'),
	(2655, 26, 351, '温泉县'),
	(2656, 26, 352, '库尔勒市'),
	(2657, 26, 352, '轮台县'),
	(2658, 26, 352, '尉犁县'),
	(2659, 26, 352, '若羌县'),
	(2660, 26, 352, '且末县'),
	(2661, 26, 352, '焉耆回族自治县'),
	(2662, 26, 352, '和静县'),
	(2663, 26, 352, '和硕县'),
	(2664, 26, 352, '博湖县'),
	(2665, 26, 353, '阿图什市'),
	(2666, 26, 353, '阿克陶县'),
	(2667, 26, 353, '阿合奇县'),
	(2668, 26, 353, '乌恰县'),
	(2669, 26, 354, '奎屯市'),
	(2670, 26, 354, '伊犁地区'),
	(2671, 26, 354, '伊宁市'),
	(2672, 26, 354, '伊宁县'),
	(2673, 26, 354, '察布查尔锡伯自治县'),
	(2674, 26, 354, '霍城县'),
	(2675, 26, 354, '巩留县'),
	(2676, 26, 354, '新源县'),
	(2677, 26, 354, '昭苏县'),
	(2678, 26, 354, '特克斯县'),
	(2679, 26, 354, '尼勒克县');
/*!40000 ALTER TABLE `districtcounty` ENABLE KEYS */;


-- 导出  表 infocomb2b.education 结构
DROP TABLE IF EXISTS `education`;
CREATE TABLE IF NOT EXISTS `education` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `education` char(50) NOT NULL DEFAULT '0',
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.education 的数据：~8 rows (大约)
DELETE FROM `education`;
/*!40000 ALTER TABLE `education` DISABLE KEYS */;
INSERT INTO `education` (`id`, `education`) VALUES
	(1, '小学'),
	(2, '初中'),
	(3, '高中'),
	(4, '中专'),
	(5, '大专'),
	(6, '本科'),
	(7, '硕士'),
	(8, '博士');
/*!40000 ALTER TABLE `education` ENABLE KEYS */;


-- 导出  表 infocomb2b.expo 结构
DROP TABLE IF EXISTS `expo`;
CREATE TABLE IF NOT EXISTS `expo` (
  `Id` tinyint(3) NOT NULL AUTO_INCREMENT,
  `pic` varchar(255) DEFAULT NULL,
  `exponame` char(50) DEFAULT NULL,
  `begindate` date DEFAULT NULL,
  `enddate` date DEFAULT NULL,
  `venue` varchar(255) DEFAULT NULL,
  `onecategoryid` int(11) DEFAULT NULL,
  `provinceid` int(11) DEFAULT NULL,
  `cityid` int(11) DEFAULT NULL,
  `unit` varchar(255) DEFAULT NULL,
  `media` varchar(255) DEFAULT NULL,
  `area` text,
  `room` varchar(500) DEFAULT NULL,
  `introduce` longtext,
  `fw` longtext,
  `areanumber` int(11) DEFAULT NULL,
  `expenses` text,
  `telephone` int(11) DEFAULT NULL,
  `fax` int(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `contactperson` varchar(255) DEFAULT NULL,
  `audit` char(50) DEFAULT NULL,
  `recommend` char(50) DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.expo 的数据：~24 rows (大约)
DELETE FROM `expo`;
/*!40000 ALTER TABLE `expo` DISABLE KEYS */;
INSERT INTO `expo` (`Id`, `pic`, `exponame`, `begindate`, `enddate`, `venue`, `onecategoryid`, `provinceid`, `cityid`, `unit`, `media`, `area`, `room`, `introduce`, `fw`, `areanumber`, `expenses`, `telephone`, `fax`, `email`, `address`, `website`, `contactperson`, `audit`, `recommend`) VALUES
	(4, 'upload/images/1393836554406.jpg', '第二十五届中国国际五金博览会暨全国五金商品交易会', '2014-03-12', '2014-03-14', '上海新国际博览中心', 24, 29, 8, '中国五金交电化工商业协会 中国建筑装饰协会 中国五矿化工进出口商会', '北京金益友联展览有限公司', '126500平方米', 'E1展厅,E2展厅,E3展厅,E4展厅,E5展厅,E6展厅,w1展厅,w2展厅,w3展厅,w4展厅,w5展厅', '经中华人民共和国商务部批准，第二十五届中国国际五金博览会定于2014年3月12-14日在上海新国际博览中心举办。作为中国历史最悠久、影响力最广的五金专业展会，中国国际五金博览会已发展成为全球规模最大的五金专业展会，深受中外五金业内人士的关注与好评。2013年3月在上海新国际博览中心成功举办的第二十三届中国国际五金博览会，展会各项指标创历史新高，展览面积近12万平米，境内外参展企业2100多家，展位总数6272个，到会专业观众超过40000人次，专业分馆更加完善、参展门类继续扩充、会期活动日益丰富，展会品质与凝聚力得到进一步提升。将于2014年3月举办的第二十五届中国国际五金博览会再求突破，启用上海新国际博览中心十一个展馆，室内外展览面积13万平米，设计标准展位6800余个，预计参展企业2500余家。本届博览会在保持工具五金传统门类增长的同时，全方位整合产业链及行业资源，大规模拓展焊接、风动器具、机械及各类机电产品，进一步提升参展品类和展品价值。当前，世界经济正处于后危机时代的温和上升阶段，中国经济继续企稳发展，中国五金行业在小五金向大五金、传统五金向现代五金转变之路上稳健前行。选择展会平台，广交四海宾朋，展示企业实力，力揽八方商机。我们相信，凭借行业的积淀与信任，依靠我们工作的热情与专注，2014年3月第二十五届中国国际五金博览会将再铸成就！让我们一同分享即将到来的行业盛宴！', '1．手动工具：传统手工具、组合工具、汽保工具、园林工具、工具箱包、量具、刃具； \r\n2．电动工具：传统电动工具、风动器具、液压工具、磨具磨料；\r\n3．机械设备：木工机械、园林机械、清洗机械、包装机械、金属加工机械、起重器材、喷涂设备；\r\n4．焊接设备：电焊设备与器材、气焊、气割设备、焊接辅机器具、焊接材料、配件；\r\n5．五金制品：建筑五金、装饰五金、门窗五金、水暖五金、卫浴五金、标准紧固件、五金杂品；\r\n6．机电产品：水泵、空压机、电动机、发电机、给排水设备、轴承；\r\n7．制造设备：锻造设备、热处理设备、光整设备、包装设备、物流设备、其它；\r\n8．其他产品：电工电料、消防器材、安全防护、劳保用品；', 21, NULL, 54971522, 51714528, 'xiuboexpo@163.com', '上海市漕宝路80号D座802室', 'http://www.hardware-fair.com/index.do', '高新', NULL, NULL),
	(5, 'upload/images/1394105299312.gif', '2014第33届中国（广州）国际家具博览会（第一期）', '2014-03-18', '2014-03-22', '中国进出口商品交易会场馆（琶洲馆）', 11, 1, 1, '广东省木材行业协会', 'E展网', '322030平方米', '1.1(A区),1.2(A区),10.1(B区),10.2(B区),10.3(B区),11.1(B区),11.2(B区),11.3(B区),12.1(B区),12.2(B区),13.1(B区),13.2(B区),14.1（C区）,14.2（C区）,14.3（C区）,14.4（C区）,15.1（C区）,15.3（C区）,15.4（C区）,16.2（C区）,16.3（C区）,16.4（C区）,2.1(A区),2.2(A区),3.1(A区),3.2(A区),4.1(A区),4.2(A区),5.1(A区),5.2(A区),6.1(A区),7.1(A区),8.1(A区),9.1(B区),9.2(B区),9.3(B区)', '作为全球规模最大的办公及商用家具展览会，中国（广州）国际家具博览会（办公环境展）专注于办公及商用承造家具行业，组织海内外知名企业围绕办公空间、酒店空间及公共空间三大主题呈现丰富多元的展品及展示案例，为包括室内设计师、承造商、大型商业机构采购、家具经销商在内的观众，提供一揽子的商业空间规划解决方案。\r\n2014年，广州办公环境展不断稳步前进，规模将超过22万平方米，参展企业达900多家，同时应数以十万计全球有商业价值的专业观众和国内外参展商的要求，展会时间从四天延长到五天，即每年3月28日-4月1日。广州办公环境展将以不断创新、不断优化的专业服务，紧联产业上下游，为行业的进步搭建高效优质的平台，谱写全新篇章。\r\n \r\n办公家具区??集中呈现办公生态的创新与变革\r\n2014年广州办公环境展将集中展现整个办公生态的创新成果，引导企业在办公概念、办公环境、现代科技与现代办公模式等领域深入思考与变革，呈现办公家具及办公环境的发展变化。办公家具区规模达17万平方米以上，由办公系统家具区、办公坐具区、办公配件区、钢制家具区四部分组成。海内外知名企业将"跨界"整合出以办公家具为主，配套以灯光照明、铺地材料、墙材、办公设备等产品的现代办公展示空间，为观众提供办公环境规划中关键问题的各种解决方案。\r\n知名企业：国誉、联友、圣奥、百利文仪、长江、兆生、健威、国靖、美力菲、新达等。\r\n \r\n酒店家具区??打造别具一格的星级酒店\r\n历届的办公环境展都不拘泥于狭义的办公家具，还同时展出包括酒店家具、公共家具在内的广义办公家具。2014年广州办公环境展酒店家具区是目前亚洲规模最大的酒店家具专业题材展，规模超过2万平方米，海内外知名企业云集，集中展现了酒店建筑空间里精美绝伦的家私及配套的灯具和艺术陈设，做到硬装和软装的合理调配，打造风格迥异的酒店空间，以满足采购商对酒店软装饰的美学及功能需求。\r\n知名企业：森源、雅柏、中新、国泰、日昌、恒美、华尚、名美轩、名辉等。\r\n \r\n公共家具区??亚洲独一无二的公共家具采购平台\r\n公共场所家具作为广义办公家具的延伸，如今已成为行业拓展新市场的重点。近年来，广州办公环境展公共家具区规模稳步增长至2万多平方米，展出学校、实验室、剧院、候机大厅乃至医院等配套家具，成为亚洲地区独一无二的公共家具采购平台，为采购商提供公共环境规划信息及相关新产品。\r\n知名企业：丽江、百匠、鸿基、名人、鸿盛等。', '办公家具           \r\n办公坐具、书柜、 办公、保险柜、 屏风、储物柜 、高隔断、文件柜、办公配件     \r\n酒店家具          \r\n酒店套房家具、酒店床垫、宴会家具、酒店沙发、酒吧桌椅\r\n公共家具           \r\n公共场所家具  (机场家具、剧院/礼堂家具等) 、公共座椅系列、学校家具、实验室家具\r\n办公场所相关设备    照明系列、墙材系列、铺地材料', 21, NULL, 31006697, 31006697, 'shenyiyong@eshow365.com', '上海普陀区西康路1068号A17B', 'http://www.eshow365.com/', '申先生', NULL, NULL),
	(6, 'upload/images/1394105635546.jpg', '第二十四届中国国际电子生产设备暨微电子工业展', '2014-04-23', '2014-04-25', '上海世博展览馆', 29, 29, 8, '励展博览集团 中国国际贸易促进委员会电子信息行业分会', 'E展网', '42000平方米', '1号馆,2号馆', '2014年4月23日-25日，第二十四届中国国际电子生产设备暨微电子工业展（NEPCON China 2014）将在上海世博展览馆隆重拉开帷幕，这将是中国表面贴装行业规模最大、影响最广、历史最悠久的一场不容错过的行业盛会之一。为期三天的展会将荟萃云集行业知名厂商，他们将在现场为大家展示当今最先进的SMT设备产品以及最前沿的行业技术，并进行现场演示，中国乃至全球表面贴装行业的新技术、新产品、新解决方案将在此得到全面呈现，届时来自中国地区的电子制造领域专业人士将聚集NEPCON China 2014，促进行业交流，见证这行业盛事。', '电子制造服务\r\n黏合剂与分离剂  \r\n仪表控制传输系统与配件\r\n化学制品  \r\n芯片载体  \r\n元件输送系统 \r\n固化系统  \r\n密封设备  \r\n烤炉与熔炉  \r\nPCB装配与制作  \r\n起重系统  \r\n流水线工具/设备 \r\n丝网印刷机与配件  \r\n视觉定位机器  \r\n电子制造服务  \r\n外包生产  \r\n常规印刷电路板组装  \r\n冲压模具冲压服务  \r\n电气机械组装   \r\n泡沫切割模具  \r\n计算机外围设备生产\r\n塑料&橡胶模具  \r\n表面贴装组装服务 \r\n工具&硬模  \r\n交钥匙\r\n组装服务\r\n元器件生产\r\nPCB及相关产品 \r\n放电加工切线设备 \r\n模具制造 \r\n数控钻头 \r\n浇筑模具机器（金属/塑料）  \r\n模具生产工具 \r\n数控磨具 \r\n金属冲压设备  \r\n工具系统  \r\n测量仪器  \r\n元器件材料  \r\n连接器   \r\n电源   \r\n芯片  \r\n其他元器件\r\n测试与测量\r\n二维/三维检测系统  \r\n球面仪器检测系统  \r\n光板测试  \r\n电子元器件视觉检测设备 \r\n胶片厚度检测设备   \r\n板内测试   \r\n红外测试设备  \r\n芯片脚架检测设备   \r\n光学显微镜 \r\n印刷电路板视觉检测设备  \r\n焊接检测设备 \r\n温度、湿度测试/环境测试设备 \r\n粘度计/示波器/温度计  \r\nX光检测设备   \r\n其他…\r\n焊接专区展品概况 \r\n拖拽式焊机  \r\n滚动式焊机  \r\n波动式焊机  \r\n回流式焊机  \r\n阻焊/焊膏/熔锡锅  \r\n烙铁头清洗装置/烙铁头 \r\n烙铁  \r\n焊台   \r\n焊锡均匀化设备 \r\n热风焊接设备  \r\n红外焊接设备  \r\n激光焊接设备  \r\n超声波焊接设备  \r\n蒸汽焊接设备  \r\n焊枪 \r\n点胶机  \r\n焊点测试仪\r\n焊接能力测试系统\r\n脱焊系统\r\n烤炉\r\n熔炉', 21, NULL, 31006697, 31006697, 'shenyiyong@eshow365.com', '上海普陀区西康路1068号维多利广场A17B', 'http://www.eshow365.com/', '申先生', NULL, NULL),
	(7, 'upload/images/1394699724359.png', '2014中国国际信息通信展览会', '2014-09-23', '2014-09-27', '中国国际展览中心', 29, 29, 7, '中华人民共和国工业和信息化部 中国国际贸易促进委员会', 'E展网（www.eshow365.com）', '', '', '2014 年中国国际信息通信展览会(PT/EXPO COMM CHINA 2014)将于2014 年9 月23 至27日在北京中国国际展览中心举行。本届展览由中华人民共和国工业和信息化部和中国国际贸易促进委员会主办，中国邮电器材集团公司和中国国际展览中心集团公司承办，美国克劳斯公司作为海外组织单位。 \r\n信息通信产业作为推动经济发展与社会进步的重要力量，发挥着越来越重要的作用。改革开放三十年来，中国信息通信产业实现了举世瞩目的大跨越。中国已经发展成为世界最重要的电信市场，运营着全球最大的用户量，汇聚着增长最快的各大制造商。由于新技术的发展以及中国信息通信技术市场的持续增长，中国市场充满了各种合作机会和投资机会。2013年，我国信息通信业继续保持平稳较快发展的良好态势。1至7月，全国电信业务总量累计完成7458.6亿元，电话用户净增992.5万户，总数达到134521.2万户。其中，移动电话用户净增1004.8万户。移动通信收入累计完成4460.3亿元，比上年同期增长11.3%，在电信主营业务收入中所占的比重从上年同期的71.64%上升到73.04%。市场格局持续改善，基础设施建设稳步推进，互联网应用迅猛发展。\r\n中国国际信息通信展览会(PT/EXPO COMM CHINA)是全球规模最大的ICT 展览会之一，也是亚洲规模最大、最具影响力的世界级信息通信展。2013 年中国国际信息通信展览会(PT/EXPO COMM CHINA 2013)总展出面积达50,000平方米，吸引了来来自中国大陆和香港、台湾地区、阿联酋、芬兰、法国、德国、印度、日本、韩国、西班牙、瑞典、丹麦、以色列、英国和美国等16个国家和地区的近500多家展团、机构和单位参展。来自新闻通讯社、电视台、广播电台、专业报刊、大众报刊、互联网站、新媒体等的200多家媒体对展览会进行了全方位、深层次、多角度、多种形式的传播和报道。\r\n随着工业与信息融合，2014年中国国际信息通信展览会(PT/EXPO COMM CHINA 2014)将在往届展览会的基础上，扩大展示范围、提供更多的交流机会以促进合作、加强融合。2014年中国国际信息通信展览会(PT/EXPO COMM CHINA 2014)必将是信息通信技术市场最重要的盛会。', '信息通信服务和应用；信息通信交换、传输技术与设备；通信终端设备及配套产品；3G/超3G 移动通信技术及设备；宽带电信业务与电信增值服务；宽带无线接入；智能终端；下一代网络（NGN）、下一代互联网（NGI）、网络电视、网络游戏、IPTV、手机视频、互动娱乐产品及服务；行业信息化应用和解决方案；二维码技术；数码、音频、视频、存储技术及产品；计算机硬件设备与软件产品；数据通信与网络技术、安全及相关产品；电信管理系统；光通信、光纤光缆；汽车电子；RFID；物流信息化技术与设备；通信电源、仪器仪表、通信机房用品、办公自动化设备；信息家电、家庭网络、数字化家庭；通信电子元器件；通信终端配件；其它信息通信配套产品；信息通信科研、设计、建设施工、咨询、统计、投资内容及产品等。', 21, NULL, 31006697, 31006697, 'shenyiyong@eshow365.com', '上海普陀区西康路1068号维多利广场A17B（近长寿路口  地铁7号线长寿路站5号出口）', 'http://www.expocommcn.com/', '申先生', NULL, NULL),
	(8, 'upload/images/1394700174171.png', '2014国际半导体设备、材料、制造和服务展览暨研讨会', '2014-03-18', '2014-03-20', '上海新国际博览中心 中国上海浦东新区龙阳路2345号', 29, 29, 8, '中国电子商会', 'E展网（www.eshow365.com）', '57500平方米', 'N1展厅,N2展厅,N3展厅,N4展厅,N5展厅', '自1988年首次在上海举办以来，SEMICON China已成为中国首要的半导体行业盛事之一，囊括当今世界上半导体制造领域主要的设备及材 料厂商。SEMICON China见证了中国半导体制造业茁壮成长，加速发展的历史，也必将为中国半导体制造业未来的强盛壮大作出贡献。', '晶圆加工设备及厂房设备\r\n在半导体制造中专为晶圆加工的厂房提供设备及相关服务的供应商，包括光刻设备、测量与检测设备、沉积设备、刻蚀设备、化学机械抛光(CMP)、清洗设备、热处理设备、离子注入设备、工厂自动化、工厂设施、拉晶炉、掩膜板制作等。\r\n晶圆加工材料\r\n在半导体制造中提供原材料和相关服务的供应商，包括多晶硅、硅晶片、光掩膜、电子气体及化学、光阻材料和附属材料、CMP 料浆、低K 材料等。\r\n测试封装设备\r\n在半导体测试和封装过程中提供设备及其他相关服务的供应商。主要涉及晶圆制程的后道工序，就是将制成的薄片“成品”加工为独立完整的集成电路。包括切割工具及材料、自动测试设备、探针卡、封装材料、引线键合、倒装片封装、烧焊测试、晶圆封装材料等。\r\n测试封装材料\r\n在半导体测试和封装过程中提供材料和相关服务的供应商，包括悍线、层压基板、引线框架、塑封料、贴片胶、上料板等。\r\n子系统、零部件和间接耗材\r\n为设备和系统制造提供子系统、零部件、间接材料及相关服务的厂商，包括质量流量控制、分流系统、石英、石墨和炭化硅等。', 21, NULL, 31006697, 31006697, 'shenyiyong@eshow365.com', '上海普陀区西康路1068号维多利广场A17B（近长寿路口  地铁7号线长寿路站5号出口）', 'http://www.eshow365.com', '申先生', NULL, NULL),
	(9, 'upload/images/1395557448750.jpg', '2014第十一届广州国际纸业展览会', '2014-07-30', '2014-08-01', '广州保利世贸展览馆', 12, 1, 1, '广东省造纸协会', 'E展网（www.eshow365.com）', '11376平方米', 'hall1', '第十一届广州国际纸业展览会（英文简称：PAPER EXPO CHINA 2013）将于2013年8月21-23日在广州琶洲保利世贸博览馆举行。展会自2004年创办以来，坚持以“促进中国纸业消费，拓展华南和国外市场”为办会宗旨，通过不懈的努力和海内外业内企业的大力支持，业已经成为中国及亚洲地区最具规模和影响力的纸张行业盛会之一。展会为促进华南及中国与国际间纸张行业上下游产业的交流和发展起到了积极的作用，为造纸企业、纸张加工企业、纸张贸易商、纸张设备商及原料商搭建了拓展中国华南地区以及亚洲地区纸张市场不可或缺的技术交流、产品展示的商贸平台，也为国内外买家搭建了一个“一站式”采购纸张的商贸平台。 PAPER EXPO CHINA 2013预计展览总面积将达12，000平方米，将汇集10多个国家及地区的逾300家参展商，集中展示最新的纸浆、纸张、纸张成品、纸张后加工设备等，发布纸张未来发展趋势。预计将吸引到来自中国、亚洲以及欧美国家和地区的15,000名业界内专业观众到会参观、采购。', '1、文化用纸、办公用纸；   \r\n2、包装用纸、印刷用纸；   \r\n3、工业用纸、各类纸板；        \r\n4、印刷包装类特种纸：艺术纸、花纹纸、珠光纸、金银卡纸、PVC装帧纸等；\r\n5、其他特种纸及纸板，包括印刷类、信息类、包装纸类、工业类、电气类、农业类、建材类、过滤类、隔温耐热纸、医疗用纸、卷烟纸、水松纸、成型纸、压敏纸、防粘纸、压敏带原纸、格拉辛纸、半透明纸等。\r\n6、生活用纸及其原纸；   \r\n7、各类纸品、纸制品；\r\n8、纸浆、废纸及其它各类纸张和纸板等；\r\n9、制浆造纸原料、化学品、设备及后加工、分切、包装、压纹等相关机械。', 21, NULL, 31006697, 31006697, 'shenyiyong@eshow365.com', '上海普陀区西康路1068号维多利广场A17B（近长寿路口  地铁7号线长寿路站5号出口）', 'http://www.eshow365.com/', '申先生', '1', '1'),
	(10, 'upload/images/1397272213765.jpg', '2014第三十四届(春季)全国摩托车及配件展示交易会', '2014-04-23', '2014-04-25', '西安曲江国际会展中心', 27, 13, 26, '中国汽车工业配件销售公司', 'E展网（www.eshow365.com）', '36000平方米', 'B1展区,B2展区,B3展区', '“第三十四届（2014春季）全国摩托车及配件展示交易会”将于2014年4月23日至25日在西安“曲江国际会展中心”召开！西安，故称长安，是中国历史上建都朝代数第一的城市，作为陕西省省会，是中国国家区域中心城市之一，西北第一大城市。西安地处中国中、西两大经济地域结合部，是西北各省通往西南、中原及华东的门户与交通枢纽，在全国经济总体布局上具有承东启西、东联西进的重要战略地位，优越的地理区位和深远的历史渊源，使西安成为中国北方西部最大的商品流通中心与物资集散地。西北地区拥有广豪的土地和众多的人口，多高山脉，摩托车行业拥有广阔的市场和空间，但摩配生产企业却不多，此次全国摩配会大胆选址西安，正是看中了其优越的地理位置和发展潜力巨大的市场，旨在为广大摩配企业提供直面西北销售市场的机会，开拓新市场，拓展销售渠道，使得夹缝中求生存的摩配行业不断保持和增强活力，此外，全国摩配会不仅重视国内市场，同时也一直在大力吸引国际参观商前来参观，实现国内外市场的积极互动，西安作为世界四大古都之一，在这方面无疑具有巨大优势。此次展示交易会在继承以往的基础上，也在不断探索新的发展道路，以期为摩托车、电动车及配件产业和相关产业带来更大的商机！曲江国际会展中心具有先进的展会设施，完善的展会服务体系，我们相信，第三十四届（2014春季）全国摩托车及配件展示交易会选址西安，将会给各位参展商带来更大的收获。', '摩托车、电动车及其零配件、轮胎、润滑油、车辆装饰用品、相关机械制造设备、工艺装备、新工艺、新材料、维修设备及防护用品等', 21, '国内标摊：6000元/个\r\n国内特装：600元/?\r\n普通展位(三层)： 5000元/单开   6000元/双开\r\n异型展位(二层)： 6000元/单开   7000元/双开\r\n特装展位： 600元/m2(二层)   500元/m2(三层) ', 31006697, 31006697, 'bq@eshow365.com', '上海普陀区西康路1068号A17B', 'http://www.eshow365.com/', '申先生', '1', NULL),
	(11, 'upload/images/1397992517265.jpg', '第二十四届中国国际电子生产设备暨微电子工业展', '2014-04-23', '2014-04-25', '上海世博展览馆', 29, 29, 8, '励展博览集团 中国国际贸易促进委员会电子信息行业分会', 'E展网（www.eshow365.com）', '42000平方米', '1号馆,2号馆', '2014年4月23日-25日，第二十四届中国国际电子生产设备暨微电子工业展（NEPCON China 2014）将在上海世博展览馆隆重拉开帷幕，这将是中国表面贴装行业规模最大、影响最广、历史最悠久的一场不容错过的行业盛会之一。为期三天的展会将荟萃云集行业知名厂商，他们将在现场为大家展示当今最先进的SMT设备产品以及最前沿的行业技术，并进行现场演示，中国乃至全球表面贴装行业的新技术、新产品、新解决方案将在此得到全面呈现，届时来自中国地区的电子制造领域专业人士将聚集NEPCON China 2014，促进行业交流，见证这行业盛事。', '电子制造服务\r\n黏合剂与分离剂  \r\n仪表控制传输系统与配件\r\n化学制品  \r\n芯片载体  \r\n元件输送系统 \r\n固化系统  \r\n密封设备  \r\n烤炉与熔炉  \r\nPCB装配与制作  \r\n起重系统  \r\n流水线工具/设备 \r\n丝网印刷机与配件  \r\n视觉定位机器  \r\n电子制造服务  \r\n外包生产  \r\n常规印刷电路板组装  \r\n冲压模具冲压服务  \r\n电气机械组装   \r\n泡沫切割模具  \r\n计算机外围设备生产\r\n塑料&橡胶模具  \r\n表面贴装组装服务 \r\n工具&硬模  \r\n交钥匙\r\n组装服务\r\n元器件生产\r\nPCB及相关产品 \r\n放电加工切线设备 \r\n模具制造 \r\n数控钻头 \r\n浇筑模具机器（金属/塑料）  \r\n模具生产工具 \r\n数控磨具 \r\n金属冲压设备  \r\n工具系统  \r\n测量仪器  \r\n元器件材料  \r\n连接器   \r\n电源   \r\n芯片  \r\n其他元器件\r\n测试与测量\r\n二维/三维检测系统  \r\n球面仪器检测系统  \r\n光板测试  \r\n电子元器件视觉检测设备 \r\n胶片厚度检测设备   \r\n板内测试   \r\n红外测试设备  \r\n芯片脚架检测设备   \r\n光学显微镜 \r\n印刷电路板视觉检测设备  \r\n焊接检测设备 \r\n温度、湿度测试/环境测试设备 \r\n粘度计/示波器/温度计  \r\nX光检测设备   \r\n其他…\r\n焊接专区展品概况 \r\n拖拽式焊机  \r\n滚动式焊机  \r\n波动式焊机  \r\n回流式焊机  \r\n阻焊/焊膏/熔锡锅  \r\n烙铁头清洗装置/烙铁头 \r\n烙铁  \r\n焊台   \r\n焊锡均匀化设备 \r\n热风焊接设备  \r\n红外焊接设备  \r\n激光焊接设备  \r\n超声波焊接设备  \r\n蒸汽焊接设备  \r\n焊枪 \r\n点胶机  \r\n焊点测试仪\r\n焊接能力测试系统\r\n脱焊系统\r\n烤炉\r\n熔炉', 21, '国内标摊：4630/? 元/个\r\n国内特装：3930元/?\r\n光地 (24 ? 起)  \r\n3930.00元/ ?   \r\n标准展位 (12 ? 起)  \r\n4630.00元/?', 31006697, 31006697, 'shenyiyong@eshow365.com', '上海普陀区西康路1068号维多利广场A17B（近长寿路口  地铁7号线长寿路站5号出口）', 'http://www.eshow365.com/', '申先生', NULL, NULL),
	(14, 'upload/images/201310150332234218.jpg', '第十三届中国国际林业、木工机械与供应展览会', '2015-03-04', '2015-03-07', '上海新国际博览中心', 10, 29, 8, '中国林业机械协会', 'E展网', '34500平方米', 'N5展厅,N3展厅,N4展厅', '由中国林业机械协会、德国汉诺威公司以及奥伟展览联盟成员华汉国际会议展览（上海）有限公司主办的第十一届中国国际林业、木业机械与供应展览、第十一届中国国际家具生产、装潢与装饰机械及配件展览以及第九届中国国际家具、建筑及装潢用木料及木制品展览于上周在上海新国际博览中心胜利闭幕。\r\n    本届展会面积比上届增长了20%，达35000 平方米。其中欧洲板材技术占到相当大的份额，同时还有更多有关林业、人造板、家具、木地板、木门窗及其他木制品生产设备的亮相。欧洲展团主要由德国VDMA 和意大利ACIMALL 会员企业组成。WoodMacChina 2011由拥有13 家会员组织，代表欧洲木工机械行业的欧洲木工机械制造商协会独家支持。国内方面则是得到中国林业机械协会和伦教木工机械商会、哈尔滨木工机械协会、青岛木工机械协会和上海木工机械同业联谊会等各地木工机械协会组织的大力支持。', '木工及家具生产设备\r\n弯曲机 拼板机 \r\n涂层处理设备 \r\n计算机数控系统 \r\n削皮机 \r\n开榫打孔机 \r\n集尘设备 \r\n压花机 \r\n指接机 \r\n林产设备 \r\n框锯机 \r\n浸渍机 \r\n覆贴面料设备 \r\n刨洗成型机 \r\n板材切锯机 \r\n后成型设备及生产线 \r\n往复锯 \r\n砂光机 \r\n推台锯 \r\n修边机 \r\nV型槽力工机械 \r\n木材干燥设备 \r\n其它	\r\n \r\n黏合机 \r\n削片机 \r\n全套板材生产设备 (交钥匙工程项目) \r\n家具设计系统 \r\n导向锯 \r\n钻孔受填装圆木榫机 \r\n封边机 \r\n雕刻机 \r\n地板生产线 \r\n四面刨 \r\n供热设备 \r\n磨刀机 \r\n覆膜压机 \r\n啧涂设备 \r\n抛光机 \r\n贴纸机 \r\n镂铣机 \r\n铣齿机 \r\n涂胶机 \r\n旋切机 \r\n废物处理设备 \r\n人造板设备\r\n \r\n相关产品\r\n空气压缩机 \r\n检测器, 分选及吃走装置 \r\n火花探测和防火设备 \r\n木屑处理设备 \r\n传感器 \r\n废木屑供热设备 \r\n其它	\r\n \r\n物料剂量投配设备 \r\n集尘设备 \r\n木材干燥室 \r\n水份测量设备 \r\n测试和实验室设备 \r\n废物处理设备\r\n \r\n木工及家具生产设备零部件及附件 \r\n研磨料 \r\n皮带 \r\n圆锯 \r\n切割工具及配件 \r\n钻孔及填装圆木榫机 \r\n马达, 发电机组 \r\n锯片 \r\n厚度控制器	\r\n \r\n钻头 \r\n硬质合金刀片 \r\n传送装置 \r\n金钢石刀具 \r\n线锯 \r\n钉枪, 钉\r\n喷枪 \r\n其它\r\n \r\n其它 \r\n行业协会\r\n网站	\r\n \r\n贸易杂志和出版社', 21, '', 62990137, 62990137, '', '中国上海浦东新区龙阳路2345号', 'http://', '', NULL, NULL),
	(15, 'upload/images/1421033558413.jpg', '2015第19届国际电子组件及生产技术展', '2015-10-01', '2015-10-16', '香港会议展览中心', 29, 31, 36, '香港贸易发展局', '慕尼黑??博??洲有限公司', '', '', '理由1(展会展望):\r\n展中有展：「?示技?世界」及「太?能光伏?子世界」是展?焦?所在，展示?今蓬勃?展的科技?域上至?重要的?品。', '出版、?子、光伏、混合、晶片、微波、印刷、元件、元器件', 852, '', 22404635, 28240249, 'exhibitions@hktdc.org', '香港?仔博?道1?', 'http://electronicasia.com/tc', '??章', NULL, NULL),
	(16, 'upload/images/1421034119773.jpg', '2015第四届深圳国际酒店设备用品展览会', '2015-10-14', '2015-10-16', '深圳会展中心', 38, 30, 30, '广州华展展览策划有限公司', '深圳市中展展览有限公司', '', '', '理由1(展会说明):\r\n一、连接海外、辐射内地、中国唯一 友谊的纽带、商贸的桥梁，2015年10月14-16日，第四届深圳国际酒店设备及用品展览会将在深圳会展中心隆重举办。\r\n\r\n理由2(行业背景):\r\n广州华展和深圳中展合力举办深圳酒店用品展，将对展会的成功举办，打下坚实的基础，2015第四届深圳国际酒店用品展将不断进取、再创辉煌，将对酒店用品行业的繁荣发展，起到积极的推动作用。\r\n\r\n理由3(上届情况):\r\n据预测，2013年，中国酒店业采购市场规模将达12000亿元。\r\n\r\n理由4(展会说明):\r\n酒店餐饮业的持续发展，为举办酒店用品展创造了良好的市场条件，深圳作为中国最大的经济特区，经济总量相当于一个中等省份，人均GDP率先突破1万美元，人均可支配收入居全国首位，是中国经济效益最好的城市之一。\r\n\r\n理由5(展会展望):\r\n深圳市中展展览有限公司也将充分利用自身资源，全力推动展会发展。\r\n\r\n理由6(上届情况):\r\n当前，中国酒店业已进入高速增长期，酒店投资规模不断扩大，全国每年大约有1600家新建酒店投入使用，总投资额近4000亿元。', '白酒、餐饮、餐饮设备、餐饮食品、厨房、大堂用品、家具、酒店、酒店布草、酒店家具、咖啡、葡萄、葡萄酒、清洁、清洁设备、食品、饮料、饮食、原材料、照明、制服、智能产品、桌面用品', 755, '', 83507908, 83507939, 'szzz1168@163.com', '深圳市福田区彩田路中银大厦B座8A', 'http://www.hosfair.com', '', NULL, NULL),
	(17, 'upload/images/1421034547945.jpg', '2015中国国际汽车商品交易会', '2015-09-19', '2015-09-22', '国家会展中心（上海）', 27, 29, 8, '中华人民共和国商务部', 'E展网', '70000平方米', '', '中国国际汽车商品交易会（CIAPE）是中国政府为适应汽车产销大国需要而搭建的自主的、满足国内外配套、售后市场需求的国际化、专业化平台。它既是出口的桥梁，也是引进消化吸收再创新的平台；既展示国外先进技术，也展示自己的实力；通过交流与合作，创造更多的机会，它是零部件整体水平提高的助推器。\r\n博览会也为世界各国的汽车零部件制造商、采购商提供了一个有效沟通的桥梁和纽带，为企业发布新产品、交流新技术、了解新趋势、获取新政策提供了一个自由、平等、专业的舞台。', '汽车零部件：\r\n发动机系统、底盘系统、车身系统、电气电子系统等；\r\n先进制造设备及关键技术；\r\n新能源汽车及相关系统部件；\r\n整车、电机、电控、电池；\r\n汽车维修养护设备及用品：\r\n维修检测诊断设备、清洗保养设备及润滑油、光膜、清洁剂等；\r\n汽车改装及服务用品：\r\n改装车、专用设备、轮毂、音响、卫星导航、内外饰部件等；\r\n汽车材料、通用部件；\r\n汽车空调\r\n汽车测试及质量监控\r\n汽车制造及装备\r\n与汽车业相关的认证、质量、金融、保险、媒体、俱乐部等', 21, '国内标摊：18620元/个\r\n国内特装：1880元/?\r\n\r\n标准展位：\r\nA 区人民币18620 元／个（3 米X 3 米）\r\nB 区人民币12320 元／个（3 米X 3 米）\r\n室内光地：\r\nA 区人民币1880 元／平方米（最少36 平方米）\r\nB 区人民币1180 元／平方米（最少36 平方米）\r\n注：双开口展位加收10%，光地展位搭建时，须另向展馆施工管理办公室支付施工场地管理费。', 62990137, 62990137, '', '中国上海市青浦区崧泽大道333号', 'http://www.eshow365.com', '', NULL, NULL),
	(18, 'upload/images/1421039243101.png', '2015中国(宁波)国际塑料橡胶工业展览会', '2015-04-23', '2015-04-25', '宁波国际会展中心', 20, 5, 81, '中国塑协工程塑料专业委员会  宁波市塑料行业协会', '际华展览服务（上海）有限公司', '', '', '【指导/支持】 中国轻工业联合会               中国塑料加工工业协会\r\n宁波市经济和信息化委员会\r\n【主办/单位】 中国塑协工程塑料专业委员会       宁波市塑料行业协会\r\n          宁波市塑料机械行业协会           宁波市橡胶商会               \r\n宁波市热塑性弹性体商会           宁波市胶粘剂及制品行业协会\r\n【支持/单位】 浙江省塑料行业协会     台州市塑料行业协会       广东省塑料工业协会\r\n上海塑料行业协会       深圳市高分子协会       宁波市磁性材料商会\r\n宁波市电线电缆商会     宁波市电工电气行业协会   宁波市石油和化工行业协会\r\n【展览时间】 布展时间：A光地搭建：4月21日-22日   B标准展位：4月22日\r\n          展览时间：4月23日-25日           撤展时间：4月25日下午3点以后\r\n【展会分析】\r\n四大主题展区构筑2015宁波国际塑料塑胶工业展览会，依托华东地区强大的产业优势，以“高品质服务、更专业优化、多方位宣传”为服务理念，为各参展商及参观商提供一个全面贸易平台与专业、可靠的参考指标；\r\n展区类型及往年部分知名厂商：\r\n一： 塑料、化工原料与助剂区：\r\n    杰事杰、俊尔、高鼎化学、巴斯夫、屹立、金发、日之升、银禧、宁波材料所、润佳、伊德尔、锦地、山今、赛日、金岛、福天、海尔、东辰、广源、威林、新长城等；\r\n二：塑料设备、配件与辅助设备区：\r\n海天、震雄、双马、海星、丰铁、金纬、伊之密、富强鑫、奇明、雄信、博创、华明、亿利、白熊、中亚、博诚、同大、东方洲强、信易、弘讯、伟立等；\r\n三：橡胶弹性体原材料、助剂与制品区：\r\n  德固赛、 朗盛、贝诺、明达、冠联、华泰、浙东、富士、永恒、德泰、浙创、恒河、联昊、和氏璧、安诺、瑞创、天宇等；\r\n四：橡胶弹性体设备、配件与辅助设备区：\r\n磐石、一像、阳明、捷和、新劲力、科盛、千普、震德、兴长佳、宏利达、科飞、华韩、科信、益联等；\r\n\r\n往届观众人数及来源分布：2014NbPlas观众总人数20657人，40%的观众第一次参观，而60%的观众以前参与过2013NbPlas。预计2015NBPLAS参观总人数将达到26000人。其中2014年参观人数中华东42%、华南26%、华北14%、西北10%、海外（港澳台）地区8%。\r\n观众类型：\r\n【展会特色与服务】\r\n1.每个参展企业均可获得邀请经销商（代理商、采购商）到场参观采购的贵宾请柬函，到场参观采购的贵宾如需宾馆服务均由组委会提供；\r\n2.报名参展后可享受在本公司合作的媒体、官网、微信平台上做名企推荐及产品介绍等服务；\r\n3.展览期间多场研讨会可凭参展证免费入场，并有相关礼品赠送；\r\n4.组委会将不定期的根据自身的条件与优势发布采购商的名单与采购的产品；\r\n5.参展企业如有需要可在展会结束后向组委会索取大会采购商名单及联系方式，组委会将根据参展商的需求免费提供相关的采购商名单，以便参展商更好的与采购商联络洽谈；\r\n6.展览期间众多礼品赠送，可凭展商证与参观证参加现场抽奖活动，欢迎参展企业赞助礼品。\r\n7.专业观众预登记可享受宾馆入住服务，并有礼品赠送。参观团同时享有大巴接送及午餐服务\r\n【广告与赞助】如需广告详细介绍或其他广告请致电组委会详询；\r\n一：钻石赞助商（独家） 赞助费：RMB 20万\r\n二：白金赞助商（独家） 赞助费：RMB 15万\r\n三：黄金赞助商（独家） 赞助费：RMB 10万 \r\n四：自定义方案： \r\n    如果以上三个方案都不能满足您的要求，请与我们取得联系，探讨一套更符合您的要求的方案！\r\n注： 1.研讨会演讲题目及内容需要提前提交至组委会备案。\r\n    2.现场易拉宝及宣传资料有赞助商自行设计及制作。\r\n    3.整版彩色广告由赞助商自行提供胶片及彩色样张。\r\n    4.所有准备材料须在2015年4月01日前提交至组委会审核,逾期未提供材料将视为自动放弃此次权利。\r\n五：会刊广告：会刊发行量20000本，提供给到场专业买家和主办单位数据库内的重要采购商，\r\n封面：22000元         封底：16000元         封二：12000元\r\n彩首：9000元         彩色内页：5000元       黑白内页：2000元\r\n六：印刷类广告：\r\n单面门票：8000元/万张     单面礼品袋：20000元/5000个\r\n单面胸牌：1元/个（1万个起做）\r\n七：展馆现场广告：\r\n支架喷绘：4000元/个     展馆南北主柱间广告：12000元/个\r\n气球广告：8000元/个     气拱门：6000元/个\r\n【参展费用】 注：双面开口展位加收20%费用。\r\n类 型      标准展台（起租9m2）       室内光地（起租36 m2）\r\n标准摊位       RMB   8800元/9m2      RMB   800元/m2\r\n豪华摊位         RMB   11800元/9m2      RMB   1200元/m2\r\n外资企业         USD$ 2800元/9m2      USD$   280元/m2\r\n配置：1.标准展台：中英文楣板、咨询桌1张、折椅2把、射灯2只、电源插座1支、纸篓1个. \r\n2.光地展台：只提供参展空间，不包展架，展具、不含特装管理费、电源费.', '展区类型及往年部分知名厂商：\r\n一： 塑料、化工原料与助剂区：\r\n    杰事杰、俊尔、高鼎化学、巴斯夫、屹立、金发、日之升、银禧、宁波材料所、润佳、伊德尔、锦地、山今、赛日、金岛、福天、海尔、东辰、广源、威林、新长城等；\r\n二：塑料设备、配件与辅助设备区：\r\n海天、震雄、双马、海星、丰铁、金纬、伊之密、富强鑫、奇明、雄信、博创、华明、亿利、白熊、中亚、博诚、同大、东方洲强、信易、弘讯、伟立等；\r\n三：橡胶弹性体原材料、助剂与制品区：\r\n  德固赛、 朗盛、贝诺、明达、冠联、华泰、浙东、富士、永恒、德泰、浙创、恒河、联昊、和氏璧、安诺、瑞创、天宇等；\r\n四：橡胶弹性体设备、配件与辅助设备区：\r\n磐石、一像、阳明、捷和、新劲力、科盛、千普、震德、兴长佳、宏利达、科飞、华韩、科信、益联等；', 21, '【参展费用】 注：双面开口展位加收20%费用。\r\n类 型      标准展台（起租9m2）       室内光地（起租36 m2）\r\n标准摊位       RMB   8800元/9m2      RMB   800元/m2\r\n豪华摊位         RMB   11800元/9m2      RMB   1200元/m2\r\n外资企业         USD$ 2800元/9m2      USD$   280元/m2', 31185634, 31185638, '420196347@qq.com', '上海市高技路435号华茸大厦1107-1108室', 'http://www.cnena.com/showroom', '丁政', NULL, NULL),
	(19, 'upload/images/1421040602851.png', '2015年深圳国际互联网与电子商务博览会', '2015-10-14', '2015-10-16', '深圳会展中心', 35, 30, 30, '深圳市物流与供应链管理协会', '深圳市合众源会展有限公司', '', '', '2015年深圳国际互联网与电子商务博览会\r\n时间：2015年10月14-16日   地点：深圳会展中心\r\n电商与物流激情碰撞，开启互联网新时代\r\n同期举办：第10届中国（深圳）国际物流与交通运输博览会\r\n    第2届跨境电商供应链管理与服务发展论坛\r\n\r\n【展会简介】\r\n2015年10月14-16日，将在深圳会展中心举办深圳国际互联网与电子商务博览会，同期举办第2届跨境电商供应链管理与服务发展论坛，上届（2014年）已吸引了超过1000名专业观众的现场参与。此外，还有由中国交通运输部和深圳市政府联合主办的目前中国唯一的国家级物流与交通运输综合博览会??第10届中国（深圳）国际物流与交通运输博览会，其规模居“亚洲第一、世界第二”。届时，将吸引来自全球40多个国家1500多家参展企业，70多个国家和地区100,000人次的专业观众和采购商的积极参与。\r\n电子商务在中国持续火爆，市场竞争却异常激烈，缺乏供应链的硬性支持，电商的生存难以为继。在这场电商淘汰赛中，只有具有竞争力的核心产品、良好的购物体验和品牌形象，完善供应链管理等都将成为活下去的砝码。互联网电子商务与物流供应链两大主题在国内首次联合展出，以物流为切点，合纵连横，打造跨境电商生态圈。物流与电子商务相互协作、资源共享，共建稳健供应链服务平台，两者的激情碰撞，将开启中国互联网产业的新时代。\r\n展会设有“品牌电商”、“电子商务生活体验”、“跨境电商”、“移动电子商务&APP”、“网络营销与新媒体”、“互联网金融”、“云计算与大数据”、“互联网娱乐”八大展区，全面、系统地展示整个互联网与电子商务行业各个环节，让来自国内外各行各业的企业代表们将可以更全面、更深入地了解互联网电子商务、物流与供应链的相互影响和重要作用。\r\n【市场大背景】 \r\n2013年中国电子商务交易额达到10.2万亿元，同比增长29.9%；其中网络零售额1.85万亿元，同比增长42.8%，约占中国社会消费品零售总额的8%，预计至2020年中国网络零售额占社会消费品零售总额的比重可达50%左右！\r\n在全国电子商务业务中，跨境电子商务的迅速崛起尤为引人注目。相比传统外贸的低迷，中国跨境电商春意盎然，并迎来黄金发展期。国内跨境电商平台企业已超过5000家，通过各类平台开展跨境电子商务业务的外贸企业已超过20万家。2013年，跨境电商的交易额约3.1万亿元，从2008年至2013年复合年均增长率高达31.1%，远高于同期我国一般贸易增长水平。\r\n　深圳市作为国内首个国家电子商务示范城市，截至2013年，全市互联网产业增加值590.59亿，年均增长20%以上，电子商务交易额超过9500亿，年均增长30%以上，网络支付借贷和股权交易等互联网金融发展，产业规模突破3000亿。深圳目前已成为国内互联网产业发展最活跃、聚集效益最优的地区之一，吸引了众多互联网巨头落户深圳，建成互联网产业园14个，超过2000家互联网企业入驻。\r\n广东省跨境电商业务占全国总额70%，其中深圳占全国总额的50％以上\r\n　　2014年9月，深圳海关在前海湾保税港区举行跨境贸易电子商务进口试点启动仪式，标志着前海在跨境电商领域进出口双向通道的全流程开通。深圳外贸出口连续22年全国第一，该地区的跨境电商发展迅速，拥有独立B2C企业和大卖家超过5000家，占据了全国跨境电商的半壁江山。目前，前海已聚集了菜鸟、顺丰等一批电商总部和华为、中兴等大型出口加工企业，吸引了DHL等一批世界级物流巨头入驻，拥有财付通、钱宝等一批优秀支付企业，形成了较为完善的跨境电商产业链。跨境电商作为一种新的贸易方式，能够改变传统贸易格局，提升中国贸易的话语权，前海要将其作为重点推进，并建成全球跨境电商网络的重要门户和核心枢纽。\r\n电子商务越来越火爆，带动了整个互联网产业（搜索引擎、网上支付、互联网营销、社交媒体、云计算等）的繁荣，电子商务的飞速发展离不开物流，物流也是实现电子商务的重要保证，二者相互依存，共同发展。电子商务是在一个效率高的计算机网络技术平台上构建的一条虚拟供应链，实现电子商务的价值过程就是一个供应链管理的过程。随着计算机网络技术的不断发展，电子商务对供应链管理产生了深远影响。电子商务和物流的融合已成为发展趋势，协调和控制供应链物流活动已成为公司电子商务经营成功的关键！', '一、电子商务展区\r\n1、B2B/B2C/C2C电子商务、跨境电子商务、知名品牌网店 \r\n2、O2O网站产品与服务（数码家电、服装鞋帽、食品饮品、孕婴童产品、生活百货）；\r\n3、移动电子商务、各种移动客户端APP、手机网站、社会化媒体； \r\n4、网络营销、联盟营销、移动营销、数字营销、搜索引擎、网络新传媒、互联网广告；\r\n5、互联网金融、各种金融和理财产品，投融资与众筹平台、银行、P2P网贷、第三方支付；\r\n二、互联网生活娱乐\r\n1、网络游戏、手机游戏软件；\r\n2、网上娱乐、网络电影、网络电视、网上阅读等各种生活类应用软件；\r\n3、在线远程教育、在线旅游、在线医疗、互联网增值服务 \r\n三、互联网技术与服务展区\r\n1、云计算、云制造、大数据分析、IDC \r\n2、网上支付与安全、移动支付与安全、数据安全管理\r\n3、网站设计、各种建站软件、网络构架；\r\n4、网络与通信运营服务商、主机托管、虚拟服务器', 20, '标准展位：3m*3m   光地：36m2以上起租\r\n国内企业参展商：9900元/展位     光地：990元/ m2\r\n国外企业参展商：16900元/展位   光地：1690元/ m2\r\n\r\n◆现场广告费用\r\n广告类别      国内（人民币）      国际（人民币）\r\n馆内条幅（2米*4米）      5000/条      6900/条\r\n展厅内观光电梯表面\r\n（高12.6米*3米）      20000/幅      30000/幅\r\n展厅内二楼观展平台玻璃护栏（长26米*宽1.2米）      29000/幅      39000/幅\r\n展会门票      6000/2万张      8800/2万张\r\n指定手提袋（10000个/组）      45000/组      55000/一万个\r\n参观证（10000个/组）      35000/组      45000/一万个\r\n会刊光碟（10000个/组）      40000/一万个      60000/一万个\r\n论坛场地租用 （100人）      20000/两小时12000/一小时      35000/两小时\r\n20000/一小时\r\n◆会刊广告费用       \r\n广告类别      国内（人民币）      国际（人民币）\r\n封面半版      30000      40000\r\n封二整版      15000      20000\r\n封三整版      10000      14000\r\n封底整版      20000      25000\r\n内彩页      6000      8800\r\n内黑白      3000      4000\r\n扉页一      13000      20000\r\n扉页      7000      8800', 61099464, 62824654, 'gzscm001@scmfair.com', '广东省广州市越秀区天河路45号天伦大厦705-706', 'http://www.cnena.com/showroom', '冯龙彬', NULL, NULL),
	(20, 'upload/images/1421040893562.png', '2015第三届中国（重庆）国际云计算博览会', '2015-04-10', '2015-04-12', '重庆国际会议展览中心', 29, 29, 29, '中华人民共和国工业和信息化部', '', '', '', '一、展会概述：\r\n中国（重庆）国际云计算博览会是云集世界云计算技术、企业、专家的高峰盛会，是我国规模最大的融展览展示、高峰会、主题活动、对接洽谈于一体的中国云计算盛会。大会通过推动行业、企业之间的协作与交流，促进云计算、大数据发展及应用市场创新，助力国内外云计算、大数据产业整体水平和市场竞争能力的提升。\r\n中国（重庆）国际云计算博览会于2012年首次举办，目前已举办两届。惠普、宏?、英特尔、富士康、思科、微软、华硕、戴尔、华为、浪潮、NEC、英业达、腾讯、中国银行、中国工商银行、日立、AMD、中国电信、中国移动、中国联通、中兴通讯、曙光信息、宝德、中国通信服务、太平洋电信、神州数码、北京磊强、东软、中冶赛迪、华三通信、城投金卡、金算盘、天元数据、TCL、志高、长虹、康佳、魅族等360多家企业参展。每届同期举办云计算高峰会，政府领导、资深专家学者以及云计算行业企业家共聚一堂，共商产业发展大计。\r\n\r\n四、专业观众邀请\r\n1、重庆市人民政府有关职能部门及区县政府职能部门；\r\n2、云计算、互联网等有关协会；\r\n3、兄弟省市经信委；\r\n4、相关企业专业技术人员、各行业信息化主管，以及兄弟省市政府信息主管单位、相关大专院校、行业科研机构研究人员。\r\n\r\n五、广告宣传：\r\n人民日报，中央电视台，新华社，中新社，重庆日报，重庆电视台，重庆人民广播电台，重庆商报，重庆晨报，重庆晚报，重庆时报，IT时代周刊，中国电子报，计算机周刊，电脑报，互联网周刊，通信产业报，数字通信世界，微型计算机，通信世界报，计算机世界，中国自动识别技术，计算机产品与流通，IT经理世界，IT价值传媒，国际商报，中国计算机报，通信世界网，中国通信在线，中关村在线，IT专家网，梅花网，百度网，腾讯网，新浪，搜狐，雅虎，网易，新华网，华龙网，中国会展网等100多家媒体将对本届展会进行全方位报道。\r\n\r\n六、上届回顾：\r\n以“云端互联&#8226;引领未来”为主题，由国家工业和信息化部、中国科学院支持，重庆市人民政府主办，市经济信息委、市发展改革委、市商委、市科委、市贸促会、两江新区管委会共同承办的2013中国（重庆）国际云计算博览会于2013年10月24日至26日在重庆国际会展中心举行。 \r\n2013云博会共设2个展馆，面积共约21000?，比上届增长40%；参展企业200多家，比上届增长31.3%；特装面积约占整个展场的93%，比上届占比超过13%。 \r\n展览分为云区、端区、大数据展区、通信网络区、增值应用体验区、综合展区、3D打印技术和机器人展区、信息电子消费节和APP中小微企业开发者展区等九个展区。惠普、微软、NEC、神州数码、英业达、华硕、腾讯、北京磊强、中国电信、中国移动、中国联通、思科、东软、太平洋电信、中冶赛迪、华三通信、重庆有线、城投金卡等多家跨国公司及国内知名企业参展。200多家单位展示了与人们日常生活紧密相关的惠普登月服务器、大数据分析平台、政府采购电子交易云服务平台、公共信息服务平台、驿票通云服务平台、消防安全云计算平台、政务云、教育云、卫生云等领先云计算产品、技术和方案。 \r\n两江新区、高新区、南岸区、永川区、西永微电园等集中展示了“云端智能重庆”形象，为观众呈现各具特色的园区建设、产业基础、优势资源等。', '1、展览内容：云计算，大数据，智能终端，移动互联网，电子商务，3D打印，可穿戴设备，机器人，物联网，智慧城市等领域企业及其产品、技术的展览展示和互动。\r\n2、高峰会：云集行业知名企业家及学者的主题高峰互动会。\r\n3、专业交流活动：以企业为主的专业推介会，招商引资说明会，参展参会企业相关实地参观考察。', 23, '1、展位费用\r\n（1）标准展位：3m×3m，7800元/个，含三面围板，中文参展单位名称楣板，两盏射灯，一个220V/5A电源插座，地毯，一张洽谈桌，两把椅子\r\n（2）特装展位：光地36?起租，780元/?，仅提供空地，若需要相关配置敬请另行申请\r\n2、技术讲座：为推广新产品、新技术、新设备，参展单位可申请举办技术讲座，组委会按10000元/场（2小时/场）收取场地及服务费用。\r\n3、广告宣传：本届大会为参展单位提供全方位的品牌推广平台，包括：会刊，专业观众邀请券，证件，手提袋，各类展场广告，各项主题活动赞助（如高峰会，专业交流活动，主题活动等），详情请向组委会办公室咨询。\r\n4、特别提示：如贵单位因特殊原因不能参加本次大会，组委会可为贵单位在本次大会会刊上刊登500字以内的企业信息，费用为1000元。', 62602116, 62602116, 'ccexpo@qq.com', '', 'http://www.cnena.com/showroom', '', NULL, NULL),
	(21, 'upload/images/1421041329546.png', '2015上海第二十三届中国国际建筑装饰展览会', '2015-03-30', '2015-04-02', '上海新国际博览中心', 24, 29, 8, '中国建筑文化中心', 'E展网', '34500平方米', 'E2展厅,E3展厅,E4展厅', '上海-中国国际建筑装饰展拥有22年悠久的历史，是全国最有影响力的综合建材盛会之一，亦是HDD (Hotelex + Design & Deco)酒店用品、装饰设计与配套产品的专业系列展的重要组成部分。作为2014年新春首场大型建材展览盛会，上海建材展一直得到诸多国内外顶尖品牌的青睐，包括斯米克、马拉齐、玫瑰、Laminam、汇晶、海福乐、安美世纪、元融、威盛亚、米卡、大津、威卢克斯、OBE、旭格、四国化成、亨特道格拉斯、罗格朗、西蒙、华艺、威罗、基士博等500多家行业知名品牌都将携其最新产品和设计亮相上海滩，展品范围涵盖门窗、幕墙、墙纸、瓷砖、卫浴、照明等综合建筑装饰领域，将吸引超过50,000名专业买家到会参观，是建材企业打好开春第一仗的首选。', '门窗遮阳：建筑门窗、自动门、室内门、车库门、金属门、门控设备、遮阳产品、阳光房、铝塑板、阳光板、钢结构等；\r\n屋面结构：斜屋顶窗、空中花园、屋顶防水材料、屋面瓦、落水系统、整体房屋等；\r\n墙体材料：幕墙系统、外墙挂板、保温材料、墙艺装饰、壁纸、隔音、隔热材料等；\r\n木制品：木门、楼梯、地板、竹木制品、防腐木、木结构房屋、木线条、板材、防火板等；\r\n室内装饰：整体家居、隔断、壁炉、橱柜、天花、吊顶、窗帘布艺、装饰画、家居饰品、艺术玻璃、装饰铁艺等；\r\n陶瓷卫浴：陶瓷系列产品、卫浴系列产品、马赛克、大理石、文化艺术石、装饰砖、砂岩雕塑、彩色地坪等；\r\n楼宇电器：智能化楼宇、建筑安全、通风设备与技术、电梯、地暖、太阳能系统等；\r\n化学建材：内外墙涂料、保温材料、填缝剂、粘胶剂等；\r\n工程设计：建筑、室内设计、酒店设计、环境规划设计、工程承包、设计软件、模型及咨询服务等。', 21, '国内标摊：14400元/个\r\n国内特装：1100元/?\r\n\r\nA.综合建材馆\r\n标准展台：RMB1200元/平方米（12平方米起租）；\r\n光地：RMB1100元/平方米；（48平方米起租）；\r\n展台提供信息桌一张，椅子两把，中英文公司楣板一条，220V电源插座一个，射灯或日光灯两只，展位内满铺地毯。\r\nB.国际精品馆\r\n标准展台：RMB1500元/平方米（12平方米起租）；\r\n光地；RMB1300元/平方米；（48平方米起租）；', 62990137, 62990137, '', '', 'http://www.eshow365.com', '', NULL, NULL),
	(22, 'upload/images/1421041581453.png', '2015中国中部门业暨装饰五金博览会', '2015-03-12', '2015-03-14', '河南郑州中原国际博览中心', 10, 17, 51, '河南省发展和改革委员会 郑州市人民政府 郑州市会展工作管理办公室', 'E展网', '6400平方米', '前广场', '随着新消费群体的成长，消费的需求正发生着改变，木门产品的消费趋势也发生着改变。未来的木门消费市场将越来越多元化，因为中国正被全世界的思想所影响，消费群里呈现非常丰富的层面。新的趋势下中国目前的在木门行业的消费趋势是于国际同步的，中国消费者对于产品需求的理念，和服务的要求与国际上需求完全是吻合的。随着中国中西部地区城镇化率和城乡居民收入水平的不断提高,对门业的需求的规模和质量必将不断提升。因此,对现阶段中西部门业的市场营销状况进行分析,从中发现问题并提出相应的营销策略,对于加快中西部门业的发展并满足不断提升的居民的需求,具有很强的应用价值.\r\n河南作为近几年新兴起来的门业生产基地，同时作为中部九省最具有潜力的消费市场，对门窗业的发展有着强力有效的促进作用。河南交通便利、四通八达，其产品运输至省内各地甚至广大西北市场，较之其他产地有着不可比拟的交通区域优势和成本优势。2013年河南省门窗业协会的成立，给河南门窗业企业的发展注入了一剂强心剂，给行业的发展确定了方向,全面促进了河南省门窗业全面发展。', '门类：实木门、原木门、实木复合门、模压门、高分子门、木塑门、塑木门、强化木门、防盗门、卷帘门、家居门、商业门、工业门、围墙大门等 \r\n电动门类：欧式卷门、快速卷门、飞机库大门、自动工业门、旋转自动门、平滑自动门、栏杆门、车库门、自动感应门、伸缩门等 \r\n门类配件：配套门禁系统、自动传感器、门镜、门机类产品、闭门器、地弹簧、合页、执手、铰链、门吸、脚轮、插销、导轨、锁具、门窗配套五金等 \r\n门类辅料：木皮、木塑、高分子材料、密封胶、结构胶、玻璃胶、锚固胶、胶条、泡沫填缝剂、密封产品等 \r\n窗类：实木门窗、铝合金门窗、塑钢门窗、彩板门窗、不锈钢门窗、玻璃钢门窗、隐形纱窗及金属门窗、斜屋顶窗、各种新型节能门窗、电动开窗机等及其配件 \r\n设备：各种门、窗产品的制造和加工设备', 21, '国内标摊：5800元/个\r\n国内特装：700元/?\r\n\r\n1、本次展会设3M×3M国际标准展位，内设2.5M高壁板、一条楣板、一张洽谈桌、两把椅子、两盏射灯、220V、5A电源插座一个。其它展俱及服务产生的费用由客商自理。\r\n2、室内空地，36平方米起租，仅提供相应空地。展示器具、用电、搭建等事项自理。\r\n收费标准（双开口标准展位加收10%展位费）：\r\n标准展位：境内企业RMB5500/个       \r\n特位： RMB5800/个\r\n室内光地：境内企业RMB700/平方米', 62990137, 62990137, '', '', 'http://www.eshow365.com', '', NULL, NULL),
	(23, 'upload/images/1421046718734.png', '2015第十五届中国厦门国际石材展览会', '2015-03-06', '2015-03-09', '厦门国际会展中心', 2, 30, 32, '', '厦门会展金泓信展览有限公司', '', '', '理由1(展会说明):\r\n十四载荣光，引领行业风向展会规模跃居全球第一 第十四届中国厦门国际石材展展览面积将达到158,000平方米，设置国际标准展位8,250个，真正成为全球最大规模的石材行业专业展览会。\r\n\r\n理由2(上届情况):\r\n十四年耕耘，成就石材梦想 第十四届中国厦门国际石材展览会于2015年3月6日-9日在厦门国际会展中心隆重举办，本届展会展览面积达115,000平方米，设置国际标准展位5900个，共有来自全球52个国家和地区的1500家企业参展。\r\n\r\n理由3(上届情况):\r\n据统计，本届展会共吸引了来自148个国家和地区的石材行业专业客商127,486人，其中境外专业观众达23,221人，这是厦门国际石材展在客商资源上的又一次突破，也是厦门石材展国际影响力增强的体现，更是中国石材行业国际口碑的提升。\r\n\r\n理由4(上届情况):\r\n中国石材的市场优势已逐步超越成本优势，让境外客商不得不重视了。\r\n\r\n理由5(展会展望):\r\n境外展览面积再创新高 厦门会展中心三期展馆将于本届展会正式投入使用，届时，三期展馆全馆3万多平方米面积将全部打造成为“国际展厅”，展会专业化和国际化程度进一步提升。\r\n\r\n理由6(展会展望):\r\n多元活动引领行业趋势 展会期间将举办“世界石材大会”、“中日石材交流会”和“石材设计师论坛”等多元活动，将中国厦门国际石材展打造成为“全球石材应用趋势和设计趋势的领先发布平台”。\r\n\r\n理由7(展会说明):\r\n品牌力量成就石材梦想 历经十三年的发展，中国厦门国际石材展品牌形象和影响力日益凸显，并荣获“2011年度中国会展产业大奖??中国十佳品牌展览会”殊荣。', '板材、板岩、大理石、防护、工艺品、花岗石、化学、机械、加工机械、监测、金刚、金刚石、金刚石锯片、锯片、开采、矿山、理石、磨具、磨料、人造石、石材、石材加工、石材加工机械、石雕、石制品、异型、异型石材、园林、', 592, '', 5959616, 5959611, 'info@stonefair.org.cn', '中国?厦门国际会议展览中心', 'http://www.stonefair.org.cn', '', NULL, NULL),
	(24, 'upload/images/1421371708359.png', '2015第25届中国华东进出口商品交易会', '2015-03-01', '2015-03-05', '上海新国际博览中心', 36, 29, 8, '世博集团上海外经贸商务展览公司', '', '', '', '理由1(上届情况):\r\n　第23届华交会将于2013年3月1日?5日在上海新国际博览中心开幕，展览面积达11.35万平方米，设标准展位5000多个。\r\n\r\n理由2(展会展望):\r\n诚邀境内外客商参展、参观、洽谈。\r\n\r\n理由3(展会展望):\r\n第25届华交会将于2015年3月1日至5日在上海新国际博览中心举行。\r\n\r\n理由4(上届情况):\r\n展览面积达11.5万平方米，标准展位5800余个，仍设置轻工纺织服装类展品。\r\n\r\n理由5(展会展望):\r\n诚邀境内外客商参展、参观、洽谈。\r\n\r\n理由6(展会说明):\r\n中国华东进出口商品交易会(简称“华交会”) 是中国规模最大、客商最多、辐射面最广、成交额最高的区域性国际经贸盛会。\r\n\r\n理由7(展会说明):\r\n是中国规模最大、客商最多、辐射面最广、成交额最高的区域性国际经贸盛会。\r\n\r\n理由8(上届情况):\r\n　自1991年以来，华交会已成功举办了20届。\r\n\r\n理由9(上届情况):\r\n第22届华交会在上海新国际博览中心举行，展览面积达10.35万平方米，设标准摊位5312个，分4个专业展区（服装、家用纺织品、装饰礼品、日用消费品展区），参展企业3300余家。\r\n\r\n理由10(上届情况):\r\n　第21届华交会有来自全世界123个国家和地区的近3.7万名客商和10万名国内专业客户到会洽谈，出口成交总额达42.36亿美元。', '办公、办公用品、包装、标签、餐厨用品、成衣、储存、床上、床上用品、地毯、纺织、纺织品、服装、服装面料、服装饰品、工艺品、挂毯、户外、护理、护理用品、纪念品、家居、家居装饰、家居装饰品、家庭、家庭用品、家用、家用纺织品、节日、乐器、礼品、旅游、旅游用品、面料、器皿、清洁、清洁用品、日用消费品、饰品、陶瓷、体育、玩具、洗浴、洗浴用品、相框、箱包、消费品、鞋帽、休闲、休闲用品、眼镜、玉雕、运动用品、纸品、纸制品、钟表、钟表眼镜、珠宝、装饰、装饰品、', 21, '', 52881111, 33030072, 'chinadeptcn@yahoo.com.cn', '上海天目西路511号锦程大厦12楼', 'http://www.ecf.gov.cn', '王丽莉、黄佳沁', NULL, NULL),
	(25, 'upload/images/1421372134671.png', '2015第十一届广州国际汽车改装服务业展览会', '2015-01-16', '2015-01-18', '中国进出口商品交易会展馆（琶洲展馆）', 27, 1, 1, '', '广州九州传媒广告有限公司', '', '', '理由1(展会说明):\r\n2015年春节比2014年春节晚了近3周，元宵结束后已经是3月5日，被称为“世纪最晚春节”。\r\n\r\n理由2(展会展望):\r\n让我们汽车后市场行业同仁结伴搭乘时光穿梭机提前经历一下这场“最晚春节”：咱们欢天喜地过完2015春节，踌躇满志地例行参加节后汽车用品大展，路上一不小心被“2月4日至3月15日的春运客流高峰期”撞个满怀，届时仓促应战三月撞期的全国各地经销商订货会，正忙得七荤八素奋力捉住春天的小尾巴，猛一抬头，却黯然神伤地发现2015的春季已经“喵”的一声溜走了，只能痛心疾首地唱起《时间都去哪儿了》。\r\n\r\n理由3(上届情况):\r\n审时度势与市场调研之后，九州昭告天下：2015AAITF广州展将于春节前一个月（1月16-18日）举办！小伙伴们惊呆了，有人为之担忧、有人为之纠结、有人为之拍手、有人为之兴奋，更有人淡定如初，一切尽在掌握中！愿闻其详？且听笔者娓娓道来。\r\n\r\n理由4(展会说明):\r\n参展无疑是企业建立品牌及开拓渠道的最有效途径之一，苦了两手抓的参展企业南北赶考，满腹苦水地梦想着广州展和北京展时间错开点，方便大伙办点事。\r\n\r\n理由5(展会展望):\r\n梦想能否照进现实？2015年的年历是关键。', 'CD盒、led、LED灯、保护膜、保险、保险丝、保险箱、表面处理、冰箱、玻璃、插座、车灯、车蜡、车辆、车身、车载、车载冰箱、车载充电器、充电、充电器、窗帘、倒车雷达、灯具、灯泡、底盘、地图、电池、电源、电源插座、多媒体、儿童、方向盘、方向盘套、防爆、防爆膜、防盗、防盗器、防盗锁、防冻液、防腐、防腐剂、防护、防护用品、风扇、扶手、改装、隔热、隔热膜、隔音、隔音材料、工作灯、功放、供应、供应商、挂件、光亮剂、海绵、衡器、后视镜、护理、护罩、化工、化工原料、火花、火花塞、机械、机油、记录仪、继电器、加湿器、监测、检测仪、检测仪器、脚垫、脚踏板、节温器、警示、均衡器、咖啡、抗磨剂、空气、空气清新剂、拉杆、喇叭、雷达、冷却、冷却液、连锁、轮毂、轮胎、美容、模块、内饰、排气、抛光、喷枪、喷涂、皮带、皮革、平衡、漆面保护膜、启动、汽车、汽车灯、汽车电器、汽车电子、汽车内饰、汽车配件、汽车漆、汽车涂料、汽车香水、汽车氧吧、汽车音响、汽车油漆、清洁、清洁剂、清洗、软件、润滑、润滑剂、润滑油、散热、散热器、刹车、刹车灯、刹车片、升降、手机、水泵、水冷、剃须、剃须刀、添加剂、通讯、头枕、涂料、涂装、涂装设备、外饰、尾灯、涡轮、雾灯、洗车、氙气灯、线材、线束、香水、行李架、修补、蓄电、蓄电池、悬挂、养护、氧吧、音响、引擎、油漆、釉、娱乐、原子灰、照明、照明系统、诊断、支架、纸巾盒、中控锁、转换、转换器、转向、转向灯、装饰、装饰灯、座垫、座套、座椅、', 20, '', 38219961, 38219935, '', '广州市体育西路123号新创举大厦11楼', 'http://', '', NULL, NULL),
	(26, 'upload/images/1421373282437.png', '2015第十二届中国国际五金电器博览会', '2015-04-20', '2015-04-22', '义乌国际博览中心', 24, 5, 59, '中国五金交电化工商业协会 义乌市人民政府', 'E展网', '30400平方米', 'A1,B1,C1,D1', '中国国际五金电器博览会，自2004年起，已在浙江义乌成功举办十一届，在全国五金电器类主题的专业展会中，展会规模、外向度、成交额等各项指标均名列前茅，已成为国内五金电器行业的外向度较高的国际性专业展会，被业界评为“全国行业十佳展会”、“全国行业展会金鼎奖”。', '五 金：\r\n五金工具：手动工具、电动工具、气动工具、通用配件、汽摩工具（配件）、园林工具等 \r\n建筑五金：建筑器材、装潢五金、水暖器材、阀门、门窗及配件、卫浴洁具、锁具、标准紧固件等 \r\n礼品五金：烟具礼品、五金工艺品、装饰五金、装饰挂件等\r\n日用五金：五金器皿、不锈钢制品、刀剪、剃须刀、量具量仪等\r\n厨卫酒店用品：厨房用品、卫生洁具、酒店用品等\r\n五金休闲用品：滑板车、安全防护用品、户外休闲旅游用品、办公文教设备等\r\n电子电器：\r\n电器产品：大家电、小家电、空调及制冷设备、照相通讯器材、灯具灯饰、插头插座等 \r\n电子产品：钟表、仪器仪表、数码产品、电讯产品等 \r\n电气电工：电气产品、电工电料、仪器仪表等 \r\n配件器材：电子配件、电器配件、电脑配件等\r\n机械机电：\r\n加工机械：小型机械、木工机械、园林机械、清洗机械、包装机械、起重机械、工程机械等\r\n机械设备：喷涂设备、金属加工设备、装配机械、缝配整烫设备、风机＼排风设备、其他机械设备等\r\n五金机床：车床、铣床、钻床、磨床、锯床、拉床、刨床、数控机床等\r\n机电产品：空压机、发电机、电焊机、砂轮机、增压泵等\r\n模具产品：注塑模具、汽车模具、风叶模具、家电模具、日用品模具等', 21, '国内标摊：6000元/个\r\n国内特装：600元/?\r\n国际标准展位3*3 6000元/个 光 地600元/平方米\r\n注：1.双开展位加收 800元/个（包括光地、标准展位）\r\n2.标准展位含：企业楣板、一张洽谈桌、两条折椅、两盏射灯、一个220V插座\r\n3.室内光地（18平方米 起租，不提供任何展具）', 62990137, 62990137, '', '', 'http://www.eshow365.com', '', NULL, NULL),
	(27, 'upload/images/1421375147578.png', '2015国际电力设备及技术展览会 第九届国际电工装备展览会', '2015-10-14', '2015-10-16', '上海世博展览馆', 32, 29, 8, '中国电力企业联合会', 'E展网', '34000平方米', '2号馆,3号馆', '国内电力行业中规模最大、最具影响力的品牌电力展国际电力电工展（EP），始于1986年，由中国电力企业联合会主办，国内唯一获全球展览业协会认可(UFI Approved Event)之专业电力电工展。\r\n每年轮流于北京、上海举办，承蒙业界人士及海内外参展商多年来的大力支持，2015年将迎来第十届上海国际电力设备及技术展览会 (EP Shanghai 2015)暨第九届上海国际电工装备展览会 (Electrical Shanghai 2015) 。展会于2015年10月14-16日，在上海世博展览馆盛大举行，展出面积达35,000平方米，参展商数目达1000家业内知名企业，展会规模再创历届高峰。', '输配电设备 \r\n发电设备-火电 / 水电 / 核能 \r\n其它供选择的能源 - (风能、太阳能、地热及潮汐发电设备等) \r\n整厂设备及工程 \r\n电力调度系统设备 (SCADA / DMS / EMS 系统) \r\n控制及测试电力设备及仪器 \r\n电力信息科技 \r\n建筑电气及机电装置 (楼宇管理及控制系统、开关设备、照明系统等) \r\n低压电工设备及器材 \r\n电器电子设备 \r\n自动化设备 \r\n工业用电设备 (不间断电源、柴油电发电机及交流发电机等) \r\n环保技术及设备 \r\n电力 / 电工产品生产设备、机械及原料', 21, '', 62990137, 62990137, '', '', 'http://www.eshow365.com', '', NULL, NULL),
	(28, 'upload/images/untitled15.png', '第七届上海国际数字标牌及触摸技术展览会', '2015-09-16', '2015-09-18', '上海世博展览馆', 29, 29, 8, '中国电子视像行业协会大屏幕投影显示设备分会 中国计算机用户协会市场发展分会 全国商业电子信息化推广办公室 上海市多媒体行业协会 上海通信广播电视行业协会 亚洲博闻有限公司', 'E展网', '29000平方米', '2号馆,4号馆', '上海国际数字标牌及视听集成技术展览会历经五届，第六届于2014年9月25-27日在上海世博展览馆圆满闭幕, 此次展会得到了美国数字标牌协会(Digital Signage Association)?Digital Signage Consortium & Nano Opt.Media Inc、中国广告协会户外分会、台湾数位看板多媒体联盟（DSMA TAIWAN）、上海多媒体行业协会及上海通信广播电视行业协会等国内外行业组织的大力支持。主要展示产品涵盖大屏幕显示终端、LCD拼接、LCD显示器、LED显示、3D裸眼显示、激光投影、广告机、户外机、虚拟试衣、触摸一体机、多点触控、多媒体信息发布展示系统、内容制作、高清传输处理及相关配件与服务等各个环节。\r\n本届展会展出面积约25000平米,汇集数字标牌、多媒体展示约500多家国内外知名企业参展。如: Samsung、Panasonic、Intel、AMD、AOpen、Shuttle、VIA Technologies、Star-Media、Cayin、Phistek、DT Research、联建、熊猫、蓝硕、三思、迅豹、宝锐视、希沃、创显、优熠、华欣、阳天、中银、VXPLO、安图、精研、灵畅、StreamTV、三阳、天禄、斯博锐意、视美乐、易维视、信安、欧帝、维冠、新节奏、汇兴博业、数源、瑞博、华北科技、华北工控、杰和、康士达、瑞葆、集优等皆在展会现场展示了他们的最新产品及技术，可谓精彩纷呈盛况空前。\r\n美国数字标牌协会、Samsung、Intel、AMD、Scala、奥维、HDBaset、台湾数位看板多媒体联盟、56IQ、AOPEN等单位的技术交流会更是给与会者带来了深入交流技术更新及发展趋势的完美平台,深受各与会者欢迎；\r\n2015年，第七届上海国际数字标牌及视听集成技术展览会将与被誉为“广告业奥斯卡”的第十三届广州国际广告标识展（上海站）、第十一届广州国际LED展（上海站）同馆同时间召开。与旗下的中国国际自助服务产品及自动售货机系统展、上海国际数字会议展、上海国际多媒体应用及人机交互展同期召开，实现行业互补，资源共享，无疑将会是业内各大企业全面展示最新技术、产品和解决方案的最佳平台。在2015年展会上您将看到更多国外厂商参展，超500多家国内知名厂商参展，更有几十场精彩论坛演讲。相信2015年我们的展会将更上规模,更具代表性,也希望能有更多的伙伴和我们一起相聚上海, 助力这一新兴行业的发展!', '1、数字告示、数位电子看板、网络广告机、多媒体信息发布系统、高清联网信息发布系统、嵌入式流媒体播放系统。液晶广告机、触控一体机、互动式广告载体。面部识别，视频图像分析处理。多媒体内容(制作、管理、整合)软件、远程监控等。\r\n \r\n2、大屏幕显示终端、LCD液晶显示器、LCD液晶拼接、等离子显示器、LED显示系统、裸眼3D显示设备、激光显示、虚拟成像、多屏幕显示、OLED、柔性显示等。\r\n \r\n3、电容式触摸屏、多点触摸屏、红外触摸屏、表面声波触摸屏、光学触摸屏、触摸一体机、手写板、触控面板、ITO导电膜等触摸屏解决方案等。\r\n \r\n4、高清传输、无线传输系统、VGA传输器、KVM延长器、矩阵、多屏处理及控制系统、边缘融合、液晶支架、设备安装等。', 21, '国内标摊：15800元/个\r\n国外标摊：4000美元/个\r\n国内特装：1580元/?\r\n国外特装：400美元/?\r\n9?标准展台 （注：双面开口展位加收10％费用） \r\n中资企业：￥15800元/个/展期   外资企业：$4000/个/展期\r\n每标准展位包括：三面围板、公司楣板、一桌二椅、二只射灯、220V/5A电源插座一个、展位铺满地毯、二十四小时保洁、保安。\r\n室内光地（注:最少36平方米起租，只提供参展空间，不包含任何设施）\r\n中资企业：￥1580元/?/展期  外资企业：$400/?/展期', 62990137, 62990137, '', '', 'http://', '', NULL, NULL),
	(29, 'upload/images/1421376409828.png', '第二十五届中国国际自行车展览会', '2015-05-06', '2015-05-09', '国家会展中心（上海）', 27, 29, 8, '中国自行车协会', 'E展网', '143432平方米', '1,2,3,4.1,4.2,北厅', '随着中国自行车消费市场日益繁荣，一方面，国内自行车行业正分享着改革开放带来的红利，内外销呈现出欣欣向荣景象，并通过“中国展”这一平台赢得更多的国际市场份额；另一方面，国内外自行车品牌纷纷看好中国自行车市场，并欲通过“中国展”这一连接中外自行车市场的桥梁，展示自身在自行车领域的实力与成就。', '自行车及零部件\r\n电动自行车及零部件\r\n童车及零部件\r\n相关设备、工艺、材料及相关出版物\r\n骑行装备、户外运动用品、户外休闲用品', 21, '', 62990137, 62990137, '', '', 'http://www.eshow365.com', '', NULL, NULL);
/*!40000 ALTER TABLE `expo` ENABLE KEYS */;


-- 导出  表 infocomb2b.factory 结构
DROP TABLE IF EXISTS `factory`;
CREATE TABLE IF NOT EXISTS `factory` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `oem` enum('Y','N') NOT NULL,
  `Research and development department number of people` int(11) NOT NULL,
  `month output` int(11) NOT NULL,
  `unit` int(11) NOT NULL,
  `workshop area` int(11) NOT NULL,
  `quality control` char(50) NOT NULL,
  KEY `id` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.factory 的数据：~0 rows (大约)
DELETE FROM `factory`;
/*!40000 ALTER TABLE `factory` DISABLE KEYS */;
/*!40000 ALTER TABLE `factory` ENABLE KEYS */;


-- 导出  表 infocomb2b.hrbigclass 结构
DROP TABLE IF EXISTS `hrbigclass`;
CREATE TABLE IF NOT EXISTS `hrbigclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hrbigclassname` varchar(50) DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.hrbigclass 的数据：11 rows
DELETE FROM `hrbigclass`;
/*!40000 ALTER TABLE `hrbigclass` DISABLE KEYS */;
INSERT INTO `hrbigclass` (`id`, `hrbigclassname`) VALUES
	(1, 'IT｜电子商务｜通信｜电子'),
	(2, '销售｜客服｜技术支持'),
	(3, '会计｜金融｜银行保险'),
	(4, '生产｜营运｜采购｜物流'),
	(5, '生物｜制药｜医疗｜护理'),
	(6, '广告｜市场｜媒体｜艺术'),
	(7, '建筑｜房地产'),
	(8, '人事｜行政｜项目｜管理'),
	(9, '咨询｜法律｜教育｜科研'),
	(10, '服务业'),
	(11, '公务员｜翻译｜其他');
/*!40000 ALTER TABLE `hrbigclass` ENABLE KEYS */;


-- 导出  表 infocomb2b.hrjobname 结构
DROP TABLE IF EXISTS `hrjobname`;
CREATE TABLE IF NOT EXISTS `hrjobname` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hrbigclassid` int(11) DEFAULT NULL,
  `hrsmallclassid` int(11) DEFAULT NULL,
  `hrjobname` varchar(50) DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=217 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.hrjobname 的数据：213 rows
DELETE FROM `hrjobname`;
/*!40000 ALTER TABLE `hrjobname` DISABLE KEYS */;
INSERT INTO `hrjobname` (`id`, `hrbigclassid`, `hrsmallclassid`, `hrjobname`) VALUES
	(1, 1, 1, '高级硬件工程师'),
	(2, 1, 3, 'Web软件开发工程师（互联网软件开发工程师）'),
	(3, 1, 3, '网页设计/制作/美工'),
	(4, 1, 3, 'Flash设计/开发'),
	(5, 1, 3, '网站编辑'),
	(6, 1, 3, '脚本开发工程师'),
	(7, 1, 3, '电子商务专员'),
	(8, 1, 3, 'UI 设计师/顾问'),
	(9, 1, 2, '软件工程师'),
	(10, 1, 2, '高级软件工程师'),
	(11, 1, 2, 'ERP技术开发'),
	(12, 1, 2, '数据库工程师/管理员'),
	(13, 1, 2, '软件UI设计师/工程师'),
	(14, 2, 9, '电话销售'),
	(15, 2, 9, '销售代表'),
	(16, 2, 9, '经销商'),
	(17, 11, 66, '在校学生'),
	(18, 11, 66, '其他'),
	(19, 11, 67, '储备干部'),
	(20, 11, 67, '培训生'),
	(21, 11, 67, '实习生'),
	(22, 11, 67, '其他'),
	(23, 9, 55, '大学教授'),
	(24, 9, 55, '中学教师'),
	(25, 9, 55, '小学教师'),
	(26, 9, 55, '讲师/助教'),
	(27, 9, 55, '院校教务管理人员'),
	(28, 9, 55, '校长'),
	(29, 8, 50, '首席执行官CEO/总裁/总经理'),
	(30, 8, 50, '总监/部门经理'),
	(31, 8, 50, '办事处/分公司/分支机构经理'),
	(32, 4, 16, '生产文员'),
	(33, 4, 16, '生产主管/督导/领班/组长'),
	(34, 4, 16, '生产计划/物料管理(PMC)'),
	(35, 4, 16, '生产经理/车间主任'),
	(36, 4, 16, '工厂经理/厂长'),
	(37, 4, 19, '技工'),
	(38, 4, 19, '普工/操作工'),
	(39, 4, 19, '裁缝印纺熨烫'),
	(40, 4, 19, '模具工'),
	(41, 4, 19, '钳工/机修工/钣金工'),
	(42, 4, 19, '车工/磨工/铣工/冲压工/锣'),
	(43, 4, 19, '切割技工'),
	(44, 4, 19, '电焊工/铆焊工'),
	(45, 4, 19, '电工'),
	(46, 4, 19, '水工/木工/漆工'),
	(47, 4, 19, '汽车修理工'),
	(48, 4, 19, '叉车工'),
	(49, 10, 59, '饼房/面包房厨师长'),
	(50, 10, 59, '炉灶厨师'),
	(51, 10, 59, '中厨厨师长'),
	(52, 10, 59, '行政总厨/技术总厨/出品总监'),
	(53, 10, 59, '打荷主管/领班'),
	(54, 10, 59, '打荷厨师'),
	(55, 10, 59, '冷菜厨师'),
	(56, 10, 59, '上什/蒸灶厨师'),
	(57, 10, 59, '食雕厨师'),
	(58, 11, 69, '场长(农/林/牧/渔业)'),
	(59, 4, 18, '技术研发工程师'),
	(60, 4, 18, '产品工艺/制程工程师'),
	(61, 4, 18, '工程/机械绘图员'),
	(62, 4, 18, '机械工程师'),
	(63, 4, 18, '模具工程师'),
	(64, 4, 18, '注塑工程师/技师'),
	(65, 4, 18, 'CNC工程师'),
	(66, 4, 18, '机电工程师'),
	(67, 1, 7, '集成电路IC设计/应用工程师'),
	(68, 1, 7, '电子工程师/技术员'),
	(69, 1, 7, '电子技术研发工程师'),
	(70, 1, 7, '射频工程师'),
	(71, 1, 7, '电路工程师/技术员(模拟/数字)'),
	(72, 1, 7, '电声/音响工程师/技术员'),
	(73, 1, 7, '半导体技术'),
	(74, 1, 7, '电子软件开发(ARM/MCU...)'),
	(75, 1, 7, '嵌入式硬件开发(主板机…)'),
	(76, 1, 7, '嵌入式软件开发(Linux/单片机/DL'),
	(77, 1, 7, '电池/电源开发'),
	(78, 9, 57, '科研人员'),
	(79, 9, 57, '科研管理人员'),
	(80, 9, 57, '其他'),
	(81, 1, 6, '电信网络工程师'),
	(82, 1, 6, '无线通信工程师'),
	(83, 1, 4, '信息技术经理/主管'),
	(84, 7, 35, '古建筑设计师'),
	(85, 7, 35, '建筑师/建筑设计师'),
	(86, 7, 36, '采购'),
	(87, 7, 36, '地基工程师'),
	(88, 7, 36, '混凝土工程师'),
	(89, 7, 36, '建筑材料工程师'),
	(90, 7, 36, '测量员'),
	(91, 7, 45, '钢结构工程师'),
	(92, 3, 14, '银行柜员'),
	(93, 3, 14, '营业部大堂经理'),
	(94, 4, 24, '汽车设计工程师'),
	(95, 4, 24, '汽车电子工程师'),
	(96, 4, 24, '内外饰装配工艺工程师'),
	(97, 4, 24, '冲压工程师'),
	(98, 4, 24, '焊接工程师'),
	(99, 4, 24, '涂装工程师'),
	(100, 4, 24, '底盘及传动系统工程师'),
	(101, 4, 24, '底盘设计工程师'),
	(102, 4, 24, '机电一体化工程师'),
	(103, 4, 24, '混合动力控制系统工程师'),
	(104, 4, 24, '高级技工/操作员'),
	(105, 4, 24, '采购工程师'),
	(106, 4, 24, '机械专业人员'),
	(107, 4, 24, '设备/模具'),
	(108, 4, 24, '电子产品设计'),
	(109, 4, 24, '总装工程师'),
	(110, 7, 42, '给排水工程师'),
	(111, 7, 42, '水暖工程师'),
	(112, 6, 29, '广告创意/设计经理'),
	(113, 6, 34, '平面设计师'),
	(114, 3, 12, '出纳员'),
	(115, 3, 12, '统计员'),
	(116, 3, 12, '会计文员'),
	(117, 3, 12, '会计'),
	(118, 3, 12, '财务主管/总帐主管'),
	(119, 10, 60, '发型师'),
	(120, 10, 60, '发型助理/学徒'),
	(121, 8, 49, '人事主管'),
	(122, 8, 49, '人事经理'),
	(123, 8, 49, '招聘专员/助理'),
	(124, 8, 49, '招聘经理/主管'),
	(125, 4, 20, '服装/纺织设计'),
	(126, 4, 20, '面料辅料开发'),
	(127, 4, 20, '面料辅料采购'),
	(128, 4, 20, '服装/纺织/皮革跟单'),
	(129, 4, 20, '服装/纺织/皮革工艺师'),
	(130, 4, 20, '打样/制版'),
	(131, 4, 20, '电脑放码员'),
	(132, 1, 3, '网站推广'),
	(133, 1, 3, '网站策划'),
	(134, 1, 3, 'Flash设计/开发'),
	(135, 1, 2, '需求工程师'),
	(136, 1, 2, '系统分析员'),
	(137, 1, 1, '硬件工程师'),
	(138, 1, 1, '硬件测试人员'),
	(139, 1, 1, '其它'),
	(140, 1, 3, '网店店长/客服'),
	(141, 1, 6, '手机软件开发工程师'),
	(142, 1, 6, '手机应用开发工程师'),
	(147, 1, 2, '系统架构设计师'),
	(144, 1, 7, '家用电器/数码产品研发'),
	(145, 1, 7, '变压器与磁电工程师'),
	(148, 1, 2, 'ERP 实施顾问'),
	(149, 3, 12, '财务总监'),
	(150, 3, 12, '财务经理'),
	(151, 4, 18, '焊接工程师/技师'),
	(152, 4, 18, '装配工程师/技师'),
	(153, 4, 18, '电力工程师/技术员'),
	(154, 4, 18, '光源与照明工程'),
	(155, 4, 18, '光伏系统工程师'),
	(156, 4, 18, '汽车/摩托车工程师'),
	(157, 4, 18, '产品规划工程师'),
	(158, 4, 18, '技术研发经理/主管'),
	(159, 6, 34, '动画/3D设计'),
	(160, 6, 34, '包装设计'),
	(161, 6, 34, '工艺品/珠宝设计鉴定'),
	(162, 6, 34, '工业/产品设计'),
	(163, 6, 34, '家具/家居用品设计'),
	(164, 6, 34, '玩具设计'),
	(165, 6, 34, '多媒体设计'),
	(166, 6, 34, '绘画'),
	(167, 6, 34, '平面设计经理/主管'),
	(168, 6, 34, '平面设计总监'),
	(169, 4, 24, '厂长/店长'),
	(170, 4, 24, '汽车用品/配件'),
	(171, 4, 24, '汽车零部件销售'),
	(172, 4, 24, '汽车零部件销售'),
	(173, 4, 24, '区域销售经理/主管'),
	(174, 4, 24, '销售/业务/公关'),
	(175, 4, 24, '车间经理/主任'),
	(176, 4, 24, '技术总监/经理'),
	(177, 4, 24, '汽车美容'),
	(178, 4, 24, '贴膜技师'),
	(179, 4, 24, '创意设计师'),
	(180, 4, 24, '轮胎工'),
	(181, 4, 24, '钣金工'),
	(182, 4, 24, '喷漆/调漆工'),
	(183, 4, 24, '车身/造型设计'),
	(184, 7, 36, '桩基工程师'),
	(185, 7, 36, '工程车司机'),
	(186, 7, 36, '调度员'),
	(187, 7, 36, '结构工程师'),
	(188, 7, 36, '加固工程师'),
	(189, 7, 36, '混凝土工程师'),
	(190, 7, 36, '防护/防化工程师'),
	(191, 7, 36, '工程总监'),
	(192, 7, 35, '绘图员'),
	(193, 7, 35, '施工图设计师'),
	(194, 7, 35, '总图设计师'),
	(196, 7, 35, '效果图/渲染/建模'),
	(197, 7, 35, '平面/动画设计/多媒体制作'),
	(198, 7, 35, '总建筑师/高级建筑师/主创建筑师'),
	(199, 7, 38, '劳务员'),
	(200, 7, 38, '施工员'),
	(201, 7, 38, '监理员/工程师'),
	(202, 7, 39, '室内设计师'),
	(203, 7, 39, '效果图/渲染/建模'),
	(204, 7, 39, '装饰设计师/工程师'),
	(205, 7, 39, '空间设计师'),
	(206, 7, 39, '门窗设计师/工程师'),
	(207, 7, 39, '家具设计师'),
	(208, 7, 39, '幕墙设计师/工程师'),
	(209, 7, 48, '销售/经纪人/置业顾问'),
	(210, 7, 48, '市场推广'),
	(211, 7, 48, '市场推广'),
	(212, 7, 48, '市场调研'),
	(213, 7, 48, '市场策划/创意文案'),
	(214, 7, 48, '总监/经理/主管'),
	(215, 7, 48, '房产中介'),
	(216, 7, 48, '其他');
/*!40000 ALTER TABLE `hrjobname` ENABLE KEYS */;


-- 导出  表 infocomb2b.hrsmallclass 结构
DROP TABLE IF EXISTS `hrsmallclass`;
CREATE TABLE IF NOT EXISTS `hrsmallclass` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `hrbigclassid` int(11) DEFAULT NULL,
  `hrsmallclassname` varchar(50) DEFAULT NULL,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.hrsmallclass 的数据：71 rows
DELETE FROM `hrsmallclass`;
/*!40000 ALTER TABLE `hrsmallclass` DISABLE KEYS */;
INSERT INTO `hrsmallclass` (`id`, `hrbigclassid`, `hrsmallclassname`) VALUES
	(1, 1, '计算机硬件'),
	(2, 1, '计算机软件'),
	(3, 1, '互联网/电子商务/网游'),
	(4, 1, 'IT-管理'),
	(5, 1, 'IT-品管、技术支持及其它'),
	(6, 1, '通信技术开发及应用'),
	(7, 1, '电子/电器/半导体/仪器仪表'),
	(8, 2, '销售管理'),
	(9, 2, '销售人员'),
	(10, 2, '销售行政及商务'),
	(11, 2, '客服及技术支持'),
	(12, 3, '财务/审计/税务'),
	(13, 3, '金融/证券/期货/投资'),
	(14, 3, '银行'),
	(15, 3, '保险'),
	(16, 4, '生产/营运'),
	(17, 4, '质量管理/安全防护'),
	(18, 4, '工程/机械/能源'),
	(19, 4, '技工'),
	(20, 4, '服装/纺织/皮革'),
	(21, 4, '采购'),
	(22, 4, '贸易'),
	(23, 4, '物流/仓储'),
	(24, 4, '汽车生产/销售/维修/配件'),
	(25, 5, '生物/制药/医疗器械'),
	(26, 5, '生物/制药/医疗器械'),
	(27, 5, '化工'),
	(28, 5, '医院/医疗/护理'),
	(29, 6, '广告'),
	(30, 6, '公关/媒介'),
	(31, 6, '市场/营销'),
	(32, 6, '影视/媒体'),
	(33, 6, '写作/出版/印刷'),
	(34, 6, '艺术/设计'),
	(35, 7, '建筑设计'),
	(36, 7, '土木/工程'),
	(37, 7, '工程/项目管理'),
	(38, 7, '现场专业人员'),
	(39, 7, '装饰装修/室内设计'),
	(40, 7, '房地产/物业'),
	(41, 7, '园林景观'),
	(42, 7, '给排水/空调/电气/照明'),
	(43, 7, '市政/路桥/轨道/隧道'),
	(44, 7, '造价/预算/评估/招投标'),
	(45, 7, '钢结构'),
	(46, 7, '环境工程'),
	(47, 7, '高层管理'),
	(48, 7, '市场/营销/策划/中介'),
	(49, 8, '人力资源'),
	(50, 8, '高级管理'),
	(51, 8, '行政/后勤'),
	(52, 8, '项目管理/项目协调'),
	(53, 9, '咨询/顾问'),
	(54, 9, '律师/法务/合规'),
	(55, 9, '教师'),
	(56, 9, '培训'),
	(57, 9, '科研人员'),
	(58, 10, '酒店'),
	(59, 10, '餐饮'),
	(60, 10, '美容/健身/娱乐/旅游'),
	(61, 10, '商超百货/连锁零售服务'),
	(62, 10, '交通运输服务'),
	(63, 10, '保安/家政/其他服务'),
	(64, 11, '公务员'),
	(65, 11, '翻译'),
	(66, 11, '在校学生'),
	(67, 11, '储备干部/培训生/实习生'),
	(68, 11, '兼职'),
	(69, 11, '农/林/牧/渔'),
	(70, 11, '环保'),
	(71, 11, '其他');
/*!40000 ALTER TABLE `hrsmallclass` ENABLE KEYS */;


-- 导出  表 infocomb2b.infomation 结构
DROP TABLE IF EXISTS `infomation`;
CREATE TABLE IF NOT EXISTS `infomation` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `name` char(50) DEFAULT NULL,
  `onecategoryid` int(11) DEFAULT NULL,
  `twocategoryid` int(11) DEFAULT NULL,
  `threecategoryid` int(11) DEFAULT NULL,
  `class` char(50) DEFAULT NULL,
  `validate` int(11) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `content` text,
  `username` varchar(255) DEFAULT NULL,
  `audit` int(11) DEFAULT NULL,
  `recommend` int(11) DEFAULT NULL,
  `inputdatetime` date DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=87 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.infomation 的数据：~9 rows (大约)
DELETE FROM `infomation`;
/*!40000 ALTER TABLE `infomation` DISABLE KEYS */;
INSERT INTO `infomation` (`Id`, `type`, `name`, `onecategoryid`, `twocategoryid`, `threecategoryid`, `class`, `validate`, `pic`, `content`, `username`, `audit`, `recommend`, `inputdatetime`) VALUES
	(52, '求购', '求购虚拟主机', 35, 155, 423, '虚拟主机', 360, 'upload/images/1355051642733.jpg', '<p>\r\n	求购虚拟主机500-600元左右。</p>\r\n<p>\r\n	qq:1428452239</p>\r\n<p>\r\n	联系人：官先生</p>', 'infocomnet', 1, 1, '2012-12-09'),
	(62, '供应', '网站建设1', 35, 155, 423, '网站建设', 30, 'upload/images/1386911348530.jpg', '<p>\r\n	无可奈何花落去</p>', 'infocomnet', 1, NULL, '2013-12-13'),
	(72, '代理', '购物网软件StShopV1.0', 35, 157, 431, '电子商务软件', 180, 'upload/images/1411725729171.jpg', '<p>\r\n	信通B2C网站管理系统信通购物网ICshopV1.0(Struts2+Hibernate+Spring+MySQL)版 采用当前最流行的技术平台。</p>\r\n<p>\r\n	前台</p>\r\n<p>\r\n	１、会员功能：注册会员，修改会员资料； 登录系统后可以选购商品，放入购物车(修改购物数量、删除购物车里的内容），继续购物，最后确认下订单，在线支付所选商品所选商品所需支付的金额；</p>\r\n<p>\r\n	２、新闻频道功能：最新新闻，新闻列表及页面显示。</p>\r\n<p>\r\n	后台</p>\r\n<p>\r\n	１、会员管理：会员的审核，删除；</p>\r\n<p>\r\n	２、分类管理：一二级分类的添加、删除、修改；</p>\r\n<p>\r\n	３、产品管理：产品的添加、修改、删除；</p>\r\n<p>\r\n	４、订单管理：订单的查看，处理（是否发货，是否付款）；</p>\r\n<p>\r\n	5、新闻管理：新闻的添加、删除、修改。</p>', 'infocomnet', 1, NULL, '2014-09-26'),
	(81, '招商', '招商加盟', 35, 157, 431, '电子商务软件', 180, 'upload/images/1411726065062.jpg', '<p>\r\n	商通网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>\r\n<p>\r\n	信通商务网招商加盟</p>', 'infocomnet', 1, NULL, '2014-09-26'),
	(82, '求购', '求购虚拟主机', 35, 155, 423, '虚拟主机', 360, 'upload/images/1355051642733.jpg', '<p>\r\n	求购虚拟主机500-600元左右。</p>\r\n<p>\r\n	qq:1428452239</p>\r\n<p>\r\n	联系人：官先生</p>', 'infocomnet', 1, 1, '2012-12-09'),
	(83, '求购', '求购虚拟主机', 35, 155, 423, '虚拟主机', 360, 'upload/images/1355051642733.jpg', '<p>\r\n	求购虚拟主机500-600元左右。</p>\r\n<p>\r\n	qq:1428452239</p>\r\n<p>\r\n	联系人：官先生</p>', 'infocomnet', 1, 1, '2012-12-09'),
	(84, '供应', '网站建设1', 35, 155, 423, '网站建设', 30, 'upload/images/1386911348530.jpg', '<p>\r\n	无可奈何花落去</p>', 'infocomnet', 1, NULL, '2013-12-13'),
	(85, '求购', '求购虚拟主机', 35, 155, 423, '虚拟主机', 360, 'upload/images/1355051642733.jpg', '<p>\r\n	求购虚拟主机500-600元左右。</p>\r\n<p>\r\n	qq:1428452239</p>\r\n<p>\r\n	联系人：官先生</p>', 'infocomnet', 1, 1, '2012-12-09'),
	(86, '求购', '求购虚拟主机', 35, 155, 423, '虚拟主机', 360, 'upload/images/1355051642733.jpg', '<p>\r\n	求购虚拟主机500-600元左右。</p>\r\n<p>\r\n	qq:1428452239</p>\r\n<p>\r\n	联系人：官先生</p>', 'infocomnet', 1, 1, '2012-12-09');
/*!40000 ALTER TABLE `infomation` ENABLE KEYS */;


-- 导出  表 infocomb2b.job 结构
DROP TABLE IF EXISTS `job`;
CREATE TABLE IF NOT EXISTS `job` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `jobname` char(50) NOT NULL DEFAULT '0',
  `hrbigclassid` int(11) DEFAULT NULL,
  `hrsmallclassid` int(11) DEFAULT NULL,
  `hrjobnameid` int(11) DEFAULT NULL,
  `introduce` text,
  `username` varchar(255) DEFAULT NULL,
  `audit` int(11) DEFAULT NULL,
  `recommend` int(11) DEFAULT NULL,
  `inputdatetime` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.job 的数据：~2 rows (大约)
DELETE FROM `job`;
/*!40000 ALTER TABLE `job` DISABLE KEYS */;
INSERT INTO `job` (`id`, `jobname`, `hrbigclassid`, `hrsmallclassid`, `hrjobnameid`, `introduce`, `username`, `audit`, `recommend`, `inputdatetime`) VALUES
	(1, 'fghfghfh', 10, 60, 119, '<p>\r\n	gfhfhfhfhfhfhgfhfhfhfhfhfhfhgf</p>', 'jxfzinfocomnet', 1, 1, '2015-07-13'),
	(4, 'ghffhfhfhfh', 8, 49, 123, '<p>\r\n	ghfhfhfh</p>', 'jxfzinfocomnet', 1, 1, '2015-07-13');
/*!40000 ALTER TABLE `job` ENABLE KEYS */;


-- 导出  表 infocomb2b.member 结构
DROP TABLE IF EXISTS `member`;
CREATE TABLE IF NOT EXISTS `member` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `username` varchar(50) DEFAULT NULL,
  `password` varchar(50) DEFAULT NULL,
  `companyname` varchar(255) DEFAULT NULL,
  `brand` varchar(255) DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `pic` varchar(255) DEFAULT NULL,
  `onecategoryid` int(11) DEFAULT NULL,
  `twocategoryid` int(11) DEFAULT NULL,
  `threecategoryid` int(11) DEFAULT NULL,
  `introduction` text,
  `telephone` char(50) DEFAULT NULL,
  `fax` char(50) DEFAULT NULL,
  `mobilephone` bigint(11) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `qq` bigint(11) DEFAULT NULL,
  `provinceid` int(11) DEFAULT NULL,
  `cityid` int(11) DEFAULT NULL,
  `districtcountyid` int(11) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `post` int(11) DEFAULT NULL,
  `website` varchar(255) DEFAULT NULL,
  `truename` varchar(255) DEFAULT NULL,
  `sex` varchar(255) DEFAULT NULL,
  `born` datetime DEFAULT NULL,
  `school` varchar(255) DEFAULT NULL,
  `education` varchar(255) DEFAULT NULL,
  `job` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `membertype` varchar(255) DEFAULT NULL,
  `audit` int(11) DEFAULT NULL,
  `recommend` int(11) DEFAULT NULL,
  `inputdatetime` date DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=27 DEFAULT CHARSET=gb2312;

-- 正在导出表  infocomb2b.member 的数据：~6 rows (大约)
DELETE FROM `member`;
/*!40000 ALTER TABLE `member` DISABLE KEYS */;
INSERT INTO `member` (`Id`, `username`, `password`, `companyname`, `brand`, `logo`, `pic`, `onecategoryid`, `twocategoryid`, `threecategoryid`, `introduction`, `telephone`, `fax`, `mobilephone`, `email`, `qq`, `provinceid`, `cityid`, `districtcountyid`, `address`, `post`, `website`, `truename`, `sex`, `born`, `school`, `education`, `job`, `type`, `membertype`, `audit`, `recommend`, `inputdatetime`) VALUES
	(21, 'jxfzinfocomnet', '123456789', '江西省抚州市信通网络科技有限公司', '信通', '', '', 40, 190, 571, '江西省抚州市康通信息科技有限公司是一家主营企业网站建设/企业电子商务（b2b/b2c）的企业。采用当前最新技术平台JAVA及框架Struts2+Hibernate+Spring技术，数据库采用Mysql。Java做为当今最热门的电脑程序设计语言之一，普遍被众多高科技企业应用，包括软件公司，互联网公司。\r\n已经开发出信通商务网B2B/信通购物网B2C这一电子商务购物(SHOP)网站，只要销加修改就可以推向市场应用。', '0794-5311812', '0794-5311812', 18679476435, 'sglg@163.com', 1428452239, 5, 6, 10, '江西省抚州市金溪县左坊镇官桥村', 344814, 'http://www.infocomb2b.com', '官禄刚', '男', '1983-05-22 00:00:00', '南昌大学', '大专', '总经理', '民营企业', 'free', 1, 1, '2015-07-13'),
	(22, 'mjywan', '123456a', '亚马逊户外运动品有限公司', '亚马逊', 'fssdfsdf', NULL, 31, 129, 352, '亚马逊户外用品公司简称亚马逊户外成立于2009年位,于广东省深圳市。\r\n是一家专业生产销售打猎户外运动品的厂家。主要产品有瑞典FX气皇400\r\n，德国夜鹰，英国骚本 ，革命者，FX 季侯风半自动， 角斗士，问切斯\r\n特等公司目前旗下有员工100人，年销售收入近1500000元。公司一贯坚持\r\n质量第一，用户至上，优质服务，信守合同 的宗旨，凭借着高质量的产品\r\n，良好的信誉，优质的服务,产品畅销全国近三十多个省、市、自治区以及\r\n远销等国家。竭诚与国内外商家双赢合作，共同发展，共创辉煌我们的宗旨:您的满意是我们的追求!\r\n我们的承诺：本公司所销售的狗全部为全新原装,假一赔十；\r\n需要了解更多产品请登陆http://www.ymx2014.com\r\n长期销售,信誉保证,一流的服务,追求让您满意.', '82385631', '8787678', 18682385631, '2913718584@qq.com', 233483567, 1, 1, 2, '广东省福田区', 340450, 'http://www.ymx2014.com', '李俊', '男', '1986-03-04 00:00:00', '福田', '博士', '总经理', '民营企业', 'free', 1, 1, '2014-03-29'),
	(23, 'jxmdbz', 'mdbzj135', '郑州中泰机械设备有限公司', '中泰', 'upload/images/1401154440296.jpg', NULL, 25, 94, 255, '河南?郑州中泰机械设备有限公司生产各种包装设备，各种加工机械设备齐全、技术实力雄厚、企业内部管理严密、生产效率高；本公司生产的包装机械品种多，规格齐全，并能承接各种特殊规格需求的产品定做。其机器的先进性、可靠性、稳定性已达到国际先进技术水平；产品以精良的质量、低廉的价格、美观的造型和完善的售后服务赢得了用户的信赖和好评；产品畅销全国各地，并出口东南亚、中东、欧洲等国家和地区。', '0371-66369226', '0371-66369226', 13525582502, 'jxmdbz@sina.com', 598011779, 17, 51, 862, '未来路886号', 450000, 'http://www.chnjixie.com', '李惠', '女', '1986-02-18 00:00:00', '郑州大学', '本科', '业务员', '民营企业', 'free', 1, 1, '2014-05-23'),
	(24, 'xiandaiyangguo', '230158hu', '北京鹏浩未来信息科技有限公司', '鹏浩触控', 'upload/images/1405417830531.jpg', NULL, 29, 150, 411, '北京鹏浩未来信息科技有限公司坐落于北京高科技核心地带------中关村。本公司是经科技部北京高技术创业中心创新基金支持的创新高科技企业，企业发展动力和后劲更加强大。信息化的时代赋予了人类更高的使命，多年来，公司业务不断发展壮大，形成了一个以开发优质产品和提供良好售后服务为主旨的公司。 　　公司经营管理团队由软件技术专家、优秀营销人员、管理专家和一批有志于多媒体信息产业化的青年知识分子组成。高水准的技术队伍和全新的经营理念创造了品质优良的产品。 　　 我们的目标：为社会提供最简捷的信息化服务 　 　 我们的文化：诚信 　效率 　创新　 协作 　 　 我们的服务宗旨：用科技创造完美 　用服务赢得信赖 　　公司发展历程 　　公司从起步时的触摸查询一体机发展到今天的多媒体软、硬件系统集成商，始终凭借的是北京鹏浩未来信息科技有限公司人勇攀高峰的思想理念。公司在技术上始终与国际先进水平保持同步发展，今年来建立了包括政府机关、企事业单位等方方面面的客户群。 　　明确的经营目标、先进的开发技术、始终如一的服务理念和时代赋予的责任必将使公司成为中国多媒体信息化的中流砥柱。 　　现公司主导产品包括: 　　 大屏幕互动银幕触摸屏、沙盘（模型）控制 　　 多媒体查询机柜、绚丽多彩的多媒体查询应用软件、空中翻书 　　 Generaltouch表面声波触摸屏、G-touch电阻屏、LCD触摸显示器 　　 排队机 　　 LED大屏等相关产品 　　 各种应用集成项目产品', '010-82853350', '010-82853350', 13691175827, '122468098@qq.com', 122468098, 29, 7, 6, '北京市海淀区西草场1号北京硅谷电脑城七层08A号', 100080, 'http://', '胡浩', '男', '1982-06-13 00:00:00', '北京化工大学', '本科', '总经理', '民营企业', 'free', 1, 1, '2014-07-15'),
	(25, 'hjhsjcl999', 'hjh666', '惠虹塑胶制品有限公司', '惠佳虹', NULL, NULL, 20, 119, 321, '惠虹塑胶制品有限公司坐落于中国广东省深圳市宝安区，专业代理销售进口工程塑胶、高性能工程塑料、绝缘材料、防静电材料四个系列产品，具有耐高温、耐腐蚀、耐冲击、耐辐射等特点。公司与德国、美国、韩国、台湾等塑胶供应商长期开展代理合作。公司自创办以来，一直依靠稳定的质量、卓越的服务、良好的行业管道和技术优势，严格秉承“质量第一 服务第一 客户至上”的经营理念，逐步赢得了广大用户的满意和信任。“质量至上、服务第一、追求卓越”始终是公司立基建业的宗旨和目标。公司本着“不断进取、与时俱进”的思想时时激励自己，用优异卓著的“诚信”产品积极参与国内外的市场竞争。公司在深圳、东莞、苏州、昆山、上海等地设有加盟商，东莞备有材料仓库及配送中心，期待与您在特种工程塑料领域内进行合作，欢迎您来电咨询，莅临指导。\r\n主要供应产品：\r\n一、工程塑料：\r\nPEEK板/棒、PPS板/棒、PVDF板/棒、PTFE（F4）板/棒、PSU板/棒、PEI板/棒、PI板/棒、PAI板/棒、PPO板/棒、PBT板/棒、CPVC板/棒、UPE板/棒、PET板/棒、PC板/棒、POM（赛钢）板/棒、ABS板/棒、PMMA（有机玻璃）板/棒、PP板/棒、PE板/棒、PU板/棒、PES板/棒、PVC板/棒、PBI板/棒、PA尼龙系列板/棒/片、MC尼龙系列板/棒等。\r\n  二、高性能工程塑料系列： \r\n加入玻纤PEEK板/棒、加石墨尼龙板/棒、加碳纤维PEEK板/棒、尼龙板/棒、合成石板、加粉末碳纤合成石板、二硫化钼尼龙板/棒、玻璃微珠等特种复合型塑胶型材、棒材产品。\r\n产品主要服务领域：航空航天电子、精密汽车电子、医疗器械、军工机械、食品机械、工农业机械、精密仪器、3C产业、五金模具、泵阀、轴承、冶具、印刷等行业。 \r\n三、绝缘材料：\r\n环氧板/棒、电木板、冷冲板、FR-4玻纤板、布板/棒、合成石。 \r\n四、防静电材料系列：\r\n防静电PEEK板/棒、防静电POM板/棒、防静电PC板、防静电PVC板、防静电PMMA板、防静电尼龙板/棒、日本三菱抗静电MC501CD/R2/R6/R9/R11尼龙板/棒等。 \r\n防静电材料的应用：防静电材料广泛用于，半导体工业、LCD工业、电子装备工业、电子电气、通讯制造、精密仪器、光学制造、医药工业及生物工程等行业。', '0755-29376572', '0755-23041920', 13641408566, '2039912600@qq.com', 2039912600, 1, 5, 195, '广东深圳宝安西乡镇', 841000, 'http://', '王长泉', '男', '1987-08-19 00:00:00', '', '高中', '总经理', '外商独资', 'free', 1, 1, '2014-08-07'),
	(26, 'nowhy1314', 'nowhy1234', '上海金喷消防设备有限公司', '金喷', 'upload/images/1407477445890.jpg', NULL, 25, 91, 246, '上海金喷消防设备有限公司，是一家从事经营各种消防喷淋，消防阀门，以及消防工程的单位，经过几年来公司员工的努力，在上海金山站稳了脚步，公司设在上海市金山区山阳镇浦卫公路16393号，并且在奉贤区青村镇设有办事处，欢迎各位新老客户前来咨询、采购。\r\n  我公司始终贯彻：“质量第一”的理念，几年来深得全国各地广大客户的信赖。并且我公司也代理国内与国外知名品牌消防产品，给予客户最实在的价格，以及优良的售后服务。\r\n  公司质量管理通过ISO9001:2000质量管理体系认证，成为上海消防协会团体会员之一，公司近年来不断创新，优质诚信，服务社会，公司员工现有一百多人。为扩大市场，现面向全国各地，并以逐步开放海外市场。', '021-57569122', '021-57569110', 18917037119, '2117643313@qq.com', 2117643313, 29, 8, 1127, '上海奉贤区人民路', 201414, 'http://www.jpxf.cn', '刘林', '女', '2014-08-05 00:00:00', '武大', '大专', '部门经理', '民营企业', 'free', 1, 1, '2014-08-07');
/*!40000 ALTER TABLE `member` ENABLE KEYS */;


-- 导出  表 infocomb2b.news 结构
DROP TABLE IF EXISTS `news`;
CREATE TABLE IF NOT EXISTS `news` (
  `Id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `pic` varchar(255) CHARACTER SET gb2312 DEFAULT NULL,
  `content` longtext,
  `newsclass` varchar(255) DEFAULT NULL,
  `author` varchar(255) DEFAULT NULL,
  `source` varchar(255) DEFAULT NULL,
  `recommend` varchar(50) CHARACTER SET gb2312 DEFAULT NULL,
  `inputdatetime` date DEFAULT NULL,
  PRIMARY KEY (`Id`)
) ENGINE=InnoDB AUTO_INCREMENT=770 DEFAULT CHARSET=gbk;

-- 正在导出表  infocomb2b.news 的数据：~1,152 rows (大约)
DELETE FROM `news`;
/*!40000 ALTER TABLE `news` DISABLE KEYS */;
INSERT INTO `news` (`Id`, `title`, `pic`, `content`, `newsclass`, `author`, `source`, `recommend`, `inputdatetime`) VALUES
	(72, '声讨淘宝行动继续超四万人在线集结', '', '<p>\r\n	2011年10月13日，位于杭州文二西路上淘宝网。 梁臻 / 东方IC　　联合反抗者目前仍在急剧增加；将以投票方式决定进一步行动<br />\r\n	　　【财新网】(记者 王姗姗)截至10月14日下午记者发稿，仍有接近四万五千人，在线集结于多玩歪歪语音聊天软件一个名为&ldquo;中国网商维权协会&rdquo;频道，对淘宝商城调整续签资费一事进行声讨和进一步反抗行动策划。<br />\r\n	　　目前数万集结语音聊天用户中，既有真实淘宝商城小卖家，也有围观人士，因此目前并无法统计出具体有多少淘宝小卖家在过去几日内确定参与了为反抗淘宝商城续签新政而发动集体恶性下单事件。<br />\r\n	　　但据记者今日目测，在线结集用户数目前还在急剧增加。排队等候发言用户，始终保持在500人满额状态。一些参与者开始抱怨现在&ldquo;人气下降&rdquo;。而大多数发言用户，主要发表观点皆为鼓舞士气和号召所有参与者要&ldquo;团结作战&rdquo;、与淘宝对抗到底。<br />\r\n	　　&ldquo;一切放下武器谈判都注定要失败，我们要大搞特搞破坏。&rdquo;一位自称身份是淘宝商城小卖家人士向在线集结用户发出呼吁。<br />\r\n	　　10月14日上午，一位自称是&ldquo;中国网商维权协会&rdquo;管理员人士在频道中通知所有参与者，未来将会通过投票来做出进一步行动决定，之后以公告形式对外发布。<br />\r\n	　　&ldquo;难道我们有几万人一起想对策，还对付不了一个淘宝？&rdquo;一位发言人10月13日通过歪歪语音聊天对参与者号召称，这一次小卖家对抗行动&ldquo;不能只局限于商城提高收费一事&rdquo;，而应该全面瓦解淘宝政策垄断，网商应该设立类似网协民间维权机构。<br />\r\n	　　10月10日淘宝商城对外公布了2012年度商家招商续签及相关规则，进一步提高了进驻&ldquo;门槛&rdquo;&mdash;&mdash;原有商家需缴纳每年6000元技术服务年费，提高至3万元和6万元两个档次；商家违约责任保证金则由之前1万元提升到5、10和15万三个档次。这意味着入驻淘宝商城卖家，其开店最低成本由之前1.6万元上升至8万元。<br />\r\n	　　新政一经出台，刺激部分中小卖家不满。10月11日晚间，一批自称是淘宝小卖家人士先是集结于语音聊天工具，之后发行了反抗行动&mdash;&mdash;集中购买淘宝商城上品牌商某些商品，令其在页面上显示&ldquo;下架&rdquo;，付款后再对所购商城给予0分或1分差评并马上申请退款。<br />\r\n	　　所谓攻击型下单行动，被参与者称为是&ldquo;商城团购&rdquo;。一位网名为&ldquo;我们需要淘宝低头&rdquo;用户自称13日&ldquo;参与拍卖一直忙到夜里四点&rdquo;，仅仅休息了三个小时后，又从今天早上七点钟开始加入新一轮攻击性抢拍下单行动。<br />\r\n	　　有第一财新日报报道称，至10月13日，聚集于多玩歪歪语音聊天软件中参与反抗淘宝商城新政用户在线人数一度突破五万，对韩都衣舍等大卖家发起恶意下单行动至少有18轮。<br />\r\n	　　一位淘宝商城公关部工作人员今天向财新记者再度获得证实，续签新规将从2012年1月1日起执行，淘宝商城对入驻商户签订合作并非以一年为周期，而是以&ldquo;自然年&rdquo;结算&mdash;&mdash;每份合同终止日期皆为每年12月31日，对于现有卖家而言，开店成本中，除了一万元保证金，技术服务费则按加入月份至年底时间比例收取。<br />\r\n	　　此外，淘宝商城竞争对手&mdash;&mdash;腾讯商城也于10月13日起展开对淘宝商户挖角行动，高调推出&ldquo;仅收取2万元保证金，不收取技术服务年费&rdquo;低价招商计划，并宣称&ldquo;将与合作伙伴不离不弃&rdquo;。</p>', '互联网', '', '财新网', 'focus', '2015-12-23'),
	(73, '外贸订单普遍下滑企纷纷借电子商务转型', '', '<p>\r\n	一年一度广交会即将开幕，在新形势下，很多外贸出口企已经开始了转型之路，利用创新思维和新兴平台创造了可观经济价值，成为外贸转型浪潮中&ldquo;冲浪者&rdquo;角色。<br />\r\n	&ldquo;全球经济负面影响还未见底，外贸出口企应该从规模扩张向质量提升转变，从粗放型向集约型转变，通过技术和管理创新实现企转型升级。&rdquo;阿里巴巴相关负责人认为，电子商务将有助于推动外贸企转型升级。<br />\r\n	&ldquo;之前生产产品缺少特色，都是正常家居用品，缺乏竞争力，2011年受到欧美经济恶化影响直接导致出口这类产品订单减少70%以上。&rdquo;江门市新会区洋洋金属制品有限公司相关负责人梁炎光说。<br />\r\n	阿里巴巴调查显示，珠三角地区小企订单量相比2010年下滑约30%。相比2008年订单急性下滑，当前订单呈现逐步减少，绝大部分小企对未来形势不确定表示担忧。<br />\r\n	2011年以来，来自欧洲和美国市场订单在逐步下降，来自这两个区域询盘量在2011年8月后缩减，对外贸出口小企影响较大。尽管临近欧美圣诞节旺季，但是欧洲市场装船率大多仍然在50%左右，美洲市场装船率也低于80%，相比往年降幅较高。来自中东及拉美、非洲市场订单略有增加，但远不能弥补欧美市场订单减少。<br />\r\n	严峻形势倒逼外贸出口企改变传统营销方式，借助电子商务打开了外贸出口新蓝海。阿里巴巴作为中国最大中小企出口贸易网络平台，其网站上企出口订单数据，某种程度上直接反映着整个中国出口贸易情况，并已成为中国经济晴雨表。<br />\r\n	&ldquo;借助电子商务不仅仅提升了企利润，而且可以帮助企转型和升级，改变过去批量化生产模式，实现了定制化生产，企重点也转移到产品服务、品牌和创新，从而进一步提升产品附加价值。&rdquo; 厦门华融集团执行董事徐平凡说。<br />\r\n	自觉迎合市场变化，利用中小企快速反应能力，通过产品创新并阿里巴巴这样电子商务平台，成为国内中小出口企一条转危为机成功之路。<br />\r\n	&ldquo;开发LED植物照明灯，并借助阿里巴巴这样电子商务渠道，我们获得了巨大商机和高额投资回报。&rdquo; 深圳市佰晟光电科技有限公司相关负责人表示。</p>', '互联网', '何秋养', '信息时报', 'focus', '2015-12-23'),
	(74, '电商协会刘东明：将来电子商务谁才是王者？', 'upload/images/1318645801156.jpg', '<p>\r\n	　　10月14日，&ldquo;淘宝创想行论道&rdquo;在北京举行，中国电子商务协会网络整合营销研究中心刘东明表示，将来谁才是电商王者，是传统卖家与电子商务相结合模式，传统将会变得越来越轻，电商位置也会随着用户需求变得越来越重要。</p>\r\n<p>\r\n	　　淘宝创想行论道现场<br />\r\n	　　谈到目前电商发展遇到问题，他认为，服装品牌电商化和服装电商品牌化，是目前很多服装企面临选择和难题。一方面，线下传统服务企有资金有实力，有自主品牌，但都在进行着电商化运营道路上遇到困难和瓶颈，另一方面依托淘宝平台产生一些淘宝商家，正在进行着品牌化，品质化蜕变<br />\r\n	　　他还强调，无论是服装电商品牌化还是服装品牌电商化，用户需求是不可忽视，服务企应该善于挖掘和创造用户需求。<br />\r\n	　　一淘网客户营销部营销整合总监徐嘉鼎也在会上发表观点，他表示，目前服装企如何建立自己电子商务团队，如何协调现在利益和已建立成熟下经销商体系吗，以什么样方式进军电子商务等问题，服装电子商务运作需从团队架构、品牌整合到营销平台搭建做出相应调整。<br />\r\n	　　韩都衣舍、裂帛、俏CIAO等传统品牌、淘品牌、B2C电商品牌、第三方服务商等进行电商均来到会议现场。<br />\r\n	　　据和讯科技了解，截止2010年12月，淘宝网注册用户达3.7亿，日访问人数峰值6000万，单日交易额峰值达19.7亿元，分别超过北京、上海、广州长三地社会消费品零售单日额，在线商品数达8亿。</p>', '互联网', '', '和讯科技', '', '2011-10-15'),
	(75, '传统服装企牵手电子商务 营销另辟蹊径', '', '<p>\r\n	近年来，电子商务以其低成本、高效率、开放性、回报快等优势迅速占领市场，吸引服装、电器等行把营销力量投向电子商务市场。随着歌莉娅、艾格、玛萨玛索等一系列传统服装品牌涌入电商浪潮，传统服装企开展电子商务热情空情高涨。<br />\r\n	　　电子商务营销重要性使得大多数企都希望成为电子商务平台掌控者，选择成熟电子商务平台或许是进入电子商务领域捷径，但不少企不喜欢在他人平台被束缚感觉，选择投入几千万甚至上亿资金建立独立电子商务网站，同时也发现品牌企基本还没有把自有电子商务平台做成销售量庞大网站。<br />\r\n	　　虽然服装企进军电子商务数量越来越多，但绝大多数传统服装企电子商务销售并不占据销售量大份额，可见真正成功实现传统营销模式和电子商务营销模式有效对接企不多，甚至不少企在进入电子商务领域后倍感压力。传统服装品牌企专注于生产以及品牌打造和营销，对电子商务营销平台搭建和传播还有待加强。而电子商务营销模式势必会对传统营销构成一定冲击，伤及部分品牌厂商利益，引发产品经销商对电子商务抵触情绪。<br />\r\n	　　据了解，截止2011年6月，网络零售市场交易规模为3492亿元，其中服装是网购商品一个大类，其中服装是最受网民欢迎网购商品之一，成为网上零售第一大门类，占到将近百分之三十份额。传统服装企涉足电子商务营销市场潜力是巨大，以优衣库为例，优衣库是日本最大服装企之一，其在中国有五家线下门店，在发展不是十分理想情况下，于2008年跟淘宝网达成了战略合作，上线之后十天之内日销售额达到50万元，相当于线下两家店销售额总和，2009年销售额过亿元。<br />\r\n	　　电子商务平台庞大销售数据亦证明着互联网营销已撼动传统营销渠道，但电子商务销售平台建设困扰、网络渠道与原有店面渠道利益冲突、旧销售思维束缚等，让这些传统服装企电子商务之路并不平坦。网络销售平台是自主建设还是外包，抑或是采用人气旺盛第三方平台，直销还是分销，线上线下是单品牌还是多品牌运作，都在考验着传统企智慧。<br />\r\n	　　针对传统服装企牵手电子商务营销平台遭遇困惑，中国电子商务研究中心、中国服装网将于10月20日共同主办&ldquo;2011中国服装行电子商务应用峰会暨中国服装产电商采购会&rdquo;，届时将举行&ldquo;2011年度中国十佳服装电子商务示范网站&rdquo;颁奖仪式和&ldquo;中国服装品牌研究中心&rdquo;揭牌仪式，同时发布《2011年度中国服装行电子商务应用报告》。目前峰会与采购会报名工作已经启动。<br />\r\n	　　目前，已确认演讲、参会部分电商企包括：凡客诚品、银泰网、乐酷天商城、走秀网、PAYPAL、玛萨玛索、瑞金麟、易合信息、中邮快购、上海商派、新百网上商城、森动数码、中国服装网、衣服网、蓝团科技、敦印、T100趋势网、童装加盟网等，还有数百家传统服装品牌企。</p>', '互联网', '', '网络导报', '', '2011-10-15'),
	(76, '走出认识误区 何为云计算？', '', '<p>\r\n	谈到云计算定义，可谓众说纷纭，比如，在维基百科上定义是&ldquo;云计算是一种基于互联网计算新方式，通过互联网上异构、自治服务为个人和企用户提供按需即取计算&rdquo;;著名咨询机构Gartner将云计算定义为&ldquo;云计算是利用互联网技术来将庞大且可伸缩IT能力集合起来作为服务提供给多个客户技术&rdquo;;而IBM则认为&ldquo;云计算是一种新兴IT服务交付方式，应用，数据和计算资源能够通过网络作为标准服务在灵活价格下快速地提供最终用户&rdquo;。<br />\r\n	　　在我看来，云计算就是在后端庞大云计算中心支撑下能提供方便用户体验和低廉成本新一代IT模式。<br />\r\n	　　具体而言：由于在后端有规模庞大、非常自动化和高可靠性云计算中心存在，人们只要接入互联网，就能非常方便地访问各种基于云应用和信息，并免去了安装和维护等繁琐操作，同时，企和个人也能以低廉价格来使用这些由云计算中心提供服务或者在云中直接搭建其所需信息服务，在收费模式上，和水电等公用事非常类似，只需为所使用部分付费。接下来，将进一步从于云计算使用者(主要是个人用户和企)角度来分析云计算在用户体验和成本这两方面给他们带来了什么好处?<br />\r\n	　　用户体验方面<br />\r\n	　　对个人用户而言，在云计算时代，会出现越来越多基于互联网服务，这些服务丰富多样、功能强大、随时随地接入，同时也无需购买、下载和安装任何客户端，并只要使用浏览器就能轻松访问，而无需为软件升级和病毒感染操心。还有，人们可以将文档等数据放在云来进行共享和协作，比如，共同编辑同一篇文章，而且通过严格权限管理机制，来确保协作是在安全环境下进行。对企用户而言，可以利用云技术来优化其现有IT服务，使现有IT服务更可靠和更自动化，更可以将企IT服务整体迁移到云上，使企卸下维护IT服务重担，从而更专注于其主营务。<br />\r\n	　　成本方面<br />\r\n	　　对个人用户而言，由于所使用服务运行在云端，本地计算需求比较少，所以无需像过去那样不断地升级电脑配置或者购买昂贵新电脑，只需一个廉价可以上网智能终端，比如：手机和上网本等。同时由于互联网服务是按需使用，而无需在初期购置不廉价软件客户端。对企用户而言，除了可以通过利用先进云技术来降低企IT初期投资成本和后期维护成本之外，更可以通过将IT服务外包或者整体迁移来削减IT部门，使得公司成本结构更完善。</p>', '互联网', '', '机房360', '', '2011-10-15'),
	(78, '找好友就摇一摇 Android微信3.0发布下载', '', '<p>\r\n	　　还记得此前手机QQ 2.0.1 Android版摇一摇即可截屏功能吗？今天发布微信3.0 Android正式版也加入了摇一摇，只不过这个功能不是截屏，而是找好友。</p>\r\n<p>\r\n	<br />\r\n	　　<strong>本地下载：<a href="http://download.sohu.com/down_detail/0/1603_index.html"><font color="#004276">http://download.sohu.com/down_detail/0/1603_index.html</font></a></strong><br />\r\n	<br />\r\n	　　<strong>新版本增加新功能：</strong><br />\r\n	<br />\r\n	　　1、摇一摇：支持通过摇一摇手机找到同时也在摇手机朋友。<br />\r\n	<br />\r\n	　　2、漂流瓶:支持扔漂流瓶匿名交友。<br />\r\n	<br />\r\n	　　3、视频信息：支持视频即拍即发，经过压缩处理，即使在移动网络也适合传送，让您随时分享精彩生活片段。<br />\r\n	<br />\r\n	　　4、支持繁体中文语言界面，增加港、澳、台、美、日五个地区用户绑定手机号。<br />\r\n	<br />\r\n	　　5、增加保存群组到通讯录功能，可以把一个群聊里所有联系人保存成一个群组，方便与这些人发起消息对话。<br />\r\n	<br />\r\n	　　6、系统插件可装卸、安装。还能让您自由设置是否显示到通讯录里，让您灵活管理满足不同需求插件。<br />\r\n	<br />\r\n	　　7、支持查看好友大头像。<br />\r\n	<br />\r\n	　　8、增加插件免打扰功能，设置免打扰后，不再提醒系统插件发来消息。<br />\r\n	<br />\r\n	　　<strong>相关截图：</strong><br />\r\n	<br />\r\n	&nbsp;</p>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677904.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677905.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677906.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677907.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677908.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677909.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677910.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center">\r\n	<table align="center">\r\n		<tbody>\r\n			<tr>\r\n				<td>\r\n					<div align="center">\r\n						<img alt="找好友就摇一摇 微信3.0(Android)发布" src="http://precommendocdn.sohu.com/20111019/Img322677911.jpg" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '通信', '雪花', '驱动之家', 'recommend', '2015-01-11'),
	(79, '京粤微博主网上影响力最大', 'upload/images/1319016170484.jpg', '<p>\r\n	微博上关于公共事件报道主要还是来自媒体官方账号。<br />\r\n	　　高校发布《微博意见活跃群体分析报告》<br />\r\n	　　本报讯 日前，武汉大学信息管理学院出版科学系博导沈阳教授带领来自全国各高校学者、学生完成了一份名为《微博意见活跃群体分析报告》调研报告，剖析了今年以来发生各起网络公共事件背后&ldquo;微博意见领袖&rdquo;群体，其中，京粤两地博友在2亿名新浪微博网友中影响力最大。<br />\r\n	　　调研团队选取了郭美美事件、药家鑫案等27件今年以来最受关注网络公共事件作为研究对象，其中评论数最多344条相关微博由175个微博账号发布，这些账号平均拥有&ldquo;粉丝&rdquo;66万人。在这175个账号中，有多达96个来自北京，排名第二是广东，有24个。<br />\r\n	　　在以上这175个博主中，排名前10有7名是个人用户，包括黄健翔、任志强和冯小刚等，均为名人，可见网友们最爱听名人说话。但记者注意到，这些博主与整个新浪微博粉丝数量排行榜并无必然联系。目前新浪微博&ldquo;粉丝&rdquo;数量最多10人均为海峡两岸娱乐圈名人，他们每人都拥有800多万甚至上千万名&ldquo;粉丝&rdquo;，但他们却没有在各起网络公共事件中发挥影响力。<br />\r\n	　　虽然名人效应显著，但名人们毕竟只是个人，他们精力和关注范围有限。调查显示，这些&ldquo;个体户&rdquo;博主往往只能关注到一两起网络公共事件。&ldquo;童话大王&rdquo;郑渊洁却是个例外，在27起最受关注网络公共事件中，他身体力行地关注了其中6起，并发出了10条影响力巨大相关微博。<br />\r\n	　　在以提供事实为主微博博主中有27个是机构账号，其中25个是媒体官方微博，他们为微博圈提供了六成左右公共事件报道。其余四成左右事件相关情况，几乎都由13名媒体从人员和7名来自广州&ldquo;草根&rdquo;网民提供。</p>', '互联网', '张强', '大洋网-广州日报', '', '2011-10-19'),
	(81, '苏泊尔与工商部门论战 检测报告被指避重就轻', 'upload/images/1319016675109.jpg', '<p>\r\n	资料图片。　　编者按：2011年，中国互联网流行一个关键词叫&ldquo;围观&rdquo;。所谓围观并非袖手旁观，亦非简单关注，而是从观察者角度进行审视，让所有不合常理之现象在围观下无所遁形&mdash;&mdash;中新网财经中心发起&ldquo;公司围观&rdquo;便旨在此。通过媒体、网民和专家力量，持续围观各行各公司百态，求证企发展中各种质疑，力求从围观反映公司实质，给关联方、利益方和责任方以本源真貌。<br />\r\n	　　中新网10月19日电 苏泊尔(17.80,-0.84,-4.51%)与哈尔滨工商部门&ldquo;纠纷&rdquo;仍在继续。后者指责苏泊尔不锈钢锅等81个型号产品存在锰含量超标，镍、铬含量不达标等问题，并在辖区内对问题产品强制下架。苏泊尔则拒不承认哈市工商部门检测结论，坚称自己产品通过了国家专机构检测。<br />\r\n	　　苏泊尔不承认检测结论<br />\r\n	　　10月14日，苏泊尔针对哈市工商部门处罚决定发布公告称，其所有相关产品均通过国家相关机构检验，对于哈尔滨市工商部门检查涉及全部产品，公司于2011年9月29日再次送交国家相关机构检验，检测结果均为合格。<br />\r\n	　　10月17日，苏泊尔高级公关主管张丽萍公开表示，哈市工商部门检测只是当地政府行为，并没有与苏泊尔总部交涉过。而且检测结果均由地方检测部门作出，苏泊尔无法判断是否属实。<br />\r\n	　　负责调查苏泊尔产品质量问题哈市工商局道外分局经检一队大队长张传义则对媒体表示，&ldquo;我是一个执法者，我是依据国家法定检验机构判定做出结论。&rdquo;<br />\r\n	　　媒体质疑苏泊尔检测报告<br />\r\n	　　苏泊尔不承认其产品质量问题，依据是其产品检测报告由&ldquo;国家专机构出具&rdquo;，而哈市工商部门是在&ldquo;当地检测&rdquo;，前者更具权威性。<br />\r\n	　　但日前却有媒体质疑苏泊尔检测报告避重就轻，并未能说明实质问题。<br />\r\n	　　据《21世纪经济报道》报道，哈市工商部门出具检测报告中，苏泊尔产品所用材料中锰含量为7.59，远高于国家规定2.50；而镍含量为3.92，远低于国家规定下限7.0，哈市工商部门据此做出&ldquo;不合格&rdquo;结论。<br />\r\n	　　而苏泊尔由国家专机构出具检测报告，却未涉及锰、镍、铬等材质含量，只对&ldquo;划伤&rdquo;、&ldquo;凹坑&rdquo;、&ldquo;点焊&rdquo;及 &ldquo;卫生要求&rdquo;进行了检测，并由此获得&ldquo;合格&rdquo;结论。<br />\r\n	　　也就是说，争执双方所出具检测报告，其实说明不是同一回事。<br />\r\n	　　苏泊尔部分产品下架<br />\r\n	　　尽管争执还在继续，但本次事件对苏泊尔造成影响已经显现。其部分产品在哈尔滨市遭到强制下架和扣押，而其他地区也开始传出下架苏泊尔部分产品消息。<br />\r\n	　　苏宁北京市场部经理苑金香日前表示，苏宁北京各卖场13日已将被曝有质量问题苏泊尔产品下架，主要是蒸锅和炖锅。大中电器北京负责人及国美内部人士均称，相关产品已下架。<br />\r\n	　　受事件影响，苏泊尔股价一路下挫，从9月至今已经跌逾15.60%。</p>', '家电', '', '中新网财经频道', '', '2011-10-19'),
	(82, '“东哥”千万赌局战国庆', 'upload/images/1334737278921.jpg', '<p>\r\n	刘强东：晕！微博140字有时难办，很多网友以为我骂李国庆傻大黑粗，错了。这是李国庆在一次2000人大会上骂我！微博为证！东哥不屑骂任何竞争对手！我只喜欢用合法市场化公开竞争手段去打败对手！</p>\r\n<p class="detailPic">\r\n	<img alt="" src="http://y1.ifengimg.com/tech_spider/dci_2012/04/4205aaaf747b0c4c2735768ee31ef0c5.jpg" /></p>\r\n<p>\r\n	李国庆：傻大黑粗：是我们几年来内部自嘲一些商品用语。是指：与超市价格战毛利额就2-3元；很重或很泡，体积大商品，比如接近5KG去污剂，洗发水，润滑油，牛奶，一大包手纸，尿布，还有快16KG哑铃。</p>\r\n<p>\r\n	新京报讯 （记者刘兰兰 实习生李媛）昨日，<a href="http://app.tech.ifeng.com/enterprise/index.php?name=%E4%BA%AC%E4%B8%9C" target="_blank">京东</a>商城CEO刘强东与<a href="http://app.tech.ifeng.com/enterprise/index.php?name=%E5%BD%93%E5%BD%93" target="_blank">当当</a>网总裁李国庆这对&ldquo;冤家&rdquo;再次爆发口水战。</p>\r\n<p>\r\n	针对李国庆此前关于京东烧钱言论，刘强东在其微博上设公开赌局，称京东账户若低于60亿现金就捐款1000万，否则造谣者捐500万。李国庆则表示资本金和账面上现金是两回事，对不断需要资金公司上市是最佳应对质疑办法。</p>\r\n<p>\r\n	日前李国庆对媒体表示，京东钱只够烧到今年8月到12月，资金告罄之后就得去继续寻求融资或者到美国上市，否则会&ldquo;很难过&rdquo;。当当网是赚一个花两个，而京东则是赚一个花四个。</p>\r\n<p>\r\n	刘强东昨日在微博上向李国庆开炮，称：发现国庆兄又是傻大黑粗，又是京东8月钱烧光，而且没完没了四处说。本不屑过问，今日太闲，东哥设一公开赌局：可以让质疑者查看京东账户，低于60亿现金（只是部分账户）东哥个人向&ldquo;爱心衣橱&rdquo;捐1000万，否则造谣者只需捐500万。</p>\r\n<p>\r\n	针对刘强东&ldquo;赌局&rdquo;，李国庆则在其微博上回应称：打赌要先统一评价体系。并表示，资本金和账面上现金是两码事。现金包括对商家应付款，银行贷款负债。&ldquo;对不断需要资金公司上市是最佳应对质疑办法。期待着。&rdquo;</p>\r\n<p>\r\n	对于网友关注&ldquo;傻大黑粗&rdquo;，刘强东称不是骂李国庆，是李国庆在会议上骂他。李国庆则解释说是&ldquo;内部自嘲一些商品用语&rdquo;。</p>\r\n<p>\r\n	资料显示，当当网去年营收36.19亿人民币，京东去年销售额则接近300亿，今年将目标定在1000亿。二者此前也多次打价格战。</p>\r\n<p>\r\n	当当网于2010年12月8日在纽交所上市，通过上市融资2.72亿美元。关于京东商城上市传言也一直没有断过。此前，刘强东在接受记者采访时表示，京东在2013年之前不考虑上市。</p>', '互联网', 'http://epaper.bjnews.com.cn/html/2012-04/18/content_331924.htm?div=-1', '新京报', '', '2012-04-18'),
	(83, '谷歌绕过Safari浏览器隐私设置 可能面临巨额罚款', 'upload/images/1334737471343.jpg', '<p style="text-align: center">\r\n	谷歌街景服务自2007年推出以来一直因牵涉用户隐私问题备受争议</p>\r\n<p>\r\n	【TechWeb报道】4月17日消息，据国外媒体报道，针对谷歌绕过数百万用户Safari浏览器隐私设置行为，美国联邦贸易委员会(Federal Trade Commission)将在未来30天内决定是否对其罚款。此前经过华尔街日报等媒体报道，谷歌已停止该行为。</p>\r\n<p>\r\n	谷歌利用特殊计算机编码技术在电脑、iPhone和iPad上安装cookies追踪文件，以跟踪计算机和移动设备用户，即使这些设备用户已经设置阻止这类文件安装。</p>\r\n<p>\r\n	据报道，美国联邦贸易委员会正在确认谷歌行动是否违反了它去年与政府达成和解协议。2011年，谷歌向政府承诺将不会向消费者&ldquo;错误表达&rdquo;其隐私举措。按照该协议，如出现违反行为，制裁罚金高达每项违规日1.6万美元。</p>\r\n<p>\r\n	目前为止，谷歌和联邦贸易委员会均为出面对这一事件发布置评。</p>\r\n<p>\r\n	谷歌街景服务因涉嫌暴露隐私一直在内外备受争议。此前谷歌还被怀疑搜集了大量未加密无线网络资料，可能违反联邦法律。美国联邦通信委员会日前谴责谷歌妨碍该委员会对其街景项目数据库进行调查，计划对谷歌罚款2.5万美元。（Ginger）</p>', '互联网', 'Ginger', 'TechWeb.com.cn', 'recommend', '2012-04-18'),
	(84, '360诉腾讯案庭审花絮盘点：腾讯一律师叫杨奇虎', 'upload/images/1334737635359.jpg', '<p>\r\n	4月18日消息，奇虎360公司诉腾讯&ldquo;滥用市场支配地位&rdquo;反垄断诉讼今日上午在广东省高院开庭进行公开审理。众多到场媒体通过微博直播现场庭审进展，不过在剑拔弩张辩论之余，现场还有不少小花絮，在此做一项不完全列举，供读者在密切关注案件进展时稍事放松。</p>\r\n<p align="center">\r\n	<br />\r\n	360诉腾讯案今日上午在广东高院开庭审理</p>\r\n<p>\r\n	花絮一、原告拿广东高院在腾讯微博平台直播庭审来说明微博自媒体功能，与即时通讯服务有所区别，被审判长严辞警告：&ldquo;本案没有在腾讯微博直播，请注意你发言。&rdquo;</p>\r\n<p>\r\n	花絮二、腾讯律师团中有一位名叫杨奇虎。</p>\r\n<p>\r\n	花絮三、原被告双方围绕360聘用专家DAVID证人身份和职称进行数轮激烈交锋，360方面当庭出示了英国公平贸易局介绍信。腾讯表示介绍信仍与其自我表述不一致。可怜英国专家DAVID在证人席上一头雾水，看着两家中国公司为他到底是正局还是副局争论不休。</p>\r\n<p>\r\n	花絮四、英国专家DAVID不懂中文，法庭指定广东外语外贸大学一位教师做为翻译，可能对于互联网领域词汇和表述不熟悉，这位老师数次翻译都被纠正，算是上午最杯具参与者，因为审判长问她：&ldquo;你同意另一位专家证人对你纠正吗?&quot;&rdquo;我同意&#8943;&#8943;&ldquo;</p>\r\n<p>\r\n	花絮五、腾讯律师中一位年轻帅哥开始口齿灰常顺溜，但由于发言中有大量专词汇，审判员担心法庭书记员来不及记录，提醒他说慢一点，结果这哥们改为两句话中间停顿3-5秒钟，以至于有同行以为他走神了&#8943;&#8943;最后审判员败给他了：&ldquo;你还是正常说吧，庭审结束后书记员会跟你们双方核实。&rdquo;（内容整理自现场媒体人士微博）</p>', '互联网', '萧萧', 'TechWeb', '', '2012-04-18'),
	(85, '如何评估电子商务网站??网站评估框架确定', 'upload/images/1346868679921.jpg', '<p align="center">\r\n	中国互联网络信息中心分析师 刘波</p>\r\n<p>\r\n	&nbsp;<wbr />&nbsp;<wbr />&nbsp;<wbr /> 电子商务网站是企展示其产品服务和经营战略平台，是买卖双方传递商品和服务信息渠道，更是企拓展市场空间商战工具。根据<span>CNNIC</span><span>公布《</span><span>2012</span><span>年一季度中国中小企互联网应用状况调查报告》数据显示，有</span><span>47.7%</span> <span>中小企已有自己网站或网店。随着企线上销售份额不断扩大，网站会受到企家们更多重视和关注，如何评估自己网站建设效果就成为一个重要问题。本文从用户体验优化角度探讨进行网站评估基本框架。</span></p>\r\n<div>\r\n	<span>　　<span>首先，我们要明确企建设商务网站具备主要功能。企建设网站有三个显而易见目，分别是展示（</span><span>show</span><span>）、交互（</span><span>interaction</span><span>）、交易（</span><span>trading</span><span>），这三点就构成了企网站主要功能，而这三点需要企网站中不同板块来实现，我们可以将其称为功能性板块。例如网站交互功能实现是通过网站在线社区、</span><span>QQ</span><span>、微博链接等网站板块实现，而交易功能这需要网站提供购物车、产品定价、支付链接来实现。</span></span><wbr /><wbr /><wbr /></div>\r\n<p>\r\n	<span><span>&nbsp;<wbr />&nbsp;<wbr />&nbsp;<wbr /> <span>其次是网站建设技术指标，这一部分是整个网站功能实现技术基础，包括网页载入便捷性、链接有效性、网站兼容性等等。</span></span></span></p>\r\n<p>\r\n	<span><span><span>&nbsp;<wbr />&nbsp;<wbr />&nbsp;<wbr /> <a href="http://precommendo.blog.sina.com.cn/showpic.html#blogid=5101b9050101apl7&amp;url=http://s12.sinaimg.cn/orignal/5101b905gc8ea6cc9098b" target="_blank"><img alt="如何评估电子商务网站???酒拦赖目蚣苋范" name="image_operate_23111346809154171" real_src="http://s12.sinaimg.cn/middle/5101b905gc8ea6cc9098b&amp;690" src="http://s12.sinaimg.cn/middle/5101b905gc8ea6cc9098b&amp;690" title="如何评估电子商务网站???酒拦赖目蚣苋范" /></a><br />\r\n	&nbsp;<wbr />&nbsp;<wbr />&nbsp;<wbr /></span></span></span></p>\r\n<p style="text-indent: 21pt">\r\n	最后是网站建设后运行指标，这一部分指标着重体现了在一定时期内网民对企网站访问情况，包括访问次数、每页访问时长、平均页面访问数等指标。</p>\r\n<p style="text-indent: 21pt">\r\n	<a href="http://precommendo.blog.sina.com.cn/showpic.html#blogid=5101b9050101apl7&amp;url=http://s12.sinaimg.cn/orignal/5101b905gc8ea70c2a54b" target="_blank"><img action-data="http%3A%2F%2Fs12.sinaimg.cn%2Fmiddle%2F5101b905gc8ea70c2a54b%26690" action-type="show-slide" alt="如何评估电子商务网站???酒拦赖目蚣苋范" real_src="http://s12.sinaimg.cn/middle/5101b905gc8ea70c2a54b&amp;690" src="http://s12.sinaimg.cn/middle/5101b905gc8ea70c2a54b&amp;690" title="如何评估电子商务网站???酒拦赖目蚣苋范" /></a></p>', '互联网', '刘波', 'cnnic互联网发展研究', 'recommend', '2012-09-06'),
	(86, '最高狂降3400元 8月份手机降价排行榜', 'upload/images/1346868831171.jpg', '<p>\r\n	八月应该是手机市场最为活跃一个月份，因为牵涉到火热暑促所以在这个时间段当中国内外品牌机型都拥有着相对频繁价格变动。9月份又迎来了学生开学又一波购机热潮，相信很多人都想要了解一下目前手机整体价格走势。那么有这类需求用户们不妨看一下本期为大家盘点出来8月份手机降价排行榜吧，虽然这只是8月份降价情况，虽然这只是八款机型，但是以点带面话你也可以从中大致了解到现今手机总体价格情况。</p>\r\n<p>\r\n	狂降3700元：三星B9120</p>\r\n<p>\r\n	三星B9120就是大器II，该机作为又一款旗舰级别高端商务智能3G手机，虽然其价格表现昂贵，但是从上市之后其缺货状态来看足可证明它并不缺少用户群体。在月初上市时候B9120报出了13900元高价，而到了月末时候其价格则降至了10200元新低，总共产生了3700元巨大降幅。不过由于其本身售价基数过大，所以在下降了3000多元之后并没有给人一种低价感觉。<br />\r\n	<br />\r\n	三星B9120也是采用了双屏幕翻盖造型设计，整体外形方面拥有着非常不错质感表现。该机内外双屏幕大小同为3.3英寸，在WVGA级别800x480像素分辨率支持下拥有着清晰显示效果。其背后配有一枚500万像素摄像头，配合一枚130万像素前置摄像头，整体拍摄能力也表现不差劲。内置当中它搭载了Android智能操作系统，一颗1.2GHz主频双核处理器带来了不俗性能表现。</p>\r\n<p align="center">\r\n	<img alt="最高狂降3400元 8月份手机降价排行榜 " height="180" src="http://image.techweb.com.cn/upload/2012/0905/img20120913468406521.jpg" style="border-bottom: #000 1px solid; border-left: #000 1px solid; border-top: #000 1px solid; border-right: #000 1px solid" width="240" /> <img alt="最高狂降3400元 8月份手机降价排行榜 " height="180" src="http://image.techweb.com.cn/upload/2012/0905/img20120913468406522.jpg" style="border-bottom: #000 1px solid; border-left: #000 1px solid; border-top: #000 1px solid; border-right: #000 1px solid" width="240" /><br />\r\n	<br />\r\n	点击图片查看三星B9120详细资料</p>\r\n<p align="center">\r\n	<img alt="最高狂降3400元 8月份手机降价排行榜 " height="180" src="http://image.techweb.com.cn/upload/2012/0905/img20120913468406523.jpg" style="border-bottom: #000 1px solid; border-left: #000 1px solid; border-top: #000 1px solid; border-right: #000 1px solid" width="240" /> <img alt="最高狂降3400元 8月份手机降价排行榜 " height="180" src="http://image.techweb.com.cn/upload/2012/0905/img20120913468406524.jpg" style="border-bottom: #000 1px solid; border-left: #000 1px solid; border-top: #000 1px solid; border-right: #000 1px solid" width="240" /><br />\r\n	<br />\r\n	点击图片查看三星B9120详细资料</p>\r\n<p>\r\n	编辑点评：</p>\r\n<p>\r\n	三星B9120拥有着标志性双屏幕翻盖造型设计，整体外形方面给人带来了出色且具有质感一面。内置当中它搭载了Android智能操作系统，双核处理器等其余配置也更好赋予了该机在操控性方面出色性能，从而使之不再像它前身一样是一款靠外形取胜商务机型。现阶段该机报出了10200元最新售价，不过现今似乎又有一些上涨之势，建议需要朋友不妨尽快考虑一下。</p>\r\n<p>\r\n	三星B9120(行货)</p>\r\n<p>\r\n	[参考价格]&nbsp;10200元</p>', '通信', '王亚南', '中关村在线', '', '2012-09-06'),
	(87, '到底值不值？深度测比亚迪速锐1.5TI 6MT', 'upload/images/1346869150593.jpg', '<p>\r\n	现如今买车情况几乎家家会遇到，无论是城市还是农村，作为一个普通老百姓选择一款既经济又实惠车型则是难上加难。下面这款车型是前段时间上市比亚迪速锐，它搭载了整个同级自主车型中最先进动力总成&mdash;&mdash;1.5TI+6速双离合变速箱，而车内互动信息技术又非常人性化，阅读起来不费脑子,这些技术叠加足够让很多当家人眼前一亮。本次我们试驾这款速锐是一款1.5TI+6速手动版车型，今天我们就先来看看它具体表现如何，双离合版带遥控技术车型将会在未来几天为大家详细介绍。<a class="pic" href="http://db.auto.sohu.com/model_3481/pic_t1740684.shtml" target="_blank"><img alt="" src="http://i1.itc.cn/20120905/2b9b_788aa1ac_8a2e_fa5a_63d3_9932534793da_1.jpg" /></a> <a href="http://db.auto.sohu.com/cartest/" style="float: right; color: #7b0707" target="_blank"><strong>更多精彩评测内容 请进入试驾首页&gt;&gt;&gt;</strong></a></p>\r\n<div class="npsPart3">\r\n	定位：<a class="teshu" href="http://db.auto.sohu.com/model-3481.shtml" target="_blank"><font color="#333333">速锐</font></a>技术更先进且性价比很出色</div>\r\n<p>\r\n	　　厂家将<a class="teshu" href="http://db.auto.sohu.com/model-3481.shtml" target="_blank">比亚迪速锐</a>定位为紧凑级车型，并且不可否认这款<a href="http://db.auto.sohu.com/model-2490.shtml" target="_blank">比亚迪</a>车型我们几乎很难<a href="http://db.auto.sohu.com/model-2590.shtml" target="_blank">发现</a>它模仿了谁，这对于很多自主厂家来讲非常值得肯定。并且在细节设计方面，<a class="teshu" href="http://db.auto.sohu.com/model-3481.shtml" target="_blank">速锐</a>造型更加成熟。</p>\r\n<p align="center">\r\n	　　厂家将其市场售价定为6.59万元~9.99万元，并且推出了多种车型可供选择，具有1.5L自然吸气和1.5TI涡轮增压缸内直喷两款<a href="http://db.auto.sohu.com/baike/250.shtml" target="_blank">发动机</a>，自然吸气车型搭载5速<a href="http://db.auto.sohu.com/baike/100.shtml" target="_blank">手动变速箱</a>。增压车型分别搭载6速手动和6速双离合<a class="teshu" href="http://db.auto.sohu.com/baike/251.shtml" target="_blank">变速箱</a>，这在自主车型甚至很多合资车型中都非产少见。</p>\r\n<p align="center">\r\n	<a href="http://db.auto.sohu.com/model_2856/pic_t1568845.shtml" target="_blank"><img alt="" src="http://m2.auto.itc.cn/car/x/45/88/Img1568845_x.JPG" style="border-bottom: #404040 1px solid; border-left: #404040 1px solid; border-top: #404040 1px solid; border-right: #404040 1px solid" title="长城 C50 实拍 外观 图片" /></a></p>\r\n<p align="center">\r\n	<a href="http://db.auto.sohu.com/model_2579/pic_t1457624.shtml" target="_blank"><img alt="" height="180" src="http://m1.auto.itc.cn/car/270/24/76/Img1457624_270.JPG" style="border-bottom: #404040 1px solid; border-left: #404040 1px solid; border-top: #404040 1px solid; border-right: #404040 1px solid" title="宝骏 630 实拍 外观 图片" width="270" /></a>&nbsp;<a href="http://db.auto.sohu.com/model_3347/pic_t1300820.shtml" target="_blank"><img alt="" height="180" src="http://m1.auto.itc.cn/car/270/20/08/Img1300820_270.JPG" style="border-bottom: #404040 1px solid; border-left: #404040 1px solid; border-top: #404040 1px solid; border-right: #404040 1px solid" title="长安 逸动 实拍 外观 图片" width="270" /></a></p>\r\n<p>\r\n	　　目前<a class="teshu" href="http://db.auto.sohu.com/model-3481.shtml" target="_blank">速锐</a>主要竞争对手有<a href="http://db.auto.sohu.com/brand_168/index.shtml" target="_blank">长城</a>C50、<a href="http://db.auto.sohu.com/model-3347.shtml" target="_blank">长安逸动</a>以及<a href="http://db.auto.sohu.com/model-2579.shtml" target="_blank">宝骏630</a>等几款车型。首先从价位角度考虑，<a class="teshu" href="http://db.auto.sohu.com/brand_168/index.shtml" target="_blank">长城</a>C50售价为7.8万元~9.18万元，全部为1.5T+5速手动车型，目前来看<a href="http://db.auto.sohu.com/model-2856.shtml" target="_blank">C50</a>单纯一款<a class="teshu" href="http://db.auto.sohu.com/baike/100.shtml" target="_blank">手动变速箱</a>可选择性明显较弱。</p>\r\n<p align="center">\r\n	<a href="http://db.auto.sohu.com/model_2856/pic_t1295970.shtml" target="_blank"><img alt="" src="http://m3.auto.itc.cn/car/x/70/59/Img1295970_x.jpg" style="border-bottom: #404040 1px solid; border-left: #404040 1px solid; border-top: #404040 1px solid; border-right: #404040 1px solid" title="长城 C50 实拍 评测 图片" /></a></p>\r\n<p align="center">\r\n	<a href="http://db.auto.sohu.com/model_3347/pic_t1300668.shtml" target="_blank"><img alt="" src="http://m1.auto.itc.cn/car/x/68/06/Img1300668_x.JPG" style="border-bottom: #404040 1px solid; border-left: #404040 1px solid; border-top: #404040 1px solid; border-right: #404040 1px solid" title="长安 逸动 实拍 评测 图片" /></a></p>\r\n<p>\r\n	　　另外一个强劲对手就是当下市场热度同样很高<a class="teshu" href="http://db.auto.sohu.com/model-3347.shtml" target="_blank">长安逸动</a>，编辑本人也曾经对<a href="http://db.auto.sohu.com/model-3347.shtml" target="_blank">逸动</a>进行过深入<a class="teshu" href="http://goche.auto.sohu.com/cartest/" target="_blank">试驾</a>，其出色高速稳定性给我留下了深刻印象。不过相比眼前<a class="teshu" href="http://db.auto.sohu.com/model-3481.shtml" target="_blank">比亚迪速锐</a>，其1.6L自然吸气<a class="teshu" href="http://db.auto.sohu.com/baike/250.shtml" target="_blank">发动机</a>以及匹配5速手动或4速<a href="http://db.auto.sohu.com/baike/102.shtml" target="_blank">手自一体变速箱</a>，在动力输出方面稍有逊色。并且<a class="teshu" href="http://db.auto.sohu.com/model-3347.shtml" target="_blank">逸动</a>7.39万元~9.49万元售价也没有成为其加分项目。</p>', '汽车', '王文咨', '搜狐汽车', '', '2012-09-06'),
	(88, '广西国家级贫困县农民房首曝光 家家别墅大泳池', 'upload/images/1346869815531.jpg', '<p>\r\n</p>\r\n<table border="0" cellpadding="0" cellspacing="0" width="600">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle" height="470" valign="center">\r\n				<a id="precommendoimg"><img height="399" id="precommendo" src="http://y1.ifengimg.com/f04c9b92453d105f/2012/0905/xes_b766ffa6a4706bea6f0a6fcbcfe426b8.jpg" style="filter: alpha(opacity=100)" width="598" /></a></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table border="0" cellpadding="0" cellspacing="0" width="600">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle" height="470" valign="center">\r\n				<a id="precommendoimg"><img height="383" id="precommendo" src="http://y1.ifengimg.com/f04c9b92453d105f/2012/0905/xes_5686f09ff07df618bfae3f99c04e0592.jpg" style="filter: alpha(opacity=100)" width="598" /></a></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table border="0" cellpadding="0" cellspacing="0" width="600">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle" height="470" valign="center">\r\n				<a id="precommendoimg"><img height="390" id="precommendo" src="http://y1.ifengimg.com/f04c9b92453d105f/2012/0905/xes_56a764cdc0e8b7aea93f0aed05aaa59d.jpg" style="filter: alpha(opacity=100)" width="599" /></a></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table border="0" cellpadding="0" cellspacing="0" width="600">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle" height="470" valign="center">\r\n				<a id="precommendoimg"><img height="397" id="precommendo" src="http://y3.ifengimg.com/f04c9b92453d105f/2012/0905/xes_f5d490f41d1195d3fb1def096cf07178.jpg" style="filter: alpha(opacity=100)" width="598" /></a></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	广西百色市今年刚刚甩掉国家级贫困县帽子革命老区&mdash;&mdash;平果县近几年来陆续建成别墅似农民住宅群成为一道亮丽风景线。</p>', '房地产', '', '凤凰网房产', '', '2012-09-06'),
	(89, '马化腾：将通过QQ互联逐步开放QQ关系链', 'upload/images/1350734240374.jpg', '<p style="text-align: center">\r\n	<span style="font-size: 12px">腾讯董事会主席马化腾(<span class="infoMblog"><a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">微博</a></span><a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">)（腾讯科技配图）</a></span></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">在10月19日举行&ldquo;移动开发者大会&bull;中国2012&rdquo;中，腾讯董事会主席兼CEO马化腾表示，在PC互联网开放同时，腾讯将通过QQ互联逐步开放移动端QQ关系链。</a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank"><strong>唱吧过半用户来自QQ互联</strong></a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">马化腾表示，腾讯在移动互联网上开放QQ互联，也就是让其他App可以直</a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">接使用QQ帐号和密码登录，并尝试逐步、分步骤开放关系链，目前正处于在和移动开发商合作测试阶段。据了解，目前市场上火爆应用&ldquo;唱吧&rdquo;有超过50%用户都来自QQ帐号登录；美丽说手机端，QQ登录为其带来新注册用户数提升比例达35%，使用QQ登录用户数是使用其他社交网站帐号登录用户数总和3倍。</a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">马化腾在演讲中表示：&ldquo;对于腾讯来说，我们定位就是希望可以为所有移动开发者打造一个开放移动互联网平台。一年前，我们腾讯发布了一个开放战略。那个时候主要是针对PC互联网，尤其是针对PC上社交网站。更准确说就是首先开放了Qzone，在中国最大社交平台。到目前为止一年半过去了，到今年6月份，我们累计分成收入和开发者实际收入已经超过10亿元人民币。单个开发者单月分成收入已经突破2千万人民币。我想这是实在例子，可以证明我们成功。现在我打算把这个思路推向移动互联网，我想大家要更关注这个方面进展。我们在移动互联网方面尝试开放QQ互联，也就是让其他App可以直接使用QQ帐号和密码登录。目前还没有完全开放，还在测试中，我们选取少量移动开发者跟我们合作。</a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank"><strong>腾讯高额奖金悬赏优秀移动APP</strong></a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">据悉，截止目前，QQ互联已经接入了34万家网站和4000余款移动应用，QQ帐号在第三方网站和移动应用登录量持续迅猛增长，QQ帐号登录已经成为国内最大社会化帐号登录体系。随着QQ关系链逐步开放，整个QQ互联系统将掀起移动应用开发热潮。移动APP接入QQ互联即可参加腾讯开放平台应用创新大赛，获得万元推广资源、角逐QQ关系链开放首批合作机会。</a></p>\r\n<p style="text-indent: 2em">\r\n	<a class="a-tips-Article-QQ" href="http://t.qq.com/pony#pref=qqcom.keyword" rel="pony" reltitle="马化腾" target="_blank">为了激励更多移动应用开发者加入腾讯开放平台移动互联，更好服务于腾讯海量用户，腾讯开放平台应用创新大赛移动赛区推出新巨大奖励计划。具体如下：第一，凡参加&ldquo;腾讯开放平台应用创新大赛&rdquo;移动应用，获得价值10000元应用推广资源及腾讯免费提供云服务;第二，移动榜单TOP10应用，有机会获得QQ关系链首批合作机会及价值10万元应用推广资源;第三，总决赛个人(高校)组第一名移动应用，可以获得20万人民币奖金、多个终端预装机会及QQ关系链开放合作机会;第四，总决赛企组第一名移动应用，可以获得价值100万元应用推广资源，多个终端预装机会及QQ关系链开放合作机会。</a></p>', '互联网', '', '腾讯科技', 'recommend', '2014-01-25'),
	(90, '艾瑞：优酷土豆领衔用户覆盖 PPTV坐二望一', 'upload/images/1350734486264.gif', '<p>\r\n	　随着网络视频领域竞争氛围不断升级，视频厂商利用数据进行行卡位做法愈发频繁。然而由于各家索引数据并未采取统一标准，存在一定片面引用，导致在人们看来&ldquo;视频行第一&rdquo;排位日渐廉价，外界对视频行真实运营情况不明所以。　</p>\r\n<p>\r\n	　　此前便有内人士曝光，近日在各大网站间传播&ldquo;腾讯视频单平台覆盖超过优酷&rdquo;稿件内容试图通过概念转换混淆视听。该篇稿件中，作者在引用腾讯视频周用户覆盖时选取艾瑞&ldquo;视频综合服务&rdquo;数据，引用优酷周用户覆盖数据时仅选取了网站服务而非综合服务，也因此呈现出&ldquo;腾讯视频单平台覆盖超过优酷&rdquo;结果，也是该文章缺乏图片印证根本原因。</p>\r\n<p>\r\n	　　在资深观察人士眼中，考量视频企运营现状与用户覆盖时，针对&ldquo;综合服务&rdquo;进行考量无疑更加准确。视频综合服务指是PC网站和客户端在去掉重复用户后视频用户覆盖数值。是目前行和广告主认可数据标准。</p>\r\n<p>\r\n	　　近日，第三方分析机构艾瑞咨询发布了网络视频行有关综合服务日均覆盖数据报告。报告显示，目前优酷土豆综合服务日均覆盖达到4394万人，位居视频行首位;PPTV网络电视则凭借3366万人规模综合服务日均覆盖紧随新近合并优酷土豆之后，PPS则位居行第三位。</p>\r\n<p>\r\n	通过视频企综合服务日均覆盖排行可知，整合后优酷土豆在视频用户覆盖规模上依然占据领先；PPTV继续延续此前用户规模快速扩张势头，位居第二。与此同时，搜狐视频、腾讯视频以及爱奇艺也超过二千万日活跃用户，紧随前三甲，其中搜狐视频销售团队务分拆被指为上市铺路。值得一提是，在线视频类服务中，PPTV和腾讯视频在PC网站和客户端方面并举发展，与其他家在产品服务形态方面建立了差异化。不过最近也看到，优酷和搜狐都开始了在客户端视频方面研发和推广。&ldquo;网站+客户端&rdquo;双模式运营或将是未来各家视频服务发展趋势之一。</p>', '互联网', '', '中国网', '', '2012-10-20'),
	(91, '传漾副总裁刘毅：移动互联网和传统互联网迈向融合', 'upload/images/1350734586983.jpg', '<p>\r\n	&nbsp;我们现在都了解到整个市场，移动互联网非常热，大家也看到移动互联网是一个非常大趋势。我们怎么把移动互联网和互联网如何更好如何，今天最主要是下面四个字&ldquo;迈向融合&rdquo;。</p>\r\n<div class="content_intr" id="divContent">\r\n	<!--content_start-->\r\n	<p>\r\n		　　投资界10月16日消息，由清科集团举办第107期Z-club移动广告专场&ldquo;移动广告投资&mdash;&mdash;小屏幕撬动大市场&rdquo;今天下午两点在北京贝塔咖啡举行， <span style="line-height: 22px; font-family: Arial, Helvetica, sans-serif; color: rgb(68,68,68)">传漾创始人兼副总裁</span><span style="line-height: 22px; font-family: Arial, Helvetica, sans-serif; color: rgb(68,68,68)">刘毅</span>出席本次沙龙并发表主题演讲。</p>\r\n	<p>\r\n		&nbsp;以下为演讲实录：</p>\r\n	<p>\r\n		　　我先简单介绍一下，大家应该了解传漾是一家<a href="http://news.pedaily.cn/industry/互联网/" target="_blank"><font color="#004079">互联网</font></a>公司，主要是以<a href="http://news.pedaily.cn/industry/互联网/" target="_blank"><font color="#004079">互联网</font></a>精准营销，监测和发布，还有一些大型网站AP系统都是用是传漾系统，还有客户监测系统都是来自于传漾。</p>\r\n	<p>\r\n		　　今天跟大家一起分享，就是如何将移动互联网跟互联网进行相互融合？我们现在都了解到整个市场，移动互联网非常热，大家也看到移动互联网是一个非常大趋势。我们怎么把移动互联网和互联网如何更好如何，今天最主要是下面四个字&ldquo;迈向融合&rdquo;。</p>\r\n	<p>\r\n		　　跟其他演讲者一样，先看一组数据，这些数据大家都非常了解。全球移动互联网用户已经达到了15亿，从增长速度来讲远远超过了互联网，07年开始0.68亿，11年已经有11亿了。还有从数据来看，全球第二季节手机出货率达到了1.58亿部，整个增长速度大概是46.9%，但是中国第二季度整体增长率是4200万户，增长速度接近200%，我们数据跟全球来比大概是4倍，所以移动互联网市场争夺焦点，从全球来看中国是一个重点。</p>\r\n	<p>\r\n		　　CNNIC到2012年6月底中国手机网民规模达到了3.88亿，我们增长速度是非常快，从上半年底到69.3一直到72.2%，手机网民数量已经超过了台式电脑，未来发展空间还是很大。</p>\r\n	<p>\r\n		　　但是有一点，虽然说我们方向特别好，我们网民数增长得特别快，但是所有移动广告和数字广告占有率确非常小，每年增长率或者每半年增长率很多都没有超过2%，可能这是为什么呢？首先看这个市场让人特别兴奋，为什么这么多数据量，这么多一个人群我们增长率却是这样呢？我们简单去分析它，从我们自己数据来考量，首先移动互联网市场对于整体客户认知度不是很足，只是到营销初级阶段。另外客户对这种移动互联网广告作为一个营销工具，没有深入去了解，深入去考量。另外我们想做精准也好，想达到相应客户也好，数据全是<a href="http://news.pedaily.cn/industry/运营商/" target="_blank"><font color="#004079">运营商</font></a>，我们只是相应给到我们相应数据，对于所有广告主来讲更希望拿到更深层次相应数据。因为所有客户一开始做移动互联网是一种尝试心态，他了解这个东西特别新鲜，所有做广告人都了解很多客户都喜欢更新鲜东西，你老给同样模式，同样格式，对于我来讲没有太大突破性，太大吸引力，对于网民也好或者看广告人来讲，没有过多一个吸引力，所以都需要一些新鲜东西。他感觉到互联网非常好，从最初彩短信，到现在AP，都挺好，最终拿到数据都是一些片面，或者只是一些点击和浏览，已经满足不了现在广告主所要需求。</p>\r\n	<p>\r\n		　　移动互联网营销依然是一个大趋势，我们看到所有数据，所有网民一些用户量增长速度特别快。下面就是我今天主要一个重点，我讲是如何让移动互联网和互联网相应融合趋势，我认为移动互联网基础是互联网，我们先前把互联网做好，把基础打好，之后才考虑移动互联网。传漾怎么相应来融合，怎么相应把这些产品做得更好呢？我讲很重要一点，是一个增强互动性。现在我主要讲一下这个例子，如果电脑要能上网，可以点一下这个链接，第一个我们融合焦点在哪里？焦点在于二维码，二维码现在铺天盖地，前几年比较高端手机才能用，低端手机用不了。现在手机二维码识别率是非常非常之高了。现在是二维码手机屏和电脑屏互动，跟<a href="http://zdb.pedaily.cn/Enterprise/新浪/" target="_blank"><font color="#004079">新浪</font></a>是独家合作，新浪用是传漾技术。</p>\r\n	<p style="text-align: center">\r\n		<img alt="传漾副总裁刘毅：移动互联网和传统互联网迈向融合" src="http://pic.pedaily.cn/201210/20121016@13467.jpg" /></p>\r\n	<p>\r\n		　　我仔细讲一下整个广告互动流程，第一点打开新浪首页，这个是三星手机广告，旁边有一个相应二维码，可以得到相应小游戏互动，会出现这样一个形式。这个时候如果我们网民拿手机八秒钟之内扫描了二维码之后，你手机上会出现一个键盘，这个键盘就是可以上下左右来玩这个游戏，吃掉了之后有更详细一关。新浪广告只有八秒时间，八秒没有时间扫描二维码，但是可以自动<a href="http://news.pedaily.cn/industry/搜索/" target="_blank"><font color="#004079">搜索</font></a>到新浪广告，你去扫描还会出现这样一个图片，之后你手机屏幕和电脑屏幕会出现一个相应互动，手机相当于一个操作界面。通过这样一个相应广告，从技术角度来讲是很简单，从应用角度来讲，我们是在互联网广告，怎么调用到移动方面去融合？很多人不做互联网，我想直接进入移动互联网广告，现在所有客户各方面想得还没有跨度这么大，他希望两个方面都有一些，相互融合一些。所以说通过这样一种形式，我们可以得到一些丰富数据获取，无论是互联网上数据，还是移动互联网上数据，我通过相应数据进行详细分析，大家对传漾了解我们在互联网监测，还有数据分析这一套系统中，专门有一套系统，通过相应数据收集，无论是流量分析，来源分析，用户行为分析，包括内容分析。我之前在一个主题会议上讲，我们现在进入了一个大数据时代，无论是从手机、电脑，还是宣传单，数据也非常多，各个方面数据都要拿过来进行分析，因为每个数据都是一个端口，这个端口可以了解到人群，了解到网民需求，网民所需要一些东西。</p>\r\n	<p>\r\n		　　我们把相应数据收集到哪里？这就是我们另外一个产品，叫Samadata，我相信所有数据会到这个库里面，我们现在收集到受众数据是9亿多，收集到相应终端之后进行详细分析，首先我们通过兴趣定向用户分析，我们整个把所有数据分成33个大类，168个中类，857个小类，分得非常细，我们可以通过相应对比值了解到男女大概状况，区域大概状况，还有收入情况。通过关键词语义进行定向<a href="http://news.pedaily.cn/industry/搜索/" target="_blank"><font color="#004079">搜索</font></a>，我们在互联网方面基于1000多个媒体资源和受众，还有互动轨迹。我们通过所有收集相应数据我们进行训练样本等成熟模型，通过关键词定向，语义定向，进行匹配展示。</p>\r\n	<p>\r\n		　　传漾通过不断数据相应积累和技术创新，对每个受众行为、模型计算，成为真正引擎。我们希望在移动互联网像所有<a href="http://news.pedaily.cn/industry/运营商/" target="_blank"><font color="#004079">运营商</font></a>拿到纳米级数据，我们通过自己方式和方法，一些数据收集经验值和技术值来达到最终目。</p>\r\n	<p>\r\n		　　谢谢大家！</p>\r\n	<p>\r\n		<!--content_end--><!--content_pagestart--><!--content_pageend--></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '互联网', '', '新浪', 'recommend', '2012-10-20'),
	(92, '易观：2012第三季度iPad在华市场份额下滑1%', '', '<div class="img_wrapper">\r\n	<img alt="1" src="http://i2.sinaimg.cn/IT/2012/1019/U6680P2DT20121019110348.png" title="1" />\r\n	<div class="img_wrapper">\r\n<img alt="2" src="http://i0.sinaimg.cn/IT/2012/1019/U6680P2DT20121019110405.png" title="2" />\r\n		</div>\r\n</div>\r\n\r\n<img alt="4" src="http://i3.sinaimg.cn/IT/2012/1019/U6680P2DT20121019110417.png" title="4" />\r\n<p>\r\n	　　新浪科技讯 10月19日上午消息，根据EnfoDesk易观智库产数据库发布《2012年第3季度中国平板电脑市场季度监测》数据显示，2012年第3季度中国市场售出平板电脑260.4万台。从厂商市场份额来看，苹果占据71.42%市场份额，有所下滑；联想市场份额排名第二，达到10.52%；壹人壹本排名第3位，市场份额为3.61%%，三星市场份额排名第四，占比为3.53%。</p>\r\n<p>\r\n	　　<span lang="EN-US">EnfoDesk</span><span style="font-family: 宋体；">易观智库分析认为，</span><span lang="EN-US">2012</span><span style="font-family: 宋体；">年第</span><span lang="EN-US">3</span><span style="font-family: 宋体；">季度中国平板电脑厂商市场格局需要关注以下四点：</span></p>\r\n<p>\r\n	　　<span lang="EN-US">1.</span><span style="font-family: 宋体；">苹果市场份额较二季度</span><span lang="EN-US">72.66%</span><span style="font-family: 宋体；">有所下滑，降至</span><span lang="EN-US">71.42%</span><span style="font-family: 宋体；">，主要原因在于</span><span lang="EN-US">New iPad</span><span style="font-family: 宋体；">销量主要集中与二季度，三季度</span><span lang="EN-US">iPad2</span><span style="font-family: 宋体；">与</span><span lang="EN-US">The new iPad</span><span style="font-family: 宋体；">进入自然出货状态。</span></p>\r\n<p>\r\n	　　<span lang="EN-US">2.</span><span style="font-family: 宋体；">联想平板电脑销量三季度增长较高，市场份额上升到</span><span lang="EN-US">10.52%</span><span style="font-family: 宋体；">，源于新品</span><span lang="EN-US">S2107</span><span style="font-family: 宋体；">与</span><span lang="EN-US">S2109</span><span style="font-family: 宋体；">发布以及学生返校季促销力度有所增加多方面带动作用。</span></p>\r\n<p>\r\n	　　<span lang="EN-US">3.</span><span style="font-family: 宋体；">由于三季度壹人壹本新产品</span><span lang="EN-US">T5</span><span style="font-family: 宋体；">新品发布，带动壹人壹本整体销量增长，</span> <span style="font-family: 宋体；">以及</span><span lang="EN-US">T4</span><span style="font-family: 宋体；">在部分省份价格有所下滑，进一步促进了壹人壹本销量。</span></p>\r\n<p>\r\n	　　<span lang="EN-US">4.</span><span style="font-family: 宋体；">三星平板电脑在中国市场销量一直呈现比较平稳状态，三季度三星</span><span lang="EN-US">Note</span><span style="font-family: 宋体；">平板电脑系列(</span><span lang="EN-US">7</span><span style="font-family: 宋体；">寸及以上版本)营销投入力度增加，品牌效应开始彰显，拉动三星平板电脑中国区销量。</span></p>\r\n<p>\r\n	　　<span style="font-family: 宋体；">另外，该季度</span><span lang="EN-US">EnfoDesk</span><span style="font-family: 宋体；">易观智库对商务平板市场市场进行研究，目前该市场中，壹人壹本占据头把交椅，市场份额达到</span><span lang="EN-US">41.07%</span><span style="font-family: 宋体；">，三星在三季度发布</span><span lang="EN-US">Galaxy Note10.1</span><span style="font-family: 宋体；">系列商务平板电脑强化商务平板市场地位，</span> <span style="font-family: 宋体；">商务平板市场份额占比为</span><span lang="EN-US">19.66%</span><span style="font-family: 宋体；">。联想</span><span lang="EN-US">ThinkPad</span><span style="font-family: 宋体；">处于自然出货状态，销量不大，市场份额占比为</span><span lang="EN-US">3.89%</span><span style="font-family: 宋体；">。</span></p>\r\n<p>\r\n	<!-- publish_helper_end --><!-- 转发到微博 begin --></p>\r\n', '电脑', '', '新浪科技', '', '2012-10-20'),
	(93, '苹果官网iPad 2翻新版机型售价降至2378', '', '<p>\r\n	<a href="http://app.tech.ifeng.com/product/index.php?name=iPad" target="_blank"><strong><font color="#004276">iPad</font></strong></a> mini发售日期临近，其相关消息也接连不断传出。日前<a href="http://app.tech.ifeng.com/enterprise/index.php?name=%E8%8B%B9%E6%9E%9C" target="_blank"><strong><font color="#004276">苹果</font></strong></a>中国官网宣布限时优惠出售翻新版iPad 2，最低版本售价2378元人民币。此次降价也被视作苹果为iPad mini让路举措之一。</p>\r\n<p align="center">\r\n	<img alt="" src="http://y2.ifengimg.com/2d035cf0451b2488/2012/1020/ori_50828c2545546.jpeg" /></p>\r\n<p>\r\n	此次降价包括个版本iPad 2，WLAN 16GB版售价2378元人民币，32GB版2948元，64GB版3748元，WLAN+3G 16GB版2998元。白色WLAN 16GB版已经显示脱销。</p>\r\n<p>\r\n	尽管外界对iPad Mini已有很多猜测，但苹果官方尚未确认这样一款产品存在。据知情人士透露，苹果将于10月23日发布这款新品，网络上甚至出现了iPad mini价格表。</p>', '电脑', '', '泡泡网', '', '2012-10-20'),
	(94, '跨国网购架起现代“香料之路” 中国网民成主力军', 'upload/images/1374734600910.jpg', '<p style="text-align: center;">\r\n	<span style="font-size: 12px;">PayPal总裁马库斯路（腾讯科技配图）</span></p>\r\n<p>\r\n	<span style="font-size: 12px;">[<strong>导读</strong>]研究发现，省钱和购买本国没有商品是进行跨国网购主要两个原因。</span></p>\r\n<p style="text-indent: 2em;">\r\n	<strong>腾讯科技讯</strong>（晨曦）北京时间7月24日消息，据国外媒体报道，网上购物，不仅便利了一国网民，此外也促进了全球各国之间贸易。支付商PayPal于7月22日发布一份报告显示，跨国网购构建起了现代版&ldquo;香料之路&rdquo;（古代香料由北非和中东输入中国路线），中国无论是在购买人群还是卖家销售上，均成为热点地区。</p>\r\n<p style="text-indent: 2em;">\r\n	这份报告由PayPal委托尼尔森公司调查并且撰写。报告指出，中国（包括香港地区）、加拿大、德国、澳大利亚、英国和美国今年跨国在线购物规模，将达到1050亿美元，未来五年，这一数字还将翻三倍，达到3070亿美元。</p>\r\n<p style="text-indent: 2em;">\r\n	PayPal总裁马库斯（David-Marcus）表示，在传统贸易中，中小商户被遗忘，但是凭借电子商务，本地商户，同样可以争取全球消费客户，&ldquo;互联网发展，使得小商户也可以让整个世界成为他们后院市场。&rdquo;</p>\r\n<p style="text-indent: 2em;">\r\n	据称，如今PayPal在线支付四分之一，和跨国网购有关。而近些年，PayPal也在逐步解决货币兑换、海外买家满意度、网站优化等全球化难题。</p>\r\n<p style="text-indent: 2em;">\r\n	报告称，在全球跨国网购中，美国是最热门目地，其次是英国、中国以及中国香港。</p>\r\n<p style="text-indent: 2em;">\r\n	在跨国商户竞相争夺买家市场中，中国排名第一，其次是阿根廷、俄罗斯、巴西和澳大利亚。</p>\r\n<p style="text-indent: 2em;">\r\n	尼尔森公司预测说，今年，跨国网购族将购买价值125亿美元服装、鞋类和服饰，花费在健康产品、美容产品上金额则为76亿美元。</p>\r\n<p style="text-indent: 2em;">\r\n	马库斯表示，今天，跨国网购规模发展到了前所未有水平，研究结果显示，不仅今天市场规模很大，而且消费者从全球商家进行网购市场潜力很巨大。</p>\r\n<p style="text-indent: 2em;">\r\n	这位高管指出：&ldquo;调查报告得出信息很简单，这些现代香料之路崛起，对于全球各大经济体和中小企，是极大利好消息。&rdquo;</p>\r\n<p style="text-indent: 2em;">\r\n	各国网民为何要进行跨国网购？尼尔森调查发现，省钱、购买本国没有商品是进行跨国网购主要两个原因。</p>', '互联网', '晨曦', '腾讯科技', 'recommend', '2015-05-24'),
	(95, '互联网主流新玩法：套现你社交关系', 'upload/images/1374735139459.jpg', '<p>\r\n	&nbsp;&nbsp;&nbsp;&nbsp;</p>\r\n<p class="wp-caption-text" style="text-align: center">\r\n	钛媒体注：中国4亿移动互联网用户使用社交应用比例</p>\r\n<p>\r\n	社交生态关系，如何赚钱？像六间房秀场，以前六间房跟优酷、土豆一样，是B2B型，靠企付广告费，现在，基本转向了C端，靠个人用户付费，占到总收入90%。YY、天鸽盈利模式基本类似。</p>\r\n<p>\r\n	最近艾瑞发了一个&ldquo;社交视频报告&rdquo;，在圈内引起一些反响，大家好奇有几点：一是独立出一个所谓新领域，规模一年好几十亿；二是有几家闷声发财公司，六间房、YY，天鸽，年收入从三五亿到十亿不等，个个都盈利，比优酷之类年年亏损视频大佬们日子好过多了；三是这些企是怎么赚钱。</p>\r\n<p>\r\n	这里说社交视频，和以前讲视频社交，或者视频社交化，是两个概念。字面上看很像，容易弄混，其实，意思和内涵差别却不小，就像最近更热互联网金融和金融互联网，阿里干是前者，中农工建做是后者，都是金融那点事儿，但本质和玩法，却不太一样。</p>\r\n<p>\r\n	看这种报告，我个人还是对一些数字感兴趣，行规模，用户量，主要公司收入等等。摘几个艾瑞报告里数据跟大家分享。社交视频是从视频网站演化分支出来，2012年规模是22亿，今年有可能达到31.7亿，他们大胆预测了三年后将达到101亿。用户规模，去年过了1亿，今年估计会到1.39亿，目前中国互联网用户将近6亿，只能说初具一些规模。</p>\r\n<p>\r\n	传统视频网站话，说说优酷土豆吧，今年一季度净收入5.16亿人民币，营收规模不小，但净亏了2.325亿，如果乐观点看，优酷土豆净收入还在增长，亏损面在缩小，但总归一直没能正经盈利过。据说，优酷也准备做社交视频，估计是看到这种务能带来不错现金流和收入，至于能不能玩好，这就像中农工建能不能玩明白互联网金融一样。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这些，我相信不是大家关注重点，还是对怎么赚钱更感兴趣。</p>\r\n<p>\r\n	所以，本文说下这个事情。六间房、YY我了解多一些。2010年，各公司刚从金融危机缓过神儿来，我跟六间房CEO刘岩长谈过一次，当时他跟我讲几点，让我印象很深刻。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第一，刘岩当时告诉我，六间房盈利了，但盈利不算太多。当时将信将疑，因为六间房刚经过痛苦资金危机和大裁员。他跟我聊最多，还是六间房秀场和前景，当时秀场还在摸索和尝试阶段，这也是现在提到社交视频时，经常被说到一个产品模式和盈利模式。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	第二，他跟我讲，创新很快乐，也很痛苦，被饥饿感逼，压力很大。&ldquo;视频行最大问题，是缺少原创思维，谁火学谁，学YouTube，学Hulu，永远用别人概念和模式在做。但他坚信一点，只要踏踏实实把产品和务做好，一切自然就来了。&rdquo;这是他原话。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	这几年，我和刘岩时不时还有交流，也看着他们一点点闷头鼓捣，除了完善&ldquo;秀场&rdquo;这种在线演艺模式，他们还做了线上线下互动大型歌唱选秀、演唱会，还买了中超转播权等等，貌似差别很大，实际上，都是在围绕社交和视频，尝试构建一个新型生态关系链，并且这个链还得能赚钱。有些能看明白，有些也是云里雾里。但刘岩就是这么个人，爱琢磨，爱尝试新玩意，别人都反对事儿，他就非想试吧试吧，有点?丝范儿。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	当年行洗牌，死掉一堆视频网站，六间房活了过来，而且现在活越来越滋润。重新引起人们关注，和社交视频有很大关系。那么，社交视频里最主要秀场模式，是个什么东西呢？微博做个例子，微博让每个人有了一个自媒体，如果你有能力经营好，那它就是一个可以影响别人舆论阵地，现在微博活跃度大幅下滑，始终也找不到怎么赚钱，其实跟它无法建立强社交关系有关。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	多说几句微博，还是想说明秀场。秀场是一个视频直播平台，每个人在秀场上拥有直播房间，简单来说，就像一个直播网络直播电视台，那些俊男美女主播们，可以唱歌、表演吸引粉丝关注，积累人气。一个人在房间里直播表演时，下面会有几万、几十万人观看，这个时候，这种直播间，就和一个地市级电视台具备了同样收视规模，还可以在线互动。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>这种生态关系，如何赚钱？像六间房秀场，以前六间房跟优酷、土豆一样，是B2B型，靠企付广告费，现在，基本转向了C端，靠个人用户付费，占到总收入90%。YY、天鸽盈利模式基本类似。</strong></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	个人付费过程是这样：一个漂亮女主播唱歌很好听，慢慢吸引了很多人关注，大多数人是免费看热闹，但这里有一部分人，愿意花十块钱，通过六间房虚拟货币&ldquo;六币&rdquo;，点播一首自己喜欢歌，或自己听，或送给别人，主播唱了，这笔点歌费，就变成六间房和主播可分享收入之一。然后，点歌还不算，有用户还愿意送虚拟鲜花给主播，五块钱一只，以表支持和喜爱，跑车，飞机，航母，这些都能送。</p>\r\n<p>\r\n	再然后，通过送虚拟礼物，用户等级不断增加，不同等级会带来一定特权，就像QQ一样，可以踢人，可以坐着跑车登场，这些特权就是用户在社区里地位象征，慢慢就形成一种社交关系。六间房每天能卖掉几十万朵鲜花，这些虚拟礼物成为最主要收入来源。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	刘岩喜欢用两个例子说明这种关系，他也讲过多次。唐朝最主要文化娱乐方式是诗歌，李白在当时就像今天迈克尔&bull;杰克逊，诗歌在当时是无法卖版税，李白靠诗歌成名，靠影响力得到支助，可以到所有饭馆吃饭不花钱；当年梅兰芳唱戏也是，最大收入不是门票，而是依靠用户打赏。还有，六间房曾经为某超女举办两场在线个人秀，第一场采用买门票方式，结果只卖了5000元票，3天后改成一场网络生日会，结果虚拟生日蛋糕卖了30万。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	实际上，秀场是一种非实名社区，与微博这种偏实名注册社区有很大不同，现实身份，你是公知，你是教授，你是老板，在这种非实名社区，都不好使，就像通过微博很难建立强社交关系一样，而非实名化，更容易建立强社交关系，也容易利用关系套现。这是所谓社交视频内在逻辑，从这个角度看，之前人人网和56融合，把社交+视频嫁接到一起，只是在内容层面，进行了互通，关系构建上并没有实质突破，所以，现在看，整合效果很有限。</p>\r\n<p>\r\n	事实上，如果优酷土豆，也是以内容思维，来做社交视频，可能结果也不会太理想，没有抓住实质和核心。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	六间房秀场也从PC端，开始向Pad、向苹果iOS平移。未来，这都是抓取新用户发力点。还有些点也值得关注下，刘岩提到，下半年线上线下选秀活动《唱战》，今年还要大力做，去年和MTV合作，打了个基础，今年可以扩大对传统音乐产链影响，商价值链开发空间会更大。</p>\r\n<p>\r\n	包括，刘岩还提到了&ldquo;广告库存&rdquo;，转型做社交视频后，六间房企付款广告已很少，但还有可挖空间，当一个主播直播房间有十万观众时，适当插播广告，都将有可能，用户体验也不会像传统视频那样强干扰，广告库存会释放出来，这将是未来可挖掘空间。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	再说下YY。YY去年上市后，大家从其财报里发现了一块新务：YY音乐，今年一季度这块收入1.168亿人民币，YY音乐其实就是类似六间房秀场在线演艺务，虽然做晚，用户规模不如六间房，但这块成长性很漂亮，给游戏等务也带来不错粘性。</p>\r\n<p>\r\n	不管是怎样叫法，叫社交视频也好，叫秀场也好，叫在线演艺，现在，这个领域竞争越来越激烈，早期公司要守住并扩大阵地，互联网新贵和巨头们，也要进来分一杯羹，闷声发大财阶段已过，未来，要真刀真枪拼实力了，到底怎么拼？核心肯定不是烧钱，过去那种拼资本，而是拼谁更懂用户，更懂如何玩转关系。</p>\r\n<p>\r\n	&nbsp;</p>', '互联网', '陈振烨', '钛媒体', 'recommend', '2013-07-25'),
	(97, '易观智库：百度搜索份额连续5季度保持78.6%', 'upload/images/1374735547081.jpg', '<div class="zw-l_z_2wzbt">\r\n	<div class="zw-l_z_2wztp_a">\r\n		<div class="TRS_Editor">\r\n			<p>\r\n				　　根据易观智库EnfoDesk产数据库发布《2013年第2季度中国搜索引擎市场季度监测》数据显示，2013年第2季度中国搜索引擎运营商市场规模为93.8亿，在未含渠道收入中国搜索引擎运营商市场收入份额中，百度占到78.6%，谷歌中国占到14.2%，搜狗占到3.6%，搜搜占1.4%。</p>\r\n			<p>\r\n				　　2013年第2季度，在含渠道收入中国搜索引擎运营商市场收入份额中，百度占到77.0%，谷歌中国占到12.3%，搜狗占到5.5%，搜搜占到2.1%。</p>\r\n			<p align="center">\r\n				<img alt="易观智库：百度搜索份额连续5季度保持78.6%" oldsrc="W020130725322425642255.jpg" src="http://www.youth.cn/mscj/sh/jdxw/201307/W020130725322425642255.jpg" /></p>\r\n			<p>\r\n				　　EnfoDesk易观智库分析认为，2013年第2季度中国搜索引擎市场收入份额主要呈现以下特征：</p>\r\n			<p>\r\n				　　百度保持中国搜索引擎运营商市场收入领先地位。关键字营销仍然是广告主青睐营销方式，而百度在关键字领域仍然受到市场尊重，成为广告主投放关键字广告首选。由于百度媒体优势集中，较多采取直销模式，所以百度含渠道收入市场份额略低于不含渠道收入市场份额。</p>\r\n			<p>\r\n				　　谷歌中国在市场收入份额中仍具备优势。主要由于谷歌中国通过为广告主提供海外营销通路而获得稳定市场收入增长。然而产内激烈竞争使得谷歌中国份额逐渐被瓜分，优势不断缩小。如果谷歌中国不能对中国地区采取针对性改善措施，谷歌市场份额将会进一步缩小。</p>\r\n			<p>\r\n				　　搜狗凭借&ldquo;三箭齐发&rdquo;战略保持稳定市场收入份额。2013年第2季度，搜狗PC端保持了输入法+浏览器+搜索流量输送与商变现良性转化。围绕用户输入信息、搜索信息、获得信息行为路径和上网场景，结合了用户需求和目，以&ldquo;海量+精准&rdquo;场景营销获得广告主青睐。</p>\r\n			<p>\r\n				　　此外，渠道优惠成为搜狗、搜搜等厂商分羹搜索市场重要手段。除去直销方式外，渠道销售是搜索引擎厂商获得广告主预算重要方式，利用渠道优惠政策吸引代理商，进而获得更多广告主青睐，市场份额快速增长。</p>\r\n		</div>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '互联网', '', '中国青年网', 'recommend', '2013-07-25'),
	(98, '四大无奈下，草根还要不要进入移动互联网创？', 'upload/images/1374735675543.jpg', '<p>\r\n	&nbsp;&nbsp;&nbsp;&nbsp;移动互联网最终趋势是什么？先认清创环境现状及艰辛：用户上网行为仍没改变；地方网站和论坛仍是主要营销方式；地方城市电商仍以B2C为主；地方城市创群体对移动互联网不感冒。</p>\r\n<p>\r\n	&ldquo;<span class="wp_keywordlink_affiliate"><a href="http://www.tmtpost.com/tag/mobile-internet" target="_blank" title="查看 移动互联 中全部文章">移动互联</a></span>网&rdquo; 这个概念成熟于2010年，而此时仍只是一个概念而已。笔者第一次使用手机上网是在2007年高考过后，使用&ldquo;移动梦网&rdquo;阅读到了电脑以外网络资讯。 07年背着破背包到厦门求学，也第一次用手机装了一个Java通用版QQ。此时&ldquo;移动互联网&rdquo;仍只是一个同学们在教室聊QQ唯一途径而已。</p>\r\n<p>\r\n	到现在， 内朋友聊起移动互联网，也只停留在用手机看看新闻聊聊微信玩玩游戏。</p>\r\n<p>\r\n	毕后留在厦门工作，老家同学问起我职，回答移动互联网，朋友会问，那是干啥？只能回答说，搞手机游戏开发。厦门是一个二线城市，之所 以有这样移动互联网氛围，主要是厦门软件园有相当成熟移动互联网公司和很多优秀手机游戏开发商，如果你还不清楚，4399和美图秀秀就在这里。</p>\r\n<p>\r\n	但 是，即使这样，厦门移动互联网氛围仍不够浓厚。说一个小插曲，昨天走在4399楼下，听后面两个MM在讲话，其中一个MM问另外一个：这个4399是不 是就是网上那个玩游戏。<strong>那么，移动互联网，它最终趋势是怎样？它能代替传统互联网吗？草根要不要进入移动互联网<span class="wp_keywordlink_affiliate"><a href="http://www.tmtpost.com/tag/chuangye" target="_blank" title="查看 创 中全部文章">创</a></span>？先认清现状及艰辛。</strong></p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>一，用户上网行为仍没改变</strong></p>\r\n<p>\r\n	笔者虽然从事移动互联网行，但主要工作和生活平台仍是传统互联网。在厦门，找工作租房子仍会上分类信息网或者本地门户社区；主要上网方式仍 是家里或者公司电脑，网吧生意也不见衰退；朋友间沟通仍以QQ和短信为主，当然，也有微信和陌陌。</p>\r\n<p>\r\n	但是，什么约炮，那都是浮云，看一看笑一笑就过 了。虽然说现在中国已有5亿多手机网民，绝大多数是智能手机用户。但是，这5亿当中有多少比例是用手机上网？就算有大部分用户使用手机上网，那又有谁能撬动这些人利用移动互联网进行消费和创？</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>二，地方网站和论坛仍是主要营销方式</strong></p>\r\n<p>\r\n	如果你问一个婚纱摄影老板怎样在本地推广商活动，他会回答你去某某社区买个广告位。而当你跟他说可以试试微信营销时候，他会回答你微信主要是 聊天，还成不了营销气候。我们可以说他们不懂这行，但是别忘了，移动互联网就得接地气，而接地气，就离不开这些&ldquo;不懂这行&rdquo;群体。说一个笑话：我一 同学开发了一个本地消费交友移动应用。</p>\r\n<p>\r\n	有一天他一个市场推广人员去某餐饮店和老板谈，问老板：你们这里需要客户端吗？老板回答他，不忙时候不用，忙 时候会叫客户自己端。笔者前些天和一个教育培训机构管理层聊天，当我提及用微信搞O2O是一个不错营销方式时候。</p>\r\n<p>\r\n	他问我，微信公众号要不要钱？和某某社区置顶帖比起来哪个效果好？我想，这可能就是大部分人用微信搞自媒体而不搞O2O，地方论坛站长越来越多原因吧。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>三，地方城市电商仍以B2C为主</strong></p>\r\n<p>\r\n	如果你在厦门软件园做个&ldquo;什么是电子商务&rdquo;调查，超过80%人会回答你：去淘宝天猫买衣服鞋子，可能会有小部分人上网买数码电器，这就是我们概念里电子商务。如果你问他/她听没听过O2O？知不知道什么是移动支付？啥玩意儿？没听过！虽然软件园附近有几家提供所谓微信订餐，但是我们仍觉得打电话订餐比较方便。如果O2O真有那么牛，就不用出现海底捞长队和大热天满世界跑求租者。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<strong>四，地方城市创群体对移动互联网不感冒</strong></p>\r\n<p>\r\n	来厦门读书人一般都留在厦门，要么上班，要么创。而更多互联网创者建个网站，做好SEO，举办线下活动，收取会员费，获得商家赞助。没有几 个敢放手开发一个APP或者经营一个本地服务微信号，对于这些人来说，这太不靠谱了。当然也有这样人，但几乎处在亏损状态。</p>\r\n<p>\r\n	而传统互联网比移动互联 网有着更多优势，成本少、技术门槛低、覆盖面广、收入渠道多。一个虚拟主机加一个域名一年不会超过1000块，找个开源程序买个模版就是一个网站，论坛 发帖QQ群发就是SEO，叫几个人拉个横幅就是线下活动，挂些联盟广告叫人点点就有收入。真正在搞移动互联网是那些有钱主和有经验和实力大公司。</p>\r\n<p>\r\n	蔡文胜说移动互联网要接地气， 而我认为，接地气是需要成本和勇气，这样成本和勇气并不是一般人能够拥有。移动互联网是一个被炒热概念，特别是微信。但实际上，一个普通互联网从 者转到移动互联网，仍是一头雾水。真正能搞得动移动互联网，依旧是那些在互联网站住了脚大企。如果说传统互联网是草根战场，而移动互联网就是草 根墓地。最后还想说一句，移动互联网水很深，入行需谨慎。（本文首发<span class="wp_keywordlink"><a href="http://www.tmtpost.com/" target="_blank" title="钛媒体">钛媒体</a></span>）</p>', '通信', '伊甸网', '钛媒体', 'recommend', '2013-07-25'),
	(99, '家居市场渐入整合期', 'upload/images/1392341279171.jpg', '<p>\r\n	<font 12px="" style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　业内普遍认为，红星美凯龙吞下吉盛伟邦或许意味着行业洗牌大幕已徐徐拉开，更多的并购整合将出现</font><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　导报记者 曹凤芹 济南报道</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　12日，红星美凯龙正式确认将全资收购行业排名第三的吉盛伟邦。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　红星美凯龙相关负责人表示，本次收购是出于长期战略发展的考虑。业内普遍认为，红星美凯龙吞下吉盛伟邦或许意味着行业洗牌大幕已徐徐拉开，更多的并购整合将出现。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　山东省家具行业协会秘书长韩庆生13日接受经济导报记者采访时表示，资源整合是大势所趋，行业集中度提高，也有利于资源的有效配置。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　重续前缘</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　红星美凯龙对吉盛伟邦的收购并不是一帆风顺，早在2009年底，两大巨头就曾传出&ldquo;深度合作&rdquo;的消息。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　据当时的消息称，双方已经签署初步意向，具体的交易将以现金和股权的形式进行，双方将保留各自的品牌，也将维持当前的定位不变。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　此后关于红星美凯龙与吉盛伟邦将携手整合的消息不断传出，却没有实质性进展的内容传出。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　据悉，此次收购完成后，红星美凯龙将继续保留&ldquo;吉盛伟邦&rdquo;品牌，同时，吉盛伟邦的管理将实行本地化，原有的团队和人才保留融合。有媒体报道称，收购资金将超过20亿元，不过，对于支付的细节，目前尚未得知。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　对于这项并购案，韩庆生认为，并购是考虑到将来双方都受益。红星美凯龙的市场地位得以稳固，资源更加丰富，未来也将通过资源整合实现更好的发展；而吉盛伟邦也将借助红星美凯龙的资源发展，而非单枪匹马应对各方竞争。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　事实上，在家居行业，企业之间联手合作近来动作频频。2013年4月，顾家和欧亚达两家企业在山东省投资的第一家县级城市综合体项目在临邑开工，两企业将斥资百亿元在三、四级市场打造100家大型连锁商贸综合平台。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　2013年末，喜临门、宜华木业、华日家具宣布三方签署战略合作框架协议，联手合作。今年年初，居然之家则收编了此前破产的东方家园的部分门店。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　此次红星美凯龙对吉盛伟邦的收购，亦让业界看到了行业整合、集中度提高的大势所趋。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　中国建筑材料流通协会常务副会长兼秘书长秦占学接受导报记者采访时表示，建材家居卖场因为过剩而导致竞争惨烈，利润下降。&ldquo;在这一过程中，一部分小卖场被淘汰，而大卖场则进一步乘胜追击，抢占市场。&rdquo;</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　为上市铺路？</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　红星美凯龙被誉为国内家居行业第一流通品牌，截至目前已经在全国90多个城市开业了125家商场。与吉盛伟邦达成协议，可以使红星美凯龙进行横向整合，做大规模巩固其霸主地位。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　虽然此次并购规模创下行业之最，但却发生在家居卖场总体已出现过剩、运营成本高企、电子商务冲击等不利状况下。</span><br />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　有猜测称，选择在这个时点披露对吉盛的收购，是红星美凯龙希望对上市作出一定影响，提高市盈率。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　2013年12月，证监会在官网上公布了首次公开发行股票(IPO)企业的审核名单和审核进程表，红星美凯龙在列，这意味着为上市筹备多年的红星美凯龙进入了实质性的申报阶段。</span><br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: none; text-align: justify; font: 14px/24px 宋体, sans-serif; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　但红星美凯龙官方的说法则认为，无论从资产规模、利润规模还是门店数量来说，该交易对红星美凯龙都不构成重大影响。其主要目的是希望进一步强化红星美凯龙在家居流通行业领导品牌的地位，利用吉盛伟邦已经积累的品牌影响力和市场口碑，进一步扩大市场份额。</span></p>', '家具', '曹凤芹', '大众网-经济导报', 'recommend', '2014-02-14'),
	(100, '谷歌富士康或携手造机器人', '', '<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　楚天金报讯 据《北京晨报》报道 未来iPhone将由谷歌与富士康合作开发的机器人组装，这或许不再是天方夜谭。近日，有媒体报道称，富士康已经秘密与谷歌进行合作，研发用于产品组装的机器人。自消息传出后，富士康旗下上市公司富智康股价连续上涨。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　从2012年开始，富士康董事长郭台铭就频频表达出对于打造机器人生产王国的浓厚兴趣，并推出&ldquo;百万机器人&rdquo;计划。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　有消息称，负责与富士康合作的是谷歌的工程副总裁，有Android之父之称的安迪&middot;罗宾。为了加速机器人在产品线上的部署，富士康董事长郭台铭最近与罗宾在台北会面，谈论了很多新型机器人技术。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　随着人力成本不断上涨，机器人代工已经成为一种潮流。郭台铭曾表示，到2014年要装配100万台机械臂，要在5-10年内看到首批完全自动化的工厂，并在数年内通过自动化消除简单重复性的工序。</p>', '机械', '', '荆楚网-楚天金报', '', '2014-02-14'),
	(101, '成都市新筑路桥机械股份有限公司关于公司及相关主体承诺履行情况的公告', '', '<p>\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　本公司及董事会全体成员保证公告内容真实、准确、完整，不存在虚假记载、误导性陈述或重大遗漏。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　成都市新筑路桥机械股份有限公司（以下简称&ldquo;公司&rdquo;或&ldquo;</span><a href="http://q.stock.sohu.com/cn/002480/index.shtml" style="border-left-width: 0px; text-decoration: none; border-right-width: 0px; white-space: normal; border-bottom-width: 0px; text-transform: none; color: rgb(0,85,153); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; padding-left: 0px; margin: 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; border-top-width: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; border-image: initial" target="_blank">新筑股份</a><span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">&rdquo;）根据中国证券监督管理委员会四川监管局《关于进一步做好上市公司实际控制人、股东、关联方、收购<span class="Apple-converted-space">&nbsp;</span></span></p>\r\n<div class="muLink" style="border-left-width: 0px; border-right-width: 0px; width: 250px; white-space: normal; border-bottom-width: 0px; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: right; padding-bottom: 0px; padding-top: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; padding-left: 0px; margin: 10px 0px 20px 24px; letter-spacing: normal; orphans: 2; widows: 2; display: inline; padding-right: 0px; border-top-width: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; border-image: initial">\r\n	<div class="stockTrends" style="border-left-width: 0px; font-size: 14px; border-right-width: 0px; border-bottom-width: 0px; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto 8px; padding-right: 0px; border-top-width: 0px; border-image: initial">\r\n		<div class="line" style="border-left-width: 0px; font-size: 0px; height: 1px; border-right-width: 0px; width: 250px; background-image: url(http://news.sohu.com/upload/article/2012/images/bg_line.gif); border-bottom-width: 0px; overflow-x: hidden; overflow-y: hidden; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; clear: both; margin: 0px auto; padding-right: 0px; border-top-width: 0px; border-image: initial; background-origin: initial; background-clip: initial">\r\n			&nbsp;</div>\r\n		<h3 style="border-left-width: 0px; font-size: 12px; border-right-width: 0px; border-bottom-width: 0px; font-weight: bold; padding-bottom: 0px; text-align: left; padding-top: 0px; padding-left: 0px; margin: 9px auto 0px; line-height: 26px; padding-right: 0px; border-top-width: 0px; text-indent: 6px; border-image: initial">\r\n			相关公司股票走势</h3>\r\n		<a href="http://q.stock.sohu.com/cn/002480/index.shtml" id="related_stock_img" style="border-left-width: 0px; font-size: 12px; text-decoration: none; border-right-width: 0px; border-bottom-width: 0px; color: rgb(0,85,153); padding-bottom: 0px; text-align: center; padding-top: 0px; padding-left: 0px; margin: 0px auto; display: block; padding-right: 0px; border-top-width: 0px; border-image: initial" target="blank"><img src="http://d1.biz.itc.cn/q/cn/480/002480/tline2.png?1392341606697" style="border-left-width: 0px; font-size: 0px; border-right-width: 0px; border-bottom-width: 0px; color: transparent; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px auto; padding-right: 0px; border-top-width: 0px; border-image: initial" /></a>\r\n		<ul class="menuTab" id="related_stock" style="border-left-width: 0px; list-style-type: none; font-size: 12px; border-right-width: 0px; width: 218px; border-bottom-width: 0px; padding-bottom: 2px; padding-top: 0px; padding-left: 0px; margin: 0px auto 10px; padding-right: 0px; border-top-width: 0px; border-image: initial">\r\n			<li c="cn_002480" class="libg" style="border-left-width: 0px; font-size: 12px; height: 16px; font-family: Tahoma; border-right-width: 0px; border-bottom-width: 0px; overflow-x: hidden; overflow-y: hidden; position: relative; padding-bottom: 0px; text-align: right; padding-top: 4px; padding-left: 0px; clear: both; margin: 8px auto 0px; display: list-item; line-height: 16px; padding-right: 0px; border-top-width: 0px; background-color: rgb(234,241,248); border-image: initial; background-origin: initial; background-clip: initial">\r\n				<span class="tt" style="border-left-width: 0px; cursor: pointer; font-size: 12px; font-family: 宋体; border-right-width: 0px; width: 54px; border-bottom-width: 0px; float: left; padding-bottom: 0px; text-align: left; padding-top: 0px; padding-left: 0px; margin: 0px 7px 0px 5px; display: block; padding-right: 0px; border-top-width: 0px; border-image: initial"><a href="http://q.stock.sohu.com/cn/002480/index.shtml" style="border-left-width: 0px; font-size: 12px; text-decoration: none; border-right-width: 0px; border-bottom-width: 0px; color: rgb(0,85,153); padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px; border-top-width: 0px; border-image: initial" target="_blank" title="新筑股份">新筑股份</a></span><span class="gray" style="border-left-width: 0px; cursor: pointer; font-size: 12px; border-right-width: 0px; width: 49px; border-bottom-width: 0px; color: rgb(51,51,51); float: left; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; display: block; padding-right: 0px; border-top-width: 0px; border-image: initial">15.57</span><span class="red" style="border-left-width: 0px; cursor: pointer; font-size: 12px; border-right-width: 0px; width: 49px; border-bottom-width: 0px; color: rgb(255,0,0); float: left; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; display: block; padding-right: 0px; border-top-width: 0px; border-image: initial">+0.05</span><span class="red" style="border-left-width: 0px; cursor: pointer; font-size: 12px; border-right-width: 0px; width: 49px; border-bottom-width: 0px; color: rgb(255,0,0); float: left; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; display: block; padding-right: 0px; border-top-width: 0px; border-image: initial">0.32%</span></li>\r\n		</ul>\r\n		<div class="line" style="border-left-width: 0px; font-size: 0px; height: 1px; border-right-width: 0px; width: 250px; background-image: url(http://news.sohu.com/upload/article/2012/images/bg_line.gif); border-bottom-width: 0px; overflow-x: hidden; overflow-y: hidden; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; clear: both; margin: 0px auto; padding-right: 0px; border-top-width: 0px; border-image: initial; background-origin: initial; background-clip: initial">\r\n			&nbsp;</div>\r\n	</div>\r\n</div>\r\n<p>\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">人以及上市公司承诺及履行有关工作的通知》(川证监上市[2014]8号)要求，对公司实际控制人、股东、关联方以及公司承诺履行情况进行了专项核查，截止2013年末尚未履行完毕的承诺履行情况如下：</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　一、关于股份锁定的承诺</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　公司董事、监事、高级管理人员承诺：&ldquo;在其任职期间每年转让的股份不得超过其所持有发行人股份总数的25%；离职后半年内，不得转让其所持有的发行人股份，离职六个月后的十二个月内通过证券交易所挂牌交易出售发行人股票数量占其所持有公司股票总数（包括有限售条件和无限售条件的股份）的比例不超过50%；&rdquo;</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺期限：任职董事、监事、高级管理人员期间、离职后半年内；</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺履行情况：正在履行未超期。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　二、关于同业竞争的承诺</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　（一）控股股东及其一致行动人关于避免同业竞争的承诺</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　为避免同业竞争、减少关联交易，公司控股股东新筑投资集团有限公司（以下简称&ldquo;新筑投资&rdquo;）及其一致行动人新津聚英科技发展有限公司于2009年11月18日向新筑股份出具了《避免同业竞争的承诺函》，控股股东一致行动人新津新联投资管理中心（普通合伙）于2013年5月9日向新筑股份出具了《避免同业竞争的承诺函》，内容如下：</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　1、本企业及本企业高级管理人员及本企业下属企业目前没有在中国境内或境外单独或与其他自然人、法人、合伙企业或组织，以任何形式直接或间接从事或参与任何对新筑股份构成竞争的业务及活动或拥有与新筑股份存在竞争关系的任何经济实体、机构、经济组织的权益，或在该经济实体、机构、经济组织中担任高级管理人员或核心技术人员。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　2、本企业保证将采取合法及有效的措施，促使本企业、本企业拥有控制权的其他公司、企业与其他经济组织及本企业的关联企业，不以任何形式直接或间接从事与新筑股份相同或相似的、对新筑股份业务构成或可能构成竞争的业务，并且保证不进行其他任何损害新筑股份及其他股东合法权益的活动。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　3、本企业将严格遵守《公司法》、《证券法》、《上市公司治理准则》等规定，避免与新筑股份发生关联交易，自觉维护新筑股份及其全体股东的利益，将不利用本企业与新筑股份的关联关系在关联交易中谋取不正当利益。如新筑股份必须与本企业控制的企业进行其他关联交易，则本企业承诺，均严格履行相关法律程序，遵照市场公平交易的原则进行，将促使交易的价格、相关协议条款和交易条件公平合理，不会要求新筑股份给予与第三人的条件相比更优惠的条件。本企业愿意承担因违反上述承诺而给新筑股份造成的全部经济损失。本承诺持续有效且不可变更或撤销。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺期限：长期有效；</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺履行情况：正在履行未超期。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　（二）实际控制人关于避免同业竞争的承诺</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　为避免同业竞争、减少关联交易，公司实际控制人黄志明先生于2009年11月18日向新筑股份出具了《避免同业竞争的承诺函》，内容如下：</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　1、本人目前没有在中国境内或境外单独或与其他自然人、法人、合伙企业或组织，以任何形式直接或间接从事或参与任何对新筑股份构成竞争的业务及活动或拥有与新筑股份存在竞争关系的任何经济实体、机构、经济组织的权益，或在该经济实体、机构、经济组织中担任高级管理人员或核心技术人员。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　2、本人保证将采取合法及有效的措施，促使本人、本人拥有控制权的其他公司、企业与其他经济组织及本人的关联企业，不以任何形式直接或间接从事与新筑股份相同或相似的、对新筑股份业务构成或可能构成竞争的业务，并且保证不进行其他任何损害新筑股份及其他股东合法权益的活动。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　3、本人将严格遵守《公司法》、《证券法》、《上市公司治理准则》等规定，避免与新筑股份发生关联交易，自觉维护新筑股份及其全体股东的利益，将不利用本人与新筑股份的关联关系在关联交易中谋取不正当利益。如新筑股份必须与本人控制的企业进行其他关联交易，则本企业承诺，均严格履行相关法律程序，遵照市场公平交易的原则进行，将促使交易的价格、相关协议条款和交易条件公平合理，不会要求新筑股份给予与第三人的条件相比更优惠的条件。本人愿意承担因违反上述承诺而给新筑股份造成的全部经济损失。本承诺持续有效且不可变更或撤销。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺期限：长期有效；</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺履行情况：正在履行未超期。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　三、控股股东认购承诺</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　公司2013年拟非公开发行股票的发行对象为包括新筑投资在内不超过十名符合中国证监会规定的特定对象，其中，新筑投资承诺以现金方式按照与其他发行对象相同的认购价格认购本次非公开发行股份，认购金额不低于8,000万元，不超过10,000万元。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺期限：至公司2013年非公开发行股票认购期结束时止；</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺履行情况：正在履行未超期。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　四、其他方面的承诺</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　（一）2013年5月15日，公司2012年度股东大会审议通过了《关于将部分项目剩余募集资金及专户利息永久补充流动资金的议案》，同意将&ldquo;桥梁建筑抗震型功能部件系列产品技术改造项目&rdquo;与&ldquo;设立子公司实施桥梁功能部件精密坯件制造基地技术改造项目&rdquo; 专户剩余募集资金及利息共计16,170.46万元用于永久补充流动资金，并承诺使用剩余募集资金永久补充流动资金后十二个月内不进行证券投资等高风险投资。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺期限：十二个月；</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺履行情况：正在履行未超期。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　（二）2009年12月，控股股东新筑投资出具《承诺函》承诺：如果社会保险及住房公积金主管部门要求公司及子公司对以前年度的员工社会保险及住房公积金进行补缴，新筑投资将按主管部门核定的金额无偿代其补缴；如果因以前年度未缴纳社会保险或住房公积金而给公司及子公司带来任何其他费用支出和经济损失，新筑投资将无偿代其承担。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺期限：长期有效；</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　承诺履行情况：正在履行未超期。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　经核查，公司实际控制人、股东、关联方和公司不存在不符合《上市公司监管指引第4 号&mdash;&mdash;上市公司实际控制人、股东、关联方、收购人以及上市公司承诺及履行》要求的承诺；不存在超期未履行承诺的情况；公司实际控制人、股东、关联方以及公司的历年各项承诺均已及时履行。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　成都市新筑路桥机械股份有限公司</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　董事会</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　二?一四年二月十三日</span></p>', '机械', '', '中证网-中国证券报', '', '2014-02-14'),
	(102, '三星电子盛世危机：手机增长放缓 陷四面楚歌', '', '<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　受世界行情低迷，以及韩元升值导致的价格竞争力下滑影响，韩国主要企业2013财年(截至2013年12月期)业绩明显走低，作为韩国经济增长领军企业的三星电子也出现减速。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　据韩国银行(央行)统计，韩元2013年的平均汇率为1美元=1095韩元，较2012年升值了2.9%。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　支撑韩国经济发展的三星电子等企业前景令人担忧。三星电子的智能手机销售增长放缓，2013年10-12月期时隔2年合并营业利润首次出现下滑。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　三星遭全球各大厂商围攻</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　据韩国《亚洲经济》消息，三星电子2013年除北美地区外，在全球与苹果的市场占有率差距进一步拉大，稳坐全球智能手机冠军宝座。对此，各主要竞争对手摩拳擦掌，将矛头直指三星：联想日前从谷歌手中收购摩托罗拉，向着国际市场发起挑战；微软也在收购诺基亚后即将提出首款处女作，一场旷日持久的竞争势不可挡。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　据电子业界消息，苹果预计于今年推出的iPhone 6屏幕将扩大至4.7-5.5英寸，苹果创始人乔布斯曾表示，智能手机的屏幕不能太大，应在3-4英寸之间，方便单手操作，但随着近来大尺寸智能手机成为主流，三星推出的一系列屏幕在5-6英寸的智能手机获得巨大成功，苹果也不再固守乔布斯的这一理论。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　作为智能手机市场的后起之秀，联想在月29日收购了摩托罗拉，从而跃升至全球第三大智能手机生产商。有分析认为，联想29亿美元从谷歌手中收购摩托罗拉，实际上可以看成联想打进美国和欧洲市场所缴纳的&ldquo;入场费&rdquo;，希望借助摩托罗拉这一品牌价值将版图扩大至全球市场。一直以来，&ldquo;联想=低价&rdquo;这一固有观念根深蒂固，虽以量取胜但缺乏创新，此次联想收购摩托罗拉标志着抢切智能手机&ldquo;蛋糕&rdquo;的开端。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　据《华尔街日报》报道，即将被微软收购的诺基亚将于本月底在西班牙巴塞罗那举行的移动世界大会(MWC)上公开首款安卓智能手机，该款手机将针对新兴市场，虽影响力有限，但对于三星来说，也将面临市场份额被蚕食的威胁。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　盛世背后并不繁荣</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　对于三星而言，盛世的背后并非仅是繁荣景象。手机业务利润占比过大、软件与服务方面的短板、创新能力的不足，这些潜在的隐忧在三星的发展过程中也一直是如影随形。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　资本市场对三星在创新方面的能力也持有怀疑态度。素有&ldquo;模仿者&rdquo;之称的三星在创新方面并没有好名声。如今这个&ldquo;模仿者&rdquo;已攀上顶峰，而整个行业却陷入了创新困境。即使是一向以创新闻名的苹果都已是创新乏力。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　显然外界对于三星能否引领创新潮流以推动智能手机市场的增长也并不确定。与此同时，智能手机市场增速放缓的迹象已经显现。摩根大通此前发布的报告显示，未来几年，全球智能手机的用户数量将继续增长，但是智能手机销售的增速将开始放缓，有预测称2014年增速将下降到17%。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(67,67,67); word-spacing: 0px; text-align: left; font: 16px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　尤其是在高端市场趋近饱和的情况下，三星的智能手机业务只能加大向中低端市场的拓展的力度，这势必会使三星的利润受到影响。</p>', '电子', '', '中国网', '', '2014-02-14'),
	(103, '恒信五金汽配城 认筹金1万 封顶商铺火热咨询中', 'upload/images/1392342566656.png', '<div class="news_zy">\r\n	<p>\r\n		<span>摘要：</span>恒信五金汽配城，项目封顶商铺火热咨询中，租两年送一年，租四年送两年；2月11日起机电城、汽配城和沿街商铺开始认筹，认筹金为1万元。咨询电话：0311-89267222。</p>\r\n</div>\r\n<div id="news_content">\r\n	<p style="text-align: center; text-indent: 0px">\r\n		<img border="0" jquery1102026079641060200525="25" src="http://img.zhijia.com/sjz/a/2014/0214/1392339423978.jpg" /></p>\r\n	<p style="text-align: center">\r\n		<a href="http://house.zhijia.com/hengxinwujinqipeicheng.html" target="_blank">恒信五金汽配城</a>实景图</p>\r\n	<div id="surround_adb" style="display: block">\r\n		&nbsp;</div>\r\n	<p>\r\n		恒信五金汽配城，项目封顶商铺火热咨询中，租两年送一年，租四年送两年；2月11日起机电城、汽配城和沿街商铺开始认筹，认筹金为1万元。咨询电话：0311-89267222。</p>\r\n	<p>\r\n		河北绿岛物流园规划占地946亩，是河北省重点示范工程，石家庄市重点建设工程。恒信五金汽配城整合汽车后市场服务全产业链，打造销售、物流和仓储一站式 专业汽车配件集散基地，预留3000余个停车位，主路宽20米，内街宽15米以提升商家和买家园内便利交通。</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '五金', '', '置家网', 'recommend', '2014-02-14'),
	(104, '我国五金气动工具市场营销现状分析', 'upload/images/1392344154500.png', '<div class="ArtM Pr30" id="Content">\r\n	　　五金气动工具的用途与其他电动工具一样，甚至有过之而无不及，它机身小七玲珑，寿命长，安全性高，且节省能源。就我国气动工具市场整体而言，它的品种规格都较为齐全，如有风凿、枪钻、抛光机、冲击扳手等，但因在它的市场价格要比普通的电动工具高很多，这是造成气动工具没有被普及运用的主要原因之一。<br />\r\n	<br />\r\n	　　气动工具前景可观，主要表现在三方面：1.气动工具工作能力强，与普通电动工具相比更适合长时间的工作。2.气动工具环境适应能力强。气动工具耐水性强，不会产生电火花，可以适应各种不良或恶劣的环境。3.气动工具维护成本低。气动工具采用的是空压管路设备，不用像电动工具那样更换零部件。<br />\r\n	<br />\r\n	　　我国启动制造业和拨动技术起步较晚，经过了十多年也已有了很大的发展，气动工具具有高质量、高寿命、高速度、高输出力和高精度等特点，被很快推广应用到各个工业部门，并发挥着显着的效益。&ldquo;目前，气动工具已被用于装配业、机械业、动输业、滑板车、电动自行车、摩托车装配、汽车修理厂及一些流水线作业的企业或厂家当中。&rdquo;国际模具及五金塑胶产业供应商协会秘书长罗百辉调研显示，随着压延、拉拔、铸造、机械加工、清洗支毛刺、装配和检测等技术水平的提高，气动元件的外观和内在质量也将不断提高。工业陶瓷、高性能软磁铁、塑封新材料已在新产品上应用，而今后的新材料的应用也将会越来越多。<br />\r\n	<br />\r\n	　　随着越来越多的经营商向品牌化经营路线方向迈进，国外的一些知名产品也被纷纷引进。为满足不同消费者的市场需求，气动工具正向以下几方面方向发展：1.机电一体化方向。为了精确达到预先设定的目标，需采用气、电信号之间转换;2.精密化方向。为使气缸定位更回精确，使用传感器、比例阀等实现精密反馈控制;3.组合化、智能化放向。在物料搬运过程中，已经使用了气缸、摆动气缸和真空吸盘的组合体。而移动小物品是将导向器的两只气缸分别按x、y轴组合而成，还配有电磁阀、程控器，结构紧凑，占用空间小。</div>\r\n<p>\r\n	&nbsp;</p>', '五金', '', '中金在线', 'recommend', '2014-02-14'),
	(105, '元宵节后塑料将现中短期反弹', '', '<p>\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　受春节期间石化装置正常运行，而下游需求则受到长假的影响，石化库存呈较大幅度增长，供需矛盾加剧。石化企业持续下调出厂价格以缓解库存压力，期价在跌破前期震荡区间后加速下跌。不过，考虑到春节效应影响的时间和空间有限，元宵节后下游企业将加速回归市场，再加上成本支撑，短期内塑料期价下跌空间有限，预计10650元/吨附近企稳后出现反弹的概率较大，不过长期的回调趋势将不变。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　节后PE库存消耗将比节前顺畅。尽管春节长假期间石化库存明显增长，但只有8天的量，且节前石化库存已下降了不少，其中华东线性库存降至2013年来的极低水平，节后石化持续让利销售，再加上元宵节后大部分下游企业将陆续归市，备战3月份的地膜消费旺季，假期效应的利空影响也将随之消失。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　后市PE装置检修将增多。进入2月份后，中原石化26万吨LLDPE装置将进入长达1.5个月的检修，后面3、5、6月份都有一些大型PE装置将进入检修状态，且通常二季度都是装置检修的高峰期，因此整个上半年而言，随着PE装置检修的逐步增多，供应压力将进一步缓解。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　社会库存尚未存在压力。截至1月31日，我国PE社会库存环比增长5.86%，但同比仅增长0.77%。自2012年以来，我国PE社会库存量就持续下降，直到2013年末才出现企稳回升的迹象，目前PE社会库存量仍处于历史低位，尽管目前石化存在一定的库存压力，但下游库存低位将限制价格的下跌空间。</span><br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: none; font: 14px/26px 宋体, simsun, sans-serif, Arial; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　成本支撑继续存在。决定塑料生产成本高低的主要是布伦特原油、石脑油和乙烯价格的涨跌。而对于布伦特原油价格而言，尽管非OPEC原油产量增速较快，且伊朗和利比亚原油出口将增加，全球供应压力增加，但美国经济复苏较为强劲，经济数据持续好转，欧元区经济也在缓慢回升，近期美国能源信息署和欧佩克均上调石油需求预测，再加上美国新建原油管道的开通，原油库存消耗也在加速，从而导致国际油价继续维持在高位，目前的石化成本在10750元/吨以上，对塑料期价有一定支撑。尽管近期亚洲地区乙烯价格高位回落，但随着亚洲地区烯烃裂解装置的增加，乙烯货源供应将再次偏紧，乙烯价格仍将维持高位，这也将持续给后市塑料期价带来支撑。</span></p>', '塑料', '', '中证网-中国证券报', '', '2014-02-14'),
	(106, '响水生态化工园区严格项目准入打造绿色园区', '', '<p>\r\n	<span style="white-space: normal; text-transform: none; color: rgb(0,0,0); word-spacing: 0px; float: none; font: 14px/25px 宋体; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　近年来，响水生态化工园区牢固树立&ldquo;环境是第一资源，环境更是生产力&rdquo;的理念，严格项目准入，严守环保底线，凡入园项目必须符合国家产业结构调整的要求，必须采用清洁生产技术及先进的技术装备，对新建和改扩建项目实施严格的行业准入管理，做到决不以牺牲环境为代价换取一时的经济发展，决不在产业转移中接受污染转移，决不产生新的污染源，大力招引投资规模大、科技含量高、资源消耗低、环境污染小、带动能力强的大项目、好项目、产业链项目，全面构建苏北地区同类园区中&ldquo;功能配套最全、转型升级最快、投资环境最优、生态改善最好&rdquo;的绿色园区。</span></p>', '化工', '余自然 潘正伟 郭建军 周东年', '新华日报', '', '2014-02-14'),
	(107, '基础化工13年报前瞻:行业盈利底部震荡,染料、氨纶环比有望持续改善', '', '<div accesskey="3" class="bd" tabindex="-1">\r\n	<div id="sczy">\r\n		&nbsp;&nbsp;&nbsp;&nbsp;投资要点:<br />\r\n		&nbsp;&nbsp;&nbsp;&nbsp;预计2013年度基础化工整体净利润将同比小幅下滑。根据我们跟踪的40家主流基础化工公司2013年盈利预测,预计2013年加权平均EPS0.38元,同比下滑7%。下滑幅度较大的子行业主要是化纤、化肥、玻纤等;同比增幅较大的子行业主要是染料、MDI、农药。<br />\r\n		&nbsp;&nbsp;&nbsp;&nbsp;染料价格仍在上行通道,未来业绩有望继续环比增长。我们预计<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600352.shtml" target="_blank">浙江龙盛</a></span>和<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002440.shtml" target="_blank">闰土股份</a></span>2013年EPS&nbsp;分别为0.87元和1.11元,分别同比增长59%和180%;预计4Q13EPS&nbsp;分别为0.27元和0.47元,环比增长14%和57%。14年以来,分散染料价格仍在上行通道,我们预计3、4月的织造旺季仍将刺激染料价格继续上行。市场担心高毛利导致部分同行复工和新进入者,明显低估了染料龙头&ldquo;产业链+环保+专利+市场&rdquo;四位一体的综合壁垒和现实的环保压力。<br />\r\n		&nbsp;&nbsp;&nbsp;&nbsp;小厂开机率上升导致草甘膦企业业绩4Q13环比不达预期,其他农药股4Q13相对平稳。受小厂开机率上升带动价格下行影响,我们预计草甘膦相关个股<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600389.shtml" target="_blank">江山股份</a></span>、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600596.shtml" target="_blank">新安股份</a></span>4Q13业绩环比降分别下滑36%、38%。其他农药股,<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600486.shtml" target="_blank">扬农化工</a></span>预计2013EPS&nbsp;为2.24元(YoY+98%,QoQ+77%),<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002391.shtml" target="_blank">长青股份</a></span>13EPS0.93元(&nbsp;YoY+22%,QoQ+6%)。<br />\r\n		&nbsp;&nbsp;&nbsp;&nbsp;<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600309.shtml" target="_blank">万华化学</a></span>、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600527.shtml" target="_blank">江南高纤</a></span>、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002108.shtml" target="_blank">沧州明珠</a></span>、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/601058.shtml" target="_blank">赛轮股份</a></span>等&ldquo;白马股&rdquo;继续保持稳定增长。预计2013年万华化学EPS1.35元(yoy+24%,QoQ-27%),江南高纤EPS0.34元(yoy+24%,QoQ+87%),沧州明珠0.45元(yoy+26%,QoQ+2%),赛轮股份0.57元(yoy+60%,QoQ-16%)。<br />\r\n		&nbsp;&nbsp;&nbsp;&nbsp;其他公司中,预计4Q&nbsp;业绩环比大幅改善的为:<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600096.shtml" target="_blank">云天化</a></span>13EPS0.46元(非经常性损益)、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002539.shtml" target="_blank">新都化工</a></span>0.30元、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/603077.shtml" target="_blank">和邦股份</a></span>0.15元;预计4Q13亏损的为:<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/000422.shtml" target="_blank">湖北宜化</a></span>13EPS0.10元、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600141.shtml" target="_blank">兴发集团</a></span>0.18元、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600075.shtml" target="_blank">新疆天业</a></span>-0.48元、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/000822.shtml" target="_blank">山东海化</a></span>-1.26元、<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/000707.shtml" target="_blank">双环科技</a></span>-1.40元。<br />\r\n		&nbsp;&nbsp;&nbsp;&nbsp;投资建议:染料行业14年以来发货量较好,1Q14价格和盈利仍有上行基础。周期反转类建议持续跟踪氨纶、玻纤的供需数据。成长类推荐持续有新产品推出、正从中间体向新材料转型的公司<span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002411.shtml" target="_blank">九九久</a></span>,以及14-15年新产能陆续达产的长青股份。建议增持业绩持续增长、估值较低的万华化学、扬农化工、江南高纤。\r\n		<div id="tipsWBzf" style="cursor: pointer; text-decoration: none; height: 22px; width: 59px; position: absolute; left: 230px; z-index: 899; top: 521px; visibility: visible">\r\n			&nbsp;</div>\r\n	</div>\r\n	<span style="height: 0px; width: 0px; overflow: hidden; font: 0px/0 Arial; display: block">正文已结束，您可以按alt+4进行评论</span></div>\r\n<p>\r\n	&nbsp;</p>', '化工', '', '申银万国证券', '', '2014-02-14'),
	(108, '偷排化工废水近18吨 致近百学生身体不适 广东茂名污染案10嫌犯落网', '', '<div checkedbycsshelper="true" class="otitle">\r\n	原标题：偷排化工废水近18吨 致近百学生身体不适 广东茂名污染案10嫌犯落网</div>\r\n<p checkedbycsshelper="true">\r\n	　　<strong checkedbycsshelper="true">中国环境报报综合报道</strong>广东茂名警方2月12日发布消息称，2月11日20时许，茂南区公馆镇重大环境污染案3名被通缉疑犯归案。至此，此案的10名犯罪嫌疑人全部落网。</p>\r\n<p checkedbycsshelper="true">\r\n	　　1月9日23时许，茂南区公馆镇白沙河段发生一起重大环境污染案，茂名市五中及公馆镇一中共96名学生怀疑吸入刺激性不明气体，出现头晕、呕吐、发烧等症状，先后被送往医院观察治疗。经公安机关排查污染源及环保部门确认，事件是当地一间汽车维修厂非法偷排化工废水所致。</p>\r\n<p checkedbycsshelper="true">\r\n	　　据了解，广西北流市清湾镇新发建筑材料厂老板黄某新，私下从重庆拉回废油，违规炼制沥青，将非法炼制沥青产生的有毒化工废液拉到茂名市茂南信诺汽车维修厂，由维修厂老板吴某新组织车辆，利用自己的厂内暗管向公馆镇白沙河段偷排有毒化工废液达17.8吨。</p>\r\n<p checkedbycsshelper="true">\r\n	　　案发后，茂名市、茂南区两级公安机关成立联合专案组，相继抓获黄某新等7名犯罪嫌疑人，并在有关媒体上发布犯罪嫌疑人吴某新等3人的通缉令。</p>\r\n<p checkedbycsshelper="true">\r\n	　　经茂名和广西壮族自治区柳州市两地警方协同侦查，最终确定信诺汽车维修厂老板吴某新和运输车辆车主江某、江某龙等3名嫌疑人的藏匿之处。</p>\r\n<p checkedbycsshelper="true">\r\n	　　2月11日，茂名、柳州两地警方在融安县境内广西三江至柳州高速公路项目部某工地将吴某新等3人抓获。</p>', '化工', '', '环境保护部网站', '', '2014-02-14'),
	(109, '全球医药经济维持弱增长格局 出口增速下行', '', '<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="white-space: normal; text-transform: none; color: rgb(102,102,102); word-spacing: 0px; float: none; text-align: left; font: 14px/26px Verdana; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(249,249,249); text-indent: 24px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">核心提示：对比近年数据发现，医药进口在经历了2011年的井喷式增长之后，近两年的增速进入相对平稳的轨道。2013年，我国进出口规模虽然均超过上年水平，但出口增速有所下降。</span></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　2月10日，本报记者从2014年医药国际贸易形势发布会上获悉，2013年我国医药保健品进出口额达896.93亿美元，同比增长10.27%。其中，出口511.80亿美元，增长6.84%，进口385.13亿美元，增长15.17%，对外贸易顺差126.66亿美元，同比下降逾12%。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　&ldquo;未来一年中，医药进出口增加预计维持在10%左右，2014年，我国医药进出口总额应向千亿美元大关挺进。&rdquo;中国医药保健品进出口商会副会长许铭表示。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<strong style="padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px">出口增速下行</strong></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　对比近年数据发现，医药进口在经历了2011年的井喷式增长之后，近两年的增速进入相对平稳的轨道。2013年，我国进出口规模虽然均超过上年水平，但出口增速有所下降。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　以原料药为例，2013年，我国原料药出口235.98亿美元，占我国医药保健品出口总额的46.27%。实际上，自2012年第四季度以来，我国大宗原料药单季度出口额同比连续出现负增长，且幅度不断拉大，2013年第三季度同比下降9.52%，为历史最大降幅。专家预测，大宗原料药出口风光不再，短期内出口下滑速度的减缓，也无法逆转持续下行的颓势。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　与大宗原料药相比，2013年，我国特色原料药出口增长势头强劲，且以他汀类心血管用药的原料药居多。其中，<a href="http://ypk.39.net/yaopin/d7a9f.html" keycmd="null" style="text-decoration: none; border-bottom: rgb(0,150,165) 1px dashed; color: rgb(0,150,165); padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px" target="_blank">厄贝沙坦</a>出口额增长79.30%，<a href="http://ypk.39.net/yaopin/d22ab.html" keycmd="null" style="text-decoration: none; border-bottom: rgb(0,150,165) 1px dashed; color: rgb(0,150,165); padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px" target="_blank">辛伐他汀</a>增长3.81%。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　在制剂国际化道路上，2013年，我国西药制剂和生化药出口额分别为27.11亿美元和23.97亿美元，同比增长5.82%和6.13%。许铭指出，我国医药企业积极提升国际竞争力的步伐加快，目前已达到欧美日和世卫组织GMP标准的国内企业近50家，美国ANDA申请成功的企业有10余家，产品30余个。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　此外，中药类产品出口创下历史新高，去年出口额达31.38亿美元，同比增长25.54%。其中，植提物出口额14.12亿美元，同比增长21.30%，中药材及饮片出口额为12.11亿美元，同比增长41.24%。许铭表示，近年来，国际市场对植提物的需求大幅增加，中药材及饮片出口旺盛，带动中药类产品出口快速增长。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　2013年，我国医械出口则步入稳步成长期，出口额达193.35亿美元，增幅为9.92%，进口额149.75亿美元，增幅为20.07%。医院诊断与治疗设备作为医械类产品的主力出口产品，仍保持两位数增幅，如彩色超声波诊断仪，去年出口额为4.77亿美元，同比增长11.39%。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<strong style="padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px">新动力未现</strong></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　纵观去年医药外贸整体形势，许铭认为，全球医药经济维持&ldquo;弱增长&rdquo;格局，发达国家经济复苏势头日显，发展中国家经济增速放缓，国际市场需求依然低迷，国内医药产业进入转型关键期，既有的比较优势正在丧失，但拉动贸易增长的新动力尚未出现。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　对此，石药集团药品事业部有关负责人表示，从2011年开始，原料药企就进入了冬天，2013年的冬天尤为寒冷，比如VE、VC、<a href="http://ypk.39.net/yaopin/kwswy/kss/b631f.html" keycmd="null" style="text-decoration: none; border-bottom: rgb(0,150,165) 1px dashed; color: rgb(0,150,165); padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px" target="_blank">四环素</a>等长期在国际市场走俏的产品也开始出现下滑，一度火热的辅酶Q10下滑最大。一些小型原料药生产企业销量下滑可能更大。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　但对于制剂企业来说，2013年还是获得了很多可喜的成绩，很多企业对外合作上了新的台阶。华海制药相关负责人表示，华海药业的阿达木单抗仿制药同时获得欧盟EMA及美国FDA允许，开展I期临床<a href="http://jck.39.net/jiancha/huaxue/myx/4eb2a.html" keycmd="null" style="text-decoration: none; border-bottom: rgb(0,150,165) 1px dashed; color: rgb(0,150,165); padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px" target="_blank">试验</a>。2013年10月，复星医药以3.88亿欧元转让两个新药的开发销售权，也是中国医药国际化的一大步。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<div class="hzh_botleft" style="border-top: rgb(204,204,204) 0px solid; border-right: rgb(204,204,204) 0px solid; width: 200px; vertical-align: bottom; white-space: normal; border-bottom: rgb(204,204,204) 0px solid; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; float: left; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 1px/1px Verdana; padding-left: 0px; margin: 25px 25px 10px 0px; letter-spacing: normal; border-left: rgb(204,204,204) 0px solid; orphans: 2; widows: 2; display: inline; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; border-image: initial">\r\n	<iframe border="0" frameborder="no" height="300" marginheight="0" marginwidth="0" name="adFrame_AA17FA45_6995_495D_8708_F89A733C753F" scrolling="no" src="http://dpvc.39.net/adpolestar/door/;ap=AA17FA45_6995_495D_8708_F89A733C753F;ct=if;pu=san9;/?" style="vertical-align: top" width="200"></iframe></div>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　另据国际医药市场监测平台数据显示，京新药业、翰宇药业、恒瑞医药、海正药业、华海药业、天士力、双鹭药业、<a href="http://ypk.39.net/yaopin/zc/weichang/a2f7c.html" keycmd="null" style="text-decoration: none; border-bottom: rgb(0,150,165) 1px dashed; color: rgb(0,150,165); padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px; padding-right: 0px" target="_blank">美罗</a>药业等20多家药企正在进行制剂国际化项目，未来有望实现较大规模制剂出口，成为撬动利润增长的新动力。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　业内专家认为，我国制剂出口呈现的二元结构应引起关注。一方面，经过多年发展，中国涌现出一批高水平的国际化先导企业，这些企业在制剂国际化道路上行进的步伐较快，大部分制剂产品获得了发达国家认证，出口至国外规范市场；另一方面，国内大多数企业的出口产品结构未有实质性调整，多以低端产品为主，低价竞销严重。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: 16px/28px Verdana; padding-left: 0px; margin: 20px 0px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　中国医保商会分析预测，未来一段时间内，中国医药外贸将呈现五大特点：传统大宗原料药出口将进入长期下行通道；医药产品转型进一步加快；中小型医械与设备出口将稳步增长；中成药贸易逆差局势持续；企业国际化步伐明显加快。</p>', '医药', '', '医药经济报', '', '2014-02-14'),
	(110, '医药经济报', '', '<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	政策和机制不完善让中医药失去了造血功能。打通最后一公里，消除&ldquo;肠梗阻&rdquo;，中医药发展不会贫血，也不会坐等输血</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	前不久，四川成都的何先生突发脑梗阻，送入当地医院急诊室抢救，虽经医生全力治疗，眼睛看东西模糊，右手右脚无法正常活动，只能有待长期康复。令人惊奇的是，香港中医胡永祥博士为何先生扎了两次针灸，扎第一次，眼睛能看清，手脚功能有所恢复；扎第二次，能下地走路，所有症状消除，顺利出院回家。如今，何先生已经基本痊愈，小小银针手到病除。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	中医诞生以来，出现了一大批妙手回春的名医大家。他们的一些医案在现代医学看来都是不可思议的。中医药的治病机理，用现代科学语言还说不清、道不明。一直以来，在某些人的眼里，中医被认为是&ldquo;不科学&rdquo;甚至伪科学。这让人想起前一段江苏卫视热播的《最强大脑》节目，讲述一个孩子的速算能力，16位数开14次方，不到一分钟就写出答案。人的大脑潜能无限，中医药类似超级大脑，这些奥秘在现代科学语境依然是神秘的未知数，还无法求解。正如钱学森所说，中医不是不科学而是超科学，只是目前人类还无法认知。上世纪50年代毛泽东曾说过，&ldquo;中国医药学是一个伟大的宝库，应当努力发掘，加以提高。&rdquo;如何激发中医药发展的活力和潜力，开发中医药&ldquo;超级大脑&rdquo;，是摆在我们面前的现实课题。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&ldquo;明者因时而变，知者随事而制。&rdquo;无论是临床实践还是公共卫生，中医药欠缺的是制度化参与。只是临时抱佛脚，召之即来，挥之即去，没有制度化的实施，中医药&ldquo;超级大脑&rdquo;很难呈现神奇功效。从11年前的非典开始，中医应对传染病疫情有了展现平台。应对H1N1、H7N9等流感疫情，中医药表现不俗，中药不亚于西药。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	中医药参与传染病防治，并不能改变中医药阵地萎缩的局面。中西医并重往往只是贴在墙上、写在纸上，顶多是用来装点门面，说起来重要，做起来不要，冲不走&ldquo;不让中医上手&rdquo;的体制障碍，突不破&ldquo;中医插不上手&rdquo;的现实困境。当然，这种状况也在发生转化，有些地方走在了前面，比如在甘肃省，中医在各大西医院参与会诊、查房、治疗，西医院的中医科不再是一个摆设，中医参与西医临床已经作为一项制度严格执行。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<div class="gg200x300" style="border-top: rgb(229,229,229) 1px solid; border-right: rgb(229,229,229) 1px solid; white-space: normal; overflow-x: hidden; overflow-y: hidden; border-bottom: rgb(229,229,229) 1px solid; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; float: left; padding-bottom: 19px; text-align: center; padding-top: 19px; font: 0px/0 宋体, sans-serif; padding-left: 19px; margin: 0px 22px 0px 0px; letter-spacing: normal; border-left: rgb(229,229,229) 1px solid; orphans: 2; widows: 2; padding-right: 19px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px; border-image: initial">\r\n	<iframe border="0" frameborder="no" height="250" marginheight="0" marginwidth="0" scrolling="no" src="http://g.163.com/r?site=netease&amp;affiliate=news&amp;cat=article&amp;type=logo300x250&amp;location=13" width="300"></iframe></div>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	开发中医药&ldquo;超级大脑&rdquo;，面临着打通最后一公里的难题。行百里者半九十。近年来，各地出台的扶持和发展中医政策文件不少，中医药工作有了不小的起色，但离老百姓需求还有较大差距。中医药事业发展的症结在于，政策和机制不完善让中医药失去了造血功能。打通最后一公里，消除&ldquo;肠梗阻&rdquo;，中医药发展不会贫血，也不会坐等输血。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: justify; padding-top: 0px; font: 14px/24px 宋体, sans-serif; padding-left: 0px; margin: 26px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 2em; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	中医中药像是左右手，中医中药分不开，却多年来处于&ldquo;学医的不懂药，学药的不懂医&rdquo;的人为分裂状态，无法有效推动中医药发展。中医药涉及医疗、保健、科研、教育、文化等多个领域，无论哪个领域出现短板，都会掣肘中医药事业。中医药的发展远不是某一个部门所能解决，必须上升为国家战略，从国家层面进行通盘考虑，顶层设计，协同推进，让中医药&ldquo;超级大脑&rdquo;焕发更多的神奇魅力来造福人类。</p>', '医药', '', '人民网-人民日报', '', '2014-02-14'),
	(111, '纺织服装行业周报：行业的春天还没有到来', '', '<div class="newscon">\r\n	<p>\r\n		　　行情回顾:节前一周沪深300指数下跌,全周收报2202.45点,较前一周下跌1.92%,多数行业下跌,<a href="http://www.chinairn.com/yjbg/moref15f6f23ff1.html">纺织</a><a href="http://www.chinairn.com/yjbg/moref15f6f24ff1.html">服装</a>行业全周上涨1.90%,走势强于沪深300指数。</p>\r\n	<p>\r\n		　　行业信息:</p>\r\n	<p>\r\n		　　(1)欧舒丹加码中国市场,内地是其全球增长最快区域。</p>\r\n	<p>\r\n		　　(2)品牌集合店发展:竞争优势明显,春天还会远吗?</p>\r\n	<p>\r\n		　　(3)韩国OLIVE YOUNG进军中国,首战遇冷。</p>\r\n	<p>\r\n		　　(4)骆驼进军&ldquo;中国式&rdquo;户外。</p>\r\n	<p>\r\n		　　公司动态:(1)卡奴迪路(002656,增持):公司拟对营销网络建设项目的实施方案进行适当调整,新建营销网点由直营店方式调整为直营或直营、联营相结合的方式,增加营销网点门店类型,在原有门店类型(旗舰店、标准店、代理店)的基础上增设品牌集合店。</p>\r\n	<p>\r\n		　　品牌风尚:(1)型牌男装:用互联网数据完成服饰定制。</p>\r\n	<p>\r\n		　　投资策略与建议:</p>\r\n	<p>\r\n		　　以中小板上市公司为主的品牌服饰公司近期将陆续进入业绩快报披露阶段,多数公司年报低于预期应该也已成为市场可以预期的事情,而在行业整体较为低迷的时候,部分上市公司进行的主动调整策略我们认为反而有利于后续零售复苏时公司更好的业绩反转。我们维持之前的判断:品牌服饰行业预计至少在2014年中期之前整体机会相对匮乏,中短期仍重在精选个股。从短期看,报表改善较早的子行业主要有大众休闲和家纺公司,改善最晚的是男装。从中长期看,我们认为回归用户为中心的商业本质,积极拥抱互联网,致力于提升产品差异度和客户体验度的品牌企业才能真正胜出并获得新的发展空间。本周我们继续推荐年报和一季报预期不错的鲁泰A(000726,买入)和探路者(300005,买入),同时建议关注罗莱家纺(002293,买入)。日化巨头<a href="http://www.chinairn.com/area/shanghai.html">上海</a>家化(600315,买入)近期调整较多,从全年角度我们依然看好其投资价值。</p>\r\n	<p>\r\n		　　风险提示</p>\r\n	<p>\r\n		　　行业投资风险主要来自于国内零售终端复苏进度慢于预期。</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '服装', '', '中国行业研究网', '', '2014-02-14'),
	(112, '鲁政委:食品价格上涨致1月份CPI涨幅超预期', '', '<h2 class="o-tit" sizcache02511225245197856="11" sizset="0">\r\n	<strong>原标题：</strong>鲁政委:食品价格上涨致1月份CPI涨幅超预期</h2>\r\n<div class="body" id="content_body">\r\n	<!--repaste.body.begin-->\r\n	<p>\r\n		　　中国网财经2月14日讯(记者 安吉罗)国家统计局数据显示，2014年1月居民消费价格指数同比上涨2.5%，兴业银行首席经济学家鲁政委对此表示，受食品价格涨幅影响，CPI数据高于预期，2月份数据仍会因蔬菜而略高，但此后将明显下行。</p>\r\n	<p>\r\n		　　据统计，2014年1月份，全国居民消费价格总水平同比上涨2.5%。其中，城市上涨2.6%，农村上涨2.2%；食品价格上涨3.7%，非食品价格上涨1.9%；消费品价格上涨2.0%，服务价格上涨3.7%。此外，与上月相比，1月份全国居民消费价格总水平环比上涨1.0%。其中，城市上涨1.0%，农村上涨0.9%；食品价格上涨2.4%，非食品价格上涨0.3%；消费品价格上涨1.1%，服务价格上涨0.8%。</p>\r\n	<p>\r\n		　　鲁政委认为，1月CPI同比涨2.5%，比兴业银行预测的2.3%高，主要是食品价格环比上涨2.4%高于预测的2.0%，但（这个数据）与往年春节月份比并不高。</p>\r\n	<p>\r\n		　　&ldquo;特别值得关注的是，从同比看，食品涨幅大的是鲜果和液态乳制品，往年逢年必涨的猪肉和鸡蛋价格是下跌的，暗示今年消费乏力。2月仍会因蔬菜而略高，但此后将明显下行。&rdquo;他说。（中国网财经中心）</p>\r\n	<!--repaste.body.end--></div>\r\n<p>\r\n	<!--end content body-->\r\n	<style type="text/css">\r\n.turn_page_box_content{clear:both;padding:9px 2px;text-align:center;color:#000000;margin:0;font-size:12px;font-family:"宋体";}\r\n							.turn_page_box_content .tpb_right a{padding:0 6px 0;border:1px solid #ccc;background-color:#fff;color:#000000;height:20px;line-height:20px;font-size:12px;display:inline-block;}\r\n							.turn_page_box_content .tpb_right a:hover{background-color:#ffffff;text-decoration:none;border-color:#ff0000}\r\n							.turn_page_box_content .tpb_right a.cur{font-weight:bold;padding:0 6px 0;border:1px solid #ed120a;background-color:#ed120a;color:#fff}\r\n							.turn_page_box_content .tpb_right a.cur:hover{background-color:#ed120a}\r\n							.turn_page_box_content .tpb_right a.tpb_btn_previous, .turn_page_box_content .tpb_right a.tpb_btn_next{padding-left:6px;padding-right:6px}\r\n							.turn_page_box_content .tpb_right a{margin-right:6px;}	</style>\r\n</p>', '食品', '', '中国网财经', '', '2014-02-14'),
	(113, '甘肃省委省政府关于全面深化农村改革加快推进农业现代化的', '', '<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<strong>中共甘肃省委 甘肃省人民政府</strong></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<strong>关于全面深化农村改革加快推进农业现代化的意见</strong></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<strong>(2014年1月26日)</strong></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　我省转型跨越发展中最薄弱的环节仍然是农业现代化滞后，经济社会体制中最突出的矛盾仍然是城乡二元体制障碍明显，努力与全国一道建成全面小康社会进程中最严重的制约仍然是城乡发展和居民收入差距过大，全面深化农村改革的任务十分繁重，&ldquo;三农&rdquo;工作依然是全省工作的&ldquo;重中之重&rdquo;。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　中央强调，要坚持和完善农村基本经营制度，始终把改革作为根本动力，不断激发农村经济社会活力。明确提出，要完善国家粮食安全保障体系、强化农业支持保护制度、建立农业可持续发展长效机制、深化农村土地制度改革、构建农业新型经营体系、加快农村金融制度创新、健全城乡发展一体化体制机制、改善乡村治理机制。全省各级党委政府和各级领导干部，要把思想和行动统一到中央决策部署上来，结合我省&ldquo;三农&rdquo;工作实际，切实抓好贯彻落实。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　2014年及今后一个时期全省农业农村工作，要全面贯彻党的十八大、十八届三中全会和中央农村工作会议精神，立足农业强起来、农民富起来、农村美起来，按照稳定政策、改革创新、持续发展的总要求，稳住粮食、着眼增收、深化改革、夯实基础，深入实施&ldquo;365&rdquo;现代农业发展行动计划、&ldquo;1236&rdquo;扶贫攻坚行动和&ldquo;联村联户为民富民&rdquo;行动，着力推进体制机制创新，着力夯实农业发展基础，着力推进农业现代化，着力推进新农村建设，为促进全省经济社会持续健康发展提供有力支撑。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　2014年农业农村工作主要预期目标是：农业增加值增长5%以上，粮食产量稳定在1100万吨以上，畜牧业增加值增长12%以上，农民人均纯收入增长13%左右，减少农村贫困人口140万人。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<strong>一、增强粮食等重要农产品的生产和保障能力</strong></p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　1.稳定粮食生产。服从国家粮食安全大局，不断提高省内粮食自求平衡能力。着眼提高粮食单产、种粮效益和种粮农民积极性，严守耕地保护红线，划定永久基本农田，确保耕地面积、粮播面积、粮食总产&ldquo;三个不减&rdquo;。项目、资金和科技服务向粮食生产大县倾斜。实施旱作农业区新增50亿斤粮食产能项目。推广全膜双垄沟播技术1500万亩、农艺节水1000万亩，发展高效农田节水100万亩。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　2.夯实现代农业发展基础。开展农田水利设施产权改革和运行管护机制试点。完善大中型水利工程建设征地补偿政策，建立水权确权和交易制度，通过以奖代补、先建后补等方式，探索农田水利基本建设新机制。实施河西走廊及沿黄灌区国家级高效节水灌溉示范区等农田水利项目，抓好7个高效节水试点县、3个规模化高效节水示范县、5个牧区节水灌溉示范等项目建设。建成引洮供水一期工程，完成靖远双永供水、引洮入潭主体建设任务，做好引洮二期、白龙江引水、引哈济党、引黄济临、甘肃中部生态移民水利等工程前期工作。全面推进防灾减灾和灾后恢复工程建设，完成60座小型病险水库、27座病险水闸除险加固任务。加快农田灌溉渠系配套建设。新建一批小水池、小沟渠、小塘坝、小堰闸、小泵站等&ldquo;五小&rdquo;水利工程。新修梯田150万亩，治理水土流失面积2000平方公里。加强基础设施的建设管护，形成群众建管机制。新增农村水电装机15万千瓦。加快研发和推广便捷、适用的玉米、马铃薯等新型农机具，力争农机总动力达到2520万千瓦，农业机械化对农民增收的贡献额人均达到190元。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　3.强化耕地保护。实行最严格的耕地保护制度和节约集约用地制度、水资源管理制度、环境保护制度，强化监督考核和激励约束。统筹梯田工程、坡耕地水土流失综合治理、国土整治、农业综合开发等项目，编制高标准农田建设规划，年内建成147万亩。大力推广节地、节水、节肥、节药、保护性耕作、免耕和测土配方施肥等技术。加大耕地污染治理力度，健全回收网络，落实企业包片回收、乡村定点回收责任和政策补贴措施，力争废旧农膜回收利用率达到75%。落实尾菜回收处理补贴政策，处理利用率达到25%以上。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　4.保障重要农产品市场供给。落实国家粮食等重要农产品价格形成机制和市场调控制度。加大力度落实&ldquo;米袋子&rdquo;省长负责制、&ldquo;菜篮子&rdquo;市长负责制。加大粮食、生猪、牛羊肉等重要农产品生产、储备和流通能力建设。加强农资市场监管和农产品市场价格监控，严厉打击制售假冒伪劣产品和扰乱市场秩序行为，保障重要农产品市场基本稳定。增强全社会节粮意识。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　5.加强农产品质量安全监管。建立最严格、覆盖全过程的食品安全监管制度，加强法规和标准体系建设，落实地方政府属地管理和生产经营主体责任。加大批发市场质量安全检验检测费用补助，支持标准化生产、重点产品风险监测预警、食品追溯体系建设。健全县乡农产品质量安全监测体系，把农产品质量安全纳入各级政府目标责任考核。开展安全食品示范市县创建试点。认真落实农产品产地准出和市场准入制度。严格农业投入品监管，开展园艺作物标准园、畜禽规模化养殖、水产健康养殖等创建活动，积极发展无公害农产品、绿色食品、有机农产品和地理标志农产品。打击农产品进出口走私行为，保障进口农产品质量安全和省内产业安全。</p>\r\n<p align="right" style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 0px; padding-top: 0px; font: 14px/23px 宋体; padding-left: 0px; margin: 15px 0px; letter-spacing: normal; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　（原标题：甘肃省委省政府关于全面深化农村改革加快推进农业现代化的意见）</p>', '农', '', '每日甘肃网', '', '2014-02-14'),
	(114, '科技部:把加强现代农业科技工作摆在优先地位', '', '<h1 class="ep-h1" id="h1title" style="white-space: normal; text-transform: none; color: rgb(37,37,37); word-spacing: 0px; padding-bottom: 0px; text-align: left; padding-top: 0px; font: bold 26px/31px 宋体, sans-serif; padding-left: 0px; margin: 0px; letter-spacing: -1px; orphans: 2; widows: 2; padding-right: 0px; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	科技部:把加强现代农业科技工作摆在优先地位</h1>', '农', '', '人民网', '', '2014-02-14'),
	(115, '云南林业十大计划构筑西南生态屏障', '', '<p align="justify" style="text-align: justify; margin: 0px 3px 15px; text-justify: distribute; text-indent: 30px">\r\n	原标题：云南林业十大计划构筑西南<span name="HL_TAG" style="cursor: hand; text-decoration: underline; border-bottom: 0px dotted; color: #0084d8">生态屏障</span></p>\r\n<p align="justify" style="text-align: justify; margin: 0px 3px 15px; text-justify: distribute; text-indent: 30px">\r\n	科技日报讯 （记者马波通讯员吕金平）记者日前从云南省林业厅获悉，为促进&ldquo;森林云南&rdquo;建设，云南省将实施生态红线保护行动等&ldquo;林业十大行动计划&rdquo;，2020年全省森林覆盖率力争达到60%左右。</p>\r\n<p align="justify" style="text-align: justify; margin: 0px 3px 15px; text-justify: distribute; text-indent: 30px">\r\n	云南省提出，实施<span name="HL_TAG" style="cursor: hand; text-decoration: underline; border-bottom: 0px dotted; color: #0084d8">生态文明</span>建设林业十大行动计划，促进&ldquo;森林云南&rdquo;建设，构筑中国重要的生物多样性宝库及西南生态安全屏障。&ldquo;十大行动计划&rdquo;包括实施生态红线保护行动、实施陡坡地生态治理行动、实施生态公益林保护行动、实施重点区域生态保护与修复行动、实施物种零灭绝行动、实施高原湿地保护与恢复行动、实施森林生态服务功能提升行动、实施林业产业振兴行动、实施森林灾害防控行动、实施生态文化建设行动等。</p>\r\n<p align="justify" style="text-align: justify; margin: 0px 3px 15px; text-justify: distribute; text-indent: 30px">\r\n	在实施生态红线保护行动中，云南省将划定生态红线，制定生态红线管理措施。严格保护森林植被，确保到2020年全省林地面积不低于2487万公顷，森林面积不低于2143万公顷，森林覆盖率力争达到60%左右，森林蓄积量要保持在18.5亿立方米以上。</p>\r\n<p align="justify" style="text-align: justify; margin: 0px 3px 15px; text-justify: distribute; text-indent: 30px">\r\n	在实施物种零灭绝行动中，云南省将加快建立和完善国家公园体制，加强自然保护区建设，扎实推进极小种群物种拯救与保护，至2015年，建立极小种群及珍稀濒危特有物种保护小区(点)15处；完成16个近地保护植物园建设；完成10至15个物种100个健康的迁地保护种群建设及5至7个极小种群物种回归基地建设，使国家重点保护野生动植物受保护率达到85%。至2020年，国家重点保护野生动植物受保护率达到或超过90%，全省生物物种及遗传基因多样性得到切实有效保护，确保实现&ldquo;物种零灭绝&rdquo;的目标。</p>\r\n<p align="justify" style="text-align: justify; margin: 0px 3px 15px; text-justify: distribute; text-indent: 30px">\r\n	据介绍，2013年，云南省林业投入达62.6亿元，同比增加13.2%；森林资源培育步伐加快，种植木本油料林257万亩，改造<span name="HL_TAG" style="cursor: hand; text-decoration: underline; border-bottom: 0px dotted; color: #0084d8">低效林</span>402万亩，陡坡地治理80万亩，全年共营造林850万亩，占计划的130.8%；全省森林覆盖率、活立木蓄积量实现双增长，分别达54.64%和18.75亿立方米。</p>', '林', '', '人民网', '', '2014-02-14'),
	(116, '瑞士家具商发明磁悬浮魔毯 可原地升起小宠物', '', '<p>\r\n	【环球网综合报道】很多人可能会梦想着像阿拉丁一样坐上飞毯，如今瑞士家具商的一项发明或许会让这一梦想在将来实现。据香港《东方日报》3月3日报道，瑞士有创意家具零售商发明了&ldquo;神奇磁悬浮魔毯&rdquo;，利用磁力可载着重2.4公斤的小狗，原地升起7厘米。</p>\r\n<p>\r\n	据报道，该张由瑞士Micasa Lab设计的磁悬浮魔毯，内置六对混合化学元素钕、铁及硼制成的稀土磁石，通过特别技术可将小型宠物原地升起，过程相当平稳，绝不会吓怕小动物。发明魔毯的公司希望将这件产品，发展成可将重10公斤的宠物升起到20厘米高，长远目标是能升起成年人，让人类未来可一尝坐飞毯的滋味。</p>\r\n<p>\r\n	报道称，虽然现在的魔毯只能原地升起，但随着科技进步，魔毯或许可发展成载人飞来飞去。除了载人，魔毯的磁力技术亦可应用于设计会悬浮的创新家具，将梳化、书柜、桌子或杂物等漂浮起来，家中的空间便可以更灵活运用。</p>', '家具', '', '环球网', 'recommend', '2014-03-03'),
	(117, '欢聚时代季报图解：营收6.12亿元 同比增129.5%', '', '<div>\r\n	[导读]今年欢聚时代将重点向网络娱乐、直播内容、教育和其它服务渗透。腾讯科技 雷建平 3月5日报道</div>\r\n<div>\r\n	欢聚时代（证券代码：YY）今天发布财报。财报显示，欢聚时代第四季度净营收为6.123亿元，比去年同期增长129.5%；净利润1.92亿元，比去年同期的3320万元增长477.9%。</div>\r\n<div>\r\n	欢聚时代CEO李学凌(微博)称：&ldquo;2013年，公司在线音乐和娱乐的表现再次超过我们的预期，营收同比增长217.1%，这主要得益于yy平台实时互动和社交能力，我们已经看到我们不断拓展的活跃用户群体中越来越多的多样化和互动性网络活动。&rdquo;</div>\r\n<div>\r\n	李学凌说，展望2014年，欢聚时代将依赖已建立的强劲基础，继续拓展让用户参与的能力及促进用户增加支出的能力，也将向网络娱乐、直播内容、教育和其它服务渗透。</div>\r\n<div>\r\n	YY Q4营收6.123亿元 同比增129.5%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度营收6.123亿元（1.011亿美元），比去年同期增长129.5%。欢聚时代净营收增长，主要是由于来自互联网增值服务营收增长，其次由于来自网络广告营收的增长。</div>\r\n<div>\r\n	欢聚时代第四季来自互联网增值服务的营收（包括来自于在线游戏、YY音乐及包括会员计划在内其他来源营收）为5.689亿元（9400万美元），比去年同期的2.33亿元增144%。欢聚时代第四季互联网增值服务营收增长，反映每位用户平均收入增长和付费用户人数增长。</div>\r\n<div>\r\n	YY音乐Q4营收3.366亿元 同比增217.1%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度来自在线音乐和娱乐的营收为3.366亿元（约合5560万美元），比去年同期的1.061亿元增长217.1%。欢聚时代第四季度在线音乐营收的增长，主要由反映付费用户数量和每位用户平均收入的增长。欢聚时代第四季度在线音乐和娱乐每用户平均收入为373元，同比增长19.6%；付费用户人数增长165.3%，至902,000人。</div>\r\n<div>\r\n	YY Q4在线游戏营收1.628亿元 同比增66%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度来自网络游戏营收1.628亿元（约合2690万美元），比去年同期的9800万元增长66.1%。欢聚时代第四季度网络游戏营收增长，主要由反映每用户平均收入的增长和付费用户数量的增长。</div>\r\n<div>\r\n	欢聚时代第四季度网络游戏每用户平均收入增41.4%，至376元；在线游戏总数为126款，高于上年同期73款。欢聚时代第四季度总付费用户人数为43.3万人，比上年同期增长17.7%。</div>\r\n<div>\r\n	欢聚时代第四季度来自其他业务（主要包括会员计划和现场游戏直播等）营收为6950万元（约合1150万美元），比去年同期的2880万元增长140.9%。欢聚时代第四季度来自会员计划的营收为4450万元（约合740万美元），比去年同期的2580万元增长72.4%。</div>\r\n<div>\r\n	欢聚时代第四季度会员计划营收的增长，主要由反映会员计划的会员总数的增加。欢聚时代第四季度会员计划总付费用户人数为83.7万人，比截至2012年12月31日的50.8万人增长64.8%。欢聚时代第四季度来自现场游戏直播的营收从去年同期的70万元大幅增长到2060万元（约合340万美元）</div>\r\n<div>\r\n	欢聚时代第四季度来自网络广告业务的营收为4340万元（约合720万美元），比去年同期的3380万元增长28.5%，主要反映了广告主数量的增长。欢聚时代第四季度每广告主平均收入约为47.2万元。欢聚时代第四季度的广告主数量为92个，同比增长50.8%。</div>\r\n<div>\r\n	YY Q4成本2.968亿元 同比增114%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度营收成本为2.968亿元（约合4900万美元），比去年同期的1.389亿元增长113.6%。欢聚时代第四季度营收成本的增长，主要由于收入分成和内容成本增长至1.651亿元（约合2730万美元），高于上年同期的4710万元。</div>\r\n<div>\r\n	YY Q4毛利3.155亿元 毛利率52%</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	欢聚时代第四季度毛利润为3.155亿元（约合5210万美元），比去年同期的1.279亿元增长146.7%。欢聚时代第四季度毛利率为51.5%，高于去年同期的47.9%，毛利率同比增长主要是由于公司改善了成本效益以及公司控制带宽成本的能力增强。</div>\r\n<div>\r\n	YY Q4费用1.285亿元 同比增37%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度运营支出为1.285亿元（约合2120万美元），比去年同期的9380万元增长37%。欢聚时代第四季度运营支出的增长，主要由于公司研发支出和总务与行政支出的增长，它们均符合公司整体业务的增长。</div>\r\n<div>\r\n	YY Q4运营利润1.949亿元 运营利润率32%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度运营利润为1.949亿元（约合3220万美元），比去年同期的运营利润3520万元增长453.4%。欢聚时代第四季度运营利润率为31.8%，去年同期运营利率为13.2%。欢聚时代第四季度运营利润率的增长，主要由于与公司扩张相关的运营杠杆增长。</div>\r\n<div>\r\n	YY Q4净利1.92亿元 同比增477.9%</div>\r\n<div>\r\n	转播到腾讯微博</div>\r\n<div>\r\n	欢聚时代第四季度净利润为1.92亿元（约合3170万美元），比去年同期的3320万元增长477.9%。欢聚时代第四季度净利率为31.4%，高于上年同期的12.5%。</div>\r\n<div>\r\n	截至2013年12月31日，欢聚时代持有的现金和现金等价物总额为7.296亿元（约合1.205亿美元），短期存款总量为14亿元（约合2.367亿美元）。欢聚时代第四季度来自于业务运营活动的净现金为3.584亿元（约合5920万美元）。返回腾讯网首页&gt;&gt;</div>', '互联网', '雷建平', '腾讯科技', '', '2014-03-05'),
	(118, 'UKER:2014英国签证材料准备之“毕业证翻译模版”', 'upload/images/1394013488406.jpg', '<p>\r\n	#UKER#【2014英国签证材料准备之&ldquo;毕业证翻译模版&rdquo;】通常来说，签证高峰会出现在7-8月，不过小编总觉得早做准备总是不会错的，下面，就让我们先来认识下签证材料之&ldquo;毕业证翻译模版&rdquo;吧，PS：好东西！同学们赶快收走！http://t.cn/8FD7Dgf</p>', '教育', '', '英国留学-中英网', 'recommend', '2014-03-05'),
	(119, '午间公告：鸿博股份联手银联电子支付开发购彩平台复制链接 打印 大 中 小', '', '<div>\r\n	鸿博股份（002229）5日午间公告，公司控股子公司广州彩创于3月5日与上海银联电子支付服务有限公司（简称&ldquo;银联电子支付&rdquo;）签署了《开放式购彩平台开发备忘录》。广州彩创与银联电子支付拟合作开发开放式购彩平台，合作平台将为拥有大量个人客户的银行、证券公司、基金公司以及拥有福利与体育彩票销售资格的单位或其他客户资源方提供快捷接入服务。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	　　根据备忘录内容，广州彩创负责合作平台的研发、调试及技术维护等工作；银联电子支付负责合作平台的推广，包括支付服务、在线推送等；同时，银联电子支付负责拓展具有客户群体的客户渠道及资源方，广州彩创提供相应的协助；合作平台开发费用由双方共同承担，运营收益由双方共享。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	　　公司表示，本次合作，有利于整合双方优势资源，实现优势互补，符合公司整体发展战略，能进一步拓宽公司彩票无纸化业务市场和销售渠道。&nbsp;</div>', '互联网', '', '搜狐公司', '', '2014-03-05'),
	(120, '苏宁惊蛰大促 联想G505 标3099再减200', 'upload/images/1394276994031.jpg', '<p>\r\n	虽然五六千元甚至更高价位的笔记本电脑，往往更容易获得媒体的关注，然而，三千元左右才是市场销量最大的产品，尤其是对于广大的家庭用户来说。来自联想的G505是一台内外兼修的动人之作，联想G505笔记本电脑搭载AMD经典四核A4-5000 APU处理器，并具备AMD Radeon HD8570M 2GB独立显卡的产品。近日苏宁&ldquo;惊折&rdquo;电脑节上（<a class="f14_link" href="http://sale.suning.com/images/advertise/007/AMD0303/index.html" target="_blank">http://sale.suning.com/images/advertise/007/AMD0303/index.html</a>）更是爆出了3099再减200的折扣，同时还可以参与抽取X-BOX ONE游戏主机，这么大的尺度，你懂的！</p>\r\n<p>\r\n	联想G505笔记本采用了15.6英寸16:9的LED高清炫彩屏，显示效果相当出色，在笔记本的上方还内置了30万像素摄像头，方便用户的日常视频聊天，支持杜比认证音效，采用联想高触感巧克力键盘，手感舒适。搭载的AMD经典四核A4-5000 APU，拥有2MB的二级缓存，标配2GB内存和500GB硬盘，支持超级DVD刻录，并搭配了2G显存AMD HD8570M独立显卡，完美支持DirectX11，拥有1&times;USB2.0+2&times;USB3.0接口，VGA，HDMI视频接口，其余网络接口、电源接口一应俱全，还支持支持802.11b/g/n无线协议，综合性能出色。</p>\r\n<p>\r\n	从外观方面讲，联想 G505笔记本采用了全新的外观设计，在风格上与Y系列更加接近，而在机身材质上抛弃了原先的工程塑料，采用了金属质感的顶盖、拉丝工艺。而机身C面的键盘边框、掌托部分更是采用了真正的金属材质，同样拥有拉丝工艺。&nbsp;</p>\r\n<p>\r\n	<strong>【配置参数】</strong></p>\r\n<p>\r\n	屏幕尺寸：15.6英寸</p>\r\n<p>\r\n	CPU型号：AMD 经典四核APU A4-5000</p>\r\n<p>\r\n	内存容量：2GB DDR3</p>\r\n<p>\r\n	硬盘容量：500GB 5400转/分钟</p>\r\n<p>\r\n	显卡芯片：AMD Radeon HD 8570M 2GB</p>\r\n<p>\r\n	笔记本重量：2.6Kg</p>\r\n<p>\r\n	参考报价：3099元</p>\r\n<p>\r\n	苏宁链接：<a class="f14_link" href="http://product.suning.com/104019409.html" target="_blank">http://product.suning.com/104019409.html</a></p>\r\n<p>\r\n	编辑点评：联想G505作为一款全能本，自然在外观与性能方面都表现出色，15.6英寸的屏幕有着良好的娱乐或者观影效果，四核处理器+2G独显的搭配，让您在游戏时不仅有优秀的显示效果，更有流畅的性能体验，更吸引人的是其价格，惊折电脑节期间折上再折，推荐入手。</p>', '电脑', '', '驱动之家', 'hot', '2015-08-05'),
	(121, '联想Z410A(i5芯/4G/500G/Win8)售4399元', '', '<p>\r\n	【3月7日太平洋电脑网西安讯】联想Z410A笔记本，采用i5-4200M处理器，标配4GB内存500GB硬盘，搭载2GB显存容量的GT 740M独立显卡+Intel HD 4000核芯显卡；<a class="cmsLink" href="http://product.pconline.com.cn/itbk/bjbzj/notebook/1107/2481034.html" target="_blank">双显卡切换</a>，Windows 8操作系统，性能卓越，高清电影及主流娱乐<a class="cmsLink" href="http://www.pcgames.com.cn/" target="_blank">游戏</a>都能运行自如。具有超快极速的数据分享，传输及备份，一定会带给你带来前所未有的使用体验。今日商家特惠现仅4399元，想要购买这款机型的朋友赶紧与商家联系一下。<br />\r\n	联想Z410A</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 从外观方面讲，联想Z410A<a class="cmsLink" href="http://product.pconline.com.cn/notebook/" target="_blank">笔记本</a>采用了全新的外观设计，在风格上与G系列更加接近，仅在细节方面有所区别，总体来说外观、细节 做工有了提升；而在机身材质上抛弃了原先的工程塑料，采用了金属质感的顶盖、拉丝工艺；<a class="cmsLink" href="http://product.pconline.com.cn/notebook/c1116/" target="_blank">14.1英寸</a>LED背光显示屏，16：9黄金比例，分辨率达1366&times;768显示效果出色。</p>\r\n<p style="text-align: center;">\r\n	<a href="http://www.pconline.com.cn/xa_pic/440/4400962_pic.html?imgsrc=http://img0.pconline.com.cn/pconline/1401/24/4219785_lx22.jpg&amp;channel=1273" target="_blank"><img alt="联想Z410A" src="http://img0.pconline.com.cn/pconline/1401/24/4219785_lx22_thumb.jpg" style="border: 1px solid black; width: 500px; height: 375px;" title="联想Z410A" /></a><br />\r\n	联想Z410A</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 从配置方面讲，联想Z410A笔记本采用Intel Core i5-4200M(2.5GHz/L3 3M)处理器，标配4GB DDR3内存、500GB <a class="cmsLink" href="http://product.pconline.com.cn/so/s16968/" target="_blank">5400转</a>机械硬盘；搭载2GB显存容量的NVIDIA GeForce GT 740M独立显卡+Intel HD 4000核芯显卡；预装Windows 8操作系统；内置超级DVD刻录、10M-100M网卡、30万像素高清摄像头、扬声器、音效芯片，支持SuperMulti双层刻录，极速的数据分享，传输及备份，带来前所未有的使用体验。<br />\r\n	&nbsp;<br />\r\n	<strong>编辑点评</strong></p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 联想Z410A采用Intel <a class="cmsLink" href="http://product.pconline.com.cn/notebook/c14019/" target="_blank">Core i5</a>-4200M(2.5GHz/L3 3M)处理器，内置4G<a class="cmsLink" href="http://product.pconline.com.cn/notebook_ram/" target="_blank">内存</a>和500G硬盘，显卡则采用了2G显存容量的NVIDIA GeForce GT 740M独立显卡，预装<a class="cmsLink" href="http://product.pconline.com.cn/so/s64564/" target="_blank">Windows 8</a>操作系统，整体配置非常主流。喜欢的朋友不妨与商家联系一下，目前仅需4399元，购买时提及太平洋电脑网西安站将享受更多优惠！</p>\r\n<p>\r\n	[参考报价] 4399元<br />\r\n	[销售商家] 陕西鑫道科技<br />\r\n	[联系方式] 029-68836944&nbsp; 13347418303&nbsp; 杨阳<br />\r\n	[商家地址] 陕西省西安市碑林区百脑汇电脑城7层A28室&nbsp;&nbsp;&nbsp;&nbsp;<br />\r\n	[商家网址] <a href="http://m.pconline.com.cn/shop583283/">http://m.pconline.com.cn/shop583283/</a><br />\r\n	[报价查询] <a href="http://product.pconline.com.cn/notebook/xa/" target="_blank"><span style="color: rgb(0, 0, 255);">西安笔记本报价</span></a><br />\r\n	[行情查询] <a href="http://notebook.pconline.com.cn/price/xa/" target="_blank"><span style="color: rgb(0, 0, 255);">西安笔记本行情</span></a></p>\r\n<p>\r\n	<!--文章内容end--></p>', '电脑', '', 'pconline 原创', 'focus', '2015-08-05'),
	(122, '高性价首选 神舟新瑞E20 D5仅售2099元_DoNews-IT数码', 'upload/images/1394187979484.jpg', '<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	<strong>【</strong><strong>PConline北京站</strong><strong>行情</strong><strong>】</strong>神舟新瑞E20 D5是一款配置中等，价格实惠的家用台式机，配有19.5寸宽屏显示器，在家中上网影音等常用任务轻松搞定，现有北京商家报价为2099元，喜欢的朋友不要错过了。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	&nbsp;</p>\r\n<center>\r\n	<table align="center" border="1" bordercolor="#000000" cellpadding="5" cellspacing="0" class="HLTabStyle" sizcache="1" sizset="0" style="font-size: 12px; border-collapse: collapse;" width="500">\r\n		<tbody sizcache="0" sizset="0">\r\n			<tr bgcolor="#3367cd">\r\n				<td align="middle" bgcolor="#3367cd" colspan="5" height="35">\r\n					<strong><span style="color: rgb(255, 255, 255);">整机类最新价格变动表</span></strong></td>\r\n			</tr>\r\n			<tr>\r\n				<td align="middle">\r\n					型号</td>\r\n				<td align="middle">\r\n					之前报价（元）</td>\r\n				<td align="middle">\r\n					现价（元）</td>\r\n				<td align="middle">\r\n					升跌（元）</td>\r\n				<td align="middle">\r\n					备注</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="middle">\r\n					神舟 新瑞E20 D5</td>\r\n				<td align="middle">\r\n					--</td>\r\n				<td align="middle">\r\n					2099</td>\r\n				<td align="middle">\r\n					--</td>\r\n				<td align="middle">\r\n					--</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" colspan="5">\r\n					<div>\r\n						<strong>采集日期：2014年03月07日更多行情价格变动请点击<span style="color: rgb(51, 103, 205);">北京台式机行情</span></strong></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</center>\r\n<p align="center" class="pictext">\r\n	神舟 新瑞E20 D5</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	神舟新瑞E20 D5采用Intel Celeron G1620(2.7GHz/L3 2M)双核处理器，主频为2.7GHz，内存为2GB DDR3，并配有500GB硬盘存储空间。显示器为19.5寸1366&times;768，集成显卡以及声卡网卡等。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	&nbsp;</p>\r\n<center>\r\n	<table align="center" bgcolor="#294f9c" cellpadding="10" cellspacing="1" class="HLTabStyle" width="500">\r\n		<tbody>\r\n			<tr>\r\n				<td bgcolor="#294f9c" colspan="2">\r\n					<div align="center">\r\n						<strong><span style="color: rgb(255, 255, 255);">PConline产品库</span><span style="color: rgb(255, 255, 255);">&mdash;&mdash;规格参数</span></strong></div>\r\n				</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col11" width="93">\r\n					品牌</td>\r\n				<td align="left" bgcolor="#ffffff" class="col12" width="354">\r\n					神舟</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					系列</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					神舟新瑞E20系列</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col11" width="93">\r\n					型号</td>\r\n				<td align="left" bgcolor="#ffffff" class="col12" width="354">\r\n					E20 D5</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					处理器</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					Intel Celeron G1620(2.7GHz/L3 2M)</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					内存类型</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					DDR3</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					内存大小</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					2GB</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					硬盘类型</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					SATA硬盘</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					硬盘容量</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					500GB</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					光驱</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					DVD光驱</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					显示器</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					LCD</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					尺寸</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					19.5寸</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					显卡</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					Intel HD Graphics</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					声卡</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					板载声卡</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					网卡</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					内置10-100-1000M网卡</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					键盘/鼠标</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					标准键盘/光电鼠标</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					机箱</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					立式</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col11" width="93">\r\n					产品链接</td>\r\n				<td align="left" bgcolor="#ffffff" class="col12" width="354">\r\n					http://product.pconline.com.cn/pc/hasee/562443.html</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col11" width="93">\r\n					IT商城</td>\r\n				<td align="left" bgcolor="#ffffff" class="col12" width="354">\r\n					网购实价</td>\r\n			</tr>\r\n			<tr>\r\n				<td align="right" bgcolor="#ecf0f8" class="col21" width="93">\r\n					更多详细资料</td>\r\n				<td align="left" bgcolor="#ffffff" class="col22" width="354">\r\n					图片 报价 参数 比较 网友点评 评测&middot;行情</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</center>\r\n<p>\r\n	&nbsp;</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	<strong>编辑点评：</strong>神舟新瑞E20 D5虽然配置比较一般，但是在这个价位来说还是很有性价比的，并且日常家庭应用都能轻松应付，对于不喜欢玩游戏的朋友可以考虑。[返回北京分站查看更多]</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	<strong>购机时提及PConline太平洋电脑网将会获取更好的服务或优惠。</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	[参考价格]：神舟 新瑞E20 D5　2099元</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	[销售商家]：北京宝鼎天数码科技发展中心 http://m.pconline.com.cn/shop300580/</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	[商家地址]：北京市海淀区西草场1号硅谷电脑城四层4A21</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	[商家电话]：15210847631 010-82851766</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	[最新行情]：北京台式机行情</p>\r\n<p align="justify" style="margin: 0px 3px 15px; text-align: justify; text-indent: 30px; text-justify: distribute;">\r\n	[报价查询]：北京台式机报价</p>\r\n<div style="display: none;">\r\n	&nbsp;</div>', '电脑', '', '太平洋电脑网', 'hot', '2015-08-05'),
	(123, 'IT168景保玉：E人E本助力无纸化办公真正落地', '', '<p>\r\n	随着信息技术的快速发展，信息化浪潮席卷全球。在我国，信息化也已经被提升到政策层面，为中央和各级政府积极推进电子政务提供了政策支持。恰逢两会召开，不少省市也已经开始运行提案网上办理系统。在此之时，光明网与E人E本联合启动&ldquo;如果两会这样开&mdash;&mdash;E人E本无纸化办公实验室&rdquo;活动，旨在更好的推进无纸化办公的落地。</p>\r\n<p>\r\n	　　在此次活动中，IT168企业级移动频道高级编辑景保玉模拟担任了两会代表的角色，并对E人E本无纸化会议系统进行了体验。景保玉指出，E人E本无纸化会议系统成为推进无纸化办公的亮点，正在召开的两会将是普及无纸化办公的重要突破口。</p>\r\n<p>\r\n	　　2月27日，中央网络安全和信息化领导小组宣告成立，信息化再次成为政府关注和社会热议的焦点。中央网络安全和信息化领导小组的成立彰显了国家推动信息化发展的决心，是中国网络安全和信息化国家战略迈出的重要一步，也成为中央及各级政府加大落实电子政务和无纸化办公的重要契机。</p>\r\n<p>\r\n	　　在无纸化办公被政府大力推进之时，E人E本推出了无纸化会议系统。通过E人E本无纸化会议系统，大会组织者只需在后台进行简单操作，就能够完成包括分发会议资料、通知会议日程等会议日常工作；而用户则可以对接收到的文件进行圈住和批示。在这个过程中，大会组织者和参会人员不在需要进行送递文件等重复工作，大大提升办公效率。</p>\r\n<p>\r\n	　　通过在活动中的模拟使用，景保玉还认为使用E人E本无纸化会议系统办公，能够让使用者切实感受到在商务办公过程中的便捷之处。景保玉说：&ldquo;E人E本无纸化会议系统将办公场景进行了很好的在线模拟，比如现场的会议签到、信息推送&rdquo;，另外E人E本无纸化会议系统还可以快速的查收信息、进行文档查阅和修改、传输文档进、无线投影，通过这些功能的使用，对日常办公将会有明显的效率提升。</p>\r\n<p>\r\n	　　在今年两会的积极倡导下，节俭务实的会议之风扑面而来，正在改变着各级政府的办公和会议模式。在此前河南省政协十一届一次会议上，无纸化办公就已经开始逐步实现：委员提案不再通过纸质形式提交，提案组事先提供了电子邮箱，委员只需要将自己的提案发到这个邮箱中即可。</p>\r\n<p>\r\n	　　在中央及各级政府推进无纸化办公的过程中，网络安全问题同样成为关注的焦点。纸质文件有便于确认接收和保密等特点，而很多保密性较高的文件也不适宜通过电子邮件发送。但是通过使用在无纸化会议系统中，领导办公可以与工作的各环节紧密结合，动态电子签名认证保证了领导签名内容的不可更改性和来源的真实性。</p>\r\n<p>\r\n	　　而用户则可以利用动态电子签名认证实现可靠的身份确认功效，比传统键盘密码更安全、更有效。用动态签名认证来替代传统密码口令验证，极大增加系统中信息的安全性，而且使用更加方便，更加容易。景保玉也认为，E人E本T7在满足无纸化的办公方面可以很好的胜任，在未来无纸化办公方面值得企业和政府部门采购。</p>\r\n<p>\r\n	　　据2014年最新统计数据显示，如果两会期间能够使用E人E本无纸化会议系统，那么用纸量就可以节省2,302,232张，用纸费用则能够节省1,064,348元，工作效率直接提升83.7倍。景保玉说，通过推进E人E本无纸化会议系统能够真正节省更多的纸张资源和政府资金。减少纸张的消耗、顺应节俭与务实的会议之风，E人E本无纸化会议系统能够真正做到让无纸化办公成功落地。</p>\r\n<p>\r\n	　　通过实际体验，景保玉认为E人E本T7商务平板与前代相比，在设计、工艺和性能等方面都得到了较大程度的提升，在很多方面都实现了创新；此外T7的用户体验也另使用者感到非常满意。</p>\r\n<p>\r\n	　　虽然无纸化办公已经成为当前的发展趋势，但是景保玉也提到这个过程的推进和落实依然需要上层领导的重视和大力支持。&ldquo;有了产品和应用需求，相信未来无纸化办公必将落到实处&rdquo;，景保玉如是说。在这个过程中，相信E人E本商务平板及E人E本无纸化会议系统将会起到积极的推动作为，助力无纸化办公的真正落地。</p>', '科技', '', '光明网-IT频道', '', '2014-03-07'),
	(124, '跨越200万用户门槛 凡科网领军自助建站', '', '<p>\r\n	作为自助建站领域里的一股强劲势力，凡科网在迎来了其3周年的企业庆典的同时，用户量也一路飙升，突破200万大关。从1到200万的跨越，里面凝聚的，是凡科网团队比这个数字鸿沟更深远的心血与信念，成就了今天一个得到认可的优质品牌。凡科网，在一步一脚印中，壮大成为今天的自助建站领域领军者。</p>\r\n<p>\r\n	用专注创造优越的产品体验</p>\r\n<p>\r\n	凡科网能够在众多自助建站公司中脱颖而出，其取得成功的首先一个秘诀，就在于创造出优越的产品体验。好的产品体验，能够深入人心，能够真正让客户产生情感上的认同，让客户与产品擦出火花，由此产生口碑传播。因此，做好产品体验尤为重要，而且是要从客户的角度去做好产品体验。</p>\r\n<p>\r\n	相比资金充足的大企业，中小企业明显有点&ldquo;囊中羞涩&rdquo;，而且客户都怕麻烦，把所有事情都给他们做简单了，他们是最开心的。基于这样一个目标客户群体的属性，凡科网在长久以来在建站产品上都专注于做简做优，在省力的同时，也要让建站做得省时更省钱。针对企业建站的特性，把每一个自助建站程序，都做成体验度高，实用性强的效果。同时，凡科网为客户开通了电话、在线客服、微博、邮件等多个咨询与反馈渠道。凡科网所有功能的开发与更新，都集思广益，重视每一个客户的建议和需求，并且坚持每周一次的功能体验更新频率，力求最大程度的响应客户的需求。凡科网自助建站，从根本上满足了无数中小企业想追赶企业科技化和创新化的朴实愿望。</p>\r\n<p>\r\n	把服务至上作为最高的态度</p>\r\n<p>\r\n	凡科网成功的另外一个秘诀，还在于其始终如一的服务至上态度。除了拥有一个专业创新的先锋技术团队，凡科网还有7x12小时在线为客户解答所有建站问题的后盾客服团队。每一个功能和模块的操作，都会手把手的指导用户，让客户在零技术的情况下也能顺畅轻松的自助建站。相比于其他建站公司在购买售后才会提供的使用咨询服务，凡科网更愿意责无旁贷的让其免费的用户也享受到全面贴心的服务。纵观各个自助建站公司，对于此种坚持对每个客户都平等、诚挚的服务态度，没有谁能做到，除了凡科网。</p>\r\n<p>\r\n	诚信低调赢来了品牌的肯定诚信必不可少，凡科网诚信低调的作风，唤来的，是一股对凡科网信赖支持的巨大客户力量，这也是凡科网成功的第三个秘诀。凡科网坚持兑现和客户的承诺，提供贴心的权益保障，在国内，它是唯一一个能做到购买7天内无条件退款、30天网站不收录也能全额退款的公司。这一份对保障客户权益的坚定，赢来的，自然是客户的认可，客户的信赖，及至对凡科网企业品牌的肯定。</p>\r\n<p>\r\n	正是在这样的一种对客户、对企业自身的正直、开放、敬业的价值观下，凡科网的自助建站方式才能与传统建站方式相匹敌，并且在自助建站的领域里独占鳌头。目前，凡科网的注册用户量已超过200万，这瞬猛的发展势头肯定还会以雄赳的姿态不断增长，在日后的未来，凡科网会继续完善与创新，助力客户企业不断发展，和客户共同成长。</p>', '互联网', '', 'IT168', '', '2014-03-07'),
	(125, '企业网站浪潮兴起 自助建站契机良好', '', '<p>\r\n	　　根据CNNIC在7月24号最新发布的消息称：中国网民数已经达到了2.53亿，已经超越美国成为了全球第一。2008上半年，中国互联网用户互联网消费总规模达2560.7亿元，增长速度进一步加快。DCCI2008上半年测量数据显示：08上半年中国互联网用户互联网消费2560.7亿元，同比增长58.2%。互联网消费总规模增长的主要原因在于中国互联网有效受众规模的快速增长以及人均网络消费的进一步提高。DCCI 预计，2008年全年互联网消费总规模将增长至5874亿元，比07年增长47.3%。</p>\r\n<p>\r\n	　　随着我国网民人数的剧增，政府大力推进信息化的发展，中小企业也意识到建立企业网站，进行网络营销的重要性，预示着中国未来网络营销良好的发展前景。艾瑞咨询预计到2011年中国中小企业的数量将达到4660万，其中拥有企业网站的企业数量仅为363万家，巨大的发展空间，给智能建站服务商提供了良好的契机。</p>\r\n<p>\r\n	　　而对于迫切需要进行网上宣传，却因资金的缺乏，又不能投入较大成本建站与维护的企业来说，企业自助建站不失为一个行之有效的低成本建站方案。自助建站能够不需请程序员和网页设计师，即时可看到网站的最终效果，并且操作维护简易，自己可以随心所欲自由更新自己的网站。</p>\r\n<p>\r\n	　　当然，并不是所有的互联网产品服务商都能提供完善的自助建站服务及产品，据笔者了解，国内知名IDC服务商美橙互联(<a href="http://www.cndns.com">www.cndns.com</a>)通过长时间的研发和测试，自助建站系统一经推出就受到了中小企业和个人站长的一致好评。美橙自助建站的特色在于无需上传安装任何程序，即时购买即时开通，具有灵活的网站自定义能力，可随时对栏目页面进行内容更新，网站建立后仍然可随时更换网站外观模版、网站标题等，切换模板，随意选择精美界面，满足各种不同建站需求。目前，只要购买美橙的虚拟主机即可获赠体验智能建站所见即所得的好处(低至168元)。同时，针对一些对网站有多语言需求的用户，不妨可以使用他们内置中、英、日等多语言版本(可自己无限添加语言种类) 的智能建站。</p>\r\n<p>\r\n	　　在IDC企业快速发展的今天，IDC产业以中小型企业为主的现状近期并不会发生根本改变。中小企业仍会是IDC产业中最重要的组成部分，推动着中国IDC产业的发展。但产业的集中化将是一种趋势，各个行业都在面临洗牌。IDC服务商只有不断提高的服务质量需求和网络安全需求方面满足市场，才会赢得长期稳定发展。</p>\r\n<p>\r\n	相关文章：</p>\r\n<p>\r\n	原文出自【比特网】，转载请保留原文链接：<a href="http://net.chinabyte.com/408/8276908.shtml">http://net.chinabyte.com/408/8276908.shtml</a></p>', '互联网', '', 'IT世界网', '', '2014-03-07'),
	(126, '企业网站模板应用也可以高品质', '', '<div class="content">\r\n	<p>\r\n		　　互联网发展到现在已经非常成熟，越来越多的企业建设自己的网站，通过互联网宣传推广企业的产品。时代在不断发展，传统的下线宣传推广方式已经不能满足企业的发展，运用新的互联网推广模式是企业宣传推广产品的有力手段。</p>\r\n	<p>\r\n		　　建设自己的网站，大多企业选择企业网站模板搭建，企业网站模板就是具有固定的网站风格并配合特定的企业网站管理系统而使用的网站风格程序。我们晓风软件建设网站就是运用网站模板制作的，也可以做出高品质的手机彩票软件产品营销站。</p>\r\n	<p>\r\n		　　企业网站模板分为静态模版(纯html)和动态模版(ASP/PHP/.NET/JAVA)。企业网站静态模板可以脱离网站管理系统而单独使用;动态模版不可以脱离网站管理系统而单独使用，不同行业的企业网站管理系统的企业网站模板不能通用。</p>\r\n	<p>\r\n		　　大部分人认为用模板建设就是底价、低品质、无技术含量的，其实事实并不是如此。从我们的手机彩票软件的网站建设中，我就有深刻的体会。当然如果一个企业有实力和能力聘请专业的设计师进行设计网站，那么这样的成效是最好的。但是一般企业站建设量不多，企业成立这样一个设计团队要花很大的成本，企业网站模板的选择就能解决这样的问题。</p>\r\n	<p>\r\n		　　由于企业网站建设市场长期以来都处于一个参差不齐的混乱局面，建设一个企业网站无论从技术、价格和风格都没有一个固定的标准，进而大部分人都误认为模板建站就是低品质代名词。而真正的企业网站模板恰恰确实高品质、高技术含量的建站利器。</p>\r\n	<p>\r\n		　　下面我从这些年用模板建设的经验与大家分享下心得</p>\r\n	<p>\r\n		　　1、网站模板介绍</p>\r\n	<p>\r\n		　　目前市场上有很多公司自行开发的网站模板，几个比较大的网站上也经常能够看到一些国外(欧美，韩国)的模板，当中比较有代表性的，在美国有较大影响力的当属怪兽模板。我在手机彩票软件http://www.x-x.cn/产品站建设中，大多用的是怪兽模板，因为怪兽模板开发了WordPress很多CMS网站模板包括joomla，WordPress ，magento ，drupal ，mambo 等,以及设计精美的ZenCart,magento,oscommerce网店系统等目前市场上最流行各种类型各种行业的的网站模板。</p>\r\n	<p>\r\n		　　国内企业模板比较常用的有满佳乐成品网站、MetInfo企业网站管理系统、织梦等，其中满佳乐成品网站在企业建站做的非常专业，模板制作非常灵活实用。我刚接触建设系统，还在学习阶段的时候，我是用的织梦建站系统建设手机彩票软件的，因为织梦的建设系统比较简单，新手的话可以考虑用这个系统。</p>\r\n	<p>\r\n		　　2、网站模板建站的好处</p>\r\n	<p>\r\n		　　企业网站模板一般对个人来说是没多大效果的，可以用来当做个人的网站;但对于企业来说，企业网站模板的存在，不但可以节省一部份的资金，减少企业开支，更能让企业站在自己的角度思考，哪些企业网站模板才合适企业用。如我们晓风软件企业要建的营销产品站需非常，手机彩票软件就有3个，还有许多其的产品需建营销站，企业网站模板解决了我们建站难的问题。</p>\r\n	<p>\r\n		　　所以，企业网站模板成为了企业建站的最好选择，也无需要花费人力在设计上，无需要思考如何设计，怎么设计合适企业的网站，只要直接浏览全部已完成的企业网站模板，看到、对比一下企业文化，按企业的需要直接选择企业网站模板就完事了，可以谈得上是方便、直接特点。</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '互联网', '晓风', '彩票网', '', '2014-03-07'),
	(127, '网站建设误区：关于模板、自助与定制网站', '', '<p>\r\n	经常有企业客户向笔者咨询这样的问题：我们花了很大的成本建成了网站，并且也有专业的运营推广团队进行网站优化，但是为什么我们公司网站的排名总是做不上去?笔者按照正常的网站检测流程，从网站定内容、标题、关键词、URL、外链等等基本优化指标进行检测，也没有发现任何的问题，不存在网站关键词堆砌、URL重复、网站内容低质量等容易导致降权和K站的常见现象。</p>\r\n<p>\r\n	网站内容和外链没有问题，就把问题归于百度的&ldquo;误杀&rdquo;并不妥当，本着为客户解决问题的目的，我们对网站的建站程序、代码进行检查，发现一个很容易让人忽视的问题：这个网站采用了模板建站，虽然表面经过了比较优秀的设计，但是其网站代码属于直接复制，也就是我们常说的模板站，同质化比较严重，简单的讲就是网上其实有成千上万个同样的网站，百度就不会喜欢这样的网站。</p>\r\n<p>\r\n	鉴于这样的现象，就很有必要分享一些企业网站建设的常见误区，尤其是网站建设的开始阶段，这里就需要对模板建站、自助建站以及个性化定制网站进行详细说明。</p>\r\n<p>\r\n	<strong>模板建站的弊端</strong></p>\r\n<p>\r\n	如果站在客户的角度，模板站就是一个带有贬义的词，形容一个网站低质劣造，所以一般企业很少会在明白模板建站弊端的时候，去选择这样的方式进行建站。关于模板建站，可以看一下这方面的要点分析：</p>\r\n<p>\r\n	1、 模板建站之所以盛行，价格低廉绝对不是主要原因。</p>\r\n<p>\r\n	2、 客户误以为模板站就是网站建设的简易流程</p>\r\n<p>\r\n	3、 模板建站所谓的成千上万个模板，其实是同一个模板的不同造型，本质上网站代码相同</p>\r\n<p>\r\n	4、 大部分模板都是网上直接下载的，风险大、不安全</p>\r\n<p>\r\n	5、 模板建站同质化严重，不利于SEO优化</p>\r\n<p>\r\n	笔者总结出模板建站市场火热的原因：客户在不了解网站建设的情况下，误以为或者被建站公司业务人员所误导，选择了这种简单而又省钱的建站模式，客户的本质是希望有一个高质量网站，而非&ldquo;模板站&rdquo;。</p>\r\n<p>\r\n	<strong>被夸大了的自助建站</strong></p>\r\n<p>\r\n	随着模板建站的弊端渐渐显露出来，一种新的网站建设模式出现：会打字就会建站。自助建站一般依靠自己开发的网站程序，让客户自己动手进行简单的网站制作，就像打造自己的博客、轻博客网站一样方便。每个建站公司的自助建站往往采用不同的建站系统，这略微改进了模板建站的同质化问题。</p>\r\n<p>\r\n	自助建站依赖于服务商的技术，企业可以轻松拥有自己动手DIY的网站，不需要自己管理服务器，也不需要进行设计，功能多、花钱少、性价比高。</p>\r\n<p>\r\n	当然，有优点也一样有缺陷。</p>\r\n<p>\r\n	1、网站控制权有限制，一般自助建站有使用年限，到期之后不在续费，网站的数据就会被清空。</p>\r\n<p>\r\n	2、没有独立空间，访问速度慢。</p>\r\n<p>\r\n	3、网站收录情况较差，依赖于自身高质量的内容</p>\r\n<p>\r\n	4、简单的操作是以牺牲掉高端的设计风格为前提的，只能选择固有的模板</p>\r\n<p>\r\n	5、实际自助建站的费用要远远高于一次性付费建站。</p>\r\n<p>\r\n	现在在企赢001建站平台上，也出现一种所谓的云建站系统，其实也属于自助建站的风格，一期望解决自助建站无法个性化、模板同质化的问题，适合具有一定技术和美工能力的人使用。</p>\r\n<p>\r\n	<strong>个性化定制网站的误区</strong></p>\r\n<p>\r\n	吐槽完模板建站和自助建站，再来批判一下某些所谓的高端个性化定制网站。笔者完全赞成企业选择个性化定制网站，也倡导有实力的企业或者有互联网意识的企业选择定制网站的形式。但是个性化定制网站并不是你说是，他就是的，需要尤为注意：</p>\r\n<p>\r\n	1、 一些网站定制仅仅是增加了页面设计，但是代码依旧模板化。纯粹属于模板建站的升级版本。</p>\r\n<p>\r\n	2、 没有个性化网站策划方案，何来个性化网站建设?个性化定制网站必须有相应的网站策划方案，这个方案可以由企业自己提供，也可以由建站公司完成，或者专业机构出具的。</p>\r\n<p>\r\n	3、 定制网站是根据客户要求进行的网站开发，包括重新策划、方案书写、重新设计、重新功能开发。省略任何一个步骤，都不属于定制网站。</p>\r\n<p>\r\n	<strong>总结：</strong></p>\r\n<p>\r\n	企业网站的目的无疑都是希望赚钱或者品牌塑造，但是一旦企业在建站过程选择了不理想的建站公司，就会对网站以及互联网市场失去兴趣，这一点从成千上万个已经荒废了的企业网站身上就可以看的出。</p>\r\n<p>\r\n	作者：企赢001尹滨，欢迎分享交流，转载请注明!</p>\r\n<p>\r\n	<strong>注：</strong>相关网站建设技巧阅读请移步到<a href="http://www.chinaz.com/web/" target="_blank">建站教程</a>频道。</p>', '互联网', '', '中文互联', '', '2014-03-07'),
	(128, '贵阳银行网上交易量大幅增长 多方式为网上支付“保驾护航”', '', '<p>\r\n	　金黔在线讯（本网记者 陈文坤 郭邱磊）记者日前从贵阳银行获悉，该行2013年省内网上银行交易笔数为64万笔，交易金额达60.96亿元，与2012年相比增幅290%；2013年全省网银客户增长7.3万户， 与2012年相比有了大幅增长。</p>\r\n<p>\r\n	　　据贵阳银行电子银行部总经理助理刘畅介绍，面对日益严峻的网上支付安全问题，贵阳银行通过软硬集合的方式为储户保驾护航。储户可以到柜台申请二代液晶屏USBKEY、动态令牌、手机短信认证、SD卡等方式保护自身账户安全。</p>\r\n<p>\r\n	<!--advertisement code begin--><!--advertisement code end--></p>\r\n<p>\r\n	　　随着移动支付端的迅猛发展，手机支付呈现着从无卡到有卡，从线上到线上线下想结合的变化趋势。面对储户担忧的手机支付问题，单纯的客户端已经无法保障储蓄的安全需求。贵阳银行针对客户的需要，在移动支付端上进行创新，先后推出黔e通手机银行、NFC手机银行卡等方式，为移动支付端客户提供安全的便捷支付方式。</p>\r\n<p>\r\n	<strong>　　相关链接：</strong></p>\r\n<p>\r\n	　　&ldquo;黔e通&rdquo;手机银行系列产品是由贵阳银行推出的面向广大客户的一款手机金融超市性质的移动支付产品。客户通过手机可以实现银行账户的查询、转账、缴费等功能，还可实现购物、购买飞机票、火车票、彩票、电影票等多种移动支付功能，具有安全、快捷、简便的特点，目前在安卓、苹果等多种手机上均可以运用。</p>\r\n<p>\r\n	<!--function: content() parse end  0ms cost! --></p>', '互联网', '陈文坤 郭邱磊', '金黔在线', '', '2014-03-07'),
	(129, '支付宝钱包试水NFC功能 正研究多种支付方式', 'upload/images/1394190699250.jpg', '<p>\r\n	核心提示： 传闻已久的支付宝钱包NFC功能日前正式揭晓，支付宝钱包最新安卓版本已经支持NFC支付，不过并没有得到支付宝方面的大力推广，支付宝也正研究包括iBeacon在内的多种支付方式。</p>\r\n<p>\r\n	每经实习记者 史青伟 发自上海</p>\r\n<p>\r\n	传闻已久的支付宝钱包NFC功能日前正式揭晓，支付宝钱包最新安卓版本已经支持NFC支付，不过并没有得到支付宝方面的大力推广，支付宝也正研究包括iBeacon在内的多种支付方式。</p>\r\n<p>\r\n	据《每日经济新闻》记者了解，由于安全性、成本及应用领域狭小等原因，NFC一直在夹缝中求生存。此次支付宝试水NFC对于该领域或有推动作用，不过从目前看来，NFC想要快速发展还面临非常多的障碍，前景并不乐观。</p>\r\n<p>\r\n	三方角力NFC支付</p>\r\n<p>\r\n	日前，支付宝8.0版本新增了对北京交通卡一卡通的NFC支持，用户可以通过支付宝钱包读取公交卡信息，并进行支付。</p>\r\n<p>\r\n	不过，支付宝钱包的NFC功能也仅能在支持NFC功能的手机上使用，现阶段支持&ldquo;NFC&rdquo;功能的手机机型包括三星等。</p>\r\n<p>\r\n	据了解，用户需要将公交卡靠近手机背面，支付宝钱包将自动打开，并进入交通卡界面，用户可以直接查看包括余额、发行商、卡号等卡内信息，也可以查看最近10笔交易记录。</p>\r\n<p>\r\n	除此之外，支付宝钱包还能通过NFC读取银行卡信息，可以快速管理IC卡，实现卡片与支付宝的高度互联，完成转账、充值、交易查询等多种使用功能。</p>\r\n<p>\r\n	据悉，这是作为网络支付公司的支付宝首次试水NFC功能。不过，支付宝相关人士在接受《每日经济新闻》记者采访时表示：&ldquo;严格来说，支付宝NFC功能并不是一个产品，后台很多功能被关闭，支付宝方面会增加新的功能范围和合作商家，改善用户体验。&rdquo;</p>\r\n<p>\r\n	随着支付宝钱包的加入，NFC支付的竞争将更为激烈。3月5日，中国电信天津公司与天津城市一卡通共同签署《战略合作框架协议》，预计在今年内，中国电信用户只要有具备NFC功能的手机，在办理专用卡后就可以实现刷手机乘车或在一卡通签约商户刷手机消费。</p>\r\n<p>\r\n	作为NFC三方角力的银行也不甘示弱，2月12日，<a href="http://finance.ifeng.com/app/hq/stock/sh600000/" target="_blank" title="浦发银行 600000"><font color="#004276">浦发银行</font></a><span id="sh600000_hq">[<span class="Agreen">-0.80%</span> <a href="http://app.finance.ifeng.com/data/stock/tab_zjlx.php?code=sh600000" style="font-weight: normal" target="_blank">资金</a> <a href="http://star.finance.ifeng.com/stock/sh600000" style="font-weight: normal" target="_blank">研报</a>]</span>联手中国移动推出&ldquo;中移动浦发手机支付地铁应用&rdquo;，用户可以通过手机刷卡乘坐地铁，不仅如此，该产品可在全国已有的86万余台具备银联&ldquo;闪付&rdquo;标识的POS机上直接进行小额支付。</p>\r\n<p>\r\n	NFC前景难乐观</p>\r\n<p>\r\n	对于支付宝是否会大力拓展NFC支付，上述支付宝人士告诉《每日经济新闻》记者，支付宝对于NFC和iBeacon、LBS（位置服务）都在研究，技术方面不存在太大问题，真正商业化需要解决成本及普及度，无法断言NFC代表未来。其透露，公司手机淘宝部门即将与相关方合作试用iBeacon支付。</p>\r\n<p>\r\n	支付宝作为世界上最大的移动支付公司刚试水NFC业务，也反映出NFC在推广方面的艰难。业内人士告诉记者，即便是新技术应用最广泛的美国，移动支付的主流依然是Square刷卡器以及Paypal账户支付，而采用近场支付的谷歌钱包发展并不顺利。</p>\r\n<p>\r\n	究其原因，还在于很多手机并不支持NFC，此外还包括NFC产业参与方众多，无法协调他们的利益等等。</p>\r\n<p>\r\n	支付宝产品经理李伟此前在一次媒体沟通会表示：&ldquo;NFC需要交易双方在前期的硬件配置上进行投入和升级，对消费者而言则是一笔不小的开销。&rdquo;</p>\r\n<p>\r\n	据了解，一个NFC芯片价格为5<a href="http://app.finance.ifeng.com/hq/rmb/quote.php?symbol=USD" target="_blank"><font color="#004276">美元</font></a>，前期手机厂商投入就需要不小的成本，而在NFC应用场景极为狭小的情况下，用户并没有很强的支付意愿。而运营商采用为用户换SIM卡的方式，依然无法回避成本难题。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	除此之外，NFC产业参与者众多，无法达成有效的合作也是原因之一。上述支付宝人士告诉《每日经济新闻》记者：&ldquo;以日本为例，日本NFC之所以发展较好，原因是日本有着一些财团，比如软银拥有运营商和银行，中间环节被打通，可以高效推进。&rdquo;</p>\r\n<p>\r\n	新的技术如二维码、声波、蓝牙在安全性和成本方面具有很大优势，蓝牙已经是移动设备的标配，相比NFC，李伟更看好蓝牙支付。</p>\r\n<p>\r\n	而手机巨头苹果公司的举动似乎也在验证的李伟的判断。现阶段，苹果iBeacon应用已导入全美多家超市，支付公司PayPal也积极投入Beacon应用实验，目前美国境内几家商店已尝试导入PayPal Beacon技术。</p>\r\n<p>\r\n	上述支付宝人士告诉记者：&ldquo;支付宝钱包安卓用户安装得多，但单个用户的消费金额，苹果用户显著高于安卓。&rdquo;这意味着苹果用户更愿意尝试移动支付方式消费，苹果公司的选择对于移动支付方式影响巨大。</p>', '互联网', '', '每日经济新闻', 'recommend', '2014-03-07'),
	(130, '微信公众平台支付功能开通 网上网下两种方式实现支付', '', '<p>\r\n	通过微信，可以买更多种东西了！3月4日晚，微信团队在官网发布消息称：微信公众平台支付功能已正式开放申请，已开通公众号的开发者可登录公众平台申请App支付功能。这意味着，此前只有少量商家试水的微信支付，终于迎来了向认证公共账号全面开放的日子；而此举也意味着微信走出了商业化的重要一步，移动端的电商航母或将出现。</p>\r\n<p>\r\n	　　目前，微信支付确定将面向综合商城、服饰鞋包、运动户外、美妆用品、家装家纺、汽车及配件、数码家电、母婴、图书等近十大类目开放。本地生活服务类商户，并不在此次开放申请范围。</p>\r\n<p>\r\n	　　据说微信支付对所有类目商户的费率均为0.6%，低于支付宝。微信方面表示，由于目前微信支付使用的是B2C即时到账接口，所以还暂不支持C2C的担保交易类型。</p>\r\n<p>\r\n	　　开放后的微信支付，共有两种主要支付方式：一种是在微信内打开网页购买商品，再调用微信支付；另一种是线下商家为商品生成二维码，用手机扫码支付即可。也就是说，用户既可在公众账号中直接买东西，还能在百货店里扫描条形码直接支付。</p>\r\n<p>\r\n	<br />\r\n	&nbsp;</p>', '通信', '', '上海市人民政府', '', '2014-03-07'),
	(131, '传易迅等腾讯电商将割让京东 腾讯微购物并入微信', '', '<p>\r\n	凤凰科技讯 3月7日消息，腾讯入股京东的传闻渐渐接近尾声。今天下午，腾讯电商内部人士参与沟通会后透露，腾讯微<a href="http://travel.ifeng.com/theme/shopping/list_0/0.shtml" target="_blank">购物</a>将并入微信，腾讯拍拍、<a href="http://car.auto.ifeng.com/series/1785" target="_blank">QQ</a>团购、易迅等线上电商并入京东。</p>\r\n<p>\r\n	今天上午有消息称，京东已经有人员开始入驻易迅，对易迅的仓库、库存以及相关资产做盘点。下午，腾讯电商于深圳总部开会，确定腾讯电商与京东的合并方案。</p>\r\n<p>\r\n	电商分析师鲁振旺认为，腾讯将拍拍+易迅网打包给京东，自己为微信也建立了最具有支撑点的网购支付入口，未来微信搞移动网购平台的希望就更大了一些，微信支付开放之后，会形成移动网购小生态，跟手机淘宝竞争，有了腾讯入股，京东重新IPO，腰板更硬，又有了腾讯在PC和移动端的流量资源，拍拍+京东可对抗淘宝+天猫。</p>\r\n<p>\r\n	易观数据显示，2013年第二季度，天猫、京东、QQ网购、易迅网的市场份额分别为48.9%、18%、3.3%和1.9%。腾讯拍拍、QQ团购、易迅等线上电商并入京东后，其市场份额将达到23.2%，接近天猫的一半，占据市场第二位。</p>\r\n<p>\r\n	但该消息还未谈到腾讯在京东资产中的占股。此前有媒体报道称，腾讯在此轮资本合作之后拿到京东20%的股权，参照京东IPO申请中估值75亿美金计算，对应股权价格在15亿美元左右。但又有消息传腾讯其实只投资了5亿美金，按推算，占股比例则在6%-8%左右。而最近的，自媒体人程苓峰又透露，腾讯占比京东股份为16%。</p>\r\n<p>\r\n	不过，无论最后确定是哪个占股比例，刘强东都不会因此失去对京东的控制权。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<div class="embedHzh" id="embed_hzh_div" style="border-bottom: #cdcdcd 1px solid; border-left: #cdcdcd 1px solid; padding-bottom: 4px; margin: 10px 20px 10px 0px; padding-left: 4px; width: 200px; padding-right: 4px; display: inline; float: left; height: 300px; clear: both; overflow: hidden; border-top: #cdcdcd 1px solid; border-right: #cdcdcd 1px solid; padding-top: 4px">\r\n	<iframe frameborder="0" height="300" id="ifm_embed_hzh_div" scrolling="no" src="http://www.ifeng.com/ssi-incs/demo/140102-taobao-neiqianHZH01-sucai-V3.html" width="200"></iframe></div>\r\n<p>\r\n	招股书显示，刘强东代表高管团队持有公司18.1%股份。在IPO之前，京东CEO刘强东通过位于英属维京群岛的公司Max Smart Limited持有京东369,564,379股普通股，持股比例为18.4%。在IPO之后，这部分股份将成为B级普通股。</p>\r\n<p>\r\n	另外，HHGL 360Buy Holdings, Ltd.持有15.8%股份，老虎基金持有最多的22.1%股份，DST持有11.2%，Best Alliance International Holdings Limited持有9.5%，Fortune Rising Holdings Limited持有5.3%（刘强东以个人单一股东持有），Kingdom 5-KR-233, Ltd. managed funds持有5%，红杉资本持有2%。</p>\r\n<p>\r\n	按照京东的AB股规则，刘强东持有的B类普通股，其1票拥有20票的投票权。这样一来，刘强东虽然持股比例只有23.9%，但其投票权比例却高达86%。</p>\r\n<p>\r\n	据悉，腾讯与京东的合作协议将会在3月10日正式宣布。</p>', '互联网', '杨阳', '凤凰科技', 'recommend', '2014-03-07'),
	(132, '沪深股市大跌 沪指失守2000点', 'upload/images/1394454218625.jpg', '<p>\r\n	&nbsp;<font color="#0000ff">3月10日，一名股民在西藏同信证券北京陶然亭路证券营业部关注股票行情。当日，沪深股市大跌，沪指失守2000点。上证综指报收于1999.06点，跌幅为2.86%；深证成指报7118.44点，跌幅为2.87%。新华社记者 王全超 摄 </font></p>\r\n<p align="center">\r\n	<img src="http://www.gov.cn/xinwen/site1/20140310/1c6f6506c5d51487c2d902.jpg" title="   3月10日，股民在上海一家证券营业部内关注股市行情。新华社发 （丁汀 摄）  " /></p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp;&nbsp;<font color="#0000ff">3月10日，股民在上海一家证券营业部内关注股市行情。新华社发 （丁汀 摄） </font></p>\r\n<p align="center">\r\n	<img src="http://www.gov.cn/xinwen/site1/20140310/1c6f6506c5d51487c2e703.jpg" title="  3月10日，股民在上海一家证券营业部内关注股市行情。新华社发 （丁汀 摄）" /></p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp;&nbsp;<font color="#0000ff">3月10日，股民在上海一家证券营业部内关注股市行情。新华社发 （丁汀 摄）</font></p>', '财经', '', '新华社', 'recommend', '2014-03-10'),
	(133, '三江腹地物流“老大”', '', '<p>\r\n	　本报讯&nbsp;&nbsp;&nbsp; &nbsp;农垦建三江管理局物流园去年累计发储货物超千万吨，其中为管理局外的客户周转货物350余万吨，成为名副其实的三江腹地物流&ldquo;老大&rdquo;。</p>\r\n<p>\r\n	　　建三江管理局交通运输局投资七千多万元，于2012年建成了一座集汽修检测、货物仓储和信息共享于一体，占地约11万平方米、拥有近百个大型现代化仓储库房的综合物流园区。并在辖区的8个大型国营农场（上市公司）设立了分站，不断将业务辐射到周边的农场、作业区和乡村，形成了一个以物流园为中心、8个分站为功能性服务单元的物流保障网络，物流服务覆盖整个三江地区。</p>\r\n<p>\r\n	　　近年来，该物流园又与国内多家大型知名物流企业签约合作，实现了货物流通横向与纵向有机对接，进一步拓展了地区物流业务，并凭借着独特的地缘优势和完备的软硬件以及完善的科学管理，货物周转量逐年攀升。从去年截至目前，已为客户发送和储存货物1142万吨，储藏水稻份额达275万吨。</p>\r\n<div style="display: none">\r\n	&nbsp;</div>', '物流', '姜久明 董桂书 吴利红', '黑龙江日报', 'recommend', '2014-03-13'),
	(134, '长城汽车南非经销代理商被当地物流公司控股', 'upload/images/1394698747234.png', '<p>\r\n	长城最近在南非发布了小型SUV哈弗M4</p>\r\n<div style="text-align: center">\r\n	&nbsp;</div>\r\n<p>\r\n	盖世汽车讯 3月上旬，南非物流公司Super Group集团宣布，收购长城汽车南非公司（Great Wall Motors SA）50.1%股权，后者为长城汽车在南非的经销代理商。</p>\r\n<p>\r\n	Super Group集团未公布此次股权收购价格，不过透露交易生效日期为2014年3月1日。长城汽车南非公司原先96%股份为董事长Tony Pinfold持有，此次交易完毕后，Super Group集团将取代其最大股东地位。</p>\r\n<p>\r\n	长城汽车7年前进入南非市场，迄今已经通过长城南非累计销售了超过50,000辆汽车，仅今年前两个月就销售了779辆汽车。</p>\r\n<p>\r\n	Super Group集团并非首次投资涉及中国车企。2006年，该集团获得中国北方车辆公司在南非销售公司Norinco Motors的少数股权，并帮助后者在彼得马里茨堡（Pietermaritzburg）兴建Powerstar卡车组装厂。</p>', '汽车', 'Martin Shi', '盖世汽车网', 'recommend', '2014-03-13'),
	(135, '皖北徽商物流港项目集中开工仪式举行', '', '<p style="white-space: normal; text-transform: none; color: rgb(49,49,49); word-spacing: 0px; font: 14px/22px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;3月12日上午，&ldquo;2014走进淮上&rdquo;招商项目集中签约暨皖北徽商物流港等项目集中开工仪式在淮上区举行。市领导王诚、张孝成、高萍、徐超，市人大常委会秘书长赵同良、市政协秘书长乔桂元出席。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(49,49,49); word-spacing: 0px; font: 14px/22px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;中国物流与采购联合会副会长贺登才、安徽徽商集团总经理刘光景、安徽力源集团董事长宋在付和签约、开工企业代表等应邀出席。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(49,49,49); word-spacing: 0px; font: 14px/22px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;市委常委、常务副市长张孝成在致辞中说，市委、市政府一直高度重视和支持淮上区的发展，始终把淮上区开发发展摆在全市经济发展的重要位置。区划调整十年来，淮上区紧紧围绕&ldquo;新兴产业集聚区、综合实力最强区、宜居宜业新城区&rdquo;发展目标，坚持&ldquo;生态立区、工业强区和商贸兴区&rdquo;战略不动摇，抢抓机遇，狠抓落实，工业化、城市化进程不断加快，各项主要经济指标取得长足进步。希望淮上区在新的起点上，按照市委市政府的安排部署，不断调高发展目标，继续拉开发展框架，积极为入驻项目的建设发展创造宽松环境，整合提升淮上区产业规模和档次。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(49,49,49); word-spacing: 0px; font: 14px/22px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;当天上午，皖北徽商物流港、义乌国际商贸城加工区、特步(安徽)产业园二期、安徽上缆防火电缆、安徽美克思节能材料产业园、安徽嘉新特种工程材料、安徽鸿申特种压缩机等13个项目集中开工，普洛斯(中国)投资管理有限公司、上海今上投资管理有限公司等40个招商项目进行了现场签约。其中皖北徽商物流港总站项目为省861计划重点项目，总投资6亿元，致力打造&ldquo;公路港模式升级版&rdquo;以及&ldquo;千里淮河第一大港&rdquo;，探索发展淮河流域航运交易平台，配套发展公路水路联运、航运代理、船舶融资及水上综合服务，努力在省内构建最具竞争力的物流园区体系。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(49,49,49); word-spacing: 0px; font: 14px/22px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(255,255,255); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;随后，应邀出席的百余位客商统一乘车观摩蚌埠工业园、商贸物流园及安置房等开工项目。<span class="Apple-converted-space">&nbsp;</span></p>', '物流', '3月12日上午，“2014走进淮上”招商项目集中签约暨皖北徽商物流港等项目集中开工仪式在淮上区举行。市领导王诚、张孝成、高萍、徐超，市人大常委会秘书长赵同良、市政协秘书长乔桂元出席。', '蚌埠新闻网', '', '2014-03-13'),
	(136, '达州市政府出台加快商贸和物流业发展意见', '', '<p>\r\n	　■到2017年，<em class="abtFlag">全市社会物流总额和增加值年均增长13.5%以上，</em><em class="abtFlag">社会消费品零售总额年均增长17.5%。</em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　■建成一批&ldquo;十亿级&rdquo;重大商贸、</em><em class="abtFlag">物流项目，</em><em class="abtFlag">培育营业额（交易额）超500亿元的骨干企业1户，</em><em class="abtFlag">超100亿元的骨干企业3户，</em><em class="abtFlag">超50亿元的骨干企业4户,超10亿元的骨干企业10户。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　■建成一批支撑区域商贸中心的&ldquo;百亿市场&rdquo;和&ldquo;百亿园区&rdquo;。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　达州市人民政府日前下发《关于加快商贸和物流业发展实现次级突破的意见》（以下简称《意见》），</em><em class="abtFlag">明确了全市加快商贸和物流业发展的总体思路、</em><em class="abtFlag">主要目标、</em><em class="abtFlag">发展重点、</em><em class="abtFlag">扶持政策和保障措施。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　《意见》指出，</em><em class="abtFlag">要按照城乡商贸、</em><em class="abtFlag">物流一体化、</em><em class="abtFlag">集群化、</em><em class="abtFlag">专业化和现代化发展战略，</em><em class="abtFlag">坚持科学规划、</em><em class="abtFlag">政策引导、</em><em class="abtFlag">政府支持、</em><em class="abtFlag">市场运作的原则，</em><em class="abtFlag">围绕建设秦巴地区区域商贸、</em><em class="abtFlag">物流中心发展目标，</em><em class="abtFlag">以重大项目为抓手，</em><em class="abtFlag">以培育骨干龙头企业为重点，</em><em class="abtFlag">加快建设区域性商贸、</em><em class="abtFlag">物流集聚区，</em><em class="abtFlag">搭建配套平台，</em><em class="abtFlag">强化商贸集聚、</em><em class="abtFlag">物流辐射、</em><em class="abtFlag">市场带动三大功能，</em><em class="abtFlag">着力构建大商贸、</em><em class="abtFlag">大物流、</em><em class="abtFlag">大市场，</em><em class="abtFlag">全面提升我市商贸、</em><em class="abtFlag">物流产业核心竞争力，</em><em class="abtFlag">为全市实施市域经济&ldquo;842战略工程&rdquo;提供强力支撑。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　《意见》明确，</em><em class="abtFlag">达州市商贸和物流业发展的主要目标是：</em><em class="abtFlag">到2017年，</em><em class="abtFlag">全市社会物流总额和增加值年均增长13.5%以上，</em><em class="abtFlag">社会消费品零售总额年均增长17.5%。</em><em class="abtFlag">建成一批&ldquo;十亿级&rdquo;重大商贸、</em><em class="abtFlag">物流项目，</em><em class="abtFlag">培育营业额（交易额）超500亿元的骨干企业1户，</em><em class="abtFlag">超100亿元的骨干企业3户，</em><em class="abtFlag">超50亿元的骨干企业4户,超10亿元的骨干企业10户。</em><em class="abtFlag">全市商贸、</em><em class="abtFlag">物流业发展规模和水平跨越提升，</em><em class="abtFlag">商贸、</em><em class="abtFlag">物流业次级突破取得明显成效，</em><em class="abtFlag">建设秦巴地区商贸、</em><em class="abtFlag">物流中心总体目标初步实现。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　就加快商贸发展，</em><em class="abtFlag">《意见》指出，</em><em class="abtFlag">要完善区域商贸中心功能载体，</em><em class="abtFlag">推进商品市场与要素市场并进、</em><em class="abtFlag">有形市场与无形市场互补的商品交易市场体系建设，</em><em class="abtFlag">建成一批支撑区域商贸中心的&ldquo;百亿市场&rdquo;和&ldquo;百亿园区&rdquo;。</em><em class="abtFlag">重点加快大型区域性商贸集聚区建设，</em><em class="abtFlag">加快完善现代交易方式、</em><em class="abtFlag">交易功能和交易设施，</em><em class="abtFlag">提高交易能力和水平，</em><em class="abtFlag">形成秦巴地区规模大、</em><em class="abtFlag">档次高、</em><em class="abtFlag">功能全、</em><em class="abtFlag">设施先进的市场群，</em><em class="abtFlag">增强市场的区域集聚力、</em><em class="abtFlag">辐射力和带动力，</em><em class="abtFlag">抢占区域市场制高点。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　就加快物流业发展，</em><em class="abtFlag">《意见》指出，</em><em class="abtFlag">要构建以秦巴（河市）物流园区为依托，</em><em class="abtFlag">各县（市、</em><em class="abtFlag">区）物流中心为基础、</em><em class="abtFlag">若干物流服务站为节点的物流体系，</em><em class="abtFlag">着力建设一批物流集聚区，</em><em class="abtFlag">引进培育一批第三方、</em><em class="abtFlag">第四方物流龙头企业，</em><em class="abtFlag">增强区域物流中心的支撑能力。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　《意见》强调，</em><em class="abtFlag">要积极推进城乡商业中心建设，</em><em class="abtFlag">在中心城区大力发展城市综合体，</em><em class="abtFlag">引导商业服务业集聚发展，</em><em class="abtFlag">建成规模大、</em><em class="abtFlag">功能多、</em><em class="abtFlag">配套设施完善的综合商业服务设施，</em><em class="abtFlag">打造城市亮点，</em><em class="abtFlag">形成商业中心。</em><em class="abtFlag">各县（市、</em><em class="abtFlag">区）县城加快培育一批大型商业零售企业，</em><em class="abtFlag">改造建设一批大型零售商业和服务业设施，</em><em class="abtFlag">建成一批集零售、</em><em class="abtFlag">休闲、</em><em class="abtFlag">餐馆、</em><em class="abtFlag">酒店为一体的现代购物休闲中心，</em><em class="abtFlag">打造县级商业中心。</em><em class="abtFlag">要大力引进高端品牌和知名企业，</em><em class="abtFlag">提升商业档次，</em><em class="abtFlag">增强消费引导力和吸引力，</em><em class="abtFlag">促进区域消费集聚，</em><em class="abtFlag">力争把我市建成区域性购物天堂和时尚消费之都。</em></em><br />\r\n	<br />\r\n	<em class="abtFlagGroup"><em class="abtFlag">　　《意见》还从扶持新建商贸物流项目、</em><em class="abtFlag">支持商贸物流龙头企业、</em><em class="abtFlag">鼓励物流企业达标升级等方面明确了扶持政策。</em></em></p>', '物流', '', '达州市府', '', '2014-03-13'),
	(137, '金台观察：大电商屋檐下 中小物流还有活路吗？', '', '<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	今天早上看到宅急送、星晨急便的创始人陈平写的一篇文章《跳出物流看物流》，里面提到最近一年物流行业的翻天覆地变化，他指出当下仓储物流行业一个趋势就是大电商要控制仓储物流配送网络，一个挑战就是中小商家不肯使用它的仓储体系怎么办，另一个挑战是物流干支线如何降价提速。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	为什么商家不肯使用中小物流的仓储体系，这需要从源头来捋才能把本质剖析明白。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	在零售业整条的购买链中，终端商几乎很难让出咨询沟通、满意度打分/投诉处理、晒单/分享/推荐等环节，这些用以维系客户的流程关乎终端商的核心竞争力。余下来可以外包的，就只有拣货、包装、质检、物流、配送这些环节了，目前只有物流配送外包最多，那其他几个环节找谁呢？</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	我国电子商务近10年才迅猛发展，历史遗留的仓储物流提供商参差不齐，有专做仓储物流的国有实力企业（如中储、中铁快运、中国邮政），有自建仓储物流的大型制造商（如一汽、海尔），有同样自建的B2C电商（如京东、1号店），还有随电子商务发展起来的第三方民营物流（如三通一达、顺丰），当然也有多如牛毛的民间仓库和货运公司，从现代化的大型仓储、自动化设备到肩挑人扛什么都有。一定程度上，这反映的当前行业瓶颈不在于仓储物流资源是否稀缺，而在于市场一盘散沙各自为战。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	怎样利用信息技术、管理、平台的力量来整合这些资源发挥最大的社会价值，这才是共赢但却最难也最有价值事情。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	拣货、包装、质检属于仓储范畴。当前，电子商务两大巨头阿里与京东都在布局这一领域。京东是依仗重金风投自建仓储搭建全新封闭体系，阿里是通过投资合作整合现有社会大仓储物流资源。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	纵观鏖战现状，国内城镇配送、海外购进口配送、冷链食品是下一阶段最集中的战场。阿里的左手日日顺在国内二三线城镇和大物件配送方面占领了相对高地。传闻阿里最近也在和中储物流谈投资合作。中储物流可是国家队，在现代仓储物流硬件方面相当豪华；而且中储还涉及国际货易代理、进口货代，这一下把海外购也布下了棋子。从制造业角度来说，不产生增值的搬运就是浪费。所以阿里又并购了高德地图，这给最优化物流路径提供了最佳数据支撑。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	只有在这样大整合的社会化仓储物流体系内，成本才能平摊最低，而且只有在这样一种投资合作的形式下，才能让松散的社会资源发挥出专业协同的巨大威力而不是同巢挤压，这才是天下中小物流与商家的福音。</p>\r\n<p checkedbycsshelper="true" style="text-indent: 2em">\r\n	（刘兴亮系互联网行业资深观察家，DCCI互联网研究院院长 ；阿朱系《走出软件作坊》作者）</p>', '物流', '刘兴亮 阿朱', '：人民网-财经频道', '', '2014-03-13'),
	(138, '中储股份高送转为定增护航 募资投向物流园物联网', 'upload/images/1394699180078.jpg', '<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&nbsp; 日前中储股份（600787）发布2013年年报，每股收益0.36元，尽管净利润同比下降，但仍推出拟10送2转增8派0.5元的分红方案。而此前一周，公司刚公布拟募资近20亿元的定增方案，定增价不低于10.91元，昨日二级市场最低一度探至11.5元，高送转为定增护航之意凸显。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;募资投向物流园物联网</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;中储股份年报显示，由于主营中生产资料占比较大，受相关产业影响，各业务板块增长面临较大压力。全年每股收益0.36元同比下降24%。不过，年报同时显示，公司开始加大各业务板块向生活资料的倾斜，尤其运输方面，业务扩展至奶制品、商超配送、快消品包装等几大行业，增加附加值高的冷链运输和供应链物流业务。而作为公司物流地产的起步年，去年已完成投资额10.5亿元。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;而今年的突破口就是业务转型，以供应链全程管理为方向，改造传统业务，打造新型业务，经营计划为总营收292亿元，营业成本281亿元。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;值得注意的是，2月28日董事会通过拟不低于10.91元定增募资近20亿元用以升级物流，其中14亿元用于辽宁物流产业园、上海临港物流园区奉贤分区基地、称重物联网产业园、西部国际钢铁物流基地及电子商务及物流信息化建设项目。目前中储股份在全国114座城市设立了分支机构，募投项目达成后，尤其在东北乃至东北亚经济区、长三角乃至华东经济区、西部地区的核心竞争力将进一步加强。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;高送转力挺增发价</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;虽然公司董事会已通过定增方案，但不低于10.91元的价格委实不低。由于去年沪市主板综合指数疲弱，其2013年年内最高也不过12.39元，进入2014年后，虽然股价一度上冲至最高14.6元，但定增公布后又明显回落，昨日最低已至11.5元，距离定增最低价仅差5%左右，收盘报11.88元。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;这样看来，即使业绩不突出，公司仍然推出每10股送2股转增8股并派现金0.5元的优厚分红，足见为定增护航之心，这可是中储股份2004年以来的首次大比例转增。</p>\r\n<p style="white-space: normal; text-transform: none; color: rgb(51,51,51); word-spacing: 0px; padding-bottom: 5px; padding-top: 5px; font: 15px/26px 微软雅黑; padding-left: 10px; margin: 0px; letter-spacing: 1px; orphans: 2; widows: 2; padding-right: 10px; background-color: rgb(238,242,246); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;公开数据显示，去年二季度开始公募已逐步撤离，至去年末前十大流通股东中已不见公募身影，但同期湖南爱尔医疗投资公司和苏州太湖国际高尔夫俱乐部却连续大幅加仓，四季度股东数在公募撤离下反而减少了6%左右。如今有着高送转这块护垫，中储股份在11元附近的股价表现值得关注。</p>', '财经', '韩祯', '新快报', 'recommend', '2014-03-13'),
	(139, 'CES2014手机产品盘点：手机/芯片各占一半', 'upload/images/1395558299984.jpg', '<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　<span style="display: inline! important; float: none; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">索尼Z1 Compact</span></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	导语：每年1月在美国拉斯维加斯举办的CES大展都可作为这一整年电子产品发展的指导手册，国内外众多大厂都会选在这个地方为自家这一年的产品来个好开头或定下基调。今年CES展上热闹依旧，在展会已经进行两天之后，新品已经基本发布完毕。新浪手机为您盘点一下这次CES展会上发布的跟通讯有关的重磅新品。<span style="color: rgb(255,255,255)">来 自 西 陆 军 事 http://www.xilu.com</span></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　手机篇：拉斯维加斯的这场大会的主角是一大票怪科技，手机算不上绝对主角，但今年也有些有趣手机出现。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　索尼Z1 Compact：我叫小强</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　Z1 Compact是一款卡位很准的手机：比它小的没他配置好，比它配置好几乎都是五英寸屏的大家伙。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　终于有家厂商想通了，没再逼着高配置手机的也必须配个大尺寸屏幕，这也是Z1 Compact的最大特点：小，而强。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　Compact本身便是&ldquo;紧凑&rdquo;的意思，Z1 Compact采用了4.3英寸触控屏，并且有个轻巧的金属骨架，外表覆上多彩的机身，尽管身材小巧，但配置没落下，Z1 Compact采用了一颗主频为2.2GHz的骁龙800四核处理器，配备2GB运行内存，16GB 存储空间，2070万像素的G镜组摄像头。</p>\r\n<p>\r\n	<img alt="CES2014手机产品盘点：手机/芯片各占一半" src="http://img1.xilu.com/2014/0323/8fef24749b0f258af8f5c615f9e693cb.jpg" style="border-top-width: 0px; border-left-width: 0px; border-bottom-width: 0px; word-spacing: 0px; font: 15px/26px SimSun; vertical-align: top; text-transform: none; color: rgb(43,43,43); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); border-right-width: 0px; webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px" /><span style="display: inline! important; float: none; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">索尼Z1 Compact</span></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　如果要挑点问题，那就是屏幕只是720P，但因为4.3寸的屏幕原因，像素密度也有342 ppi，达到了所谓的视网膜屏幕330ppi标准。</p>\r\n<p>\r\n	<img alt="CES2014手机产品盘点：手机/芯片各占一半" src="http://img1.xilu.com/2014/0323/0b96ee6ba54aa0c3c346fae8ca94f058.jpg" style="border-top-width: 0px; border-left-width: 0px; border-bottom-width: 0px; word-spacing: 0px; font: 15px/26px SimSun; vertical-align: top; text-transform: none; color: rgb(43,43,43); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); border-right-width: 0px; webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px" /><span style="display: inline! important; float: none; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">索尼Z1 Compact</span></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　对了，索尼还在这款手机上保留了防尘防水功能。小，多彩，配置好，还三防，世面上能满足这些条件的手机似乎还没有其他。</p>', '通信', '', '西陆网', 'recommend', '2014-03-23'),
	(140, '无锡集成电路产业规模全国第二', '', '<p style="word-spacing: 0px; font: 16px/26px 宋体; text-transform: none; color: rgb(0,0,0); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	&nbsp; 新华网南京3月21日电(记者陈刚) 记者从无锡市信息化和无线电管理局获悉,去年该市集成电路产业纳入统计的190家微电子企业共完成营业收入652.12亿元,同比增长超过25%,规模列全国第二。</p>\r\n<p style="word-spacing: 0px; font: 16px/26px 宋体; text-transform: none; color: rgb(0,0,0); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp; 据介绍,作为国家集成电路设计产业化基地之一,无锡已形成囊括芯片设计、掩模、制造、封装、测试、配套材料与装备制造业的完整产业链。统计数据显示,目前该市晶圆制造产业名列全国第一,封装测试产业名列全国第三,集成电路设计产业名列全国第四。该市SK海力士、华润微电子,新潮集团、海太半导体、英飞凌(无锡)位列全国同业十强。 2013年中国集成电路产业销售收入逾2500亿元,同比增长超过16%。(完)</p>\r\n<p>\r\n	<br class="Apple-interchange-newline" />\r\n	&nbsp;</p>', '电子', '', '新华网江苏频道', '', '2014-03-23'),
	(141, '英特尔ARM开启芯片之战 消费者该何去何从？', 'upload/images/1395558525843.jpg', '<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	【搜狐IT消息】据国外媒体报道，正在逼近的芯片之战将让消费者无所适从。<span style="color: rgb(255,255,255)">来 自 西 陆 军 事 http://www.xilu.com</span></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　全球最大PC芯片制造商英特尔希望它的芯片产品能进入平板电脑和智能手机市场。全球最大移动处理器设计厂商ARM则希望自己的芯片产品能打进平板PC市场。如同上世纪90年代和2000年初的Mac和PC之争，新的芯片大战意味着出现这样一种局面，消费者喜欢的应用无法支持他的设备，或无法如他所希望的那样在设备上运行。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　这将与目前我们习惯的局面大为不同。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　现在，几乎所有的PC（包括Mac）都在使用英特尔芯片。高通、苹果、三星和Nvidia等厂商制造的ARM芯片则占据了移动设备市场的95%。移动和PC各有一个芯片平台，双方井水不犯河水。这方便了设备制造商、软件开发商和消费者。同一款软件一般都能确保在不同的设备上保持相同功能。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　但ARM和英特尔的芯片之战可能会让这种清楚的分布变得更加混乱，对开发商和消费者产生影响。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　ARM已经首出重拳，联合微软支持Windows RT，一种搭载为平板电脑优化的Windows 8版本。由于ARM芯片的低功率架构，因此Windows RT不兼容Windows 7应用。这让包括微软Surface在内的新平板电脑的实用性大大降低。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　去年英特尔宣布了进入移动市场的大动作，它发布了一款新的芯片组，既可以带动Windows 8；而且因为高效的能源管理，因此可以搭载在移动设备中。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　不像Windows RT无法运行一般的Windows软件。英特尔有内置工具可以让它的芯片运行为ARM优化的应用。但这还不是一步到位的解决方案：对于任何应用来说，设备硬件的限制和性能都要考虑。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　根据ARM总裁西蒙&bull;希加斯（Simon Segars）的说法，最受影响的应该是游戏软件。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　游戏《粘粘世界》（World of Goo）开发商2D Boy联合创始人吉尔&bull;卡梅尔（Gil Carmel）表示，他对芯片之战并不太关心。尽管《粘粘世界》有大量华丽的视觉效果，但2D Boy目前的游戏并不需要特别优化。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　卡梅尔表示：&ldquo;对于我们的游戏来说，支持英特尔芯片组是很简单的事，因为我们的游戏在大多数现代硬件上都运行良好，无需太多的低层次、特别架构的优化。我们内部已经测试过对英特尔芯片的支持，移植过程非常简单。&rdquo;</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　但在现今应用低利润的时代，特别是Android平台，许多小型开发公司没有资源让它们的应用针对不同的硬件架构进行优化。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　谷歌的Android操作系统可能受芯片之战的影响比较大。苹果则不一样，它牢牢控制着每代iPhone的芯片使用。谷歌对Android设备制造厂商的控制力没有这么强，它们有些会使用英特尔芯片，有些会使用ARM芯片。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 20px; word-spacing: 0px; font: 15px/26px SimSun; text-transform: none; color: rgb(43,43,43); text-indent: 25px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	　　现在，小部分手机已经在使用英特尔芯片，运行ARM的PC在消费者当中还不是十分流行。但技术分析师认为，未来几年内，双方都能切实提高在各自市场的份额。这意味着未来消费者在选择智能手机、平板电脑或笔记本电脑时，必须考虑最常用的软件能否运行在相应设备上。（柯山）</p>', '电子', '', '西陆网', 'recommend', '2014-03-23'),
	(142, '64位Android手机何时到来？再等等吧', 'upload/images/1395558758296.jpg', '<p>\r\n	&nbsp;</p>\r\n<div class="BSHARE_POP blkContainerSblkCon clearfix blkContainerSblkCon_14" id="artibody" style="padding-right: 19px; padding-left: 19px; padding-bottom: 0px; word-spacing: 0px; font: 14px/23px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 23px; zoom: 1; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); webkit-text-size-adjust: auto; orphans: 2; widows: 2; webkit-text-stroke-width: 0px">\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　采用64位芯片的iPhone 5s发布已经过去将近半年，但Android阵营中依旧没有对应的产品出现。用户们还要等多久才能用上64位芯片的Android手机？韩国媒体ETNews给出的答案是&mdash;&mdash;至少要等到2014年年底或者2015年早期。</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　ETNews说，包括三星在内的多家Android手机制造商将推迟64位芯片智能手机的发布。计划变更的主要原因在于系统端&mdash;&mdash;目前Android系统还无法全面地支持64位芯片。</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　作为对比，iOS在芯片架构设计、硬件和结构系统都为64位芯片进行了优化，这让iPhone 5s在更换为64位芯片后依旧能流畅完善地运行现有应用。但Android目前还无法实现这点。眼下Google正在紧锣密鼓地解决Android对64位芯片的支持问题，但考虑到工作量，新系统的发布时间恐怕要有点晚。</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px; text-align: center">\r\n		<img alt="iphone-64bit-lead" class="aligncenter" height="284" src="http://i3.sinaimg.cn/IT/cr/2014/0322/2692904096.jpg" style="border-right: medium none; padding-right: 0px; border-top: medium none; padding-left: 0px; padding-bottom: 0px; margin: 0px; border-left: medium none; padding-top: 0px; border-bottom: medium none" width="550" /></p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　除了系统端的限制，移动D-RAM内存的生产成本也是制约64位Android手机面世的原因之一。如果要生产支持64位芯片的D-RAM内存，芯片商们需要改造生产线，但这势必会延长产品的生产周期，推迟产品出厂时间，生产成本的提高自然是情理之中的事了。</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　要是因此苛责芯片商势利，那他们倒也有点冤枉。毕竟对商业公司来说，获利本来就是一件无可厚非的事。另外，高通、英伟达、MTK等大型芯片商其实已经发布了64位芯片，传统x86架构的芯片商英特尔也在今年全线更进64位移动芯片。如果不确定的话，这里可以再复习一下他们的产品：</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　高通在今年MWC媒体会上宣布对骁龙600和骁龙800系列处理器进行升级，同时推出骁龙610、615和骁龙801三款新芯片。其中骁龙610和615都是64位芯片，前者采用4核心，后者采用8核心</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　英伟达在今年CES消费展上推出Tegra K1移动芯片，后者拥有32位和64位两个版本。64位的Tegra K1基于英伟达自行设计的Denver CPU架构开发，运行频率最高为2.5GHz</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　MTK在MWC通信展上推出旗下首款64位芯片MT6732，后者采用4核Cortex-A53架构，主频为1.5GHz，支持更加高效的ARM v8指令集，同时整合了最新的Mail-T760图形芯片</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　英特尔也在MWC通信展期间发布了两个64位移动芯片品牌，分别是Merrifield和Moorefield。前者包含Atom Z3460和Atom Z3480两款双核处理器，最高主频分别为1.6GHz和2.13GHz；后者包含Atom Z3560和Atom Z3580两款四核处理器，最高主频分别为1.8GHz和2.33GHz。这是英特尔发布的首款64位移动处理器，英特尔表示，未来所有移动处理器都将采用64位结构</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　采用64位芯片的Android手机最早在今年年底或者明年早期面世，ETNews给出的时间来自行业人士的预测。Google在去年11月对外发布Android 4.4，假设新版系统的开发周期为1年，如果再算上OEM商们的适配和优化时间，今年年底或者明年早期发布64位Android手机的可能性还是非常大的。</p>\r\n	<p style="padding-right: 0px; padding-left: 0px; font-size: 14px; padding-bottom: 0px; margin: 15px 0px; line-height: 23px; padding-top: 0px">\r\n		　　所以，期待64位Andorid手机的用户还是继续慢慢等待吧。</p>\r\n	<div style="clear: both; font-size: 0px; height: 0px">\r\n		&nbsp;</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '电子', '　　采用64位芯片的iPhone 5s发布已经过去将近半年，但Android阵营中依旧没有对应的产品出现。用户们还要等多久才能用上64位芯片的Android手机？韩国媒体ETNews给出的答案是??至少要等到2014年年底或者2015年早期。', '新浪科技手机频道', 'recommend', '2014-03-23'),
	(143, '陈学慧：多位专家热议房地产市场，崩盘？拐点？字号', 'upload/images/1395749409234.jpg', '<div align="center">\r\n	<font style="font-size: 12px">图片来源：贺翔/东方IC</font></div>\r\n<p>\r\n	　　不能说出现了大的拐点，更不同意崩盘论，但是要正视现实。当前中国的住房市场确实出现了一些新的阶段性特征和趋势</p>\r\n<p>\r\n	　　房地产投资增速放缓。没有一个国家，房地产是永远高歌猛进的，到了一定的程度会规律性地回落，而这种回落并不是泡沫的破裂</p>\r\n<p>\r\n	　　今年的政府工作报告没提&ldquo;房价&rdquo;，而是首次提出&ldquo;针对不同城市情况分类调控&rdquo;。政策已经明显变化</p>\r\n<p>\r\n	　　要发挥地方政府的作用，还要保持中性的房地产金融政策，同时完善住房保障机制，特别是要加强预期管理。要避免采用过度的刺激政策，也要避免突然收紧货币政策或者过度控制银行对于房地产的放贷</p>\r\n<div align="center">\r\n	　　近来的几个动向，让房地产市场备受瞩目，议论纷纷。一是，今年的政府工作报告没提&ldquo;房价&rdquo;，而是首次提出&ldquo;针对不同城市情况分类调控&rdquo;。这是自2005年以来，除去2009年，第一次未提&ldquo;房价&rdquo;。而这个时间节点正是市场对新一届中央政府如何调控房地产市场最为期盼的时候。二是，有媒体报道，住房与城乡建设部今年已不再要求各地政府上报并向社会公布房价调控目标，这是2009年以来政策上比较明显的变化。事实上，今年一季度按国八条向社会公布房价调控目标的城市不多。三是，杭州、<a href="http://news.hexun.com/beijing/index.html" target="_blank">北京</a>等一线城市相继有楼盘因为各种原因，房价定的比预期的要低，市场观望情绪增加。对此，有市场人士直呼&ldquo;房价面临全面失控&rdquo;，甚至有&ldquo;崩盘&rdquo;论在坊间流传。</div>\r\n<p>\r\n	　　如何看待当前的房地产市场？如何理解当前的房地产相关政策？让我们来听听专家和业内人士的观点。</p>\r\n<p>\r\n	　　&ldquo;今年以来整个舆论对中国住房市场的讨论和判断与以往有了一些不同，有悲观的认为马上要崩盘，也有乐观的认为还有长达十几年甚至几十年的高速增长。我们的观点是，不能说出现了大的拐点，更不同意崩盘论，但是要正视现实。当前中国的住房市场确实出现了一些新的阶段性特征和趋势。&rdquo;国务院发展研究中心市场经济研究所所长任兴洲观点很鲜明。她及她的团队对此作过深入调研和分析。</p>\r\n<p>\r\n	　　瑞士国家银行前行长菲利普&middot;希德布兰德也表示，&ldquo;不能简单地说中国楼市有泡沫，要区分一下中国的一线城市、二线城市、三四线城市的情况。&rdquo;他认为，一线城市和二线城市的基本面比较健康，房价较高的主要是供应有限，以及市民财富增长、农民工涌入等，不用太多担心。同时，杠杆率相对不高，中国对首付有最低比例的要求，对于按揭也有相关规定。但是三四线城市情况就不一样了，这些城市供应过剩的情况可能性更高。</p>\r\n<p>\r\n	　　很多人总是把中国和<a href="http://news.hexun.com/2013/japan/index.html" target="_blank">日本</a>的房地产泡沫进行对比。瑞穗金融集团总裁佐藤康博认为，从数据上看，虽然中国城市之间存在着差异，但是整体上并没有发生像日本上世纪80年代那样强烈的价格上涨。现在不能说是有明显的泡沫，但如果不加以控制就有可能会成为泡沫。中国政府迄今实施的政策已经见效，市场已经有了趋稳的迹象。</p>\r\n<p>\r\n	　　按照任兴洲及其研究团队的分析，中国的住房市场出现了新的阶段性特征和趋势。第一个特征是，房地产投资增速放缓或者说增速换挡。经测算，1998年到2011年房地产开发投资高速增长，年复合增长率为24.4%，而从2012年起这种高速增长出现了变化，2012年和2013年的增速分别为11.4%和19.4%，整体上明显放缓。这种放缓是符合规律的，是房地产业持续十几年高速增长以后规律性的回落。这种回落不仅表现在投资方面，还表现在销售以及其他方面。</p>\r\n<p>\r\n	　　房地产投资增速换挡的原因在于：一是经济增长进入速度换挡期；二是供求关系发生了明显变化。据推算，截至2012年常住人口家庭户均住房达到1套。从国际经验来看在这样的供求关系下，住房市场会有比较大的阶段性的变化。十几年来大规模建房，使得存量规模越来越大，存量房的交易量不断增大，对新建房的投资也会产生影响。三是从客观上来讲，没有一个国家，房地产是永远高歌猛进的，到了一定的程度会规律性地回落，而这种回落并不是泡沫的破裂。</p>\r\n<p>\r\n	　　第二个特征是，区域市场分化明显。在东中西部各选一个省份所做的调查显示，这种明显分化的特征不是偶然的，也不是局部的。分化有人口聚集的因素、产业布局的因素，也有供求的因素。</p>\r\n<p>\r\n	　　第三个特征是，双轨供给局面形成。&ldquo;十二五&rdquo;期间保障房供给大幅度提高，到2015年保障家庭会达到20%左右。双轨的一边是市场化供给，另一边是政府承担起主导的保障功能。双轨的形成特别是保障房占比增加，对商品房市场当然有影响。</p>\r\n<p>\r\n	　　&ldquo;房地产业已进入到调整期。我相信这个调整期是健康的，过了调整期中国房地产业会更加健康地发展。&rdquo;华润集团有限公司董事长<a href="http://renwu.hexun.com/figure_628.shtml" target="_blank">宋林</a>如此判断。他的团队对房地产业也做过深度调研，其对房地产业新特征的判断与任兴洲吻合。</p>\r\n<p>\r\n	　　基于这些新的特征，房地产调控思路必然会转变，那就是分类调控。&ldquo;得的不是一样的病不能吃一样的药。&rdquo;任兴洲表示，要发挥地方政府的作用，还要保持中性的房地产金融政策，同时完善住房保障机制，特别是要加强预期管理。&ldquo;出现问题不是在房地产市场快速增长的时候，反而是在供求趋向平衡的时候，所以这时候我们更要防范风险。调控思路要从现实出发，要把握政策的边界和力度，特别避免在投资规律性回落的时候盲目刺激，盲目地刺激会带来更多的房地产过剩，过剩的话泡沫的风险可能会增加。&rdquo;任兴洲强调说。</p>\r\n<p>\r\n	　　佐藤康博也建议，要避免采用过度的刺激政策，也要避免突然收紧货币政策或者过度控制银行对于房地产的放贷，操之过急的紧缩可能引发长期的经济疲软。宋林也强调，要相信市场的力量，运用市场手段。政府要在宏观经济层面、社会层面，以及营造公开公平公正的法治环境上，多引导市场，而不要干预微观行为。</p>\r\n<p>\r\n	　　&ldquo;房地产市场处在持续健康发展的新起点，我们对企业、市场和政府都非常有信心。&rdquo;<a href="http://renwu.hexun.com/figure_218.shtml" target="_blank">冯仑</a>是房地产业善于思考的&ldquo;名嘴&rdquo;企业家，他的乐观值得市场更多考量。</p>', '房地产', '陈学慧', '中国经济网', 'recommend', '2014-03-25'),
	(144, '2014年第12周佛山房地产市场运行分析', 'upload/images/1395749691093.png', '<p>\r\n	<strong>一、土地市场<br />\r\n	　　<br />\r\n	　　1、土地供应</strong><br />\r\n	　　<br />\r\n	　　2014年第12周（2014年3月17日&mdash;2014年3月23日），佛山新增6宗用地供应，全位于三水区。<br />\r\n	　　<br />\r\n	　<strong>　2、土地成交</strong><br />\r\n	　　<br />\r\n	　　2014年第12周（2014年3月17日&mdash;2014年3月23日），上周佛山没有土地共成交。<br />\r\n	　　<br />\r\n	<strong>　　二、一手房市场<br />\r\n	　　<br />\r\n	　　1、新增预售</strong><br />\r\n	　　<br />\r\n	　　2014年第12周（2014年3月17日&mdash;2014年3月23日），佛山五区佛山五区共9个项目共取得11个预售证，共预售1545套，面积为13.89万平米，其中预售住宅1345套，面积为12.11万平米；<a class="replace1_css" href="http://www.askci.com/reports/index188.html" target="_blank">商业</a>预售68套，面积为0.65万平米；各区预售方面，禅城只有沿海馨庭1个楼盘取得1个预售证，共预售住宅120套，面积1.09万平米，商业9套，面积739平米，南海区4项目取得6个预售证，预售住宅647套，面积为6.26万平米，商业预售58套，面积0.57万平米，顺德共有4个项目取得4个预售证，其中住宅预售578套，共预售4.76万平米，商铺预售1套，面积为82平方米。 上周高明和三水没有新增预售。<br />\r\n	　　<br />\r\n	　　<strong>2、成交状况</strong><br />\r\n	　　<br />\r\n	　　从上周成交数据来看，佛山一手住宅共成交1633套；总成交面积为17.39万平米；成交均价为9896元/平米；总成交额为17.21亿元。<br />\r\n	　　<br />\r\n	　　从上周各区成交套数来看，各区表现平稳，禅城上周成交环比上升3.2%，共成交194 套，而成交主力南海区上周成交同样表现平稳，成交952 套，环比上升4.6%，顺德区上周共成交304 套，环比下跌5.9%，而三水区上周共成交112 套，较前周减少12 套，环比微跌9.7%，高明上周成交71 套，较前周增加6 套。<br />\r\n	　　<br />\r\n	　　各区在成交均价方面，中心城区禅城有所下跌，为9825 元/平米，环比下跌9.9%；南海均价环比下跌明显，但均价位居五区之首，为10622 元/平米，环比下跌15.9%，顺德区整体均价较为平稳，为9444 元/平米，环比微升3.5%，三水均价7146 元/平米，环比上升17%，高明均价为7072 元/平米，环比上升10.6%。<br />\r\n	　　<img border="0" src="http://www.askci.com/files/Content/2014-3/28-873998-55.png" /><br />\r\n	　　从上周总体成交情况及各方面表现来看，佛山楼市成交平稳，上周共成交1633 套，较前周增加23 套；受热销楼盘开盘刺激下，加上价格优惠加大，购房者积极入市，令整体成交量保持高位平稳，而价格方面，开发商有一定让利，整体均价环比有明显下跌，为9896 元/平方米，全市整体市场表现量稳价跌。</p>\r\n<div class="ry6">\r\n	　<strong>　1、新增预售</strong><br />\r\n	　　<br />\r\n	　　2014年第12周（2014年3月17日&mdash;2014年3月23日），顺德共有4个项目取得4个预售证，其中住宅预售578套，共预售4.76万平米，商铺预售1套，面积为82平方米。<br />\r\n	　　<br />\r\n	　<strong>　2、成交状况</strong><br />\r\n	　　<br />\r\n	　　从上周成交数据来看，顺德一手住宅共成交304套；成交总面积为3.44万平米；成交均价为9444元/平米；成交总金额为3.25亿元。<br />\r\n	　<img border="0" src="http://www.askci.com/files/Content/2014-3/28-045914-3.png" />　<br />\r\n	　　从各镇街成交套数看，中心城区大良-容桂成交总量与前一周环比成交下跌，共成交97 套，大良成交39 套，环比前一周下跌，而容桂成交同样微跌，共成交58 套，其余各镇街成交表现突出的为陈村和乐从，分别成交57 套和38 套，其他各镇街较为平稳。<br />\r\n	　　<br />\r\n	　　成交均价方面，均价过万的镇街有北?、陈村、大良和乐从，分别为北?均价12283 元/平米，陈村均价12065 元/平米、大良均价12012 元/?和乐从均价为11917 元/平米，其余镇街成交均价都稳中微升。<br />\r\n	　　<img border="0" src="http://www.askci.com/files/Content/2014-3/28-637734-17.png" /><br />\r\n	　　从上周总体成交情况及各方面表现来看，顺德楼市成交稳中微跌，主要持续销量较快的多为区域地段较好和品牌开发商旗下楼盘，而其他开发商在营销方面未见有大动作，部分购房者观望仍比较浓厚，而价格方面，部分楼盘让利收窄，环比微升，为9444 元/平方米，全市整体市场表现量稳价升。</div>', '房地产', '', '世联行', 'recommend', '2014-03-25'),
	(145, '成都：购北京汽车E系列最高优惠1.62万元', 'upload/images/1395749940875.jpg', '<p>\r\n	　　据北京汽车4S店销售人员表示：目前北汽E系2013款三厢1.5L自动乐享版优惠1.62万，部分车型的优惠有提升。车源充足，颜色可选。具体价格信息见下表：</p>\r\n<p>\r\n	　　</p>\r\n<center>\r\n	车型(成都报价)指导价(万)4s店价格(万)价格变化(万)备注三厢 1.3L 手动乐天版2013款5.985.08<strong style="font-family: 宋体; color: #008800">&darr;</strong>0.90车源充足两厢 1.5L 手动乐天版2013款6.185.08<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足三厢 1.5L 手动乐天版2013款6.285.18<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足两厢 1.5L 自动乐天版2013款6.815.71<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足三厢 1.5L 自动乐天版2013款6.885.78<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足三厢 1.5L 手动乐尚版2013款6.985.88<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足三厢 1.5L 自动乐尚版2013款7.616.51<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足三厢 1.5L 自动乐享版2013款8.787.16<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.62车源充足两厢 1.3L 手动乐天版2012款5.884.98<strong style="font-family: 宋体; color: #008800">&darr;</strong>0.90车源充足两厢 1.3L 手动乐尚版2012款6.515.61<strong style="font-family: 宋体; color: #008800">&darr;</strong>0.90车源充足两厢 1.5L 手动乐尚版2012款6.885.78<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足两厢 1.5L 自动乐尚版2012款7.516.41<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.10车源充足两厢 1.5L 自动乐享版2012款8.687.28<strong style="font-family: 宋体; color: #008800">&darr;</strong>1.40车源充足</center>\r\n<p>\r\n	&nbsp;</p>\r\n<p align="center" sizcache08252647875429778="0.0.1" sizset="false">\r\n	<img alt="北京汽车 三厢 1.5L 自动" src="http://www.jx.chinanews.com/uploadfile/20140325/201403251441341591.jpg" /></p>\r\n<p>\r\n	　　北京汽车E系列全车车身尺寸为3998*1720*1503mm，轴距为2500mm，拥有标准的小型车身材，外形酷似奔驰。车身侧面线条紧凑而上扬，整车显得很饱满。共有6种车身颜色可供选择，分别为阿尔卑斯白、马德里红、香榭丽舍金、冰岛蓝、米兰银、汉堡灰。</p>\r\n<p align="center" sizcache08252647875429778="0.0.2" sizset="false">\r\n	<img alt="北京汽车 三厢 1.5L 自动 中控台整体" src="http://www.jx.chinanews.com/uploadfile/20140325/201403251441351592.jpg" /></p>\r\n<p>\r\n	　　内饰方面，中控台的设计样式简洁，上黑下浅的配色机构也让车内氛围更容易让人接受。多功能方向盘具备音量、电台、CD、外接终端(Apple、U盘)控制、定速巡航控制等多种功能。此外，全系配备发动机防盗、中控锁、隔热玻璃、行车电脑，配置在同价位车型中较有竞争力。</p>\r\n<p align="center" sizcache08252647875429778="0.0.3" sizset="false">\r\n	<img alt="北京汽车 三厢 1.5L 自动 发动机主体特写" src="http://www.jx.chinanews.com/uploadfile/20140325/201403251441351593.jpg" /></p>\r\n<p>\r\n	　　动力方面，北京汽车E系搭载三菱的4A9系列发动机，有1.3L和1.5L两个排量，都具备了可变气门正时、正时链条和电子油门技术，其中1.5L发动机最大功率为83kW/6000rpm，最大扭矩为143Nm/4000rpm。分别匹配5速手动变和来自爱信4速自动变速箱。</p>\r\n<p>\r\n	　　<strong>编辑点评：</strong></p>\r\n<p>\r\n	　　北汽E系列整车外观设计秉德式设计风格，大气时尚，动感十足。其前脸酷似奔驰B200。感兴趣的朋友可以到店咨询购买，或是致电经销商了解更多资讯。</p>\r\n<p>\r\n	　　<strong>保养信息：</strong></p>\r\n<p>\r\n	　　</p>\r\n<center>\r\n	保养信息质保周期\r\n	<div align="center" style="padding-bottom: 0px; margin: 3.75pt 0cm; padding-left: 0px; padding-right: 0px; vertical-align: baseline; padding-top: 0px">\r\n		3年或10万公里</div>\r\n	店内建议保养周期\r\n	<div align="center" style="padding-bottom: 0px; margin: 3.75pt 0cm; padding-left: 0px; padding-right: 0px; vertical-align: baseline; padding-top: 0px">\r\n		5000公里</div>\r\n	更换机油机滤费用\r\n	<div align="center" style="padding-bottom: 0px; margin: 3.75pt 0cm; padding-left: 0px; padding-right: 0px; vertical-align: baseline; padding-top: 0px">\r\n		300元左右</div>\r\n	<div style="padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; vertical-align: baseline; padding-top: 0px">\r\n		（以4S店价格为准）</div>\r\n	更换机油三滤费用\r\n	<div align="center" style="padding-bottom: 0px; margin: 3.75pt 0cm; padding-left: 0px; padding-right: 0px; vertical-align: baseline; padding-top: 0px">\r\n		500元左右</div>\r\n	<div style="padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; vertical-align: baseline; padding-top: 0px">\r\n		（以4S店价格为准）</div>\r\n</center>', '汽车', '', '网上车市', 'recommend', '2014-03-25'),
	(146, '高清无伪照曝光升级“神车”定名宝骏730', 'upload/images/1395750189234.jpg', '<p>\r\n	【<a href="http://hz.cheshi.com/">网上车市杭州站讯</a>】相信大家对<a class="t_link" href="http://product.cheshi.com/bseries_1247/" target="_blank"><font style="color: #333">五菱宏光</font></a>都已经相当熟悉了，这款上市仅仅三年多的<a class="t_link" href="http://product.cheshi.com/" target="_blank"><font style="color: #333">车型</font></a>，就凭借着对消费需求的精准洞察和上汽<a class="t_link" href="http://product.cheshi.com/logo_234/" target="_blank"><font style="color: #333">通用</font></a><a class="t_link" href="http://product.cheshi.com/logo_129/" target="_blank"><font style="color: #333">五菱</font></a>的强大品质保障，目前已拥有超百万用户，单月销量已超过8万辆，开辟了&ldquo;7座家用车&rdquo;&nbsp;全新细分市场，并改变了中国&nbsp;MPV市场格局，&nbsp;被业界誉为&ldquo;神车&rdquo;。</p>\r\n<p>\r\n	近日，上汽通用五菱内部代号为CN200的新款七座家用车正式命名为&ldquo;<a class="t_link" href="http://product.cheshi.com/logo_244/" target="_blank"><font style="color: #333">宝骏</font></a><a class="t_link" href="http://product.cheshi.com/bseries_7/" target="_blank"><font style="color: #333">730</font></a>&rdquo;，其高清无伪谍照也再度曝光。据悉，宝骏730基于全新开发平台打造，是上汽通用五菱发力七座家用车市场的又一款重要产品，自曝光以来，一直被视为五菱宏光的升级版车型，它是否能承担起&ldquo;升级神车&rdquo;的使命呢&nbsp;？我们也许能在这些外观谍照中得到部分答案。</p>\r\n<p>\r\n	<span style="text-indent: 2em">从照片来看，宝骏730头部造型很饱满，简约的U型镀铬轮廓搭配横拉式双条格栅，全新的流线型外后视镜，集成了时下流行的LED转向灯功能。</span></p>\r\n<p>\r\n	泪眼式造型设计搭配透镜灯组，让前大灯看起来更加灵动，从外观设计中来看，无疑是点睛之笔。</p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	&nbsp;<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396880.shtml" style="text-indent: 2em" target="_blank"><img src="http://img2.cheshi-img.com/center/600/e1/13/93/009d7c3cb5f8e6074ba2b337d4.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396834.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/290/9d/ce/e8/f8795e0513617fb680c4f9c567.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a>&nbsp;<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396837.shtml" style="text-indent: 2em" target="_blank"><img src="http://img2.cheshi-img.com/center/290/a9/1d/97/d76055ab135badec21b4561a9c.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">宝骏730的白色LED日间行车灯将车辆外观设计与安全性完美结合。LED照明单元犹如钻石般精致夺目，前雾灯和LED日间行车灯采用回旋镖式设计，造型独特，这与保险杠的运动包围融为一体。</span></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396838.shtml" target="_blank"><img src="http://img2.cheshi-img.com/center/290/2f/c5/8f/12d913e57ecdb3e69aacb5814a.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396839.shtml" target="_blank"><img src="http://img1.cheshi-img.com/center/600/b1/dd/89/fc3978677ec54180bba85bc56b.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">宝骏730侧面造型设计简洁流畅，突出的轮拱与门把手上方的高挑腰线一气呵成。前机舱盖延至C柱的流畅曲线，让线条衔接的柔和而有设计感，也让饱满并伴随起伏的轮廓显得强硬而富有安全感，更有震慑力十足的视觉冲击力。</span></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396841.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/600/26/98/d4/65729df93bed5b3972c9a53b64.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">新车的轮毂采用双五辐放射状立体式设计，这样的造型让车身的整体比例看起来非常协调。</span></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396848.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/600/a3/e3/7d/18cb74c5d25d60828b7ca69331.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">从整体造型来看，宝骏730为了降低MPV在风阻上的劣势，对前保险杠、发动机舱罩、车辆顶部、A柱、D柱、扰流板等关键造型要素都进行细致的调整优化，这为降低车辆油耗起到重要作用。</span></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396850.shtml" target="_blank"><img src="http://img1.cheshi-img.com/center/600/e2/00/23/ba2766b6b6613e659ab1696692.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396851.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/600/2f/45/02/f2346c2bc014530165c466bce3.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">宝骏730的尾部造型非常饱满，尾灯继承了宝骏家族化的简洁设计，而加长后的C型元素让尾部造型更加时尚。</span></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396854.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/600/f6/d0/eb/203aea377413da70087b4d1dd6.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">从图片上看，宝骏730车尾处设置了车尾反射器，它很像是简洁的小尾灯，宏光S的车尾都不曾出现此配置。</span><span style="text-indent: 2em">这样独立的车尾反射器，不但可有效提示后方车辆安全距离，更在细节处显示出上汽通用五菱更加贴近用户的造车<a class="t_link" href="http://product.cheshi.com/logo_235/" target="_blank"><font style="color: #333">理念</font></a>。</span></p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140325/1298898_5396856.shtml" target="_blank"><img src="http://img1.cheshi-img.com/center/600/69/a3/1c/48f729f006715fd0403d0284bf.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em">宝骏730自曝光以来，吸引了大批消费者和行业人士的关注。他们对这款被称为&ldquo;升级版神车&rdquo;的名字、配置、定价等猜测，也备受各大媒体关注，成为争相报道的新闻焦点。此次终于官方公开了这款神秘七座家用车的命名，不仅意味着它离量产上市为期不远，也意味着上汽通用五菱家族中7座家用车系又添虎将。</span></p>', '汽车', '', '网上车市', 'recommend', '2014-03-25'),
	(147, '盛世传“祺”传祺成为公务车的领跑者', '', '<p>\r\n	　【<strong sizcache021564087853894076="20" sizset="154"><a href="http://www.chexun.com/">车讯网</a> 报道</strong>】近年来，公务车政策改革的持续深入推进，在一定程度上遏制了公车消费的奢华风气，优先采购自主品牌乘用车用作政府公务车已经开始出现实质性的破冰。这对众多自主车企来说，无疑是抢占市场的一次重大机遇。</p>\r\n<p sizcache021564087853894076="20" sizset="155">\r\n	　　深耕公务车市场是<a href="http://auto.chexun.com/brand_gac/" target="_blank">广汽</a>乘用车稳步进军中高端轿车市场的战略体现。众所周知，政府采购对<a href="http://auto.chexun.com/brand_vw/" target="_blank">大众</a>市场影响颇深，广汽<a href="http://auto.chexun.com/trumpchi/" target="_blank">传祺</a>深谙其道，自诞生之日起便秉持高起点、高品质发展路线，积极在公务市场开疆拓土。</p>\r\n<p align="center">\r\n	<img alt="盛世传“祺”传祺成为公务车的领跑者  " src="http://i0.chexun.net/images/2014/0325/13016/news_default_12DA6E84DD819AEAD9D54019D3F3516C.jpg" style="border: 0px solid currentColor; width: 550px; height: 378px;" /></p>\r\n<p>\r\n	　　被誉为&ldquo;新一代公务车典范&rdquo;的1.8L传祺，与公布的公务车采购新政策不谋而合，自上市以来在公务车领域大展拳脚。</p>\r\n<p>\r\n	　　据了解，目前市场上符合公务车采购新政的1.8T车型很少，传祺GA5 1.8T的推出无疑为传祺进一步拓展公务车市场增添了有力砝码。&ldquo;传祺GA5 2013款 1.8T外观大气、空间宽敞、动力强劲，符合公务车采购的高标准要求，大大提升自主品牌的竞争力，将加速公务车自主化进程&rdquo;，业内人士评价。&ldquo;传祺GA5 1.8T将开启更为广阔的中高端私人用车市场，同时也将进一步夯实传祺轿车在公、商务轿车市场的优势地位&rdquo;，广汽乘用车相关负责人介绍。&ldquo;涡轮增压发动机功率比同排量的发动机要大20％-30％，所以&lsquo;T&rsquo;车型很受政府采购部门青睐，而传祺GA5 1.8T车型紧贴公务车采购排量要求上限，最大限度满足公务车采购对&lsquo;大动力&rsquo;的需求，竞争优势明显&rdquo;，专家分析。</p>\r\n<p align="center">\r\n	<img alt="盛世传“祺”传祺成为公务车的领跑者  " src="http://i3.chexun.net/images/2014/0325/13016/news_default_2DEA7851501D01729B642DE04E1FFEE7.jpg" style="border: 0px solid currentColor; width: 550px; height: 382px;" /></p>\r\n<p>\r\n	　　目前，广汽传祺以过硬的产品品质在公务车市场表现优异，建立良好的口碑并树立高端品牌形象 ，这也将形成示范效应并反哺大众市场。鉴于传祺近两年在公务车市场的强劲发展势头，相信传祺GA5 1.8T未来一定能够成功开启公务车市场&ldquo;T时代&rdquo;，成为中高端大众市场的畅销车型。</p>\r\n<p align="center">\r\n	<img alt="盛世传“祺”传祺成为公务车的领跑者  " src="http://i0.chexun.net/images/2014/0325/13016/news_default_2559ABAE2CF6D3D2427E90762DF6070D.jpg" style="border: 0px solid currentColor; width: 550px; height: 377px;" /></p>\r\n<p>\r\n	　　24小时服务热线：400-868-4708</p>\r\n<p>\r\n	　　拨打以上400热线或在网上下询价订单优惠更高哦</p>\r\n<p>\r\n	　　关注贵州广瑞通微信公众平台获得最新传祺资讯</p>\r\n<p align="center">\r\n	<img alt="盛世传“祺”传祺成为公务车的领跑者  " src="http://i2.chexun.net/images/2014/0325/13016/news_default_70AB96A2D0EBB3F02577460FC44612C9.jpg" style="border: 0px solid currentColor; width: 550px; height: 993px;" /></p>\r\n<p>\r\n	　　广瑞通传祺4S店新浪微博地址 @贵州广瑞通</p>\r\n<p>\r\n	　　http://weibo.com/3180469454</p>\r\n<p align="center">\r\n	<img alt="盛世传“祺”传祺成为公务车的领跑者  " border="0" src="http://i3.chexun.net/images/2014/0325/13016/news_default_27B45B5763B9BF068D5706A9A9FB04C9.jpg" /></p>\r\n<p>\r\n	　　<strong>贵州广瑞通汽车销售服务有限公司</strong></p>\r\n<p>\r\n	<strong>　　销售热线：0851-3635888</strong></p>\r\n<p>\r\n	<strong>　　24小时服务电话：0851-3713388</strong></p>\r\n<p>\r\n	<strong>　　店面地址：贵州省贵阳市花溪孟关国际汽贸城传祺4S店</strong></p>\r\n<p>\r\n	<strong>　　广汽传祺广瑞通清镇店</strong></p>\r\n<p>\r\n	<strong>　　销售咨询热线:13985011302</strong></p>\r\n<p>\r\n	<strong>　　店面地址：清镇市东门桥济辉汽车城</strong></p>\r\n<p>\r\n	<strong>　　广汽传祺广瑞通金阳店</strong></p>\r\n<p>\r\n	<strong>　　销售咨询热线:18690740646</strong></p>\r\n<p>\r\n	<strong>　　店面地址：贵阳第一中学对面</strong></p>\r\n<p>\r\n	<strong>　　大客户专线：139850251555</strong></p>', '汽车', '黎世', '车讯网', 'focus', '2015-12-23'),
	(148, '纠结的土豪款 全球最贵Tesla改装车', '', '<p style="text-indent: 2em;">\r\n	并不是所有电动车头上都有一个&ldquo;素食&rdquo;的标签，来自美国加州西好莱坞的Al &amp; Ed&#39;s Autosound这次打造了一款土豪版Tesla Model S，售价超过20万美金，足以满足那些&ldquo;重口&rdquo;消费者的喜好。<img alt="纠结的土豪款 全球最贵Tesla改装车" id="9997452" md5="" src="http://art.china.cn/car/images/attachement/jpg/site8/20140325/0800270084aa149b80301f.jpg" width="630" /></p>\r\n<p style="text-indent: 2em;">\r\n	首先，从起价85900美金的85千瓦时Model S开始，增加一套性能包（performance plus）直接飙到123770美金，&ldquo;智能&rdquo;悬挂系统2250美金、科技包3750美金、超高保真音响系统2500美金、全景天窗2500美金、21英寸轮圈4500美金。</p>\r\n<p align="center">\r\n	<img alt="纠结的土豪款 全球最贵Tesla改装车" id="9997453" md5="" src="http://art.china.cn/car/images/attachement/jpg/site8/20140325/0800270084aa149b803020.jpg" width="630" /></p>\r\n<p style="text-indent: 2em;">\r\n	还没完，轮圈升级至锻造&ldquo;GhostGold&rdquo;7500美金、车身3M贴膜6000美金、碳纤维车身套件5250美金、定制内饰25000美金等等。现在你知道这部Tesla的身价已经多高了吗？是贾斯汀比伯那部电镀Fisker Karma的两倍还多。</p>\r\n<p align="center">\r\n	<img alt="纠结的土豪款 全球最贵Tesla改装车" id="9997454" md5="" src="http://art.china.cn/car/images/attachement/jpg/site8/20140325/0800270084aa149b802e1d.jpg" width="630" /></p>\r\n<p style="text-indent: 2em;">\r\n	最最重要的是，从外观上并看不出这是一部售价超过20万美金、甚至比全新911 Turbo S还贵的Tesla，至于那个科技选装包，难道一个大iPad还不够吗？</p>', '汽车', '', '新浪车致', 'focus', '2015-12-23'),
	(149, '双离合众泰T600亮相北京车展 2.0T将上市', 'upload/images/1395750737156.jpg', '<p>\r\n	随着车展日益临近，我们了解到<a class="t_link" href="http://product.cheshi.com/bseries_1833/" target="_blank"><font style="color: #333">众泰T600</font></a> 2.0T DCT（双离合）将于2014北京新国际博览中心惊艳亮相北京国际车展,，<a class="t_link" href="http://product.cheshi.com/logo_177/" target="_blank"><font style="color: #333">众泰</font></a>T600 2.0T手动版也将于2014年中上市，而2.0T DCT版本将于第三季度正式上市。</p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140324/1297141_5390092.shtml" target="_blank"><img src="http://img2.cheshi-img.com/center/600/b7/f8/7a/ab3698fe8a634b862f749b7a3a.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	具有卓越外观与超高性价比优势的众泰T600系列，一经上市便在自主<a class="t_link" href="http://product.cheshi.com/SUV/" target="_blank"><font style="color: #333">SUV</font></a>市场中引起了不小的地震，它给都市白领们带来的不仅仅是一部扎实可靠的中型SUV，更是以其能够在外观、内饰、配置等各个方面带给消费者更多的感官享受。众泰T600 2.0T DCT将于三季度上市，手动挡<a class="t_link" href="http://product.cheshi.com/" target="_blank"><font style="color: #333">车型</font></a>将在年中提前亮相。</p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140324/1297141_5390089.shtml" target="_blank"><img src="http://img1.cheshi-img.com/center/600/d0/b5/c3/4954e2365b1c954195c424b24a.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	从众泰T600 2.0T官方微博公布的最新照片来看，众泰造型设计已然沿袭经典德系<a class="t_link" href="http://product.cheshi.com/logo_235/" target="_blank"><font style="color: #333">理念</font></a>，根据国人的审美需求精心打造，外观大气而不失时尚，内饰简洁大气，空间足够出众。</p>\r\n<p style="text-align: center; text-indent: 0px">\r\n	<a href="http://news.cheshi.com/picbrowser/20140324/1297141_5390112.shtml" target="_blank"><img src="http://img1.cheshi-img.com/center/600/7f/58/a4/aafd3e5a7d0c6d6d16a4368216.jpeg" style="border-bottom: black 1px solid; border-left: black 1px solid; border-top: black 1px solid; border-right: black 1px solid" /></a></p>\r\n<p>\r\n	众泰<a class="t_link" href="http://www.cheshi.com/" target="_blank"><font style="color: #333">汽车</font></a>T600 2.0T使用的湿式双离合变速器由德国舍弗勒和美国的博格华纳等世界著名供应商共同联合开发的。而此次众泰T600车型搭载2.0T+DCT动力总成亮相，将是众泰汽车此次北京车展上的亮点产品。</p>', '汽车', '曹旭', '网上车市', 'recommend', '2014-03-25'),
	(150, '旭辉集团位列2014中国房地产开发企业500强第31位', 'upload/images/1395751462000.jpg', '<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">3月19日，由中国房地产研究会、中国房地产业协会与中国房地产测评中心联合主办的&ldquo;2014中国房地产500强测评成果发布会暨500强峰会&rdquo;在北京召开。<strong>旭辉集团位列&ldquo;2014中国房地产开发企业500强&rdquo;综合排名第31位，较去年36位上升5位；同时位列开发企业经营绩效10强第4位，较去年第6位上升2位。</strong></span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">&nbsp;</span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">2月下旬，集团发布的2013年度业绩公告显示，公司去年销售和利润双双创下历史新高，年度合同销售额达153.19亿，同比增长60.5%，并超额完成上调后的全年140亿元销售目标；股东核心盈利则达15.19亿，同比大增长64.9%。每股核心净利润为0.26元人民币，同比增长30%。</span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">3月10日，集团公布，马年前两个月，公司共实现合同销售金额30.2亿元，较上年同期增长约42%。</span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">这些成绩的取得是全体旭辉人共同努力拼搏的结果，是行业和社会对旭辉过去一年成绩的认可和肯定，更是对旭辉未来发展的鞭策和鼓舞。</span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">据悉，2014年的中国房地产500强测评共设立7项一级指标、19项二级指标和40项三级指标。从企业规模、风险管理、盈利能力、成长潜力、运营绩效、创新能力、社会&nbsp;责任七大方面，采用了收入规模、开发规模、偿债能力、增长能力、运营能力、创新能力、社会保障责任等19个二级指标，包括房地产业务收入、房地产销售面&nbsp;积、投资性物业持有面积、现金流动负债比等40个三级指标全面衡量企业的综合实力。&emsp;&emsp;</span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">从这些年的测评成果来看，测评指标从侧重企业规模、盈利能力、成长潜力、运营绩效、创新能力、风险管理等方面，逐渐增加了社会责任、新材料新技术运用、企业创新能力等指标的比重，强调了企业参与保障性安居工程建设、节能减排、税收贡献、社会捐赠等等，使测评成果在展示企业综合实力和社会贡献方面&nbsp;更加完整，为促进房地产业调整、转变发展方式和健康发展起到了积极的引领作用。</span></p>\r\n<p style="padding-bottom: 0px; widows: 2; text-transform: none; text-indent: 2em; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Verdana, 微软雅黑; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span style="text-align: center; widows: 2; text-transform: none; text-indent: 0px; display: inline !important; font: 12px/22px Verdana, 微软雅黑; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(36,36,36); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">据悉，中国房地产100强榜单将在近期发布。</span></p>\r\n<p>\r\n	<br class="Apple-interchange-newline" />\r\n	&nbsp;</p>', '房地产', '', '亿房', 'recommend', '2014-03-25'),
	(151, '上海市房地产开发企业本年到位资金规模缩小', 'upload/images/1395751514593.jpg', '<p>\r\n	&nbsp;</p>\r\n<div class="bzdh fl" style="border-bottom: rgb(210,232,255) 1px solid; border-left: rgb(210,232,255) 1px solid; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(255,255,255); text-indent: 0px; margin: 10px 0px; padding-left: 0px; width: 625px; padding-right: 0px; font: 14px/24px 宋体, arial; white-space: normal; orphans: 2; float: left; letter-spacing: normal; color: rgb(0,0,0); clear: both; border-top: rgb(210,232,255) 1px solid; border-right: rgb(210,232,255) 1px solid; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<dl style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n		<dt style="border-bottom: rgb(210,232,255) 1px solid; padding-bottom: 0px; border-right-width: 0px; margin: 0px; padding-left: 15px; padding-right: 0px; font: bold 14px/30px simsun; border-top-width: 0px; color: rgb(5,80,153); border-left-width: 0px; padding-top: 0px">\r\n			新闻提要</dt>\r\n		<dd style="border-bottom: 0px; border-left: 0px; padding-bottom: 10px; line-height: 26px; margin: 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; overflow: hidden; border-top: 0px; border-right: 0px; padding-top: 10px">\r\n			数据显示，1-2月，上海市房地产开发投资399.23亿元，比去年同期增长5%，增速同比回落15.4个百分点。房地产开发投资占全社会固定资产投资的60.4%，比重同比上升0.6个百分点。</dd>\r\n	</dl>\r\n</div>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 6px 0px; padding-left: 0px; padding-right: 0px; font: 14px/1.8 宋体, arial; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 5px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 6px 0px; padding-left: 0px; padding-right: 0px; font: 14px/1.8 宋体, arial; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 5px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp;<span class="Apple-converted-space">&nbsp;</span><a href="http://www.officese.com/" style="color: rgb(51,51,51); text-decoration: none" target="_blank" title="中华写字楼网">中华写字楼网</a>（<a href="http://www.officese.com/" style="color: rgb(51,51,51); text-decoration: none" target="_blank">http://www.officese.com</a>）：上海市房地产开发企业本年到位资金规模缩小</p>\r\n<p align="center" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<img src="http://www.funxun.com/news/upload/201431991630.jpg" style="border-bottom: medium none; border-left: medium none; max-width: 550px; border-top: medium none; border-right: medium none" /></p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	&nbsp;&nbsp;&nbsp; 今年前两月上海市房地产开发投资和商品房销售面积小幅增长，但增幅明显低于去年；新开工面积和竣工面积大幅度下降；开发企业本年到位资金规模缩小。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　数据显示，1-2月，上海市房地产开发投资399.23亿元，比去年同期增长5%，增速同比回落15.4个百分点。房地产开发投资占全社会固定资产投资的60.4%，比重同比上升0.6个百分点。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　从开发投资构成看，土地购置费投资36.5亿元，比去年同期增长55.9%，占全部开发投资的9.1%，比重同比提高2.9个百分点，拉动房地产开发投资增长3.4个百分点；建筑工程投资289.09亿元，增长2.6%，占72.4%，比重下降1.7个百分点。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　<font size="3"><font face="宋体"><span class="Apple-converted-space" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: 0px; border-right: 0px; padding-top: 0px">&nbsp;</span></font></font>从房屋类型看，住宅投资217.03亿元，比去年同期增长0.2%，占全部开发投资的54.4%，比重同比下降2.6个百分点；<a href="http://www.officese.com/" style="color: rgb(51,51,51); text-decoration: none" target="_blank" title="办公楼">办公楼</a>和商业用房投资121.13亿元，增长18.3%，占30.3%，比重上升3.4个百分点。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　数据还显示， 1-2月，上海市新建商品房销售面积287.17万平方米，比去年同期增长2.9%，增幅同比回落34.5个百分点。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　此外，根据市房地产交易中心统计，1-2月，上海市存量房网签面积250.41万平方米，比去年同期下降29.3%。其中存量住宅网签面积212.65万平方米，下降32.5%，与去年市场火热现象形成对比。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　除了存量房交易大幅下降，商品房新开工和竣工面积也双双大幅下降。数据显示，1-2月，上海市商品房新开工面积254.18万平方米，比去年同期下降52.3%。其中，住宅155.49万平方米，下降51.5%，占商品房新开工面积的比重为61.2%。1-2月，上海市商品房竣工面积385.14万平方米，比去年同期下降38.6%。</p>\r\n<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(242,246,252); text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 14px/30px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	　　数据还显示， 1-2月，房地产开发企业本年到位资金1144.05亿元，由去年同期增长21.8%转为下降2.3％。从资金来源渠道看，作为资金主要构成的国内贷款和其他资金分别增长11.5%和10.7％,但增幅比去年同期分别回落26.7和34.2个百分点；自筹资金下降22.3％。</p>', '房地产', '', '中国证券网', 'recommend', '2014-03-25'),
	(152, '中国房地产500强发布 万科恒大万达跻身前三甲', '', '<p>\r\n	&nbsp;</p>\r\n<div class="mtabstract" id="newxq_B01_28" style="border-bottom: 0px; border-left: 0px; padding-bottom: 11px; widows: 2; text-transform: none; background-color: rgb(238,238,238); list-style-type: none; text-indent: 0px; margin: 15px 0px 0px; padding-left: 11px; padding-right: 11px; font: 12px/24px 宋体, Arial; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(85,85,85); overflow: hidden; border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 11px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<strong>[摘要]</strong>2014中国房地产500强测评成果日前公布。榜单显示，万科、恒大、万达跻身前三甲。</div>\r\n<p>\r\n	&nbsp;</p>\r\n<div id="newxq_B01_05" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(255,255,255); list-style-type: none; text-indent: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font: 12px 宋体, Arial; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(85,85,85); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<div class="mtcomment" id="news_body" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; list-style-type: none; margin: 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; overflow: hidden; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 26px; list-style-type: none; text-indent: 28px; margin: 20px 0px 0px; padding-left: 0px; padding-right: 0px; overflow: visible; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			2014中国房地产500强测评成果日前公布。榜单显示，万科、恒大、万达跻身前三甲。</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 26px; list-style-type: none; text-indent: 28px; margin: 20px 0px 0px; padding-left: 0px; padding-right: 0px; overflow: visible; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			记者查询发现，多家渝派地产上榜，其中龙湖地产(第10)、金科地产(第20)、隆鑫地产(第43)入前50强席位。此外，中国房地产研究会还发布了旅游地产10强榜单，我市隆鑫地产上榜，位居第8名。</p>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '华龙网', '', '2014-03-25'),
	(153, '特普丽再次荣获“中国房地产开发500强首选供应商品牌”', 'upload/images/1395752003328.jpg', '<p>\r\n	&nbsp;</p>\r\n<p id="digest" style="border-bottom: rgb(219,219,219) 1px solid; border-left: rgb(219,219,219) 1px solid; padding-bottom: 10px; widows: 2; text-transform: none; background-color: rgb(251,251,251); text-indent: 0px; margin: 5px auto; padding-left: 15px; width: 519px; padding-right: 15px; font: 12px/1.6 宋体, arial, serif; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(102,102,102); border-top: rgb(219,219,219) 1px solid; border-right: rgb(219,219,219) 1px solid; word-spacing: 0px; padding-top: 10px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<span class="fred fbold" style="color: rgb(204,0,0)">摘要：</span>2014年3月19日，特普丽墙纸应邀出席由中国房地产研究会、中国房地产业协会、中国房地产测评中心主办的&ldquo;2014年中国房地产500强测评成果发布会&rdquo;，行政中心总监李济公、工程部经理段合军到场参加。恒大集团、绿城集团、保利地产、万科集团等房地产企业董事长、总经理等皆出席了本次会议。与此同时，特普丽墙纸</p>\r\n<div class="blkContainerSblkCon BSHARE_POP" id="artibody" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; widows: 2; text-transform: none; background-color: rgb(245,248,253); text-indent: 0px; margin: 15px 0px 0px; padding-left: 0px; padding-right: 0px; font: 14px/23px Simsun; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(0,0,0); border-top: 0px; border-right: 0px; word-spacing: 0px; padding-top: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">\r\n	<div id="articleText" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; font-size: 12px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n		<div class="articleTextad" id="b09" style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; float: left; font-size: 12px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&nbsp;</div>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;<b>特普丽再次荣获&ldquo;中国房地产开发</b><b>500</b><b>强首选供应商品牌&rdquo;</b></p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;2014年3月19日，特普丽墙纸应邀出席由中国房地产研究会、中国房地产业协会、中国房地产测评中心主办的&ldquo;2014年中国房地产500强测评成果发布会&rdquo;，行政中心总监李济公、工程部经理段合军到场参加。恒大集团、绿城集团、保利地产、万科集团等房地产企业董事长、总经理等皆出席了本次会议。与此同时，特普丽墙纸在本次评选中荣获&ldquo;2014中国房地产开发企业500强首选供应商&middot;墙纸类&rdquo;称号</p>\r\n		<p style="border-bottom: 0px; text-align: center; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			<img height="313" src="http://src.house.sina.com.cn/imp/imp/deal/07/21/e/0452b9505db7a2c4371941fc24d_p1_mk1.jpg" style="border-bottom: rgb(0,0,0) 1px solid; border-left: rgb(0,0,0) 1px solid; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: rgb(0,0,0) 1px solid; border-right: rgb(0,0,0) 1px solid; padding-top: 0px" width="428" /><br />\r\n			<span class="img_wrapper_img_descr">&nbsp;</span></p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;图为：中国房地产研究会会长刘志峰发表讲话</p>\r\n		<p style="border-bottom: 0px; text-align: center; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			<img height="285" src="http://src.house.sina.com.cn/imp/imp/deal/43/68/e/835bdb2eee190d4ff75f65d455d_p1_mk1.jpg" style="border-bottom: rgb(0,0,0) 1px solid; border-left: rgb(0,0,0) 1px solid; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: rgb(0,0,0) 1px solid; border-right: rgb(0,0,0) 1px solid; padding-top: 0px" width="428" /><br />\r\n			<span class="img_wrapper_img_descr">&nbsp;</span></p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;图为：特普丽荣获&ldquo;2014中国房地产开发企业500强首选供应商&middot;墙纸类&rdquo;</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;会议中，与中国房地产500强开发商测评同步进行，被誉为建筑部品领域&ldquo;奥斯卡&rdquo;盛典的2014中国房地产开发企业500强首选供应商(壁纸类)品牌评选，在经历了备选企业报名、线上影响力投票、行业协会专家提名、采购平台在线口碑评价、开发商评审等六个阶段的评选后，最终结果已揭晓，北京特普丽装饰装帧材料有限公司生产的墙纸类产品，以高达20%的品牌首选率，高居500强首选供应商品牌(墙纸类)榜首。</p>\r\n		<p style="border-bottom: 0px; text-align: center; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			<img height="380" src="http://src.house.sina.com.cn/imp/imp/deal/3d/1a/1/f60bc8a7af77f42f9fcc9ccee9d_p1_mk1.jpg" style="border-bottom: rgb(0,0,0) 1px solid; border-left: rgb(0,0,0) 1px solid; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: rgb(0,0,0) 1px solid; border-right: rgb(0,0,0) 1px solid; padding-top: 0px" width="369" /><br />\r\n			<span class="img_wrapper_img_descr">&nbsp;</span></p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;图为：500强峰会现场发布特普丽墙纸高居中国房地产开发企业墙纸类供应商品牌榜首</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;特普丽在中国墙纸市场突飞猛进的发展时代中，始终坚持针对不同市场、不同区域、不同群体的墙纸功能个性化需求和墙纸消费多元化的发展需要，39年来开拓进取、进行新技术、新材料、新工艺的研发创新，并聘请国际顶尖设计大师博恩&middot;哈根、日本技术教父新国敬进行产品、工艺、技术、设计的研发，从而大力推动着特普丽墙纸不断向科技化、环保化、时装化方向迈进。</p>\r\n		<p style="border-bottom: 0px; text-align: center; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			<img height="342" src="http://src.house.sina.com.cn/imp/imp/deal/fe/eb/5/4c5ecc148d41a4d21be33882035_p1_mk1.jpg" style="border-bottom: rgb(0,0,0) 1px solid; border-left: rgb(0,0,0) 1px solid; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: rgb(0,0,0) 1px solid; border-right: rgb(0,0,0) 1px solid; padding-top: 0px" width="455" /><br />\r\n			<span class="img_wrapper_img_descr">&nbsp;</span></p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;图为：特普丽墙纸行政中心总监李济公(左二)出席并领取首选供应商品牌铜牌</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;为了更好的适应国内房地产开发企业的个性化定制、产品供应、售后服务等需求，特普丽墙纸与恒大集团、绿城集团、招商地产、华远地产、合生创展等房地产开发企业建立了长期战略合作关系，与万科地产、保利地产、绿地集团、万达集团、龙湖地产、远洋地产等30余家房地产开发企业建立了长期合作伙伴关系，特普丽产品得到了房地产开发企业的充分首肯，为中国房地产开发企业的平稳发展做出了突出贡献。</p>\r\n		<p style="border-bottom: 0px; text-align: center; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			<img height="349" src="http://src.house.sina.com.cn/imp/imp/deal/d6/8c/b/680f33761624b82b48c9037b373_p1_mk1.jpg" style="border-bottom: rgb(0,0,0) 1px solid; border-left: rgb(0,0,0) 1px solid; padding-bottom: 0px; margin: 0px; padding-left: 0px; padding-right: 0px; border-top: rgb(0,0,0) 1px solid; border-right: rgb(0,0,0) 1px solid; padding-top: 0px" width="463" /><br />\r\n			<span class="img_wrapper_img_descr">&nbsp;</span></p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;图为：中国房地产开发500强峰会特普丽企业展示</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;在今后的发展及建设中，特普丽将秉承&ldquo;创新、务实、协作&rdquo;的价值观，坚持&ldquo;以质量求生存、以创新求发展；提供一流产品、实现满意服务&rdquo;的经营理念，以最顶级的设计、最尖端 的工艺技术、最时尚的墙纸为中国房地产企业的发展做出更完善的市场服务。</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;特普丽墙纸</p>\r\n		<p style="border-bottom: 0px; border-left: 0px; padding-bottom: 0px; line-height: 23px; margin: 15px 0px; padding-left: 0px; padding-right: 0px; font-size: 14px; border-top: 0px; border-right: 0px; padding-top: 0px">\r\n			&emsp;&emsp;2014年3月21日</p>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '新浪家居', 'recommend', '2014-03-25'),
	(154, '2014中国房地产500强在京揭晓', '', '<p>\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　日前，&ldquo;2014中国房地产500强测评成果发布会暨500强峰会&rdquo;在北京举行。这是中国房地产研究会、中国房地产业协会与中国房地产测评中心连续第六年进行此项测评。会上发布了《2014中国房地产开发企业500强测评研究报告》，并发布了2014中国房地产开发企业500强、500强房企首选供应商品牌两大主榜单，以及房地产开发企业综合实力10强等系列子榜单。</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　测评报告认为，2013年房地产开发企业整体业绩再上台阶，市场集中度再次提高，资源进一步向大企业集中，小型房地产开发企业的景气度直线下降，部分中小房企将逐渐被边缘化。在房地产开发企业500强榜单中，万科集团连续六年位居榜首，恒大地产和万达集团分列第二名和第三名。随着房地产市场的波动和各区域市场的分化，近年来持续的产业集中度提升之势在2013年得以延续，不管是以金额和面积计算的房地产业集中度，还是500强房地产开发企业市场份额，均持续保持高位;赢利能力也有所回升，2013年500强房地产开发企业净利润均值为4.64亿元，同比上升7.26%，终止了2011年以来的下滑趋势;但偿债压力普遍上升，净负债率均值达到近五年来的最高点。</span></p>', '房地产', '王坤朔', '参考消息?北京参考', '', '2014-03-25'),
	(155, '中国房地产500强测评 天朗控股领军西北连斩大奖', '', '<p>\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　2014中国房地产500强测评成果3月19日在北京公布。西部地产企业龙头&mdash;天朗控股集团表现优异，以综合排名第72位继续领跑西北房企，同时荣膺全国房地产企业发展潜力10强、成长速度10强等多项殊荣，瞩目全国。毫无疑问，天朗控股的实力凸显又一次印证了西部房企的全国地位正在迅速攀升。</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　区域龙头 名扬峰会</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　日前， 2014中国房地产开发企业500强测评成果发布会在北京举行，现场发布了《2014中国房地产开发企业500强测评研究报告》。西部地产企业龙头&mdash;天朗控股集团表现优异，以综合排名第72位继续领跑西北房企，同时当选全国房地产开发企业发展潜力10强、成长速度10强等多项殊荣，瞩目全国。毫无疑问，天朗控股的实力凸显又一次印证了西北房企的全国地位正在迅速攀升。</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　据悉，中国房地产500强测评活动由中国房地产研究会、中国房地产业协会及中国房地产测评中心举办，力求以权威的数据、科学的测评方法全面客观的评价房地产开发企业的成绩，并向社会公布，今年已经举办第六届。活动当日，来自全国的业内领导和专家，以及房地产企业、研究机构和媒体人士近500人出席了本次峰会。</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　转型典范 布局全国</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　从2001年创业于古都西安，到2005年介入土地一级开发与整理并独创&ldquo;城系开放&rdquo;模式，再到2010年实现了由区域迈向全国的战略转型，过去的十余年间，天朗控股一直在积极探索行业及城市整合运营新模式，更以无私的奉献精神，本着区域龙头企业的责任担当，带领西北房企不断探索城市变革背景下的行业转型和企业升级之路，成为中国第三代房地产典范企业。</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　2013年，天朗控股集团成功实现以&ldquo;投资及资本融通、开发建设管理、产业综合运营&rdquo;为核心能力推动，开创了以城市区域文脉传承与弘扬为背景、实体产业经济导入及产业业态合理化布局为支撑、整合各项功能服务配套为保障的中国城市文化产业集群产业模式，成功打造出天朗&middot;文化集核心产品运营形态，推动中国城市化进程的可持续健康发展，成为一家以中国城市文化产业投资与运营为主营业务的全国性企业集团。</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　源于西安 奉献全国</span><br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<br style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; font: 14px/24px 宋体; white-space: normal; orphans: 2; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="text-align: left; widows: 2; text-transform: none; background-color: rgb(231,240,247); text-indent: 0px; display: inline !important; font: 14px/24px 宋体; white-space: normal; orphans: 2; float: none; letter-spacing: normal; color: rgb(51,51,51); word-spacing: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　天朗控股成立十余年来一直在积极探索行业及城市整合运营新模式，更以无私的奉献精神，本着区域龙头企业的责任担当，凭借城市区域版块综合性布局和整体化运营，提升区域版块经济，探寻城市可持续发展运营的全新路径。当前形势下，需要更多天朗控股这样的企业出现，为行业营造良好的发展环境，赢得社会的尊重与认可。</span></p>', '房地产', '', '搜狐资讯', '', '2014-03-25'),
	(156, '让新型农业经营主体融资不再难', '', '<p>\r\n	前不久，河北省两家省级农业产业化重点龙头企业&mdash;&mdash;同和生物制品有限公司和香道食品有限公司通过&ldquo;金财通&rdquo;融资模式，分别从邯郸银行获得了500万元的贷款，解了企业的燃眉之急。</p>\r\n<p>\r\n	&ldquo;金财通&rdquo;是邯郸市财政创新融资模式，帮助涉农企业缓解融资难的一个新举措。此举在河北省尚属首例，为破解新型农业经营主体融资困局提供了有益的探索。</p>\r\n<p>\r\n	&ldquo;量身定制&rdquo;的扶持方式</p>\r\n<p>\r\n	&ldquo;近年来，随着农业农村经济发展，一批新型农业生产经营主体脱颖而出，种养大户、农民专业合作社、农业企业这&lsquo;三类主体&rsquo;已成为农业农村发展的中坚力量。&rdquo;邯郸市农业产业化办公室副主任孟繁军说，但这&ldquo;三类主体&rdquo;在生产经营中也遇到了一些亟待解决的难题，融资难首当其冲。以农业企业为例，邯郸市市级以上农业产业化龙头企业有410家，都在不同程度上受到资金短缺的困扰。有的企业规模小、效益不稳定，在遭遇资金短缺想贷款时难以提供足值抵押物、难以获得担保，进而无法贷款，又反过来影响了企业的进一步发展。</p>\r\n<p>\r\n	为解决涉农企业贷款条件不足、银行放贷怕风险的问题，邯郸市按照&ldquo;政府引导、市场运作、政银合作、企业受益&rdquo;的思路，深入调研，积极洽谈，与邯郸银行合作推出了&ldquo;金财通&rdquo;融资模式。</p>\r\n<p>\r\n	所谓&ldquo;金财通&rdquo;，是指邯郸市财政安排专项资金与银行合作，帮助邯郸行政区域内农业产业化企业申请获得1年期以内、500万元以下流动资金的融资贷款模式。主要支持邯郸市行政区域内技术有优势、产品有市场、发展潜力较大、社会诚信良好，但担保能力不够银行贷款条件的农业产业化企业。</p>\r\n<p>\r\n	&ldquo;&lsquo;金财通&rsquo;模式的运行，给这些企业带来生机。&rdquo;邯郸市财政局农业处处长杨文学介绍说，邯郸银行每年安排一定规模的资金定向支持，并组织了专业团队专司服务&ldquo;金财通&rdquo;，当天签合同当天放贷。而且利率执行最高上浮上限不超过银行同期贷款基准利率的30%，就目前来看利率是较低的。</p>\r\n<p>\r\n	&ldquo;与其他企业贷款形式相比，&lsquo;金财通&rsquo;最适合农业产业化企业，是量身打造出的&lsquo;特供&rsquo;扶持方式。&rdquo;杨文学说，&ldquo;金财通&rdquo;具备门槛低、无抵押、资金足等特点。门槛低&mdash;&mdash;只要企业照章纳税、符合环保要求，即可提出申请；无抵押&mdash;&mdash;企业无需提供抵押、担保，只要满足相关条件，即可获得银行贷款；资金足&mdash;&mdash;邯郸银行每年安排一定规模的定向支持资金，可满足农业产业化企业需求。</p>\r\n<p>\r\n	撬动贷款资金16亿元</p>\r\n<p>\r\n	&ldquo;金财通&rdquo;最大亮点是市、县两级财政按比例拿出专项资金，与银行合作，共同支持农业产业化发展。据了解，这种由财政出资提供担保、银行配合安排贷款的<a href="http://auto.ifeng.com/news/finance/" target="_blank"><font color="#004276">金融</font></a>运作方式，邯郸市是全国第三家。</p>\r\n<p>\r\n	按照协议，&ldquo;金财通&rdquo;由县市区政府出资不低于500万元，市财政按1∶1比例配套，向邯郸银行存入贷款增信保证金，邯郸银行承诺按不低于保证金的8倍安排贷款规模，向农业产业化企业提供贷款服务。</p>\r\n<p>\r\n	&ldquo;理论上计算，如果全市各县市区全部签订了&lsquo;金财通&rsquo;贷款协议，我市农业产业化企业将有可能获得16亿元的贷款资金支持。这么大的资金量全部投入到涉农企业的话，必将对地域经济和企业发展产生极大的推动力。&rdquo;杨文学说。</p>\r\n<p>\r\n	&ldquo;金财通&rdquo;优点多多，那么企业想办贷款，申请容易吗？&ldquo;贷款程序相对简易，概括说，就是企业申请、部门审核、政府推荐、银行审批。&rdquo;杨文学说，凡自愿申请&ldquo;金财通&rdquo;的农业产业化企业，一般要在每年的3月、9月集中向所在地县市区财政局和农业产业化办公室提出贷款申请。如果企业因临时性、突发性原因造成资金不足的，可以随时按程序申请贷款。</p>\r\n<p>\r\n	据悉，为确保&ldquo;金财通&rdquo;农业产业化贷款安全高效运行，邯郸市出台了《&ldquo;金财通&rdquo;农业产业化企业融资办法（试行）》，明确财政部门、农业产业化部门作为&ldquo;金财通&rdquo;主管部门，负责增信保证金的筹集和动态管理。市、县两级财政每年在预算中安排风险补偿金，财政和农业产业化部门定期研究分析贷款使用、生产经营等情况，启动贷后管理措施。</p>\r\n<p>\r\n	为企业铺就&ldquo;金光道&rdquo;</p>\r\n<p>\r\n	&ldquo;&lsquo;金财通&rsquo;帮了企业大忙，贷款资金只周转了一次，企业就增收几百万。&rdquo;香道食品有限公司副总经理严洪波说，前不久企业收储主要原材料时，突然发现流动资金有了缺口。正当发愁之际，市、县两级财政和邯郸银行合作推出&ldquo;金财通&rdquo;贷款模式，让严洪波他们抓到了&ldquo;救命稻草&rdquo;。</p>\r\n<p>\r\n	&ldquo;&lsquo;金财通&rsquo;门槛低、不用抵押物、审批流程快，只用了半个月工夫，就贷到500万元。&rdquo;严洪波心里算口里说，500万元可增加原材料收购量5000吨，按照每吨450元的利润计算，可增加200多万元的经济效益。</p>\r\n<p>\r\n	同和生物制品有限公司是邯郸市十大农业产业化重点龙头企业，该公司引进法国成套鸡蛋粉生产线设备，每天可消化鸡蛋130余吨，实现年销售收入3亿元，直接带动农业增效和农民增收1亿元以上，是目前国内最大的蛋品加工企业之一。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	该公司董事长张欣荣说，公司目前正处于快速成长期，急需配套生产资金。正在这时，市、县通过&ldquo;金财通&rdquo;贷款模式给予公司大力支持，解了公司燃眉之急。</p>\r\n<p>\r\n	&ldquo;&lsquo;金财通&rsquo;贷款资金注入后，公司发展规模有了扩大，订单量有了显著提升。&rdquo;张欣荣说，&ldquo;金财通&rdquo;给公司带来了三件喜事：一是与北京一家公司签订了2014年的成品蛋进京销售协议，仅这一项，就可为公司增加收入2000万元；二是扩大了对蒙牛集团的鲜蛋产品供应量，在今年2000万元销售额的基础上，明年将增加到5000万至6000万元；三是因为与邯郸银行签订&ldquo;金财通&rdquo;贷款合同，同时又获得政府的支持，公司信誉度得到提升。</p>\r\n<p>\r\n	&ldquo;可以说，&lsquo;金财通&rsquo;为企业铺就出了&lsquo;金光道&rsquo;。&rdquo;张欣荣说。</p>', '农业', '', '中国财经报', '', '2014-04-12'),
	(157, '甘肃礼县已完成旱作农业6.8万亩', 'upload/images/1397276216140.jpg', '<p>\r\n	　　春耕生产开始以来，礼县把旱作农业作为全年农业工作的&ldquo;第一场硬仗&rdquo;来打，早安排，早部署，抢抓农时，下派技术人员，积极运送农资，全力开展旱作农业工作。截至目前，全县已完成旱作农业6.8万亩。</p>', '农业', '', '新农网', '', '2014-04-12'),
	(158, '专访：“中国在工业技术领域很有竞争力”', 'upload/images/1397276615812.jpg', '<p>\r\n	&nbsp;</p>\r\n<p>\r\n	　　新华网雅典4月11日电（记者陈占杰）从北凯&middot;科波内先生泛着笑意的眼神里，我知道自己的问题可能有点笨。果然，回答&ldquo;在工业技术领域中国比欧洲和<a href="http://news.hexun.com/usa/index.html" target="_blank">美国</a>落后多少&rdquo;这个问题时，科波内反问我：&ldquo;落后？怎么可能？&rdquo;</p>\r\n<p>\r\n	　　4月10日，在希腊首都雅典的大国际会议中心，刚刚主持完欧洲工业技术大会第二次全会的科波内先生接受了记者的专访。因为接下来还有另一场活动，采访时间只有30分钟。</p>\r\n<p>\r\n	　　为期三天的第三届欧洲工业技术大会9日在雅典大国际会议中心开幕，来自世界各国的1000多名代表在这里展示和交流其在纳米、生物技术、先进材料技术和高科技制造技术等方面的最新成果。</p>\r\n<p>\r\n	　　从诺基亚公司&ldquo;跳槽&rdquo;出来的科波内先生是芬兰斯宾沃（Spinverse，字面意思是搅动宇宙）公司的首席执行官。十几年来，这家不大的高科技孵化公司参与组织了前两届欧洲工业技术大会和很多类似的会议，致力于把科研、工业和政府几方面的力量结合起来，以高科技手段推动社会进步。</p>\r\n<p>\r\n	　　科波内说，自从第一届欧洲工业技术大会2010年在布鲁塞尔举行以来，这一活动的参与人数越来越多，涉及的行业越来越广，特别是欧洲地区之外的代表开始参与，其影响已经超越了欧洲。</p>\r\n<p>\r\n	　　从上个世纪90年代中期第一次踏上中国土地开始，科波内去中国的次数连自己也数不清了，中国的朋友们给他起了一个中文名字叫&ldquo;北凯&rdquo;，他说&ldquo;<a href="http://news.hexun.com/beijing/index.html" target="_blank">北京</a>的北，当大门讲的凯&rdquo;。</p>\r\n<p>\r\n	　　关于中国举行类似会议的前景，科波内说：&ldquo;中国是个非常有诱惑力的市场，我们愿意在那里举行这样的会议。&rdquo;他已经就此和中国一些部门有过接触，他本人非常愿意把中国纳入工业技术创新的国际网络，把欧洲的首席技术官和相关部门官员带到中国，和中国同行一起，加速技术创新进程。</p>\r\n<p>\r\n	　　在谈到中国与欧美等发达国家在科技创新方面的差距时，科波内笑着说：&ldquo;中国落后？我认为中国在这方面发展得早已经比欧美快了，中国在工业技术领域很有竞争力。&rdquo;</p>\r\n<p>\r\n	　　</p>\r\n<div align="center">\r\n	<img alt="4月10日，在希腊首都雅典的大国际会议中心，刚刚主持完欧洲工业技术大会第二次全会的科波内先生接受了记者的专访。因为接下来还有另一场活动，采访时间只有30分钟。" border="1" height="359" src="http://i9.hexunimg.cn/2014-04-12/163862113.jpg" style="margin: 4px; border: 1px solid rgb(0, 0, 0);" width="500" /></div>\r\n<p>\r\n	　　他说，中国人很聪明。中国政府在对外开放之初，就凭借自己丰厚的劳动力资源和10几亿人口的市场，吸引大批有实力的外国公司到中国投资设厂。此后，中国的产品开始往欧洲出口。</p>\r\n<p>\r\n	　　&ldquo;开始是简单的产品，后来复杂的产品，比如机械和电子产品也大量出口，很多欧洲人干脆把工厂搬到了中国。&rdquo;科波内说。</p>\r\n<p>\r\n	　　他说，后来欧洲商人有了新想法：让中国生产产品，欧洲从事研发和创新，最终产品在欧洲包装和销售。科波内说，中国在研发方面进步也很快，比如在信息通讯技术领域，联想、<a href="http://gongsi.hexun.com/fc_285.shtml" target="_blank">华为</a>等中国公司在国际上已经极具竞争力。</p>\r\n<p>\r\n	　　不过，科波内也指出，在有些领域，中国还需要进行更多努力。他说，在环保清洁技术方面，中国可能需要西方的专业知识。当然，在这一领域，中国有自己的特殊情况，中国相关项目的规模也将比西方国家大许多。</p>\r\n<p>\r\n	　　科波内强调的另一个领域是生物能源，因为现在中国高度依赖进口石油和其他能源产品，在生物能源领域中国应加大投资。科波内说，他注意到中国一些公司已经在能源领域扩张到其他国家，中国政府也把它列入了最优先的日程。</p>\r\n<p>\r\n	　　目前，斯宾诺公司在中国主要从事两方面的工作，一是就技术创新向各级政府提供咨询，二是为欧洲和中国的公司牵线搭桥，重点放在高科技领域的研发方面。</p>\r\n<p>\r\n	　　在谈到中国这些年取得飞速进步的原因时，科波内认为，和欧洲人比起来，中国人工作非常努力，也更渴望取得成就。比如，像本届大会这样三天的会议，欧洲通常会在周二至周四举行，而周一时与会者做做参加会议的准备，周五会议结束后回家休息一下，再加上两个周末，这样一个会要用9天的时间。而中国人周一至周五正常上班，会议选周末举行，这样只用两天的时间就开完了同样的会。</p>\r\n<p>\r\n	　　&ldquo;这样，你就可以看到中国为什么更有竞争力了。&rdquo;科波内笑着说。</p>\r\n<p>\r\n	　　展望中国科技创新的前景时，科波内希望中国在研发方面更加协调，解决研发融资等方面的实际问题，鼓励西方公司和中国公司合作，为科研成果从大学向市场转化创造条件。</p>\r\n<p>\r\n	　　在谈到斯宾沃这个公司名称的寓意时，科波内说：&ldquo;我们公司人很少，但做了不少大项目，公司的名称表明我们很勇敢，我们要搅动整个宇宙。&rdquo;</p>', '工业', '陈占杰', '新华网', 'hot', '2015-08-05'),
	(159, '2016年重庆工业机器人市场规模将达120亿元', '', '<p>\r\n	&nbsp;</p>\r\n<p>\r\n	　　本报讯 (记者 陈钧)正在举行的&ldquo;高交会&rdquo;上,各式各样的机器人各显神通,让市民大开眼界。但正如&ldquo;外行看热闹,内行看门道&rdquo;,4月11日,记者从带着近10款机器人参展高交会的<a href="http://news.hexun.com/chongqing/index.html" target="_blank">重庆</a>华数机器人有限公司获悉,到2016年,重庆的工业机器人产业蛋糕将达到120亿元规模,届时,机器人的&ldquo;身体、大脑、神经、心脏和血管等重要器官&rdquo;,都将实现本地制造。</p>\r\n<p>\r\n	　　华数机器人公司是两江新区去年引进的一家国内机器人制造领军企业。</p>\r\n<p>\r\n	　　(下转2版)</p>\r\n<p>\r\n	　　2016年重庆工业 机器人相关需求</p>\r\n<p>\r\n	　　(单位:亿元)</p>\r\n<p>\r\n	　　汽车工业 60</p>\r\n<p>\r\n	　　装备制造业 20</p>\r\n<p>\r\n	　　电子信息产业 15</p>\r\n<p>\r\n	　　化学工业 12</p>\r\n<p>\r\n	　　消费品工业 7</p>\r\n<p>\r\n	　　材料工业 6</p>', '工业', '陈钧', '重庆日报', 'focus', '2015-08-05'),
	(160, '环保/科技/复古 2014北京车展豪车前瞻', 'upload/images/1397904568234.jpg', '<p>\r\n	<strong>法拉利<span name="HL_TAG" style="border-bottom: 0px dotted; color: #0084d8; cursor: hand; text-decoration: underline">California</span> T</strong></p>\r\n<p>\r\n	<strong>关键词：3.8T增压<span name="HL_TAG" style="border-bottom: 0px dotted; color: #0084d8; cursor: hand; text-decoration: underline">发动机</span></strong></p>\r\n<p>\r\n	<strong>上市时间：未知</strong></p>\r\n<p align="center" style="text-align: center">\r\n	<img align="center" border="0" hspace="0" id="{93DB1FDE-7644-4BF3-856B-0084E53E4E59}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330643751n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　法拉利California T在法拉利的产品线中比较特殊，是一款硬顶敞篷2+2跑车，之所以取名为California，大概是那种蕴含着加州海岸公路畅游的闲适，与458/<span>LaFerrari</span>等奔跑机器还是有一定区别的。</p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{DE25B719-59D6-47BF-86E1-DEDBE299C0F7}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330643901n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p align="center">\r\n	<img align="center" border="0" height="197" hspace="0" id="{7D396493-82A1-462B-83AD-3C9C9478A22D}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330644061n.jpg" style="border-bottom: #000000 0px solid; border-left: #000000 0px solid; border-top: #000000 0px solid; border-right: #000000 0px solid" title="" width="296" />&nbsp;<img align="center" border="0" height="197" hspace="0" id="{587DD521-17F5-45EE-94FE-CC4C303BDD16}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330644211n.jpg" style="border-bottom: #000000 0px solid; border-left: #000000 0px solid; border-top: #000000 0px solid; border-right: #000000 0px solid" title="" width="296" /></p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{5B9D5B58-697E-4781-BC5E-2AC0087F7824}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330644371n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{81F93F71-E009-41BC-BC11-6AC3EE5247F3}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330644531n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　新车在<span name="HL_TAG" style="border-bottom: 0px dotted; color: #0084d8; cursor: hand; text-decoration: underline">外观</span>内饰上和法拉利California并没有太显著的区别，外观上新车采用了类似LaFerrari的头灯，内饰最明显的不同还是中央空调出风口上增加的增压值显示仪表。</p>\r\n<p align="center" style="text-align: center">\r\n	<img align="center" border="0" hspace="0" id="{1908D459-6B26-4E17-A986-9961DC964371}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330644681n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　此次，法拉利California T与现售的法拉利California最大的不同是采用了一台3.8L涡轮增压发动机，最大功率560马力，最大扭矩750Nm，排量的降低使得二氧化碳的排放量有所减少，250g/km的数值水平相比现款<span name="HL_TAG" style="border-bottom: 0px dotted; color: #0084d8; cursor: hand; text-decoration: underline">车型</span>降低了约15%。</p>\r\n<p>\r\n	<strong>兰博基尼Hurac&aacute;n LP 610-4</strong></p>\r\n<p>\r\n	<strong>关键词：战斗版座舱</strong></p>\r\n<p>\r\n	<strong>上市时间：今年下半年</strong></p>\r\n<p align="center" style="text-align: center">\r\n	<img align="center" border="0" hspace="0" id="{D2003F82-9B4C-4781-9518-CB7C7818A44F}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330644841n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　Huracan被视为是Gallardo的继任者，将在北京车展上完成亚洲首发。Huracan的名字在西班牙语中直译为&ldquo;飓风&rdquo;。相对前作从外观来看，Huracan全新设计的前大灯和进气口造型看上去更加凶狠更具攻击性。</p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{E7B81B64-217D-41C7-A91A-6750EF3C4ED1}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330645001n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　外观设计上，取材兰博基尼最新旗舰车型Aventador，贲张的进气格栅以及Y型日间行车灯看起来相当犀利。车身侧面还是兰博基尼跑车经典的造型。</p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{17B491D9-930F-4A85-A078-8021F0EF7020}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330645151n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　车尾相对于Callardo有了很大的提升，相比后者平实的车尾，新车的层次感更加明显，横置Y型LED尾灯以及蜂窝状散热口逐渐成为了兰博基尼车尾的标识。</p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{E7422F80-54A2-4A2C-AA90-C9127D27D0DC}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330645311n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p>\r\n	　　战斗机般的内饰是新车浓墨重彩的一笔，相对于Gallardo各种奥迪元素的内饰，新车的设计相当精彩。浮雕式仪表和空调出风口很有科技感，液晶屏仪表和飞机开关样按钮组成的中控台更是提升了车内的战斗感。</p>\r\n<p align="center">\r\n	<img align="center" border="0" hspace="0" id="{EFF7AA8F-4C25-4D08-805C-818D05D026AD}" qvod="0" sourcedescription="" sourcename="" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330645461n.jpg" style="border-right-width: 0px; border-top-width: 0px; border-bottom-width: 0px; border-left-width: 0px" title="" /></p>\r\n<p align="center">\r\n	<img align="默认" border="0" id="{78FE344E-D4C1-4F5A-A92C-29899A423AB2}" qvod="0" sourcedescription="编辑提供的本地文件" sourcename="本地文件" src="http://news.xinhuanet.com/auto/2014-04/14/126386285_13974330645621n.jpg" style="width: 600px; height: 399px" title="" /></p>\r\n<p align="center">\r\n	（图片来源：汽车之家）</p>\r\n<p>\r\n	　　动力方面，兰博基尼Huracan LP 610-4搭载的是一台5.2L V10发动机，最大输出功率为610马力/8250rpm，峰值扭矩可达到560N&middot;m/6500rpm，传动部分匹配7速双离合变速箱。新变速箱的加入或许可以让这台蛮牛在低速行驶时获得更好的动力平顺性。兰博基尼经典的中置四驱设定则是这台车操控性的保证。</p>', '汽车', '', '新华汽车', 'recommend', '2014-04-19'),
	(161, '亚马逊的“生态圈”野心：机顶盒后是手机', 'upload/images/1397993217031.jpg', '<p class="Introduction">\r\n	[<strong>摘要</strong>]电纸书、平板电脑、机顶盒&hellip;&hellip;亚马逊正在走出电商领域，构筑硬件生态圈。&nbsp;</p>\r\n<div bosszone="content" id="Cnt-Main-Article-QQ" style="position: relative">\r\n	<p style="text-indent: 2em">\r\n		<strong>腾讯科技 长歌 4月18日编译</strong></p>\r\n	<p style="text-indent: 2em">\r\n		软件、服务和硬件，原本是科技市场相互隔离的三大领域，但随着&ldquo;巨头效应&rdquo;的不断蔓延，越来越多的科技大鳄开始跨界经营，不仅是为了寻求更多的营收，更是为了打造一体化的平台&mdash;&mdash;用时下流行的说法，就是构建自己的生态系统。</p>\r\n	<p style="text-indent: 2em">\r\n		<!--keyword--><span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/AMZN.OQ.htm" target="_blank"><!--/keyword-->亚马逊<!--keyword--></a></span><!--/keyword-->便是其中最引人注目的大鳄之一。</p>\r\n	<p style="text-indent: 2em">\r\n		<strong>Fire TV延续既有硬件战略</strong></p>\r\n	<p style="text-indent: 2em">\r\n		4月2日，亚马逊刚刚发布了全新的FireTV机顶盒。而据知情人士透露，该公司现在又准备推出智能手机。这足以表明，亚马逊已经将自身定位为一家硬件公司，准备与<!--keyword--><span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/AAPL.OQ.htm" target="_blank"><!--/keyword-->苹果<!--keyword--></a></span><!--/keyword-->、<!--keyword--><span><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/GOOG.OQ.htm" target="_blank"><!--/keyword-->谷歌<!--keyword--></a></span>(<a href="http://t.qq.com/googlechina#pref=qqcom.keyword" rel="googlechina" reltitle="谷歌" target="_blank">微博</a>)<!--/keyword-->和三星同场竞技。</p>\r\n	<p align="center">\r\n		&nbsp;</p>\r\n	<div class="mbArticleSharePic " r="1" style="width: 616px">\r\n		<div class="mbArticleShareBtn">\r\n			<span>转播到腾讯微博</span></div>\r\n		<img alt="不只是电商：亚马逊图谋硬件市场" src="http://img1.gtimg.com/tech/pics/hv1/60/187/1571/102202020.jpg" /></div>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p align="center">\r\n		图一：亚马逊最近一年股价走势</p>\r\n	<p style="text-indent: 2em">\r\n		虽然今年以来的走势不佳，但过去一年间，亚马逊股价还是从265美元上涨到317美元。该股过去3个月股价下跌的主要原因是营收增长放缓。不难看出，这家电子商务巨头之所以选择进军其他硬件领域，很重要的原因就是为了恢复营收增长。</p>\r\n	<p style="text-indent: 2em">\r\n		该公司目前是全球第一大在线零售商，它出售的产品涵盖百货、图书、音乐和数字内容等诸多领域。不过，亚马逊并非最近才开始觊觎硬件市场，早在2007年11月，它就推出了Kinlde电子阅读器。2011年9月，它又发布了KindleFire平板电脑。随后又陆续升级了这些产品。由此看来，无论是机顶盒还是智能手机，都是在不断加码的前提下，延伸了既有战略。</p>\r\n	<p style="text-indent: 2em">\r\n		<strong>构建生态系统</strong></p>\r\n	<p style="text-indent: 2em">\r\n		亚马逊的硬件产品一向价格低廉，其主要目的是通过后续的数字内容和其他产品创收。这一点与谷歌颇为相似。谷歌向各大企业免费提供Android操作系统，但却可以通过智能手机的搜索广告赚取营收。</p>\r\n	<p align="center">\r\n		&nbsp;</p>\r\n	<div class="mbArticleSharePic " r="1" style="width: 616px">\r\n		<div class="mbArticleShareBtn">\r\n			<span>转播到腾讯微博</span></div>\r\n		<img alt="不只是电商：亚马逊图谋硬件市场" src="http://img1.gtimg.com/tech/pics/hv1/67/187/1571/102202027.jpg" /></div>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p align="center">\r\n		图二：亚马逊销售收入增长情况</p>\r\n	<p style="text-indent: 2em">\r\n		而具体到亚马逊，则可以通过金牌会员和电子商务业务创收。Kindle电子阅读器、Kindle Fire和Kindle FireHD平板电脑都秉承了这一思路，而最近发布的Fire TV机顶盒也不例外&mdash;&mdash;它的售价仅为99美元。</p>\r\n	<p style="text-indent: 2em">\r\n		Fire TV主要是一款流媒体视频设备，定位与苹果公司的AppleTV类似。通过Fire TV，用户便可观看来自Netflix、YouTube和Hulu的视频内容。该产品还可以获取亚马逊自家的InstantVideo服务，并收听亚马逊、Pandora和TuneIn的流媒体音乐。另外，FireTV还具备语音搜索功能，内置2GB内存，最高可以解析1080p全高清视频。</p>\r\n	<p style="text-indent: 2em">\r\n		FireTV甚至可以充当一个平台，吸引开发者设计各种Android移动应用和游戏。据亚马逊应用商店和游戏副总裁麦克&bull;乔治(MikeGeorge)介绍：&ldquo;开发者已经通过Kindle Fire和亚马逊应用商店成功实现了商业化。FireTV是吸引开发者为亚马逊设计应用和游戏的又一个理由。FireTV有望吸引大批开发者，既包括现有的Android开发者，也包括游戏主机开发者，甚至包括PC开发者。&rdquo;</p>\r\n	<p style="text-indent: 2em">\r\n		&ldquo;他们都将通过客厅与热爱娱乐的全新消费者展开互动。我们已经吸引了2K、AOL、Bloomberg、ClearChannel、Disney、EA、ESPN、Gameloft、Hulu、Mojang、Pandora、SEGA、SHOWTIME、Telltale、Ubisofth和Vevo等一批优秀的开发者，今后还将有更多开发者陆续加入。&rdquo;乔治补充说。</p>\r\n	<p style="text-indent: 2em">\r\n		<strong>智能手机如箭在弦</strong></p>\r\n	<p style="text-indent: 2em">\r\n		按照亚马逊的惯例，这些电子产品的首要目的都是吸引用户，然后逐步向其推销各种服务，销售各种产品。这项战略也的确收到了成效，过去几年间，该公司的服务业务营收增幅一直都是产品业务营收增幅的两倍。然而，这两项营收的增速都在逐步放缓。而为了恢复增长，该公司开始通过扩大产品种类进军新的市场，增加更多硬件产品自然成了首选方案。</p>\r\n	<p style="text-indent: 2em">\r\n		从亚马逊现有的硬件产品组合来看，智能手机似乎是最有可能推出的新品。据悉，该公司可能会在6月末推出智能手机，并在9月末正式发货，以便抓住圣诞购物季这一重要时点。</p>\r\n	<p align="center">\r\n		&nbsp;</p>\r\n	<div class="mbArticleSharePic " r="1" style="width: 640px">\r\n		<div class="mbArticleShareBtn">\r\n			<span>转播到腾讯微博</span></div>\r\n		<img alt="不只是电商：亚马逊图谋硬件市场" src="http://img1.gtimg.com/tech/pics/hv1/68/187/1571/102202028.jpg" /></div>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p align="center">\r\n		图三：全球智能手机市场份额</p>\r\n	<p style="text-indent: 2em">\r\n		当今的智能手机市场由三星和苹果主导，所以亚马逊必须推出质优价廉的产品才能取得成功。根据市场研究公司IDC的统计，三星目前占据全球智能手机市场31%的份额，苹果为15%，二者合计瓜分了智能手机市场的半壁江山。华为、LG和联想等企业各自拥有约2%的份额。由此看来，亚马逊必须在自己的智能手机中引入一些创新，才能真正有所作为。</p>\r\n	<p style="text-indent: 2em">\r\n		亚马逊自然对此心知肚明。据报道，该公司希望在智能手机中融合3D显示功能，但要配合特制的眼镜才能实现。这款手机还将配备视网膜追踪技术，以便让一些图像显示出类似于3D的效果。</p>\r\n	<p style="text-indent: 2em">\r\n		<strong>服务或成杀手锏</strong></p>\r\n	<p style="text-indent: 2em">\r\n		而流媒体服务则有可能成为亚马逊的杀手锏，为其硬件产品带来巨大的附加价值。市场研究公司Qwilt的报告显示，亚马逊金牌会员专享的InstantVideo流媒体视频服务，在美国的流量已经超过了Hulu和苹果。过去12个月间，亚马逊的流媒体视频流量增长94%，而在部分美国运营商网络中的流量增幅甚至接近300%。</p>\r\n	<p align="center">\r\n		&nbsp;</p>\r\n	<div class="mbArticleSharePic " r="1" style="width: 640px">\r\n		<div class="mbArticleShareBtn">\r\n			<span>转播到腾讯微博</span></div>\r\n		<img alt="不只是电商：亚马逊图谋硬件市场" src="http://img1.gtimg.com/tech/pics/hv1/81/187/1571/102202041.jpg" /></div>\r\n	<p>\r\n		&nbsp;</p>\r\n	<p align="center">\r\n		图四：美国视频网站排名情况</p>\r\n	<p style="text-indent: 2em">\r\n		不过，要真正称霸市场，亚马逊还有很长的路要走。单从这一指标来看，该公司虽然有了长足的进步，但仍然远远落后于Netflix和YouTube，后二者的合并份额高达74%，而亚马逊只有区区3%。</p>\r\n	<p style="text-indent: 2em">\r\n		众所周知，内容是视频领域最重要的元素。亚马逊同样在这方面做足了功夫，不仅积极购买版权，还投资拍摄自制剧，而且取得了不错的成效。</p>\r\n	<p style="text-indent: 2em">\r\n		亚马逊数字视频和音乐副总裁比尔&bull;卡尔(BillCarr)说：&ldquo;我们已经向优质的电视节目和电影投入了数亿美元资金。金牌会员可以毫无限制地观看他们最喜欢的电影和电视节目。随着我们增加了《阿尔法屋》、《Bosch》、《TheAfter》、《Mozart in the Jungle》和《Transparent》等自制剧，用户无疑会对我们提供的内容更加满意。现在，FireTV将为用户提供最简单的内容访问方式。&rdquo;</p>\r\n	<p style="text-indent: 2em">\r\n		亚马逊还在努力为金牌会员争取热门电视节目的独家订阅权。例如，该公司2014年4月1日宣布与二十世纪福克斯电视公司达成协议，允许亚马逊金牌会员通过InstantVideo独家观看美剧《24小时》的192集内容。</p>\r\n	<p style="text-indent: 2em">\r\n		当然，要获得金牌会员资格，需要支付一定的费用。而随着亚马逊提供的内容不断增多，金牌会员的年费也将从79美元上调至99美元。不过，除了流媒体视频外，金牌会员从亚马逊购物时还可以享受不限次数的两日送达服务。</p>\r\n	<p style="text-indent: 2em">\r\n		内容成本上涨是亚马逊给出的主要调价理由，这似乎无可厚非&mdash;&mdash;毕竟，天下没有免费的午餐。但这也恰恰印证了亚马逊的战略实质：卖硬件，但却不靠硬件赚钱。更何况，订阅费只是用户支付的最显性的成本。</p>\r\n	<p style="text-indent: 2em">\r\n		在购买亚马逊的硬件或成为亚马逊的金牌会员后，额外花费的购物和内容成本，才是亚马逊真正看重的盈利来源。<a alt="点击进入腾讯首页" href="http://www.qq.com/?pref=article" id="backqqcom" style="white-space: nowrap" target="_blank" title="点击进入腾讯首页"><img height="16" src="http://www.qq.com/favicon.ico" width="16" /><span bosszone="backqqcom" style="padding-left: 5px; font-size: 14px">返回腾讯网首页&gt;&gt;</span></a></p>\r\n	<div id="tipsWBzf" style="z-index: 899; left: 145px; visibility: hidden; width: 59px; cursor: pointer; position: absolute; top: 5223px; height: 22px; text-decoration: none">\r\n		&nbsp;</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '科技', '长歌', '腾讯科技', 'recommend', '2014-04-20'),
	(162, '亚振家具拟发行5474万股登陆A股，美克股份为其竞争对手', '', '<p>\r\n	　　<a href="http://q.stock.sohu.com/cn/601519/index.shtml" target="_blank">大智慧</a>阿思达克通讯社4月21日讯，证监会从18日深夜到19日紧急开闸IPO预披露,目前共28家公司预披露，将登陆主板的亚振家具位列其中。<br />\r\n	<br />\r\n	　　根据亚振家具招股说明书显示，公司是集家具设计研发、生产制造、营销以及家居文化研究于一体的企业集团，产品定位于中高档民用欧&nbsp;&nbsp;</p>\r\n<!-- 程序自动插入相关股票行情 end -->\r\n<p>\r\n	<!--digest end-->式家具市场。本次IPO，亚振家具拟发行5474万股，募集6.01亿元用于营销网络扩建、沙发及家具扩产项目、家具生产线技改项目、信息化系统建设项目等。<br />\r\n	<br />\r\n	　　公司表示，若募集资金不足，由公司根据上述募集资金投资项目的重要性和紧迫性安排募集资金的具体使用，不足部分通过自筹方式解决。<br />\r\n	<br />\r\n	　　截至2013年12月31日，公司已在北京、上海、南京、沈阳、哈尔滨、大连、杭州、苏州、成都、武汉等城市拥有19家品牌旗舰店，在广州、乌鲁木齐、天津、济南、深圳、重庆等76个经济发达城市拥有147家品牌形象店，初步建立了覆盖全国经济发达城市的营销网络。<br />\r\n	<br />\r\n	　　财务数据显示，去年末公司总资产为4.93亿元，营收为5.40亿元，归属于母公司股东的净利润为0.78亿元，资产负债率为34.36%。<br />\r\n	<br />\r\n	　　亚振家具在招股书中表示，公司产品定位于中高档民用欧式家具市场，拥有较高的品牌知名度和美誉度。产品定位、品牌和渠道策略使公司在一定程度上规避了部分竞争对手。<br />\r\n	<br />\r\n	　　尽管如此，公司仍然面临来自行业内诸多企业的竞争。公司表示，目前主要竞争对手为<a href="http://q.stock.sohu.com/cn/600337/index.shtml" target="_blank">美克股份</a>（600337.SH）和中山四海家具制造有限公司等，若公司不能在产品设计及品质上持续创新，不能保持鲜明的品牌形象，则难以保持销售渠道和市场份额的持续提升，而影响公司的经营业绩。<br />\r\n	<br />\r\n	　　发稿：严恒/古美仪 审校：肖云祥/田新杰</p>', '财经', '', '大智慧阿思达克通讯社', '', '2014-04-21'),
	(163, '山西明珠家具物流产业园项目落户运城经济开发区', '', '<p>\r\n	4月18日，运城经济开发区举行山西明珠家具物流产业园项目签约仪式。</p>\r\n<p align="justify">\r\n	<font style="line-height: 175%">　　明珠家具集团是集研发、生产、销售、服务于一体的国家级家具龙头企业之一。山西明珠家具物流产业园，总投资18亿元，一期工程投资10亿元，二期投资8亿元，年产床垫30万张，沙发9万套，现代板式家具3000余万件；项目建成后，预计年产值25亿元，年缴税金1亿元，提供就业岗位1500多个。</font></p>\r\n<p align="justify">\r\n	<font style="line-height: 175%">山西明珠家具物流产业园项目成功落户运城经济开发区，标志着开发区四个产业集群的发展又上了一个新的台阶，也必将进一步推动开发区产业化发展进程，将对运城乃至黄河金三角地区家具行业的发展注入新的活力。 （王慕凯）</font></p>', '家具', '', '地方新闻网站', '', '2014-04-21'),
	(164, '美乐乐供应链：采购走出去，家具走进来', 'upload/images/1398052722031.bmp', '<div id="content">\r\n	<p>\r\n		　　国内家具行业经过多年的发展，已经在江苏蠡口、四川成都、广东乐从和河北香河四个城市形成了家具商贸基地。这四个商贸基地在很大程度上承担着各自所辐射地域的家具供应。</p>\r\n	<p>\r\n		　　近年来，随着家居电商的入驻，这种以地缘为主导因素的家具供货模式被打破。以家具电商美乐乐来说，在全国布局了15个仓库，让美乐乐的采购区间不再局限于某一个地域，而可以将采购范围扩大，扩充选择空间。</p>\r\n	<p>\r\n		　　美乐乐COO黄辉在3月份的东莞名家具论坛上曾透露，目前美乐乐的供应链已经伸向以越南为主的海外，在家具采购采购比例上，国内与国外比例为1：1，且在今年将继续扩大海外采购规模。</p>\r\n	<p>\r\n		　　之所以将供应链延伸到越南，黄辉表示，越南的劳动力和原料成本都比中国低廉，在越南进行大规模采购，能够很好地进行成本控制，从而与消费者分享渠道红利。</p>\r\n	<p>\r\n		　　据了解，美乐乐是目前国内唯一实现大规模海外采购的家居电商企业，除了在成本上更有竞争优势外，还有其多方面的考量。对此，美乐乐采购负责人接受了记者的采访。</p>\r\n	<p>\r\n		　　&quot;越南的实木资源非常丰富，尤其是以坚硬著称的亚洲硬木。&quot;美乐乐采购部负责人向记者说道：&quot;这种木料质地坚硬，用作实木家具制造可算是上好木料，比国内很多家具厂生产的实木家具都要坚韧些。&quot;负责人介绍，由于越南的木料质高价优，且凭借这里代理工厂丰富的实木家具生产经验，越南的实木家具在国内具有非常大的竞争优势。</p>\r\n	<p>\r\n		　　&quot;我们下一步将继续扩大在越南的采购份额，目的就是为了能引进更多实木家具，提升实木家具的市场占比，毕竟大部分消费者更信赖实木家具的环保和耐用特性。&quot;美乐乐采购部负责人如是说。</p>\r\n	<p>\r\n		　　据负责人介绍，美乐乐的实木家具基本从越南进口，而软体家具和配套的家纺家饰，则是在国内生产采购。</p>\r\n	<p>\r\n		　　&quot;越南在制造实木家具上有很大优势，但对于皮革、布艺的处理，还是国内的工艺更专业。&quot;采购部负责人告诉记者，在国内的广东、江苏和浙江等地一些工厂，有着长时间的外贸生产经验，对皮革和布艺的加工有着一套较为完备的体系，相比于外贸经济起步较晚的越南，国内的这些区域在这方面有着较大优势，因此，美乐乐包括皮艺、布艺的软体家具，特意选择了广东、江苏和浙江这三个省份进行采购生产。</p>\r\n	<p>\r\n		　　采访的最后，负责人告诉记者，美乐乐作为一家电商，对渠道、供应链都有着很大的选择空间，也有能力整合最优质的资源做好家具销售，特别是这种&quot;博采众长&quot;的采购法则，相信能在市场上赢得更多消费者的支持。</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '家具', '', '东南网　　　　', 'recommend', '2014-04-21'),
	(165, '美乐乐体验券助阵五月大促：买家具日省斗金', 'upload/images/1398053313437.jpg', '<p>\r\n	　20元当200元用？！在常人看来，这样的&ldquo;不等价&rdquo;交换在商品交易中基本是不可能的，但是准备在5月重装上阵的的家居电商领导品牌美乐乐，在继续提升家具电商平价空间的同时，再次放出省钱绝招，20元购买200元现金抵用券。<br />\r\n	　　据美乐乐官网五月阳光大促的页面显示，从4月21日开始，美乐乐将分别在电脑端、手机站、美乐乐官方微信上，每日分不同时段限量以20元价格出售200元现金抵用券。三个购买平台发售时间均为：11点、15点、20点，可以为买家具的消费者日省斗金。</p>\r\n<p>\r\n	<br />\r\n	　　据美乐乐相关活动专员介绍到，抵用券可到美乐乐全国近300家体验馆的任意一家使用，购物满500元可使用，并且需要在进店前购买，每人限购一张，用户名、收货人、收货地址、电话号码、E-MAIL、网银或支付宝账号，以上任何信息需不能重复。该负责人还表示，&ldquo;这其实是美乐乐O2O模式的另一种数字化形式，意在通过看到见的减免额度，与线下消费者有更多互动，促进O2O的良性循环。<br />\r\n	　　据了解，2014年以来美乐乐的多场促销活动均，使用过售卖抵用券的方式让利消费者。有媒体报道仅仅在2月的美乐乐促销活动中就售出7000多张优惠券，让利近130万，而近1个月的体验券的销量直逼2万，获得了消费者的极大赞誉。配合美乐乐即将上架的全屋购购物功能，体验券势必还将造成一波新的平价风潮。</p>', '家具', '', '美乐乐', 'recommend', '2014-04-21'),
	(166, '2014第20届海南春季房地产展示交易会今日开幕', 'upload/images/1398993701765.jpg', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">&nbsp; &nbsp; &nbsp;2014第20届海南春季房地产展示交易会于5月1日至5月3日在海口会展中心举行，共有来自海口、澄迈、临高等市县的40余家开发商50多个开发项目参展，展出面积约6000平方米，展览范围涵盖商品房住宅、各类别墅、商铺、经济适用房、写字楼等。</span></p>', '房地产', '', '新华网', 'recommend', '2014-05-02'),
	(167, '2014年广西房地产博览会隆重开幕 地产盛宴五一亮相', 'upload/images/1398993802937.gif', '<p align="center" style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px; text-align: center;">\r\n	<img border="0" id="{D7CF6E80-0F48-4540-9AA3-31277EFA17FB}" sourcedescription="编辑提供的本地文件" sourcename="本地文件" src="http://news.xinhuanet.com/house/nn/2014-05-01/1110499900_13989411290231n.gif" style="border: 0px; height: 394px; width: 500px;" title="" /></p>\r\n<p align="center" style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px; text-align: center;">\r\n	<span style="orphans: 2; widows: 2;">房地产精英共启房博会盛幕</span></p>\r\n<p align="center" style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px; text-align: center;">\r\n	<img border="0" id="{1CDF862A-F222-47F1-913C-72CF1D4ADCC3}" sourcedescription="编辑提供的本地文件" sourcename="本地文件" src="http://news.xinhuanet.com/house/nn/2014-05-01/1110499900_13989411368981n.gif" style="border: 0px; height: 292px; width: 500px;" title="" /></p>\r\n<p align="center" style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px; text-align: center;">\r\n	<span style="orphans: 2; widows: 2;">展区内人头攒动</span></p>\r\n<p align="center" style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px; text-align: center;">\r\n	<span style="orphans: 2; widows: 2;">新华网房产频道南宁站 谢文/摄</span></p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 新华网(房产频道)南宁5月1日电（梁笑天 卢艺春）今天上午9:30，由广西日报传媒集团主办，为期3天的&ldquo;2014年广西（南宁）房地产博览会&rdquo;在南宁国际会展中心隆重开幕。本届房博会推出&ldquo;魔幻、创意、幸福、甜蜜&rdquo;四大主题，向南宁市民展现一场大气又时尚、精彩又细致的房产盛宴。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;<strong>广西房产盛宴</strong></p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 据悉，在本届房博会上汇聚了代表广西最高水平、最具影响力的30余家广西房地产企业90多个楼盘，项目遍布南宁市青秀区、江南区、兴宁区、经开区、西乡塘区、五象新区、邕宁区。既有南宁的楼盘，也有北海、钦州、防城港等地的楼盘；项目既有住宅，也有写字楼、商铺；有开发多年的大盘，也有新面市的新项目。南宁绝大部分在售、在建的楼盘项目，都参加了展会，并纷纷出台优惠方案，吸引购房者购买。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 值得关注的是，今年房博会还吸引了相关职能部门积极参展，如南宁住房局、上林县、横县等。其中有介绍南宁住房节能、科技成果的，有介绍县域规划、区域资源的。另外，还有数十个家装、建材品牌联袂出场，在数以万计的市民目光注视下接受检阅。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;<strong>楼市&ldquo;风向标&rdquo;</strong></p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 房博会作为广西楼市&ldquo;风向标&rdquo;，迎来了第十三个年头。13年来，房博会始终严格遵守以更好的标准、更优质的服务理念，与全区房地产企业一道共同做好房地产各项服务工作。而一向被誉为广西房地产&ldquo;奥斯卡&rdquo;的房博会颁奖，今年也以全面革新的形式举行。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 本次房博会荣誉榜评选出&ldquo;2014年影响广西的房地产品牌企业&rdquo;、&ldquo;2014年影响广西的房地产领袖人物&rdquo;、&ldquo;2014年影响广西的房地产营销精英&rdquo;、&ldquo;2014年影响广西的房地产服务机构&rdquo;、&ldquo;风情园林社区&rdquo;、&ldquo;生态乐居名宅&rdquo;、&ldquo;创意设计社区&rdquo;、&ldquo;样板别墅社区&rdquo;、&ldquo;人气关注名盘&rdquo;、&ldquo;刚需精品名盘&rdquo;等奖项。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 荣誉榜的评选旨在树立让大家超越的榜样，提高行业发展水平。对此，广西日报传媒集团党委副书记、副社长、总经理钟桂发在开幕式上表示，希望房博会这个平台能够成为老百姓买房的&ldquo;超级市场&rdquo;，通过这个平台让更多的到会者买到满意的房子，并且培育出一批值得老百姓信赖的品牌企业。本届房博会既是购房消费者的一次盛会，同时也为全区房地产企业之间的交流发展搭建了一个平台，希望参展商以本届房博会为契机，提升理念打造经典，共谋发展建设更高品质的产品，为推动广西房地产健康持续发展积极贡献。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp;<strong>&nbsp;礼品送不停</strong></p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 为感谢广大市民的参与，当天，房博会组委会组织了许多精美礼品，发放给热心观展的市民。据了解，房博会在现场发放的礼品，有日用品、工艺品，还有电脑用品。奖品共1000份，每日限量发送。此外，各参展楼盘也准备了精美礼品，赠送给前来看房、咨询的市民。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 今年房博会，组委会广泛使用和推广广传魔码，既形成了展会的鲜明特色，也方便更多市民了解房博会。届时，市民在入口处、过道、展位等位置，下载和扫描广传魔码，就可收看、收听房博会的最新信息，了解楼盘最新资讯。担心手机流量不够用？组委会在现场布置了免费WIFI，让市民尽情上网。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 为方便市民观参，在房博会期间，组委会还在南宁各城区开通房博会观展免费专线车，让市民直达南宁国际会展中心。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;<strong>楼市潜力巨大</strong></p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 当下，房地产市场扑朔迷离，有些城市还出现了量价齐跌的状况，大家对房地产形势也众说纷纭。但是，房博会参展企业代表、南宁市地产业开发总公司书记、总经理陆炳良在开幕式上表示，纵观<span name="HL_TAG" style="border-bottom-style: dotted; border-bottom-width: 0px; color: rgb(0, 132, 216); text-decoration: underline;">南宁楼市</span>，南宁房地产依然是稳定、健康并且处于可持续发展的状态。首先南宁市的宏观经济发展良好；其次，南宁供需平衡，全市各大主流媒体也纷纷报道了南宁市存储商品房正处于合理区间；第三，南宁市楼市结构合理。换而言之，南宁房地产市场依然前途光明。本届房博会作为推介房地产品牌的和优秀项目的重要平台，是广西房地产一年一度的盛会，对推动行业的发展将产生深远的影响。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 当天，不少参展商家也表示，随着城镇化建设的推进以及广西加快北部湾经济区的开发、开放，市场需求逐步释放，后市发展潜力大。</p>\r\n<p style="margin: 0px; padding: 0px 0px 15px; border: 0px; outline: none; list-style: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 28px;">\r\n	&nbsp;&nbsp;&nbsp; 根据《南宁&ldquo;中国水城&rdquo;建设规划（2010～2020）》，南宁到2020年将形成&ldquo;一江、两库、两渠、六环、十八河、一百湖&rdquo;的城市水系格局，实现&ldquo;水畅、湖清、岸绿、景美&rdquo;的面貌。南宁地铁一号线、二号线已相继动工，三号线力争在今年动工。不少参展商认为，城市面貌和基础设施的改善，有利于促进社会发展。从长远看，南宁楼市还有较大发展空间。</p>', '房地产', '', '新华网', 'recommend', '2014-05-02'),
	(168, '机构看好险资举牌地产股 仍需关注一季报行情', 'upload/images/1398993924312.jpg', '<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	近日<a href="http://quotes.money.163.com/0600383.html" style="color: rgb(15, 107, 153);">金地集团</a>被<a href="http://money.163.com/keywords/4/3/4e3e724c/1.html" style="color: rgb(15, 107, 153);" target="_blank" title="举牌">举牌</a>引发了<a href="http://quotes.money.163.com/#query=EQA" style="color: rgb(15, 107, 153);">A股</a>市场的&ldquo;被举牌行情&rdquo;。有媒体统计，今年以来，<a href="http://money.163.com/baike/ashares/" style="color: rgb(15, 107, 153);" target="_blank" title="财经知识_A股">A股</a>市场合计有20家公司被举牌，其中<a href="http://quotes.money.163.com/1000759.html" style="color: rgb(15, 107, 153);">中百集团</a>、<a href="http://quotes.money.163.com/1000532.html" style="color: rgb(15, 107, 153);">力合股份</a>、金地集团等公司更是多次被举牌，公司股价也均有靓丽表现。寻找潜在被举牌的公司也成了市场追逐的热点，近日国泰君安发表了<a href="http://money.163.com/keywords/9/6/96698d44/1.html" style="color: rgb(15, 107, 153);" target="_blank" title="险资">险资</a>举牌地产蓝筹的主题报告，报告认为，保险频频举牌地产公司，彰显了对低估值、高盈利的地产板块的看好。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	上述报告认为，股权分散、资质好、易被举牌和低估蓝筹是两条主要逻辑，依次推荐金融街、深振业、<a href="http://quotes.money.163.com/0600325.html" style="color: rgb(15, 107, 153);">华发股份</a>、金地集团等。不过依据资质好的这一标准，被举牌公司或许并不能成为股价走强的唯一依据，一季报仍然会影响股价走势。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	<strong>龙头地产股一季度&ldquo;失速&rdquo;</strong></p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	从2013年年报情况来看，142家申万<a href="http://money.163.com/keywords/5/3/57304ea780a1/1.html" style="color: rgb(15, 107, 153);" target="_blank" title="地产股">地产股</a>仅有10家公司净利润亏损，其余132公司均在不同情况实现了盈利，盈利比例达到93%。实现盈利的地产公司中，有88家公司净利润同比实现增长，仅44家公司净利润同比下降，增长占比达到66.67%。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	其中华谊地产、奉化股份、青鸟华光等公司因基数较低，净利润同比增长超过10倍。龙头股方面，万科A去年净利润151.12亿元，同比增长20.46%；<a href="http://quotes.money.163.com/1000024.html" style="color: rgb(15, 107, 153);">招商地产</a>净利润42.02亿元，同比增长26.64%；<a href="http://quotes.money.163.com/0600048.html" style="color: rgb(15, 107, 153);">保利地产</a>净利润107.47亿元，同比增长27.36%；金地集团净利润36.09亿元，同比下降2.92%。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	不过，随着今年一季度部分楼市的降温，四大地产股一季度报告表现并不如人意，仅保利地产一家实现了实现净利润同比增长。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	<strong>资质较好但股权分散公司更易被举牌</strong></p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	大股东集中度低普遍被市场认为更容易取得控制权，进而实现对公司的改组。记者提取了大股东持股比例小于30%的地产股，其中根据万得给出最近一年一致预测PE的公司共有27家，万科A、金地集团龙头股入列，最近受到关注的金融街也位列其中。不过，3月份频现大宗市场的<a href="http://quotes.money.163.com/0600638.html" style="color: rgb(15, 107, 153);">新黄浦</a>并没有在其中。</p>\r\n<p class="f_center" style="padding: 0px; margin: 26px 0px; font-size: 14px; text-align: center; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px;">\r\n	&nbsp;</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	大股东持股少于30%且给出PE(FYI)的地产股</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	<strong>险资偏好的地产股值得关注</strong></p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	上述研报认为，已重仓可显示出险资的资金偏好，预计未来继续加仓可能性较大。但并不限于原保险公司继续加仓，也可能是其他公司加仓。数据显示，截至2013年年报，出现险资身影的地产股共有19家，其中<a href="http://quotes.money.163.com/0600240.html" style="color: rgb(15, 107, 153);">华业地产</a>险资持股比例达5.95%，公司大股东持股比例低于30%；此外，金地集团、金融街、万科A、<a href="http://quotes.money.163.com/1000608.html" style="color: rgb(15, 107, 153);">阳光股份</a>等也具备上述特性。</p>\r\n<p class="f_center" style="padding: 0px; margin: 26px 0px; font-size: 14px; text-align: center; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px;">\r\n	<img alt="险资偏好的地产股" border="0" src="http://img1.cache.netease.com/catchpic/0/0F/0F06CCF19E3A505B5D63E3F55823C61B.jpg" style="vertical-align: top; border: 0px;" /></p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	险资偏好的地产股</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	<strong>被举牌公司走势仍值得商榷</strong></p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	金融街日前公告称，于4月25日晚收到和谐健康保险通知，其通过二级市场交易，累计持有的金融街股票已达1.51亿股左右，占公司股权比例的5.000003%，公司股价28日放量涨停。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	&nbsp;</p>\r\n<div class="gg200x300" style="padding: 19px; margin: 0px 22px 0px 0px; overflow: hidden; text-align: center; font-size: 0px; line-height: 0; float: left; border: 1px solid rgb(229, 229, 229); color: rgb(37, 37, 37); font-family: 宋体, sans-serif;">\r\n	&nbsp;</div>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	不过，收盘后交易所的<a href="http://quotes.money.163.com/#query=MRLHB" style="color: rgb(15, 107, 153);">龙虎榜</a>数据显示，有资金借机出逃。数据显示，前五大席位中买入第一名为知名游资徐晓的席位<a href="http://quotes.money.163.com/1000728.html" style="color: rgb(15, 107, 153);">国元证券</a>上海虹桥路营业部，买入6435万元，同时卖出2021万元，此外一个机构专用席位买入5743万元。此外，卖出席位第一名为机构专用席位，大举卖出3.86亿元。此外国泰君安交易单元（01000）卖出3922万元，该席位在上周五买入3883万元，显然是获利了结，该席位为号称私募一哥的徐翔专用席位之一。</p>\r\n<p style="padding: 0px; margin: 26px 0px; font-size: 14px; text-indent: 2em; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	估值低、盈利强的地产蓝筹股显然是保险资金作为长线投资的优良选择，不过随着一季度地产股的&ldquo;失速&rdquo;，市场仍然不会单一跟随&ldquo;被举牌&rdquo;这一指标，例如金地集团2013年净利润为36.09亿元，同比下滑2.92%，每股收益0.81元。拟每10股派现1.6元。今年一季报显示，1-3月净利润为4934.38万元，同比下滑73.65%，每股收益0.01元。公司股价已经连续2日跌停。</p>', '财经', '', '证券时报网(深圳)', 'recommend', '2014-05-02'),
	(169, '百万豪车销售火爆2天卖20台', 'upload/images/1398994352687.jpg', '<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254); text-align: center;">\r\n	<span style="text-align: -webkit-center;">　　2014湖南车展，林肯汽车价值181.8万元的领航员已售出。记者 田超 摄</span></p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	男子买300万超级豪车，看车买车不到10分钟</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　5月1日，湖南国际会展中心迎来如织人流，场馆内人声鼎沸，二楼豪车馆更是热闹非凡。初步统计百万的豪车，短短两天卖出20多台。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	<strong>　　10分钟不到</strong></p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	<strong>　　男子下单&ldquo;新飞驰&rdquo;</strong></p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　5月1日上午10点，正逢奥迪展台进行模特走秀活动。来自岳阳的市民马忠业与记者一起进入二楼豪车馆，不由自主地被吸引了过去。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　模特走秀结束，他走进奥迪展台，对一辆红色奥迪A3表示出了兴趣，20多万元的价格也在他的预算范围之内，&ldquo;没想到二十多万能买四个圈，这辆红色的A3尤其适合女孩子。&rdquo;</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　豪华车受到如此追捧最根本的原因还是湖南人收入上涨，消费豪车的意愿大增。超级豪车也不甘示弱。一大早，宾利展台内宾利新飞驰标出&ldquo;已售&rdquo;字样。这辆车是何时售出的？&ldquo;昨天下午，一名30岁左右的男子买走了这台价值336.8万元的新飞驰。从看车到签合同刷卡，前后用了不到10分钟的时间。&rdquo;宾利长沙的负责人说，买车的男子相当爽快。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	<strong>　　旧车能换新车</strong></p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	<strong>　　买豪车有底气</strong></p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　不光宾利，除了主流豪华品牌&mdash;&mdash;奥迪、宝马、奔驰、雷克萨斯、英菲尼迪、沃尔沃和捷豹路虎等销量不错，宾利、玛莎拉蒂等超级豪车也有新车售出。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　玛莎拉蒂更是一口气收获了7位新车主，从139万元Ghiblis、240万元的GT到286万元新总裁都有斩获。今年北京车展上才宣布正式进入中国的美系豪华品牌林肯，售出一辆价值181.8万元的领航员和一辆价值213.98万元的领袖1号。另一美系豪华品牌凯迪拉克也在本次湖南车展上售出价值150多万元的凯雷德一辆。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　据初步统计，2天内，过百万的豪车销售超过20台。记者了解到，目前豪车都有旧车换新车的政策，这也让很多消费者在看豪车买豪车时更有底气。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　■三湘华声全媒体记者 杨刚</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　车展&middot;抽奖</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　车展送出3台奖车了</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　2014湖南车展&ldquo;看车中大奖&rdquo;活动第三次大奖抽取于5月1日下午圆满结束，中奖号码为：TS20923。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　奖品是由长沙天潮4S店提供的1台长安铃木锋驭汽车的使用权。</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　每天中奖号码统计：</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　4月29日中奖号码为：TS12258</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　4月30日中奖号码为：TS22174</p>\r\n<p style="font-size: 14px; line-height: 25px; background-color: rgb(245, 250, 254);">\r\n	　　5月1日中奖号码为：TS20923</p>', '汽车', '杨刚', '华声在线-三湘都市报', 'recommend', '2014-05-02'),
	(170, '百万级豪车卖出30多辆(组图)', 'upload/images/1398994564390.jpg', '<p>\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">2014湖南车展豪车馆热闹非凡，一辆售价336.8万元的豪车不到10分钟被买走</span></p>\r\n<table align="center" style="margin: 0px auto; color: rgb(37, 37, 37); font-family: 宋体, sans-serif; line-height: 24px; text-align: justify;">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle">\r\n				<table align="center" style="margin: 0px auto;">\r\n					<tbody>\r\n						<tr>\r\n							<td>\r\n								<div align="center" style="padding: 0px; margin: 0px;">\r\n									<img alt="图为车展上价值688万元的皇室专车劳斯莱斯。李锋" src="http://img1.cache.netease.com/catchpic/E/E5/E5BF79F66C20AF2A827DE9F054F7B176.jpg" style="vertical-align: top; border: none; margin: 5px;" /></div>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td align="middle">\r\n				<div align="center" style="padding: 0px; margin: 0px;">\r\n					<font 12px="">图为车展上价值688万元的皇室专车劳斯莱斯。李锋 摄</font></div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　本报讯（记者 何正清 张 帆）5月1日，湖南国际会展中心迎来如织人流，场馆内摩肩接踵、人声鼎沸，二楼豪车馆更是热闹非凡。据初步统计，百万级的豪车，短短3天内已经卖出30多辆。</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　336.8万元宾利10分钟内售出</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　昨天上午10时，奥迪展台正好赶上模特走秀活动，整个展台被观众里三层外三层包围起来。来自岳阳的马忠业与记者一起进入二楼豪车馆，路过奥迪展台时，不由自主地被吸引过去。他举起相机，频频按下快门：&ldquo;难得来看一次，要值回票价啵。&rdquo;模特走秀结束，他进入奥迪展台，对一辆鲜红的全新奥迪A3很感兴趣，20多万元的价格，也在他的预算范围之内。&ldquo;没想到20多万就能买到4圈，这辆红色的A3尤其适合女孩子。&rdquo;</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　业内人士表示，随着人们的收入上涨，消费豪车的意愿大增。超级豪车也不甘示弱。一大早，宾利展台内宾利新飞驰，标出&ldquo;已售&rdquo;字样。这辆车是何时售出的？记者马上找到宾利品牌负责人询问相关情况。</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　&ldquo;昨天下午，一名30岁左右的男子买走了这台价值336.8万元的新飞驰。从看车到签合同刷卡，前后用了不到10分钟的时间。&rdquo;宾利汽车长沙公司的负责人告诉记者，买车的男子相当爽快。</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　前3天百万级豪车销售超30辆</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　不光宾利，除了主流豪华品牌&mdash;奥迪、宝马、奔驰、雷克萨斯、英菲尼迪、沃尔沃和捷豹路虎等销量不错，宾利、玛莎拉蒂等超级豪车也都有新车售出。</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	&nbsp;</p>\r\n<p>\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　玛莎拉蒂更是一口气收获了7位新车主，所售车型价格从139万元至286万元。今年北京车展上才宣布正式进入中国美系豪华品牌林肯售出一辆价值181.8万元的领航员和一辆价值213.98万元的领袖1号。另一美系豪华品牌凯迪拉克也在本次湖南车展上售出价值150多万元的凯雷德一辆。</span><br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<br style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;" />\r\n	<span style="color: rgb(37, 37, 37); font-family: 宋体, sans-serif; font-size: 14px; line-height: 24px; text-align: justify;">　　据组委会初步统计，车展前3天百万级的豪车销售超过了30辆。记者了解到，目前豪车都有旧车换新车的政策，这让很多消费者在看豪车、买豪车时，更有底气。&ldquo;原来这些品牌有点高高在上的感觉，奥迪、宝马、梅赛德斯-奔驰国产后，售价更接地气，长沙的中产阶层购买这些品牌，也不会有很大的压力。再加上，贷款购车也成了一种消费趋势，首付10多万元，买辆豪车很轻松呀！&rdquo;在二楼豪车馆，某豪华品牌销售经理对记者这样说。</span></p>', '汽车', '何正清 张 帆', '长沙晚报(长沙)', 'recommend', '2014-05-02'),
	(171, '运动美学 莲花汽车登陆西安五一车展', 'upload/images/1398994752281.jpg', '<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp; &nbsp; 2014（第六届）西安五一汽车展览会在西安曲江国际会展中心开幕。在本次车展，陕西融达汽车销售维修服务有限公司携旗下众多车型重磅登陆本次车展，消费者将有机会近距离全面感受莲花汽车独特的品牌魅力以及卓越不凡的产品品质。与此同时融达莲花还为喜爱莲花汽车的朋友带来了十分惊喜的优惠政策。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016080465346.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016080465346.jpg" src="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016080465346.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp; &nbsp; 莲花汽车传承了英国莲花运动血统及设计研发理念，完全以欧系车标准研发设计，从产品定义、项目管理、技术工程、制造工艺、质量控制和供应链管理六方面都严格把控。旗下产品兼顾了操控性和舒适性的双重需要。莲花汽车精湛技术与莲花汽车卓越的产品品质完美结合，向热爱运动和激情的消费者全面展示莲花汽车的&ldquo;五星级底盘&rdquo;和越级操控，让更多的消费者能够零距离体验纯粹极致运动赛车的魅力</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016084552629.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016084552629.jpg" src="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016084552629.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016085276394.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016085276394.jpg" src="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016085276394.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016090123552.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016090123552.jpg" src="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016090123552.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016094081279.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016094081279.jpg" src="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016094081279.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp; &nbsp; 2014年1月8日，陕西融达汽车集团正式成立。旗下陕西融达汽车销售维修服务有限公司成立于2010年，公司位于西安市三桥西部国际车城以南西宝疏导线2号，是一家专营莲花汽车的旗舰4S店，集整车销售、配件供应、信息反馈、售后服务为一体，同时是浙江青年乘用车集团在陕西地区最重要的合作伙伴。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016090638353.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016090638353.jpg" src="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016090638353.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016102725407.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016102725407.jpg" src="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016102725407.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016102176286.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016102176286.jpg" src="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016102176286.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp; &nbsp; &nbsp;公司以人为本、以客户为主导、以诚实守信为理念，组建了一支最具专业素质的服务团队，依照最高标准的服务体系，以确保客户能享受到最卓越的服务！在整车销售的同时，公司还为客户提供了多种增值服务。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016092947157.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016092947157.jpg" src="http://www0.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016092947157.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	<a href="http://www.autohome.com.cn/img/?img=newspic/2014/4/30/0_1_2014043016094046882.jpg" style="color: rgb(59, 89, 152); outline: 0px; text-decoration: none;" target="_blank"><img alt="汽车之家" height="411" original="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016094046882.jpg" src="http://www1.autoimg.cn/newspic/2014/4/30/620x0_1_2014043016094046882.jpg" style="vertical-align: top; background-image: url(http://x.autoimg.cn/news/show20/1210/default_bg.png); display: inline-block; border: 0px !important; background-position: 50% 50%; background-repeat: no-repeat no-repeat;" width="620" /></a></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp; &nbsp; &nbsp;公司坚持&ldquo;全方位、满负荷、快节奏、高效率&rdquo;的工作作风，力求在行业内独树一帜。2010年12月至今，公司销售额逐月递增，2011年年销售量、提车量均位居全国第一，多次受到厂方的嘉奖和客户的赞誉，也是西安地区汽车销售行业快速成长发展的亮点。公司本着&ldquo;整合地域资源、实施强强联合、实行优势互补、打造四个平台、拓展四大领域、实现稳健发展&rdquo; 的发展战略方针做强做大。并立志将让莲花汽车遍布三秦大地！成为莲花汽车在西北地区的领头羊，为广大莲花汽车客户提供更加优质、周到、快捷的服务。（编译/汽车之家 黄英杰）</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	经销商名称：陕西融达汽车销售维修服务有限公司</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	经销商地址：西安市三桥西宝疏导线2号（西部国际车城南2000米路西）</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体, arial, tahoma, sans-serif; font-size: 16px; line-height: 28px;">\r\n	经销商电话：4008682648</div>', '汽车', '', '汽车之家', 'recommend', '2014-05-02'),
	(172, '广州年内计划推广3000余辆新能源汽车 2015年1万辆', 'upload/images/1398994934718.jpg', '<div class="daodu" style="border: 1px solid rgb(221, 221, 221); text-indent: 28px; padding: 5px; background-color: rgb(244, 244, 244); font-family: 宋体; font-size: 14px; line-height: 28px; margin-top: 5px;">\r\n	【导读】广州将大力推广新能源汽车应用，今年内计划推广3000余辆新能源汽车，至2015年计划推广各类新能源汽车1万辆。</div>\r\n<p style="margin: 0px; padding: 15px 0px 10px; font-size: 14px; line-height: 28px; text-indent: 2em; font-family: 宋体;">\r\n	作为国家2013-2015年新能源汽车推广应用城市，广州将大力推广新能源汽车应用，今年内计划推广3000余辆新能源汽车，至2015年计划推广各类新能源汽车1万辆。</p>\r\n<p style="margin: 0px; padding: 15px 0px 10px; font-size: 14px; line-height: 28px; text-indent: 2em; font-family: 宋体;">\r\n	为贯彻落实国务院《大气污染防治行动计划》和《财政部、科技部、工业和信息化部、发展改革委关于支持北京、天津等城市或区域开展新能源汽车推广应用工作的通知》，广州市政府日前审议通过了《广州市新能源汽车推广应用工作方案》(以下简称《工作方案》)《广州市2014年新能源汽车推广应用工作计划》(以下简称《工作计划》)。</p>\r\n<p style="margin: 0px; padding: 15px 0px 10px; font-size: 14px; line-height: 28px; text-indent: 2em; font-family: 宋体;">\r\n	根据这些计划方案，至2015年，广州市计划推广应用各类新能源汽车1万辆，其中，公交车2000辆，出租车1000辆，公务用车2000辆，环卫、邮政、物流等专用车1000辆，私人领域4000辆。建设各类<a href="http://www.itdcw.com/tags.php?/%E5%85%85%E7%94%B5%E7%AB%99/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank"><span style="color: rgb(0, 102, 204);">充电站</span></a>105个、各类充电桩(机)9970个，初步构建网络化的充电服务体系和智能化的综合性服务平台。与此同时，还将建立完善的配套政策体系，形成良好的跨部门合作联动机制，初步形成产品门类齐全、产业链完整、具有核心竞争力的产业体系。</p>\r\n<p style="margin: 0px; padding: 15px 0px 10px; font-size: 14px; line-height: 28px; text-indent: 2em; font-family: 宋体;">\r\n	其中，今年内广州市计划推广应用新能源汽车3050辆，其中公交车900辆，出租车300辆，公务用车580辆，环卫、邮政、物流等专用车270辆，私人领域用车1000辆。建设各类充电站46个和各类充电桩(机)2916个。</p>\r\n<p style="margin: 0px; padding: 15px 0px 10px; font-size: 14px; line-height: 28px; text-indent: 2em; font-family: 宋体;">\r\n	为顺利推广新能源汽车，广州市专门成立了由市发展改革委牵头的新能源汽车发展工作领导小组办公室，下设各责工作组、专家咨询委员会等。</p>\r\n<p style="margin: 0px; padding: 15px 0px 10px; font-size: 14px; line-height: 28px; text-indent: 2em; font-family: 宋体;">\r\n	据广州市发展改革委有关人士透露，广州将鼓励技术成熟、性能可靠的新能源汽车产品及配套基础设施在广州市的推广应用，不单独设立地方门槛和目录。广州还将尽快制订出台保障措施与鼓励办法。与此同时，鼓励企业加大研发与产业化力度，加快提升技术成熟、安全可靠、可市场化的新能源汽车产品的供应能力，为消费者提供更多选择。</p>', '汽车', '', '中国电池杂志-中国电池网', 'recommend', '2014-05-02'),
	(173, '九江：高新技术企业成为开发区工业增效升级主力军', 'upload/images/1399085091406.jpg', '<p style="padding: 0px; margin: 20px 0px 0px; text-indent: 2em; text-align: center;">\r\n	<span style="padding: 0px; margin: 0px; font-size: 14px; line-height: 30.796875px;"><strong style="padding: 0px; margin: 0px;"><span style="padding: 0px 0px 0px 8px; margin: 0px; font-size: 24px;">高新技术企业成为开发区工业增效升级主力军</span></strong></span></p>\r\n<p style="padding: 0px; margin: 20px 0px 0px; text-indent: 2em; text-align: center;">\r\n	<span style="font-size: 14px; line-height: 30.796875px; text-indent: 2em;">高新技术企业九江七所精密机电科技有限公司依托省级污染控制工程技术研究中心开展系列科技创新，在油液污染控制领域走在了国内行业前列，每年推出近20项科技创新成果。今年以来，九江经济技术开发区以深入开展&ldquo;工业经济增效升级年&rdquo;活动为契机，通过设立科技扶持及技术改造专项资金，支持骨干企业建设研发平台，鼓励创新型领军企业实施品牌、专利战略，加快创业创新服务体系建设等举措推动企业创新发展，一大批高新技术企业成为开发区工业增效升级主力军。　　　　　　　　　</span></p>\r\n<p style="padding: 0px; margin: 20px 0px 0px; text-indent: 2em;">\r\n	<span style="padding: 0px; margin: 0px; font-size: 14px; line-height: 30.796875px;">（李涛渊 摄）</span></p>', '机械', '黄安', '九江新闻网', 'recommend', '2014-05-03'),
	(174, '工业互联网引领未来智能工厂', 'upload/images/1399086421812.jpg', '<div>\r\n	摘要：计算能力、信息提取和交流系统所带来的改变，已经在制造业中&ldquo;肆虐&rdquo;。关于这样一个新时代的表述不尽相同：德国称其&ldquo;工业4.0&rdquo;(Industry4.0)，美国则更多地将之概况为颇为宏大的概念&ldquo;工业互联网&rdquo;(IndustrialInternet)。实际上，无论叫什么名字，本质上都是信息技术与工业技术的高度融合，表述的是网络、计算机技术、信息技术、软件与自动化技术的深度交织所产生新的价值模型。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	从概念上来看，&ldquo;工业4.0&rdquo;描述的是以信息物理系统(Cyber-PhysicalSystem，CPS)为基础，工业领域的设备、生产与系统以网络化的形式向互联网迈进，这是一种由集中式控制向分散式增强型控制的基本模式转变，最终建立一个高度灵活的个性化和数字化的产品与服务生产模式；而&ldquo;工业互联网&rdquo;则指的是复杂机械与网络化的传感器和软件的整合，这涉及机器学习(machinelearning)、大数据、物联网和M2M(machine-to-machine)等领域，其过程包括从机器提取数据，进行实时分析，将其用以调整操作。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	这场正在发生的革命有几个基本特征&mdash;&mdash;</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	智能机器：用先进的传感器、控制和软件应用等新方式连接大量的机器、设备等；</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	先进的分析能力：基于物理的分析、预见性算法、自动化和材料科学的专业领域知识，电力工程和其他重点学科，这些都有助于理解机器和系统的运作；</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	工作中的人：让工作中的人无论身处工厂、办公室、医院还是移动中，都可以高质量、安全地进行智能设计、运作、维护。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	实际上，对于企业资源系统(ERP)、产品生命周期管理(PLM)、供应链管理等一系列的生产管理工具和方法等并不陌生的人们，发现自己终于可以在在信息通信、数据处理、自动控制以及模拟仿真等领域中，在自动化工厂的蓝图之上创造出&ldquo;智能工厂&rdquo;。在德国，巴斯夫、宝马、博世、戴姆勒、SAP、西门子等著名的德国企业纷纷投入顶尖研发资源于其中，而大洋彼岸的美国通用电气公司，也投入大量人力物力致力于将机器分析、行业洞察、自动化和商业预测结合起来，打造全新的工业互联网的商业实验。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	博斯公司(Booz&amp;Company)研究发现，智能工厂需要实现的目标有四个：产品的智能化、生产的自动化、信息流和物资流合一、价值链同步。而这些需要企业从工厂布局、设施、产品的生产流程、人力资源等诸多层面投入资源和能力建设。尽管现在还没有一家企业可以宣称自己已经完成了智能工厂的全部建设，但先行者已然在行动。</div>', '工业', '', '工控中国', 'recommend', '2015-08-05'),
	(175, '工业机器人14年将成产业拐点', 'upload/images/1399086651031.png', '<div>\r\n	摘要：2011年是全球工业机器人市场自1961年以来的行业顶峰，全年销售达16.6万台。2012年全球工业机器人销量为15.9万台，略有回落，主要原因是电气电子工业领域的销量有所下滑，但汽车工业机器人销量延续增长态势。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	随着全球制造业产能自动化水平提升，特别是中国制造业升级，预计到2017年全球工业机器人销量达到25万台，年复合增长率9.5%。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	根据IFR数据，2012年全球个人（或家庭）用服务机器人市场容量为73亿元，公共服务机器人市场容量为208亿元。目前看公共服务机器人产业化走在前面，市场容量更大。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	全球工业机器人本体市场以中国、欧盟地区、美国和日本为主。日本、美国、德国、韩国和中国五国存量占全球比例达71.24%,销量达69.92%。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	截至2012年底，全球机器人累计销量达到247万台。机器人平均使用寿命为12年，最长15年。估计现在全球机器人存量在120万~150万台之间。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	分区域看，亚洲、澳洲增幅达到9%，亚洲增幅主要由中国需求拉动，因为中国2012年工业机器人销量增幅达到30%。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	分生产地和消费地看，日本是惟一的工业机器人净出口国，拥有全球最大的机器人产能，占据全球机器人产量的66%。机器人消费地最大的区域是除日本以外的亚洲地区，占比约34%，而且是以中国市场为主。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	工业机器人销量占机床销量比反映各国机器人使用情况。这个比例的上升在一定程度上代表着这个国家机器人普及水平的提升。美国、日本、德国三国的机器人销量占机床销量比稳定在一定区间内（15%~25%），表明这三国的机器人销量趋势与机床销量趋势基本一致，也表明机器人行业发展较为稳定。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	中国机器人销量占机床销量比在2006~2011年间虽然有所提升，但仍然处于一个较低水平，不到5%。因此，中国机器人行业发展潜力还很大。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	美国、日本和欧盟地区在机器人行业发展处于世界领先地位，但它们的优势领域各不相同。日本在工业机器人、家用机器人方面优势明显，欧盟地区在工业机器人和医疗机器人领域居于领先地位，美国主要优势在系统集成领域，医疗机器人和国防军工机器人。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	在全球工业机器人本体市场，机器人四大龙头企业2012年收入占比超过50%，是这一领域的绝对强者。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	在机器人系统集成方面，除了机器人本体企业的集成业务，知名独立系统集成商还包括杜尔、徕斯和柯马等。</div>\r\n<div>\r\n	&nbsp;</div>\r\n<div>\r\n	近年来，随着服务机器人产业化趋势显现，在服务机器人领域也有一系列企业涌现出来。这些企业包括研制达芬奇机器人的直觉外科机器人公司和生产吸尘器机器人的IROBOT等。</div>\r\n<div>\r\n	&nbsp;</div>', '工业', '', '工控中国', 'recommend', '2015-08-05'),
	(176, '予墨：做到极致 中国汽车工业才会有希望', 'upload/images/1399086965875.jpg', '<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　在今年的<a class="firstLink" href="http://beijingchezhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">北京车展</a>上，自主品牌阵营的表现中，造型上最抢眼的是<a class="firstLink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">奇瑞</a>&alpha;概念车，而在技术上最抢眼的，则非<a class="firstLink" href="http://db.auto.sohu.com/model_4382/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">比亚迪唐</a>莫属了。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　<a class="notfirstlink" href="http://beijingchezhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">北京车展</a>归来，我就将车展的照片发到了空间里。有几位朋友一眼就看到了<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>&alpha;概念车的照片，并给予了较高的评价。不怕不识货就怕货比货，当把这些产品摆放到一起，好坏自然更加容易分辨。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　路遥知马力，日久见人心。笔者是一名评论员，也是一位<a class="firstLink" href="http://db.auto.sohu.com/model_3095/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">奇瑞E5</a>的车主。开了三年<a class="notfirstlink" href="http://db.auto.sohu.com/model_3095/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞E5</a>，对这款车型的稳定性有了更加深刻的了解。在笔者看来，<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>在核心零部件上的稳定性已经达到了较高的水准，但是在造型设计上，却一直没有掌握到消费者的审美脉搏。其产品线中有QQ这样的成功者，也有像<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>QQ me、<a class="firstLink" href="http://db.auto.sohu.com/model_2841/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">瑞麒G3</a>等这样的失败例子。很显然，过去<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>在造型上的成功主要靠运气。或许正因为如此，<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>过去才打造出那么多的车型。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　而从<a class="firstLink" href="http://db.auto.sohu.com/model_3171/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">艾瑞泽7</a>开始，<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>在造型上逐渐找到了市场痛点。其新一代车型<a class="notfirstlink" href="http://db.auto.sohu.com/model_3171/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">艾瑞泽7</a>、<a class="firstLink" href="http://db.auto.sohu.com/model_4047/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">瑞虎5</a>以及<a class="firstLink" href="http://db.auto.sohu.com/model_3522/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">E3</a>，在造型上都获得了消费者相当高的评价，即使是<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>内部人士，也开始对自己的产品有了信心。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　不过在笔者看来，<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>在<a class="notfirstlink" href="http://beijingchezhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">北京车展</a>上展出的&alpha;概念车，才是<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>转型后造型革新的真正起点。这款产品应该是<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>新任造型总监完全参与的第一款概念车，它的造型已经完全摆脱了过去<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>给我留下的总是在老车型上修修补补的标签印象，而是一款真正意义的全新造型。与其他自主车企的造型完全以欧化风格为主所不同，<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>&alpha;概念车更多的是在欧化风格之外，融入更多的中国元素。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　然而，从概念车到量产车，它们之间还有相当长的一段路要走。过去<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>在制造过程中，经常会因为生产工艺问题而在造型细节上作出妥协，正因为如此，<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>量产车的造型总是让人觉得细节上有所欠缺。所以，有了这么漂亮的概念车，就请<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>认真打造量产车吧，不要再让消费者失望了。只有做到极致，才可能迎来转型上的成功。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　<a class="notfirstlink" href="http://db.auto.sohu.com/brand_148/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">奇瑞</a>在造型上的不断改进，是在尽力弥补自己的短板，以获得更加均衡的产品品质；而<a class="firstLink" href="http://db.auto.sohu.com/model_2490/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">比亚迪</a>则截然不同，它们则在不断提高自己的长处，以获得更加出色的突出优势。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　<a class="firstLink" href="http://db.auto.sohu.com/model_3536/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">比亚迪秦</a>所搭载的双擎双模动力总成，已经在大家心中留下了比较深刻的印象。它们在过去一年所做的各种动力性能挑战赛，让我们见识了<a class="firstLink" href="http://db.auto.sohu.com/model_3536/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">秦</a>的动力性能。不过<a class="notfirstlink" href="http://db.auto.sohu.com/model_2490/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">比亚迪</a>并未就此止步，<a class="notfirstlink" href="http://beijingchezhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">北京车展</a>上它们所推出的<a class="firstLink" href="http://db.auto.sohu.com/model_4382/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">唐</a>，搭载的三擎双模四驱动力和传动系统，再次让我们眼前一亮。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　所谓的三擎双模四驱，是它搭载了2.0T、前电机和后电机三个引擎（实际上，前后电机的左右也是独立的，严格上讲可以是五擎）；能够以纯电动和混合动力两种模式运行；四轮独立驱动。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　在这一套插电混合动力总成之下，<a class="notfirstlink" href="http://db.auto.sohu.com/model_2490/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">比亚迪</a>为<a class="notfirstlink" href="http://db.auto.sohu.com/model_4382/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">唐</a>这款大型<a class="firstLink" href="http://db.auto.sohu.com/suv.shtml" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">SUV</a>确立了百公里加速5秒以内、全时四驱以及百公里综合油耗2L的性能目标。纵观目前国内外的汽车市场，能达到这样的综合性能，也是凤毛麟角。我想，如果最终能够实现量产，那么这款车型可以看做是中国自主品牌车型在性能追求上的一个里程碑。这也是王传福在<a class="notfirstlink" href="http://beijingchezhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">北京车展</a>上喊出的&ldquo;弯道超车&rdquo;的底气。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　这两年合资品牌不断加大在中国市场的投入，向更低<a class="firstLink" href="http://db.auto.sohu.com/baike/249.shtml" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">级别</a>的细分市场渗透，自主品牌的压力日渐增大。但正是在这些压力之下，自主品牌反而激发出了更强的斗志，在<a class="firstLink" href="http://db.auto.sohu.com/model_1744/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">前进</a>的道路上更加勇于探索。在经历了几年的低迷期之后，部分自主品牌已经逐渐找到了清晰的发展脉络。总结起来，其实也就是一句话，只有做到极致才能成为市场的宠儿。这一点，在特斯拉的火爆上也能看得出来。未来几年，通过<a class="notfirstlink" href="http://beijingchezhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51);" target="_blank">北京车展</a>，我对自主品牌有了更强的信心，未来必然会有一批自主品牌涌现出来，成为具有世界级竞争力的品牌。我想，这正是中国汽车工业不屈不挠的精神体现，也是中国汽车工业的希望所在，中国人的希望所在。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　----------------------------------</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　<strong>作者汪军艇，80后。<a class="firstLink" href="http://wuhan.auto.sohu.com/" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">武汉</a>理工大学汽车学院<a class="firstLink" href="http://db.auto.sohu.com/baike/250.shtml" style="text-decoration: none; outline: none medium; color: rgb(51, 51, 51); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(59, 89, 152);" target="_blank">发动机</a>专业毕业，在车企从事研发多年，现为独立汽车评论员。如果您有什么想和我聊的，请给我留言。如果您有购车方面的疑问，也可和我交流。如果您觉得我的某些文章还符合您的口味，欢迎在&ldquo;搜狐新闻&gt;订阅&rdquo;中输入&ldquo;予墨auto&rdquo;并点击红色&ldquo;+&rdquo;号订阅，或扫一扫以下二维码直接订阅！感谢支持。</strong></p>\r\n<p style="margin: 15px 0px 0px; padding: 0px; color: rgb(45, 45, 45); font-family: 宋体; font-size: 16px; line-height: 28px;">\r\n	　　<img alt="" src="http://cache.k.sohu.com/img8/wb/2014/03/11/139454602396744283.png" style="border: 0px none;" /></p>', '汽车', '汪军艇', '予墨Auto', 'recommend', '2014-05-03'),
	(177, '全市工业经济民营经济科技创新暨帮联企业会议召开', 'upload/images/1399087155640.jpg', '<div style="margin: 0px; padding: 0px; text-align: center; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	<span style="margin: 0px; padding: 0px; font-size: 16pt;">全市工业经济民营经济科技创新暨帮联企业会议召开</span></div>\r\n<div style="margin: 0px; padding: 0px; text-align: center; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	&nbsp;</div>\r\n<div style="margin: 0px; padding: 0px; text-align: center; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	<strong style="margin: 0px; padding: 0px;"><span style="margin: 0px; padding: 0px; font-size: 22pt;">推进提质增效　释放发展活力</span></strong></div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	<p style="margin: 0px; padding: 0px; text-align: center;">\r\n		<span style="margin: 0px; padding: 0px; font-size: 16pt;">&nbsp;</span></p>\r\n	<p style="margin: 0px; padding: 0px; text-align: center;">\r\n		<span style="margin: 0px; padding: 0px; font-size: 16pt;"><img alt="" border="0" src="http://www.hbnews.net/upload/Image/tp2013/1_7365631229.jpg" style="margin: 6px 0px; padding: 0px; border: 0px currentColor; max-width: 580px;" zcmsimagerela="736563" /></span></p>\r\n	<p style="margin: 0px; padding: 0px; text-align: center;">\r\n		<span style="margin: 0px; padding: 0px; font-size: 16pt;">&nbsp;</span></p>\r\n</div>\r\n<p style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	　　4月30日下午，淮北市召开工业经济、民营经济、科技创新暨帮联企业会议。市领导肖超英、黄晓武、阚相华、樊勇、杨军、曾凡银、杨彦颖、朱浩东，市政府秘书长胡永达等出席会议。</p>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	　　会上，副市长朱浩东作全市工业经济等四项工作报告；市委常委、常务副市长杨军通报了2013年度县区工业经济、民营经济目标任务完成和全市民营企业50强排序情况。会议对全市民营企业综合10强、纳税10强、创新10强和公益10强进行了授牌。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	　　市委副书记、市长黄晓武在讲话中指出，要强化工业经济主引擎意识，大力推进工业提质增效。要抓重点项目，加快建设一批重大产业项目，积极实施一批重点技改项目，抓紧谋划储备一批重大项目，大力引进一批招商项目，形成新的经济增长点；要抓重点产业，做深做长煤基产业，做优做强非煤优势产业，培育扩张战略性新兴产业；要抓重点园区，培育主导产业，完善服务功能和公共服务平台，实施园区提升行动。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	　　黄晓武要求，要强化民营经济主力军意识，全面释放经济发展活力。要放宽和降低民间投资的准入领域和准入门槛，着力破解&ldquo;准入难&rdquo;；要充分激发群众创业积极性，抓好重点人群创业指导，加快构筑全民创业平台，着力破解&ldquo;创业难&rdquo;；要加大民营企业的信贷支持，拓宽民营企业融资渠道，强化财政性资金导向作用，着力破解&ldquo;融资难&rdquo;。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	　　黄晓武强调，要强化科技创新主动力意识，加快推进创新型城市建设。要着力推动产业转型升级，强化企业创新能力建设，搭建产学研创新平台，营造创新发展环境。要强化帮联企业主抓手意识，着力打造一流发展环境。要当好掌握企业实情&ldquo;调研员&rdquo;、政策法规&ldquo;宣讲员&rdquo;、破解企业难题&ldquo;协调员&rdquo;和助推企业发展&ldquo;服务员&rdquo;，确保帮在点子上、联在关键处，提振企业发展信心，持续优化发展环境。</div>\r\n<div style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); line-height: 24px; font-family: SimSun; font-size: 14px;">\r\n	　　市委副书记樊勇主持会议并就贯彻会议精神提出要求。</div>', '工业', '吴永生', '淮北新闻网', 'recommend', '2015-08-05'),
	(178, '工业社会向信息社会发展过程中，将会消失的五样东西', 'upload/images/1399087323937.jpg', '<p style="margin: 26px 0px; padding: 0px; color: rgb(37, 37, 37); line-height: 24px; text-indent: 2em; font-family: 宋体, sans-serif; font-size: 14px;">\r\n	本文是Albert Wenger为DLD演讲准备的提纲，简单讲述了从工业社会演变为信息社会过程中消失的五样东西&mdash;&mdash;</p>\r\n<ul>\r\n	<li style="margin: 0px; padding: 0px; list-style-type: none;">\r\n		<p style="margin: 26px 0px; padding: 0px; text-indent: 2em;">\r\n			增长的消失。我的观点是由于我们正在走向一个具有大量正外部性的世界，GDP已经不再是衡量经济增长的好方法。比如可汗学院在成长的过程中会减少传统的纸质教科书的销售量，这就好比是GDP的负增长。</p>\r\n	</li>\r\n	<li style="margin: 0px; padding: 0px; list-style-type: none;">\r\n		<p style="margin: 26px 0px; padding: 0px; text-indent: 2em;">\r\n			就业的消失。主要是自动化的崛起和自助式服务的增长。例如，商业行为正在从线下转移到线上，即便在实体商店里，自助式的结账方式也趋于流行。这对就业造成了明显的冲击。</p>\r\n	</li>\r\n	<li style="margin: 0px; padding: 0px; list-style-type: none;">\r\n		<p style="margin: 26px 0px; padding: 0px; text-indent: 2em;">\r\n			资本的消失。过去的公司需要大量的运营资本用来支付工资，供应商，租金等等，这些成本在收入之前就需要付出。现在这些公司则可以通过预售，按需生产或数字化流通（digital<br />\r\n			distribution）等方式的组合来摆脱甚至逆转对运营资本的需求。</p>\r\n	</li>\r\n	<li style="margin: 0px; padding: 0px; list-style-type: none;">\r\n		<p style="margin: 26px 0px; padding: 0px; text-indent: 2em;">\r\n			公司的消失。公司曾经是通过减少外部刺激以实现组织协调的重要手段。现在由于信息的开放，在没有公司的条件下我们也可以实现同样的目标甚至做的更好，这在非盈利的项目上尤为突出。一个有趣的例子是&ldquo;Twitch玩《口袋妖怪》&rdquo;的故事。</p>\r\n	</li>\r\n	<li style="margin: 0px; padding: 0px; list-style-type: none;">\r\n		<p style="margin: 26px 0px; padding: 0px; text-indent: 2em;">\r\n			专注的消失。无论是个人还是组织曾经都有很强的专注性，而现在，使个人分神的东西则非常多，组织也花费大量的成本用于使一群人专注于某一件事情上。</p>\r\n	</li>\r\n</ul>\r\n<p style="margin: 26px 0px; padding: 0px; color: rgb(37, 37, 37); line-height: 24px; text-indent: 2em; font-family: 宋体, sans-serif; font-size: 14px;">\r\n	[本文编译自：continuations.com]</p>', '工业', '', '36氪(北京)', 'hot', '2015-08-05'),
	(179, '同比增长10.6% 一季度我市规上工业增加值高于全省平均水平', 'upload/images/1399087391937.jpg', '<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　日前，记者从市经济和信息化委员会获悉，一季度，我市规上工业增加值增长10.6%，高于全省平均水平1.4个百分点，超省下达开门红目标4.6个百分点，全省列第8位，顺利完成了一季度工业经济&ldquo;开门红&rdquo;的目标任务。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　同比增长10.6% 一季度我市规上工业增加值高于全省平均水平</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　平稳发展 亮点纷呈</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　今年以来，我市按照市委三届七次全会提出的实施后发追赶，&ldquo;打硬仗，补欠账&rdquo;的工作要求和部署，狠抓落实， 多措并举促进工业发展，全市规上工业在克服种种不利影响的同时，平稳发展、亮点纷呈，顺利实现了一季度工业经济&ldquo;开门红&rdquo;的目标任务。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;工业经济明显回升</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　一季度，我市333户规模以上企业累计实现工业总产值135.60亿元，增长10.2%;规上工业增加值增长10.6%，高于全省平均水平1.4个百分点，超省下达开门红目标4.6个百分点，全省列第8位。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　一季度我市规上企业共333户，比去年同期净增7户，全年拟新增18户规上企业。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;工业用电稳步增长</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　一季度全市累计销售电量16.64亿千瓦时，较去年同期增长9.66%;其中大宗工业用电量同比增加11.72%。反映出工业经济持续向好，电力供应和电量消纳两旺。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;优势产业加快发展</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　一季度，全市&ldquo;3+1&rdquo;优势产业(水电电冶、机械制造、农产品加工、新材料新能源)实现工业总产值108.77亿元，净增10.43亿元，增长10.6%，占全市工业总量的80.2%。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;重点企业运行平稳</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　一季度，全市规上企业中产值上亿元企业有27户。其中，水电龙头企业国电大渡河瀑布沟发电有限公司产值10.09亿，增长6.2%;机械制造龙头企业长安集团四川建安车桥分公司产值6.45亿元，略增0.1%;电冶龙头企业一名特种合金实现产值4.99亿元，增长11.8%;新材料新能源龙头企业四川中雅科技有限公司实现产值2.80亿元，增长12.9%。另外，雅安电力集团实现产值4.28亿元，增长19.3%，四川华能宝兴河水电公司实现产值2.43亿元，增长1.3%。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;重点行业逐步复苏</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　一季度，全市电力生产、化学品制造、纺织业发展平稳;汽车制造、煤炭生产发展较慢;金属冶炼和矿物制品业、茶叶加工、食品制造、医药制造发展较快，重点行业正在逐步复苏。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;园区经济蓄势待发</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　随着我市灾后重建进度加快，园区基础设施建设投入增加，招商引资和退城入园项目快速推进，园区发展呈现蓄势待发的态势。一季度园区企业也不断加大投入，累计完成投资额12.32亿元，增长17.26%;462户企业实现营业收入69.81亿元，占全市工业经济比重份额约60%。同时，一季度全市产业园区从业人数达到5.8万人，同比增加1898人(其中工业从业人数4.8万人，同比增加1500人)，产业对就业带动能力进一步凸显。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　稳中有忧 困难并行</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　尽管我市工业经济实现了 &ldquo;开门红&rdquo;，但在严峻而复杂的经济形势下，县区发展仍不平衡，工业投资增长乏力，需要全力克服的困难依然不少。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;工业结构不合理。我市工业结构以水电为主，一季度，全市水电产业总产值达36.78亿，占全市规上企业总产值的27.12%，由于水电行业本身受水量和建成规模制约，增量相对较小;而传统加工行业如电冶、纺织等增加值率较低，对增加值增长带动作用不明显。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;成品油保障不足。随着经济的快速增长，成品油需求呈高速增长态势，加之我市灾后重建项目全面铺开，重点工程用油大幅增加，元旦前后一度出现供油紧张的局面，目前市内无大中型油库，规划的一级油库建设也因成雅铁路未动工而尚未启动，一旦出现资源紧张情况，将导致我市成品油供应能力不足。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;企业融资困难。受灾企业尤其是受损严重企业因灾后恢复重建耗费大量现金，影响了企业正常的资金流动周转;地震造成企业的设备和厂房受损，向银行申请贷款的抵质押物不足，银行从控制风险角度考虑，会减少对受灾企业的贷款;国家宏观调控，实施紧缩的货币政策，提高了银行存款准备金率，许多中小企业从银行申请贷款较难。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　&mdash;&mdash;企业开工不足。一季度，全市有46户企业处于停产半停产状态(40户完全停产，6户半停产)，占全市规上企业数的14%;其中电冶企业24户(受枯水期电价影响)，煤炭企业13户(受行业整顿影响)，化工企业4户，其他企业5户。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　抢抓机遇 乘势而上</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　面对当前严峻而复杂的形势，我市工业战线正借助灾后恢复重建和雅安全域纳入成都&ldquo;1+7&rdquo;经济圈同城化发展等历史机遇，乘势而上，确保完成&ldquo;双过半&rdquo;及全年的目标任务。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　市经信委相关负责人表示，将加快项目推动工作。充分运用国家和省、市级工业发展资金、重建资金，推动我市灾后恢复重建和技改项目工作，采取倒逼机制、限时办结，将责任落实到具体部门，务实推进项目建设，提高项目竣工率，努力形成新的增量;加快建安、川西、雅化、金红叶、青江机器等工业企业&ldquo;退城入园&rdquo;技改搬迁项目和三九产业园、一名微晶、王老吉、新筑通工等在建重点项目实施，力争在下半年形成部分增量。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　同时，将加快区域合作步伐。本着&ldquo;平等、互利、共赢&rdquo;原则，充分发挥电力、生态等突出优势，做好产业配套服务和成链发展。加强与成都、眉山、德阳、乐山对接，积极承接产业转移，共同打造优势产业集群。一是加强双流合作项目的协调，做好项目的引进和服务;二是充分利用灾后重建政策，继续加快推进飞地园区、成雅工业园区征地拆迁、基础设施建设、招商引资等工作。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　此外，还要加强园区平台建设。一是加快打造芦天宝飞地产业园区(四川雅安经开区)、荥经县循环经济产业集聚区、芦山县产业集中区等重点灾后重建平台，发挥其灾后重建主阵地作用，促进特色产业集聚发展。二是推动汉源工业园区、石棉工业园区等省级园区建设，促进园区企业尽快形成投资和生产规模。三是指导各产业园区列出负面清单，引导企业和项目向相适应的园区集约发展，进一步优化我市产业结构和布局。</p>\r\n<p style="margin: 0px; padding: 0px; color: rgb(0, 0, 2); line-height: 26px; font-family: 宋体, Arial, Verdana, Tahoma; font-size: 14px; background-color: rgb(247, 252, 255);">\r\n	　　最后，还将强化资金和电力保障。深入了解企业融资情况，积极搭建银企沟通平台，加强银、政、企三方合作，建立中小企业融资平台，配合省经信委做好全省银行系统与园区项目对接工作，为园区及企业提供融资途径和通道，解决企业和项目融资问题。</p>', '工业', '', '北纬网', 'hot', '2015-08-05'),
	(180, '演绎内涵式发展新思维 ??南康“工业强区”挺起经济发展脊梁', 'upload/images/1399087519093.jpg', '<p style="line-height: 28px; font-size: 16px;">\r\n	<span style="color: rgb(0, 0, 255); font-family: 楷体;">　近日，南康汇丰矿业工人在矿产品提炼车间检查生产管道。特约记者杨晓明 摄</span></p>\r\n<p style="line-height: 28px; font-size: 16px;">\r\n	<strong><font color="maroon" face="楷体">掘金开放型经济</font></strong></p>\r\n<p style="line-height: 28px; font-size: 16px;">\r\n	<font face="楷体">　　10个亿元重点工业项目列入赣州市重点项目调度，22个项目列入省级调度，家具产业园、家具市场和龙回、镜坝、龙华工业园等平台建设全面提速&hellip;&hellip;去年以来，一个又一个工业项目，扣动着南康&ldquo;工业强区&rdquo;的主频律动，激荡出南康工业转型升级的雄浑乐章，挺起了南康经济发展的脊梁。今年一季度，该区工业总产值达142.8亿元，同比增长67.6%；工业增加值达17.2亿元，同比增长15.9%。</font></p>\r\n<p align="center" style="text-align: center; line-height: 28px; font-size: 16px;">\r\n	<font color="blue"><strong>演绎内涵式发展新思维</strong></font></p>\r\n<p align="center" style="text-align: center; line-height: 28px; font-size: 16px;">\r\n	<font color="blue">&mdash;&mdash;南康&ldquo;工业强区&rdquo;挺起经济发展脊梁</font></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	<strong>舍与得的抉择</strong></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	<strong>&mdash;&mdash;变招商引资为招商选资，围绕转型升级上项目</strong></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	总投资20亿元的颐高数码产业园签约落户，总投资30亿元、占地600亩的南康金融中心项目及总投资50亿元、占地1000亩的南康汽车城项目已正式启动&hellip;&hellip;沉甸甸的大项目无论是规模，还是潜力，均是&ldquo;优中选优&rdquo;。</p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	南康区变招商引资为招商选资，突出开展以商招商、专业招商、产业链招商等十大招商活动， 紧紧围绕产业发展定位和转型升级要求，根据产业链条及产业之间关联度，围绕家具、服装、矿产品、电子等主导产业和电子商务、总部经济，紧盯世界五百强、行业百强和大型民营企业，着力引进一批龙头项目、配套产业链项目、总部经济项目、高新企业和知名企业。同时，把招商选资与引进技术、人才和管理经验结合起来，大力引进研发中心、总部经济、服务外包型企业，着力引进和实施一批对该区发展方式转变和产业转型升级具有较强支撑和拉动作用的重大项目，为产业转型升级提供项目支撑。</p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	南康对有意入驻的项目并非照单全收，而是严把项目评估关，对高污染、高能耗企业坚决说&ldquo;不&rdquo;。纵然门槛再高，也挡不住&ldquo;高个子&rdquo;和&ldquo;大块头&rdquo;的脚步。2013年，该区跟踪在谈项目129个，意向总投资金额287.59亿元，其中内资项目119个，含5000万元以上项目94个、亿元项目59个；外资项目10个，包括500万美元以上项目7个；新引进省外5000万元以上内资项目11个，其中亿元项目5个，同比增长28.45%；实际进资27.65亿元，其中亿元项目进资15.95亿元，同比增长18.72%。</p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	<strong>质与量的辩证</strong></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	<strong>&mdash;&mdash;&ldquo;不仅是速度的跨越，更是质量的攀升&rdquo;，内涵式发展后劲十足</strong></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	德普特科技、罗边玻纤通过实施科技创新被认定为国家高新技术企业，博晶科技、超越电子、格棱电子等企业快速成长&hellip;&hellip;去年以来，南康坚持培大扶强，重点扶持一批主业突出、市场占有率高、掌握核心竞争力的企业，通过要素倾斜、技改扩能、联合重组等方式，做成行业的&ldquo;小巨人&rdquo;。同时，大力鼓励重点企业建立研发中心和引进专利技术，帮助企业争取上级技改项目，改进生产工艺，提高核心竞争力。去年，该区47户重点工业企业实现主营业务收入157.4亿元，完成增加值36.8亿元；纳税百万元以上企业达到32家，纳税1000万元以上企业达10家，其中3000万元以上企业3家&hellip;&hellip;产业龙头、骨干企业让南康企业有群山、更有高峰，联袂演绎县域经济&ldquo;多点喷涌&rdquo;的发展佳话。</p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	抓量求质追高，&ldquo;咬定&rdquo;大项目不放松，让大项目成转型升级的&ldquo;支点&rdquo;，南康以硬手腕提升传统产业和培植新兴产业双轮驱动的亮点层出不穷：家具、有色金属、服装等传统产业发力攀升，节能照明灯饰、电子等新兴产业集群发展。同时，南康以打造中部地区重要的有色金属加工和贸易基地为目标，深入发展有色金属产业；以打造中国中部家具产业基地为目标，规范发展家具产业；以打造江西承接沿海电子产业转移示范区为目标，培植发展电子产业。</p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	<strong>高与低的战略</strong></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	<strong>&mdash;&mdash;紧盯高新技术，&ldquo;外交远朋、内攀高亲&rdquo;借梯登高</strong></p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	去年8月，为了让家具企业早日实现转型升级梦，南康邀请了南京林业大学家具与工业设计学院院长、博导吴智慧和南京林业大学家具设计系主任、副教授、硕士生导师陈于书，共同为200多家家具业主指点迷津。&ldquo;常常说转型升级，可是并不清楚转型升级到底该怎么走，今天算是长了见识，给我们指了一盏明灯。&rdquo;两位专家的授课让家具业主受益匪浅。</p>\r\n<p style="margin: 0px 3px 15px; line-height: 28px; text-indent: 30px; font-size: 16px;">\r\n	瞄准&ldquo;高新+尖端&rdquo;，南康深挖内力、广借外力，强化人才和品牌支撑，全力抓好招才引智，围绕有色金属、家具、电子、服装等产业进一步加强与中国家具协会、深圳家具协会、南京林业大学、江西理工大学、江西服装学院等的产学研合作，构建校企研发共享共建机制，加速科技成果向现实生产力的转化，努力培育一批自主创新型企业群体。同时，鼓励企业加强研发，促进产品由产业链低端向高端发展、由价值链低位向价值链高位提升。南康蓝天木业有限公司一直坚持自主研发、原创设计，把新产品的研发视为公司发展的引擎，设立研发设计机构，配置独立的样品作业生产线。&ldquo;我们不断加强与专业研发机构的交流与合作，将公司研发部门制定的产品设计方案传输到专业研发机构，做到既发挥专业研发机构的专业优势，又与市场实际紧密结合。&rdquo;该公司总经理刘谊介绍，他们研发设计的&ldquo;吉祥百得&rdquo;实木套房系列产品获得了业内多个产品设计奖项和国家专利认证证书。（文/图）</p>', '工业', '古幸 特约记者 刘家喜 记者 彭雪英', '中国赣州网-赣南日报', 'hot', '2015-08-05'),
	(181, '江都将打造高端机械装备基地', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">江都力争通过3-5年的努力，着力打造苏中乃至全省知名的高端机械装备特色产业基地。这是记者5月15日在2014年中国&middot;江都机械产业专家咨询暨招商推介会上获得的消息。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　近年来，江都区将坚持走特色发展、融合发展、转型发展、统筹发展之路，坚持把产业转型升级作为推动经济社会健康协调发展的战略举措，形成了以机械装备、汽车及零部件、船舶特钢等为代表的一批优势支柱产业。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　据了解，江都的工业现有汽车及零部件、机械装备、船舶特钢、医药化工四大主导产品，其中，机械装备产业是整个工业经济的重要支柱，现有机械装备规模以上企业250家，占全区规模以上企业总数的40%左右，其中亿元以上企业30家，从业人数4.3万多人。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　参会人员观看了《江都高端和机械制造业巡礼》专题片。东南大学机械学院、省机械行业协会、南京理工大学的领导、专家作了专题演讲。仙城工业园、高端装备产业园作了投资环境专题推介。仙城工业园区将坚持工业化与城市化互动并进，坚持以产业转型为主线、以重大项目为支撑、以规划设计为龙头、以融资筹资为关键，力争跻身省级高新技术开发区；高端装备产业园力争在3-5年内建成空间布局合理、产业特色鲜明、功能配套完善、省内知名的重点工业园区，努力打造产业高端化和新型城镇化融合互动发展的示范区。</span></p>', '机械', '李杨', '时报讯', '', '2014-05-18'),
	(182, '“2014中国?江都机械产业专家咨询暨招商推介会”顺利召开', 'upload/images/1400410236296.jpg', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">5月15日，2014中国&middot;江都机械产业专家咨询暨招商推介会在扬州市江都区隆重举行。省经信委副主任秦雁、扬州市江都区委书记蒋爱祥、东南大学机械学院院长汤文成等领导嘉宾出席本次活动。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　近年来，江都区机械产业发展迅猛，在数控机床、环保机械、建材机械、电工电器、工程机械等领域培育出一批优质企业和拳头产品，除此之外，今年江都区委区政府高标准规划建设高端装备产业园，为做强做大机械产业创造新的承载体。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　活动中，与会专家就机械产业相关特点进行了专家演讲，同时对江都区仙城工业园、高端装备产业园进行了招商推介。活动最后，26个机械产业招商项目当场签约。</span></p>', '机械', '时修艳 张春景 陈 英', '江苏经济报', 'recommend', '2014-05-18'),
	(183, '我国机械五金行业正面临巨大压力', '', '<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　 近年来，我国的空气质量堪忧，雾霾污染困扰着全国大多数的城市。人民长期生活在没有阳光的环境里面，同时，雾霾中的有害物质也在侵蚀着人们的身体健康。面对这样的情况，有关<a href="http://www.chinairn.com/yjbg/moref15f15f62ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">环保</a>的话题越来越被人们重视，环保对于各行业，特别是<a href="http://www.chinairn.com/yjbg/moref15f3f15ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">制造</a>行业的影响日益显着，<a href="http://www.chinairn.com/yjbg/moref15f3f12ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">机械</a>五金<a href="http://www.chinairn.com/yjbg/moref15f3f15ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">加工</a>业受环保政策的影响也变得越来越明显。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　随着新一轮的雾霾天气影响，环保产业再次被提及。如今<a href="http://www.chinairn.com/report/20140117/105502875.html" style="color: rgb(51, 51, 51); text-decoration: none;">高耗能</a>产业盲目发展已经成为中国转变<a href="http://www.chinairn.com/yjbg/moref15f18f72ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">经济</a>发展方式的拦路虎，这也凸显出中国经济转型面临困局。新一届政府对<a href="http://www.chinairn.com/report/20130711/115034862.html" style="color: rgb(51, 51, 51); text-decoration: none;">环保工程</a>的重视程度明显提升，这其中也包含对机械五金行业的规划。对于如今中国的实际情况而言，环保没有太多高精尖的<a href="http://www.chinairn.com/yjbg/moref15f1f4ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">技术</a>，主要靠政策推动，&ldquo;国十条&rdquo;的出台有望形成有效的驱动力。当然，雾霾治理将是一个长周期事件，在这一过程中，市场和政策的变化将持续呈现，相关产业所受到的事件刺激和需求提振也将持续数年。这其中也不可避免将出现种种反复，需要坚持的毅力和坚决的信心。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　在治理过程中会改变机械五金行业的一些产品类型。如<a href="http://www.chinairn.com/report/20140319/105244121.html" style="color: rgb(51, 51, 51); text-decoration: none;">LNG</a>产品在需求增加，<a href="http://www.chinairn.com/report/20140327/110951543.html" style="color: rgb(51, 51, 51); text-decoration: none;">新</a><a href="http://www.chinairn.com/yjbg/moref15f15f58ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">能源</a><a href="http://www.chinairn.com/report/20140317/102139414.html" style="color: rgb(51, 51, 51); text-decoration: none;">挖掘机</a>、<a href="http://www.chinairn.com/report/20140315/095537581.html" style="color: rgb(51, 51, 51); text-decoration: none;">装载机</a>、<a href="http://www.chinairn.com/report/20140315/091849579.html" style="color: rgb(51, 51, 51); text-decoration: none;">混凝土</a><a href="http://www.chinairn.com/report/20140321/135759634.html" style="color: rgb(51, 51, 51); text-decoration: none;">泵</a>车等开始出现。随着中央财政环保资金的投入，以及各地方政府的理解加深，新的治理环境污染工程、改造原有工业工程等会增多。这些对机械五金加工行业都将提出需求和创造新的机遇。</p>', '机械', '', '中研网', '', '2014-05-18'),
	(184, '世界先进包装机械发展高端化', '', '<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　我国进入高速发展阶段，<a href="http://www.chinairn.com/yjbg/moref15f13f53ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">包装</a>机械竭力打开欧美<a href="http://www.chinairn.com/scfx/gjsc.html" style="color: rgb(51, 51, 51); text-decoration: none;">国际市场</a>。而要成功进军国际市场，一方面与中国包装<a href="http://www.chinairn.com/yjbg/moref15f3f12ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">机械</a>的<a href="http://www.chinairn.com/yjbg/moref15f1f4ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">技术</a>水平有关，另一方面也与美国包装机械市场的形态有关。作为一个高度发达的自由化市场，美国包装机械<a href="http://www.chinairn.com/yjbg/moref15f3f15ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">制造</a>商两极分化现象明显。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　当前，世界先进包装机械的发展已呈现出集机、电、气、液、光、磁、生为一体的势头，生产的高效率化、产品节能可回收化、高新技术实用化、智能化已成趋势，这也应该是我国包装机械业的主流发展方向。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　以检测试备、打码装置为代表的小巧精致的<a href="http://www.chinairn.com/yjbg/moref15f3f13ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">电子</a>产品在美国发展得欣欣向荣；而以热收缩包装机、裹包机和封箱机为主的通用型包装机械也占有相当比重；以<a href="http://www.chinairn.com/report/20140321/101848894.html" style="color: rgb(51, 51, 51); text-decoration: none;">灌装机</a>、贴标机、封盖机为主的大型包装机械生产线，美国基本上已经不生产，市场几乎全部为进口<a href="http://www.chinairn.com/yjbg/moref15f3f12ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">设备</a>、特别是德、意厂家生产的设备所占领。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　中国包装机械制造水平和工业设计水平通过模仿、引进技术和资金以及全球化采购等方式得以快速发展。今天中国的包装机械制造企业很容易通过全球化采购获得一些关键<a href="http://www.chinairn.com/yjbg/moref15f4f18ff1.html" style="color: rgb(51, 51, 51); text-decoration: none;">零部件</a>，从而迅速提高设备的技术水平和可靠性。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　在一些技术含量较低的产品上，目前中国生产的很多包装机械，已经可以满足美国市场的要求，并最有可能在短期内获得突破性进展。但在全自动打包机、贴标机、封箱机和<a href="http://www.chinairn.com/report/20140303/173719459.html" style="color: rgb(51, 51, 51); text-decoration: none;">机械手</a>等设备上，中国制造的机械还无法同德、意、日产品竞争。</p>\r\n<p style="padding: 0px 0px 22px; margin: 0px; font-family: 宋体, Arial, sans-serif; font-size: 14px; line-height: 28px;">\r\n	　　通过技术的提升和优化，实现高端包装设备的国产化是指日可待的，而通过高新技术的不断应用和推动，武装和强化行业的整体水平，我国也将朝着世界包装中心的方向不断前进。</p>', '机械', '', '中研网', '', '2014-05-18'),
	(185, '长沙工程机械产业国内率先突破1000亿元大关', '', '<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　长沙工程机械产业在国内城市率先突破1000亿元大关。记者今天从省外专局获悉，第十届中美工程技术研讨会湖南先进装备制造技术研讨分会将于5月26日至28日在长沙召开，32位中美顶尖专家将同台论道。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　中美工程技术研讨会由国家外国专家局与美国华人专家组织&mdash;&mdash;美洲中国工程师学会发起，每两年在中国举办一次，目前已经举办了9届。经省外专局的积极争取，国家外专局同意将本届研讨会主办地设在长沙。2010年12月，长沙工程机械产业已迈上千亿产业集群的台阶，成为长沙第一个千亿产业集群，在国内城市率先突破1000亿元大关。今年1至3月，长沙工程机械完成规模工业产值为394.55亿元，增长6.8%。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　此次研讨会由国家外国专家局、省人民政府、美洲中国工程师学会(CIE/USA)、美国机械工程师学会(ASME)联合主办，将围绕&ldquo;先进装备制造技术&rdquo;主题进行研讨。省人社厅副厅长、省外专局局长王瑰曙表示，通过这样高规格的论坛，将促使长沙工程机械行业继续在自主创新、知识产权保护和关键配套件等方面继续进步。</p>', '机械', '', '湖南日报', '', '2014-05-18'),
	(186, '机械行业：复苏乏力 看好逆周期板块', '', '<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	13年业绩企稳，14年一季度业绩欠佳，显示行业整体复苏仍待时日。13年机械板块<a class="a-tips-Article-QQ" href="http://finance.qq.com/l/stock/shsgs/index.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">上市公司</a>共实现营业收入7661亿元，同比提升了2.51%；实现归属母公司净利润370亿元，同比下滑11.52%。由此可见，在13年，尤其是下半年<a class="a-tips-Article-QQ" href="http://finance.qq.com/l/financenews/domestic/index.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">宏观经济</a>温和复苏的情况下，机械行业整体业绩实现了温和反弹，其主要表现为营收开始实现正增长，利润下降幅度大幅收窄，已接近持平。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	14年1季度机械板块上市公司共实现营业收入1545亿元，同比下滑2.21%；实现归属母公司股东净利润73亿元，同比下滑9.91%。显示目前行业营收及利润下降的幅度都在降低，然而提升速度较为缓慢，在宏观经济复苏仍有可能出现反复的情况下，行业未来的盈利状况仍然不容乐观。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	造船企业业绩复苏明显。13年行业主要上市企业取得营收1324.26亿元，同比增长1.95%；实现净利润92.53亿元，同比下降25.82%；而13年取得营收1459亿元，获得归属母公司净利润127亿元，较12年同比提升10.17%和37.35%。在去产能和订单、船价同时提升的作用下，我们认为15年行业的业绩拐点将会到来。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	逆周期效应显著，坚定看好铁路设备板块。13年主要上市企业共实现营收2122亿元，同比增长6.9%；实现净利润100.09亿元，同比提升了17%。14年调整后今年的铁路投资总额将达到8000 亿元以上，该投资额创历史第二高，仅次于10年；14 年设备投资额由1200 亿增至1430 亿以上，创历史峰值。另外动车组的大规模交付使今年设备企业业绩有保障，因此我们坚定看好14年铁路设备板块表现。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	油气钻采设备受投资减少、反腐、周边海域领土争端影响，今年看法偏负面。13年主要上市企业实现营业收入166.55亿元，同比增长17.16%；实现净利润15.79亿元，同比增长11.2%。14年<a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/PTR.N.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">中石油</a>资本支出较13年下降了14.3%，预示着今年三大油企的投资战略将偏向保守，同时受到反腐、周边海域领土争端影响，我们对油气设备板块的看法偏向负面。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	市场表现及投资建议。13年以来机械板块跑赢<a class="a-tips-Article-QQ" href="http://finance.qq.com/l/stock/dpfx/" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">大盘</a>，14年以来在申万板块涨跌幅中排名第15，推荐受益于投资超预期及业绩有保障的铁路设备板块，推荐个股：<a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/hk/ggcx/01766.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">中国南车</a>（601766）、<a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/hk/ggcx/06199.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">中国北车</a>（601299）。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	风险提示：宏观经济复苏出现反复，固定资产投资大幅下滑。</p>', '财经', '', '东莞证券', '', '2014-05-18'),
	(187, '我国电子信息制造业已经告别高速增长时代', '', '<p>\r\n	<span style="font-family: 宋体; font-size: 14px; line-height: 25px;">　　我国电子信息制造业已经告别高速增长时代，将可能进入&ldquo;深度调整期&rdquo;。权威机构赛迪智库昨天在《中国电子信息产业季度形势研判报告》中发布的数据显示，今年前三个月我国电子信息制造业实现销售产值2.2万亿元，同比增长9%，较去年和前年同期分别回落3.6和1.5个百分点。赛迪智库电子信息产业研究所所长安晖表示，这一时期的突出特点是产业内部结构剧烈变动、企业外部环境趋向复杂，我国传统整机产业规模优势与主要产品市场低迷的矛盾日渐突出。在此背景下，我国电子信息制造业提质增效的压力将大幅增加。他表示，从一季度整个产业发展情况来看，部分企业经营状况堪忧。比如，由于受到互联网企业的冲击，传统电视制造厂商濒临亏损的边缘；而</span><a href="http://tech.hexun.com/telecom/index.html" style="color: rgb(72, 90, 144); font-family: 宋体; font-size: 14px; line-height: 25px;" target="_blank">通信</a><span style="font-family: 宋体; font-size: 14px; line-height: 25px;">行业企业虽然整体实力较强，但在苹果、三星等巨头的挤压下，平均利润仅为2%至3%.</span><span style="font-family: 宋体; font-size: 14px; line-height: 25px;">&nbsp;</span></p>', '电子', '', '元器件交易网', '', '2014-05-18'),
	(188, '成都海关便利跨国电子企业', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　新华网成都5月17日电（记者海明威）记者17日从成都海关获悉，成都海关特殊监管区域内进行单耗核销改革，正式开展工单式核销模式。此举能促进企业内部管理水平的提高，节约大量人力资源，英特尔、戴尔等在成都投资的跨国巨头将从中受益。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　据成都海关办公室介绍，近年来，随着海关特殊区域的快速发展，各类IT产品制造业企业和高新技术产业研发中心纷纷入驻特殊区域。传统单耗核销发展遇到的瓶颈，现行加工贸易备案要求较难适应大型电子产品生产企业商品种类繁多、变化快的特点，现行单耗申报方式也难以适应其实际生产管理需求。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　工单式核销模式是手工核销向信息化核销的转变，此项改革在提升海关监管效能的同时促进企业内部管理水平的提高，更好的支持企业发展，让双方节约大量人力资源，实现了企业发展和海关监管效能的双赢，更好地适应现代社会信息化的要求。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　据介绍，目前成都高新综合保税区内已开展或已申请开展工单式核销的企业已有鸿富锦、戴尔、仁宝、英特尔等5家，其中鸿富锦和戴尔已于2013年底完成首次工单式核销试点，效果良好，获得企业好评。下一步，成都海关力争将符合条件的企业全部纳入改革。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　四川是中西部外贸大省，海关最新数据显示，今年前4月，四川实现对外贸易进出口总值1368.2亿元，同比增长5.3%，而同期全国整体进出口下降3.1%。前4月，四川出口以便携电脑、集成电路等为主的机电产品584亿元。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	&nbsp;</p>', '电子', '海明威', '新华网', '', '2014-05-18'),
	(189, '解决电子产品售后服务难', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　如今，手机、PAD、笔记本电脑、数码相机等3C电子产品种类繁多，但相应配套服务机构欠缺，维修市场鱼龙混杂，猫腻颇多。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　李女士是一位白领，她拥有的手机、MP4、PAD出现问题，她要奔波多个厂商售后站进行维修。很多像李女士一样的消费者往往怕麻烦，直接在街边小店维修，这个时候乱收费、偷换零部件甚至&ldquo;越修越坏&rdquo;的情况时有出现。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　针对这些问题，有关方面了解到联想推出多品牌3C服务，基于专业电脑厂商的原厂技术实力，为所有品牌的电脑、手机、pad等电子产品提供软硬件服务、数据安全、选件及升级保养服务。用户可通过电话、网络、上门服务三种方式获得服务。自己开车的李女士知晓后表示：&ldquo;不必再为多品牌产品的售后维修发愁，没想到在乐享3C网站可以找到联想不限品牌的服务，工程师网上远程协助就帮我解决了问题，这样光油钱都能省不少。&rdquo;</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　不难看出，随着电子产品日益走进人们的生活，消费者更需要的是省心、便捷、一站式全能服务。联想多品牌3C服务使所有品牌的用户都能够通过便捷的方式获得优质的服务体验。据悉，5月10日，联想发起全国规模电脑清理日活动，其推出的多品牌服务获得了消费者的广泛认可和欢迎。分析人士表示：&ldquo;联想服务已经不再只是本品牌服务的代表，而是3C产品综合服务的理想选择。&rdquo;</span></p>', '电子', '', '新闻晨报', '', '2014-05-18'),
	(190, '四创电子定增股东1年浮盈逾30%', 'upload/images/1400412299765.gif', '<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	证券时报记者 童璐</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	<a href="http://finance.ifeng.com/app/hq/stock/sh600990/" style="text-decoration: none; color: rgb(0, 66, 118); font-weight: bold;" target="_blank" title="四创电子 600990">四创电子</a>（600990）近日通过网络业绩说明会表示，公司在平安合肥项目建设过程中积累了一定经验，此举有利于公司面向全国建设形成一套可复制的平安城市建设模式。</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	年报显示，四创电子于2013年8月15日与合肥市公安局签订并实施了5.37亿元平安合肥项目。公司根据2013年度发行的5年期国债利率5.41%对平安合肥2013年度合同收入进行折现，并根据完工百分比法确认收入并结转成本，2013年度确认收入1.63亿元。</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	有投资者质疑：&ldquo;平安合肥项目如果按照市场利率核算会亏损，为什么要做？&rdquo;四创电子财务总监韩耀庆对此表示，该项目折现率的选择，主要是基于客户对象以及借鉴已发行资产证券化项目利率做出的预计，该项目折现产出的数额，可以弥补项目实际发生的资金成本。</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	由于四创电子应收账款的主要对象为政府等集团客户，在地方政府债务风险上升的同时，能否顺利回收资金也成为投资者关注的问题之一。韩耀庆回应称，公司应收账款的坏账风险不大，远低于公司已经计提的坏账准备金，其中陕西省人民防空办公室1586万元的应收账款预计今年上半年可以收回。</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	四创电子今年一季度实现营业收入1.43亿元，同比增长65.66%；归属母公司的净利润为-1.8万元，主要系为进一步夯实管理和技术能力，人员投入等加大所致。</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	值得关注的是，尽管公司一季度亏损，但在国防安全、军工概念、通用航空等热门概念的簇拥下，公司股价二级市场遭到热捧。去年5月，四创电子以17.64元/股的价格向汇添富基金、<a href="http://finance.ifeng.com/app/hq/fund/sz174501/" style="text-decoration: none; color: rgb(0, 66, 118); font-weight: bold;" target="_blank" title="广发基金 174501">广发基金</a>等6家机构和1位名为安<a href="http://app.travel.ifeng.com/city_detail_149" style="text-decoration: none; color: rgb(0, 66, 118); font-weight: bold;" target="_blank">桂林</a>的个人投资者定向增发，募集资金投入雷达系列产品产业化扩产等3个项目。由于最终定向增发价格远高于最低14.64元/股的预案发行底价，加之一位名为安桂林的24岁神秘妙龄女子拿出4586.4万元的真金白银参与竞标并获配260万股，四创电子去年定向增发吸引了市场眼球。</p>\r\n<p style="margin: 0px 0px 25px; padding: 0px; text-indent: 28px; font-size: 14px; color: rgb(43, 43, 43); font-family: simsun, arial, helvetica, clean, sans-serif; line-height: 24px;">\r\n	据悉，上述增发的1910.2万股限售股将于5月19日解禁上市，占公司总股本13.97%。依照公司5月16日23.46元/股的收盘价格来计算，安桂林等参与定增的投资者一年内已浮盈32.99%。</p>', '财经', '', '新民网', 'recommend', '2014-05-18'),
	(191, '600570 : 恒生电子2013年度利润分配实施公告', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">600570 恒生电子 2013 年度利润分配实施公告</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　证券代码：600570 证券简称：恒生电子 公告编号：2014-032</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　恒生电子股份有限公司</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　2013 年度利润分配实施公告</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　本公司及董事会全体成员保证公告内容不存在虚假记载、误导性陈述或者重大遗漏，</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　并对其内容的真实、准确和完整承担个别及连带责任。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　重要内容提示：</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　● 扣税前与扣税后每股现金红利</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　扣税前每股现金红利为 0.16 元，扣税后自然人股东和证券投资基金每股现金红利为人民币</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　0.152 元，合格境外机构投资者(&ldquo;QFII&rdquo;)股东每股现金红利为人民币 0.144 元。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　● 股权登记日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　股权登记日 2014 年 5 月 22 日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　● 除权(除息)日：2014 年 5 月 23 日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　● 现金红利发放日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　现金红利发放日 2014 年 5 月 28 日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　一、 通过利润分配方案的股东大会届次和时间</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　《公司 2013 年度利润分配方案》 2014 年 5 月 7 日召开的公司 2013 年年度股东大会审议通过，</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　经</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　《恒生电子 2013 年年度股东大会决议公告》刊登于 2014 年 5 月 8 日《中国证券报》、《上海</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　证券报》、《证券时报》、《证券日报》以及上海证券交易所网站 http://www.sse.com.cn。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　二、 利润分配方案</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(一) 发放年度：2013 年度</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(二) 发放范围：</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　截止 2014 年 5 月 22 日下午上海证券交易所收市后，在中国证券登记结算有限责任公司上海分</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　公司登记在册的公司全体股东。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(三) 本次分配以 617,805,180 股为基数，向全体股东每 10 股派发现金红利 1.6 元(含税)，</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　扣税后每 10 股派发现金红利 1.52 元，共计派发股利 98,848,828.8 元。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(四)扣税说明：</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　1.对于持有公司股份的个人股东和证券投资基金，根据 2012 年 11 月 16 日财政部发布的《关</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　于实施上市公司股息红利差别化个人所得税政策有关问题的通知》(财税[2012]85 号)有关规</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　定，公司暂按 5%的税负代扣代缴个人所得税，实际派发现金红利为每股 0.152 元。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　持股期限(指个人和证券投资基金从公开发行和转让市场取得本公司股票之日至转让交割</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　本公司股票之日前一日的持有时间)在 1 个月以内(含 1 个月)的，其股息红利所得全额计入</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　应纳税所得额，实际税负为 20%；持股期限在 1 个月以上至 1 年(含 1 年)的，实际税负为 10%；</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　持股期限超过 1 年的，实际税负为 5%。个人和证券投资基金转让股票时，中国证券登记结算有</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　限责任公司上海分公司(下称&ldquo;中登上海分公司&rdquo;)将根据其持股期限计算实际应纳税额，超</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　600570 恒生电子 2013 年度利润分配实施公告</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　过已扣缴税款的部分，由证券公司等股份托管机构从个人和证券投资基金资金账户中扣收并划</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　付中登上海分公司，中登上海分公司于次月 5 个工作日内划付公司，本公司在收到税款当月的</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　法定申报期内向主管税务机关申报缴纳。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　2.对于持有本公司股份的合格境外机构投资者(QFII)，公司将根据 2009 年 1 月 23 日国家</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　税务总局颁布的《国家税务总局关于中国居民企业向 QFII 支付股息、红利、利息代扣代缴企</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　业所得税有关问题的通知》(国税函[2009]47 号)的规定，按照扣除 10%所得税后的金额，即</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　按每股 0.144 元派发红利。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　3.对于其他机构投资者，其所得税自行缴纳，实际派发现金红利为每股 0.16 元。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　三、 实施日期</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(一) 股权登记日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　股权登记日 2014 年 5 月 22 日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(二) 除权(除息)日：2014 年 5 月 23 日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　(三) 现金红利发放日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　现金红利发放日 2014 年 5 月 28 日</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　四、 分派对象</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　截止 2014 年 5 月 22 日(A 股股权登记日)下午上海证券交易所收市后，在中国证券登记</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　结算有限责任公司上海分公司登记在册的全体股东。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　五、 分红实施办法</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　1、杭州恒生电子集团有限公司所持本公司股份的红利由公司直接发放。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　2、除上述股东外，其余股东所持本公司股份的红利全部委托中国证券登记结算有限责任公司上</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　海分公司通过其资金清算系统向股权登记日登记在册并在上海证券交易所各会员单位办理了指</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　定交易的股东派发。已办理全面指定交易的 股东可于红利发放日在其指定的证券营业部领取现</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　金红利，未办理指定交易的股东红利暂由中国证券登记结算有限责任公司上海分公司保管，待</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　办理指定交易后再进行派发。</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　六、 有关咨询办法</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　咨询机构：公司董事会办公室</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　联系电话：0571-28829702、28829378</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　联系地址：杭州市江南大道 3588 号 恒生大厦董事会办公室</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　邮政编码：310053</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　七、 备查文件目录</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　公司 2013 年年度股东大会决议</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　恒生电子股份有限公司</span><br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<br style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: Arial, Helvetica, sans-serif, 宋体; font-size: 14px; line-height: 22px;">　　日期：2014 年 5 月 19 日</span></p>', '财经', '', '中金在线', '', '2014-05-18'),
	(192, '中国电子商务研究中心评聚美优品IPO对电商业十大意义', '', '<div class="nr" style="margin-left: 24px; margin-right: 24px; color: rgb(14, 10, 10); font-size: 14px; margin-top: 10px; font-family: 宋体;">\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　(中国电子商务研究中心讯)据中国电子商务研究中心（100EC.CN）获悉，5月16日晚间，聚美优品在纽交所正式挂牌上市，股票代码为&ldquo;JMEI&rdquo;，开盘报价为27.25美元，较发行价22美元上涨23.86%，市值约38.695亿美元。</p>\r\n	<p align="center" style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		<img alt="" height="316" src="http://img1.toocle.com/uppic/a/2014/05/17/f9/e8/f9e83a0789974a9c93b6e02529f5157a-342929.jpg" style="margin: 0px; padding: 0px; border: 0px;" width="480" /></p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　<strong>中国电子商务研究中心主任、研究员<a href="http://www.100ec.cn/detail_man--313.html" style="text-decoration: none;" target="_blank">曹磊</a>认为，聚美优品ipo对电商行业有如下十大意义：</strong></p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　1、中国第一家化妆品电商上市公司；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　2、中国电商17年历史上最快实现ipo的公司(成立仅四年)；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　3、第一家成功实现由团购网站转型B2C并独立发展的公司(其余5000家非死即拼爹，曹叔和他的中国电子商务研究中心的小伙伴们这些年也见证了团购行业的起起伏伏)；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　4、83年的陈欧，成为了纽交所历史上最年轻的中国公司ceo，也是仅次于扎克伯格(29岁上市)的年轻ceo；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　5、2014年意外抢在京东、阿里第一家上市的电商企业；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　6、第一家专注女性<a href="http://www.boogle.cn/" style="text-decoration: none;" target="_blank">网购</a>群体最强做大的上市公司；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　7、更难得可贵的是：第一家上市前就已连续规模性、多年盈利的公司；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　8、融资次数(仅仅A轮)、金额(1600千万美金)均最少的海外上市互联网公司；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　9、依靠陈欧&ldquo;我为自己代言&rdquo;不走寻常营销路，实现用户获取成本最低的电商上市公司；</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　10、首家盈利上市的垂直B2C公司，在垂直电商均普遍唱衰的今天，无意给了很多苦苦挣扎的电商企业和投资机构无疑注入一&ldquo;强心剂&rdquo;。</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　最后，还是个&ldquo;?丝逆袭高富帅&rdquo;依靠自身奋斗，实现&ldquo;中国梦&rdquo;的典范。</p>\r\n	<p style="margin: 20px 0px 0px; padding: 0px; line-height: 22px;">\r\n		　　总之，聚美身上有着太多的光环有待我们思考发掘，电商人、媒体人、投资人、创业者还有我们的政府部门都应该思考。当然聚美后面还有很长的路要走。走好陈欧、走好聚美、走好电商寻梦人。。（文/海沐森）</p>\r\n</div>\r\n<div style="font-family: 宋体; padding-left: 0px; line-height: 25px;">\r\n	<div style="padding-left: 30px;">\r\n		<br />\r\n		<strong>&nbsp;&nbsp;&nbsp; 第一时间获取电商要闻/评论/数据/报告/会议/信息图/实战干货，请关注中国电子商务研究中心微信公众账号：<font color="#990000">i100EC</font></strong></div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '互联网', '中国电子商务研究中心', '中国电子商务研究中心', '', '2014-05-18'),
	(193, '布局互联赢在电商交流会在辛集皮革城举办', 'upload/images/1400413300875.jpg', '<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	&nbsp;慧聪<a class="recommendlinkmode" href="http://www.leather.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">皮革</a>网讯，&ldquo;如果我们今天错过了互联网，我们错过的不是一个机会，而是整整一个时代。&ldquo;，比尔盖茨用这样一句话告诉了我们互联网的重要性。在如今互联网迅速发展的大背景下，每一位<a class="recommendlinkmode" href="http://info.shoes.hc360.com/list/list-qydt.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">企业</a>领袖都需要考虑企业新的生存之道：传统企业如何在业务和产品上升级、转型？如何从互联网浪潮中获得新的发展机遇？企业与企业之间的<a class="recommendlinkmode" href="http://www.shoes.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">合作</a>平台如何搭建？5月18日上午，&ldquo;布局互联赢在电商&rdquo;2014年<a class="recommendlinkmode" href="http://info.shoes.hc360.com/list/glxy.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">电子</a>商务发展趋势交流会在辛集国际<a class="recommendlinkmode" href="http://www.shoes.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">皮革</a>城成功举行。本次活动由<a class="recommendlinkmode" href="http://www.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">慧聪网</a>、中国<a class="recommendlinkmode" href="http://info.shoes.hc360.com/list/info.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">鞋业</a>联盟、中国皮革联盟、辛集国际皮革城联合主办。</p>\r\n<p align="center" style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	<img alt="交流会开幕之前慧聪网邀请的所有企业，买家，经销商大合影  " border="0" src="http://img02.hc360.com/shoes/201405/201405181309278208.jpg" style="margin: 0px; padding: 0px; border: 1px solid rgb(0, 0, 0);" /></p>\r\n<p align="center" style="margin: 10px 0px; padding: 0px; font-family: 宋体; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	交流会开幕之前慧聪网邀请的所有企业，买家，<a class="recommendlinkmode" href="http://info.shoes.hc360.com/list/glxy.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; font-size: 14px; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">经销商</a>大合影</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;交流会在慧聪网培训总监刘佳美老师的&ldquo;十巧手&rdquo;游戏中拉开序幕。十巧手拍拍手，轻松又健康，经营企业同样也需要用健康的双手来开启企业的未来。</p>\r\n<p align="center" style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	<img alt="交流会在十巧手游戏中轻松开幕" border="0" src="http://img02.hc360.com/shoes/201405/201405181310476393.jpg" style="margin: 0px; padding: 0px; border: 1px solid rgb(0, 0, 0);" /></p>\r\n<p align="center" style="margin: 10px 0px; padding: 0px; font-family: 宋体; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	交流会在十巧手游戏中轻松开幕</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;在交流会现场，100多位皮革鞋业买家，经销商齐聚辛集国际皮革城多功能会议室，在轻松健康的游戏后静下心来，围绕&ldquo;电子商务发展趋势&rdquo;的话题，一抒所见、所为、所感。</p>', '互联网', '', '慧聪鞋网', 'recommend', '2014-05-26'),
	(194, '电子行业周报:景气度旺盛,建议积极布局', '', '<p>\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">电子行业景气度旺</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;从各细分行业看,电子行业当前景气度旺盛。半导体产业,景气畅旺,从台湾市场看,第2季多家厂商业绩可望同创历史新高纪录,综合各家看法,智慧手机相关市场是驱动成长的主要动力,智慧手机仍是驱动上下游半导体厂营运成长的主要动力。其中第2季在中东、非洲及拉丁美洲等新兴市场需求强劲带动下,智慧手机出货继续成长。</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;</span><a class="a-tips-Article-QQ" href="http://finance.qq.com/l/industry/xiaofeits08/xiaofei.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166); font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" target="_blank">消费</a><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">电子部分,大陆智能机出货维持较高的增速,我们认为当期可关注</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/NOK.N.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">诺基亚</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">手机供应链。诺基亚手机卷土重来,希望再度挑战</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/AAPL.OQ.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">苹果</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">、三星电子、LG及Sony等国际手机大厂,并抗衡包括中兴、华为、酷派、联想、小米、TCL通讯、天语、金立等快速崛起的大陆手机厂。近期原诺基亚(Nokia)手机部门(将更名</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/MSFT.OQ.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">微软</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">行动;Microsoft&nbsp;Mobile&nbsp;Oy)冲力十足,供应链业者持续接获不少备货订单,使得相关业者出货动能转强。供应链业者透露,近期诺基亚手机大举反攻大陆与新兴国家市场,聚焦最有量能的平价手机市场需求,让产品更具备性价比优势,重新获得消费市场青睐,期望能再度改写全球手机市占版图,近期开始急起直追,2014年将是背水一战。供应链业者认为,未来微软行动与手机供应链业者如何打破既有框架,重新规划产品组合及市场策略,提高产品性价比,以扩大市场规模,备受业界瞩目。</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;LED部分,行业维持景气状态,从上游原材料看,蓝宝石厂产能利用率持续攀升,蓝宝石基板业者看好后续市场表现,相关业者指出,4、5、6月产能保持满载,目前没有悲观的理由。背光、照明市场皆是被看好的应用。</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;投资策略展望</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;我们坚定看好</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/hk/ggcx/00085.htm" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">中国电子</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">产业在全球市场地位持续提升,看好以下领域:</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;我们认为智能领域下一个爆发成长的行业是智能家居,当前处于行业爆发成长初期,长期看好,推荐</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/300183.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">东软载波</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(300183)。</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;国家对集成电路产业扶持将促进国内半导体产业发展,我们最看好集成电路设计产业,从公司规模以及应用领域,我们最为看好</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002049.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">同方国芯</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(002049),</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002371.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">七星电子</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(002371,未评级),</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/300223.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">北京君正</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(300223,未评级)&nbsp;&nbsp;LED背光以及照明仍然具备成长空间,推荐</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/300303.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">聚飞光电</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(300303),</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/600261.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">阳光照明</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(未评级)。&nbsp;&nbsp;新客户订单转移带来业绩成长,看好</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/002475.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">立讯精密</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(002475)和</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/300207.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">欣旺达</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(300207)承接苹果订单。&nbsp;&nbsp;修炼内功,业绩反转类企业,看好</span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/sstock/ggcx/300256.shtml" style="text-decoration: none; outline: none; color: rgb(0, 0, 0); border-bottom-width: 1px; border-bottom-style: dotted; border-bottom-color: rgb(83, 109, 166);" target="_blank">星星科技</a></span><span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">(300256)重组之后成长动力。</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;机构观点</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;市场对LED产业普遍看好,但是对部分LED公司存在分歧,分歧的原因主要在估值,部分公司当前较大的市值是产业分歧的主要原因。此外,消费电子部分,市场期待苹果供应链今年会有一波较大幅度的反弹。</span><br style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;" />\r\n	<span style="font-family: 宋体, Arial, sans-serif; font-size: 16px; line-height: 28px;">&nbsp;&nbsp;&nbsp;&nbsp;风险提示:智能终端短期库存调整压力</span></p>', '财经', '', '浙商证券', '', '2014-05-18'),
	(195, '支持家具行业发展', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　近日,记者从市经信委、市交管局获悉,为支持重庆家具行业发展,市交管局为重庆家具行业协会会员单位符合条件的货车,办理了绿色通行证,深受重庆家具行业协会会员好评。5月22日,市公安局交巡警总队秩序管理支队支队长郭斌代表市交管局,接受重庆家具行业协会赠送的锦旗。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　重庆市公安局交通管理局通告称,自4月1日起,对注册登记地址在主城区(不含北碚区)的三轴以下载货汽车核发货车通行证,通行证分为黄、红、绿(A/B)3种颜色,持证车辆须按照通行证规定的时间、线路进行通行。从5月1日起,正式对违规货车进行处罚。</span><br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(231, 240, 247);">　　由于重庆家具行业协会广大会员单位在主城各大家具卖场均设有门市,这对商家的售前、售中、售后服务影响严重,对消费者接货也造成诸多不便。4月底,重庆家具行业协会负责人就此向重庆市经济和信息化委员会作了汇报,市经信委随即向市公安局交通管理局去函,协调向家协会员企业货车发放绿色通行证一事。截至5月19日,市交管局已为家具行业协会114家会员企业办理了93个货车绿色通行证。</span></p>', '家具', '', '重庆日报', '', '2014-05-26'),
	(196, '我国家具业总产值2015年将超2.4万亿元', 'upload/images/1401102884546.jpg', '<p align="center" class="pictext" style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	家居行业向O2O电商过渡是必然趋势。资料图片</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　来自国家统计部门的数据显示：目前我国家具产能占据全球的25%，我国已成为世界上名副其实的家具制造第一大国。而在1978年，我国家具产业的市场总值不过13亿元。如果按照过去30年平均22.2%的增长率计算，到2015年，我国家具业总产值将达到24300亿元。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　对此，有业界专家预测，我国家具产业必将步入互联网技术兴起的电商时代。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　<strong>　家具企业发力电子商务</strong></p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　专家指出，我国家具产业现阶段已开始步入电商时代。由于家具产品受到大件、耐用和物流等方面的限制，传统家具卖场或经销商&ldquo;触电&rdquo;后的效果参差不齐：号称投资超过3亿元的红星&middot;美凯龙电商平台&ldquo;红美商城&rdquo; 在经历一波困境之后，再度更名&ldquo;星易家&rdquo;继续前行；居然之家、月星家具、金海马等家居卖场&ldquo;触电&rdquo;后也处在&ldquo;摸着石头过河&rdquo;阶段。而与此相对照的是，深谙互联网底蕴的家具电商则异军突起，吸引了穗宝、尚品宅配、顾家、全友等数百家知名家具品牌走上B2B、B2C的营销模式，更有牛窝网、美乐乐等越来越多的专业家具电商品牌前仆后继扎根家居电子商务。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	<strong>　　三四线市场成开拓重点</strong></p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　据了解，随着家具出口受阻，导致越来越多的家具品牌开始转向内销。除了品牌家具的主动转型出击，一些中小家具品牌也更加注重对空白市场的开发。广东顺德家具联盟秘书长张君严曾表示：&ldquo;在目前的中国家具市场，内地市场的发展势头很强劲，在经历了北京、四川等地成功的市场开发之后，政府和协会会带动广东更多的中小家具企业开拓三、四线城市的家具市场。&rdquo;三线城市房地产项目遍布城市的各个角落，楼价较一二线城市低，生活成本相对低廉，城市对高端品牌的消费力还没有释放，是一个增长潜力巨大的市场。</p>\r\n<p style="margin: 0px 0px 29px; padding: 0px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif;">\r\n	　　除了基于生活的创新设计，家具产业重组也正在被网络潮引领，领先的家具制造企业正在通过信息化和高科技，将制造与渠道服务深度整合，并实现组织和管理变革，奠定从制造业向服务业转型的初步基础。例如，掌上明珠引入IBM，联邦引入神州数码。这一波浪潮会在未来5年内进一步推进、扩散，深度改变中国家具品牌制造企业的面貌。</p>', '家具', '阳军', '信息时报', 'recommend', '2014-05-26'),
	(197, '迪高乐家具续签代言人贾静雯', 'upload/images/1401102973062.jpg', '<div class="introduce" style="word-break: break-all; font-family: Verdana, Arial; margin: 10px 15px; padding: 8px 12px; line-height: 25px; font-size: 14px; background-color: rgb(241, 241, 241); color: rgb(51, 51, 51);">\r\n	核心提示：5月24日下午，江苏迪高乐家具有限公司一片喜庆欢腾的景象，国际巨星贾静雯亲临，与迪高乐签下续约两年的战略合作书，并前往展厅，为新一轮形象代言进行广告片拍摄。</div>\r\n<div id="content" style="word-break: break-all; font-family: Verdana, Arial; color: rgb(51, 51, 51);">\r\n	<div class="content" id="article" style="word-break: break-all; font-size: 14px; line-height: 25px; padding: 10px 20px;">\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			5月24日下午，江苏迪高乐家具有限公司一片喜庆欢腾的景象，国际巨星贾静雯亲临，与迪高乐签下续约两年的战略合作书，并前往展厅，为新一轮形象代言进行广告片拍摄。</p>\r\n		<p style="word-break: break-all; text-indent: 2em; text-align: center;">\r\n			&nbsp;</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			签约仪式上，贾静雯一身端庄的红色礼服，成为全场焦点。仪式结束后，贾静雯与特意赶回迪高乐的各地经销商逐一合影留念，亲切、优雅，深受好评。迪高乐董事长贾丰强表示&ldquo;贾静雯温柔贤惠、美丽善良、气质动人，与迪高乐的品牌内涵及企业文化十分吻合，两年来的代言合作特别愉快，更加增进了彼此间的欣赏和认可，因此决定继续合作。&rdquo;</p>\r\n		<p style="word-break: break-all; text-indent: 2em; text-align: center;">\r\n			<img alt="" height="333" src="http://www.szfa.com/file/upload/201405/26/13-45-58-63-1.jpg" style="word-break: break-all; border: none;" width="500" /></p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			围绕&ldquo;乐在家，爱在家&rdquo;的企业核心理念，迪高乐软体家居把自己对居家生活及家居文化的深厚理解融入产品的设计研发中，引进国际顶尖沙发生产工艺，集成各学科和技术，集中了一大批手工技艺精湛的技师，凭借深厚的工艺技术积累、一流的产品设计和严格的品质管理标准赢得了业界的高度认可。在原材料的使用上，迪高乐全部采用国际环保优质材料，以一流的品质来赢得市场的信任。同时，在推出产品之际，迪高乐对终端的支持与服务，也给出了更高的要求。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			迪高乐续签形象代言人贾静雯拉开其2014年新一轮发展战略的序幕。展望未来，迪高乐家具将全面整合资源，优化企业运营效率，向成为一家满怀激情、受人尊敬的一流企业的目标奋力前行</p>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '家具', '李素', '中国家具网', 'recommend', '2014-05-26'),
	(198, '五年磨一剑：办公家具潮流趋势白皮书倾情绽放', 'upload/images/1401103193703.jpg', '<div class="introduce" style="word-break: break-all; font-family: Verdana, Arial; margin: 10px 15px; padding: 8px 12px; line-height: 25px; font-size: 14px; background-color: rgb(241, 241, 241); color: rgb(51, 51, 51);">\r\n	核心提示：2013年是办公家具行业喜忧参半的一年，特别是政策调整给整个行业带来的震动。</div>\r\n<div id="content" style="word-break: break-all; font-family: Verdana, Arial; color: rgb(51, 51, 51);">\r\n	<div class="content" id="article" style="word-break: break-all; font-size: 14px; line-height: 25px; padding: 10px 20px;">\r\n		<p style="word-break: break-all; text-indent: 2em; text-align: center;">\r\n			<strong style="word-break: break-all;">五年磨一剑：办公家具潮流趋势白皮书倾情绽放</strong></p>\r\n		<div style="word-break: break-all; text-align: center;">\r\n			&nbsp;</div>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			2013年是办公家具行业喜忧参半的一年，特别是政策调整给整个行业带来的震动。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			1.&nbsp;楼堂馆所停建，使得关注政府采购的办公家具企业开始担忧未来的业绩。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			2.&nbsp;财政部印发《中央预算单位批量集中采购管理暂行办法》，家具是否被纳入存疑。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			3.&nbsp;城镇化步伐加快，对办公家具的需求显现，未来蕴藏巨大的市场。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			4.&nbsp;随着国内市场崛起，拉动内需的全面展开，企业采购成为办公家具行业新的增长点。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			面临激烈的市场竞争，许多知名企业开始积极思变，推陈出新，甚至做出了革命的抉择。办公家具发展趋势如何？企业如何应对复杂多变的市场环境？每年的广州办公家具展都会成为把脉中国办公家具产业发展的晴雨表。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			在此背景之下，深圳家具研究开发院通过实地市场调研，详实的数据分析，致力于办公家具潮流趋势研究与总结，精炼成《2014办公家具潮流趋势白皮书》、《2014办公家具潮流趋势图集》，并且即将同步发售。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			<strong style="word-break: break-all;">《2014办公家具潮流趋势白皮书》内容先览</strong></p>\r\n		<div style="word-break: break-all; text-align: center;">\r\n			<img alt="" height="637" src="http://www.szfa.com/file/upload/201405/26/09-53-33-37-1.jpg" style="word-break: break-all; border: none;" title="点击打开原图" width="600" /></div>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			某办公品牌全国渠道分布，该品牌虽在全国市场皆有分布，但以江、浙、沪、鲁地区分布最为密集。</p>\r\n		<div style="word-break: break-all; text-align: center;">\r\n			<img alt="" height="378" src="http://www.szfa.com/file/upload/201405/26/09-53-35-20-1.jpg" style="word-break: break-all; border: none;" title="点击打开原图" width="600" /></div>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			该品牌2014年展会新品信息，风格以中式古典、新中式、现代为主，材质以老挝大红酸枝、人造板、密度板为主，而价格分布在6800-52500之间。</p>\r\n		<div style="word-break: break-all; text-align: center;">\r\n			<img alt="" height="372" src="http://www.szfa.com/file/upload/201405/26/09-53-36-61-1.jpg" style="word-break: break-all; border: none;" title="点击打开原图" width="600" /></div>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			各办公家具品牌风格化矩阵图，在风格化分布上，各品牌风格以现代欧式、现代中式、欧式古典、中式古典为主，但在细节表现上又各有千秋。</p>\r\n		<div style="word-break: break-all; text-align: center;">\r\n			<img alt="" height="642" src="http://www.szfa.com/file/upload/201405/26/09-53-36-10-1.jpg" style="word-break: break-all; border: none;" title="点击打开原图" width="600" /></div>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			2014年办公家具用材趋势，在实木和全实木材质中，一些品牌偏好老挝大红酸枝木、鸡翅木、进口红栎木、泰国进口橡胶木等材质。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			以上分析来自中国广州国际家具博览会（办公环境）现场调研以及通过其他数据来源分析所得。更多精彩内容，请阅读《2014办公家具潮流趋势白皮书》。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			未来，办公家具将会如何发展？通过《2014办公家具潮流趋势白皮书》由点到面的全面分析，您一定会了然于胸。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			《2014办公家具潮流趋势白皮书》共257页，售价：4800RMB&nbsp;《2014办公家具潮流趋势图集》售价：1800RMB&nbsp;整套售价：6000RMB</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			设计驱动市场，智慧领航品牌&mdash;&mdash;</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			深圳家具研究开发院成立于2002年，研发中心（DEDE）由国家公派意大利米兰理工大学访问学者、南京林业大学博士生导师许柏鸣教授亲自带队组建。研发中心独立运营12年来，已为国内两百余家家具、家居及产业链上下游企业提供市场专题研究、战略设计、品牌督导、家具产品设计、品牌形象设计、商业空间设计、活动策划及广告平面传播设计等服务。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			咨询热线：400&nbsp;880&nbsp;7260</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			请继续关注家具潮流趋势白皮书微信公众平台，获取更多流行趋势。</p>\r\n		<p style="word-break: break-all; text-indent: 2em;">\r\n			或搜索家具潮流趋势白皮书添加新浪微博关注。</p>\r\n		<p style="word-break: break-all; text-indent: 2em; text-align: center;">\r\n			<img alt="" src="http://www.szfa.com/file/upload/201405/26/09-53-37-27-1.jpg" style="word-break: break-all; border: none;" /></p>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '家具', '佘凤琴', '中国家具网', 'recommend', '2014-05-26'),
	(199, '家居陈设需讲究 让家具与人互动起来', 'upload/images/1401103603515.jpg', '<p align="center" style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	&nbsp;</p>\r\n<div class="mbArticleSharePic    " r="1" style="width: 300px; position: relative; margin: 0px auto; z-index: 1">\r\n	<img alt="好生摆放" src="http://img1.gtimg.com/hb/pics/hv1/174/153/1604/104339289.jpg" style="max-width: 640px; border-top: medium none; border-right: medium none; vertical-align: bottom; border-bottom: medium none; border-left: medium none" /></div>\r\n<p>\r\n	&nbsp;</p>\r\n<p align="center" style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	&nbsp;</p>\r\n<div class="mbArticleSharePic " r="1" style="width: 300px; position: relative; margin: 0px auto; z-index: 1">\r\n	<img alt="好生摆放" src="http://img1.gtimg.com/hb/pics/hv1/172/153/1604/104339287.jpg" style="max-width: 640px; border-top: medium none; border-right: medium none; vertical-align: bottom; border-bottom: medium none; border-left: medium none" /></div>\r\n<p>\r\n	&nbsp;</p>\r\n<p align="center" style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	&nbsp;</p>\r\n<div class="mbArticleSharePic" style="position: relative; margin: 0px auto; z-index: 1">\r\n	<img alt="好生摆放" src="http://img1.gtimg.com/hb/pics/hv1/175/153/1604/104339290.jpg" style="max-width: 640px; border-top: medium none; border-right: medium none; vertical-align: bottom; border-bottom: medium none; border-left: medium none" /></div>\r\n<p>\r\n	&nbsp;</p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	　　在欧阳山的《三家巷》中有过这样一段描述：&ldquo;客厅十分宽敞，南北两边是全套酸枝公座椅，当中摆着云石桌子、云石凳子。东面靠墙正中是一个玻璃柜子，里面陈设着碧玉、玛瑙、珊瑚、怪石种种玩器；柜子两旁是书架，架上放着笔记、小说、诗文集子之类的古书。&rdquo;从描述中不难看出，家具的摆放、陈设是生活习惯使然，更与主人气性一脉相承。</p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	<strong>　　有空间透视感的客厅最是酣畅</strong></p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	　　客厅是会客聊天、谈心饮茶的区域，舒畅和自在的生活需求，要求客厅尽量宽敞。因此，沙发、茶几和视听设备应尽量简单大方，榻榻米、小茶几、边柜等则尽量以点缀的方式进行呈现。沙发的布置分为三种，包括面对型、L型和U型。面对型的摆放适用于小卧室，长条沙发要与电视柜等长或者更长。L型的布置，如果你喜欢更加自由的沙发组合，不妨使用脚踏或者舒适的高靠背老虎椅来代替灵活度差的贵妃位。U型则相对需要比较宽敞的空间，并在至少一侧需要方几来进行搭配，否则会显得不够稳重。</p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	<strong>　　需要留足50cm过道空间给餐厅</strong></p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	　　在实际的居家生活中，普通的两口或者三口之家很少用到餐桌，只有亲朋好友到访时才会认真将餐桌纳入视线范围之内。因此，购买组合家具或者折叠家具无疑会让餐厅显得干净清爽，也为餐边柜的&ldquo;跻身&rdquo;留出了足够的空间。尤其是对餐厅过于狭长或者影响了过道通畅度的空间，这样的摆设不失温馨也十分实用，摆放时记得给餐椅背后留足50cm的过道空间，以免就餐尴尬。</p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	<strong>　　把零碎&ldquo;吞进&rdquo;柜体 只剩妖娆</strong></p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	　　家里所有的物件都暴露在人们的视野中，难免会造成空间拥挤且杂乱无章的感觉。但如今，顶天立地的厅柜设计并不像以前那么&ldquo;讨喜&rdquo;，占据整面墙的压抑感已经超过了收纳带来的愉悦感。走访西部家具城时记者发现，不少个性收纳柜、斗柜、厅柜争奇斗艳，&ldquo;大肚能容&rdquo;的同时本身也是一道靓丽风景。</p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	　　比如，欧式典雅边柜清新淡雅凸显高贵气质；实木五斗柜整洁自然，带着原始肌理的美感；极具明亮色彩的收纳柜，放在玄关处具有独特的个人风格。如果你喜欢开放式的收纳，那一定要对展示的单品精挑细选，水晶、彩陶、莲蓬头、富贵鱼饰等具有装饰性的饰品都是不错的选择。</p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	<strong>　　让&ldquo;和谐&rdquo;之气在家中风生水起</strong></p>\r\n<p style="font-size: 16px; font-family: 宋体, Arial, sans-serif; padding-bottom: 0px; padding-top: 0px; padding-left: 0px; margin: 0px 0px 29px; line-height: 28px; padding-right: 0px">\r\n	　　在堪舆学中，&ldquo;鞋&rdquo;与&ldquo;谐&rdquo;同音，古代被看作是喻意着和谐、进步的吉祥物。成双成对的鞋堆放在一起时所表现出来的形态，寓意家庭生活的和谐程度及全家人出门谋生的运势。有的家庭把鞋柜设在大门之外，有把&ldquo;和谐&rdquo;挡在门外的寓意，不妨将其摆放在玄关之下，既美观又实用。总的来说，鞋柜的选择和摆放原则是&ldquo;宜小不宜大，宜矮不宜高&rdquo;，高最好不要超过楼层高度的1/3，宽度不宜超过成人双手伸直的长度。</p>', '家具', '张莉 奚淼', '西安晚报', 'recommend', '2014-05-28'),
	(200, '南康家具：如何打造千亿产业集群', 'upload/images/1401103773953.jpg', '<p align="center" style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	<span style="color: rgb(0, 0, 255);">家具文化从学生抓起。杨晓明摄</span></p>\r\n<p align="center" style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	<img src="http://green.workercn.cn/html/files/2014-05/26/20140526075305891789425.jpg" style="margin: 0px; padding: 0px; border: 0px none;" /></p>\r\n<p align="center" style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	<font color="#0000ff" style="margin: 0px; padding: 0px;">赣州市南康区一瞥。杨晓明摄</font></p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　仲春时节，赣南大地，郁郁葱葱，生机盎然。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　中国（赣州）第一届家具产业博览会即将召开之际，&ldquo;中国中部家具产业基地&rdquo;&ldquo;全国实木家具知名品牌创建示范区&rdquo;赣州市南康区好消息接踵而至。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　经过20多年的长足发展，南康家具企业目前达6000余家，国内销售网点超6000个，产品出口到10多个国家和地区，仅2013年总产值近450亿元，带动直接就业人口30多万人。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　&ldquo;南康家具产业，从无中生有，从小到大，从大到强，以《国务院关于支持赣南等原中央苏区振兴发展的若干意见》出台为契机，迎来了跨越式大发展的春天。&rdquo;南康区委书记徐兵说。</p>\r\n<p align="center" style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	<strong style="margin: 0px; padding: 0px;">　　自然资源贫乏，产业无中生有</strong></p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　南康自然资源贫乏，&ldquo;地下没矿，山上没林，田里没水，人守三分地&rdquo;，交通和区位优势亦不明显，家具产业几乎无中生有！</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　南康家具产业的基因，似乎可以追溯到秦朝10万被发配到赣南采木的&ldquo;木客&rdquo;，他们正是南康客家人敬畏的始祖。在南康人的血液中，&ldquo;客&rdquo;意味着&ldquo;穷则思变&rdquo;和&ldquo;精通百艺&rdquo;的客家精神；&ldquo;木匠&rdquo;是客家人谋生的行当，集技术与艺术为一体的手艺而世代传承。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　特别是上世纪80年代，在改革开放春风吹拂下，约有15万南康木匠到珠江三角洲打工，不仅帮助他们完成资金的原始积累，更开阔了视野，学习先进的技术、经营、管理、销售经验和理念。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　1993年，一个叫林永红的木匠回到南康，盖了间简易的木板厂房，南康第一家家具厂就这样诞生了。当年他赚了20万元。第二年，南康家具厂达到200多家。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　靠着精湛的木工手艺和客家人的勤奋求知，许多像林永红一样的打工仔后来成长为南康著名的企业家，例如：蓝天木业有限公司董事长刘学春，18岁时，他常常从早上7时工作到深夜，一干就是3年；文华家瑞家具实业有限公司董事长吴述文，22岁时，他南下深圳干起了家具学徒及家居装修，就这样干了5年；昭玺家具有限公司总经理曾昭玺，17岁时，他锯了些木料到广东贩卖，从此开始了11年的打工历程&hellip;&hellip;</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　政府因势利导，对产业的发展予以引导，1997年《南康市家具产业发展五年规划》出台，通过投资、政策导向等方式，推动家具产业的发展壮大，在东山镇建设家具产业园。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　经过初期的快速发展，南康家具产业&ldquo;散、乱、小&rdquo;的问题在本世纪初也逐渐暴露：部分企业只重生产，不重研发、营销和管理，小富即安思想严重。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　本世纪初开始，随着市场竞争加剧，&ldquo;草根产业&rdquo;多年隐藏的弊端显露出来。由于品种单一、技术含量低、产品附加值低，这个&ldquo;泡沫&rdquo;在2002年被引爆：一些企业在生产实木家具时缺少重要的烘干工序，导致产品变形，致使整个南康家具业都遭遇危机。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　政府引导起到重要作用。改变过去几十道工序由一家完成的做法，形成家具产业的专业化分工，降低生产成本，打造一条龙的产业链，开始严控家具生产企业准入条件，规划了五大家具生产区，要求企业往园区聚集。对实力较强的企业，政府则通过降低税负、协助贷款、注册商标、校企研发等措施，帮助企业打造品牌。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　&ldquo;最关键的是要对南康家具产业进行重新整合，实现规范集约发展。&rdquo;当地一位领导如是说。2009年，南康专门成立了家具产业促进局，遴选、整合出30家企业重点培育。为此，南康实行了&ldquo;一个企业一个政策&rdquo;和&ldquo;一个领导、一个区直单位、一家银行&rdquo;的帮扶制度，引导企业摆脱恶性竞争，实现良性循环。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　在此过程中，原有的家族式管理、农民式粗放经营模式逐渐成为掣肘。通过开办经营管理培训班，资助企业家读MBA，政府给老板们&ldquo;洗脑&rdquo;，使他们意识到管理经营人才的重要性。目前，南康主动攻读知名高校MBA的家具老板达360多人。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　江西木牛家具有限公司副总经理刘烈萌，被称为南康家具企业第一个&ldquo;职业经理人&rdquo;。&ldquo;从广东带来的现代企业管理制度和大批开发设计人才，成了南康家具实现振兴的关键。&rdquo;木牛家具总裁廖为敏对于自己当年的决定颇为满意。</p>\r\n<p align="center" style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	<strong style="margin: 0px; padding: 0px;">　　用活两个市场、两种资源</strong></p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　从缅甸花梨、马达加斯加紫檀到老挝大红酸枝、非洲的乌金木和虎斑木、俄罗斯的榆木、北美的胡桃木、欧洲的榉木，再到国内河南、新疆的杨木，广西、贵州、湖南的椿木、桦木&hellip;&hellip;在南康佳兴国际家具材料中心，聚集了世界上28个国家和国内多个省份的近30种木材。为了从源头上保证木材供应，很多企业甚至直接到非洲买山。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　2013年，南康木材进口量占到木材消费量的八成，达285万立方米，其中80%以上为进口高档木材。&ldquo;进口高档木材的普遍使用，不仅提高了南康家具的品质和档次，更改善了产品形象，保护了资源和环境。&rdquo;南康区副区长钟旭辉说。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　曾昭玺是南康家具&ldquo;走出去&rdquo;的代表之一。2006年，昭玺公司开始和一个马来西亚客户合作。这个客户要求非常严格，不仅制定了严格工序标准，还派了一个技术员常驻厂里。当时，有的师傅抱怨，&ldquo;又不是造飞机，搞得这么严格&rdquo;；但曾昭玺只有一个要求&mdash;&mdash;磨合，再磨合。两年后，客户不仅撤走了技术员，而且对其公司新研发的赣南风格产品，也是直接交货就行。如今，昭玺家具远销香港、马来西亚等十几个国家和地区，外销占公司销售70%以上。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　而整个南康家具，不仅在国内布下6000余家销售网点，600多条物流线路，更将出口触角伸向了世界几十个国家。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　南康人消化吸收了国内外先进原料和技术，用活了国际国内两个市场、两种资源，用世界的木材，做世界的品牌家具，真正做到了&ldquo;买自全球，卖向全球&rdquo;。</p>\r\n<p align="center" style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	<strong style="margin: 0px; padding: 0px;">　　转型升级，打造千亿家具产业群</strong></p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　2012年6月《国务院关于支持赣南等原中央苏区振兴发展的若干意见》出台，明确支持南康家具产业基地建设，支持建设国家级检验检测技术研发服务平台。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　&ldquo;2016年，要将南康家具打造为千亿产业集群；2020年，南康要成为中高端实木家具生产基地。&rdquo;根据《南康家具转型升级规划》，南康早已对未来有了清晰的目标。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　两年时间，产值由450亿元达到1000亿元，南康人的信心来源于政府不断打造家具公共服务平台，推动产业实现转型升级。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　赣州市南康区维平家具公司的车间里，一条由意大利引进的机器人油漆喷涂线正在作业，手臂快速进行着3D扫描，立体自动喷涂油漆，一分钟不到，油漆干燥完成。这条机器人喷涂线是目前国内仅有的三条之一。&ldquo;油漆的回收利用率能达到90%以上。&rdquo;维平创业家具实业有限公司营销副总监刘斌强说。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　南康家具产业园里的喷涂、检测、烘干三大中心，成为政府推进转型升级的头等大事。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　在9.4万平方米喷涂中心，3D扫描喷涂机械手、油漆自动回收、紫外线照射干燥等家具自动化喷涂一体化服务项目，将实现家具喷涂集中、节约、环保、节能效益。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　规划占地50亩的国家家具产品质量监督检测中心，将实现家具、人造板及木材三大类100多个产品500多个参数的检验能力，每年可为企业提供10万批次的检验服务。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　&ldquo;通过打造公共技术研发服务平台，企业不仅节省了检测设备和实验室建设资金，还让它们在聚合中开展公共技术研究及新产品研发，让这里的空气都弥漫创新的味道。&rdquo;南康区家具产业促进局局长蔡湖南说。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　烘干中心规划兴建的木材加工干燥中心、木材干燥窑等，将实现木材锯解、干燥及脱脂、防腐、阻燃等处理工艺。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　今天的南康则要不断延长产业链。大批企业开始主动引进研发设计人才，加强与专业机构合作，建立企业研发中心，政府推动建立起家具科技研究院，从两个层面汇聚自主品牌建设智慧，给家具贴上&ldquo;南康创造&rdquo;的标签。物流仓储、五金配件、油漆化工、木材交易、电子商务等配套产业茁壮成长，为企业产品制造、品牌营销插上腾飞翅膀。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　国家级进境木材检验检疫监管区、质检中心、木材烘干中心、研发培训中心、电子商务中心、金融商务中心&hellip;&hellip;南康加强了家具产业的分工合作，让企业专注于研发和生产。</p>\r\n<p style="margin: 0px; padding: 5px 0px; color: rgb(3, 0, 0); font-family: 宋体; font-size: 14px; line-height: 26px;">\r\n	　　&ldquo;政府完善市场环境，企业担当创新主体，我们相信，随着南康家具产业基地建设升格为国家级，南康家具品牌一定能走向全国，畅销全球。&rdquo;南康区长何善锦信心百倍。</p>', '家具', '', '人民日报', 'recommend', '2014-05-26'),
	(201, '刘利刚：中国房地产市场处于周期性调整阶段', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　</span><a href="http://q.stock.sohu.com/cn/601519/index.shtml" style="border: 0px; margin: 0px; padding: 0px; font-size: 14px; color: rgb(0, 85, 153); text-decoration: none; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;" target="_blank">大智慧</a><span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">阿思达克通讯社5月26日讯，澳新银行大中华首席经济师刘利刚周一（26日）表示，中国的房地产市场并没有进入一个历史的拐点，而是正在进入一个周期性的调整，这种调整跟中国经济结构的整体调整有一定的关系，因为未来消费占GDP比重将上升，而投资占GDP比重必须下&nbsp;</span></p>\r\n<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">来。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　刘利刚并指出，根据国务院发展研究中心的预测，中国到2023年城市人口将会达到9.2万亿，这意味着城市人口的逐渐增加将创造更多的需求，与此同时，当前中国39个城市有限购的状况，等于说需求在某种方面已经被限制，如果这样的房地产调控政策在中西部的城市可以逐渐放松，需求就会被释放出来，现在房地产的价格下跌也会得到抑制。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　同时，刘利刚认为，&ldquo;上海的房价并不是一个很大的泡沫，虽然它已经跟它的均衡价格有一定的脱离，它是不是会进入日本那样的状况，在短短的一两年当中它的价格飞速上升，这是我们要担心的。&rdquo;</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　刘利刚进一步解释称，&ldquo;中国货币政策的一致性将会决定中国房价是不是在今后一段时间将会进入一个大的泡沫的状况。从另外一个宏观的角度，如果说资本还在向中国流入，在这种状况下我们很难想象我们的房地产市场有一个很大的价格的调整。&rdquo;</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　发稿：宁萱/古美仪 审校：丁亮</span></p>', '房地产', '', '大智慧阿思达克通讯社', '', '2014-05-26'),
	(202, '经济学家：房地产下行带来固定资产投资减少超万亿', 'upload/images/1401105271750.jpg', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　国际货币基金组织（IMF）经济学家Loungani在2010年曾经分析了OECD 国家住房价格波动的周期规律。在1970到1990年代中期，房价上升了4年，上升幅度是33%。然后下降了4年，下跌幅度是20%。因此住宅价格的动态规律是周期性的，而不是趋势性的。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　在Loungani后来2012发表的结果中显示（更大的国家样本，以季度为计量单位）：</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	&nbsp;</p>\r\n<div align="center" style="border: 0px; margin: 0px; padding: 0px; font-size: 14px; color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	<table align="center" style="border-collapse: collapse; border-spacing: 0px; margin: 0px auto;">\r\n		<tbody>\r\n			<tr>\r\n				<td style="vertical-align: top;">\r\n					<div align="center" style="border: 0px; margin: 0px; padding: 0px;">\r\n						<div class="conserve-precommendo" desc="" picurl="http://precommendocdn.sohu.com/20140526/Img400046844.jpg" style="border: 0px; margin: 0px; padding: 0px; width: 105px; height: 29px; background-image: url(http://news.sohu.com/upload/article/2012/images/saveBtn.png); cursor: pointer; position: absolute; right: 20px; border-top-left-radius: 3px; border-top-right-radius: 3px; border-bottom-right-radius: 3px; border-bottom-left-radius: 3px; top: 706px; left: 592.5px; background-repeat: no-repeat no-repeat;">\r\n							<div class="comCount" style="border: 0px; margin: 0px; padding: 0px; font-size: 11px; width: 76px; height: 12px; position: absolute; top: 18px; right: 0px; line-height: 12px; font-family: 宋体; color: white;">\r\n								2</div>\r\n						</div>\r\n					</div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　过去的周期上涨20个季度，20个季度相当于五年，上涨幅度48%，然后下降了18个季度，下降幅度23%，不完全对称。按他们的统计，在目前这个住宅周期中，全球上升的周期是38个季度，9年，上涨幅度126%，现在已经下降了15个季度，下降了19%，所以全球的周期还没有下降完，还会有相当长的时间。这个周期现象中国不会例外。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　钟伟为CF40所做宏观报告认为：房地产对投资和就业的影响非常大。首先，房地产的投资包括三部分，在建、新增、土地购置。在建和新增对资本形成的影响特别大。从新增规模来看，按今年一季度的开工情况，今年全年新开工规模大概只有12-15亿平米，销售面积大概在10亿平米左右。房地产总投资大概会增长10%，但是边际投资却会减少7000-8000亿。其次，低端劳动力就业与房地产的关系特别密切。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　房地产有两个方面可以吸收大量的就业，一是建筑施工，2013年建筑施工企业就集中了4500万人就业；二是房地产开发和物业管理，大概可以集中1000-1200万人就业。土地市场的萎缩情况比房地产新开工面积和销售下降的幅度会更大。去年房地产相关的土地出让收入4.1万亿，与房地产相关的税费，包括土地增值、农村耕地占用、城镇土地使用等约1.2万亿。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　总体来讲，去年地方政府土地的收益大约5.2-5.4万亿，而去年地方政府全部的财政收入才只有6.9万亿。关于房地产下行所引发的金融风险，最大的风险可能并不在银行部门，银行部门具体涉及到的房地产贷款是5万亿的开发贷和9万亿的按揭贷款，这部分基本上是安全的。最大的风险是地方财政的问题。在未来两个季度如果没有政策扶持的话，房地产加速下行带来固定资产投资减少的边际投资量超过1万亿人民币，目前已经出台的微刺激政策(棚户区改造，增加铁路投资，小微企业税收优惠)总和增加的投资不足4000亿元。力度不足以抵消房地产下行对经济的负面影响。（本文作者任若恩系经济学博士，北京航空航天大学教授）</span></p>', '房地产', '任若恩系', '财经网', 'recommend', '2014-05-26'),
	(203, '宋卫平：房地产市场已面目全非 我愤怒了', '', '<p class="titdd-Article" style="margin: -20px 0px 12px; padding: 12px 18px 10px; font-size: 14px; line-height: 28px; background-color: rgb(243, 243, 243); font-family: 宋体, Arial, sans-serif;">\r\n	[<strong style="margin: 0px; padding: 0px;">导读</strong>]在房地产业内已持续发酵达一个多月之后，融创中国（01918.HK）与绿城中国（03900.HK）的热恋终于有了结果。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	在房地产业内已持续发酵达一个多月之后，融创中国（01918.HK）与绿城中国（03900.HK）的热恋终于有了结果。5月22日晚间，融创中国发布公告称，已成功收购绿城524851793股，占已发行股本的24.313%，与九龙仓（00004.HK）并列绿城中国的第一大股东。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	据两家公司发布的公告显示，融创以62.98亿港元购买绿城24.313%的股份，每股相当于12港元。这部分股份来自于三人，分别是绿城中国董事长宋卫平出售11.398%，股东夏一波出售3.190%，绿城中国执行董事兼行政总裁寿柏年出售9.725%。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	在完成此次收购后，融创中国将与绿城原大股东九龙仓并列为绿城中国的最大股东；宋卫平与寿柏年分别剩余股份10.473%和8.086%，但作为一致行动人，二人成为绿城中国的第三大股东。从2015年3月1日起，宋卫平将改任董事会名誉主席，孙宏斌任董事会主席。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	九龙仓作为并列第一大股东，昨日并没有出席在杭州的新闻发布会。但是，寿柏年在现场宣读了一份来自九龙仓的通告发言，九龙仓常务副主席吴天爱在通告发言中称，&ldquo;将继续支持宋卫平选定的接班人的工作。&rdquo;</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	在昨日的新闻发布会上，宋卫平和孙宏斌分别表示，今后九龙仓的职能大多是行使&ldquo;否决权&rdquo;以及&ldquo;等着领钱&rdquo;。其言外之意似乎就是&ldquo;整个绿城将以孙宏斌为代表的融创团队负责&rdquo;。尽管绿城还是绿城，但显然已不再是宋卫平的绿城。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	在上市公司资产易主后，绿城的非上市资产怎么处理依然是业界关注焦点。对此，宋卫平表示，在房地产开发这个领域，以后只有&ldquo;绿城中国&rdquo;这个品牌上市公司可以使用；其他服务类资产里面，例如物业、教育、足球、医院等，都能继续使用&ldquo;绿城&rdquo;的品牌，但养老这块有时候会以养老地产的形态出现，为了避免出现纠葛，所以就用了一个新的品牌&ldquo;蓝城&rdquo;。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	宋卫平：不想再玩下去了</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：为什么要卖掉绿城的股份？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	宋卫平：我对未来的房地产市场十分悲观。在经历了2005年、2008年及2011年的调控之后，当前的房地产市场已经不是一个正常的市场，而是一个非常扭曲的市场，基本上是面目全非。但有些企业是具备超能力的，我们需要这样的企业继续带领绿城走下去，这个因素应该占到30%。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：那剩下的70%因素是什么？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	宋卫平：剩下的70%是一个综合的考量。首先，有舍才有得，有些东西必须得舍下，才能有所得。其二，我们终究是要退休的。其三，我有一些愤怒了，不想再玩下去了。当前的一些市场调控政策真的非常糟糕，为什么土地拍卖要设置最高溢价率？为什么非要配建保障房？保障房到底卖给谁？我不愿意再跟这些人继续玩下去了。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：为什么是融创而不是别人？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	宋卫平：跟老孙（孙宏斌）和融创的合作过程中，他们的理解和信任是超越一般的商业合作伙伴的。我们已经变成既是商业上的合作伙伴，又是一起做事的朋友。有这样的一份情谊在里面，所以我们才会在众多被证明可以掌控一个大的房地产公司的团队里面、领袖人物里面，选择了融创，选择了老孙。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：如果融创和九龙仓产生矛盾，你会帮谁？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	宋卫平：不管是名誉董事长，还是联席董事长，我还是绿城的股东，我只会赞同一些对客户负责任、对员工负责任、对社会负责任的一方，不管他是融创还是九龙仓，只要靠谱，我就会支持。如果说万一出现难以协调的矛盾，那当然是要以股份作为管控的最主要依据。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	晨报记者 孙春祥</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	孙宏斌：收购绿城很便宜</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：按照当前绿城的股价，此次收购价的溢价率较高，为什么？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	孙宏斌：我们在定收购价格的时候，基本上没有怎么看股价，因为是按净资产来算的。按照我们的收购价格，事实上是在净资产价格的基础上还打了一个13%的折扣。如果看账面净资产的话，绿城所有土地都是按照原价给我们的，都还是十年前或五年前的价格。如果是按照股价来说，那只能说股价太低了。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：你如何看待未来的房地产业？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	孙宏斌：对于市场生态，我一直是挺悲观的。大家都知道，因为经济下行压力很大，产能过剩是各个行业都有的。地方债事实上不是问题，左口袋转右口袋倒腾一下就可以了，而产能过剩问题却是各个行业的，房地产也是一样，目前三四线城市供应量太大。但我觉得，最近政府的政策有好转迹象，我对政府还是有信心的，相信会改掉一些很荒唐的政策。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：融创和绿城今后如何避免同业竞争？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	孙宏斌：我们目前达成的一个基本原则是，融创和绿城在各自的优势区域各自发展。比如说，在浙江我们融创肯定会退出，山东也不会再做了；融创主打的天津、重庆，绿城也不一定会去了。第二个原则是，在一线城市，我们都合起来做，比如在上海、北京。第三个原则，在深圳、广州、厦门等这些南方城市都以绿城为主，我们可能入一点股份。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	记者：今后还会继续支持绿城中超球队吗？</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	孙宏斌：我不太喜欢足球，也不太看足球。但在这次和九龙仓的协商中，我们达成的共识是，至少目前还会跟之前一样，一如既往地支持。要不要增加投入还要继续商量，但肯定不会减少，因为这对绿城的品牌、知名度等各方面都有特别多的好处。</p>', '房地产', '', '北京晨报', '', '2014-05-26'),
	(204, '太原房地产新开工面积负增长', '', '<p class="titdd-Article" style="margin: -20px 0px 12px; padding: 12px 18px 10px; font-size: 14px; line-height: 28px; background-color: rgb(243, 243, 243); font-family: 宋体, Arial, sans-serif;">\r\n	[<strong style="margin: 0px; padding: 0px;">导读</strong>]省统计局发布最新数据显示，我市房地产施工面积、销售面积、新开工面积出现不同程度回落。其中新开工面积呈负增长。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	省统计局发布最新数据显示，我市房地产施工面积、销售面积、新开工面积出现不同程度回落。其中新开工面积呈负增长。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	数据显示，一季度，我市房地产开发施工面积和销售面积呈回落态势，新开工面积呈负增长。施工面积 3916.91万平方米，增长11.7%，增速比上年同期回落15.4%；销售面积53.51万平方米，增长18.8%，增速比上年同期回落27.1%；新开工面积46.50万平方米，下降35.0%，降幅比上年同期收窄5.2%。</p>\r\n<p style="margin: 0px; padding: 0px 0px 29px; font-size: 16px; line-height: 28px; font-family: 宋体, Arial, sans-serif; text-indent: 2em;">\r\n	房地产开发投资是占全市投资比重最高的行业之一，但从其走势和相关指标变动情况看，房地产开发行业在银行惜贷，不动产登记制度挤压投机性购房等因素的作用下，市场观望气氛浓厚，全年运行趋势很不明朗。省统计局相关人士称，作为全市投资的重要组成部分，相关部门应予以足够重视，积极做好预案，以及时弥补其出现回落时产生的缺口。</p>', '房地产', '', '太原新闻网', '', '2014-05-26'),
	(205, '程实：中国房地产市场趋冷的全球动因', '', '<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　中国不仅是中国的中国，也是全球的中国。如果一种经济现象不仅是中国所独有，那么，寻找全球动因就是理解趋势变化的重要一环。近来，中国房市趋冷引发市场热议，2014年前4个月，中国<a href="http://q.stock.sohu.com/cn/bk_22.shtml" style="border: 0px; margin: 0px; padding: 0px; color: rgb(0, 85, 153); text-decoration: none;" target="_blank">房地产</a>销售面积同比下降6.9%，商品房销售价格同比下降0.9%，市场人士总结了一系列内因来解释房市变化，并由此形成对未来走势的判断，目前来看，看多、看平和看空者各执一词，难言高下。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　笔者以为，市场一直忽视了一点，那就是：房市趋冷是一种全球现象。2014年2月，美国标准普尔20个大中城市房价环比下跌0.03%，已经是连续第4个月环比负增长；2014年4月，日本东京圈和近畿圈新屋销售均价分别环比下跌3.7%和3.16%，后者连续第三个月环比下跌；2013年第四季度，欧元区和欧盟房价指数分别环比下跌0.7%和0.3%，均结束了前两个季度连续环比正增长的态势。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　全球现象，必有全球动因。忽略每一个个体的独特性，能够从全局层面解释全球房市趋冷的原因有四：其一，全球经济复苏遭遇&ldquo;低收入增长&rdquo;的挑战。虽然全球各地的数据口径、数据频率和更新状况不尽相同，但利用截至目前可获得的各种数据进行测算，数据趋势却惊人地相似，无论是发达国家和新兴市场国家，都呈现出复苏后半程（2013年至今）比前半程（2010-2012年）收入增长明显趋缓的状况，部分国家的居民实际收入甚至出现了负增长。全局性的收入增长放缓削弱了全球购房者的购买力，导致房市承压。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　其二，全球货币政策呈现出&ldquo;相对趋紧&rdquo;的共同特征。虽然各主要经济体货币政策状态截然不同，美国正在有序退出QE，欧洲央行还在考虑负利率，日本再通胀也从未松力，但相对于其各自经济复苏态势而言，各主要央行的政策选择都显得有些偏紧，或者说，宽松力度相对不够。从各主要经济体2014年第一季度羸弱的经济表现，以及近来主要央行宽松倾向均有所增强的态势来看，货币政策相对趋紧是存在的，而且已经借由利率和预期渠道给房市带来了压力，美国房市就是最直观的例子。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　其三，全球风险偏好出现普遍提升的态势。从复苏历程来看，2014年是一个特殊的年份，这一年，复苏中的&ldquo;不平等问题&rdquo;骤然凸显，宏观层面表现为国别分化持续深化，微观层面则表现为两极分化风险大幅上升，IMF在2014年经济展望中就首次强调了这一点。此外，2014年又是危机以来地缘政治风险最为突出的一年，年初以来，乌克兰乱局、泰国军事政变和恐怖主义事件接踵而至，引发市场高度担忧。在社会矛盾和政治动荡加剧的背景下，全球风险偏好普遍下降，给包括房市在内的资产市场带来了压力。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　其四，全球房市基本面支撑力度不足。根据世界银行2014年发布的数据，2012年全球65岁以上人口占总人口的比例为7.83%，较危机前上升了0.43个百分点，老龄化已经变成全球现象，2012年，高收入国家、中等收入国家和低收入国家65岁以上人口占比就分别较危机前上升了0.72、0.2和0.15个百分点。此外，2012年，全球城市化率为52.55%，0.47个百分点的上升幅度为2001年以来最低，表明全球城市化的推进正进入一个边际动能递减的阶段。加速的老龄化和放缓的城市化，共同给全球房市基本面带来长期性的抑制作用。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　值得强调的是，虽然房市趋冷是一种全球现象，且能找到具有一定解释力的全球动因，但全局性差异也是存在的。主要体现在三个方面：首先，各经济体房市所处的周期位置大不相同，例如，美国房市可能处于长周期复苏的短期调整阶段，欧洲房市可能处于长期周期调整的寻底阶段，中国房市之前处于长周期繁荣阶段，现在是处于长周期拐点还是短周期回调点，很难判断。不同性质长周期中的房市，短期变化的持久性和深度也会迥然有异。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　其次，各经济体房市的风险状况不尽相同。从房屋空置率、房贷负担率、抵押贷款赎回权丧失率等角度看，美国房市处于结构改善的过程之中，而另一些地区的房市调整显然尚未伴随着相称的风险释放。可以推测，后一种地区的房市调整如果得到趋势确认，力度相比美国可能会更加激烈。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　最后，全球资本流动的影响可能不太一样。虽然在风险偏好降低的背景下，全局性资本流入处于下降态势，但全球资本的结构性流动还是会给不同经济体带来不同影响，面临较大资本流出压力的新兴市场房市，压力会更大一些。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	　　总之，房市趋冷是一种全球现象，从全球看中国，内因的变化未必能带来预期中的房市影响，只有将全球动因和全球差异考虑进去，才能看得更加清晰。</p>\r\n<p style="border: 0px; margin: 0px; padding: 26px 0px 0px; font-size: 14px; font-family: 宋体, simsun, sans-serif, Arial; line-height: 26px;">\r\n	<img align="middle" alt="" class="flag_bigP" src="http://precommendocdn.sohu.com/20140526/Img400027458.jpg" style="border: 0px; margin: 0px auto; padding: 0px; font-size: 0px; color: transparent; display: block; text-align: center;" /></p>\r\n<div>\r\n	&nbsp;</div>', '房地产', '', '搜狐证券', '', '2014-05-26'),
	(206, '房地产市场出现新的分化', '', '<p>\r\n	<span style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;">　　日前住建部兵分几路密集调研地方楼市,实地了解房地产市场下滑程度。住建部调研结果显示,部分中心城市表现仍不错,目前对经济冲击并不大,但市场开始出现新的分化。三四线城市的情况要好于杭州、贵阳、沈阳等二线城市。</span><br style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;" />\r\n	<br style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;" />\r\n	<span style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;">　　平安证券认为，在房地产趋势性下行的背景下,各地放松限购限贷的呼声也越来越高。取消限购限贷本身是对过往不合理政策的回归,本来就不存在新一轮的救市,中央希望的是房地产市场积极调整,而不是等待救市,北上广深的限购限贷政策的退出可能是最慢的,但并不代表这一政策还将全面的持续下去,房地产政策正在从需求端的过于紧缩走向正常。但这些变化,不会改变房地产市场开始高位趋于下行的大趋势。</span><br style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;" />\r\n	<br style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;" />\r\n	<span style="font-family: tahoma, 宋体; font-size: 14px; line-height: 26px;">　　近期房屋销售继续低迷,中国房地产泡沫将破灭等市场观点此起彼伏。交银国际证券认为中国房屋价格确实有调整压力,但考虑到城镇化进程中城市人口仍将稳步增加,中国的城市房屋数量实际上并未明显过剩,只是过高的价格抑制了潜在购买需求。就像一只好公司的股票也有可能被高估一样,当前中国房地产价格普遍偏高,但其作为一种享受中国城镇化红利的优质资产的性质并未改变。</span></p>', '房地产', '', '财界网整理', '', '2014-05-26'),
	(207, '重庆攀华房地产独家赞助涪陵明星幼儿园', 'upload/images/1401667856359.jpg', '<div class="bzdh fl" style="margin: 10px 0px; padding: 0px; border: 1px solid rgb(210, 232, 255); float: left; width: 625px; clear: both; font-family: 宋体, arial; font-size: 14px; line-height: 24px;">\r\n	<dl style="margin: 0px; padding-right: 0px; padding-left: 0px; border: 0px;">\r\n		<dt style="margin: 0px; padding: 0px 0px 0px 15px; border-width: 0px 0px 1px; border-bottom-style: solid; border-bottom-color: rgb(210, 232, 255); font-weight: bold; line-height: 30px; font-family: simsun; color: rgb(5, 80, 153);">\r\n			新闻提要</dt>\r\n		<dd style="margin: 0px; padding: 10px 0px; border: 0px; line-height: 26px; overflow: hidden;">\r\n			5月30日上午在攀华未来城热烈举行，与现场近千名师生、家长一起，掀起了儿童节的欢乐热潮。</dd>\r\n	</dl>\r\n</div>\r\n<p style="margin: 6px 0px; padding: 5px 0px 0px; border: 0px; line-height: 1.8; font-family: 宋体, arial; font-size: 14px; background-color: rgb(242, 246, 252);">\r\n	&nbsp;</p>\r\n<p style="margin: 6px 0px; padding: 5px 0px 0px; border: 0px; line-height: 1.8; font-family: 宋体, arial; font-size: 14px; background-color: rgb(242, 246, 252);">\r\n	&nbsp;&nbsp;&nbsp;</p>\r\n<p style="margin: 6px 0px; padding: 5px 0px 0px; border: 0px; line-height: 1.8; font-family: 宋体, arial; font-size: 14px; background-color: rgb(242, 246, 252);">\r\n	<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="中华写字楼网">中华写字楼网</a>（<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank">http://www.officese.com</a>）：重庆攀华房地产独家赞助涪陵明星幼儿园</p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	<span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;"><span style="margin: 0px; padding: 0px; border: 0px;"><font size="3">　重庆攀华<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="房地产">房地产</a>有限公司一直关注教育事业的发展，一直秉承&ldquo;取之社会、回报社会&rdquo;的人文价值观。一年一度的六一节儿童节即将来临，重庆攀华<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="房地产">房地产</a>有限公司独家赞助了涪陵明星幼儿园&ldquo;金色童年，放飞梦想&rdquo;庆六一活动。5月30日上午在</font><font face="宋体" size="3">攀华未来城</font><font size="3">热烈举行，与现场近千名师生、家长一起，掀起了儿童节的欢乐热潮。</font></span></span></p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	<span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;"><span style="margin: 0px; padding: 0px; border: 0px;"><font size="3">　　整场汇演由小朋友活泼可爱的舞蹈《牛奶歌》拉开帷幕，通过《快乐时光》、《我的身体》、《水果王国》等优美的舞蹈与有趣的故事等多种节目形式，引发现场阵阵喝彩。</font></span></span></p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	<span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;"><span style="margin: 0px; padding: 0px; border: 0px;"><font size="3">　　而作为此次活动的赞助单位，重庆攀华<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="房地产">房地产</a>有限公司领导陈南丽表示：&ldquo;我们很高兴小朋友们能在欢笑和快乐中度过自己的节日，祝明星幼儿园的小朋友们节日快乐。重庆攀华<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="房地产">房地产</a>有限公司自2009年进入涪陵以来，取得了不错的业绩，这离不开涪陵人民的关心与支持。我们的企业是责任地产，希望以后能够更多地造福百姓，回馈社会。</font></span></span></p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	<span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;"><span style="margin: 0px; padding: 0px; border: 0px;"><font size="3">　</font></span></span><span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;">　在现场，攀华房产公司为幼儿园的小朋友精心准备了精美的礼物，包括幼儿精装图书、益智拼图等，颁发的这些礼品也受到了广大家长和孩子们的喜爱。</span></p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	<span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;"><span style="margin: 0px; padding: 0px; border: 0px;">　据悉，重庆攀华<a href="http://www.officese.com/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="房地产">房地产</a>有限公司是中国民营企业500强&mdash;&mdash;攀华集团旗下的一个子公司，实力雄厚。目前在涪陵打造有2个精品<a href="http://www.officese.com/xiezilou/" style="color: rgb(51, 51, 51); text-decoration: none;" target="_blank" title="楼盘">楼盘</a>，其中</span>攀华未来城<span style="margin: 0px; padding: 0px; border: 0px;">项目，是名副其实的大型花园式社区，目前入住率已达到90%以上，容纳人口8000多人。现正在开发建设的</span>攀华国际广场<span style="margin: 0px; padding: 0px; border: 0px;">项目，更是攀华集团的升级力作。地处交通枢纽位置，地理位置优越。同时采用内外街式商业，形成了以城市道路为沿街面的外圈商业和以内街为沿街面的内商业，极大地增加了商业的价值，提高了地块的人气凝聚力，致力将该项目打造为涪陵新区CBD核心和涪陵首席步行街。</span><img alt="攀华未来城" src="http://house.fuling.com/uploadfile/2014/0530/20140530045655668.jpg" style="border: 0px; max-width: 650px; padding: 0px; margin: 0px; width: 600px; height: 399px; max-height: 1650px; vertical-align: middle;" /></span></p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	&nbsp;</p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	&nbsp;</p>\r\n<p style="margin: 15px 0px; padding: 0px; border: 0px; line-height: 24px; font-family: 宋体; word-wrap: break-word;">\r\n	<span style="margin: 0px; padding: 0px; border: 0px; font-size: 14px;"><font size="3">　　明星幼儿园的小朋友在欢乐而热闹地气氛中度过了一个美好的节日，愿他们成长快乐。</font><br />\r\n	<img alt="攀华未来城" src="http://house.fuling.com/uploadfile/2014/0530/20140530045730642.jpg" style="border: 0px; max-width: 650px; padding: 0px; margin: 0px; width: 600px; height: 399px; max-height: 1650px; vertical-align: middle;" /></span></p>', '房地产', '', '涪陵房产网', 'recommend', '2014-06-02'),
	(208, '郁亮：轻松赚钱时代已过 看好“房地产下半场”', 'upload/images/1401667941109.jpg', '<p style="margin: 0px 0px 10px; line-height: 24px; color: rgb(51, 51, 51); font-family: Arial, 宋体, sans-serif; font-size: 14px; text-align: center;">\r\n	<span class="img_wrapper_img_descr">万科集团总裁郁亮</span></p>\r\n<p style="margin: 0px 0px 10px; line-height: 24px; color: rgb(51, 51, 51); font-family: Arial, 宋体, sans-serif; font-size: 14px;">\r\n	&emsp;&emsp;昨天，万科总裁郁亮表示，房地产进入下半场已成为行业共识，但目前市场上对这一概念的理解过于悲观。在郁亮看来，房地产轻松赚钱的时代已经过去，下半场对企业的考验更加全面，但优秀企业不缺少成长空间。</p>\r\n<p style="margin: 0px 0px 10px; line-height: 24px; color: rgb(51, 51, 51); font-family: Arial, 宋体, sans-serif; font-size: 14px;">\r\n	&emsp;&emsp;郁亮认为，中国的城市化远未结束，经济转型、不动产精细化才刚刚开始。同时，中国房地产行业的集中度明显低于发达国家成熟阶段。</p>\r\n<p style="margin: 0px 0px 10px; line-height: 24px; color: rgb(51, 51, 51); font-family: Arial, 宋体, sans-serif; font-size: 14px;">\r\n	&emsp;&emsp;此外，万科昨日对外表示，H股最早可能在6月下旬上市。去年1月19日，万科公布B转H方案。今年3月3日，万科转板方案获得中国证监会批复；5月21日，方案获得香港联交所上市委员会聆讯通过。现金选择权行权情况，将是影响万科B转H能否成功的最后一个关键环节。</p>', '房地产', '', '', 'recommend', '2014-06-02'),
	(209, '(5.31)网上房地产系统维护 仅18套认购数据上传', 'upload/images/1401668064640.jpg', '<table align="center" cellpadding="0" cellspacing="0" style="color: rgb(0, 0, 0); font-family: 宋体;" width="100%">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle">\r\n				5月31日网上房地产系统升级维护半天暂停服务 来源：南京网上房地产</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	<strong style="font-family: 宋体; font-size: 14px;">365地产家居网 南京讯</strong></p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　小长假第一天，南京楼市中不少楼盘都抓住端午节或者儿童节的契机，举行了丰富多样的活动，真正开盘卖房的反而十分少，仅有江宁新城玖珑湖项目详情业主社区相册样板户型视频地图和溧水楼盘创维乐活城项目详情业主社区相册样板户型视频地图推出了共110套房源。5月的最后一天，楼市也仿佛进入了假期模式。</p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　南京网上房地产数据显示，截至5月31日晚8:00，南京楼市当日共认购商品住宅18套、成交5套。出现这样的数据原因是今日网上房地产系统升级维护，有大半天时间系统暂停对外服务，直至下午恢复后才有个别板块有部分数据上传。（5月30日，南京共认购商品住宅264套、成交129套）。</p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　从仅有的少量上传数据的楼盘中可以看到，包括海峡城项目详情业主社区相册样板户型视频地图、保利梧桐语项目详情业主社区相册样板户型视频地图、世茂君望墅项目详情业主社区相册样板户型视频地图、骋望骊都项目详情业主社区相册样板户型视频地图、翠屏城项目详情业主社区相册样板户型视频地图等近期在楼市中较为活跃的楼盘今日都有相应的销售数据上传。尽管市场目前仍未从较冷的气氛中恢复过来，但开发商已陆续为了跑量在进行着各种各样的应对措施，有业内人士因此感叹，&ldquo;市场正在用自己的手进行调节。&rdquo;至于收效如何，只有等待实践来验证。</p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　据了解，在接下来的两天小长假，南京楼市还有包括天正理想城项目详情业主社区相册样板户型视频地图、雅居乐林语城项目详情业主社区相册样板户型视频地图等几个楼盘计划开盘推新。即将到来的6月，南京楼市将迎来一个怎样的开局？值得期待。（365地产家居网 姜芳芳）</p>\r\n<p>\r\n	<span style="font-family: 宋体; font-size: 14px;">　　</span></p>\r\n<table align="center" cellpadding="0" cellspacing="0" style="color: rgb(0, 0, 0); font-family: 宋体;" width="100%">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle">\r\n				<img align="middle" alt="截至5月31日南京楼市住宅库存情况 数据来源：网上房地产" border="1" src="http://i2.hexunimg.cn/2014-05-31/165304940.jpg" style="margin: 4px; padding: 0px; border: 1px solid rgb(0, 0, 0);" />截至5月31日南京楼市住宅库存情况 数据来源：网上房地产</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<table align="center" cellpadding="0" cellspacing="0" style="color: rgb(0, 0, 0); font-family: 宋体;" width="100%">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle">\r\n				<img alt="5月31日网上房地产系统升级维护半天暂停服务 来源：南京网上房地产" border="1" height="224" src="http://i3.hexunimg.cn/2014-05-31/165304941.jpg" style="margin: 4px; padding: 0px; border: 1px solid rgb(0, 0, 0);" width="500" />5月31日南京楼市热销楼盘排行榜 数据来源：南京网上房地产</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	<strong style="font-family: 宋体; font-size: 14px;">1、海峡城项目详情业主社区相册样板户型视频地图</strong></p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　海峡城于5月26日时加推6、7号楼，共355套房源，去化约180套，面积80-201?，其中80、140?房源热销。均价21000元/?。</p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　<strong>2、保利梧桐语项目详情业主社区相册样板户型视频地图</strong></p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　保利梧桐语目前在售28-30号楼，面积91、125?，毛坯交付，91?房源均价12000元/?，125?房源均价11000元/?。</p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　<strong>3、世茂君望墅项目详情业主社区相册样板户型视频地图</strong></p>\r\n<p style="margin: 0px; padding: 20px 0px 0px; border: 0px; line-height: 25px; font-family: 宋体; font-size: 14px;">\r\n	　　世茂君望墅在售小高层，面积115、130、140、160?，多位于顶楼和底楼。剩余房源量比较少。115?以下房源基本售完。均价17000元/?。</p>', '房地产', '', '365地产家居网', 'recommend', '2014-06-02'),
	(210, '内江市房地产交易当天成交2.5亿元', 'upload/images/1401668171859.jpg', '<div>\r\n	&nbsp;</div>\r\n<div>\r\n	<div class="neirong" id="article" style="border: 0px none; margin: auto; padding: 0px; list-style-type: none; width: 620px; font-family: 宋体;">\r\n		<form action="http://search.ce.cn/ce-mail/sendmail/sendmailCommon/fillmail.jsp" id="formarticle" method="post" name="formarticle" style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;" target="_blank">\r\n			<div class="content" id="articleText" style="border: 0px none; margin: 20px auto; padding: 0px; list-style-type: none; font-size: 14px; line-height: 22px;">\r\n				<div class="TRS_Editor" style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;">\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;">图为嘉宾出席内江第五届房交会开幕式</font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;"><img alt="" oldsrc="W020140601426237928496.jpg" src="http://sc.ce.cn/gdxw/201406/01/W020140601426237928496.jpg" style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;" /></font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;">图为内江第五届房交会正式启动瞬间</font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;"><img alt="" oldsrc="W020140601426237948423.jpg" src="http://sc.ce.cn/gdxw/201406/01/W020140601426237948423.jpg" style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;" /></font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;">图为摄影爱好者正在欣赏甜城摄影大赛优秀获奖作品</font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;"><img alt="" oldsrc="W020140601426237962857.jpg" src="http://sc.ce.cn/gdxw/201406/01/W020140601426237962857.jpg" style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;" /></font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;">图为市民在房产展示厅与外模合影</font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;"><img alt="" oldsrc="W020140601426237985372.jpg" src="http://sc.ce.cn/gdxw/201406/01/W020140601426237985372.jpg" style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;" /></font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						&nbsp;</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt; text-align: center;">\r\n						<font style="line-height: 1.5; font-size: 10.5pt;">图为展厅内市民了解精品户型信息</font></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<b>中国经济网内江6月1日讯（杨佳星 刘丽 记者 张贤明）</b>5月30日，内江第五届&ldquo;大千龙舟经贸文化节&rdquo;正式开幕。紧扣&ldquo;文化体育搭台，经贸投资唱戏&rdquo;文贸共融发展主题，七大系列活动先后登台，热烈上演，聚焦精彩。其中，作为&ldquo;七大盛事&rdquo;之一的&ldquo;房界盛会&rdquo;&mdash;&mdash;内江市第五届房地产交易展示会，于5月31日在内江国际会展中心正式启幕，获得多方媒体共同关注。</div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">据悉，本届房交会为期四天，借助端午节庆亲友团聚之际，以内江国际会展中心对外&ldquo;首秀&rdquo;为开展平台，扩大辐射力和影响深度，汇集众名企房产楼盘&ldquo;群雄逐鹿&rdquo;。以端午小长假为契机，旨在拉动购房长幅&ldquo;消费红线&rdquo;。与往年相比，今年房交会更注重深化全民参与的积极性、房业知识普及性、活动类型多样性以及购房服务&ldquo;一站式&rdquo;。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						<b>　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">现场：开幕仪式隆重启动 多方媒体共同瞩目</span></b></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">当日上午8点半，在多家媒体和相关重要嘉宾到场支持和热切瞩目下，第五届房地产交易展示会开幕式在&ldquo;全新亮相&rdquo;的展览、办公、休闲多功能公共建筑&mdash;&mdash;内江国际会展中心户外广场上如期举行。依傍着美丽的甜城湖畔，抒写出一篇新城蓬勃崛起的经济篇章。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">据了解，本届房交会由内江市房地产业协会主办，内江电视台、内江日报社、内江支点广告有限责任公司、内江未来全景策划机构承办，以创新联动的形式贯穿举办过程。在选址上，亦打破&ldquo;露天广场&rdquo;局限，以专精&ldquo;经贸&rdquo;的国际会展中心领衔全新运作机制，着实为内江房交会品牌效益注入新鲜活力和支撑实力。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">激情水鼓舞、柔美芭蕾舞、动感现代舞穿插其间，为开幕式现场火热气氛再增&ldquo;燃点&rdquo;。伴随昂扬音乐，内江市房地产协会会长吴芝奇先生在场宣布：&ldquo;2014内江市第五届房交会正式启动&rdquo;，标志房交会活动顺利&ldquo;起航&rdquo;。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">开幕式期间，还为日前组委会组织&ldquo;室内家装设计大赛&rdquo;和&ldquo;甜城摄影大赛&rdquo;两项房交会特色子活动揭晓评选结果。经层层筛选，四川顺安建筑工程有限公司和罗大江摄影作品《魅力内江》分获一等奖。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						<b>　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">活动：八大主题精彩纷呈 资源共享&ldquo;一站&rdquo;升级</span></b></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">据悉，本届房交会以&ldquo;城市让梦想升级&rdquo;为宣传口号，紧扣&ldquo;倾听楼市福音，寻找栖息福祉&rdquo;活动宗旨，着力铺设一站式&ldquo;精彩&rdquo;亮点，多措统筹，绘制房产经济蓝图。共邀请内江万达广场、邦泰国际公馆、鸿通春天公园城、峰景万晟城、锦华都等17家主力楼盘积极参展，结合诸多时尚元素和现代经济展销方式，热力开演&ldquo;HOUSE秀&rdquo;。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">在活动内容上，主办方专项策划了&ldquo;楼盘交易展示、内江新城建设巡展、室内设计大赛、甜城摄影大赛、最受欢迎楼盘评选、万元大抽奖、甜城购房地图、楼盘展示秀&rdquo;八大子活动。据现场负责人介绍，本次增设了摄影、设计、评选等&ldquo;与民同乐&rdquo;型互动活动，将观、赏、玩、乐融入购房大潮，其丰富性远超前几届，从结构、质感、品次、厚度、交易流通度全面&ldquo;升级&rdquo;，更突显出内江顺应&ldquo;一体化&rdquo;、&ldquo;一站式&rdquo;发展主流，致力将&ldquo;房产经济&rdquo;做活做亮、精益求精的倾向性。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　<b>　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">民声：房型多元万&ldquo;式&rdquo;俱备 有益展览增广视野</span></b></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">展馆外，各类装修个性的展区、设计精巧的房型让观展者赞不绝口。&ldquo;我比较看好锦华都，它的地理区位突显了教育优势。我家孩子正在学习关键期，能搬到这里，不管是买菜、就医、购物、选书都会很方便。&rdquo;善于分析户型的孙剑宇先生告诉记者，&ldquo;这次参加房交会覆盖面广，&lsquo;老熟人&rsquo;和&lsquo;新面孔&rsquo;很多，有复式高档户型也有经济宜居户型，也有一些本土特色户型，购房者可根据所需筛选对象&rdquo;。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">展馆内，在&ldquo;甜城摄影大赛&rdquo;、&ldquo;新城建设巡展&rdquo;展板前，聚集了大批市民观众，正看得津津有味。资深摄影爱好者陈熙楠面对 &ldquo;都市经典&rdquo;等主题中获奖作品，频频竖起大拇指。他评价道：&ldquo;这些摄影作品从多视角折射内江发展亮点和投产理念，扩充了房产内涵，递增了房交会的品质感，&lsquo;以图说房&rsquo;，可说是一次大胆尝试。&rdquo;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">同样赞不绝口的还有大学生许晓文，她认为新城建设巡展把个体购房的&ldquo;点&rdquo;上升到解读城事的&ldquo;面&rdquo;，是一种全新开拓。&ldquo;内容很有看头，分设地方馆，以多视角资源共享，全方位、立体化展现出内江三县两区的精品建设成果和可行规划方向。&rdquo;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						<b>　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">房企：个性宣传创意十足 共性发展百家争鸣</span></b></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">当日下午，记者再次来到现场，看到房展会现场依然人头攒动，热闹非凡。各家楼盘分设定点，通过醒目横幅、纸质传单、举板宣传，乃至外模合影、扫码送礼、人体彩绘等花样方式，吸引了诸多市民驻足观望，现场参与了解。?</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">尽管宣传手段充满&ldquo;个性&rdquo;，但众家房企在筹备&ldquo;房销房展&rdquo;的积极态势中，总体呈现出了重视服务、精心筛选、自铸品牌、立足口碑的&ldquo;共性&rdquo;。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">金科&middot;公园王府做足了房产销售的&ldquo;好服务员&rdquo;口碑，他们推出的变形金刚展门票馈赠、老照片征集、2套特价房抢购等优惠活动获得了不少市民&ldquo;点赞&rdquo;。&ldquo;灵活应变的服务是我们赢得客户的法宝。&rdquo;该房产置业顾问表示，在众多楼盘各有千秋情况下，服务就显出了亲民性，售前服务要周到，售后服务更要贴心，才能打好&ldquo;民心牌&rdquo;，拥有稳定消费群。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">四川万晟房地产有限公司策划总监梁文轩强调的是&ldquo;精心筹备&rdquo;。据他介绍，万晟城一期规划建设1000亩，本次房交会带来了3个项目，可交易商品房面积共计约10万平方米，将近1200套。&ldquo;随着消费水平提高，内江正逐渐成为商业地产投资的理想蓝海。我们大胆投入的自信来源于内江房产市场的深度潜力和可观性。&rdquo;他如是谈道。</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">另一家房产&ldquo;大佬&rdquo;邦泰集团内江公司总经理盛斌则评价，房交会上&ldquo;讲解&rdquo;意义要胜过&ldquo;劝购&rdquo;，据悉，他们此次带来2个项目，可交易商品房面积共计约6万平方米，近800套住房。他更多地谈到了住房供需波动时期，更新购房理念对延伸房产人文品牌的影响力。&ldquo;我们不只注重售房量，更强调与甜城市民的沟通。在现代经济模式下，住房随处可见，如何推广使用家用净水器系统、社区wife智能覆盖这些新型住房资源，改变家居结构，锁定打造宜居生活绿色理念，才是彰显&lsquo;城市让梦想升级&rsquo;的核心要义。&rdquo;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">&nbsp;</span></div>\r\n					<div style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">\r\n						　　<span style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none; line-height: 1.5; font-size: 10.5pt;">据相关数据核实统计，第五届房交会开幕当日，17个参展项目总共成交住房套数23套，营业房100套，成交总金额达2.5亿元。当天预约登记人数338人，在场咨询房源人数945人，整体经济态势良好，销售趋势看涨。</span></div>\r\n					<div>\r\n						&nbsp;</div>\r\n				</div>\r\n				<p style="border: 0px none; margin: 0px; padding: 0px; list-style-type: none;">\r\n					&nbsp;</p>\r\n			</div>\r\n		</form>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '中国经济网-四川频道', 'recommend', '2014-06-02'),
	(211, '房地产市场的“再平衡”', 'upload/images/1401668666109.jpg', '<p style="margin: 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	古<a class="keylink" href="http://htq.guhantai.com/" style="color: rgb(0, 68, 153); text-decoration: none; outline: none;" target="_blank">汉台</a>网6月1日讯 4月份的经济数据继续维持了疲弱的态势，再次表明了&ldquo;稳增长&rdquo;的必要性。幸运的是，一系列 &ldquo;稳增长&rdquo;与&ldquo;调结构&rdquo;相结合的措施自3月份即已陆续推出。根据过去几年的经验，这些陆续播撒的种子一般会在3-6个月里破土发芽。因此，即便5月份的经 济数据依然较弱，经济增长启稳回升应该就在不远的将来，估计三季度实际GDP增长率再次回升到7.5%或以上应该是大概率事件。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	然而，一些投资者担心&ldquo;这次不一样&rdquo;，因为他们认为房地产市场目前出现的下滑会把整个经济拖垮。他们担心，由于过去数年开发商的过度投资以及 投机、投资者的过度购买，房地产市场目前存在巨大的供应过剩问题，市场的出清会带来房价下跌、投资下滑、开发商资金断链、银行与信托公司坏账上升、房地产 上下游行业受到牵连等一系列连锁反应，最终引发一场经济与金融危机。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	和讯网刊登博道投资首席经济学家孙明春文章认为，这些担忧有些过虑了。从长周期来看，中国的房地产市场正在从供应极度短缺的阶段走向供需基本 平衡的阶段，这一&ldquo;再平衡&rdquo;的过程估计要历时十年之久。在此过程中，中国的房地产市场会变得更为健康，房价走势会更为平稳，购房者的经济承受力会逐步改 善，有真实性购房需求的低收入群体的福利会上升，开发商之间的整合会加速，房地产业也会从一个暴利行业逐渐转变成为一个享受社会平均回报率的行业。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	当然，在这个&ldquo;再平衡&rdquo;过程中，真正的风险集中在那些杠杆率过高、摊子铺得过大的开发商，他们将在接下来的十年中面临极大的挑战，其中肯定会 有很多破产倒闭(尤其是在2016-2018年间)。而那些有远见、审慎经营、杠杆率较低的地产商将会借助这一历史机遇通过廉价的兼并与收购来做大做强。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	房地产市场长期存在供需失衡</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	文章表示，房地产是一个周期性行业。在过去15年里，中国的房地产市场经历了数个明显的周期，这些周期大都因宏观调控、政策紧缩而始，以政策 放松、市场强劲反弹而终。在这15年里，关于中国房地产市场存在巨大泡沫、房地产市场即将崩盘的各种悲观言论此起彼伏，不绝于耳。而房地产行业虽然有起有 伏，但最终以房价、房租、开工面积、竣工面积、销售面积、在建面积等指标数倍、甚至数十倍的上涨反击了上述言论。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	中国房地产市场在过去15年的强劲成长，源于多种深刻而复杂的原因，包括：(1)90年代末期的住房改革促成了商业化房地产市场从无到有、起 点较低的原因；(2)大规模的城镇化进程；(3)城镇居民收入水平的大幅度提高导致对居住条件改善的巨大需求；(4)人口红利；(5)整个经济由于改革开 放的深入而出现&ldquo;货币化&rdquo;深化的进程；(6)在货币高增长但上市公司质量普遍欠佳的环境下，具有长期保值增值功能的、高质量的投资品出现了明显的短缺，这 迫使富有储蓄文化的中国居民对住房的投资功能高度追捧。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	上述因素集中表现在一个现象上，那就是在过去15年里，中国的房地产市场出现了严重的供不应求，这是导致这些年房价成倍上涨的最主要原因。我 们根据国家统计局公布的一系列数据做了匡算，结论是：在1999-2013年的15年时间里，以商品房累计竣工面积计算的房产供应仅仅是潜在住房需求的 50%左右，供需缺口总量高达76亿平米。在如此巨大的供需缺口之下，房价的大幅度上涨自然是无法避免的。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	在我们估算住房的潜在需求时，主要包括两个方面，一是新增城镇人口带来的新增住房需求，二是原有城镇人口存在的改善性住房需求。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	一、1999-2013年期间，城镇常住人口总量增加了3.2亿人，按城镇居民人均居住面积33平米计算，这些新增城镇人口需要约104亿平米的住房。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	二、1998年底，全国城镇常住人口为4.2亿，当年人均居住面积为18.7平米，比2013年的人均33平米少14.3平米，这意味着过去15年中原有城镇人口形成的改善性住房需求约为60亿平米。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	二者相加，1999-2013年间住房潜在需求总量约为164亿平米，而同期的商品房竣工面积总量(包括住宅和商业地产)仅为88亿平米，供需缺口达到76亿平米。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	当然，由于数据的质量和可获得性的原因，这个测算是非常粗略的，不可能精确。比如，国家统计局公布的商品房竣工面积，很可能无法涵盖各种&ldquo;小产权房&rdquo;，这一数据的缺失有可能导致对住宅供应量的较大低估。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	但是，也要指出的是，我们在计算住宅供应时，没有去除因房屋动迁、旧城改造所减少的原有住宅面积(因为没有数据)。考虑到绝大多数城市的面貌 在过去15年都发生了革命性的变化，可以想象旧房拆迁的面积之大。因此，用商品房累计竣工总面积来估算住宅供应，肯定大大高估了实际净增的供应面积。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	同时，如果考虑到商品房竣工面积中还有约15-25%为商业地产，真正用于居民住宅的竣工面积比我们估算的88亿平米应该会更少。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	总之，考虑到上述所有的误差与遗漏，我们可以大致确定，过去15年房地产市场的实际供应仅仅满足了50%左右的潜在需求。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	很多人认为，大部分从农村转移到城市的人口收入很低，即便他们已经被城镇化，也买不起城里的房子，所以不应该把他们的买房需求算进来。这种观 点有失偏颇。理论上讲，如果房价低到一定程度，这些人口中的绝大部分也就买的起房了，但此时房地产市场的供需缺口就不是潜在的，而是真实的，是有购买力支 持的。然而，一旦这些供需缺口从潜在的变成真实的，那么房价就不可能这么低了，而是会因市场竞价而被不断推高。这就是市场规律。因此，在房地产市场供需缺 口达到50%左右的情况下，有一半左右甚至以上(考虑到收入不平衡的现象)的人口买不起房，其实不应该令人奇怪。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	房地产市场的&ldquo;再平衡&rdquo;</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	文章分析，中国房地产市场的供需极度失衡，在今后5-10年里会出现明显的改善。中国的房地产市场将逐步进入一个供需基本平衡的阶段。在这个 &ldquo;再平衡&rdquo;的过程中，房价的涨幅会明显回落，在某些供应增长过快的区域甚至会出现明显的下跌。但从全国均价来看，在今后10年里，房价整体应该还是保持稳 中略升的态势(当然其中某些年份可能会出现一些波动)。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	国家统计局的数据显示，到今年4月底，全国商品房在建未完工面积达到54亿平米。如果按2013年的商品房竣工面积(10亿平米)计算，把这 些在建项目完工需要大约5.3年的时间。在这5年多的时间里，按城镇人口每年新增1800万人计算，城镇常住人口会增加约9000万人。按人均居住面积 33平米计算，这些新增城镇人口所形成的潜在住房需求约为30亿平米。也就是说，在不考虑现有城镇居民的改善性住房需求的情况下，今后5年 (2014-2018年)住宅房地产市场将出现新增供应大于新增潜在需求约24亿平米(54亿平米减去30亿平米)的现象。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	不过，这24亿平米供大于需的缺口，与过去15年所累积的供小于需的缺口(76亿平米)相比，依然有52亿平米的差距。这意味着，即便把这些 在建项目按时竣工，中国住宅市场的巨大供需缺口也不可能在5年内消失。因此，我们判断，中国的房地产市场从供应极度短缺的状态走向基本平衡的&ldquo;再平衡&rdquo;过 程大约会持续10年左右。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	在房地产市场&ldquo;再平衡&rdquo;的过程中，随着供需缺口的逐渐缩小，一批又一批对住房具有&ldquo;潜在需求&rdquo;的城镇居民将会获得买房的机会。在这一背景下， 房价走势将主要取决于居民收入的成长速度及按揭贷款的可获得性。只要中国经济能够保持7%左右的实际增长率，城镇居民的名义收入应该可以保持在8-10% 的增速，这意味着其名义收入的绝对水平在今后5年内会提升50%，而在10年内会成长一倍以上。在这种收入增速下，城镇居民的购房能力会明显改善。如果随 着金融改革的深化，按揭贷款的可获得性进一步提升的话，越来越多的&ldquo;潜在需求&rdquo;将转化成为真实需求，从而形成对房价稳定的有力支撑。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	因此，在供需缺口依然较大、收入增速依然较快、金融深化的空间依然广阔的背景下，中国的房地产市场在今后5-10年的&ldquo;再平衡&rdquo;过程应该可以 平稳进行，房价涨幅应该更趋温和。而在近期内(2014-2015年)，各地政府正在酝酿取消的&ldquo;限购&rdquo;政策则会更为直接、更为快速地释放出大量的具有购 买力支撑的真实需求，从而大大降低房价下跌的可能性。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	房地产市场的潜在风险</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	文章指出，尽管如此，房地产市场的潜在风险也的确不容忽视。如果开发商们继续保持过去几年疯狂扩张、拼命圈地的策略，而不是悬崖勒马、稳健经营、降低杠杆率的话，那么房地产市场的风险在今后数年则可能急剧上升，最终导致一场较大的危机。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	按照国家统计局的数据，在2010-2013年间的4年里，新开工面积总和达到73亿平米。而2013年当年的商品房新开工面积即达到20亿 平米。如果开发商继续以如此疯狂的速度上新项目，那么今后5年，新开工面积总和将超过100亿平米，远远超出今后10年新增的住房需求，也远远大于过去 15年商品房竣工面积总和(88 亿平米)。果真如此，中国的房地产市场在10年之内就可能出现供大于求的现象，届时房地产价格的大幅度调整也就难以避免。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	从这个意义上讲，今年前四个月出现的新开工面积的大幅度回落(-22%)其实是件好事!如果新开工面积在今后几年继续保持回落态势，这将大大 降低5年后房地产市场出现严重供大于需的风险，保证房地产行业的平稳运行。与此同时，由于在建面积实在很大，即便新开工面积继续回落，只要开发商获得足够 的融资，房地产投资在今后的3-4年里依然有可能维持10-15%的增速，这对近期的&ldquo;稳增长&rdquo;举措也不会产生明显的不利影响。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	在这个&ldquo;再平衡&rdquo;过程中，真正的风险集中在那些杠杆率过高、摊子铺得过大的开发商，他们将在接下来的十年中面临极大的挑战，其中很多会破产倒 闭(尤其是在2016-2018年间)，并有可能对银行、信托等金融机构和金融体系造成一定的冲击。对此，监管部门及投资者都应及早采取防范措施。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	然而，这些开发商的困境也给那些富有远见、审慎经营、杠杆率较低的地产商提供了难得的历史机遇，因为后者可以通过廉价的兼并与收购来做大做强，实现行业的整合。这些兼并与收购活动也会减轻金融体系的压力，降低出现系统性金融危机的风险。</p>\r\n<p style="margin: 26px 0px 0px; padding: 0px; list-style: none; text-indent: 28px; line-height: 23px; color: rgb(43, 43, 43); font-family: 宋体, sans-serif; font-size: 14px; background-color: rgb(247, 252, 254);">\r\n	因此，经过这一轮的&ldquo;再平衡&rdquo;之后，中国的房地产行业将从一个快速成长的行业转变成为一个基本平稳的行业，房地产市场的供需会更为平衡，房价 走势会更为平稳，购房者的经济承受力会明显改善，有真实性购房需求的低收入群体的福利会上升，开发商之间的整合会加速，房地产业也会从一个暴利行业逐渐转 变成为一个享受社会平均回报率的行业。</p>', '房地产', '', '古汉台网', 'recommend', '2014-06-02'),
	(212, '2014年中国房地产 上市公司综合实力榜 （前30强）', '', '<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	1 万科</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	2 保利地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	3 中国海外发展</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	4 恒大地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	5 龙湖地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	6 世茂房地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	7 碧桂园</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	8 富力地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	9 融创中国</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	10 华润置地</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	11 远洋地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	12 招商地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	13 绿城中国</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	14 华夏幸福</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	15 佳兆业集团</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	16 金地集团</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	17 雅居乐地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	18 金科股份</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	19 新城发展控股</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	20 金隅股份</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	21 保利置业集团</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	22 金融街</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	23 华侨城</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	24 旭辉控股集团</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	25 路劲基建</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	26 建业地产</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	27 中南建设</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	28 荣盛发展</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	29 阳光城</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	30 SOHO中国</p>', '房地产', '', '中国房地产研究会、中国房地产业协会、中国房地产测评中心', 'recommend', '2014-06-02'),
	(213, '以“质”取胜，奥利凯中央空调进驻桦林房地产', 'upload/images/1401668949937.jpg', '<p style="margin: 0px; padding: 0px; border: 0px currentColor; line-height: 28px; font-family: 宋体; font-size: 16px;">\r\n	　近日，经过了综合实力考核，奥利凯中央空调成功进驻德州桦林房地产新建办公楼。桦林房地产开发有限公司是德州市较具实力的房地产开发公司，建筑面积达5000平方米。该项目主机选用了奥利凯风冷模块机组，末端选用了风机盘管机组。</p>\r\n<div align="center" style="margin: 0px auto; padding: 0px; color: rgb(67, 67, 67); line-height: 20px; overflow: hidden; font-family: 宋体; float: none;">\r\n	&nbsp;</div>\r\n<p style="margin: 0px; padding: 0px; border: 0px currentColor; line-height: 28px; font-family: 宋体; font-size: 16px;">\r\n	　　设备安装调试后，运行稳定，效果良好，赢得了桦林房地产董事长包总的高度评价。包总表示，奥利凯中央空调质量过硬，价格公道，今后有合适的项目将继续合作。</p>\r\n<p style="margin: 0px; padding: 0px; border: 0px currentColor; line-height: 28px; font-family: 宋体; font-size: 16px;">\r\n	　　作为中国质量检验协会团体会员单位的青岛奥利凯中央空调有限公司拥有先进的暖通行业技术、高智能实验室、一流的生产设备和完善的售后体系，今后，将秉承&ldquo;专注行业，品质见证&rdquo;的企业理念，做好履约服务，不断提升产品品质，提高用户的满意度，坚持以&ldquo;质&rdquo;取胜，为市场提供更多性能稳定的高质量产品。</p>', '房地产', '', '中国质量网', 'recommend', '2015-12-22'),
	(214, '郁亮：中国房地产轻松赚钱的黄金时代已终结', 'upload/images/1401669169546.jpg', '<p style="margin: 10px 0px; padding: 0px; font-size: 14px; line-height: 25px; font-family: 宋体; word-wrap: break-word; color: rgb(51, 51, 51);">\r\n	　　在全国房地产市场走向扑朔迷离的当下，地产大佬纷纷发声。继近日SOHO中国董事长潘石屹将楼市比喻成&ldquo;将撞冰山的泰坦尼克号&rdquo;之后，万科集团总裁郁亮昨天也表示，中国房地产行业轻松赚钱的黄金时代已经终结。不过，与潘石屹的悲观相比，郁亮仍认为，楼市下半场对企业能力的考验会更加全面，优秀企业并不会缺少成长空间。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-size: 14px; line-height: 25px; font-family: 宋体; word-wrap: break-word; color: rgb(51, 51, 51);">\r\n	　　在经历了去年的成交大幅回升后，今年以来，国内房地产市场销售有所放缓，市场对后续走势的判断也随之出现分化。作为业内率先提出&ldquo;下半场&rdquo;概念的领军人物，郁亮表示，尽管下半场已成行业共识，但目前市场上对这一概念的一些理解过于悲观。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-size: 14px; line-height: 25px; font-family: 宋体; word-wrap: break-word; color: rgb(51, 51, 51);">\r\n	　　他认为，地产行业轻松赚钱的时代已经过去，但中国的城市化还远未结束，经济转型、不动产精细化才刚刚开始。同时，中国房地产行业目前的集中度明显低于发达国家成熟阶段，美国前五大开发商的市场占有率2010年为18.1%，而国内前五大开发商2013年的占有率仅8.6%，集中度的上升将帮助龙头企业保持较好的成长性。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-size: 14px; line-height: 25px; font-family: 宋体; word-wrap: break-word; color: rgb(51, 51, 51);">\r\n	　　郁亮认为，未来的客户需求和以前相比会有很大的区别，而移动互联网时代企业也需要加倍善待客户。郁亮透露，万科未来将按照&ldquo;好产品、好服务、好邻居&rdquo;的总体思路，在产品性能、服务内容和社区氛围上做出努力，不断超越行业目前的范围和水准，始终保持行业领跑者的地位。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-size: 14px; line-height: 25px; font-family: 宋体; word-wrap: break-word; color: rgb(51, 51, 51);">\r\n	　　&ldquo;万科近年来也在积极谋求转型。&rdquo;郁亮表示，在传统业务上，公司正在逐步转向更安全、效率更高的轻资产模式，同时也在积极尝试消费地产（发展诸如社区配套等服务）、产业地产（物流地产、养老地产）等新业务的开拓。郁亮称，万科有信心在行业发生根本性变化之前完成公司的转型。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-size: 14px; line-height: 25px; font-family: 宋体; word-wrap: break-word; color: rgb(51, 51, 51);">\r\n	　　郁亮是在万科集团发给媒体的一篇&ldquo;B转H临近收官&rdquo;新闻稿中做出以上表述的。</p>', '房地产', '潘秀林', '京华时报', 'recommend', '2014-06-02'),
	(215, '房地产大腕唱空楼市 房价下跌最快城市排行榜', '', '<div class="mtabstract" id="newxq_B01_28" style="margin: 15px 0px 0px; padding: 11px; border: 0px currentColor; color: rgb(85, 85, 85); line-height: 24px; overflow: hidden; font-family: 宋体, Arial; list-style-type: none; background-color: rgb(238, 238, 238);">\r\n	<strong>[摘要]</strong>房价走势到底如何？2014年新一波房地产的&ldquo;唱空&rdquo;似乎再度来袭。2014年的中国楼市真的走到所谓&ldquo;崩盘&rdquo;的边缘了吗？事实上，关于中国楼市崩盘的说法，有多少&ldquo;证据&rdquo;的同时就会有多少的反证。一直唱高房价的任志强对于今年房地产的增长也不持乐观态度。楼市走势虽不能肯定，却有传言中国12个城市房价或将下跌最快。</div>\r\n<div id="newxq_B01_05" style="margin: 0px; padding: 0px; border: 0px currentColor; color: rgb(85, 85, 85); font-family: 宋体, Arial; list-style-type: none;">\r\n	<div class="mtcomment" id="news_body" style="margin: 0px; padding: 0px; border: 0px currentColor; overflow: hidden; font-size: 14px; list-style-type: none;">\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			2014年，新一波房地产的&ldquo;唱空&rdquo;似乎再度来袭。一直唱高房价的任志强对于今年房地产的增长也不持乐观态度。任志强表示，&ldquo;很多开发商以为今年可能跟去年一样，很乐观。我个人对他们提出警告，我说你们太乐观了，很危险。&rdquo;</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			2014年的中国楼市真的走到所谓&ldquo;崩盘&rdquo;的边缘了吗？事实上，关于中国楼市崩盘的说法，有多少&ldquo;证据&rdquo;的同时就会有多少的反证。各种数据呈现出来的现状，一面是中小城市房价回落，销售乏力的现实；一面是一线城市热度不减，需求空前的现状&hellip;&hellip;房价走势到底如何？楼市会崩盘吗？我们都不能肯定，只是传言中国12个城市房价或将下跌最快，跟小编一起去看看吧，在这里买房需谨慎。</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<strong>房价下跌最快城市排行</strong></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			1、北京</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：9418元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&darr;0.15%，环比上月：&darr;0.85%，同比去年：&uarr;3.93%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			&nbsp;</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			2、上海</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：27024元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;0.05%，环比上月：&uarr;19.20%，同比去年：&uarr;30.37%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321039065_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="2" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			3、深圳</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：25942元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;1.56%，环比上月：&uarr;0.33%，同比去年：&uarr;26.48%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321039567_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="3" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			4、厦门</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			均价：25538元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;0.33%，环比上月：&uarr;1.92%，同比去年：&uarr;27.56%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321039925_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="4" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			5、温州 住宅均价：20,755元/平 环比上月-0.49%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321040287_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="5" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			6、三亚 住宅均价：20,017元/平 环比上月-4.01%7、杭州</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：20753元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&darr;0.1%，环比上月：&uarr;1.29%，同比去年：&uarr;8.80%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321040593_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="6" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			7、杭州</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<font color="#ff0000">住宅均价：20753元/平米</font></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&darr;0.1%，环比上月：&uarr;1.29%，同比去年：&uarr;8.80%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321040914_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="7" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			8、广州</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：19265元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;0.56%，环比上月：&uarr;3.47%，同比去年：&uarr;20.23%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321041268_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="8" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			9、南京</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：15925元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;0.45%，环比上月：&uarr;26.03%，同比去年：&uarr;39.72%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321041605_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="9" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			10、天津</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：17032元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;1.21%，环比上月：&uarr;0.95%，同比去年：&uarr;18.01%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321042225_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="10" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			11、宁波</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：14698元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;0.38%，环比上月：&uarr;1.33%，同比去年：&uarr;0.11%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321042826_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="11" type="image" /></p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			12、福州</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			住宅均价：14698元/平米</p>\r\n		<p style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			环比上周：&uarr;0.38%，环比上月：&uarr;1.33%，同比去年：&uarr;0.11%</p>\r\n		<p align="center" style="margin: 20px 0px 0px; padding: 0px; border: 0px currentColor; line-height: 26px; text-indent: 28px; overflow: visible; list-style-type: none;">\r\n			<img alt="" src="http://imgs.soufun.com/news/2014_05/29/news/1401321041922_000.jpg" style="margin: 0px; padding: 0px; border: 0px currentColor; list-style-type: none;" title="12" type="image" /></p>\r\n	</div>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '搜房网', 'focus', '2015-12-23'),
	(216, '禹洲地产荣膺“2014中国房地产上市公司综合实力50强”', 'upload/images/1401669409781.png', '<div class="REVIEW" style="font-size: 14px; color: rgb(0, 0, 0); background-color: rgb(241, 241, 241); line-height: 28px; padding: 10px 5px; font-family: 宋体;">\r\n	<b>[导读]</b>2014年5月29日，由中国房地产研究会、中国房地产业协会与中国房地产测评中心主办的&ldquo;2014中国房地产上市公司测评成果发布会暨上市房企高峰论坛&rdquo;在香港盛大举行。</div>\r\n<table style="color: rgb(109, 109, 109); font-family: 宋体;" width="100%">\r\n	<tbody>\r\n		<tr>\r\n			<td>\r\n				<div class="newShow" style="padding: 23px 0px; font-size: 14px; color: rgb(68, 68, 68);">\r\n					<div class="content" style="line-height: 24px; padding: 0px;">\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em;">\r\n							2014年5月29日，由中国房地产研究会、中国房地产业协会与中国房地产测评中心主办的&ldquo;2014中国房地产上市公司测评成果发布会暨上市房企高峰论坛&rdquo;在香港盛大举行。禹洲地产（01628.HK）荣膺&ldquo;2014中国房地产上市公司综合实力50强&rdquo;第39名，并首次入榜&ldquo;2014中国房地产上市公司发展速度5强&rdquo;。禹洲地产财务总监邱于赓先生代表公司上台领奖。</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em;">\r\n							2014中国房地产上市公司测评从企业规模、风险管理、盈利能力、成长潜力、运营绩效、创新能力、社会责任七大方面，全面衡量企业的综合实力。测评成果的公布，有助于上市公司了解自身的实力和在行业中的地位，同时为政府、银行、金融机构、消费者提供极具参考价值的企业信息，并加深社会各界对优秀上市公司的认知度。</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em;">\r\n							禹洲地产自2009年在香港成功上市以来，秉持稳健发展的理念，不断扎实&ldquo;立足海西，建树中国&rdquo;的大战略，基于&ldquo;去化率、利润率和执行力&rdquo;的谨慎考虑，目前已成功布局厦门、福州、上海、合肥、天津、泉州、龙岩、蚌埠、漳州这9个城市。禹洲亦不断优化财务结构及保持稳定且充裕的现金流，其稳健的财务状况及发展前景，获得了包括花旗证券、麦格理证券、中银国际等多家投行和券商的关注，评级机构穆迪及标准普尔分别维持本集团企业【B1】和【B+】发行人评级以及【B2】和【B】债券评级，前景展望皆为稳定。</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em;">\r\n							此外，在产品和服务上，禹洲不断完善项目环境与配套，全面提升产品品质，致力为客户提供更完美更贴心的服务，力争成为全国一流的城市优质生活服务商。其旗下公司禹洲物业服务有限公司，作为全国一级资质物业服务企业，现已设有上海、天津、福州、合肥、泉州等分公司，管理总建筑面积约247万平方米，向约22,670户业主提供服务。</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em;">\r\n							在行业、企业分化加剧的情况下，禹洲连续三年登上&ldquo;房地产上市公司综合实力50强&rdquo;榜，并于2014年荣膺多项权威奖项前40强，此前更首次当选&ldquo;中房协&rdquo;副会长单位，足以表明资本市场与行业对禹洲价值与发展前景的认可。未来，禹洲地产将坚定不移地落实&ldquo;立足海西，建树中国&rdquo;的目标，继续秉持&ldquo;稳健发展，创造价值&rdquo;的理念，致力于为中国城市发展创造更多价值，力争成为中国房地产行业&ldquo;稳健价值创造者&rdquo;的代表企业！</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em; text-align: center;">\r\n							&nbsp;</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em; text-align: center;">\r\n							禹洲地产财务总监邱于赓先生（左三）代表公司领取奖项<br />\r\n							<br />\r\n							<img alt="禹洲地产荣膺“2014中国房地产上市公司综合实力50强”" src="http://fz.lanfw.com/uploadfile/2014/0530/20140530024612387.png" style="border: 0px; width: 556px; height: 391px;" title="禹洲地产荣膺“2014中国房地产上市公司综合实力50强”" /></p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em; text-align: center;">\r\n							禹洲地产荣膺&ldquo;2014中国房地产上市公司综合实力50强&rdquo;<br />\r\n							<br />\r\n							<img alt="禹洲地产荣膺“2014中国房地产上市公司综合实力50强”" src="http://fz.lanfw.com/uploadfile/2014/0530/20140530024635275.png" style="border: 0px; width: 555px; height: 374px;" title="禹洲地产荣膺“2014中国房地产上市公司综合实力50强”" /></p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em; text-align: center;">\r\n							禹洲地产首次入榜&ldquo;2014中国房地产上市公司发展速度5强&rdquo;</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em;">\r\n							如欲了解更多禹洲地产的信息，请浏览公司网页：<a href="http://www.xmyuzhou.com.cn/" style="color: rgb(109, 109, 109); text-decoration: none;">http://www.xmyuzhou.com.cn</a>&nbsp;，官方微博：<a href="http://weibo.com/yuzhou1994" style="color: rgb(109, 109, 109); text-decoration: none;">http://weibo.com/yuzhou1994</a>&nbsp;，或关注公司微信订阅号：禹洲地产。</p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em; text-align: center;">\r\n							<img alt="禹洲地产荣膺“2014中国房地产上市公司综合实力50强”" src="http://fz.lanfw.com/uploadfile/2014/0530/20140530024657511.png" style="border: 0px; width: 165px; height: 156px;" title="禹洲地产荣膺“2014中国房地产上市公司综合实力50强”" /></p>\r\n						<p style="padding: 0px; margin: 0px 0px 8px; text-indent: 2em; text-align: center;">\r\n							扫一扫，关注禹洲地产</p>\r\n					</div>\r\n				</div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '蓝房网', 'recommend', '2014-06-02'),
	(217, '蒋定之:加强监测分析预警促进房地产业平稳健康发展', 'upload/images/1401669753937.jpg', '<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px; text-align: center;">\r\n	<span style="color: rgb(128, 128, 128); text-align: -webkit-center;">省长蒋定之在海口市调研房地产业发展运行情况</span></p>\r\n<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px;">\r\n	&nbsp;今天（28日）上午，省长蒋定之在海口市调研房地产业发展运行情况，并与有关部门、市县和房地产企业负责人座谈，听取各方面意见建议，分析研判当前我省房地产市场形势和走势，研究部署下阶段工作措施。蒋定之强调，房地产业仍是现阶段海南的重要支柱产业，要准确把握房地产业发展运行状况，密切关注和重视出现的新情况、新问题，加强监测分析预警，更有针对性、前瞻性做好工作，促进我省房地产业平稳健康发展。</p>\r\n<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px;">\r\n	　　蒋定之一行分别来到海口滨江新城和开维生态城项目现场，听取相关企业负责人的介绍，详细了解项目建设规模、销售量价、市场结构、配套设施和物业管理等情况。他进家入户，看户型问质量，听取购房者的意见建议，随后在现场主持召开了全省房地产业发展座谈会。</p>\r\n<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px;">\r\n	　　蒋定之在座谈会上指出，促进房地产业平稳健康发展，首先要科学认识和判断当前我省房地产市场形势。今年1到4月份，尽管我省出现了房地产新开工面积有所下降、房屋销售有所回落等新情况，但房地产投资和商品房施工面积继续较快增长，商品房销售均价保持在合理区间，房地产整体结构进一步优化，从总体上看，海南房地产市场是健康的、平稳的，没有出现大的起伏和波动。蒋定之说，好山好水好空气是海南房地产业持续健康发展的基石，生态环境的优越性和稀缺性，奠定了海南房地产业的市场竞争力，无论从当前态势还是从发展趋势看，海南房地产业保持平稳健康发展的基础和条件是突出的，市场潜力和前景是好的。我们要进一步增强发展信心，稳定市场预期，有针对性做好工作，为房地产业平稳健康发展创造良好市场环境。</p>\r\n<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px;">\r\n	　　蒋定之说，促进房地产平稳健康发展，十分关键的是要加强对市场的分析研究，眼睛要紧紧盯市场，从市场需求出发完善开发建设思路，创新和调整营销方式，在细分市场、占领市场、开发市场、引导市场上下功夫，尤其要加强海南整体形象的包装、设计和营销，显著提升区域整体吸引力和竞争力。要加强政策储备，科学确定我省房地产市场健康运行的合理区间，适时出台相应对策措施，主动引领市场健康发展。要高度重视优化房地产结构，按照&ldquo;稳定东部、提升西部、控制中部&rdquo;的总体要求，促进区域协调发展;逐步降低普通商品住房开发比例，增加高端旅游酒店、度假村、产权式公寓等经营性地产的开发建设，加大保障性住房供应力度。要积极引导房地产企业合理投资，保持适度投资规模，着力调整和优化投资结构，防止投资大起大落，重点要抓好棚户区改造、保障房工程、经营性地产开发、新型城镇化建设等领域的投资。</p>\r\n<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px;">\r\n	　　蒋定之强调，各级政府要进一步加强对房地产市场的监测分析预警，深入了解市场运行情况，及时发现苗头性、倾向性问题，适时发出预警信号，指导房地产企业未雨绸缪精准应对。蒋定之说，各有关部门、市县、金融机构，要各尽所能、主动作为、多策并举、多管齐下，为房地产业发展提供良好的支持和服务。各级政府特别是领导干部要加强对房地产业的学习研究，更好地认识产业特点、把握产业规律、了解产业政策、知晓产业趋势，切实提高指导和服务房地产业发展的能力、水平。</p>\r\n<p style="font-family: 宋体, Arial, Helvetica, sans-serif; font-size: 16px; line-height: 28px;">\r\n	　　副省长王路分析了当前海南房地产业发展形势，提出了具体工作措施。省住建厅、海口市、琼海市、文昌市负责人和有关房地产企业负责人分别发言。省政府秘书长胡光辉参加座谈会。(记者彭青林)</p>', '房地产', '', '海南日报', 'recommend', '2014-06-02'),
	(218, '中国展开欧洲“购物”之旅：频繁收购工业企业', '', '<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">据《参考消息》6月1日报道，外媒称，近日，中国通过收购西欧工业企业再次引发关注。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　德国《法兰克福汇报》网站5月29日发表题为《中国人正展开欧洲购物之旅》的报道称，中国国有企业航空工业集团公司以4.73亿欧元的价格从3i金融投资公司手中买下了德国汽车零部件供应商海力达公司。海力达公司此前名为Hydraulik-Ring公司，隶属于西门子集团。上海集优机械股份有限公司以3.25亿欧元的价格从私募股权投资商吉尔德公司手中收购了荷兰紧固件供应商内德史罗夫公司。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　报道称，中国在最近几年收购了越来越多的欧洲企业，且往往是在机械制造和汽车工业领域。当然，其他行业也有收购行动。在工业政策方面，中国先是把较小的国内企业联合成大企业，现在开始了第二步，想在国际上扩张。2011年，中国在德国的收购实现了跨越式增长：根据安永会计师事务所的研究，自那以来中国企业每年收购20多家德国企业。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　报道说，这其中很多是小型交易，像2012年引起巨大轰动的交易不是很多。当时中国企业收购了德国混凝土泵制造商普茨迈斯特公司和施维英公司&mdash;两家行业内领先的供应商。此外，潍柴动力参股了德国凯傲叉车公司。</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　现在，规模更大的海力达公司也进入中国人之手。该公司生产低油耗的发动机和传动部件，年营业额约为4亿欧元。西门子集团在十多年前卖掉了这家子公司，自那以后它被多次转手。2011年3i公司以2.3亿欧元的价格从一个大财团手中买下该公司。3i公司德国经理乌尔夫&middot;冯&middot;哈克说，当时的收购没有从银行贷款，使用的完全是3i公司的自有资本。海力达公司被3i公司接掌后就扩大了亚洲业务。该公司的客户有大众、奥迪和通用等大型汽车制造商。哈克说，过去几年里海力达公司的营业额每年都增长大约15%。参与该公司竞标的只有工业企业，没有金融投资商。哈克说：&ldquo;这是从一开始就纯粹是战略买家的竞标过程。&rdquo;</span><br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<br style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;" />\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体, simsun, sans-serif, Arial; font-size: 14px; line-height: 26px;">　　在荷兰，内德史罗夫公司也被中国人买下。总部位于海尔蒙德的内德史罗夫公司为汽车和卡车提供螺栓和紧固件，它的年营业额约为5亿欧元。（编译/聂立涛）</span></p>', '工业', '聂立涛', '新华网', '', '2014-06-02'),
	(219, '机器人工厂来袭 中国工业演绎智能化风潮', '', '<ul style="margin: 0px; padding-right: 0px; padding-left: 0px; list-style-type: none; color: rgb(102, 102, 102); font-family: 宋体;">\r\n	<li class="tob_wzb_bk" style="margin: 0px; padding: 10px; list-style-type: none; text-align: left; zoom: 1; overflow: hidden; border: 2px solid rgb(204, 204, 204); background-color: rgb(247, 252, 255); display: block; color: rgb(0, 0, 0);">\r\n		<div class="wzb_bk_div" style="font-size: 14px; line-height: 20px;">\r\n			导读: 虽然现在的机器人还没法为你泡茶做饭，但在工业生产领域已广泛应用。在美德日韩等国家，机器人使用密度超过五成，一些完全自动化的无人工厂，以前要百人耗费两周的工作，现只需4人指挥，一天时间就可完成。</div>\r\n		<div class="wzb_bk_wz" style="margin-top: 4px;">\r\n			<ul style="margin: 0px; padding-right: 0px; padding-left: 0px; list-style-type: none;">\r\n				<li style="margin: 0px 5px 0px 0px; padding: 0px; list-style-type: none; display: block; float: left; line-height: 16px;">\r\n					<div class="bk_wz_gjz" style="background-image: url(http://www.ofweek.com/gongkong/images/fiber-6.gif); color: rgb(255, 255, 255); text-indent: 3px; width: 44px;">\r\n						关键字</div>\r\n				</li>\r\n				<li style="margin: 0px 5px 0px 0px; padding: 0px; list-style-type: none; display: block; float: left; line-height: 16px;">\r\n					机器人&nbsp;&nbsp;中国工业&nbsp;&nbsp;智能化&nbsp;&nbsp;</li>\r\n			</ul>\r\n		</div>\r\n	</li>\r\n	<li class="tob_wzb_lbp" style="margin: 0px; padding: 15px 0px 10px; list-style-type: none; font-size: 14px; line-height: 26px; word-break: normal; display: block; color: rgb(0, 0, 0);">\r\n		<p style="margin: 10px; padding: 0px; list-style-type: none; word-break: normal;">\r\n			　　OFweek<span class="hrefStyle"><a href="http://gongkong.ofweek.com/" style="color: rgb(146, 3, 70);" target="_blank" title="工控网">工控网</a></span>讯：变形金刚与终结者，应该只是科幻电影中的角色，但如今却要闯入我们的现实生活。6月18日，一大批代表当今智能制造领先水平的机器人将空降北京，为在新国展举行的CIMES机床展助威。</p>\r\n		<p style="margin: 10px; padding: 0px; list-style-type: none; word-break: normal;">\r\n			　　虽然现在的机器人还没法为你泡茶做饭，但在工业生产领域已广泛应用。在美德日韩等国家，机器人使用密度超过五成，一些完全<span class="hrefStyle"><a href="http://gongkong.ofweek.com/" style="color: rgb(146, 3, 70);" target="_blank" title="自动化">自动化</a></span>的无人工厂，以前要百人耗费两周的工作，现只需4人指挥，一天时间就可完成。</p>\r\n		<p style="margin: 10px; padding: 0px; list-style-type: none; word-break: normal;">\r\n			　　我们国家起步晚但速度快，据国际机器人联合会预测，中国有望在2016年成为全球最大的机器人市场，保有量将超过13万台。在此利好推动下，&ldquo;第十二届中国国际机床工具展览会&rdquo;特别开辟了&ldquo;机器人&rdquo;专区，KUKA、史陶比尔、德国ZIMMER、沈阳新松、上海众拓等全球领先的机器人制造商，将在专区展现洁净机器人、机械臂、集成系统等尖端力作，现场完成一些人类无法胜任的工作。</p>\r\n		<p style="margin: 10px; padding: 0px; list-style-type: none; word-break: normal;">\r\n			　　机器人不知疲累，拥有更高的劳动效率，在作业精度和洁度上也极为稳定，从而让厌烦简单枯燥生产的80后，有更多时间去研发创新。CIMES机床展负责人表示，&ldquo;随着用工成本上升，机器人不仅能节省企业开支，也能有效的把人口红利转化为头脑红利。&rdquo;</p>\r\n		<p style="margin: 10px; padding: 0px; list-style-type: none; word-break: normal;">\r\n			　　2014被认为是中国机器人的爆发元年，高端装备业首先刮起了机器人上岗旋风。以自主创新，打破了国外对工业机器人等多领域技术封锁的沈阳新松，就预言机器人行业将出现像苹果那样的领军名企，成为拉动经济增长的引擎。</p>\r\n		<p style="margin: 10px; padding: 0px; list-style-type: none; word-break: normal;">\r\n			　　为期五天的CIMES机床展，预计迎来30个国家的1300多家厂商。为了让观众全面领略机器人的魅力，主办方特别安排了免费巴士专线，往返于地铁天通苑北站和新国展。同期举办的&ldquo;机器人应用系列会议&rdquo;上，更将揭示机器人的未来，也许有一天，他们会走出车间进入你的生活。</p>\r\n	</li>\r\n</ul>', '工业', '', '半岛都市报', '', '2014-06-02'),
	(220, '靖州县委书记钦代寿：要坚定不移推进工业强县发展战略', '', '<div align="center" id="PrintTxt" style="margin: 0px; padding: 0px; font-family: SimSun, serif; font-size: 14px; line-height: 28px;">\r\n	<p align="center" style="margin: 0px 0px 1em; padding: 0px;">\r\n		<img src="http://images.rednet.cn/articleimage/2014/06/01/91356232.JPG" /></p>\r\n	<p align="center" style="margin: 0px 0px 1em; padding: 0px;">\r\n		县委书记钦代寿在湖南佰诺酒业有限公司调研&nbsp;&nbsp; 龙本亮 摄影</p>\r\n</div>\r\n<p>\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　红网靖州站6月1日讯(通讯员 龙本亮 滕栋)5月29日，湖南省靖州县委书记钦代寿先后来到湖南佰诺酒业有限公司、中国杨梅生态博物馆、甘太工业园等地，实地调研靖州重点项目建设进展情况，钦代寿强调：要加强工业保障、加快建设和项目招商，坚定不移推进工业强县发展战略。</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　调研中，钦代寿一行实地查看了湖南佰诺酒业有限公司生产加工情况、中国杨梅生态博物馆和工业园区建设进展情况。详细了解企业发展、项目建设过程中存在的问题和困难。</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　据悉，今年1至5月，全县上下努力克服阴雨天气、资金、征拆等影响，积极作为，重点项目进展情况总体较好，实现开工建设53个，开工率68%，累计完成投资8.13亿元，完成年度目标任务的27%，较去年增加2.7亿元，增长50%。</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　在随后召开的座谈会上，针对当前工业园区项目中存在的土地报批、林地占用指标限制、融资平台建设难度大等问题，县财政、林业、国土等部门负责人纷纷结合各自工作实际进行了发言。县领导胡宏林、粟东来分别从研究制定园区政策、规划建设布局、提升服务水平、优化发展环境、发展混合制经济等方面提出了意见和要求。</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　钦代寿强调：要坚定不移推进工业强县发展战略。一是要加强工业保障，落实园区机构、人员、政策及融资平台建设，要扩大助保贷业务，规范运作PPP联合建设模式，拓展融资渠道，允许在规范操作、手续完善的前提下，农民以土地资金入股方式投资园区建设。要落实项目上报，各部门所有上报项目必须重点围绕四大产业园区来整合项目、整合资金，捏紧拳头办大事办产业。要落实园区服务，园区代办制要落实，同时，其他部门也要搞好服务，进一步优化发展环境，要关心被征地农民的切身利益，及时解决他们的后顾之忧。二是要加快建设，要加快土地的征用和报批，加快基础设施建设和项目建设，加快招商引资。三是要实现目标，确保年初确定的投资、基建、投产、招商、纳税等目标的实现，要做到一月一调度，一季度一分析，抓实出效果。</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　</span><br style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;" />\r\n	<span style="font-family: SimSun, serif; font-size: 14px; line-height: 28px;">　　靖州县领导周文祥、梁源路、县政府副调研员蔡世发陪同调研。</span></p>', '工业', '龙本亮 滕栋', '红网', 'recommend', '2014-06-02'),
	(221, '中国汽车工业协会后市场 委员会在京成立', 'upload/images/1401670342625.jpg', '<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px; text-align: center;">\r\n	<span style="font-weight: bold; text-align: center;">中国汽车后市场委员会成立大会现场</span></p>\r\n<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	<strong>　中国汽车工业协会于2014年5月30日在<a class="firstLink" href="http://beijing.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">北京</a>会议中心召开了中国汽车后市场委员会成立大会及第一次理事会议，并举行了2013年优秀零部件出口企业的颁奖仪式，中汽协将开始在中国汽车后市场领域中发挥重要作用。</strong></p>\r\n<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	　　&ldquo;后市场委员会&rdquo;是中国汽车工业协会直属专业委员会，汽车后市场委员会将在配合政府制订汽车后市场相关政策、出台后市场相关行业管理标准、充分反映后市场相关企业诉求、维护企业权益、开展行业自律等方面发挥重要作用。中汽协常务副会长兼秘书长董扬出席会议并致辞，对后市场委员会的工作提出了要求和希望；中机联特别顾问、中汽协名誉会长张小虞到会祝贺并对汽车后市场发展提出宝贵的建议和意见。民政部、国资委等有关政府部门领导参加了会议，并对中国汽车后市场的发展提出了指导意见，国务院发展研究中心等行业专家对中国汽车市场的现状及未来做出了深度分析。中汽协师建华副秘书长针对中国汽车后市场的发展做了《汽车后市场发展现状与趋势》的主题报告， 受到参会各企业代表及行业专家的认同。</p>\r\n<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	　　作为本次会议的主要内容之一，大会通过了《后市场委员会工作条例》和选举产生了由汽车生产企业和后市场服务企业为主体构成的理事会。理事长由中国汽车工业协会副秘书长师建华出任，<a class="firstLink" href="http://db.auto.sohu.com/group_55/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">上汽集团</a>、<a class="firstLink" href="http://db.auto.sohu.com/brand_284/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">东风</a>汽车公司、中国汽车工业配件销售有限公司、北汽鹏龙等企业出任执行副理事长，特别聘请中机联特别顾问张小虞先生、中汽协常务副会长兼秘书长董扬先生为名誉理事长，委员会秘书处设在中汽协。</p>\r\n<div class="text-pic" style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	<table align="center" border="0" cellpadding="0" cellspacing="0" class="tableImg" style="margin: 10px auto; padding: 0px; border-collapse: collapse; border-spacing: 0px;">\r\n		<tbody>\r\n			<tr>\r\n				<td style="margin: 0px; padding: 0px; text-align: center;">\r\n					<img align="middle" alt="" src="http://precommendocdn.sohu.com/20140531/Img400282393.jpg" style="border: 0px;" /></td>\r\n			</tr>\r\n			<tr>\r\n				<td class="text-pic-tt" style="margin: 0px; padding: 0px; text-align: center;">\r\n					<p style="margin: 15px 0px; padding: 0px;">\r\n						<strong>&nbsp;中国汽车后市场委员会成立大会现场</strong></p>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<p>\r\n	<span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">&nbsp;&nbsp; 会议确定了中汽协后市场委员会今后将从配件供应、售后维修服务、汽车后装、</span><a class="firstLink" href="http://auto.sohu.com/s2006/qichejinrong/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;" target="_blank">汽车金融</a><span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">、</span><a class="firstLink" href="http://2sc.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;" target="_blank">二手车</a><span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">及租赁、</span><a class="firstLink" href="http://auto.sohu.com/quwen.shtml" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;" target="_blank">汽车文化</a><span style="color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">、报废回收和再制造、专业市场及其他等9大类别来开展工作。中汽协后市场委员会秘书长许海东主持了会议。</span></p>\r\n<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	　　30日下午会议分六个专题组进行了讨论，共同协商汽车后市场各专业领域未来工作方向、工作机制、核心业务、近期工作具体计划等事宜，特别是讨论开展推动本专业行业标准和规范的制定，建立行业诚信体系，开展企业评优活动，培养和树立行业内领军企业，规范行业发展等方面的工作。通过这些工作来推动各专业领域的业务具体化，实际发挥行业的协调作用，推进行业整体发展水平的提高。</p>\r\n<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	　　为进一步促进中国汽车零部件企业的转型升级，加快企业发展方式的转变，着力做大做强，提升中国汽车零部件产业的整体规模和效益，本次会议对2013年度优秀汽车零部件出口企业进行了表彰。来自中信戴卡、<a class="firstLink" href="http://ningbo.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">宁波</a>拓普、山东金麒麟、莱州三力、潍柴动力、广西玉柴、湖北恒隆、浙江骆氏、<a class="firstLink" href="http://shanghai.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">上海</a>保隆、 江正裕、浙江世宝、东启汽车、佛冈鑫统仕、广东法<a class="firstLink" href="http://db.auto.sohu.com/brand_356/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">拉达</a>、山东厚丰、<a class="firstLink" href="http://xiamen.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">厦门</a>永裕等16家企业获得了本次优秀零部件出口企业奖。</p>\r\n<p style="margin: 15px 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	　　来自<a class="notfirstlink" href="http://db.auto.sohu.com/group_55/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">上汽集团</a>、<a class="notfirstlink" href="http://db.auto.sohu.com/brand_284/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">东风</a>汽车公司、中国汽车工业配件销售有限公司、北汽鹏龙、安徽<a class="firstLink" href="http://db.auto.sohu.com/brand_235/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">江淮</a>、<a class="firstLink" href="http://db.auto.sohu.com/model_2490/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">比亚迪</a>、中国重汽、<a class="notfirstlink" href="http://db.auto.sohu.com/brand_284/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">东风</a>轻型商用车、<a class="firstLink" href="http://db.auto.sohu.com/subbrand_1087/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">东风日产</a>、<a class="notfirstlink" href="http://shanghai.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">上海</a>国际汽车零部件采购、上汽<a class="notfirstlink" href="http://2sc.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">二手车</a>平台、安吉租赁、<a class="firstLink" href="http://db.auto.sohu.com/subbrand_1074/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">一汽-大众</a>、<a class="firstLink" href="http://changchun.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">长春</a>承信<a class="notfirstlink" href="http://2sc.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">二手车</a>公司、北汽集团、北汽<a class="firstLink" href="http://db.auto.sohu.com/brand_232/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">福田</a>、<a class="firstLink" href="http://db.auto.sohu.com/search.at?suggest=%D3%A2%C2%D7" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">华晨汽车</a>、浙江<a class="firstLink" href="http://db.auto.sohu.com/brand_159/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">吉利</a>、<a class="firstLink" href="http://db.auto.sohu.com/brand_260/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">力帆</a>实业、<a class="firstLink" href="http://db.auto.sohu.com/subbrand_2011/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">长安铃木</a>、中国重汽、<a class="firstLink" href="http://zhengzhou.auto.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">郑州</a>宇通、浙江骆氏、 浙江万安、全国商用车配件产销联合会、中国汽车配件用品市场协会等国内主要汽车集团、零部件生产销售公司、以及从事汽车后市场服务相关领域企业、中汽协下属分会和各地方汽车行业协会等百余家企业和组织均<a class="firstLink" href="http://db.auto.sohu.com/model_2247/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">派</a>代表出席了本次会议。国内50余家主流媒体对本次会议给予了报导。</p>\r\n<div class="text-pic" style="margin: 0px; padding: 0px; color: rgb(51, 51, 51); font-family: 宋体; font-size: 14px; line-height: 24px;">\r\n	<table align="center" border="0" cellpadding="0" cellspacing="0" class="tableImg" style="margin: 10px auto; padding: 0px; border-collapse: collapse; border-spacing: 0px;">\r\n		<tbody>\r\n			<tr>\r\n				<td style="margin: 0px; padding: 0px; text-align: center;">\r\n					<img align="middle" alt="" src="http://precommendocdn.sohu.com/20140531/Img400282394.jpg" style="border: 0px;" /></td>\r\n			</tr>\r\n			<tr>\r\n				<td class="text-pic-tt" style="margin: 0px; padding: 0px; text-align: center;">\r\n					&nbsp;<strong>讲述<a class="notfirstlink" href="http://2sc.sohu.com/" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">二手车</a><a class="firstLink" href="http://dealer.auto.sohu.com/dealermap/index.shtml" style="cursor: pointer; text-decoration: none; color: rgb(51, 51, 51);" target="_blank">经销商</a>身边的变化</strong></td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '工业', '王晓明', '搜狐二手车', 'recommend', '2014-06-02'),
	(222, '重庆1-4月外资工业企业331家 完成工业总产值1531亿元', '', '<p style="font-size: 16px; line-height: 21.328125px; font-family: 宋体;">\r\n	&nbsp; 重庆频道消息 5月29日重庆市经信委发布消息，1-4月全市规模以上外资工业继续保持平稳增长，截止4月底，全市共有规模以上外资工业企业331家，完成工业总产值1531.3亿元，同比增长19.8%，高出全市规上工业总产值4.8个百分点。</p>\r\n<p style="font-size: 16px; line-height: 21.328125px; font-family: 宋体;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;数据显示，规上外资工业企业中，汽车产业支撑作用明显，电子信息产业持续发挥第一驱动力作用。</p>\r\n<p style="font-size: 16px; line-height: 21.328125px; font-family: 宋体;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;六大主要行业中，电子信息行业1-4月外资工业总产值占比43.67%，汽摩行业外资工业总产值占比32.66%，两大行业共占比76.33%，继续领跑六大主要行业。化医行业规模最小，占比2.44%。汽摩产业增长最快，同比增长35.8%；电子产业增长第二，同比增长为19.6%。六大主要行业同比增长19.4%。</p>\r\n<p style="font-size: 16px; line-height: 21.328125px; font-family: 宋体;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;同时，1-4月，重庆外资工业销售值1504.58亿元，同比增长20.2%；工业产品销售率达到98.3%，同比增长0.4%；实现出口交货值为626.27 亿元，同比增长28.5%。</p>\r\n<p style="font-size: 16px; line-height: 21.328125px; font-family: 宋体;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;另外一个重要特点是，外资在重庆市工业的投入明显集中于重工业。1-4月，全市规模以上外资轻工业总产值为181.72亿元，规模以上外资重工业总产值为1349.58亿元，轻重工业比重为1：7。</p>', '工业', '', '早报网', '', '2014-06-02'),
	(223, '我市推进工业强镇壮大工业经济', '', '<p class="describe" style="margin: 0px 0px 20px; padding: 9px; border: 1px solid rgb(238, 238, 238); line-height: 24px; color: rgb(85, 85, 85); text-indent: 2em;">\r\n	提示：&nbsp;市经信委统计数据显示，到2013年底，全市规上工业超10亿元以上的工业乡（镇、街道）73个，超20亿元以上的工业乡（镇、街道）46个，累计实现规上工业产值2950亿元，占全市规上工业的67%；工业强镇完成工业投资约480亿元，占全市工业投资的72%；全市规上工业超10亿元以上的工业乡（镇、街道）实现工业税金约220亿元，占全部财政收入的53%。</p>\r\n<div class="article-content fontSizeBig BSHARE_POP" style="margin: 0px; padding: 0px;">\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		本报消息（记者 王妃）市经信委统计数据显示，到2013年底，全市规上工业超10亿元以上的工业乡（镇、街道）73个，超20亿元以上的工业乡（镇、街道）46个，累计实现规上工业产值2950亿元，占全市规上工业的67%；工业强镇完成工业投资约480亿元，占全市工业投资的72%；全市规上工业超10亿元以上的工业乡（镇、街道）实现工业税金约220亿元，占全部财政收入的53%。</p>\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		今年2月，我市加大对工业强镇的政策扶持力度，专门出台《关于推进工业强镇（乡、街道）建设的意见》，实施工业强镇（乡、街道）建设三年计划，力争到2016年全市规模以上工业总产值超20亿元的镇（乡、街道）达到50个，其中超50亿元的镇（乡、街道）30个、超100亿元的镇（乡、街道）8个、超200亿元的镇（乡、街道）两个。</p>\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		近期，普洛股份总部和得邦制药销售总部回迁东阳市横店镇，并落户电子产业园，极大地提升了横店的医药化工产业实力。</p>\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		多年来，为将该园区打造成电子产业的&ldquo;聚宝盆&rdquo;，横店镇采取全员招商、亲情招商、以企引企等方式，加大招商引资力度。2013年，该镇实际到位内资5.1亿元，较上年增长138.3%；引进外资600万美元（2012年引进外资为零）。园区二期招商引进34家企业，目前已全部开工建设，19家已投产。在优惠政策的激励和配套措施的推动下，今年1至4月，园区相继引进内资8000万元。</p>\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		位于婺城区乾西乡工贸区的金华市泰元包装材料有限公司近期正在加紧规划如何采取&ldquo;以机器换人&rdquo;、&ldquo;零增地技改&rdquo;等举措，实现产业的提档升级。</p>\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		通过整体提升企业低效闲置资源，引导企业经营者转变发展理念，激发企业&ldquo;零增地&rdquo;技改热情，倡导企业实施&ldquo;退二进三&rdquo;、推进土地二次利用等，乾西乡的工业企业规模得到较好提升，企业效益得到明显提高。据介绍，今年将有5家企业在乾西乡栅川工业园落地，总占地面积约124.8亩，计划总投资约4.42亿元，其中两家为计划总投资亿元以上企业。同时，该乡还完成旧厂区改造23194平方米，拆除落后生产线9条、电镀槽容积279.2立方米。</p>\r\n	<p style="margin: 0px 0px 14px; padding: 0px; text-indent: 2em; color: rgb(51, 51, 51); line-height: 30px; font-size: 16px;">\r\n		在乾西乡党委书记戴忠余看来，虽然不可避免地要涉及工业企业的短期利益，工业发展近期可能要牺牲部分GDP，但实现了减污增效的工业会更加健康和富有活力。&ldquo;&lsquo;四破&rsquo;整治是一场攻坚战，金华工业转型发展必须跨过这道坎，工业强镇就是要将&lsquo;四破&rsquo;的力度、经济的稳定和企业的承受力有效结合，注重以新的增量来解决制约工业发展的短板问题。&rdquo;市经信委相关负责人说。</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '工业', '王妃', '金华日报', '', '2014-06-02'),
	(224, '一季度我国工业自动化系统装置收入超706亿元', '', '<div class="tuwen" style="padding: 0px; margin: 0px auto; outline: none; border-width: 0px; width: 555px; height: auto; color: rgb(51, 51, 51); font-family: 宋体; line-height: 18px;">\r\n	<p style="padding: 0px; margin: 20px 0px 0px; border-width: 0px;">\r\n		　　根据上海仪器仪表行业协会发布的最新数据显示，2014年1-3月我国工业自动化控制系统装置制造主营收入7067872万元。中国拥有世界最大的工业自动控制系统装置市场，传统工业技术改造、工厂自动化、企业信息化需要大量的工业自动化系统，市场前景广阔。工业控制自动化技术正在向智能化、网络化和集成化方向发展。基于工业自动化控制较好的发展前景，预计2015年工业自动控制系统装置制造行业市场规模将超过3500亿元。尽管全球工业制造业增长疲软，中国自动化控制市场依然将保持较快增长。IMSResearch最新的研究报告指出：包括可编程控制器、机器视觉、人机界面、伺服和步进驱动器、中低压马达驱动器和工业计算机在内的中国自动化控制系统市场规模在2013年将会达到1311亿元，整个中国自动化控制系统市场的年复合增长率在12%左右，其中PLC设备市场达到140亿元我国工控行业在国家政策扶持、人力成本上升、技术实力偏低等众多因素的刺激下，积极进行产业转型升级。另外，教学专用仪器制造行业实现8.13%的利润率，供应用仪表及其他通用仪器制造为7.83%，运输设备及生产用计数仪表制造利润率为7.75%。上述三个子行业为仪器仪表行业利润率最高。地质勘探和地震专用仪器制造行业利润总额出现负值，利润率实现负增长。</p>\r\n</div>\r\n<div class="tu-1" style="padding: 0px; margin: 0px auto; outline: none; border-width: 0px; color: rgb(51, 51, 51); font-family: 宋体; line-height: 18px;">\r\n	&nbsp;</div>', '工业', '', '北极星电力网', '', '2014-06-02'),
	(225, '机械工业企业对市场 景气回升预期不高', '', '<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	中国机械工业联合会执行副会长蔡惟慈5月28日指出，今年前4个月，我国机械工业延续了去年温和增长的势头，但产业增加值等一些关键性指标呈逐月回落态势，机械工业企业不应对后期走势盲目乐观，要对可能出现的困难保持警惕。</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	&ldquo;在当前宏观经济偏冷的形势下，机械工业的主要经济指标明显好于全部工业的平均水平。&rdquo;蔡惟慈表示，尽管亮点颇多，但从4月份开始，机械工业的多项经济指标开始出现增速回落的势头，给正在回暖的行业带来了一丝寒意。</p>\r\n<p style="text-indent: 1.5em; font-size: 14px; line-height: 19px; background-color: rgb(247, 250, 255);">\r\n	1至4月，我国机械工业完成固定资产投资10383亿元，同比增长14．14％，与去年同期16．56％的增幅相比，回落了2．42个百分点。&ldquo;可见，机械工业企业对未来市场景气回升的预期不高，投资需求不容乐观。&rdquo;蔡惟慈表示。</p>', '工业', '', '中国日报网', '', '2014-06-02'),
	(226, '苗圩：我国将采取五大措施推动软件产业升级', '', '<p style="margin: 15px 0px 0px; padding: 0px;">\r\n	&nbsp;新华社北京５月２９日电（记者刘菊花）工业和信息化部部长苗圩２９日表示，我国将采取优化产业发展环境、鼓励企业创新发展、加快拓展应用市场、持续培育龙头企业、大力发展生产性服务业等五大措施促进软件产业升级，全面提升软件产业对经济社会发展和维护网络信息安全的支撑服务能力。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;苗圩在第十八届中国国际软件博览会上表示，近年来我国软件产业虽然发展迅速，产业规模不断扩大，企业竞争力不断提升，但产业整体上处于价值链中低端，缺乏全球领先地位的大企业。未来一段时期是我国软件产业转型发展的关键时期，软件产业正加快向网络化、服务化、体系化、融合化方向发展，云计算、物联网、移动互联网等新型业态层出不穷，而加快经济发展方式转变和提质增效升级、促进信息化与工业化深度融合，对软件产业的支撑保障能力也提出了更高要求。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;苗圩表示，下一步我国将加大软件产业相关行政审批事项取消下放力度，加快重点软件标准制定，做好软件正版化和知识产权保护工作。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;此外，我国将加快移动智能终端操作系统、移动互联网、智能语音、云计算服务、大数据等新兴领域发展，促进信息安全技术和产业发展，鼓励企业间建立以产业链为基础的合作机制和产业联盟。在重点领域开展安全可靠信息系统应用示范，提高国家信息安全保障能力。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;另外，我国将综合运用政策、规划、标准、资金等多种手段，引导支持优势企业兼并重组、做大做强，推动形成一批具有国际竞争力的大企业，并支持一批&ldquo;专精特新&rdquo;中小企业，形成全产业链协同发展格局。</p>\r\n<p style="margin: 15px 0px 0px; padding: 0px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;苗圩透露，我国将推动面向制造业的生产性服务业剥离，面向行业和社会提供专业化服务，并引导和支持有条件的园区创建以生产性服务业为特色的新型工业化产业示范基地，适时启动生产性服务业试点示范城市创建。</p>\r\n<div>\r\n	&nbsp;</div>', '软件', '', '新华社', 'recommend', '2014-06-02'),
	(227, '中国工业企业品牌竞争力年度评价结果揭晓 南通工业博览城获称中国工业先锋示范单位', '', '<table align="right" border="0" cellpadding="0" cellspacing="0" style="color: rgb(43, 43, 43); font-family: 宋体; font-size: 14px; line-height: 25px;" width="99%">\r\n	<tbody>\r\n		<tr>\r\n			<td align="center" colspan="2" style="font-size: 12px; margin: 0px; padding: 6px; border-style: solid; border-color: rgb(204, 204, 204);">\r\n				<span style="color: rgb(204, 0, 0);">&ldquo;无线南通，城市在你我手中！&rdquo;</span>欢迎安装南通报业&ldquo;无线南通&rdquo;手机客户端！苹果手机App&nbsp;store搜索&ldquo;无线南通&rdquo;下载。安卓系统手机可通过360手机助手下载，还可扫描二维码或登录<span style="color: rgb(20, 86, 160);">南通网官网（<a href="http://app.zgnt.net/" style="color: rgb(43, 43, 43); text-decoration: none;" target="_blank">wx.zgnt.net</a>）下载</span>。</td>\r\n		</tr>\r\n		<tr>\r\n			<td align="left" colspan="3" height="50" style="margin: 0px; padding: 15px 8px 8px;">\r\n				<p align="left" style="margin: 0px 3px 15px; padding: 0px; line-height: 30px; text-indent: 30px;">\r\n					南通网讯 由国家工信部、中国工业经济联合会、中国工业报社、中国航空综合技术研究所举办的2013年度中国工业企业品牌竞争力评价结果近日揭晓。南通工业博览城荣获&ldquo;中国工业先锋示范单位&rdquo;称号，该企业董事长林思荣与中星微电子董事长邓中翰等同获&ldquo;中国工业十大杰出青年&rdquo;称号。</p>\r\n				<p align="left" style="margin: 0px 3px 15px; padding: 0px; line-height: 30px; text-indent: 30px;">\r\n					南通工业博览城是华东地区五金机电博览交易中心和南通发展现代服务业的重点项目。近年来，他们抓住国家大力发展生产性服务业，促进工业转型升级的战略机遇，利用长三角地区加速推进工业化、城镇化和现代化的良好契机，乘势打造国家级&ldquo;2.5产业&rdquo;创新示范项目，加快制造业与服务业的深度融合，助推工业经济转型升级取得积极成果。据悉，南通工业博览城后续项目将重点打造工程机械、工业设备、通用航空、高级游艇、光伏产品等市场集群，同时建设国际会展中心、中国工业品网络交易中心、中国工业经济论坛长三角会议中心、中国工业博物馆等大型设施。此次入选&ldquo;中国工业先锋示范单位&rdquo;实至名归。</p>\r\n				<p align="left" style="margin: 0px 3px 15px; padding: 0px; line-height: 30px; text-indent: 30px;">\r\n					据了解，在本届&ldquo;中国工业年度人物&rdquo;评选活动中，福田雷沃重工王桂民、广西柳工增光安、南通铁人黄承斌等15人入选&ldquo;中国工业先锋人物&rdquo;，格力集团董明珠、玖龙纸业张茵入选&ldquo;中国工业十大杰出女性&rdquo;。 国顺 天雄</p>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '工业', '', '南通网', '', '2014-06-02'),
	(228, '缙云工业经济要举大旗走新路', '', '<p style="color: rgb(87, 87, 87); font-family: 宋体; font-size: 14px; line-height: 23px;">\r\n	　<strong>缙云新闻网讯&nbsp;</strong>5月28日，副市长陈重一行到缙云调研指导工业经济发展情况。调研中，陈重指出，缙云县要采取有力举措，在工业经济发展上继续领跑全市，努力推动工业经济平稳健康发展。</p>\r\n<p style="color: rgb(87, 87, 87); font-family: 宋体; font-size: 14px; line-height: 23px;">\r\n	　　近年来，缙云深入实施工业强县战略，形成了机械装备、电器电子、建材、汽摩配四大主导产业。去年，工业总产值达461.5亿元，总量连续13年位居全市首位。</p>\r\n<p style="color: rgb(87, 87, 87); font-family: 宋体; font-size: 14px; line-height: 23px;">\r\n	　　调研中，陈重对缙云在工业经济发展方面取得的成绩给予了充分肯定，他指出，缙云工业经济总量领先、产业特色鲜明、转型升级步伐坚定、招商引资有力、工业运行机制科学。</p>\r\n<p style="color: rgb(87, 87, 87); font-family: 宋体; font-size: 14px; line-height: 23px;">\r\n	　　陈重指出，缙云工业经济要举大旗、走新路，要举生态工业的大旗，走创新驱动、创新发展的新路；要抓两头、带中间，要高度重视招商引资和困难企业的帮扶工作，通过四换三名等举措助推带动中小企业的发展；要盯项目、促投资，要采取有效举措，在促进项目的落地、投产上多花精力；要排隐患、优环境，要加大力度排查资金、环保、安全生产等各方面的风险和隐患，同时要不断优化发展环境，为企业和客商提供更好的服务。</p>\r\n<p style="color: rgb(87, 87, 87); font-family: 宋体; font-size: 14px; line-height: 23px;">\r\n	　　县领导吴筱琳、楼锦游以及市县有关部门负责人等陪同。</p>', '工业', '陈魁', '中国缙云新闻网', '', '2014-06-02'),
	(229, '4月份中国工业增长8.7%验证外贸企稳态势', 'upload/images/1401671347468.jpg', '<p style="margin: 1em auto; padding: 0px; font-family: simsun; font-size: 14px; line-height: 30px;">\r\n	5月13日，中国国家统计局发布数据显示，2014年4月份，中国规模以上工业增加值同比实际增长8.7%，比3月份回落0.1个百分点，较去年同期回落0.6个百分点。从环比看，4月份比上月增长0.82%。1-4月份，中国规模以上工业增加值同比增长8.7%。在3月份的反弹后，中国工业增速4月份再度回落。不过当月，反映出口热度的工业企业出口交货值增速较3月份继续放大，验证了中国外贸企稳回升的判断。资料图为山西太钢冷轧厂。</p>\r\n<p style="margin: 1em auto; padding: 0px; font-family: simsun; font-size: 14px; line-height: 30px;">\r\n	<strong>IPO动态</strong></p>\r\n<p style="margin: 1em auto; padding: 0px; font-family: simsun; font-size: 14px; line-height: 30px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;IPO发行启动在即，34家过会企业严阵以待，预披露增2家。</p>', '工业', '', '证券日报', 'recommend', '2014-06-02'),
	(230, '于言良到朝阳县调研工业产业集群和重点项目建设', '', '<p>\r\n	<span style="font-size: 14px; line-height: 22px; widows: 2; text-indent: 10px; orphans: 2;">&nbsp;本报讯 (记者 吕丽华)5月29日上午，市长于言良到朝阳县就产业集群和今年重点项目建设情况进行调研。他指出，要坚定不移地抓好重点项目建设，按照全市工业园区基础设施和产业集群建设年活动要求，不断壮大有色金属产业集群规模，推动朝阳县工业经济健康快速发展。市委常委、副市长武永存和有关部门负责人参加。</span><br style="font-size: 14px; line-height: 22px; padding: 0px; widows: 2; text-indent: 10px; margin: 0px; orphans: 2;" />\r\n	<span style="font-size: 14px; line-height: 22px; widows: 2; text-indent: 10px; orphans: 2;">　　&nbsp; 今年以来，朝阳县按照&ldquo;工业发展园区化、园区发展产业化、产业发展集群化、集群发展特色化&rdquo;的思路，深入组织开展园区基础设施和产业集群建设年活动，加快推进有色金属产业集群发展。并坚持项目第一理念，狠抓项目推进工作。目前，有色金属产业集群的基础设施建设和园区项目建设正在积极推进，全县工业经济呈现稳中有增的良好势头。</span><br style="font-size: 14px; line-height: 22px; padding: 0px; widows: 2; text-indent: 10px; margin: 0px; orphans: 2;" />\r\n	<span style="font-size: 14px; line-height: 22px; widows: 2; text-indent: 10px; orphans: 2;">　 　 调研期间，于言良视察了朝阳百盛钛业公司钛锭项目和朝阳东鑫有色金属公司精炼镍项目、朝阳华龙科建公司煤矸石建材项目、朝阳天亿机械公司二期项目的建设现场及朝阳县青年创业孵化基地电子商务项目、台子镇横河子旅游观光采摘基地项目等，详细了解工业园区、产业集群建设及重点项目进展情况，协调解决项目推进难题，并对下步工作提出指导性意见。</span><br style="font-size: 14px; line-height: 22px; padding: 0px; widows: 2; text-indent: 10px; margin: 0px; orphans: 2;" />\r\n	<span style="font-size: 14px; line-height: 22px; widows: 2; text-indent: 10px; orphans: 2;">　　&nbsp; 于言良指出，各地、各部门要充分认识我市今年开展的工业园区基础设施和产业集群建设年活动的重要意义，进一步提升工业园区的基础设施水平，做大现有产业集群规模，加快形成产业集聚效应，提高区域综合竞争力。朝阳县要坚定不移地抓工业经济发展，结合建设年活动，继续加快推进工业园区基础设施和产业集群建设，把有色金属产业集群做大做强。要制定园区长远发展目标，按照总体规划科学摆布项目，做好园区基础设施配套等各项工作。要统筹推进有色金属产业集群的核心项目建设，加大科技研发力度，积极抢占市场，不断扩大产能，搞好精深加工，接长产业链条，壮大集群规模，不断提高市场竞争力。要充分发挥资源优势和现已形成的产业优势，围绕有色金属产业集群、新县城、农业产业化、房地产开发和文化旅游等重点领域大力开展招商引资。要加强园区管理体制、机制创新，提高工作效率。市委市政府和相关部门单位将全力支持朝阳县的工业园区基础设施和产业集群建设，推动朝阳县工业经济健康快速发展。同时，朝阳县还要加快推进电子商务发展，认真学习借鉴外地经验，不断解放思想，创新发展理念，努力把电子商务作为一项战略性新兴产业加快培育；要完善旅游观光采摘基地基础配套设施，努力把它打造成一个集旅游观光、休闲娱乐为一体的旅游风景区。</span></p>', '工业', '', '朝阳日报-燕都晨报', '', '2014-06-02'),
	(231, '我国机械工业一季度经济效益指标分析', '', '<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	&nbsp; &nbsp;<a class="recommendlinkmode" href="http://www.plas.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">慧聪塑料网</a>讯：作为我国国民<a class="recommendlinkmode" href="http://www.finance.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">经济</a>的支柱之一，<a class="recommendlinkmode" href="http://www.machine.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">机械工业</a>的发展脚步从未停歇。经过半个多世纪的努力，中国机械工业已逐步发展成为具有一定综合实力的制造业，初步确立了在国民经济中的支柱地位。2014年以来，我国机械工业继续保持平稳发展态势。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	　　统计数据显示，1~3月，全国机械工业各项主要经济效益指标表现如下：总资产贡献率为13.18%，较全国工业(12.72%)高0.46个百分点;流动资产周转率为1.94次，较全国工业(2.38次)低0.44次;成本费用利润率为7.01%，较全国工业(5.81%)高1.2个百分点;主营业务收入利润率为6.5%，较全国工业(5.4%)高1.1个百分点，主营活动利润率6.16%，较全国工业(5.36%)高0.8个百分点。3月末，资本保值增值率114.16%，资产负债率为55.63%。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	　　前3个月，全国机械工业全行业共实现利润总额3114.55亿元，同比增长22.81%，增速较1~2月(29.24%)回落6.43个百分点。3月份，实现利润总额1281.67亿元，同比增长14.65%。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	　　1~3月，全国机械工业全行业实现主营活动利润2952.12亿元，同比增长7.21%，增速较1~2月(12.15%)回落4.94个百分点。3月份实现主营活动利润1203.19亿元，同比增长0.77%。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	　　今年一季度，在机械工业的13个大行业中，除<a class="recommendlinkmode" href="http://www.food.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">食品</a>包装机械行业利润总额同比下降(-1.49%)外，其余12个行业利润总额同比均增长。在利润总额同比增长的行业中，增速较1~2月回落的行业有10个，其中<a class="recommendlinkmode" href="http://www.cm.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">工程机械</a>行业利润总额同比增速回落最大，1~3月同比增长4.87%，增速较1~2月(40.83%)回落35.96个百分点。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	　　从行业利润贡献率看，1~3月，<a class="recommendlinkmode" href="http://www.auto.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">汽车</a>行业实现利润总额达1365.99亿元，同比增长29.36%，利润贡献率为53.6%，对机械行业利润增长贡献最大，非汽车行业实现利润总额1748.56亿元，对机械全行业利润贡献率为46.4%。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	　　当前中国机械工业行业正处在一个稳中有忧的时期。虽然去年中国机械工业行业总体运行平稳，实现了缓慢回升、温和增长，但是中国机械工业仍未进入良性发展的轨道，稳增长保全局仍是今年行业发展的第一要务。</p>\r\n<p align="center" style="margin: 10px 0px; padding: 0px; font-family: 宋体; font-size: 14px; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	<img alt="3" border="0" src="http://img01.hc360.com/plas/201401/201401151013566076.jpg" style="margin: 0px; padding: 0px; border: 0px;" /></p>\r\n<p align="left" style="margin: 10px 0px; padding: 0px; font-family: 宋体; line-height: 24px; background-color: rgb(245, 248, 253);">\r\n	&nbsp;<a href="http://www.plas.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; font-size: 14px;" target="_blank"><img src="http://style.org.hc360.com/css_hy/images/end_logo/hc_logo_end.jpg" style="margin: 0px; padding: 0px; border: 0px;" /></a></p>', '工业', '', '中国塑料机械网', '', '2014-06-02'),
	(232, '1-4月广东工业企业利润增长25.7%', '', '<p style="margin: 15px 0px; padding: 0px; font-size: 14px; line-height: 23px; color: rgb(51, 51, 51); font-family: 宋体;">\r\n	　南方日报讯（记者/黄应来）广东省统计局发布的数据显示，2014年1-4月，广东规模以上工业企业实现利润总额1562.97亿元，同比增长25.7%，增幅比一季度回落了1.0个百分点，比上年同期提高1.7个百分点，其中主营活动利润1448.69亿元，增长26.2%。</p>\r\n<p style="margin: 15px 0px; padding: 0px; font-size: 14px; line-height: 23px; color: rgb(51, 51, 51); font-family: 宋体;">\r\n	　　从经济区域看，1-4月，21个地级市中，除韶关和惠州市外，其他19个市利润实现增长。四大经济区域中，珠三角实现利润1259.99亿元，增长25.2%，增幅比一季度回落1.0个百分点；东翼实现利润141.42亿元，增长35.9%，增幅比一季度回落7.5个百分点；西翼实现利润88.00亿元，增长24.9%，增幅比一季度提高0.9个百分点；山区实现利润73.56亿元，增长17.8%，增幅比一季度提高6.0个百分点。</p>\r\n<p style="margin: 15px 0px; padding: 0px; font-size: 14px; line-height: 23px; color: rgb(51, 51, 51); font-family: 宋体;">\r\n	　　从经济类型看，1-4月，国有控股企业实现利润319.48亿元，增长14.4%，增幅比一季度回落2.5个百分点；外商及港澳台商投资企业实现利润752.37亿元，增长14.4%，增幅比一季度提高0.7个百分点；股份制企业实现利润659.42亿元，增长42.1%，增幅比一季度回落1.7个百分点；民营企业实现利润632.57亿元，增长49.7%，增幅比一季度回落4.9个百分点。</p>\r\n<p style="margin: 15px 0px; padding: 0px; font-size: 14px; line-height: 23px; color: rgb(51, 51, 51); font-family: 宋体;">\r\n	　　从行业大类看， 1-4月，在40个工业大类行业中，利润总额同比增长的行业32个。新增利润较多的前5个行业分别是：计算机、通信和其他电子设备制造业增加101.67亿元，同比增长70.0%；汽车制造业增加33.08亿元，同比增长56.6%；非金属矿物制品业增加23.86亿元，同比增长55.3%；电力热力生产和供应业增加20.18亿元，同比增长15.0%。5个行业新增利润合计占全部规模以上工业企业新增利润的73.4%。</p>\r\n<p style="margin: 15px 0px; padding: 0px; font-size: 14px; line-height: 23px; color: rgb(51, 51, 51); font-family: 宋体;">\r\n	　　企业亏损面和亏损额增幅缩小。1-4月，全省规模以上工业企业39506家，亏损企业8982家，企业亏损面为22.7%，比一季度收窄3.0个百分点。亏损企业亏损额232.30亿元，同比增长1.9%，增幅比一季度收窄5.6个百分点。</p>', '工业', '', '南方日报', '', '2014-06-02'),
	(233, '1至4月份全省工业经济效益情况', 'upload/images/1401671672343.jpg', '<table align="center" border="0" height="890" width="100%">\r\n	<tbody>\r\n		<tr>\r\n			<td align="center" class="title" colspan="2" height="40" style="font-family: 黑体; font-size: 24px; line-height: 30px; font-weight: bold;">\r\n				1至4月份全省工业经济效益情况</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="blue12" colspan="2" height="20" style="line-height: 22px; color: rgb(0, 101, 156);">\r\n				<div align="center" style="margin: 0px; padding: 0px; border: 0px;">\r\n					2014-05-30 14:36:51&nbsp;　来源：&nbsp;省统计局</div>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td class="black12" colspan="2" height="15" style="line-height: 24px;" valign="middle">\r\n				<div align="center" style="margin: 0px; padding: 0px; border: 0px;">\r\n					&nbsp;</div>\r\n			</td>\r\n		</tr>\r\n		<tr>\r\n			<td colspan="2" valign="top">\r\n				<table border="0" cellpadding="0" cellspacing="0" width="100%">\r\n					<tbody>\r\n						<tr>\r\n							<td class="black14" style="font-size: 14px; line-height: 24px; color: rgb(71, 71, 71);">\r\n								<p>\r\n									　　1&mdash;4月份，全省规模以上工业企业总体效益降幅有所收窄。实现利税671.0亿元，同比下降11.0%，其中利润291.0亿元，下降11.9%，下降幅度分别比上月末收窄0.6和1.3个百分点；实现主营业务收入3537.7亿元，下降3.5%,降幅比上月末收窄0.1个百分点；亏损企业1093户，亏损面26.4%，亏损企业亏损额89.1亿元，减亏8.7%，比上月末收窄2.5个百分点。</p>\r\n								<p>\r\n									　　1&mdash;4月份，全省规模以上地方工业企业实现利税122.1亿元，同比下降13.1%，其中利润53.2亿元，下降14.0%；主营业务收入2092.8亿元，下降4.1%；亏损企业1053户，亏损面26.0%，亏损企业亏损额62.8亿元，增亏17.0%。全省地方企业总体效益比上月有所下滑，主要是受煤炭开采和洗选业影响。</p>\r\n								<p>\r\n									　　附件：全省规模以上工业经济效益指标</p>\r\n								<div align="center" style="margin: 0px; padding: 0px; border: 0px;">\r\n									<div align="center" style="margin: 0px; padding: 0px; border: 0px;">\r\n										&nbsp;</div>\r\n								</div>\r\n							</td>\r\n						</tr>\r\n					</tbody>\r\n				</table>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	&nbsp;</p>', '工业', '', '黑龙江省省统计局', 'recommend', '2014-06-02'),
	(234, '2013年度中国机械工业百强企业排行榜揭晓', 'upload/images/1401671830562.jpg', '<div class="daodu" style="margin: 10px 0px; padding: 8px 10px; background-image: none; background-attachment: scroll; background-color: rgb(247, 247, 247); border-bottom-width: 1px; border-bottom-style: solid; border-bottom-color: rgb(229, 229, 229); border-top-width: 1px; border-top-style: solid; border-top-color: rgb(229, 229, 229); color: rgb(102, 102, 102); font-family: 宋体; line-height: 22px; background-position: 0% 0%; background-repeat: repeat repeat;">\r\n	<strong style="margin: 0px; padding: 0px;">导读：</strong>2013年国内外经济形势错综复杂，机械工业运行困难明显增多，转变发展方式的压力急遽加大。在此背景下，机械工业贯彻落实中央关于&ldquo;稳中求进&rdquo;的工作要求，全力以赴稳增长、调结构、促改革，实现了全行业的缓慢回升、温和增长和平稳发展，产销、效益等主要经济指标均实现了适度增长。</div>\r\n<div class="content" style="margin: 0px; padding: 0px; font-size: 14px; font-family: 宋体; line-height: 22px;">\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		<span style="margin: 0px; padding: 0px; color: rgb(255, 0, 0);"><strong style="margin: 0px; padding: 0px;">【中国<a class="keylink" href="http://www.lmjx.net/lmjx/" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">路面机械</a>网 整理】</strong></span>2013年国内外经济形势错综复杂，机械工业运行困难明显增多，转变发展方式的压力急遽加大。在此背景下，机械工业贯彻落实中央关于&ldquo;稳中求进&rdquo;的工作要求，全力以赴稳增长、调结构、促改革，实现了全行业的缓慢回升、温和增长和平稳发展，产销、效益等主要经济指标均实现了适度增长。同时在<a class="keylink" href="http://marketing.lmjx.net/" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">市场</a>倒逼机制作用下，结构调整与转型升级的步伐正在加速。其中，一批行业龙头企业起到了中坚和骨干作用。</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		为继续反映机械大企业过去一年的发展成果，激励行业企业加快结构调整、推进转型升级，中国机械工业联合会根据2013年机械企业主要<a class="keylink" href="http://tongji.lmjx.net/" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">统计</a><a class="keylink" href="http://tongji.lmjx.net/" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">数据</a>，排定了新一届机械工业百强企业座次。</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		据了解，自2004年开始发布第一届中国机械工业百强企业名单以来，至今这项活动已经成功举办十届，成为社会影响广泛、深受行业企业欢迎、示范作用很强的行业<a class="keylink" href="http://marketing.lmjx.net/List_136.shtml" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">品牌</a>活动。连续十年采集和发布机械百强企业信息，旨在反映中国装备制造企业不断提升综合竞争力的成长历程，反映入选企业在产业发展中的作用和地位，有助于社会各界了解我国机械工业的发展业绩，有助于提高全社会对机械行业中大企业的认知，便于与国际同类大企业进行实力对比，同时，也希望藉此为政府有关部门制定国家和区域产业政策提供有效依据。</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		<span style="margin: 0px; padding: 0px; color: rgb(255, 0, 0);"><strong style="margin: 0px; padding: 0px;">现在小编就百强机械企业中以<a class="keylink" href="http://www.lmjx.net/" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">工程机械</a>为主营<a class="keylink" href="http://marketing.lmjx.net/List_134.shtml" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">业务</a>的企业名单整理如下：</strong></span></p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-align: center;">\r\n		<img alt="" src="http://img.lmjx.net/news/uploadfile/2014/0530/20140530025131712.jpg" style="margin: 0px; padding: 0px; border: 0px none; width: 558px; height: 547px;" /></p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		<span style="margin: 0px; padding: 0px; color: rgb(255, 0, 0);"><strong style="margin: 0px; padding: 0px;">机械工业百强企业&bull;十年发展突出贡献奖名单（排名不分先后）：</strong></span></p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		1. 中国机械工业集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		2. 潍柴控股集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		3. 徐州<a class="keylink" href="http://www.lmjx.net/" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">工程机械</a>集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		4. 上海电气（集团）总公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		5.&nbsp;<a class="keylink" href="http://zj.lmjx.net/zj_company_0_0_0_3.html" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">中联重科</a>股份有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		6.&nbsp;<a class="keylink" href="http://zj.lmjx.net/zj_company_0_0_0_4.html" style="margin: 0px; padding: 0px; color: rgb(0, 68, 153);" target="_blank">三一</a>集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		7. 中国东方电气集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		8. 新疆特变电工集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		9. 正泰集团股份有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		10. 许继集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		11. 中信重工机械股份有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		12. 沈阳鼓风机集团股份有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		13. 海天塑机集团有限公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		14. 瓦房店轴承集团有限责任公司</p>\r\n	<p style="margin: 10px 0px 0px; padding: 0px; line-height: 25px; text-indent: 2em;">\r\n		15. 陕西鼓风机（集团）有限公司(本文来自中国路面机械网)</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '工业', '', '中国路面机械网', 'recommend', '2014-06-02'),
	(235, '白银工业属性远超黄金', '', '<p>\r\n	<span style="font-family: 宋体, tahoma, Helvetica, arial, sans-serif; font-size: 14px; line-height: 24px;">&nbsp;白银既有金融属性，也有商品属性，银价涨跌幅往往远高于金价。和黄金相比，白银具有更强的工业属性，其价格与实体经济的关系更加紧密。一般而言，白银价格长期受供需关系和全球经济状况等宏观因素影响，短期则容易受到黄金、美元、原油、股指和突发事件等诸多因素影响。</span></p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;一是供给和需求。国际白银协会的统计数据显示，白银的需求构成与黄金明显不同，其工业需求占比为55%，首饰需求和银币奖章等需求占比仅为31%;黄金的工业需求占比仅为11%，但首饰和投资需求占比则高达87%，这充分说明黄金的金融属性强而白银的工业属性较强。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;从供给方面来看，白银作为铜、铅、锌的伴生矿（银作为副产品），其产量受其他金属的影响明显，矿产银约占总供给的70%，而再生银占20%多。虽然近几年间银价上涨数倍，但矿产银的增长却十分有限。当白银需求增长较快而银产量未能大幅提升时，就会催生大牛市行情，如2010年全球经济较好情况下白银总需求同比大幅上涨14.58%，但2010年白银矿产量同比仅增长2.5%，供需不平衡推动银价出现八个月的单边上涨行情。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;二是黄金价格。自古以来，黄金和白银一直作为货币而存在，即使已进入信用货币时代，全球投资者依然喜欢储存金银来满足其保值需求。白银往往被定位为&ldquo;黄金的替代投资品&rdquo;，当金价走高后，投资者会买入白银来代替黄金，因此金银价格往往会同涨同跌，但相对黄金而言，白银投机特性较高，价格波动更大。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;三是美元汇率及美国货币政策。白银市场上有美元升值则银价跌、美元贬值则银价涨的规律，因国际白银均是以美元标价，而且绝大部分以美元结算，美元汇率的变动对银价必然产生直接影响。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;美联储货币政策也是决定美元汇率的重要因素，其重大货币政策的出台往往对银价的影响巨大。如从美联储推出第二轮量化宽松政策的2010年8月到2011年4月底，美元指数从83附近持续走弱至73，银价则从18美元/盎司附近大涨至49.8美元/盎司。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;四是通货膨胀。通胀期间很多投资者会买入白银来实现资产的保值和增值。如2011年美国CPI长期维持在3%以上，美国老鹰银币平均每月销量高达370万枚（同比2010年增长逾20%）。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;五是全球经济增长和股票指数表现。2008年美国次贷危机爆发后道琼斯股指出现连续暴跌，银价也跌幅过半;而当2009年初道琼斯股指触底大幅回升后，白银价格也重新进入大牛市，两者同涨同跌的特性非常明显。</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;六是原油价格。白银价格和原油价格通常呈正相关关系。当油价上涨时往往意味着经济增长预期较高，进而提振白银的工业需求和价格上涨;另一方面，原油价格上涨会加大通货膨胀压力，这将促进白银的投资需求增加。对近22年来伦敦银和美国NYMEX原油连续合约数据进行分析，得出两者相关系数高达0.81925，说明在近22年内白银和油价有着很强的正相关性。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p style="margin: 0px; padding: 8px 0px; font-size: 14px; font-family: 宋体, tahoma, Helvetica, arial, sans-serif; line-height: 24px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;此外，影响白银价格的因素还有全球金融危机、国际政局动荡、战争等因素，银价对重大的政治、经济和战争事件有较高的敏感性，投机资金也会对银价产生显著影响，如1980年美国亨利兄弟炒作操纵白银市场，导致国际银价突破50美元/盎司。</p>', '工业', '', '智通财经', '', '2014-06-02'),
	(236, '前4月泉州工业投资完成290亿元 重点项目推进快', '', '<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>数字看发展</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>编者按</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	今年以来，我市经贸部门紧盯目标、靠前服务、主动作为、狠抓落实，与企业携手，有力推动产业加快转型，促进全市工业经济实现平稳增长。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	通过今年前4个月的一系列数字，可窥一斑。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>工业投资完成290亿元</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>重点项目推进快</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	本报讯 记者从市经贸委获悉，今年1&mdash;4月，全市完成工业投资289.26亿元，比增14.8%。其中技改投资174.18亿元，比增32.4%。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	重点工业项目稳步推进，拉高投资增幅。其中，晋江百宏年产25.5万吨功能性聚酯薄膜项目已投产第一条聚酯薄膜生产线。台资项目天岗精密机械制造项目建设步伐加快，投产后将生产制造各类精密数控机床设备、橡塑料数控成型机床及周边设备等，预计年内投产后可实现2亿元的年产值。安溪海西光电科技创新基地（二期）项目1号&mdash;11号楼项目实现全部封顶，已成功引进福建华瀚明光电等10家LED封装企业入驻，建成投产后年产值预计达10亿元，将带动当地光电产业的集聚壮大。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>亿元企业667家</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>龙头支撑带动大</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	本报讯 今年1&mdash;4月，全市累计产值超亿元企业达667家，比去年同期增加99家。其中，产值5亿元以上企业有75家，占规模以上工业产值的47.8%，龙头带动作用更加凸显。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	据悉，我市将认真解读&ldquo;省政府支持龙头企业加快发展、促进工业稳定增长七条措施&rdquo;，完善《泉州市产业龙头促进计划的贯彻意见》，重点培育5家百亿企业，用足、用好财税、金融、用地等叠加政策，强化产业龙头项目上下联动、分级管理机制，突出龙头企业带动作用，延伸完善产业链，提升产业集聚水平和综合竞争力。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>扶持3000家小微企业</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>突出成长性</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	本报讯 据悉，今年我市将深入实施&ldquo;万家企业成长工程&rdquo;和&ldquo;万家小微企业成长计划&rdquo;，在全市传统优势产业、成长型产业和战略性新兴产业中筛选成长型小微企业，建立小微企业成长库，争取全年完成3000家成长型小微企业入库，到2016年完成1万家企业入库，实施滚动管理，对自主创新能力强、市场前景广、成长性好的小微企业进行评价认定，在融资、项目申报、资源配置、管理培训等方面给予重点扶持和服务。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>工业用电比增7.4%</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	<strong>复苏态势明显</strong></p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	本报讯 今年1&mdash;4月，全市工业用电量81.50亿千瓦时，同比增长2.1%，工业用电增长与工业增加值增速匹配度进一步提高。其中，4月份完成工业用电量26.42亿千瓦时，同比增长7.4%，保持稳步回升态势。</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	实施100个节能重点工程提高利用率</p>\r\n<p align="justify" style="margin: 0px 3px 15px; padding: 0px; font-family: 宋体; font-size: 16px; line-height: 28px; text-align: justify; text-indent: 30px;">\r\n	本报讯 记者从市经贸委获悉，今年我市将继续组织134家重点用能企业开展节能低碳行动，深化工业企业对标行动，重点抓好钢铁、水泥、造纸等8个行业对标行动，不断提高高耗能行业能源利用率；积极向上争取专项资金，结合市本级统筹安排，全年争取组织实施100个以上的节能重点工程。</p>', '工业', '邱和军 曾源福 孙振汉 林建龙 刘庆南', '泉州晚报', '', '2014-06-02'),
	(237, '桂林汽车及零部件工业实现逆势增长', '', '<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp; &nbsp; 958年，桂林汽车总站大修厂生产出了桂林第一台汽车整车&mdash;&mdash;&mdash;漓江牌货车。从那以后，桂林<a class="recommendlinkmode" href="http://info.qipei.hc360.com/zt/07lhyz/index.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">汽车产业</a>从无到有，从小到大，从刚开始仅仅满足本地市场，到逐渐向全国和国外市场拓展，如今已形成系列客车、校车和曲轴、变速箱、汽车安全玻璃、<a class="recommendlinkmode" href="http://info.qipei.hc360.com/zt/fdj/index.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">柴油机</a>等零部件生产的庞大产研发和销售体系，实现了整车桂林制造与汽车零部件生产的比翼齐飞。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;今年以来，国内经济形势复杂多变，经济下行压力增大，许多行业都出现增速放缓的状况，桂林汽车及<a class="recommendlinkmode" href="http://info.qipei.hc360.com/zt/07lhyz/index.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">零部件产业</a>却逆势崛起，加速发展。统计数据显示，一季度，桂林汽车工业总产值达29.7亿元，同比增长27.21%；销售产值达29.56亿元，同比增长26.63%，全市汽车工业继续保持着高速发展态势。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;1958年，桂林汽车总站大修厂生产出了桂林第一台汽车整车&mdash;&mdash;&mdash;漓江牌货车。从那以后，桂林汽车产业从无到有，从小到大，从刚开始仅仅满足本地市场，到逐渐向全国和国外市场拓展，如今已形成系列客车、校车和曲轴、变速箱、汽车安全玻璃、柴油机等零部件生产的庞大产研发和销售体系，实现了整车桂林制造与零部件生产的比翼齐飞。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;今年以来，国内经济形势复杂多变，经济下行压力增大，许多行业都出现增速放缓的状况，桂林汽车及零部件产业却逆势崛起，加速发展。统计数据显示，一季度，桂林汽车工业总产值达29.7亿元，同比增长27.21%；销售产值达29.56亿元，同比增长26.63%，全市汽车工业继续保持着高速发展态势。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;<strong style="margin: 0px; padding: 0px;">汽车零部件：13家规模以上企业的&ldquo;诸侯争霸战&rdquo;</strong></p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;如果说在桂林汽车工业中，整车生产是桂客集团、桂林大宇、桂客发展三足鼎立，那么汽车<a class="recommendlinkmode" href="http://info.qipei.hc360.com/list/zx.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">零部件行业</a>则呈现出13家规模以上企业诸侯争霸的局面。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;汽车零部件生产是我市传统产业之一，最早可追溯到抗战时期。建国初期到20世纪60年代，我市有5家工厂先后生产汽车机械配件；进入上世纪80年代后，各汽车配件厂生产技术有了长足进步，不断开发出各类型高档汽车配件新产品。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;桂林福达集团要算其中的佼佼者。该集团于2000年正式组建，是广西汽车零部件行业发展速度最快、规模最大的民营控股企业，主要生产<a class="recommendlinkmode" href="http://info.qipei.hc360.com/zt/fdj/index.shtml" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">发动机</a>曲轴、汽车离合器、汽车齿轮等汽车零部件产品。2013年，该公司完成产值53.5亿元，实现营业收入54.2亿元，利税总额8.5亿元，成为桂林首家超50亿元装备工业企业。今年以来，该公司继续保持快速发展势头，1&mdash;4月，累计实现工业总产值达20.57亿元，同比增长29.38%；实现销售产值20.53亿元，同比增长27.60%。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;桂林奇昌车辆装饰有限责任公司是以专业生产汽车座椅、车辆装饰件为主导产品的股份制民营企业，主要配供上汽通用五菱汽车股份有限公司N107实用型（主要车型&ldquo;五菱之光&rdquo;）座椅。今年，该公司产销出现爆发式增长，1&mdash;4月，工业总产值达到1亿元，同比增长946.95%；实现销售产值9121万元，同比增长853.43%。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&hellip;&hellip;</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;市工信委<a class="recommendlinkmode" href="http://www.ec.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">电子</a>信息软件和装备工业科相关人士介绍，汽车及零部件产业是我市传统产业之一。近年来，经过资产重组和加快发展，该产业实力不断增强，目前已拥有行业规模以上企业16家，2013年完成工业总产值81.3亿元，对全市规模以上装备工业产值贡献率达16.4%。桂林也成为广西唯一的客车生产基地，高档大型豪华客车等产品在全国处于领先水平，新<a class="recommendlinkmode" href="http://www.energy.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">能源</a>客车的研发和生产走在全国前列，尤其是校车生产异军突起，成为全国首批获得校车生产资质的地区；曲轴、变速箱、离合器等零部件产品在国内市场排名前列。</p>\r\n<p style="margin: 10px 0px; padding: 0px; font-family: 微软雅黑; font-size: 16px; line-height: 30px; text-indent: 16px;">\r\n	&nbsp;&nbsp;&nbsp;&nbsp;&ldquo;汽车及零部件产业是我市今后重点发展的产业之一。&rdquo;该人士说，今年，我市专门出台了《桂林市加快重点工业产业及战略性新兴产业发展的若干政策意见》，通过设立市本级工业发展专项资金，在资金、政策等方面，鼓励汽车及零部件产业等一批重点产业发展。&ldquo;大力发展汽车产业，特别是新能源汽车，对于我市加快转变经济发展方式、做大做强做优工业意义重大。按照政策，市工信委将加大力度支持汽车及零部件产业中的重点工业企业的两化融合建设。对企业实施生产装备数字化改造、信息系统建设、软件开发、信息平台建设、开展网上<a class="recommendlinkmode" href="http://www.ceo.hc360.com/" style="margin: 0px; padding: 0px; color: rgb(15, 119, 244); text-decoration: none; border-bottom-width: 1px; border-bottom-color: rgb(15, 119, 244); border-bottom-style: dotted;" target="_blank">营销</a>、电子商务等项目，投资额在100万元以上，给予相关资金扶持。工信部门将推动全市汽车产业升级，积极打造我国南方重要汽车产业基地，实现桂林人的汽车产业梦想。&rdquo;</p>', '工业', '', '广西新闻网', 'recommend', '2014-06-02'),
	(238, '2014第十三届中国沈阳国际汽车工业博览会', '', '<p style="margin: 0px; padding: 0px; font-family: 宋体, 黑体, 微软雅黑; font-size: 14px; line-height: 22px;">\r\n	　　由中国机械工业集团有限公司、中国汽车工业国际合作有限公司主办，中国汽车工业国际合作有限公司和辽宁中汽会展有限公司共同承办的&ldquo;2014第十三届中国沈阳国际汽车工业博览会&rdquo;（以下简称：沈阳国际汽博会）定于6月25日-30日在沈阳国际展览中心盛大举行。启用沈阳国际展览中心八个室内展馆及室外展区，总面积将达18万平方米。</p>\r\n<p style="margin: 0px; padding: 0px; font-family: 宋体, 黑体, 微软雅黑; font-size: 14px; line-height: 22px;">\r\n	　　始于1999年的沈阳国际汽博会，历经15年的培育和发展，凭借沈阳在东北地区得天独厚的地域和市场优势，为全国汽车企业搭起了一座尽情展示的舞台，成为中外汽车行业广泛交流与合作的重要平台和引领东北地区汽车产业发展、促进汽车消费的重要载体，成为东北地区蕴涵发展潜力的汽车产业和贸易平台。&ldquo;沈阳国际汽博会&rdquo;凭借着上届18万平方米的展出面积、近万台车辆的成交量以及成交额突破20亿人民币的喜人业绩已稳步发展成为东北地区第一大车展。</p>\r\n<p style="margin: 0px; padding: 0px; font-family: 宋体, 黑体, 微软雅黑; font-size: 14px; line-height: 22px;">\r\n	　　本届沈阳国际汽博会以&ldquo;感低碳科技、享品质生活&rdquo;为主题，通过展会向观众充分展示新能源、新技术及低碳、低排放等环保技术在汽车产品上的开发和应用给人们带来的&ldquo;清新、绿色、舒适&rdquo;的高品位体验。本届展会为了回馈广大观众多年来对沈阳汽博会的关心和支持，特设置了5000万豪礼大赠送活动，不仅有爱车族喜欢的汽车时尚大礼包，而且购车就有机会赢得苹果5S、Ipad MINI等诱人大奖！在获得奖项的同时，还可以欣赏到只有在国际车展现场才能看到的&ldquo;中国国际汽车模特大赛（东北赛区）选拔赛、&rdquo;&ldquo;中国好声音&rdquo;2014年MECA赛事汽车音响大赛、超跑嘉年华、汽车改装秀、汽车彩绘大赛、韩国民俗园展示等多彩的绚目活动。届时，还会有多款罕见车型亮点展会现场，数十款新车上市发布会、中外香车靓模让您近距离体验国际车展高大上的品牌风范！</p>', '工业', '王舒婷', '沈阳日报', '', '2014-06-02');
INSERT INTO `news` (`Id`, `title`, `pic`, `content`, `newsclass`, `author`, `source`, `recommend`, `inputdatetime`) VALUES
	(239, '要么电子商务，要么无商可务', 'upload/images/1403351688156.jpg', '<div align="center" style="font: 14px/24px 宋体, sans-serif; margin: 0px; padding: 0px; color: rgb(37, 37, 37); text-transform: none; text-indent: 0px; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	<br style="font: 14px/24px 宋体, sans-serif; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 0px; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;" />\r\n	<span style="font: 14px/24px 宋体, sans-serif; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 0px; letter-spacing: normal; word-spacing: 0px; float: none; display: inline !important; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">　　吴晓波（</span><a class="daren-keyword" style="font: 14px/24px 宋体, sans-serif; text-align: justify; color: rgb(15, 107, 153); text-transform: none; text-indent: 0px; letter-spacing: normal; text-decoration: underline; word-spacing: 0px; white-space: normal; position: relative; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;" userid="4238907446334947977">微博</a><span style="font: 14px/24px 宋体, sans-serif; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 0px; letter-spacing: normal; word-spacing: 0px; float: none; display: inline !important; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">）：1968年出生，毕业于复旦大学新闻系。财经作家、&ldquo;蓝狮子&rdquo;财经图书出版人，上海交通大学、暨南大学EMBA课程教授，常年从事公司研究。</span></div>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	著名财经作家吴晓波最新力作《商战：电商时代》出版 接受本报专访：</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	日前，知名财经作家吴晓波新作《商战：电商时代》出版，从模式、用户、价格、物流、品牌、资本、大数据等方面，对电子商务这个&ldquo;日渐熟悉的陌生人&rdquo;进行了全面的解读。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	与此同时，同名纪录片《商战之电商风云》隆重登陆央视，成为热门的财经话题。大数据时代，商业如何生存？我们又该如何应对消费方式和生活方式的大变革？</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	文、图 记者 吴波</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	电子商务的光荣与梦想</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	吴晓波认为，&ldquo;互联网在改造我们思维和生活的同时，电子商务作为互联网经济的核心形态，正以前所未有的姿态向所有商业活动发起摧枯拉朽式的猛烈攻击。&rdquo;这是他在研究历史经济规律过程中绕不开的课题。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	随着社交网络、移动智能和大数据的更深入发展，电商让社会和经济的变化变得更显著。不管你生活在哪里，已经到了要关注电商的时代，因为这不仅关系到你的消费，也将带来更多的机会，以及因电商对实体行业的重组挤压而导致的行业形态转换、岗位流失等挑战。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	《商战：电商时代》由吴晓波任总撰稿，文本内容涵盖了对杰夫&middot;贝索斯（亚马逊创始人）、刘强东、马云、柳传志、雷军、陈年、李国庆等近百位国内外知名企业家的采访及回应，串联起了电商时代一个个颇具传奇色彩的故事，概述了中国电子商务近20年来的发展过程。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	电子商务</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	已成为生活方式</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	吴晓波告诉记者，&ldquo;网络购物已经成为我们生活中的一种DNA。越来越多的人，逐渐从犹疑不定的网络购物怀疑者，渐渐步入坚定支持者的行列。&rdquo;《2012年度中国网络零售市场数据监测报告》显示，我国网络购物用户规模达到2.47亿人，平均每6个人之中，就有一个是网络购物者。仅2013年11月11日这天，涌进天猫的网购用户就达到1.88亿人次。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	中国的电子商务，正在以其独特的购物体验疯狂地从传统零售业中争夺用户。大部分电商都很自信。在阿里巴巴的创始人马云看来，这个时代已经到了离不开电子商务的地步，&ldquo;你今天一定要用电子商务，用互联网的思想和互联网的技术，去解决你现有的商业中发生的问题&rdquo; 。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	&ldquo;如果一定要为近十年的商业发展和经济社会的变化找一个关键词，那无疑是&lsquo;电子商务，吴晓波如此说道，&ldquo;电子商务对现实生活的穿透力，不仅仅表现在天文数字般的商业数据上，更表现在对公众消费习惯的强大颠覆上。&rdquo;</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	互联网电子商务的出现，在中国曾经是一个笑话&mdash;2000年时，第一代的电商人啃着面包，骑了一天的自行车到北京郊区送了一个汉堡，只收回来5元钱的货款。网购的商品，一直被当作次品、假货或者是便宜的尾货&mdash;直到今天，这些乱象仍未彻底根除。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	电子商务的核心竞争力到底是什么？大多数人可能会说：价格便宜。实惠对于消费者来说固然重要，但电子商务为什么如此便宜却还能赢利，却不是烧钱那么简单。例如，亚马逊上百万种图书能供全球数亿用户自由选择，全天候24小时风雨无阻，这是任何一家地面书店都不能提供的服务，而对于出版商来说，只要有这么一个网页，他的图书就可以被全球数亿用户发现和购买，无需全渠道布货和全媒体广告，这种简洁高效的推广和销售方式，是商家不能拒绝的选择。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	今天，电子商务已经成为我们的一种生活方式，无论是吃穿住行，还是<a href="http://love.163.com/?utm_source=word.163.com&amp;utm_campaign=163&amp;vendor=163.new.word" style="color: rgb(15, 107, 153); text-decoration: underline;" target="_blank" title="交友">交友</a><a href="http://love.163.com/?utm_source=word.163.com&amp;utm_campaign=163&amp;vendor=163.new.word" style="color: rgb(15, 107, 153); text-decoration: underline;" target="_blank" title="婚恋">婚恋</a>，我们都能感受到电子商务的便捷、快速与神奇。越来越多的人开始相信比尔&middot;盖茨的预言&mdash;&ldquo;21世纪，要么电子商务，要么无商可务&rdquo;。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	对话吴晓波：</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	电子商务正在改变中国</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	广州日报：您能否简单地告诉读者，我们的生活究竟是如何被电子商务改变的？</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	吴晓波：长期以来，中国经济的崛起依赖的是廉价的原料和劳动力建立起来的制造能力，然而&ldquo;中国制造&rdquo;在近几年，特别是2008年全球金融危机之后遭遇到巨大挑战，中国经济的增长不得不转回到启动庞大的内需市场上。而回到国内市场后，面对的一系列问题就是：如何找到目标消费者，如何构建渠道，如何打造品牌？对于一些新兴公司来说，最好的选择自然就是&ldquo;电子商务&rdquo;。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	任何一个传统行业，在今天都要思考的一个问题就是：我如何跟互联网建立联系？如何利用互联网更准确地找到我的目标消费者，如何把我的产品和服务传达到消费者的手上，如何根据消费者的建议进行改进。在这个意义上，电子商务浪潮是中国摆脱&ldquo;廉价制造&rdquo;标签，真正实现产业转型升级的大好时机。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	广州日报：电子商务乃至互联网经济仅仅只是一种新的商业形态吗？对传统产业而言，电子商务是否意味着破坏性力量？</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	吴晓波：随着年轻一代的成长和消费习惯的日益成熟，人们在希望买到更多更好商品的同时，也希望能获得更优质的服务，这个&ldquo;服务&rdquo;是广义的，包括更安全、更快速的投递，更便捷、更人性化的支付，这些切实的需求原本看上去都属于电子商务无力撬动的领域。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	然而，我们确实不能低估电商所带来的连锁效应。不难看到，随着电子商务的蓬勃发展，传统的快递、支付到今天都实现了大的飞跃。在前一段时间，互联网金融领域也成为各界关注的焦点，依照这种发展趋势，其未来大可期许。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	在我看来，商业上没有新的事物，有的只是对过去事物的重复。即便电商，也不例外。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	广州日报：您怎么看中国电商与世界范围电商发展历程？</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	吴晓波：在互联网经济时代，中国是幸运的。因为当互联网这波趋势来临之时，中国的企业没有错过这班车。当雅虎、亚马逊在美国诞生之时，仅仅过了几年，中国的阿里巴巴、腾讯等日后的互联网代表公司也应声而至。这使得中国企业第一次与美国企业站在了同一起跑线上。在今天移动互联网大潮来临时，中国企业甚至稍稍占得了一定的先机。这意味着，今天我们在中国目睹的一切电子商务行为，都是具有开创性意义的，不再像以前，我们跟在美国后面亦步亦趋。同时，也意味着从今而后，中国的互联网公司从一开始就要面对世界级的竞争，从某个角度来讲，这可以算作中国商业进步的一个体现。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	内容介绍</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	全书第一章介绍了美国（海外市场）和我国电子商务起步发展的概括。书中指出，8848等电商创业&ldquo;先烈&rdquo;&ldquo;面临（过）的困难与挑战，遭遇的挫折，恰恰为后来者标出了哪些是黑洞，哪些是漩涡&rdquo;，特别是8848创业团队因发展需要而不得不屈从于资本压力，进而造成崩盘的教训，在后来警醒了马云和刘强东，才没让阿里巴巴和京东商城在创业起步阶段就迅速折翼。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	第二章浓墨重彩的描绘了用户主导的消费时代，电商企业（包括其中涌现并发展壮大的巨头企业）不断强化竞争、不断加深对用户需求认识的过程。这其中不无挫折，却因此鞭策了电商企业想办法去满足用户，想办法创造方方面面的惊喜。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	本书的第三章、第四章分别提及电商在明面和暗面上的两场殊死争夺，即价格战和物流效率之争，说到底，这些都是市场竞争的产物，是用户需求和订单倒逼的结果。</p>\r\n<p style="font: 14px/24px 宋体, sans-serif; margin: 26px 0px; padding: 0px; text-align: justify; color: rgb(37, 37, 37); text-transform: none; text-indent: 2em; letter-spacing: normal; word-spacing: 0px; white-space: normal; font-size-adjust: none; font-stretch: normal; background-color: rgb(255, 255, 255); webkit-text-stroke-width: 0px;">\r\n	叙述到第五章，开始介绍电商行业、企业的资本之路时，读者大概可以意识到这其实在书写创业极客、梦想家无法逃避的最残酷磨砺。</p>', '互联网', '吴波', '大洋网-广州日报', 'recommend', '2015-05-24'),
	(240, '开发商触网看点 商业地产利用"大数据"进军电商', 'upload/images/1403351895578.jpg', '<p align="center" class="pictext">\r\n	■万科和百度达成战略合作关系，打造新商业生态系统。</p>\r\n<p>\r\n	　　<strong>互联网金融带来全新融资模式</strong></p>\r\n<p>\r\n	　　目前房地产行业筹融资渠道以及投资渠道过分单一，与互联网金融结合，为房地产基金以及房企拓展了全新的融资渠道。互联网金融最典型代表就是余额宝的诞生。对于房企来讲，可以借助互联网金融的优势，与相关银行等金融机构开展合作，设立房地产基金，拓展全新的融资渠道。</p>\r\n<p>\r\n	　　此外，由于三、四线城市开发商资质很难达到，房地产项目未来销售预期风险较大，这些开发商就算有项目抵押也很难从银行拿到资金，被限制贷款。即使可以获得贷款的企业，贷款成本也相对高企。从去年下半年开始，越来越多处于三、四线城市的开发商找到P2P网贷公司，进行融资，以期望通过这样创新的融资方式解决燃眉之急。</p>\r\n<p>\r\n	　<strong>　利用互联网思维</strong></p>\r\n<p>\r\n	<strong>　　再造房地产开发流程</strong></p>\r\n<p>\r\n	　　房企与互联网的融合，不仅仅停留在业务层面上，还包括房企经营思路、开发模式的重塑。这种改变，也许不能在三五年内影响或改变房地产行业现状，但是却可以折射出房地产未来的发展之路。从地产大佬对于互联网的重视开始，互联网的思维模式将会逐步在房企的开发建设、产品定位、营销模式、资源整合中逐步体现。</p>\r\n<p>\r\n	　　同策咨询研究部总监张宏伟认为，在未来，由使用互联网以及针对互联网平台的应用为起始，在开发项目前期、招拍挂、项目规划、营销定位、开工建设、项目预热、蓄水、强销、持续销售、尾盘、交付等各个环节，用互联网的方式去换位思考和运营就显得十分必要。甚至，在未来也可以利用互联网思维再造房地产开发流程，循序渐进地提升地产公司的信息化、互联网化水准，颠覆行业开发流程、开发模式，提升公司运营效率。</p>\r\n<p>\r\n	　　<strong>商业地产利用&ldquo;大数据&rdquo;进军电商</strong></p>\r\n<p>\r\n	　　利用互联网&ldquo;大数据&rdquo;进军电商，调整商家布局成为商业地产企业发力的方向。今年3月份，保利旗下商业项目正式启采用&ldquo;ECO模式&rdquo;&mdash;&mdash;一个万能的定制化服务模式，包括硬件上配合定制商务办公的Business-Box以及软件上从智能生活上提升用户体验度的利视计划，从而突破传统的办公、购物方式，结合保利地产的业主&ldquo;大客户群&rdquo;，为购房者和业主带来一站式服务体验。</p>\r\n<p>\r\n	　　再以万达为例，万达在去年便开始大举筹备进军电商，计划将旗下商业地产、酒店、电影院线、连锁百货、旅游度假五大主营业务打包上线。万达拥有全国独一无二的线下资源，有一百多个广场，接近一百个酒店，过几年后还有若干个大型度假区，万达可以利用这些项目资源，建立会员体系，把每一个项目当中大量的会员消费的次数、额度、喜好和所有的这一切东西建立和掌握起来，然后根据大数据来做出分析,以进行下一阶段的招商和调整商家布局。</p>\r\n<p>\r\n	　　万达在互联网领域的探索与尝试已经引领了行业的发展趋势，这或许也会成为其他商业地产企业模仿与转型的方向之一。</p>\r\n<p>\r\n	　<strong>　利用互联网技术开展团购&ldquo;卖房子&rdquo;</strong></p>\r\n<p>\r\n	　　对于开发企业来讲，如何利用互联网&ldquo;卖房子&rdquo;就成为眼下最关心的话题之一。比如SOHO中国此前就直接与互联网公司联手，展开网上销售的合作，利用互联网&ldquo;卖房子&rdquo;。一时间，导致地产与互联网融合成为时髦话题。</p>\r\n<p>\r\n	　　同策咨询研究部总监张宏伟认为，利用互联网&ldquo;卖房子&rdquo;的企业越来越多，但更多的只是体现在&ldquo;散售&rdquo;或&ldquo;分销&rdquo;上，而&ldquo;散售&rdquo;或&ldquo;分销&rdquo;并不能体现出以互联网技术为基础的房产电商平台的优势。依托互联网技术，开展团购&ldquo;卖房子&rdquo;才是房产电商平台优势所在。&ldquo;团购&rdquo;的楼盘一般都要比正常售出便宜5%-10%，甚至更多，也就是说，市场上总价在100万元左右的房子，通过 &ldquo;团购&rdquo;购房，购房者可以节省5万-10万元房款，甚至更多。由此，购房者可以节约大量购房成本，电子商务网站同时也从中可以实现巨额收益，开发企业也可以尽快回笼资金，实现项目的高周转操盘策略。</p>\r\n<p>\r\n	<strong>　　推出社区APP系统，轻资产运作</strong></p>\r\n<p>\r\n	　　在互联网思维下，物业管理费甚至就可以免征，但免征的前提要看以什么模式来运营这些项目。目前来讲，部分房企已经开始尝试利用移动互联网技术，推出社区APP系统，提供社区服务的轻资产运作方式。</p>\r\n<p>\r\n	　　比如，花样年旗下物管公司彩生活管理服务面积超过6000万平方米，服务人口约400万人，如果这400万人平均每人月消费1000元，包括水电煤、日常生活中的吃喝拉撒等，一年下来消费总额接近500亿元。针对这么庞大的市场需求，彩生活向社会正式推出了彩之云APP系统。这是一个可以实现线上和线下融合的互联网平台，花样年通过互联网手段实现物业管理的自动化、系统化、信息化服务，在这里集成了包含衣、食、住、行、娱、购、游在内的各领域商户服务资源，构建社区1公里微商圈。</p>\r\n<p>\r\n	<!--/enpcontent--><!--/enpcontent--></p>', '互联网', '', '中新网', 'recommend', '2014-06-21'),
	(241, '砸钱+创意 电商营销进入“娱乐时代”', '', '<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	候雪莲电商<a href="http://auto.ifeng.com/news/marketing/" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank"><font color="#004276">营销</font></a>一向搏的就是眼球，因为眼球意味着流量。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	当&ldquo;6&middot;18&rdquo;遇上世界杯，这个夏季让创意变得更加重要。为了吸睛，京东拉来女明星柳岩与刚刚完成上市、正春风得意的刘强东送货，1号店董事长于刚兑现&ldquo;诺言&rdquo;亲吻奶牛，亚马逊喊出&ldquo;10年未有的力度&rdquo;，当当网则誓言&ldquo;踢爆6&middot;18&rdquo;，国美在线最&ldquo;土豪&rdquo;，线上投入32亿元现金券&hellip;&hellip;</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	今年的6月电商大促销，因为每家企业都不肯错过流量红利，不但参战的电商企业数量增加，传统企业也积极应战，较之往年更增添了热闹的气氛。不过，有专家点评，今年的夏季大促，企业已经明显跨过借低价拉拢用户赚流量的阶段，转而更多关注商品质量和用户体验，其背后比拼的是各家企业的供应链能力、运营能力和物流配送能力。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	分享流量红利</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	进入6月，作为消费者的你已经躲不开电商夏季大促的攻势。在《中国经营报》记者常用的电子邮箱企业订阅邮件栏中，前50封邮件中有41封都是电商企业的广告，而且内容充满浓浓的火药味。比如，酒仙网的邮件标题是&ldquo;用户不爽，老板不哭，也叫6&middot;18？全场包邮包爽！&rdquo;，强调&ldquo;决战6&middot;18，7天7夜全网流血又包邮&rdquo;。而1号店的内容更是直指京东，邮件主题是&ldquo;手机家电，<a href="http://baike.finance.ifeng.com/doc/16771" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank"><font color="#004276">秒杀</font></a>6&middot;18&rdquo;，打开内容赫然出现&ldquo;手机家电比京东低50元，以旧换新立省40%购机费用&rdquo;。拉手网的&ldquo;有段时间没来拉手网了吧！我们想你了&rdquo;算是最温柔的。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	除了网上攻势，地面<a href="http://travel.ifeng.com/outdoor/list_0/0.shtml" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank"><font color="#004276">户外</font></a>广告也几乎被电商企业占据。6月18日，电商夏季大促最核心的日子，记者在深圳老街地铁站看到，遍布地铁站的都是姚晨代言的1号店的大幅广告，&ldquo;6月11日至15日，进口啤酒一律5折&rdquo;。而沿途的地铁和公交站牌，几乎都是电商企业的广告。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	自从春节前夜宣布启动IPO，到5月22日正式上市，电商圈就预测今年一直新闻不断的京东一定会憋足力气大搞&ldquo;6&middot;18&rdquo;。京东和总裁刘强东果然也&ldquo;不负众望&rdquo;，早在&ldquo;6&middot;18&rdquo;前半个月，就通过京东APP、微信、手机<a href="http://car.auto.ifeng.com/series/1785" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank"><font color="#004276">QQ</font></a>三个主流移动端发放价值10亿元的京东红包预热。6月18日当天，刘强东也一如既往地穿上快递员的工服在北京送货。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	中国电子商务研究中心网络零售部主任莫岱青分析师认为，&ldquo;京东借上市喜气，加大促销投入的态势非常明显。京东意欲在上市后形成与阿里比肩的电商双极格局，急于向市场表现成绩，而此次年中庆正好是其业绩首秀的关键节点。&rdquo;</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	坚持了十年的&ldquo;6&middot;18&rdquo;已然成为&ldquo;双11&rdquo;之外另一个电商狂欢节，国内最大的品牌商和零售平台天猫也早已把6月定为一年中重点促销的既定时点，成为其&ldquo;两新一促一节&rdquo;中的一项。其中两新是指春秋两季上新，一节是&ldquo;双11&rdquo;，一促正是此次年中促。为配合世界杯和6月大促，阿里巴巴6月10日宣布&ldquo;码上淘&rdquo;战略，并与<a href="http://finance.ifeng.com/app/hq/stock/sh600600/" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank" title="青岛啤酒 600600"><font color="#004276">青岛啤酒</font></a><span id="sh600600_hq">[<span class="Agreen" style="color: rgb(37,114,7)">-0.45%</span><span class="Apple-converted-space">&nbsp;</span><a href="http://app.finance.ifeng.com/data/stock/tab_zjlx.php?code=sh600600" style="font-weight: normal; color: rgb(0,66,118); text-decoration: none" target="_blank">资金</a><span class="Apple-converted-space">&nbsp;</span><a href="http://star.finance.ifeng.com/stock/sh600600" style="font-weight: normal; color: rgb(0,66,118); text-decoration: none" target="_blank">研报</a>]</span>、百事可乐等快消企业达成战略合作，通过百事可乐和<a href="http://app.travel.ifeng.com/city_detail_327" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank"><font color="#004276">青岛</font></a>啤酒罐身遍布的二维码，与用户互动，提供最简单快捷的<a href="http://travel.ifeng.com/theme/shopping/list_0/0.shtml" style="font-weight: bold; color: rgb(0,66,118); text-decoration: none" target="_blank"><font color="#004276">购物</font></a>通路。在天猫公关迟有雷看来，&ldquo;码上淘&rdquo;重新定义了流量入口的标准，把从前的流量入口从PC端、移动端扩展到所有具有二维码的实体商品上。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	如何才能吸引来流量呢？有电商B2C两巨头的引领，6月的流量红利自然是各家电商企业都不能放过的机会，就连传统企业也在积极备战。记者采访中，很多企业都表示，很看重6月的淡季促销，年初就开始进行货源组织和渠道安排，主动配合电商企业共同促进销量。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	会吆喝，更要有货卖</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	不过，电商并不是有了流量就会自然转化成销售，转化率背后考验的还是企业运营及对细节控制的能力。比如，企业花高成本拉来的流量，如果后台系统没有配合好，比如货没有备足，或者服务、配送等用户体验的环节没有做好，高额成本就等于打了水漂。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	莫岱青表示，电商原先借低价格笼络用户的方法屡试不爽。但随着电商战火升级、用户消费品质的提高，仅仅靠低价卖点已无法集中用户眼球。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	今年电商年中大促开始更多关注商品质量和用户体验。从某种意义上说，巨头间的营销战已经进入后流量时代。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	对电商企业来说，营销搏的就是吸引眼球的能力，&ldquo;砸钱+创意&rdquo;成为吸晴的不二法门。去年&ldquo;双11&rdquo;，京东展现自身物流配送优势的&ldquo;快才过瘾&rdquo;系列广告至今仍被电商圈认为是继凡客体后最成功的广告。但好的创意很多时候可遇不可求，因此今年，商家营销的重点主要放在代言人和明星身上，比如1号店请来姚晨，手机淘宝请来都教授，京东找来柳岩送货。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	今年京东主打的主题是&ldquo;PARTY&rdquo;。据京东副总裁徐雷介绍，今年京东安排了明星送货日，京东和很多品牌商及供应商有很好的关系，京东希望与企业共同打造一个PARTY的感觉，很多品牌商或者供应商也在安排自己的形象代言人参与到PARTY中。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	相对京东的&ldquo;PARTY&rdquo;战略，阿里今年更强调协同。迟有雷介绍，今年天猫和聚划算全面打通，合力提升商家流量转化率。&ldquo;从商品、商户、促销活动的主分会场，天猫、聚划算都是一盘棋在做。&rdquo;而高流量转化率背后，也是阿里提前向供应链上游寻求合作、主动稳定货源带来的协同效果。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 25px; word-spacing: 0px; font: 14px/24px simsun, arial, helvetica, clean, sans-serif; text-transform: none; color: rgb(43,43,43); text-indent: 28px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	早在今年4月18日，阿里就与多家手机厂商共同建立了手机生态圈，保证在促销高峰时间有充足的商品供应，这是流量能成功转化成购买的基础。</p>', '互联网', '李向东', '中国经营报', '', '2014-06-21'),
	(242, '中介另起炉灶建电商平台', 'upload/images/1403352224031.jpg', '<div align="center" style="word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<div align="center">\r\n		<font size="+0">昨日，世华地产加盟Q房网，由此进入O2O电子商务领域。深圳商报记者 陆剑伟 摄</font></div>\r\n</div>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	&nbsp;</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　《四大中介炮轰<span onmouseover="ShowInfo(this,"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/SFUN.N.htm" style="color: rgb(0,0,0); border-bottom: rgb(83,109,166) 1px dotted; text-decoration: none; outline: none" target="_blank">搜房网</a></span>》追踪报道</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　深圳商报讯 （记者 陆剑伟）昨日，世华地产宣布加盟Q房网，旗下在深圳、珠海、东莞等地的300余家门店，将全部更换为Q房网标识，并由此进入O2O电子商务领域。世华地产营业总经理林家乐昨日表示，与Q房网合作将降低营销成本、提高营销精准度，同时也希望与搜房网继续合作。深圳商报记者了解到，多个城市爆出地产中介和电商&ldquo;掐架&rdquo;，我爱我家、链家地产和世华地产在内的多个传统地产中介，纷纷&ldquo;另起炉灶&rdquo;，打造自己的电商平台。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　逾亿元&ldquo;另起炉灶&rdquo;建电商平台</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　拥有十三年品牌历史的世华地产将淡出公众视野。从6月20日起，分布在深圳、珠海、东莞大街小巷的300余家世华地产门店，将统一更换为Q房网标识，世华地产正式成为Q房网全国首家品牌特许加盟商，拥有自主的网络营销系统平台。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　世华地产进入电商的想法并非近日才有。记者了解到，Q房网上线三年以来，一直由世华地产一手扶持、打造，陆续投入产品研发资金超过1亿元。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　在谈到为什么敢于放弃原有知名品牌时，世华地产营业总经理林家乐坦言，现行房地产中介行业，一方面遭遇市场阶段性下调，一方面竞争上却空前激烈，局势更为复杂，线上有<a class="a-tips-Article-QQ" href="http://finance.qq.com/l/financenews/jinrongshichang/jinrong.htm" style="color: rgb(0,0,0); border-bottom: rgb(83,109,166) 1px dotted; text-decoration: none; outline: none" target="_blank">金融</a>巨头平安跨界房产电商攻城略地，线下有品牌中介联合抵制搜房、安居客，还有外地的<span onmouseover="ShowInfo(this,"><a class="a-tips-Article-QQ" href="http://stockhtm.finance.qq.com/astock/ggcx/WUBA.N.htm" style="color: rgb(0,0,0); border-bottom: rgb(83,109,166) 1px dotted; text-decoration: none; outline: none" target="_blank">58同城</a></span>等等，多种力量互相博弈日趋激烈，这是行业洗牌的一次契机，也是房地产经纪行业探索新出路的必然之举。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　&ldquo;此次加盟Q房网谈不上&lsquo;谁吃掉谁&rsquo;，两者是合作关系，是一种服务与被服务的关系，各自独立经营。&rdquo; 林家乐如是说。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　Q房网集团副总裁花蕴表示，世华地产十多年沉淀下的客户资源以及门店密集覆盖能力，无缝对接Q房网大数据系统、线上营销平台，采用品牌一体化进行全渠道营销。并通过线上、线下一体化的品牌形象，为客户提供从线上房源搜索，到线下带看、签约、过户等一站式优质服务体验，真正搭建起房产经纪O2O模式闭环。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　将推出主动式精准推客模板</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　&ldquo;有置业意愿的购房者近期在搜房、安居客、58同城等网站，浏览的房源所在区域、户型、面积等信息，Q房网通过大数据抓取，反馈到世华地产相关部门，经纪人员可根据世华房源信息进行精细筛选，再对客户进行精准推送，大大降低了地产中介推盘的盲目性。&rdquo;</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　昨日，Q房网&ldquo;祭出&rdquo;全国首家房产技术产品&mdash;主动式精准推客模板，将大幅降低世华地产推盘的营销成本，拟在近期选择一家地铺试运行，年底在世华300余间地铺全面推广。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　记者了解到，目前Q房网对世华地产使用发布房源信息端口仍是免费，未来将逐步实现收费。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　仍希望与搜房网进行合作</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　谈及18日的深圳地产中介联盟声讨电商一事，林家乐表示，通过搜房网的客户占比达到20%~30%，好的区域占比达到四五成，在端口服务公司中，搜房网仍是客户来源占比最大的一家。世华仍希望在可能的条件下，与之合作。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　&ldquo;Q房网开启O2O模式之后，对我们的端口免费，但是我们不会强制要求员工选择某家电商，仍然让他们自愿选择服务和效果好的电商。&rdquo; 林家乐如是说。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px 0px 29px; word-spacing: 0px; font: 16px/28px 宋体, Arial, sans-serif; text-transform: none; color: rgb(0,0,0); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　记者了解到，目前，除世华地产外，我爱我家和链家地产，目前都建立起自己的线上房产电商平台。</p>', '互联网', '陆剑伟', '深圳新闻网-深圳商报', 'recommend', '2014-06-21'),
	(243, '2014好品山东电商节7月中旬开幕 将开启网购嘉年华', 'upload/images/1403352276484.jpg', '<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<font 12px="">今天上午，&ldquo;2014好品山东电商节合作沟通会&rdquo;在山东济南举行。（齐鲁网记者 满倩 摄）</font></div>\r\n<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<table align="center" style="font-size: 12px; margin: 0px auto">\r\n		<tbody>\r\n			<tr style="font-size: 12px">\r\n				<td style="font-size: 12px">\r\n					<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; padding-top: 0px">\r\n						<img alt="山东省经信委对外合作与交流处调研员吴炎致辞。（齐鲁网记者" src="http://img1.cache.netease.com/catchpic/1/1F/1F5EA1250442E5DE621A6EFD306C3627.jpg" style="border-right: medium none; border-top: medium none; margin: 5px; vertical-align: top; border-left: medium none; border-bottom: medium none" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<font 12px="">山东省经信委对外合作与交流处调研员吴炎致辞。（齐鲁网记者 满倩 摄）</font></div>\r\n<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<table align="center" style="font-size: 12px; margin: 0px auto">\r\n		<tbody>\r\n			<tr style="font-size: 12px">\r\n				<td style="font-size: 12px">\r\n					<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; padding-top: 0px">\r\n						<img alt="好品山东项目负责人郭俊超。（齐鲁网记者" src="http://img1.cache.netease.com/catchpic/4/41/410E2C35292B47A439A813088702936A.jpg" style="border-right: medium none; border-top: medium none; margin: 5px; vertical-align: top; border-left: medium none; border-bottom: medium none" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<font 12px="">好品山东项目负责人郭俊超。（齐鲁网记者 满倩 摄）</font></div>\r\n<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<table align="center" style="font-size: 12px; margin: 0px auto">\r\n		<tbody>\r\n			<tr style="font-size: 12px">\r\n				<td style="font-size: 12px">\r\n					<div align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; padding-top: 0px">\r\n						<img alt="“好品山东”与首批报名参加2014年好品山东电商的企业进行了第一次现场沟通，来自全省各地近100余家近200企业代表参与了此次会议。（齐鲁网记者" src="http://img1.cache.netease.com/catchpic/0/09/0983A2D03C33DA08AF309F8A019F48AA.jpg" style="border-right: medium none; border-top: medium none; margin: 5px; vertical-align: top; border-left: medium none; border-bottom: medium none" /></div>\r\n				</td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</div>\r\n<p>\r\n	<font 12px="" style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　&ldquo;好品山东&rdquo;与首批报名参加2014年好品山东电商的企业进行了第一次现场沟通，来自全省各地近100余家近200企业代表参与了此次会议。（齐鲁网记者 满倩 摄）</font><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　</span><strong style="word-spacing: 0px; font: bold 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">齐鲁网济南6月20日讯</strong><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　（记者 满倩）今天上午，&ldquo;2014好品山东电商节合作沟通会&rdquo;在山东济南举行。作为山东省经信系统开展网络营销的服务平台，&ldquo;好品山东&rdquo;与首批报名参加2014年好品山东电商的企业进行了第一次现场沟通，来自全省各地近100余家近200企业代表参与了此次会议。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　</span><strong style="word-spacing: 0px; font: bold 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">100余家近200企业代表参加电商节沟通会</strong><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　&ldquo;此电商节将是我省史无前例的一次优秀企业与电子商务龙头平台的强势对接与最佳营销机会。&rdquo;好品山东项目负责人郭俊超表示。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　&ldquo;2014好品山东电商节&rdquo;是为落实省政府领导关于推动产业向价值链前后两端延伸的有关指示精神，促进传统产业转型电商，由好品山东联合国内知名电商机构所策划举办的一次山东省历史上最大规模的电商营销盛会。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　活动旨在整合全国各大龙头电子商务平台落地山东，整合全国知名电商服务企业扎堆山东，对接山东省名优企业及优质产品，推动山东省传统企业快速转型电商，抱团营销打造品牌。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　山东省经信委对外合作与交流处调研员吴炎致辞时表示，&ldquo;就市场营销而言，我省与先进省份的差距主要体现在近几年飞速发展的电子商务提升工作。希望通过&lsquo;好品山东&rsquo;的建设和服务全省电子商务社会功能的不断完善和提高，为我省营造良好的发展氛围，为大家便利化开展电子商务业务提供一个服务平台。&rdquo;</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　&ldquo;好品山东是个新生事物，仅仅建成了9个月，功能和服务还在不断发展和完善过程中，但我相信他的未来，相信经过一段时间的建设和发展，一定能为在座的各位提供更有价值的服务。&rdquo;吴炎认为，通过&ldquo;好品山东&rdquo;网络营销服务平台开展网络营销业务，主要体现在四个&ldquo;更加&rdquo;上，分别为&ldquo;网络营销操作可以更加便捷了&rdquo;、&ldquo;更加经济了&rdquo;、&ldquo;效果更加显著了&rdquo;、&ldquo;管理和营销更加科学了&rdquo;。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　</span><strong style="word-spacing: 0px; font: bold 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">&ldquo;2014好品山东电商节&rdquo;预计7月中旬开幕</strong><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　据介绍，首届&ldquo;2014好品山东电商节&rdquo;将在山东省经信委的指导下，由好品山东网络营销服务平台联合山东省电子商务协会、杭州问道电子商务有限公司组织承办。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　本次电商节拟邀请中国电子商务协会、阿里、京东、当当网、唯品会、聚美优品、蘑菇街、美丽说、艾瑞咨询等国内电商龙头机构作为联合主办单位，联手举办好品山东电商节网购嘉年华活动。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　届时，各大参与活动的电商平台都将开辟专区，对好品山东电商节活动参展企业、产品进行网上集中推荐、展示、销售，将山东省优秀产品推荐到千家万户，在全省乃至全国营造浓厚的网络营销氛围，带动山东省企业电子商务的迅速启动与高速发展。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　根据活动规划，&ldquo;2014好品山东电商节&rdquo;活动将在7月中旬拉开大幕，届时，各大电商平台副总均将莅临好品山东，与好品山东及好品TOP100企业现场签约，并将联合企业召开中国首届电商服务产业峰会。8月上旬，2014好品山东将正式启动电商节网购嘉年华活动，与各大电商平台共建活动专场，活动将一直持续到12月底。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　值得一提的是，本次电商节的策划团队今年曾在东莞进行预演。三天之内，在仅有20多项单品的情况下，创造了500余万元的销售额。所以，此次电商节，好品山东整合省内现有资源打造的电商节效益值得期待。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　</span><strong style="word-spacing: 0px; font: bold 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">参与活动企业前期不收取任何费用</strong><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　本次沟通会可以看作为电商节大战之前的一场动员会与准备会。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　会上，国内知名网销专家、好品山东首席电商产业规划师李结林向与会企业详细介绍了首届2014年好品山东电商节的活动主旨、活动内容及时间规划，并与企业代表现场沟通互动，对企业关于本次电商节的疑问以及企业提出的电商人才短缺、定位模糊、网销平台如何选择等电商发展中的困惑一一进行了解答。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　大部分企业对电商节表示出极大的热情，明确表示将全力配合好品山东参与电商节，合力做好本次电商盛会，部分意愿强烈的企业今天下午留在了会场继续讨论合作计划，原本计划半天的见面会延长为一天。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　为保证电商节产品及服务质量，好品山东将在省经信委指导下，在全省集中筛选100家山东名优企业作为本次电商节参展企业，重点展示推荐山东省高新技术产品、优秀新产品、名牌产品、地方特色产品、特色产业集群，以形成强大的品牌集合影响力，打造&ldquo;鲁企、鲁商、鲁货&rdquo;新形象，提升我省企业产品品牌知名度，带动我省网络销售及电子商务发展。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　另外，参与活动的企业前期不收取任何费用，待活动结束后按照活动的交易额缴纳部分管理费用，而且其也不必再担心没有流量，推广费用高等问题。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	&nbsp;</p>\r\n<p>\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　目前，电商节TOP100企业仍在继续招募，尚未报名的企业，可联系好品山东官方微信订阅号(微信号HopingShanDong)索取报名材料，详情请拨打电话（0531）82608500-603进行咨询。</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　延伸阅读：滨州256家企业上线&ldquo;好品山东&rdquo;网络营销平台东营152家企业入驻&ldquo;好品山东&rdquo; 开拓国内外市场山东首批&ldquo;好品山东&rdquo;名企 &ldquo;潍坊面孔&rdquo;最多好品山东网络营销进潍坊企业 中国特产山东馆上线好品山东携京东商城共建中国特产山东馆淄博110家企业参与&ldquo;好品山东&rdquo; 网络营销全面提升&ldquo;好品山东&rdquo;网络营销培训会迎来120余家企业</span><br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="display: inline! important; float: none; word-spacing: 0px; font: 14px/24px 宋体, sans-serif; text-transform: none; color: rgb(37,37,37); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: justify; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　作者：满倩</span></p>', '互联网', '满倩', '齐鲁网', 'recommend', '2014-06-21'),
	(244, '中国电信快速发展网络支付业务', 'upload/images/1406961948046.jpg', '<p>\r\n	<span style="white-space: normal; text-transform: none; color: rgb(0,0,0); word-spacing: 0px; float: none; font: 14px/25px 宋体; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(245,248,253); text-indent: 0px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">　　中国电信2011年3月成立天翼电子商务有限公司，其初衷就是致力于创新探索&ldquo;金融、电信、互联网&rdquo;差异化发展模式。经过3年多时间的运营，翼支付业务已拥有超过8000万用户，合作商户超过8万家。与其他两家运营商所不同的是，中国电信一直坚持&ldquo;账户路径&rdquo;,在互联网时代留住用户最行之有效的方式就是创建个人账户，得账户者得天下，电信此举是为了把账户变成客户金融活动的根据地。</span></p>', '通信', '苏和', 'eNet硅谷动力', 'recommend', '2014-08-02'),
	(245, '银联网上与移动支付户数破1.5亿', '', '<div class="m_zy">\r\n	<strong>内容提要</strong>：记者29日从银联获悉，银联在互联网与移动支付领域已接入超过255家发卡银行。截至2014年7月，银联互联网与移动支付用户数突破1.5亿。随着用户规模的不断扩大，银联互联网与移动支付用户目前已遍布全国乃至境外，其中，广东以14.43%的占比位居各省市榜首，而中西部的用户占比正在逐步提升。从用 &hellip;&hellip;</div>\r\n<p>\r\n	<!-----正文-----></p>\r\n<div class="hidden">\r\n	<!--播放器开始-->\r\n	<p id="player1">\r\n		<!--播放器结束--></p>\r\n</div>\r\n<div class="m_text">\r\n	<p>\r\n		　　记者29日从银联获悉，银联在互联网与移动支付领域已接入超过255家发卡银行。截至2014年7月，银联互联网与移动支付用户数突破1.5亿。</p>\r\n	<p>\r\n		　　随着用户规模的不断扩大，银联互联网与移动支付用户目前已遍布全国乃至境外，其中，广东以14.43%的占比位居各省市榜首，而中西部的用户占比正在逐步提升。从用户使用习惯看，建行、招行、交行、农行、工行、中行等17家全国性银行发行的银联卡使用频率最高，占比超过96%。 (韦夏怡)</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '互联网', '', '经济参考报', 'recommend', '2014-08-02'),
	(246, '巴曙松：中国网络支付市场的发展趋势与安全', 'upload/images/1406962833406.jpg', '<p>\r\n	<strong>一、网络支付市场发展的基本格局、基本态势</strong></p>\r\n<p>\r\n	（一）中国互联网络信息中心（CNNIC）1月15日发布的《第31次中国互联网络发展状况统计报告》显示，截至2012年底，我国网民规模达到5.64亿，互联网普及率为42.1%；使用网上支付的用户规模是2.21亿，使用率是39.1%，和上一年相比用户增加5389万，增长率达到32.3%，这是在整体宏观经济回落背景下实现的快速增长。</p>\r\n<p>\r\n	（二）网络支付服务机构不断壮大。2013年2月28日，人民银行发放了第七批非金融机构支付业务许可证28张，累计已发放250余张支付业务许可证。其中，从事互联网支付、移动支付的非金融支付机构已超过80家。非金融支付机构获得支付业务许可证是政府监管部门主动适应市场需求进行引导、规范、推动的结果。</p>\r\n<p>\r\n	（三）在供求因素之外，业务应用领域不断拓展。网络支付业务的应用领域除了零售、团购等网上购物领域外，保险、基金、非税、高校、跨境支付、交通(铁路、公路等)等新兴的细分市场不断拓展。此外，对于传统零售业和制造业需求的不断挖掘，也为第三方支付市场提供了业务强劲增长的基础和发展空间。</p>\r\n<p>\r\n	（四）网络支付市场未来发展的空间巨大、前景广阔。艾瑞咨询研究报告显示，2012年，互联网支付市场交易规模约为3.82万亿元，按年增长70%左右。该交易规模约占全年社会消费品零售总额的18.54%。从调研情况看，市场普遍的观点是网上支付整体占比逐年增加，在不远的将来有望超过线下支付。中国银联统计的数据显示，2012年银行卡跨行交易总额是21.8万亿元，按照这个目标保守估计，3-5年内网络交易支付规模至少还有6倍左右的增幅。</p>\r\n<p>\r\n	同时，以互联网支付和移动支付为主体的网络支付市场中，发展热点正在悄然变化，未来增长可期。手机支付和手机金融成为新的增长点，随着移动支付技术标准的确立，支付企业在手机支付领域的布局和发力，带动了手机网上支付业务的快速增长。2012年，手机网上支付用户达到5531万，用户的年增长是80.9%，使用率是13.2%，各银行年报中披露的手机银行签约的客户数量已经达到1.2亿，增长迅速。</p>\r\n<p>\r\n	<strong>二、推动网络支付发展的主要因素、动力</strong></p>\r\n<p>\r\n	首先，电子商务超预期增长，成为网络支付市场发展的基础。工信部2012年一季度发布的《电子商务&ldquo;十二五&rdquo;发展规划》预计，十二五期间，电子商务的交易额会翻两番，突破18万亿元。其中，企业间电子商务交易规模将超过15万亿元。网络零售交易总额将突破3万亿元，占社会消费品零售总额的比例将超过9%。各方数据显示，2012年网络支付规模已经超越了电子商务&ldquo;十二五&rdquo;发展规划的预测，电子商务超预期的快速增长，预示着网上支付行业发展的空间在不断打开。</p>\r\n<p>\r\n	其次，人民银行及时的监管对行业发展发挥了积极作用，人民银行发布的《非金融机构支付服务管理办法》明确了非金融支付行业的地位及业务属性，设立了行业的准入门坎，从备付金安全、实名制规范、反洗钱与反恐怖融资、支付风险管理、客户权益保护等方面提出了监管要求。二号令出台以后整个行业得到了制度红利，200多家机构拿到牌照，找到更多传统行业的合作伙伴，提升了行业的声誉，消费者能够更放心地使用电子支付服务，行业主体在市场前景的感召下也加大了投入，所以市场主体开始向行业的纵深拓展，创新服务模式，开拓以传统行业B2B的电子商务解决方案为代表的全新的业务体系。</p>\r\n<p>\r\n	<strong>三、网络支付的发展情况及安全现状</strong></p>\r\n<p>\r\n	网络支付在提高支付效率的同时，安全性始终是各参与方密切关注的一个方面。欧央行在其《互联网支付安全建议》中强调，当前监管者、立法者、支付服务提供者以及社会公众的感觉是，通过互联网进行支付，遭受欺诈的概率要高于传统支付方式，实际上国内社会公众也普遍存在着网络支付受欺诈概率比较高的观点。但是从我们调查的实际数据来看，消费者的主观感受与实际情况有着明显的差异。从实际情况来看，中国网络支付仍处于培育发展阶段，安全风险可控，总体运行平稳，但需进一步规范，潜在风险须重视。</p>\r\n<p>\r\n	首先，整个网络支付行业在短短的14年间从零增长到万亿级规模，如果没有一定的风险控制能力，没有强大的数据管理能力，要达到这样的市场规模是很难想象的。市场主体的风险可控，再加上政府监管，行业的整体风险是可控的。经过近十年的发展，国内互联网支付企业在安全方面的投入规模非常大，网上支付的安全技术不断完善，包括Usbkey、动态口令、证书、钓鱼网站的实时拦截等等，已经广泛应用。从调研的一些主流支付机构的情况看，总体的风险管理能力是可接受的，国内网络支付平均盗卡的欺诈水平在0.01%，主流的支付机构风险水平更低。</p>\r\n<p>\r\n	国际网络欺诈盗卡率大概在1-2%，甚至有的更高。国际领先的支付企业Paypal的网上支付商户拒付比例为0.27%，包括极少数没有到货的情况。Paypal有庞大的风控团队，有着多年发展的风险控制系统和经验，一万多人里面有一半是做风险管理的，所以它的风险水平是有代表性的。</p>\r\n<p>\r\n	其次，在风险防控方面，国内和国外的差距一方面是业务模式和风险控制手段不一样，还有就是在理念上，国外并不是一味的压低风险，而是达到收入和成本之间的平衡。对银行来说，零不良率不一定是最好的。金融机构本身就是通过承担风险获得收益，这是它存在的理由，所以如果不良率保持在1-2%，但是能覆盖成本，获得正收益，这就是风险收益平衡的概念，所以设定一定比例下的风险容忍度，有助于鼓励支付机构在支付业务中更加注重诚信的作用。</p>\r\n<p>\r\n	第三，整体产业链上的安全防范水平参差不齐，从银行端到第三方支付到商户，内部的风险管理、安全防范水平呈现出一个逐渐降低的趋势，部分第三方支付机构挣扎在生存边缘，安全投入有待提高；行业的安全联防协作程度有待提高，高风险的客户、商户、IP地址等黑名单共享方面有待加强。</p>\r\n<p>\r\n	第四，网络环境也存在着一些潜在的风险，据统计看，植入后门网站激增70%。2012年10月份，中国境内数据统计，中国被植入后门的网站有7366个，比9月份4334个增长了70%，在主要的节假日期间，监测发现平均每一秒拦截157次购物钓鱼网站的仿冒页面。据监测，2010年中国大陆近3.5万个网站被篡改，数量比2009年下降21.5%，但其中被篡改的政府网站高达4635个，比2009年上升了67.6%，2010年被篡改的政府网站的数量占境内被篡改网站数量13.3%。</p>\r\n<p>\r\n	<strong>四、网络支付安全的关注点和趋势</strong></p>\r\n<p>\r\n	2013年荷兰的海牙将成立欧洲网络犯罪执法部门，这既是欧洲网络支付安全管理的最新动向，也是全球范围内共同关注的一个领域。</p>\r\n<p>\r\n	要从前瞻性的角度，关注网络支付安全对网络支付行业国际竞争力的影响。网络跨境支付发展到一定阶段后，游戏规则及安全要求发生了变化。大家非常关注的华为、中兴这些中国的IT企业被美国众议院情报委员会认定为可能会威胁美国国家通讯安全。网络支付是否会遇到及如何避免这些问题，也关乎到中国的互联网企业的国际竞争力。</p>\r\n<p>\r\n	网络支付安全和效率的关系是网络支付发展中的关键问题。网络支付业务具有互联网和金融的双重特征。金融特征就是指这些公司有自己的虚拟账户，可以沉淀和流转资金，管理要求很高，容错率很低，100%风险备付，没有杠杆；互联网特征指所处的产业以及提供的服务都是在互联网上进行的，必须符合互联网的产业特点、规模要求、分工协同要求以及市场效应要求等等。这种双重特征使网络支付面临着安全与效率目标的双重追求。</p>\r\n<p>\r\n	从未来支付安全的技术趋势来看，第一是智能的实时防控系统，由机器完成的通过相应规则对交易进行实时筛查的监控系统，通过数据分析、挖掘等等建立一整套规则体系，来捕捉异常的或者有风险的操作账户，系统初步筛查，配合人工核查，最终锁定风险交易，控制风险账户，从事后响应转为事中响应，从而提高风险防控效率。第二是大数据在安全方面的应用，体现了信息间的协同，互联网技术提供了这个可能性，通过手机、电话等大量的行为状态记录，存储到云端服务器，将来可以通过对人的行为的连续性进行综合分析，而不仅仅是通过密码和密钥来分析。</p>\r\n<p>\r\n	<!-- @end 文章内容 --><span class="fz12 cor999">(责任编辑：小晨)</span> <!-- 相关阅读 --></p>', '互联网', '巴曙松', '南华早报', 'recommend', '2014-08-02'),
	(247, '盛夏里的大学生专场招聘会', 'upload/images/1406963871890.jpg', '<p>\r\n	<span style="white-space: normal; text-transform: none; color: rgb(72,72,72); word-spacing: 0px; float: none; font: 14px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(249,249,249); text-indent: 28px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">2014年8月2日，江西省新余市渝水区大学生专场招聘会现场人头攒动。</span><br style="white-space: normal; text-transform: none; color: rgb(72,72,72); word-spacing: 0px; font: 14px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; background-color: rgb(249,249,249); text-indent: 28px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px" />\r\n	<span style="white-space: normal; text-transform: none; color: rgb(72,72,72); word-spacing: 0px; float: none; font: 14px/28px 宋体; letter-spacing: normal; orphans: 2; widows: 2; display: inline !important; background-color: rgb(249,249,249); text-indent: 28px; -webkit-text-size-adjust: auto; -webkit-text-stroke-width: 0px">&nbsp;&nbsp;&nbsp;&nbsp;为拓宽高校毕业生的就业渠道，当日，新余市渝水区劳动就业局举办2014年大学生专场招聘会暨未就业大学生现场实名登记活动。90余家用人单位提供就业岗位1000余个，涉及光伏、机械加工、电子、化工、旅游专业等，吸引了上千名求职者入场应聘，现场签订就业意向书的达350余人，现场进行实名登记未就业大学生160名。招聘会现场还为求职大学生提供了政策咨询、就业指导、创业培训、小额贷款等&ldquo;一站式&rdquo;就业服务。</span></p>', '教育', '', '光明网', 'recommend', '2014-08-02'),
	(248, '沃尔沃/雷克萨斯完成人事调整 二线豪车再发力', 'upload/images/1408162519703.jpg', '<p align="center" style="font-family: 宋体; font-size: 10pt">\r\n	2014年上半年豪华品牌上牌量数据</p>\r\n<p class="titdd-Article">\r\n	[<strong>摘要</strong>]豪车&ldquo;第二阵营&rdquo;的竞争呈现出胶着的态势。上牌量上沃尔沃首次超越雷克萨斯挺进前五，而就在同时，两家企业也开始了新一轮的人事调整布局。</p>\r\n<p style="text-indent: 2em">\r\n	[腾讯汽车<!--keyword-->（<span class="infoMblog"><a class="a-tips-Article-QQ" href="http://t.qq.com/qqauto#pref=qqcom.keyword" rel="qqauto" reltitle="腾讯汽车" target="_blank">微博</a></span>)<!--/keyword-->原创报道 宋双辉]2014年对于中国豪华汽车市场来说注定是极不平凡的一年。在一路高歌猛进的势头下，反垄断调查的大锤猛地惊醒了一众豪华品牌。常年盘踞销量前三甲的德系三剑客纷纷中枪，在面临高额罚金的同时品牌形象也受到了重创。反观后几名&ldquo;二线&rdquo;品牌，却在超高的增速下奋力破局，向第四名的位置发起了猛攻。上牌量上<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/177/" target="_blank" title="沃尔沃"><!--/keyword-->沃尔沃<!--keyword--></a><!--/keyword-->首次超越<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/158/" target="_blank" title="雷克萨斯"><!--/keyword-->雷克萨斯<!--keyword--></a><!--/keyword-->挺进前五，而就在同时，两家企业也开始了新一轮的人事调整布局。</p>\r\n<p style="text-indent: 2em">\r\n	<strong>上牌量沃尔沃首超雷克萨斯</strong></p>\r\n<p style="text-indent: 2em">\r\n	根据最新出炉的2014上半年汽车行业上牌数，豪车第二阵营的位置发生了改变：<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/140/" target="_blank" title="奥迪"><!--/keyword-->奥迪<!--keyword--></a><!--/keyword-->、<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/141/" target="_blank" title="宝马"><!--/keyword-->宝马<!--keyword--></a><!--/keyword-->、<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/143/" target="_blank" title="奔驰"><!--/keyword-->奔驰<!--keyword--></a><!--/keyword-->分别以26.83、20.86和13.45万辆的上牌数量位于榜单前三甲。<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/163/" target="_blank" title="路虎"><!--/keyword-->路虎<!--keyword--></a><!--/keyword-->仍旧以5.17万辆的成绩排名第四，而第五的位置却被沃尔沃夺下，雷克萨斯滑落至第六位。&nbsp;</p>\r\n<p style="text-indent: 2em">\r\n	而根据另一份上半年销量数据，雷克萨斯依然排名第四，不过与沃尔沃之间的差距不足千辆。</p>\r\n<p align="center">\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<div class="mbArticleSharePic   " r="1" style="width: 357px">\r\n	<div class="mbArticleShareBtn">\r\n		<span>转播到腾讯微博</span></div>\r\n	<img alt="沃尔沃/雷克萨斯完成人事调整 二线豪车再发力" src="http://img1.gtimg.com/auto/pics/hv1/199/33/1681/109315639.jpg" /></div>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p align="center" style="font-family: 宋体; font-size: 10pt">\r\n	2014年上半年豪华品牌销量数据</p>\r\n<p style="text-indent: 2em">\r\n	<strong>人事重新布局 重点发力营销</strong></p>\r\n<p style="text-indent: 2em">\r\n	从上表中的数据可以看出，如今第二阵营的竞争已经到了胶着化的程度。无论是在国产化，还是引进车型、市场营销以及售后方面，几家品牌的投入力度都是前所未有的。一贯保守的雷克萨斯在进入中国十年之后将发布直通2025年的未来10年在华全新品牌战略，&ldquo;更好地向中国消费者诠释和传递品牌形象&rdquo;将是这份战略的核心。而在战略发布前，雷克萨斯提前完成了人事上的布局，破天荒的引入了前&ldquo;<a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_serial/338/index.shtml" target="_blank">MINI</a>中国掌门人&rdquo;朱江作为主管市场的副总。</p>\r\n<p style="text-indent: 2em">\r\n	雷克萨斯中国执行副总经理江积哲也（<a class="a-tips-Article-QQ" href="http://auto.qq.com/d/person/1/164/" target="_blank">点击查看最新人物消息</a>）曾对腾讯汽车表示，如果把自己置身事外，单纯的作为一个雷克萨斯的车迷，他认为&ldquo;雷克萨斯有这么多好的车型，但是在宣传和广告方面做得太不够了。&rdquo;而引入朱江，正是要弥补这一短板。不久前雷克萨斯品牌体验展厅活动上，朱江完成首秀，在此之后还未见雷克萨斯有太多动作。</p>\r\n<p style="text-indent: 2em">\r\n	而反观沃尔沃，在2012年付强（<a class="a-tips-Article-QQ" href="http://auto.qq.com/d/person/1/172/" target="_blank">点击查看最新人物消息</a>）加盟之后，也带来了昔日伙伴柳燕（<a class="a-tips-Article-QQ" href="http://auto.qq.com/d/person/1/173/" target="_blank">点击查看最新人物消息</a>），组成了沃尔沃在华销售团队的稳定阵容。之后沃尔沃在华的销量一直呈现稳定增长态势。2013年，沃尔沃在中国市场实现销售同比增长45.6%。2014年7月沃尔沃在华单月销量达6,858辆，同比增长高达47.8%。在华前7个月累计销量45,414辆，增幅为36.2%。</p>\r\n<p style="text-indent: 2em">\r\n	出于对中国区销售团队工作的认可，同时也为了更好的在第二本土市场实现销售和品牌影响力的进一步突破，沃尔沃汽车<!--keyword-->(<span class="infoMblog"><a class="a-tips-Article-QQ" href="http://t.qq.com/volvocars#pref=qqcom.keyword" rel="volvocars" reltitle="沃尔沃汽车" target="_blank">微博</a></span>) <!--/keyword-->集团中国区近日宣布，沃尔沃汽车（中国）销售公司销售与市场执行副总裁柳燕自9月1日起升任销售公司首席运营官，&ldquo;她将在公司业务发展新阶段的战略规划和执行中担当更大职责，并继续向销售公司总裁兼首席执行官付强先生汇报工作。&rdquo;同时曾经作为吉利收购沃尔沃项目骨干成员的袁小林也将从沃尔沃汽车集团总部哥德堡回归沃尔沃中国担任中国区总裁一职。</p>\r\n<p style="text-indent: 2em">\r\n	与雷克萨斯积极引入外援不同，沃尔沃更强调在稳定的现有团队中提升骨干成员的职权和话语权。而两家品牌人事调整的相同之处，则是都加强了市场营销方面的投入。同为第二阵营，在<!--keyword--><a class="a-tips-Article-QQ" href="http://data.auto.qq.com/car_brand/180/" target="_blank" title="英菲尼迪"><!--/keyword-->英菲尼迪<!--keyword--></a><!--/keyword-->大秀&ldquo;敢爱&rdquo;的时候，形象都相对保守低调的雷克萨斯和沃尔沃都选择着另一条路来提升品牌影响力。</p>', '汽车', '宋双辉', '腾讯汽车', 'recommend', '2014-08-16'),
	(249, '农民竟然是豪华别墅群的房东 却连别墅门都没进过(图)', 'upload/images/1408162665375.jpg', '<p style="text-align: center">\r\n	&nbsp;<span style="font-family: 楷体_GB2312, 楷体">别墅群场</span></p>\r\n<p>\r\n	原标题：仓山浦口农民新村用地变<a href="http://app.house.ifeng.com/pic/sc/149/1" target="_blank"><strong><font color="#004276">别墅</font></strong></a>区　村民莫名成房东</p>\r\n<p>\r\n	福州新闻网8月16日讯　仓山区盖山镇浦口村的村民近日向本报记者反映，该村一块农民新村建设用地竟成了豪华别墅区，里面的39栋别墅均已建好约10年，村民们多次向有关部门举报，但别墅一直没被拆除，相关责任人也一直未受查处。</p>\r\n<p>\r\n	<strong>39栋别墅</strong></p>\r\n<p>\r\n	<strong>已建好约10年</strong></p>\r\n<p>\r\n	昨天，记者在浦口村看到，一堵高大的围墙把别墅区与外面坑坑洼洼的村道完全隔开。记者登上围墙外一户村民家的三楼<a href="http://app.house.ifeng.com/pic/sc/32/1" target="_blank"><strong><font color="#004276">阳台</font></strong></a>，发现这些别墅的占地面积都不小，每栋都在3层左右，独门独户，造型颇具古典风格。别墅周围的庭院内铺着草坪，种着绿树，还设有独立的停车位，别墅之间由铺着地砖的小路相连。整个别墅区宛若一个漂亮的大花园，与围墙外杂乱破烂的民房形成鲜明对比。</p>\r\n<p>\r\n	村民们表示，围墙内的别墅共有39栋，均是在2004年前后建起来的。</p>\r\n<div style="page-break-after: always">\r\n	<span style="display: none">&nbsp;&nbsp;&nbsp; </span><strong>村民成挂名房东</strong></div>\r\n<p>\r\n	<strong>别墅门都没进过</strong></p>\r\n<p>\r\n	虽然这些别墅的产权证上大多是村民的名字，但这些村民连别墅的大门都没进过。</p>\r\n<p>\r\n	住在别墅区附近的村民黄建彬告诉记者，前几年他偶然得知自己居然也是这些别墅的挂名房东之一。他向记者出示了复印的房产证，上面的信息显示，黄建彬是浦口村农民新村一栋3层房屋的3个共有房东之一，房子的总建筑面积有400多平方米。据黄建彬了解，这栋房子的另两个共有人也是浦口村的村民，均只是挂个名。</p>\r\n<p>\r\n	村民们称，这一切都是村委会主任黄珍胜一手操作的。他假借新农村建设之名，将政府部门批给浦口村民建新村住房的土地圈起来后建别墅，并以每栋200多万元的高价卖给社会上的人。&ldquo;这些人一般是在晚上或周末才入住别墅，坐小车进出，从不跟村民来往。&rdquo;黄建彬说。</p>\r\n<p>\r\n	&ldquo;我们发现这个问题后多次向有关部门举报，不知道为什么违建别墅一直没被拆除，有关责任人也一直没被处理。&rdquo;村民们质疑道。</p>\r\n<p>\r\n	<strong>国土部门确认</strong></p>\r\n<p>\r\n	<strong>违法用地行为</strong></p>\r\n<p>\r\n	村民们向记者出示了国土部门对村民反映问题的书面回复意见，上面还盖有国土部门的公章。记者看到，去年省国土资源厅作出的《信访事项复核意见书》中明确指出：&ldquo;经复核，村民们反映的地块系浦口村新村建设用地地块。2003年10月，福州市国土资源局仓山分局对该农民新村建设共审批65户，每户用地面积为66平方米。该农民新村于2003年底建成围墙，占地面积为51.17亩，比实际审批面积(23.3亩)超出27.87亩。2004年起，福州市国土资源局仓山分局先后多次对该违法用地行为进行制止、查处。2005年7月，该分局执法人员两次遭到违建村民和社会闲杂人员围攻、阻挠。该分局已将案件移送公安机关处理，目前该案正由公安机关侦办。&rdquo;</p>\r\n<p>\r\n	盖山镇政府、福州市国土资源局仓山分局昨日均表示，浦口村民反映的违建别墅问题很复杂，要等公安机关的调查结果出来后才能做进一步处理。</p>\r\n<p>\r\n	市公安局仓山分局相关工作人员表示，黄珍胜涉嫌经济犯罪，已由经侦大队展开调查，村民们此前曾多次反映相关问题，警方一定会抓紧时间办案。</p>', '房地产', '陈鸿星', '福州晚报', 'recommend', '2014-08-16'),
	(251, '最该注意的装修风水 保证你一生顺风顺水', 'upload/images/1408163336046.jpg', '<p>\r\n	一、卧房形状为斜边或是多角形状。</p>\r\n<p>\r\n	斜边容易造成视线上的错觉，多角容易造成压迫，因而增加人的精神负担，长期下来容易罗患疾病及发生意外。</p>\r\n<p>\r\n	二、卧房昏暗</p>\r\n<p>\r\n	卧房应设有窗户，除了空气得以流通，白天更可以采光，使人精神畅快，而晚间窗户应备有窗帘，挡住<a href="http://travel.ifeng.com/outdoor/list_0/0.shtml" target="_blank"><strong><font color="#004276">户外</font></strong></a>夜光，使人容易入眠。</p>\r\n<p>\r\n	三、浴厕改成卧房</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i7.hexunimg.cn/2013-07-23/156399952.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>三、浴厕改成卧房</span></p>\r\n<p>\r\n	<a href="http://app.house.ifeng.com/pic/sc/84/1" target="_blank"><strong><font color="#004276">现代</font></strong></a>大楼管线整体施工，所以整栋大楼浴厕都设在同一地方。如果将浴厕改为卧房，势必造成睡在楼上和楼下两层的浴厕当中，而浴厕本为潮湿、不洁之所，夹在当中必然对环境卫生有所影响，另外当楼上马桶、水管一开动也绝对会影响到您的安宁，所以对人的身心健康造成伤害</p>\r\n<p>\r\n	四、房门对大门</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="310" src="http://i9.hexunimg.cn/2013-07-23/156399960.jpg" style="cursor: pointer" title="点击进入下一页" width="578" /></p>\r\n<p class="picIntro">\r\n	<span>四、房门对大门</span></p>\r\n<p>\r\n	卧房为休息的地方，需要安静、隐密，而大门为家人、朋友进出必经的地方，所以房门对大门不符合卧房安静的条件。大门直冲房门容易影响健康和财运</p>\r\n<p>\r\n	五、房门正对卫生间</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="377" src="http://i8.hexunimg.cn/2013-07-23/156399963.jpg" style="cursor: pointer" title="点击进入下一页" width="596" /></p>\r\n<p class="picIntro">\r\n	<span>五、房门正对卫生间</span></p>\r\n<p>\r\n	卫生间是供人排泄的地方，容易产生秽气和湿气，所以正对房门会对卧房的空气产生影响，对人的生体健康有害</p>\r\n<p>\r\n	六、房门正对<a href="http://app.house.ifeng.com/pic/sc/7/1" target="_blank"><strong><font color="#004276">厨房</font></strong></a>或和厨房相邻</p>\r\n<p>\r\n	厨房炉火煎炒、排出油烟，容易影响正对的房门，危害人体健康，并且使工作表现不稳定。厨房是生火之处，甚为燥热，所以也不宜与卧房相邻，尤其是睡床紧贴炉灶的墙</p>\r\n<p>\r\n	七、房门对镜子</p>\r\n<p>\r\n	镜子有反射作用，在<a href="http://house.ifeng.com/home/jjfs/list_0/0.shtml" target="_blank"><strong><font color="#004276">风水</font></strong></a>上可将煞气反射回去，所以可挡凶煞。但是镜子对着房门会将凶煞冲克照进卧房，招来不好运势</p>\r\n<p>\r\n	八、镜子与落地门窗对<a href="http://app.house.ifeng.com/pic/sc/38/1" target="_blank"><strong><font color="#004276">床</font></strong></a></p>\r\n<p>\r\n	镜子是用来挡煞，作用是把煞气反射回去，所以不可对床。尤其人们从睡梦中醒来，在意识不很清楚时，容易被映在镜子或落地窗里的自己所惊吓</p>\r\n<p>\r\n	九、睡床或床头对正房门</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i6.hexunimg.cn/2013-07-23/156399980.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>九、睡床或床头对正房门</span></p>\r\n<p>\r\n	睡觉时最讲求安全、安静和稳定，房门是进出房间必经之所，因此房门不可对正睡床或床头。否则睡床上的人容易缺乏安全感，并且有损健康</p>\r\n<p>\r\n	十、床头紧贴窗口</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i0.hexunimg.cn/2013-07-23/156399984.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>十、床头紧贴窗口</span></p>\r\n<p>\r\n	窗户为理气进出之所，所以床头贴近窗口容易犯冲。在睡床上的人因看不见头上的窗口，容易缺乏安全感，造成精神紧张，影响健康</p>\r\n<p>\r\n	十一、床头在横梁下</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i6.hexunimg.cn/2013-07-23/156400000.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>十一、床头在横梁下</span></p>\r\n<p>\r\n	天花板宜平坦，忌有横梁。横梁在心理上容易产生重体的感觉，尤其人睡在横梁之下会感受到莫大的压力，造成精神上的压迫，影响健康、事业</p>\r\n<p>\r\n	十二、床头不靠墙壁</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i6.hexunimg.cn/2013-07-23/156400001.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>十二、床头不靠墙壁</span></p>\r\n<p>\r\n	人平躺时不容易看见头顶上，所以床头宜靠墙、避免露空，而减少安全感。否则睡在床上的人，容易精神恍惚、疑神疑鬼，影响健康、事业</p>\r\n<p>\r\n	十三、<a href="http://app.house.ifeng.com/pic/sc/38/1" target="_blank"><strong><font color="#004276">床</font></strong></a>紧贴地面</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="317" src="http://i5.hexunimg.cn/2013-07-23/156400002.jpg" style="cursor: pointer" title="点击进入下一页" width="573" /></p>\r\n<p class="picIntro">\r\n	<span>十三、床紧贴地面</span></p>\r\n<p>\r\n	床面应离开地面50公分左右(小区网论坛)，床底必需保持清洁，不宜堆积杂物。离开地面，并且不堆积杂物能保持床底空气畅通，减少地面湿气渗透入床垫，而影响健康</p>\r\n<p>\r\n	十四、卧房摆过多的植物</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="324" src="http://i1.hexunimg.cn/2013-07-23/156400005.jpg" style="cursor: pointer" title="点击进入下一页" width="518" /></p>\r\n<p class="picIntro">\r\n	<span>十四、卧房摆过多的植物</span></p>\r\n<p>\r\n	过多的花草植物容易聚集阴气，并且植物于晚间吸收氧气、释放二氧化碳，所以容易影响人的身体健康</p>\r\n<p>\r\n	十五、电器过多，尤其电视正对床脚</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="301" src="http://i1.hexunimg.cn/2013-07-23/156400007.jpg" style="cursor: pointer" title="点击进入下一页" width="561" /></p>\r\n<p class="picIntro">\r\n	<span>十五、电器过多，尤其电视正对床脚</span></p>\r\n<p>\r\n	<a href="http://app.house.ifeng.com/pic/sc/30/1" target="_blank"><strong><font color="#004276">卧室</font></strong></a>内电器过多在<a href="http://house.ifeng.com/home/jjfs/list_0/0.shtml" target="_blank"><strong><font color="#004276">风水</font></strong></a>上被称为&ldquo;火宅&rdquo;，影响健康。现代医学理论也指出，电器辐射确实损害人体健康。脚是人的第二心脏，处于待机状态的电视若正对床脚，其辐射更容易影响双脚的经络运行及血液循环。</p>\r\n<p>\r\n	专家建议：少在卧室摆放电器，尤其不要将电视正对床脚，不使用时拔掉电源</p>\r\n<p>\r\n	十六、卧室面积超过20平方米</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="307" src="http://i0.hexunimg.cn/2013-07-23/156400008.jpg" style="cursor: pointer" title="点击进入下一页" width="562" /></p>\r\n<p class="picIntro">\r\n	<span>十六、卧室面积超过20平方米</span></p>\r\n<p>\r\n	古代风水理论指出&ldquo;屋大人少，是凶屋&rdquo;，认为&ldquo;大房子会吸人气&rdquo;。因此，即使是皇帝的寝宫，面积也不会超过20平方米。 其实风水中所说的&ldquo;人气&rdquo;就是我们后来发现的&ldquo;人体能量场&rdquo;。人体是一个能量体，无时无刻不在向外散发能量，就像工作中的空调，房屋面积越大所耗损的能量就越多。因此，卧室面积过大肯恶导致人体因耗能过多而免疫力下降、无精打采、判断力下降、做出错误决定、甚至&ldquo;倒霉&rdquo;生病。</p>\r\n<p>\r\n	专家建议：卧室面积控制在10-20平方米为佳</p>\r\n<p>\r\n	十七、窗口大，朝东或朝西</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="337" src="http://i8.hexunimg.cn/2013-07-23/156400010.jpg" style="cursor: pointer" title="点击进入下一页" width="545" /></p>\r\n<p class="picIntro">\r\n	<span>十七、窗口大，朝东或朝西</span></p>\r\n<p>\r\n	风水师指出睡在窗口大、朝东或朝西的房间中容易因&ldquo;光煞&rdquo;导致&ldquo;血光之灾&rdquo;。因为在朝东或朝西的房间，早上或下午猛烈的阳光会导致卧室内光线过强，刺激神经影响休息，导致失眠，更使人变得不棱镜、冲动易怒。</p>\r\n<p>\r\n	专家建议：选择窗口不大、朝北或朝南的房间为卧室。如果已经住进了朝东或朝西的房间，暂时不可能变换，那么就注意在适当的时候拉好窗帘</p>\r\n<p>\r\n	十八、床正上方的屋顶装有吊灯</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="382" src="http://i8.hexunimg.cn/2013-07-23/156400011.jpg" style="cursor: pointer" title="点击进入下一页" width="590" /></p>\r\n<p class="picIntro">\r\n	<span>十八、床正上方的屋顶装有吊灯</span></p>\r\n<p>\r\n	风水上将&ldquo;床正上方的屋顶装有吊灯&rdquo;称为&ldquo;吊灯压床&rdquo;，认为&ldquo;煞气重&rdquo;。对健康不利。现代心理学研究发现，床正上方的屋顶若装有吊灯，确实会给人以心理暗示，增加人心理压力，影响内分泌，进而引起失眠、恶梦、呼吸系统急病等一系列健康问题。</p>\r\n<p>\r\n	专家建议：保持床正上方屋顶的空旷，在床边使用光线柔和的落地灯或台灯。</p>\r\n<p>\r\n	住宅风水，最好是根据主人的特点度身定造。但是也有一些普遍的原则是适用的，就是在居家布置中，不能犯一些风水上的大忌，否则会住得不舒适，而且对主人会有不利影响。以下是居家风水布置17条禁忌，看看你家的风水布置有没有与之冲突的地方</p>\r\n<p>\r\n	十九、<a href="http://app.house.ifeng.com/pic/sc/30/1" target="_blank"><strong><font color="#004276">卧室</font></strong></a>的色调不可太过鲜艳，否则对运气不利。</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" height="392" src="http://i2.hexunimg.cn/2013-07-23/156400015.jpg" style="cursor: pointer" title="点击进入下一页" width="555" /></p>\r\n<p class="picIntro">\r\n	<span>十九、卧室的色调不可太过鲜艳，否则对运气不利</span></p>\r\n<p>\r\n	卧室不可布置得琳琅满目卧室的色调以素雅温暖为宜，切忌太过鲜艳，也不要布置得琳琅满目，过度豪华，闪闪发光的饰物尤为不宜。</p>\r\n<p>\r\n	二十、家里常青盆栽，很好。</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i3.hexunimg.cn/2013-07-23/156400016.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>二十、家里常青盆栽，很好。</span></p>\r\n<p>\r\n	常青盆栽利家运由于生活品位的提高，为了增加室内的绿意，常青盆栽是很好的室内饰物，但务必选择常绿、生命力强，不易凋谢、落叶的植物</p>\r\n<p>\r\n	二十一、入门必见<a href="http://app.house.ifeng.com/pic/sc/17/1" target="_blank"><strong><font color="#004276">客厅</font></strong></a>，否则退运。</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i5.hexunimg.cn/2013-07-23/156400017.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>二十一、入门必见客厅，否则退运。</span></p>\r\n<p>\r\n	入门先见厨厕，退运之宅所有的屋子，入门必见客厅。现代的建筑设计，有时为了考虑空间的配置，一进门往往先见到厨房、餐厅或浴厕。这是阳宅的大忌，也不合常理，居住其中，家运必衰</p>\r\n<p>\r\n	二十二、不规则房间不可用做夫妇的主卧房</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i7.hexunimg.cn/2013-07-23/156400020.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>二十二、不规则房间不可用做夫妇的主卧房</span></p>\r\n<p>\r\n	不规则屋不宜做卧室不规则的房间不可用做夫妇的主卧房，否则会导致久婚不孕的后果</p>\r\n<p>\r\n	二十三、客厅在屋子正中，可使家运昌隆</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i5.hexunimg.cn/2013-07-23/156400023.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>二十三、客厅在屋子正中，可使家运昌隆</span></p>\r\n<p>\r\n	客厅在屋子正中，可使家运昌隆</p>\r\n<p>\r\n	二十四、客厅在屋子正中，可使家运昌隆</p>\r\n<p class="detailPic">\r\n	<img alt="点击进入下一页" src="http://i9.hexunimg.cn/2013-07-23/156400026.jpg" style="cursor: pointer" title="点击进入下一页" /></p>\r\n<p class="picIntro">\r\n	<span>二十四、客厅在屋子正中，可使家运昌隆</span></p>\r\n<p>\r\n	客厅在屋子正中大吉一般住宅，如果起居室或客厅设在整幢房子的正中间，这是一种大吉之象，可使家运昌隆</p>\r\n<p>\r\n	二十五、不规则屋如用来做<a href="http://app.house.ifeng.com/pic/sc/7/1" target="_blank"><strong><font color="#004276">厨房</font></strong></a>，会影响家人健康</p>\r\n<p>\r\n	二十五、不规则屋如用来做厨房，会影响家人健康</p>\r\n<p>\r\n	不规则屋不可做厨房不规则屋如用来做厨房，会影响家人健康，不规则屋只可用来做储藏间用</p>\r\n<p>\r\n	二十六、横梁压顶，会影响健康。</p>\r\n<p class="detailPic">\r\n	<img alt="二十六、横梁压顶，会影响健康。" src="http://i7.hexunimg.cn/2013-07-23/156400030.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>二十六、横梁压顶，会影响健康。</span></p>\r\n<p>\r\n	横梁压顶，影响情绪与健康横梁最忌压在<a href="http://app.house.ifeng.com/pic/sc/38/1" target="_blank"><strong><font color="#004276">床</font></strong></a>头、书桌及餐桌上方，如实在无法避免，也要设计天花板，将之挡住，否则就会影响居者的情绪与健康，事业运亦会受阻</p>\r\n<p>\r\n	二十七、浴厕对床，会患恶疾。</p>\r\n<p class="detailPic">\r\n	<img alt="二十七、浴厕对床，会患恶疾。" src="http://i0.hexunimg.cn/2013-07-23/156400031.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>二十七、浴厕对床，会患恶疾。</span></p>\r\n<p>\r\n	浴厕对床，当心恶疾主卧室中，除了床不可正对浴厕之外，侧对亦不吉，容易使人罹患严重恶疾</p>\r\n<p>\r\n	二十八、床头挂画太大，非死即伤，不可不慎。</p>\r\n<p class="detailPic">\r\n	<img alt="二十八、床头挂画太大，非死即伤，不可不慎" src="http://i2.hexunimg.cn/2013-07-23/156400032.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>二十八、床头挂画太大，非死即伤，不可不慎</span></p>\r\n<p>\r\n	床头巨画大不宜床头置画可以增加卧室之雅意，但以轻薄短小为宜，最忌厚重巨框之大画，否则一旦挂钩脱落，当头砍下，非死即伤，不可不慎</p>\r\n<p>\r\n	二十九、浴室阴湿、不洁、有异味，破财。</p>\r\n<p class="detailPic">\r\n	<img alt="二十九、浴室阴湿、不洁、有异味，破财。" src="http://i0.hexunimg.cn/2013-07-23/156400034.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>二十九、浴室阴湿、不洁、有异味，破财。</span></p>\r\n<p>\r\n	整洁的浴厕才能留财浴厕是排污之所，除了方位要合规中局之外，最忌阴湿、不洁、有异味，如能保持清洁干爽反而能留住财气</p>\r\n<p>\r\n	三十、居室数房排列，难得平安。</p>\r\n<p class="detailPic">\r\n	<img alt="三十、居室数房排列，难得平安。" src="http://i5.hexunimg.cn/2013-07-23/156400042.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>三十、居室数房排列，难得平安。</span></p>\r\n<p>\r\n	大门直通到底，麻烦不断居家忌象宾馆饭店一样一条长廊连着一排数个房间，否则易发生外遇及私奔现象，难得平安</p>\r\n<p>\r\n	三十一、浴厕在走廊尽头，大凶。</p>\r\n<p class="detailPic">\r\n	<img alt="　三十一、浴厕在走廊尽头，大凶。" src="http://i1.hexunimg.cn/2013-07-23/156400047.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>三十一、浴厕在走廊尽头，大凶。</span></p>\r\n<p>\r\n	浴厕设在走廊尽头，大凶屋内如有走廊，浴厕只宜设在走廊边上，不可设在尽头，否则大凶</p>\r\n<p>\r\n	三十二、床头开大窗，<a href="http://house.ifeng.com/home/jjfs/list_0/0.shtml" target="_blank"><strong><font color="#004276">风水</font></strong></a>大忌。</p>\r\n<p class="detailPic">\r\n	<img alt="　三十二、床头开大窗，风水大忌。" src="http://i1.hexunimg.cn/2013-07-23/156400050.jpg" /></p>\r\n<p class="picIntro">\r\n	<span>三十二、床头开大窗，风水大忌。</span></p>\r\n<p>\r\n	床头忌开大窗床头开窗乃风水大忌，务必谨记</p>\r\n<p>\r\n	三十三、房内柱角冲射，不利健康和婚姻。</p>\r\n<p>\r\n	柱角冲射不利婚不论男性或女性之个人房间内，皆要避免柱角冲射，否则必会影响情绪和健康，对恋爱及婚姻亦不利，务必及早补救</p>\r\n<p>\r\n	三十四、冷光灯泡不利夫妇感情。</p>\r\n<p>\r\n	暖光灯泡利于感情卧房的灯光对夫妇感情相当重要，应尽量采用暖色光的灯泡，少用寒色光的灯泡或荧光灯</p>', '房地产', '', '凤凰房产综合', 'recommend', '2014-08-16'),
	(253, '延庆城建万科城客户体验中心预计8月开放', 'upload/images/1408166332953.jpg', '<p>\r\n	<strong>城建万科城： </strong><a href="http://house.baidu.com/bj/detail/140412/" onrecommend="undefined" target="_blank">概述</a> | <a href="http://house.baidu.com/bj/precommendo/140412/home/" onrecommend="undefined" target="_blank">户型</a> | <a href="http://house.baidu.com/bj/precommendo/140412/" onrecommend="undefined" target="_blank">相册</a> | <a href="http://house.baidu.com/bj/price/140412/" onrecommend="undefined" target="_blank">价格</a> | <a href="http://house.baidu.com/bj/advantage/140412/" onrecommend="undefined" target="_blank">优缺点</a> | <a href="http://bj.bbs.house.sina.com.cn/bbs/forum/forumdisplay/?fid=5900137499329581056" onrecommend="undefined" target="_blank">业主论坛</a></p>\r\n<div class="m_body m_body_n">\r\n	<p>\r\n		&emsp;&emsp;新浪乐居讯(编辑 王程)<span class="akey"><a class="akey" href="http://house.baidu.com/bj/detail/140412/" onrecommend="undefined" target="_blank">城建万科城</a> (<a class="d_recommendLink" href="http://weibo.com/u/0" onrecommend="undefined">微博售楼处</a> <a class="akey" href="http://bj.bbs.house.sina.com.cn/forum-5900137499329581056/" onrecommend="undefined" target="_blank">论坛</a> <a class="akey" href="http://house.baidu.com/bj/detail/140412/shequ/0_1/" onrecommend="undefined" target="_blank">相册</a> <a class="akey" href="http://house.baidu.com/bj/detail/140412/huxing/0_1/" onrecommend="undefined" target="_blank">户型</a> <a class="akey" href="http://house.baidu.com/bj/detail/140412/yangban/0_1/" onrecommend="undefined" target="_blank">样板间</a> <a class="akey" href="http://house.baidu.com/bj/comment/140412/" onrecommend="undefined" target="_blank">点评</a> <a class="akey" href="http://house.baidu.com/bj/device/140412/" onrecommend="undefined" target="_blank">地图搜索</a>)</span>预计8月下旬开盘。城建万科城沿袭赖特经典建筑风格，精心打造九层电梯洋房，主力户型为75-90平米通透二、三居，一梯两户，均装修交房。园区内规划有 多业态社区商业、贴身亲子乐园等生活、休闲配套，全面满足业主日常生活所需。城建万科城客户体验中心预计将于8月下旬开放。</p>\r\n	<p>\r\n		&emsp;&emsp;<b>&gt;&gt;&gt;了解详细项目信息欢迎致电：400-606-6969 转 97708</b></p>\r\n	<p>\r\n		&emsp;&emsp;城建万科城是由万科、北京城建和天运三大品牌强强联手，合力铸造的20万平米美式低密华宅。项目位于延庆县沈家营镇，与延庆县城紧密相连，毗邻延琉路。乘坐873路、Y18路、Y13路等直达延庆县城中心，乘919路或铁路S2线通达市区德胜门或西直门。</p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://bj.house.sina.com.cn/zhuanti/8.23xlljtzzxkft/index.shtml" onrecommend="undefined"><b>&gt;&gt;2014年8月23日新浪乐居通州专线看房团</b></a></p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://bj.house.sina.com.cn/zhuanti/bjweixingoufang%20/index.shtml" onrecommend="undefined"><b>&gt;&gt;微信购房季刷爆你的朋友圈 幸运网 友抽中0首付房</b></a></p>\r\n	<p>\r\n		&emsp;&emsp;<span style="font-family: KaiTi_GB2312,KaiTi">以上信息仅供参考，最终以开发商公布为 准。本稿件为新浪乐居独家原创稿件，版权所有，引用或转载请 注明出处。</span></p>\r\n	<p>\r\n		&emsp;&emsp;<b><a href="http://i.house.sina.com.cn/index.php? ctrl=buyserver&amp;act=subscribe" onrecommend="undefined" target="_blank">订阅会 员置业刊我们将直接把最新的热盘动向发送到您的邮箱 </a></b></p>\r\n	<p>\r\n		&emsp;&emsp;</p>\r\n	<p>\r\n		&emsp;&emsp;<img height="300" src="http://src.house.sina.com.cn/imp/imp/deal/c3/86/0/f0be1b991b5e6b07e318372d9fa_p1_mk1.jpg" width="560" /></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '百度乐居', 'recommend', '2014-08-16'),
	(255, '燕郊金谷美丽城40平一居房源总价约50万起(图)', 'upload/images/1408166623187.jpg', '<p>\r\n	<strong>金谷&middot;美丽城(美丽公馆)： </strong><a href="http://house.baidu.com/bj/detail/119925/" onrecommend="undefined" target="_blank">概述</a> | <a href="http://house.baidu.com/bj/precommendo/119925/home/" onrecommend="undefined" target="_blank">户型</a> | <a href="http://house.baidu.com/bj/precommendo/119925/" onrecommend="undefined" target="_blank">相册</a> | <a href="http://house.baidu.com/bj/price/119925/" onrecommend="undefined" target="_blank">价格</a> | <a href="http://house.baidu.com/bj/advantage/119925/" onrecommend="undefined" target="_blank">优缺点</a> | <a href="http://bj.bbs.house.sina.com.cn/bbs/forum/forumdisplay/?fid=1408680553690444" onrecommend="undefined" target="_blank">业主论坛</a></p>\r\n<div class="m_body m_body_n">\r\n	<p>\r\n		&emsp;&emsp;新浪乐居讯(编辑 燕线)<a href="http://house.baidu.com/bj/detail/119925/" onrecommend="undefined" target="_blank">金谷&middot;美丽城(美丽公馆)</a>位于北京周边燕郊迎宾北路，9、11至13、15至17号楼，25-33层，二梯五户、二梯六户板塔结合楼，户型面积为40-60平米一居，80-90平米两居，110-130平米三居，户户朝南、明厨明卫，参考上期房源售罄前11000元/平方米均价，40平一居房源总价约50万/套起，精装修，2015年9月入住。</p>\r\n	<p>\r\n		&emsp;&emsp;<b>&gt;&gt;了解项目更多信息欢迎致电：400-606-6969转36832</b></p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://house.baidu.com/bj/detail/119925/" onrecommend="undefined" target="_blank">金谷&middot;美丽城(美丽公馆)</a>一期项目美丽公馆，是基于豪布斯卡理念开发的未来都市中心其中包含的新古典精装住宅。低密度高端精装社区，极具升值价值，交通便利，户户朝阳，户户赠送面积，曲线水体景观，道路硬质铺装，每栋楼旁花园景观兼休憩广场</p>\r\n	<p>\r\n		&emsp;&emsp;百世金谷实业有限公司，自成立之初，即致力于产业地产开发与运营，经过多年的科学管理和悉心经营，现已发展成为涵盖产业地产、房地产、文化传媒、园林绿化、金融服务及综合性投资为支柱的5 +1产业机构。</p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://bj.house.sina.com.cn/zhuanti/8.16xlljdxkft/index.shtml" onrecommend="undefined"><b>&gt;&gt;8月16日新浪乐居情定七夕为爱SI奔大型看房团</b></a></p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://bj.house.sina.com.cn/zhuanti/bjweixingoufang%20/index.shtml" onrecommend="undefined"><b>&gt;&gt;微信购房季刷爆你的朋友圈 幸运网 友抽中0首付房</b></a></p>\r\n	<p>\r\n		&emsp;&emsp;<span style="font-family: KaiTi_GB2312,KaiTi">以上信息仅供参考，最终以开发商公布为 准。本稿件为新浪乐居独家原创稿件，版权所有，引用或转载请 注明出处。</span></p>\r\n	<p>\r\n		&emsp;&emsp;<b><a href="http://i.house.sina.com.cn/index.php? ctrl=buyserver&amp;act=subscribe" onrecommend="undefined" target="_blank">订阅会 员置业刊我们将直接把最新的热盘动向发送到您的邮箱 </a></b></p>\r\n	<p>\r\n		&emsp;&emsp;</p>\r\n	<p>\r\n		&emsp;&emsp;<img height="300" src="http://src.house.sina.com.cn/imp/imp/deal/c3/86/0/f0be1b991b5e6b07e318372d9fa_p1_mk1.jpg" width="560" /></p>\r\n</div>\r\n<p>\r\n	<br />\r\n	&nbsp;</p>', '房地产', '', '百度乐居', 'recommend', '2014-08-16'),
	(257, '顺义新城名校旁顺鑫山语溪2-3居总价127万/套起', 'upload/images/1408166827453.jpg', '<p>\r\n	<strong>顺鑫&middot;山语溪： </strong><a href="http://house.baidu.com/bj/detail/118047/" onrecommend="undefined" target="_blank">概述</a> | <a href="http://house.baidu.com/bj/precommendo/118047/home/" onrecommend="undefined" target="_blank">户型</a> | <a href="http://house.baidu.com/bj/precommendo/118047/" onrecommend="undefined" target="_blank">相册</a> | <a href="http://house.baidu.com/bj/price/118047/" onrecommend="undefined" target="_blank">价格</a> | <a href="http://house.baidu.com/bj/advantage/118047/" onrecommend="undefined" target="_blank">优缺点</a> | <a href="http://bj.bbs.house.sina.com.cn/bbs/forum/forumdisplay/?fid=1408680553688123" onrecommend="undefined" target="_blank">业主论坛</a></p>\r\n<div class="m_body m_body_n">\r\n	<p>\r\n		&emsp;&emsp;新浪乐居讯(编辑 孙佳月)<a href="http://house.baidu.com/bj/detail/118047/" onrecommend="undefined" target="_blank">顺鑫&middot;山语溪</a>&nbsp;(<a href="http://bj.bbs.house.sina.com.cn/bbs/forum/forumdisplay/?fid=1408680553688123" onrecommend="undefined" target="_blank">论坛</a>&nbsp;<a href="http://house.baidu.com/bj/detail/118047/shequ/0_1/" onrecommend="undefined" target="_blank">相册</a>&nbsp;<a href="http://house.baidu.com/bj/detail/118047/huxing/0_1/" onrecommend="undefined" target="_blank">户型</a>&nbsp;<a href="http://house.baidu.com/bj/detail/118047/yangban/0_1/" onrecommend="undefined" target="_blank">样板间</a>&nbsp;<a href="http://house.baidu.com/bj/comment/118047/" onrecommend="undefined" target="_blank">点评</a>&nbsp;<a href="http://house.baidu.com/bj/device/118047/" onrecommend="undefined" target="_blank">地图搜索</a>)位于牛栏山一中东侧100米，目前一期5、7号楼剩有20余套房源在售，预计2014年年底推出二期。目前一期有20多套78平2居、108平3居在售，最高7、11层，均价16300元/平，总价127万/套起，现房。</p>\r\n	<p>\r\n		&emsp;&emsp;<b>&gt;&gt;了解项目更多信息欢迎致电：400-606-6969转88513</b></p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://house.baidu.com/bj/detail/118047/" onrecommend="undefined" target="_blank">顺鑫&middot;山语溪</a>地处顺义新城北部牛栏山组团，牛栏山酒厂东侧，临近地铁M15号线、规划中的S6号线、机场轻轨L1号线等多条轨道交通与陆路交通构成立体交通网络，出行便捷。</p>\r\n	<p>\r\n		&emsp;&emsp;<b>&gt;&gt;<a href="http://bj.house.sina.com.cn/exhibit/shouloudianhua/index.shtml" onrecommend="undefined">热盘免费电话在手 与梦想新房更近一步</a></b></p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://house.baidu.com/bj/detail/118047/" onrecommend="undefined" target="_blank">顺鑫&middot;山语溪</a>整体分二期完成，一期为现房，二期项目正在规划中。社区内配套完善，包含幼儿园、小学、邮局、菜市场及自身可餐饮商业，满足业主日常生活所需。项目处于顺义新城16街区，规划为高等教育、文化娱乐 区域，未来生活氛围浓厚，发展前景可观。</p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://bj.house.sina.com.cn/zhuanti/8.16xlljdxkft/index.shtml" onrecommend="undefined"><b>&gt;&gt;8月16日新浪乐居情定七夕为爱SI奔大型看房团</b></a></p>\r\n	<p>\r\n		&emsp;&emsp;<a href="http://bj.house.sina.com.cn/zhuanti/bjweixingoufang%20/index.shtml" onrecommend="undefined"><b>&gt;&gt;微信购房季刷爆你的朋友圈 幸运网 友抽中0首付房</b></a></p>\r\n	<p>\r\n		&emsp;&emsp;<span style="font-family: KaiTi_GB2312,KaiTi">以上信息仅供参考，最终以开发商公布为 准。本稿件为新浪乐居独家原创稿件，版权所有，引用或转载请 注明出处。</span></p>\r\n	<p>\r\n		&emsp;&emsp;<b><a href="http://i.house.sina.com.cn/index.php? ctrl=buyserver&amp;act=subscribe" onrecommend="undefined" target="_blank">订阅会 员置业刊我们将直接把最新的热盘动向发送到您的邮箱 </a></b></p>\r\n	<p>\r\n		&emsp;&emsp;</p>\r\n	<p>\r\n		&emsp;&emsp;<img height="300" src="http://src.house.sina.com.cn/imp/imp/deal/c3/86/0/f0be1b991b5e6b07e318372d9fa_p1_mk1.jpg" width="560" /></p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '房地产', '', '百度乐居', 'recommend', '2014-08-16'),
	(259, '如果无人驾驶汽车出了车祸，由谁来担责？', 'upload/images/1408167075953.jpg', '<p>\r\n	<span style="text-indent: 2em;"><b>眼下，像谷歌等公司开发的无人驾驶汽车，面临尴尬处境。</b></span></p>\r\n<p>\r\n	据《大西洋月刊》8月13日报道，眼下，像<a href="http://tech.163.com/company/google/"><font color="#0f6b99">谷歌</font></a>等公司开发的无人驾驶汽车，面临尴尬处境。比如说，谷歌出售了一辆无人驾驶汽车给你，不小心发生了交通意外。谁将为车祸造成的损失负责&mdash;&mdash;你还是谷歌？驱动汽车的程序、当然还有传感器和所有的控制系统都是谷歌的产品。甚至他们公司的员工也认为，交警的罚单或者法院的传票都不应该下发给车主，而应该给谷歌。</p>\r\n<p>\r\n	是的，谁来负责？汽车制造商，车主，还是操纵方向盘的智能汽车自己？眼下讨论的热点是要不要赋予机器人（智能汽车）法律上的人格。</p>\r\n<p>\r\n	<b>机器人能独立承担责任？</b></p>\r\n<p>\r\n	当第一次听说&ldquo;机器人也有法律意义上的人格&rdquo;，大多数人都快疯了。</p>\r\n<p>\r\n	机器人不是人！</p>\r\n<p>\r\n	当然不是。</p>\r\n<p>\r\n	但是法律意义上的人格，从概念上来说，不是认定它是否有血有肉，而是谁/什么实体被推上法庭。</p>\r\n<p>\r\n	《机器人也是人》的作者、律师约翰&middot;弗兰克&middot;威弗尔（John Frank Weaver）在美国知名网络杂志《Slate》上表示，&ldquo;如果我们希望机器人（智能汽车）帮我们做更多事情，比如载我们出游或者帮我们派送东西，就需要在法律上赋予它一定位置。&rdquo;</p>\r\n<p>\r\n	&ldquo;如果我们像和常人交往一样对待机器人，法律理应承认这些互动与真正人类间的互动没有区别，&rdquo;威弗尔写道，&ldquo;在某些案例中，法律要求确认机器人可获承保及具有完全独立的行为能力，像真正人类或者实体公司一样。&rdquo;</p>\r\n<p>\r\n	问题来了：如果我们不能赋予机器人一定范围内的法律权利和义务，我们就不能更有效地利用他们。而确定如何分配权利义务的工具就是法律人格。</p>\r\n<p>\r\n	或者找一个可能发生的场景。例如当无人驾驶汽车为了避免撞上一头小鹿紧急转向，不幸地是它撞上了旁边的汽车。如果汽车做到了一名好司机该做的，那么谷歌（或者任何其他无人驾驶汽车制造商）是否需要为车祸损失负责？</p>\r\n<p>\r\n	威弗尔的回答是否定的。在他推崇的法律世界里，机器人能独立承担责任，&ldquo;汽车具备了独立行为能力，这样能更快地获得保险赔付来帮助受害者，同时保护车主应对可能的官司。&rdquo;</p>\r\n<p>\r\n	但是在现实世界里，无人驾驶汽车可能需求特定的人员维护或者被限定在某些特定区域内行驶。</p>\r\n<p>\r\n	<b>&ldquo;谷歌的世界&rdquo;没有严重车祸</b></p>\r\n<p>\r\n	如果这看起来很荒唐，那么换另一个角度。如果谷歌卖出了一百万辆汽车，它是否在法律上真的有责任为每辆车的每次罚单和事故&ldquo;埋单&rdquo;？什么样的公司能负担起这样的法律责任？</p>\r\n<p>\r\n	不过谷歌设计顾问布莱恩&middot;舍伍德&middot;琼斯(Brian Sherwood Jones)反驳了威弗尔的说法。他认为，事故是&ldquo;机器人的责任&rdquo;简直是胡说。他表示，如果我们不&ldquo;把责任归咎于人&rdquo;，那么将出现&ldquo;大规模规避责任&rdquo;的情况。</p>\r\n<p>\r\n	有趣的是，目前上路的汽车其行为能力已被划定给相关的运营企业等非人类的&ldquo;法人&rdquo;。</p>\r\n<p>\r\n	或许，威弗尔可以辩解说，使机器人成为独立的法律实体大有好处，如果我们在生活中碰到类似上述情形时，就能厘清机器人的角色作用。作为一个&ldquo;法律人&rdquo;上路，在碰到无人驾驶汽车正确行使却遇到交通事故的情形时，汽车需要自己的保险。也就是说，损失将由汽车这个法律实体来支付。</p>\r\n<p>\r\n	另一种选择是，让类似谷歌的公司自己设立企业，运营所开发的无人驾驶汽车：他们既然由此获利当然也要承担无人车带来的风险。这与其说是出售无人驾驶汽车，不如说谷歌自己运营一个超级安全的车队。当然，从谷歌汽车&ldquo;小而轻、且有速度限制&rdquo;的设计来看，谷歌准备让它的汽车行驶在一个不大可能发生严重车祸的世界。</p>\r\n<p>\r\n	或者可以说，为了囊括和处理像企业集团或机器人等复杂的现代化体系，我们的司法体系在如何处理与&ldquo;人&rdquo;的关系上一路豕突狼奔，机器&ldquo;人&rdquo;的例子就是一个很好的证明。可能我们需要的并不是将人格赋予机器人，而是改写&ldquo;非人类实体&rdquo;的人格概念本身。</p>\r\n<p>\r\n	正如温迪&middot;柯米纳（Wendy Kaminer，律师、作家）警告的那样，将人格限制于&ldquo;自然人&rdquo;将带来一系列意想不到的结果。也就是说，开人格概念的倒车是不可能的，相反，最明智的做法是把人格扩展到&hellip;&hellip;机器人。</p>', '汽车', '谢涓', '澎湃新闻网', 'hot', '2015-08-05'),
	(260, '改款奥迪Q3假想图曝光 最快于年底推出', 'upload/images/1408167231640.jpg', '<p>\r\n	【<a href="http://newcar.xcar.com.cn/price/pb1/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">新款奥迪</a>Q3假想图】</p>\r\n<p>\r\n	[XCAR 海外<a href="http://info.xcar.com.cn/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">新车</a> 原创]</p>\r\n<p sizcache="2" sizset="69">\r\n	&nbsp;&nbsp;&nbsp; 近日，有媒体在网络曝出了改款<a href="http://newcar.xcar.com.cn/1784/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">Q3</a>最新的假想图，据消息称，新款Q3最早有望在年内推出。据悉，新车在外观上对比现款将有所改变。</p>\r\n<p sizcache="2" sizset="72" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1829018&amp;aid=284836" target="_blank"><img alt="奥迪(进口)2012款奥迪Q3" src="http://img1.xcarimg.com/b63/s2355/608_456_20120727163632947145.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="奥迪(进口)2012款奥迪Q3" /></a></p>\r\n<p sizcache="2" sizset="73" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1829017&amp;aid=284836" target="_blank"><img alt="一汽-大众奥迪2013款奥迪Q3" src="http://img1.xcar.com.cn/b5/s4391/608_456_20140211140912412587.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽-大众奥迪2013款奥迪Q3" /></a></p>\r\n<p sizcache="2" sizset="74" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1829016&amp;aid=284836" target="_blank"><img alt="一汽-大众奥迪2013款奥迪Q3" src="http://img1.xcar.com.cn/b5/s4391/608_456_20140211140904582870.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽-大众奥迪2013款奥迪Q3" /></a></p>\r\n<p sizcache="2" sizset="75" style="text-align: center">\r\n	【现款<a href="http://newcar.xcar.com.cn/1784/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">奥迪Q3</a>外观】</p>\r\n<p sizcache="2" sizset="76">\r\n	&nbsp;&nbsp;&nbsp; 从假想图来看，<a href="http://newcar.xcar.com.cn/price/pb1/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">奥迪</a>改款Q3相比在售车型的变化主要在车前脸部分，上进气格栅的镀铬饰条改为横向式设计，并且一直延伸至前大灯，这样的设计提升了Q3的气势。前大灯的样式经过改动后，显得更加动感，此外Q3的LED日间行车灯也有所调整。</p>\r\n<p sizcache="2" sizset="77" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1829015&amp;aid=284836" style="color: rgb(65,110,170); text-decoration: underline" target="_blank"><img alt="奥迪(进口)2012款奥迪Q3" src="http://img1.xcarimg.com/exp/3577/3579/3633/3819/608_456_20110420092619663580.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="奥迪(进口)2012款奥迪Q3" /></a></p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 动力方面，奥迪改款Q3将依然有柴油发动机和汽油发动机供消费者选择，而与之匹配的则是7速双离合变速箱。</p>\r\n<p sizcache="2" sizset="78">\r\n	&nbsp;&nbsp;&nbsp; <strong>编辑点评：</strong>虽然现在我们还没有Q3具体的上市时间，但目前有两种猜测，今年底亦或者明年初，国产可能会再晚一些。而据我们现在所了解的，<a href="http://newcar.xcar.com.cn/656/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">宝马X1</a>的换代车型将于明年6月推出，或许这将会是老对手之间的新一轮较量。</p>\r\n<p sizcache="2" sizset="79">\r\n	<strong sizcache="2" sizset="79">&nbsp; &nbsp; <span style="color: #ff0000">相关内容回顾：</span><br />\r\n	&nbsp; &nbsp; 奥迪Q3 40TFSI越野版上市 售价42.88万<br />\r\n	&nbsp; &nbsp;&nbsp;<a href="http://info.xcar.com.cn/201407/news_1628672_1.html" target="_blank">http://info.xcar.com.cn/201407/news_1628672_1.html</a></strong></p>', '汽车', '果婷', '爱卡汽车', 'recommend', '2014-08-16'),
	(261, '15万元起精致好口碑MPV导购 年轻人也适合', 'upload/images/1408167794250.jpg', '<div class="abstract">\r\n	动力方面，全新逸致整合了全系动力配备，取消了2.0L车型，其他与老款车型不变，新款包括一款1.6升车型和七款1.8升车型，1.6L发动机最大功率122马力，1.8L发动机最大功率140马力，手动车型配备6MT变速箱，自动车型配备无级变速箱。</div>\r\n<div class="content" id="content" jquery110207033597379231529="153">\r\n	<!-- <div class="player"><span id="video_url"></span><video class="video-js vjs-default-skin" id="video_player" controls preload="auto"></video></div>-->\r\n	<div id="video_code" style="display: none">\r\n		&nbsp;</div>\r\n	<div id="video_code_mobile" style="display: none">\r\n		&nbsp;</div>\r\n	<div style="margin: 0px auto; width: 100%; display: none">\r\n		<div id="video_o_url">\r\n			&nbsp;</div>\r\n	</div>\r\n	<div class="contentshow" id="zoom">\r\n		<div style="margin: 0px auto; width: 600px">\r\n			<div id="vodPlayer">\r\n				&nbsp;</div>\r\n		</div>\r\n	</div>\r\n	<div id="player">\r\n		&nbsp;</div>\r\n	<div class="gallery">\r\n		&nbsp;</div>\r\n	<!--enpproperty <date>2014-08-16 05:00:35.0</date><author></author><title>15万元起精致好口碑MPV导购 年轻人也适合</title><keyword>车型 MPV 扭力梁 佳乐 全景天窗 行驶稳定系统 辅助控制系统 RCZ Nu BOSCHESP</keyword><subtitle></subtitle><introtitle></introtitle><siteid>4</siteid><nodeid>166166</nodeid><nodename>汽车即时快讯</nodename><nodesearchname></nodesearchname>/enpproperty--><!--enpcontent-->\r\n	<p>\r\n		　　<strong>起亚新佳乐</strong></p>\r\n	<p>\r\n		　　<strong>指导价：15.98-20.58万元</strong></p>\r\n	<p>\r\n		　　2013年5月，第三代佳乐正式上市。该车为都市精智家庭量身打造，并且在造型和技术上进行了大胆突破，配置和性能全面升级。</p>\r\n	<p align="center">\r\n		<img alt="购车参谋 亚讯车网 www.yescar.cn" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/91/16668405642122338135.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		2013款佳乐</p>\r\n	<p>\r\n		　　佳乐的前脸采用了家族式的虎啸式进气格栅设计，辨识度很高，而佳乐的车侧与车尾造型就相对比较中庸、传统，整体给人的感觉还算饱满，但没有什么令人过目难忘的地方。至于车身尺寸，佳乐除了车宽略占优势外，其它方面的表现都处于中等水平。</p>\r\n	<p align="center">\r\n		<img alt="购车参谋 亚讯车网 www.yescar.cn" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/24/13620688189528526232.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		2013款佳乐</p>\r\n	<p>\r\n		　　内饰方面，该车的中控台造型平直简约，大量软性材质的使用带来了不错的手感。在配置方面，佳乐全系标配带加热和转向助力轻重可调的真皮多功能方向盘和全景天窗等配置让人眼前一亮。特别是全景天窗，在15-20万元价格区间内的紧凑型MPV车型中，能有此配置的也只有它了。</p>\r\n	<p align="center">\r\n		<img alt="购车参谋 亚讯车网 www.yescar.cn" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/38/6083879871085594674.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		2013款佳乐</p>\r\n	<p>\r\n		　　车内座椅布局，佳乐和大部分紧凑型MPV一样提供了5座和7座版两种车型可供选择，其第一和第二排的空间表现都比较令人满意，第三排的空间相对比较局促，成年人乘坐的话会不太舒服，但偶尔应应急还是可以的。至于后备厢空间，在满载7人的情况下，它的容积其实也所剩不多，仅有300mm的深度比杰德略强一点点（杰德为210mm），算是勉强能放入两个双肩包了。佳乐不仅第二排和第三排座椅椅背可以完全放平外，它的副驾驶座椅椅背也能完全向前放倒，进而形成最长2570mm的纵深，表现相当惊人。</p>\r\n	<p align="center">\r\n		<img alt="购车参谋 亚讯车网 www.yescar.cn" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/66/4450531392324908914.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		2013款佳乐</p>\r\n	<p>\r\n		　　佳乐全系车型目前只提供2.0L+6AT这一种选择，这台名为Nu的2.0L发动机最大功率为152马力/6500rpm，最大扭矩为194牛&middot;米/4800rpm，搭配的是6速手自一体变速箱。汽车之家实测的0-100km/h加速成绩为10.67秒，对于一台MPV车型来说，还算可以。</p>\r\n</div>\r\n<div class="abstract">\r\n	动力方面，全新逸致整合了全系动力配备，取消了2.0L车型，其他与老款车型不变，新款包括一款1.6升车型和七款1.8升车型，1.6L发动机最大功率122马力，1.8L发动机最大功率140马力，手动车型配备6MT变速箱，自动车型配备无级变速箱。</div>\r\n<div class="content" id="content" jquery1102040990005426849235="138">\r\n	<!-- <div class="player"><span id="video_url"></span><video class="video-js vjs-default-skin" id="video_player" controls preload="auto"></video></div>-->\r\n	<div id="video_code" style="display: none">\r\n		&nbsp;</div>\r\n	<div id="video_code_mobile" style="display: none">\r\n		&nbsp;</div>\r\n	<div style="margin: 0px auto; width: 100%; display: none">\r\n		<div id="video_o_url">\r\n			&nbsp;</div>\r\n	</div>\r\n	<div class="contentshow" id="zoom">\r\n		<div style="margin: 0px auto; width: 600px">\r\n			<div id="vodPlayer">\r\n				&nbsp;</div>\r\n		</div>\r\n	</div>\r\n	<div id="player">\r\n		&nbsp;</div>\r\n	<div class="gallery">\r\n		&nbsp;</div>\r\n	<!--enpproperty <date>2014-08-16 05:00:35.0</date><author></author><title>15万元起精致好口碑MPV导购 年轻人也适合</title><keyword>车型 MPV 扭力梁 佳乐 全景天窗 行驶稳定系统 辅助控制系统 RCZ Nu BOSCHESP</keyword><subtitle></subtitle><introtitle></introtitle><siteid>4</siteid><nodeid>166166</nodeid><nodename>汽车即时快讯</nodename><nodesearchname></nodesearchname>/enpproperty--><!--enpcontent-->\r\n	<p>\r\n		　　<strong>2013款丰田逸致</strong></p>\r\n	<p>\r\n		　　<strong>指导价：14.98-18.98万元</strong></p>\r\n	<p align="center">\r\n		<img alt="国产新车 亚讯车网 www.yescar.cn" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/90/10865943017661252066.jpg" /></p>\r\n	<p>\r\n		　　相对现销版逸致来说，改版车型在车厢部分不做任何调整，只是彻底更改了整个车头的造型风格，说明这只是一次小改款版本，不涉及车身结构。</p>\r\n	<p align="center">\r\n		<img alt="国产新车 亚讯车网 www.yescar.cn" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/86/2980098215072764146.jpg" /></p>\r\n	<p>\r\n		　　配置方面，新车的安全配置非常丰富，全系标配VSC车身稳定控制系统、TRC牵引力控制系统和HAC上坡起步辅助控制系统、SRS前排侧空气囊和驾驶席膝部气囊。新车全新还标配了前排中央扶手箱、四门电动车窗（带防夹，一触式升降功能）、集成控制式多功能方向盘（可4向调节）、第二排独立座椅（带前后滑移功能，可倾斜，可折叠放平）、AUX&amp;USB多媒体接入端口等配置。</p>\r\n	<p>\r\n		　　动力方面，全新逸致整合了全系动力配备，取消了2.0L车型，其他与老款车型不变，新款包括一款1.6升车型和七款1.8升车型，1.6L发动机最大功率122马力，1.8L发动机最大功率140马力，手动车型配备6MT变速箱，自动车型配备无级变速箱。</p>\r\n</div>\r\n<div class="abstract">\r\n	动力方面，全新逸致整合了全系动力配备，取消了2.0L车型，其他与老款车型不变，新款包括一款1.6升车型和七款1.8升车型，1.6L发动机最大功率122马力，1.8L发动机最大功率140马力，手动车型配备6MT变速箱，自动车型配备无级变速箱。</div>\r\n<div class="content" id="content" jquery110208111298090332102="138">\r\n	<!-- <div class="player"><span id="video_url"></span><video class="video-js vjs-default-skin" id="video_player" controls preload="auto"></video></div>-->\r\n	<div id="video_code" style="display: none">\r\n		&nbsp;</div>\r\n	<div id="video_code_mobile" style="display: none">\r\n		&nbsp;</div>\r\n	<div style="margin: 0px auto; width: 100%; display: none">\r\n		<div id="video_o_url">\r\n			&nbsp;</div>\r\n	</div>\r\n	<div class="contentshow" id="zoom">\r\n		<div style="margin: 0px auto; width: 600px">\r\n			<div id="vodPlayer">\r\n				&nbsp;</div>\r\n		</div>\r\n	</div>\r\n	<div id="player">\r\n		&nbsp;</div>\r\n	<div class="gallery">\r\n		&nbsp;</div>\r\n	<!--enpproperty <date>2014-08-16 05:00:35.0</date><author></author><title>15万元起精致好口碑MPV导购 年轻人也适合</title><keyword>车型 MPV 扭力梁 佳乐 全景天窗 行驶稳定系统 辅助控制系统 RCZ Nu BOSCHESP</keyword><subtitle></subtitle><introtitle></introtitle><siteid>4</siteid><nodeid>166166</nodeid><nodename>汽车即时快讯</nodename><nodesearchname></nodesearchname>/enpproperty--><!--enpcontent-->\r\n	<p>\r\n		　　<strong>标致3008</strong></p>\r\n	<p>\r\n		　　<strong>指导价：15.97-21.47万元</strong></p>\r\n	<p>\r\n		　　标致3008首次亮相于去年的日内瓦车展，采用和308相同的技术平台，其长宽高分别为4365mm、1639mm、1837mm。轴距为2613mm。3008在外形上保持了法国车一贯的浪漫风格，锐利的前大灯与大嘴设计表明其来自标致的身世，配合锐利的头灯设计，显得十分霸气。从侧面看3008，我们不难发现其修长的车身设计基本是移植于标致的SW车型，大号的尾灯和平直的尾门则融合了一些SUV的造型风格。而整体流线的车身线条早就了3008只有0.296的风阻系数。</p>\r\n	<p align="center">\r\n		<img alt="标致3008" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/52/18130970685743530156.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		标致3008</p>\r\n	<p>\r\n		　　内饰方面，3008采用了灵感来自于飞机驾驶舱全新的设计元素。而真正会给你驾驶飞机的感觉来自于抬头显示器，车辆驾驶信息会从仪表台后的投影仪上投射到一块防反光的半透明聚碳酸酯板上。驾驶员无需将目光从路面移开，就可以从这里获取行驶速度等信息。但对于乘坐者来说，没有什么比1.60平方米的超大全景天窗更给力的了。天窗由深色夹层玻璃制成，使传入车内的光和热量都很有限，天窗宽度为1202mm，侧面可以一直延伸到车身面板处；长度为1382mm，这使得后排乘客都几乎看不到天窗的后边缘。</p>\r\n	<p align="center">\r\n		<img alt="标致3008" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/72/12214808117942262028.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		标致3008</p>\r\n	<p>\r\n		　　配置方面，入门版的2.0L手动经典版配备了BOSCHESP车身行驶稳定系统、HAC上坡辅助系统、前排双气囊+前排座椅侧气囊、EPB电子驻车制动系统、后排空调出风口、飞翼式LED日航灯等等配置，足矣应付日常所需。顶配车型更是提供HUD平视显示系统、泊车可视、3D导航、智能大灯、智能雨刮、多路况适应系统（GripControl）等等配置。</p>\r\n	<p>\r\n		　　标致3008出自PSA的2号平台，这一平台衍生出来了不同种类的车型，有像308这样的紧凑型车也有像RCZ这样的跑车，他们都有一个共同的特性就是采用了前麦弗逊后扭力梁的悬挂结构。有人说一辆SUV采用扭力梁这样的后悬挂有些不可思，不过要是针对标致3008这样的一款城市型跨界SUV，城市道路才是它的主战场。</p>\r\n	<p align="center">\r\n		<img alt="标致3008" src="http://car.southcn.com/7/images/attachement/jpg/site4/20140816/69/676276118625115457.jpg" /></p>\r\n	<p align="center" class="pictext">\r\n		标致3008</p>\r\n	<p>\r\n		　　动力方面进口的3008采用PSA集团与宝马共同研发的1.6T涡轮增压发动机，不过国产后也有可能搭载目前的2.0L或2.3L发动机。变速箱方面我们比较激动的看到了一款6挡手自一体变速箱，希望未来国产时不要换回杯具的4挡变速箱。而扭力梁悬挂的使用以及前驱的驱动形式也彻底的证明了它只是一款适合城市的CROSS车型，除了离地间隙略高外，它和308的区别并不大。</p>\r\n	<p>\r\n		　　价格虽然便宜，但标致3008却是和翼虎、CR-V等车型一样，同属紧凑型SUV。按照中国人买大不买小的心理，3008绝对是物有所值。而且它的外观也很漂亮，看来东风标致没有延用进口3008的外形是个明智之举。</p>\r\n	<p>\r\n		&nbsp;</p>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '汽车', '', '亚讯车网', 'recommend', '2014-08-16'),
	(262, '2014款宝马X5美规版 购车送惊喜仅需70万', 'upload/images/1408167931187.jpg', '<p>\r\n	<a href="http://binhai.cheshi.com/" style="text-align: center; color: rgb(0, 82, 148); text-indent: 2em; font-family: Verdana, Geneva, sans-serif; font-size: 16px; text-decoration: none; background-color: rgb(249, 249, 249);">【网上车市 天津滨海行情.原创】</a><span style="text-indent: 2em;">近日，在天津鸿通<a class="t_link" href="http://www.cheshi.com/" target="_blank"><font style="color: rgb(51, 51, 51);">汽车</font></a>贸易有限公司了解到，2014款<a class="t_link" href="http://product.cheshi.com/bseries_35/" target="_blank"><font style="color: rgb(51, 51, 51);">宝马X5美规版</font></a>现车到店，<a class="t_link" href="http://seller.cheshi.com/" target="_blank"><font style="color: rgb(51, 51, 51);">购车</font></a>送惊喜仅需70万，机会难得欲购从速，具体详情欢迎来电咨询，购车咨询电话：</span><span style="color: rgb(255, 0, 0); text-indent: 2em;"><span style="font-size: 18px;"><strong>13920020623</strong></span></span></p>\r\n<p>\r\n	&nbsp;</p>\r\n<table align="center" bgcolor="#dddddd" border="0" cellpadding="3" cellspacing="1" class="table" style="border-color: rgb(218, 229, 235); margin: 0px auto; color: rgb(51, 51, 51); line-height: 22px; clear: both; font-family: Verdana, Geneva, sans-serif; orphans: 2; widows: 2;" width="500">\r\n	<tbody>\r\n		<tr>\r\n			<td align="middle" bgcolor="#eeeeee" style="margin: 0px; padding: 0px;" width="200">\r\n				<strong>车型(天津报价)</strong></td>\r\n			<td align="middle" bgcolor="#eeeeee" style="margin: 0px; padding: 0px;" width="65">\r\n				<strong>颜色</strong></td>\r\n			<td align="middle" bgcolor="#eeeeee" style="margin: 0px; padding: 0px;" width="55">\r\n				<strong>售价</strong></td>\r\n			<td align="middle" bgcolor="#eeeeee" style="margin: 0px; padding: 0px;" width="65">\r\n				<strong>价格变化</strong></td>\r\n			<td align="middle" bgcolor="#eeeeee" style="margin: 0px; padding: 0px;">\r\n				<strong>备注</strong></td>\r\n		</tr>\r\n		<tr>\r\n			<td bgcolor="#f8f7f5" style="margin: 0px; padding: 0px; text-align: center;">\r\n				<span style="line-height: 28px; text-indent: 28px;">2014款宝马X5美规版</span></td>\r\n			<td align="middle" bgcolor="#f8f7f5" style="margin: 0px; padding: 0px;">\r\n				<span style="line-height: 28px; text-indent: 28px;">电议</span></td>\r\n			<td align="middle" bgcolor="#f8f7f5" style="margin: 0px; padding: 0px;">\r\n				<span style="line-height: 28px; text-indent: 28px;">70万</span></td>\r\n			<td align="middle" bgcolor="#f8f7f5" style="margin: 0px; padding: 0px;">\r\n				<span style="line-height: 28px; text-indent: 28px;">优惠</span></td>\r\n			<td align="middle" bgcolor="#f8f7f5" style="margin: 0px; padding: 0px;">\r\n				现车</td>\r\n		</tr>\r\n		<tr>\r\n			<td align="right" bgcolor="#f8f7f5" colspan="5" style="margin: 0px; padding: 0px;">\r\n				2014年8月16日最新报价制表：<a href="http://tj.cheshi.com/" style="color: rgb(0, 68, 153); text-decoration: none;" target="_blank">网上车市天津滨海站 tj.cheshi.com</a></td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p>\r\n	外观方面：<a class="t_link" href="http://product.cheshi.com/bseries_35/" target="_blank"><font style="color: rgb(51, 51, 51);">2014款宝马X5</font></a>美规版经典的双肾型前格栅加之眼神犀利的大灯，动感之中更显现出霸气。同时，尾部的LED水平灯带也增添了不少运动气息。<a class="t_link" href="http://product.cheshi.com/bseries_35/" target="_blank"><font style="color: rgb(51, 51, 51);">宝马X5</font></a>整车长4854mm，宽1933mm，高1776 mm，轴距2933mm，展现出魁梧的身材。</p>\r\n<p style="text-align: center; text-indent: 0px;">\r\n	<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120628.shtml" target="_blank"><img src="http://img2.cheshi-img.com/center/600/71/06/a1/366755a3d360bc98f8185f303d.jpeg" style="border: 1px solid black;" /></a></p>\r\n<p style="text-align: center; text-indent: 0px;">\r\n	<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120627.shtml" target="_blank"><img src="http://img1.cheshi-img.com/center/290/2a/22/72/7091dd38da021bf266a3c9f09b.jpeg" style="border: 1px solid black;" /></a>&nbsp;&nbsp;<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120630.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/290/1f/d2/ae/1a6af525cfe2df0a9140824c1b.jpeg" style="border: 1px solid black;" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em;">其他方面：2014款<a class="t_link" href="http://product.cheshi.com/logo_5/" target="_blank"><font style="color: rgb(51, 51, 51);">宝马</font></a><a class="t_link" href="http://product.cheshi.com/bseries_1854/" target="_blank"><font style="color: rgb(51, 51, 51);">X5</font></a>美规版的安全特性集成设计为车辆提供了最大限度的保护。和所有<a class="t_link" href="http://product.cheshi.com/logo_5/" target="_blank"><font style="color: rgb(51, 51, 51);">BMW</font></a>安防车辆一样，全新一代BMW X5升级版防弹车的安防组件和技术均在常规BMW X5<a class="t_link" href="http://product.cheshi.com/" target="_blank"><font style="color: rgb(51, 51, 51);">车型</font></a>研发之初就进行集成设计。</span></p>\r\n<p style="text-align: center; text-indent: 0px;">\r\n	<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120632.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/600/d5/54/96/b40531f90fd803a5fc1b267cd9.jpeg" style="border: 1px solid black;" /></a></p>\r\n<p style="text-align: center; text-indent: 0px;">\r\n	<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120633.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/290/c7/b7/43/15aff4de7a2ff7cdc7d9e26135.jpeg" style="border: 1px solid black;" /></a>&nbsp;&nbsp;<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120635.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/290/9b/a7/99/b0514b3ccbadd9246293aba379.jpeg" style="border: 1px solid black;" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em;">动力方面：2014款宝马X5美规版搭载输出功率高达330千瓦/450马力的V8双涡轮增压汽油发动机和宝马xDrive智能四轮驱动系统。</span></p>\r\n<p style="text-align: center; text-indent: 0px;">\r\n	<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120626.shtml" target="_blank"><img src="http://img2.cheshi-img.com/center/600/60/0d/30/be497aa3638f0848d447981331.jpeg" style="border: 1px solid black;" /></a></p>\r\n<p style="text-align: center; text-indent: 0px;">\r\n	<a href="http://news.cheshi.com/picbrowser/20140816/1469112_6120637.shtml" target="_blank"><img src="http://img.cheshi-img.com/center/600/3e/7c/1b/aeee756da7e9fd55dbcb0bc451.jpeg" style="border: 1px solid black;" /></a></p>\r\n<p>\r\n	<span style="text-indent: 2em;">使2014款宝马X5美规版升级版防弹车驾驶性能得到提升，提高了行驶稳定性。</span><a href="http://binhai.cheshi.com/" style="text-align: center; color: rgb(0, 82, 148); text-indent: 2em; font-family: Verdana, Geneva, sans-serif; font-size: 16px; text-decoration: none; background-color: rgb(249, 249, 249);">【网上车市 天津滨海行情.原创】</a></p>\r\n<p>\r\n	&nbsp;</p>\r\n<table align="center" bgcolor="#ffffff" border="0" cellpadding="0" cellspacing="0" class="table" style="border-color: rgb(211, 215, 216); margin: 0px auto; color: rgb(51, 51, 51); line-height: normal; font-family: Simsun;" width="578">\r\n	<tbody>\r\n		<tr>\r\n			<td align="right" bgcolor="#f5f7f9" class="yy_1225_td04" colspan="4" valign="center">\r\n				<p>\r\n					<a href="http://seller.cheshi.com/892682/"><font color="#000000">天津鸿通汽车贸易有限公司</font></a></p>\r\n				<a class="yy_1125_a" href="http://seller.cheshi.com/892682/">查看详情&gt;&gt;</a></td>\r\n		</tr>\r\n		<tr>\r\n			<td align="left" class="yy_1225_td05" height="20" width="35">\r\n				主营：</td>\r\n			<td align="left" class="yy_1225_td06" width="239">\r\n				宝马</td>\r\n			<td align="left" class="yy_1225_td06" width="40">\r\n				业务：</td>\r\n			<td align="left" class="yy_1225_td06" width="230">\r\n				<a href="http://seller.cheshi.com/892682/newcar.html"><font color="#006695">新车</font></a></td>\r\n		</tr>\r\n		<tr>\r\n			<td align="left" class="yy_1225_td07" height="20">\r\n				电话：</td>\r\n			<td align="left" class="yy_1225_td08">\r\n				13920020623</td>\r\n			<td align="left" class="yy_1225_td09">\r\n				地址：</td>\r\n			<td align="left" class="yy_1225_td09">\r\n				天津港保税区天保大道86号渤海国际汽车城一层C01-8</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p style="margin: 19px 0px 0px; padding: 0px !important; text-align: center; color: rgb(51, 51, 51); text-indent: 28px; font-family: Verdana, Geneva, sans-serif; font-size: 16px; word-break: break-all; background-color: rgb(249, 249, 249);">\r\n	<span style="font-size: 14px;"><strong><span style="color: rgb(255, 0, 0);">更多详情请点击：</span><a href="http://binhai.cheshi.com/" style="color: rgb(0, 82, 148); text-decoration: none;"><span style="color: rgb(255, 0, 0);">http://binhai.cheshi.com/</span></a><span style="color: rgb(255, 0, 0);">&nbsp;网上车市滨海车市</span></strong></span></p>\r\n<p style="margin: 19px 0px 0px; padding: 0px !important; color: rgb(51, 51, 51); text-indent: 28px; font-family: Verdana, Geneva, sans-serif; font-size: 16px; word-break: break-all; background-color: rgb(249, 249, 249);">\r\n	<span style="font-size: 14px;">温馨提示：以上<a class="t_link" href="http://seller.cheshi.com/" style="color: rgb(0, 82, 148); text-decoration: none;" target="_blank"><font style="color: rgb(51, 51, 51); border-bottom-color: rgb(102, 102, 102); border-bottom-width: 1px; border-bottom-style: dashed;">购车</font></a>优惠信息由天津滨海综合<a class="t_link" href="http://seller.cheshi.com/" style="color: rgb(0, 82, 148); text-decoration: none;" target="_blank"><font style="color: rgb(51, 51, 51); border-bottom-color: rgb(102, 102, 102); border-bottom-width: 1px; border-bottom-style: dashed;">经销商</font></a>提供，仅供<a class="t_link" href="http://seller.cheshi.com/" style="color: rgb(0, 82, 148); text-decoration: none;" target="_blank"><font style="color: rgb(51, 51, 51); border-bottom-color: rgb(102, 102, 102); border-bottom-width: 1px; border-bottom-style: dashed;">购车</font></a>参考；由于行情因素价格浮动较大，具体车辆成交价格请致电商家获取最新报价；优惠行情可查阅网上车市天津滨海<a class="t_link" href="http://seller.cheshi.com/" style="color: rgb(0, 82, 148); text-decoration: none;" target="_blank"><font style="color: rgb(51, 51, 51); border-bottom-color: rgb(102, 102, 102); border-bottom-width: 1px; border-bottom-style: dashed;">经销商</font></a>报价后台，告知对方信息来源于网上车市将有更多优惠。</span></p>\r\n<ul class="tab_more clearfix">\r\n	<li class="lefts">\r\n		<a href="http://product.cheshi.com/bseries_35/seller.html?kid=n0060"><font size="4"><font color="#005294"><font face="微软雅黑"><strong>查看本地经销商</strong>&gt;&gt;</font></font></font></a></li>\r\n	<li>\r\n		<a href="http://product.cheshi.com/order/?source_detail=0000100004&amp;catesubclass=35&amp;kid=n0060"><font size="4"><font color="#005294"><font face="微软雅黑"><strong>咨询最低价</strong>&gt;&gt;</font></font></font></a></li>\r\n</ul>\r\n<p>\r\n	<!--sum_page_box--></p>\r\n<div class="sum_page_box clearfix y_1203_jump">\r\n	<h4>\r\n		<a href="http://click.cheshi.com/go.php?proid=0&amp;clickid=1386294556&amp;url=http%3a%2f%2fapp.cheshi.com%2fgmac%2findex.php"><font color="#dd0000">科鲁兹月供599元起</font></a> <a href="http://www.cheshi.com/15years/"><font color="#dd0000">15周年汽车生活文化节</font></a> <a href="http://click.cheshi.com/go.php?proid=0&amp;clickid=1397727767&amp;url=http%3a%2f%2fc.admaster.com.cn%2fc%2fa20580%2cb200473327%2cc1647%2ci0%2cm101%2ch"><font color="#dd0000">有&ldquo;致&rdquo;青年跨越神州之旅</font></a></h4>\r\n</div>\r\n<p>\r\n	&nbsp;</p>', '汽车', '', '网上车市', 'recommend', '2015-12-18'),
	(263, '[原创]口碑选车之中级车(上) 马6/天籁/思铂睿', 'upload/images/1408168289765.jpg', '<p>\r\n	[XCAR <a href="http://info.xcar.com.cn/guide/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">导购</a> 原创]</p>\r\n<p sizcache="2" sizset="76">\r\n	&nbsp;&nbsp;&nbsp; 除了日常导购<a href="http://drive.xcar.com.cn/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">试驾</a>类文章之外，左右我们购买选择的另外一大因素就是来自其它车主的口碑传播了，而爱卡<a href="http://www.xcar.com.cn/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">汽车</a>&ldquo;说真的&rdquo;频道正式这样一个&ldquo;口碑大本营&rdquo;。依托于数以万计真实车友们的评论，一款车的优缺点便一目了然，而我们此番开创的全新系列文章正是希望将车型推荐解析与车主真实口碑结合起来，为大家的选车提供更加切实有效地帮助。</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 爱卡&ldquo;说真的&rdquo;频道根据车型级别划分，总结出6个核心关键词分别为：最省油、乘坐最舒适、故障率最低、做工最好、操控最佳以及配置最满意，根据网友评分综合排名，在今天的第一集中我们将关注点锁定在中级车级别，看看在各项排名中谁得到的肯定是最多的。</p>\r\n<p sizcache="2" sizset="79" style="text-align: center">\r\n	<a href="http://newcar.xcar.com.cn/review.htm"><img alt="说真的" src="http://pic1.xcarimg.com/img/news_precommendo/2014/08/14/geClADmNlA1242.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="说真的" /></a></p>\r\n<p sizcache="2" sizset="80">\r\n	<strong sizcache="2" sizset="80">&nbsp; &nbsp; 推荐车型一：2014款 <a href="http://newcar.xcar.com.cn/132/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">一汽马自达6</a></strong></p>\r\n<p>\r\n	<strong>&nbsp; &nbsp; 售价区间：12.98-15.98万</strong></p>\r\n<p sizcache="2" sizset="81">\r\n	&nbsp;&nbsp;&nbsp; 在油耗这个单项中<a href="http://newcar.xcar.com.cn/132/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">马自达6</a>的评分高达4.5分，这也意味着大部分网友对于马自达6的油耗表现非常满意，通过实际评论也不难看出，2.0L自然吸气发动机日常综合油耗都能控制在9L以内，对于一款中级车来说确实可圈可点。</p>\r\n<p sizcache="2" sizset="82" style="text-align: center">\r\n	<a href="http://newcar.xcar.com.cn/132/review.htm"><img alt="马自达6" src="http://pic4.xcarimg.com/img/news_precommendo/2014/08/14/gQxpXP6lKg3973.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="马自达6" /></a></p>\r\n<p sizcache="2" sizset="83" style="text-align: center">\r\n	<a href="http://newcar.xcar.com.cn/132/review/3.htm"><img alt="马自达6" src="http://pic4.xcarimg.com/img/news_precommendo/2014/08/14/G1MTyyxneV8880.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="马自达6" /></a></p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 最为当今为数不多拥有着10年以上销售历史的&ldquo;车坛老将&rdquo;马自达6可谓深的民心，以至于到目前为止都还维持着不俗的销量，在2013年马自达6再次进行有小幅改款，并且通过将大幅度的优惠措施保持竞争力。在外观方面改款马自达6的变化并不大，分体式前大灯与同色的&ldquo;一字型&rdquo;中网都与没有变化，小小的升级来自于外后视镜，原翼子板侧上的转向灯被集成到后视镜上，夜间行驶的侧向安全性有所提升。</p>\r\n<p sizcache="2" sizset="84" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831315&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" src="http://img1.xcarimg.com/b53/s5964/608_456_20140616221749016293.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2014款马自达6" /></a></p>\r\n<p sizcache="2" sizset="85" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831314&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" class="smallpic" src="http://img1.xcarimg.com/b53/s5964/296_222_20140616221740230570.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2014款马自达6" /></a><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831313&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" class="smallpic" src="http://img1.xcarimg.com/b53/s5964/296_222_20140616221759651226.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="一汽马自达2014款马自达6" /></a></p>\r\n<p sizcache="2" sizset="87" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831312&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" src="http://img1.xcarimg.com/b53/s5964/608_456_20140616221752130177.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2014款马自达6" /></a></p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 新款马自达6在内饰方面同样做出了小幅修整，中控侧面的两个出风口增加电镀装饰圈，全黑内饰配色体现了充分的运动性，在装配工艺与用料方面虽然不能与早年款同日而语，但是考虑到实惠的售价也还是可以接受的。</p>\r\n<p sizcache="2" sizset="88" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831311&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" src="http://img1.xcarimg.com/b53/s5964/608_456_20140616222036602091.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2014款马自达6" /></a></p>\r\n<p sizcache="2" sizset="89" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831310&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" class="smallpic" src="http://img1.xcarimg.com/b53/s5964/296_222_20140616222039688964.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2014款马自达6" /></a><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831309&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" class="smallpic" src="http://img1.xcarimg.com/b53/s5964/296_222_20140616222044005436.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="一汽马自达2014款马自达6" /></a></p>\r\n<p>\r\n	&nbsp;</p>\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="xcar_tab_start" sizcache="2" sizset="91">\r\n	<tbody sizcache="2" sizset="91">\r\n		<tr sizcache="2" sizset="91">\r\n			<td sizcache="2" sizset="91">\r\n				<div class="xcarData" sizcache="2" sizset="91" style="border-bottom: rgb(127,192,230) 1px solid; position: relative; border-left: rgb(127,192,230) 1px solid; padding-bottom: 16px; background-color: rgb(250,250,250); margin-top: 20px; width: 564px; height: auto; color: rgb(152,152,152); margin-left: auto; border-top: rgb(127,192,230) 1px solid; margin-right: auto; border-right: rgb(127,192,230) 1px solid">\r\n					<div style="background-image: url(http://icon.xcar.com.cn/2012/images/power_ta.gif); position: absolute; width: 173px; background-position: 0px -28px; height: 28px; top: -21px; left: 14px">\r\n						&nbsp;</div>\r\n					<div class="power_tag_anli" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_arra.jpg); position: absolute; background-position: 183px 1px; color: rgb(103,103,103); top: 25px; right: 12px">\r\n						<em style="background-color: #5aaf6b; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px; margin-right: 14px">宽裕</span><em style="background-color: #6492e0; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px; margin-right: 14px">适中</span><em style="background-color: #e54140; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px">局促</span></div>\r\n					<div class="power_tag_ld" sizcache="2" sizset="91" style="z-index: 20; position: absolute; text-align: right; width: 370px; height: 28px; overflow: hidden; top: 24px; left: 0px">\r\n						<span sizcache="2" sizset="91" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_bgd.jpg); line-height: 24px; padding-left: 12px; display: inline-block; background-position: 0% 0px; height: 28px"><span sizcache="2" sizset="91" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_bgd.jpg); padding-right: 12px; display: inline-block; background-position: 100% -28px; height: 28px"><a href="http://newcar.xcar.com.cn/132/" target="_blank"><font color="#0072bb">马自达6</font></a> 空间舒适度：<b style="font-family: Verdana, Geneva, sans-serif; color: #6492e0">适中</b></span></span></div>\r\n					<div style="z-index: 0; position: relative; text-align: center; width: 564px; padding-top: 50px">\r\n						<span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 100px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 160px; opacity: 0.7">前排头部空间<br />\r\n						990mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 110px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 360px; opacity: 0.7">后排头部空间<br />\r\n						895mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 180px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 180px; opacity: 0.7">前排腿部空间<br />\r\n						855~1110mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 200px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 340px; opacity: 0.7">后排腿部空间<br />\r\n						630~880mm</span> <img class="nobShare_forapp" height="245" src="http://icon.xcar.com.cn/2012/images/pic_c.jpg" width="425" /></div>\r\n					<a class="xcardate_a" href="http://newcar.xcar.com.cn/132/space.htm" style="position: absolute; text-align: center; line-height: 16px; width: 95px; bottom: -9px; display: block; height: 16px; right: 14px" target="_blank">空间报告详情&gt;&gt;</a></div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n	<!--{%<city>END</city>%}-->\r\n</table>\r\n<p>\r\n	&nbsp; &nbsp; 动力系统并没有太多惊喜，依旧是搭载多年的2.0L自然吸气发动机与5速手自一体变速器，这台发动机的最大功率为108千瓦，最大扭矩为183牛米，动力输出差强人意，变速器由于技术滞后也没有太多亮点，日常驾驶基本能满足需求。</p>\r\n<p sizcache="2" sizset="93" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831308&amp;aid=284827" target="_blank"><img alt="试驾2013款马自达6" src="http://img1.xcar.com.cn/guide/7639/9534/608_456_20130827065839785676.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="试驾2013款马自达6" /></a></p>\r\n<p sizcache="2" sizset="94" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831307&amp;aid=284827" target="_blank"><img alt="一汽马自达2014款马自达6" src="http://img1.xcarimg.com/b53/s5964/608_456_20140616222051382261.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2014款马自达6" /></a></p>\r\n<p>\r\n	&nbsp; &nbsp; 马自达6在配置方面的表现还是能够令人满意，在保证足够低廉的售价基础上除了手动车型之外都装配了7英寸触摸显示器，并且增加了蓝牙与AUV接口，在功能上还集成了可视倒车系统，唯一可惜的是并没有内置导航软件，而在舒适型配置方面诸如自动空调、外后视镜电动折叠以及电动座椅调节等在高配车型上都有体现。</p>\r\n<p sizcache="2" sizset="95" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831306&amp;aid=284827" target="_blank"><img alt="试驾2013款马自达6" src="http://img1.xcar.com.cn/guide/7639/9534/608_456_20130827065858357213.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="试驾2013款马自达6" /></a></p>\r\n<p sizcache="2" sizset="96" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831305&amp;aid=284827" target="_blank"><img alt="试驾2013款马自达6" src="http://img1.xcar.com.cn/guide/7639/9534/608_456_20130827065853616397.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="试驾2013款马自达6" /></a></p>\r\n<p sizcache="2" sizset="97" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831304&amp;aid=284827" target="_blank"><img alt="一汽马自达2013款马自达6" src="http://img1.xcar.com.cn/b53/s5397/608_456_20130905164906318419.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="一汽马自达2013款马自达6" /></a></p>\r\n<p sizcache="2" sizset="97" style="text-align: center">\r\n	<strong>推荐车型二：2014款 </strong><a href="http://newcar.xcar.com.cn/189/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank"><strong>东风日产天籁</strong></a><strong>/公爵</strong></p>\r\n<p>\r\n	<strong>&nbsp; &nbsp; 售价区间：17.78-29.98万</strong></p>\r\n<p sizcache="2" sizset="85">\r\n	&nbsp; &nbsp; <a href="http://newcar.xcar.com.cn/189/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">天籁</a>长久以来倍受好评的就是其出色的乘坐舒适度，在这一点上也得到了爱卡网友们的广泛认同，在舒适度评分上达到了4.01分，从评价上来看突出的特点就是座椅柔软与悬挂调校非常舒适。</p>\r\n<p sizcache="2" sizset="86" style="text-align: center">\r\n	<a href="http://newcar.xcar.com.cn/189/review.htm"><img alt="天籁" src="http://pic4.xcarimg.com/img/news_precommendo/2014/08/14/SuvP14KG530044.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="天籁" /></a></p>\r\n<p sizcache="2" sizset="87" style="text-align: center">\r\n	<a href="http://newcar.xcar.com.cn/189/review/7.htm"><img alt="天籁" src="http://pic1.xcarimg.com/img/news_precommendo/2014/08/14/b1QID7tfpN0914.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="天籁" /></a></p>\r\n<p sizcache="2" sizset="88">\r\n	&nbsp; &nbsp; 完成最新换代的全<a href="http://newcar.xcar.com.cn/189/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">新天籁</a>在外观内饰风格上有了脱胎换骨的变化，老款沉闷中庸的外观被全新的流线型设计所替代，采用了全新的日常家族式元素，前脸X设计与发动机舱盖线条相呼应，侧面造型也更加紧致动感，新天籁走年轻化的设计路线相当彻底。</p>\r\n<p sizcache="2" sizset="89" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831303&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" src="http://img1.xcar.com.cn/b13/s5644/608_456_20131126010224572943.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2014款天籁" /></a></p>\r\n<p sizcache="2" sizset="90" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831302&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" class="smallpic" src="http://img1.xcar.com.cn/b13/s5644/296_222_20131126010141926534.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2014款天籁" /></a>&nbsp;<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831301&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" class="smallpic" src="http://img1.xcar.com.cn/b13/s5644/296_222_20131126010158716273.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="东风日产2014款天籁" /></a></p>\r\n<p sizcache="2" sizset="92" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831300&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" src="http://img1.xcarimg.com/b13/s5644/608_456_20131126010212160432.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2014款天籁" /></a></p>\r\n<p sizcache="2" sizset="93">\r\n	&nbsp; &nbsp; 新天籁在内饰方面较之老款车型也有很大幅度的改变，由老款多媒体与空调分布而置的方式，变成了贯穿上下的一个整体，而全新的镀铬装饰条取代了老款车型略显老气的木纹装饰板，搭配中控高亮钢琴漆饰板呈现出年轻化的设计<a href="http://newcar.xcar.com.cn/price/pb112/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">理念</a>，而在用料与工艺方面新天籁同样维持着一贯的高品质感，软性材质包裹的中控台触感非常出色。</p>\r\n<p sizcache="2" sizset="94" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831299&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" src="http://img1.xcar.com.cn/b13/s5644/608_456_20131128205616071384.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2014款天籁" /></a></p>\r\n<p sizcache="2" sizset="95" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831298&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" class="smallpic" src="http://img1.xcar.com.cn/b13/s5644/296_222_20131128205630594803.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2014款天籁" /></a><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831297&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" class="smallpic" src="http://img1.xcarimg.com/b13/s5644/296_222_20131128205624146807.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="东风日产2014款天籁" /></a></p>\r\n<p sizcache="2" sizset="97" style="text-align: center">\r\n	&nbsp;</p>\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="xcar_tab_start" sizcache="2" sizset="97">\r\n	<tbody sizcache="2" sizset="97">\r\n		<tr sizcache="2" sizset="97">\r\n			<td sizcache="2" sizset="97">\r\n				<div class="xcarData" sizcache="2" sizset="97" style="border-bottom: rgb(127,192,230) 1px solid; position: relative; border-left: rgb(127,192,230) 1px solid; padding-bottom: 16px; background-color: rgb(250,250,250); margin-top: 20px; width: 564px; height: auto; color: rgb(152,152,152); margin-left: auto; border-top: rgb(127,192,230) 1px solid; margin-right: auto; border-right: rgb(127,192,230) 1px solid">\r\n					<div style="background-image: url(http://icon.xcar.com.cn/2012/images/power_ta.gif); position: absolute; width: 173px; background-position: 0px -28px; height: 28px; top: -21px; left: 14px">\r\n						&nbsp;</div>\r\n					<div class="power_tag_anli" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_arra.jpg); position: absolute; background-position: 183px 1px; color: rgb(103,103,103); top: 25px; right: 12px">\r\n						<em style="background-color: #5aaf6b; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px; margin-right: 14px">宽裕</span><em style="background-color: #6492e0; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px; margin-right: 14px">适中</span><em style="background-color: #e54140; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px">局促</span></div>\r\n					<div class="power_tag_ld" sizcache="2" sizset="97" style="z-index: 20; position: absolute; text-align: right; width: 370px; height: 28px; overflow: hidden; top: 24px; left: 0px">\r\n						<span sizcache="2" sizset="97" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_bgd.jpg); line-height: 24px; padding-left: 12px; display: inline-block; background-position: 0% 0px; height: 28px"><span sizcache="2" sizset="97" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_bgd.jpg); padding-right: 12px; display: inline-block; background-position: 100% -28px; height: 28px"><a href="http://newcar.xcar.com.cn/189/" target="_blank"><font color="#0072bb">天籁</font></a> 空间舒适度：<b style="font-family: Verdana, Geneva, sans-serif; color: #6492e0">适中</b></span></span></div>\r\n					<div style="z-index: 0; position: relative; text-align: center; width: 564px; padding-top: 50px">\r\n						<span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 100px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 160px; opacity: 0.7">前排头部空间<br />\r\n						1005mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 110px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 360px; opacity: 0.7">后排头部空间<br />\r\n						880mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 180px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 180px; opacity: 0.7">前排腿部空间<br />\r\n						880~1090mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 200px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 340px; opacity: 0.7">后排腿部空间<br />\r\n						640~880mm</span> <img class="nobShare_forapp" height="245" src="http://icon.xcar.com.cn/2012/images/pic_c.jpg" width="425" /></div>\r\n					<a class="xcardate_a" href="http://newcar.xcar.com.cn/189/space.htm" style="position: absolute; text-align: center; line-height: 16px; width: 95px; bottom: -9px; display: block; height: 16px; right: 14px" target="_blank">空间报告详情&gt;&gt;</a></div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n	<!--{%<city>END</city>%}-->\r\n</table>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 动力方面，2.0L发动机进行了小幅调整，2.5L舍弃V6平顺的换来了成本更低、重量更轻、燃油经济性更佳的4缸，与老款相同的动力水准，第二代X-Tronic变速器比老款天籁在燃油经济性上提升10%左右。</p>\r\n<p sizcache="2" sizset="99" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831296&amp;aid=284827" target="_blank"><img alt="东风日产2013款天籁" src="http://img1.xcar.com.cn/guide/7639/7744/608_456_20130226172331253938.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2013款天籁" /></a></p>\r\n<p sizcache="2" sizset="100" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831295&amp;aid=284827" target="_blank"><img alt="东风日产2013款天籁" src="http://img1.xcarimg.com/guide/7639/7744/608_456_20130226172333219920.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2013款天籁" /></a></p>\r\n<p sizcache="2" sizset="101">\r\n	&nbsp;&nbsp;&nbsp; 新天籁在配置方面同样可圈可点，全系车型都标配了无钥匙启动、电动天窗、自动空调以及多功能方向盘，而在高配车型中诸如自动大灯、360可视系统、<a href="http://yp.xcar.com.cn/db/gps/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">GPS</a>导航以及座椅电加热等都包括在内，2014年上市的公爵系列车型更是将乘坐舒适度与豪华质感提升到新高度，包括后排中央扶手部分的集成功能按键、后排独立双液晶娱乐系统以及专属VIP标示刺绣真皮座椅都延续了公爵强调极致舒适的特点。</p>\r\n<p sizcache="2" sizset="102" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831294&amp;aid=284827" target="_blank"><img alt="东风日产2013款天籁" src="http://img1.xcar.com.cn/guide/7639/7744/608_456_20130226172251661045.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2013款天籁" /></a></p>\r\n<p sizcache="2" sizset="103" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831293&amp;aid=284827" target="_blank"><img alt="东风日产2013款天籁" src="http://img1.xcarimg.com/drive/7604/7804/608_456_20130311092811438901.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2013款天籁" /></a></p>\r\n<p sizcache="2" sizset="104" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831292&amp;aid=284827" target="_blank"><img alt="东风日产2013款天籁" src="http://img1.xcarimg.com/guide/7584/9460/608_456_20130809080245172996.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2013款天籁" /></a></p>\r\n<p sizcache="2" sizset="105" style="text-align: center">\r\n	<a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831291&amp;aid=284827" target="_blank"><img alt="东风日产2014款天籁" src="http://img1.xcar.com.cn/b13/s5644/608_456_20131128205309429314.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风日产2014款天籁" /></a></p>\r\n<p sizcache="2" sizset="97" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><strong>推荐车型三：2013款 </strong><a href="http://newcar.xcar.com.cn/price/b163/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank"><strong>东风本田</strong></a><strong> </strong><a href="http://newcar.xcar.com.cn/936/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank"><strong>思铂睿</strong></a></span></p>\r\n<p>\r\n	<span class="article_keys_edit" id="editor_baidu"><strong>&nbsp; &nbsp; 售价区间：21.58-25.58万</strong></span></p>\r\n<p>\r\n	<span class="article_keys_edit" id="editor_baidu">&nbsp;&nbsp;&nbsp; 虽然在中级车领域中相对比较冷门，但是思铂睿在车主中的口碑一直不错，从爱卡说真的频道评分来看，在品质单项中的得分高达4.33分，受到普遍认可的原因是质量极其稳定，小毛病少，车身结构相对出色车主省时省心。</span></p>\r\n<p sizcache="2" sizset="77" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://newcar.xcar.com.cn/936/review.htm"><img alt="思铂睿" src="http://pic4.xcarimg.com/img/news_precommendo/2014/08/14/XFc2kAw54A1230.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="78" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://newcar.xcar.com.cn/936/review/4.htm"><img alt="天籁" src="http://pic4.xcarimg.com/img/news_precommendo/2014/08/14/Mxk970Jizz0910.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="天籁" /></a></span></p>\r\n<p sizcache="2" sizset="79">\r\n	<span class="article_keys_edit" id="editor_baidu">&nbsp;&nbsp;&nbsp; 被当做运动版<a href="http://newcar.xcar.com.cn/149/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">雅阁</a>引入的思铂睿在上市初期凭借其相对凌厉的造型赢得了很多<a href="http://newcar.xcar.com.cn/price/pb17/" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">本田</a>粉的推崇，但是相对较高的定价还是带来了局限性，叫好不叫座的思铂睿一直在销量上没有改善，虽然在之后也推出了2.0L车型拉低门槛，但效果一直并不明显。全新改款思铂睿在外观方面的变化不大，只是略微调整了中网面积，造型改为更简洁的双横幅式造型，下进气口形状则由老款的倒梯形改为正梯形，经过重新设计的<a href="http://www.xcar.com.cn/forumdisplay.php?fid=30" style="border-bottom: #333 1px dashed; color: black; text-decoration: none" target="_blank">保险</a>杠更加粗壮扎实。</span></p>\r\n<p sizcache="2" sizset="82" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831290&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" src="http://img1.xcar.com.cn/b163/s4387/608_456_201212270022221100704.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="83" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831289&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" class="smallpic" src="http://img1.xcarimg.com/b163/s4387/296_222_201212270022271100705.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831288&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" class="smallpic" src="http://img1.xcar.com.cn/b163/s4387/296_222_201212270022361100707.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="85" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831287&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" src="http://img1.xcar.com.cn/b163/s4387/608_456_201212270022171100703.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p>\r\n	<span class="article_keys_edit" id="editor_baidu">&nbsp;&nbsp;&nbsp; 思铂睿在内饰氛围的营造上也要更加偏重运动属性，三幅式方向盘造型动感手感饱满，多功能按键的丰富性也十分出色，另外在内饰配色上也十分考究，红黑相间的双色运动座椅，中控金属色饰板以及挡把上的红色缝线都更能激起驾驶者的热情。唯一让人觉得稍感遗憾的就是整体材质的塑料质感稍微强了一点。</span></p>\r\n<p sizcache="2" sizset="86" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831286&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" src="http://img1.xcar.com.cn/b163/s4387/608_456_201212270033571100919.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="87" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831285&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" class="smallpic" src="http://img1.xcarimg.com/b163/s4387/296_222_201212270034121100923.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831284&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" class="smallpic" src="http://img1.xcarimg.com/b163/s4387/296_222_201212270032181100890.jpg" style="border-bottom: rgb(51,51,51) 1px solid; border-left: rgb(51,51,51) 1px solid; border-top: rgb(51,51,51) 1px solid; border-right: rgb(51,51,51) 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="97" style="text-align: center">\r\n	&nbsp;</p>\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="xcar_tab_start" sizcache="2" sizset="89">\r\n	<tbody sizcache="2" sizset="89">\r\n		<tr sizcache="2" sizset="89">\r\n			<td sizcache="2" sizset="89">\r\n				<div class="xcarData" sizcache="2" sizset="89" style="border-bottom: rgb(127,192,230) 1px solid; position: relative; border-left: rgb(127,192,230) 1px solid; padding-bottom: 16px; background-color: rgb(250,250,250); margin-top: 20px; width: 564px; height: auto; color: rgb(152,152,152); margin-left: auto; border-top: rgb(127,192,230) 1px solid; margin-right: auto; border-right: rgb(127,192,230) 1px solid">\r\n					<div style="background-image: url(http://icon.xcar.com.cn/2012/images/power_ta.gif); position: absolute; width: 173px; background-position: 0px -28px; height: 28px; top: -21px; left: 14px">\r\n						<span class="article_keys_edit" id="editor_baidu">&nbsp;</span></div>\r\n					<div class="power_tag_anli" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_arra.jpg); position: absolute; background-position: 183px 1px; color: rgb(103,103,103); top: 25px; right: 12px">\r\n						<span class="article_keys_edit" id="editor_baidu"><em style="background-color: #5aaf6b; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px; margin-right: 14px">宽裕</span><em style="background-color: #6492e0; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px; margin-right: 14px">适中</span><em style="background-color: #e54140; width: 12px; display: block; float: left; height: 12px; overflow: hidden; margin-right: 6px">&nbsp;</em><span style="display: block; float: left; height: 12px">局促</span></span></div>\r\n					<div class="power_tag_ld" sizcache="2" sizset="89" style="z-index: 20; position: absolute; text-align: right; width: 370px; height: 28px; overflow: hidden; top: 24px; left: 0px">\r\n						<span class="article_keys_edit" id="editor_baidu"><span sizcache="2" sizset="89" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_bgd.jpg); line-height: 24px; padding-left: 12px; display: inline-block; background-position: 0% 0px; height: 28px"><span sizcache="2" sizset="89" style="background-image: url(http://icon.xcar.com.cn/2012/images/power_bgd.jpg); padding-right: 12px; display: inline-block; background-position: 100% -28px; height: 28px"><a href="http://newcar.xcar.com.cn/936/" target="_blank"><font color="#0072bb">思铂睿</font></a> 空间舒适度：<b style="font-family: Verdana, Geneva, sans-serif; color: #6492e0">适中</b></span></span></span></div>\r\n					<div style="z-index: 0; position: relative; width: 564px; padding-top: 50px">\r\n						<span class="article_keys_edit" id="editor_baidu"><span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 100px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 160px; opacity: 0.7">前排头部空间<br />\r\n						960mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 110px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 360px; opacity: 0.7">后排头部空间<br />\r\n						900mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 180px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 180px; opacity: 0.7">前排腿部空间<br />\r\n						855~1075mm</span> <span style="border-bottom: #a0bddd 1px solid; position: absolute; text-align: left; filter: alpha(opacity=70); border-left: #a0bddd 1px solid; padding-bottom: 2px; background-color: #fff; padding-left: 6px; padding-right: 6px; color: #62656a; border-top: #a0bddd 1px solid; top: 200px; border-right: #a0bddd 1px solid; padding-top: 4px; left: 340px; opacity: 0.7">后排腿部空间<br />\r\n						620~865mm</span> <img class="nobShare_forapp" height="245" src="http://icon.xcar.com.cn/2012/images/pic_c.jpg" width="425" /></span></div>\r\n					<span class="article_keys_edit" id="editor_baidu"><a class="xcardate_a" href="http://newcar.xcar.com.cn/936/space.htm" style="position: absolute; line-height: 16px; width: 95px; bottom: -9px; display: block; height: 16px; right: 14px" target="_blank">空间报告详情&gt;&gt;</a></span></div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n	<!--{%<city>END</city>%}-->\r\n</table>\r\n<p style="text-align: left">\r\n	<span class="article_keys_edit" id="editor_baidu">&nbsp;&nbsp;&nbsp; 改款思铂睿将老款2.4L发动机进行了升级，提升了进气流量，并且改变了压缩比（老款10.5；新款11.5）最大功率由老款的133kW（180Ps）/6500rpm提升为新款的148kW（200Ps）/7000rpm，扭矩由老款的225N&middot;m/4300rpm提升为233N&middot;m/4300rpm。与之匹配的变速器依旧为5速手自一体。</span></p>\r\n<p sizcache="2" sizset="91" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831283&amp;aid=284827" target="_blank"><img alt="东风本田2009款思铂睿" src="http://img1.xcar.com.cn/drive/1607/2111/608_456_20100518025019424400.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2009款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="92" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831282&amp;aid=284827" target="_blank"><img alt="东风本田2009款思铂睿" src="http://img1.xcar.com.cn/drive/1607/2111/608_456_20100518025024424402.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2009款思铂睿" /></a></span></p>\r\n<p>\r\n	<span class="article_keys_edit" id="editor_baidu">&nbsp;&nbsp;&nbsp; 思铂睿在车型配置也并不含糊，全系车型都标配了自动空调与动态稳定系统，其中2.4L车型相比2.0L还增加了无钥匙启动系统与内置防炫目后视镜，而在高配车型中诸如下氙气大灯、自动头灯、车载蓝牙以及感应雨刷等都涵盖其中，最顶配的TYPE-S在外观方面还具有更为运动化的包围套件。</span></p>\r\n<p sizcache="2" sizset="93" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831281&amp;aid=284827" target="_blank"><img alt="东风本田2009款思铂睿" src="http://img1.xcarimg.com/b163/s1434/608_456_erx9egbcrr6724.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2009款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="94" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831280&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" src="http://img1.xcarimg.com/guide/5231/7461/608_456_201211291857281078266.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="95" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831279&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" src="http://img1.xcarimg.com/b163/s4387/608_456_201212270033301100912.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p sizcache="2" sizset="96" style="text-align: center">\r\n	<span class="article_keys_edit" id="editor_baidu"><a href="http://precommendo.xcar.com.cn/group/view_t.php?pid=1831278&amp;aid=284827" target="_blank"><img alt="东风本田2013款思铂睿" src="http://img1.xcarimg.com/b163/s4387/608_456_201212270031581100882.jpg" style="border-bottom: #333 1px solid; border-left: #333 1px solid; border-top: #333 1px solid; border-right: #333 1px solid" title="东风本田2013款思铂睿" /></a></span></p>\r\n<p>\r\n	<span class="article_keys_edit" id="editor_baidu">&nbsp;&nbsp;&nbsp; <strong>总结：</strong>在今天的文章中我们为大家总结了爱卡&ldquo;说真的&rdquo;频道中级车领域内：油耗、乘坐舒适度以及质量稳定性最受认可的车型，如果您认为内容不够充实还可以点击文章中图片跳转到&ldquo;说真的&rdquo;频道内了解更多车型评分情况，在下期文章中我们将继续为大家推荐中级车中另外三项评分最为出色的车型。</span></p>', '汽车', '李想', '爱卡汽车', 'recommend', '2014-08-16'),
	(264, '[腾讯行情]南京 风神S30最高优惠3000元', '', '<p style="text-indent: 2em">\r\n	[腾讯行情 南京站]近日，编辑从江苏启辰汽车贸易有限公司了解到，店内风神S30少量现车销售，颜色可选，目前购车最高可优惠3000元，感兴趣的朋友可以到店咨询购买，详情见下表：</p>\r\n<p style="text-indent: 2em">\r\n	<style type="text/css">\r\n/*行情样式*/.hqtab {border-top:#666 solid 1px;border-left:#666 solid 1px; width:550px;margin:0 auto 15px auto}.hqtab td, .hqtab th{ font-size:12px;line-height:18px; padding:0px; text-align:center; border-bottom:#666 solid 1px;border-right:#666 solid 1px;}.hqtab td{ font-size:12px;}.hqtab a{ color:#000;}.hqtab a:hover{ color:#C2130E;}.hqtab p{ margin:0; padding:0}.hqtab th{background:#cccccc;font-weight:bold}.hqtab .red{ color:red}.hqico{color:#fff}	</style>\r\n</p>\r\n<p>\r\n	&nbsp;</p>\r\n<table align="center" border="0" cellpadding="0" cellspacing="0" class="hqtab" width="550">\r\n	<tbody>\r\n		<tr>\r\n			<th colspan="2">\r\n				车型+车款</th>\r\n			<th>\r\n				指导价</th>\r\n			<th>\r\n				降幅</th>\r\n			<th>\r\n				现价</th>\r\n			<th>\r\n				降幅比例</th>\r\n			<th width="90">\r\n				备注</th>\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20105/index.shtml" target="_blank"><img alt="风神S30 2014款 1.6L MT尊雅型CNG" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_151435_31585500_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20105/index.shtml" target="_blank">风神S30 2014款 1.6L MT尊雅型CNG</a></td>\r\n			<td width="60">\r\n				8.18万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20105" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.30万</span></td>\r\n			<td width="60">\r\n				7.88万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20105" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				3.66%</td>\r\n			<!--TD>有</TD-->\r\n			<td rowspan="7">\r\n				少量现车</td>\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20104/index.shtml" target="_blank"><img alt="风神S30 2014款 1.6L MT感恩版CNG" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_151330_14609310_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20104/index.shtml" target="_blank">风神S30 2014款 1.6L MT感恩版CNG</a></td>\r\n			<td width="60">\r\n				7.08万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20104" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.30万</span></td>\r\n			<td width="60">\r\n				6.78万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20104" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				4.23%</td>\r\n			<!--TD>有</TD-->\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20101/index.shtml" target="_blank"><img alt="风神S30 2014款 1.5L AT尊雅型" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_145601_89302040_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20101/index.shtml" target="_blank">风神S30 2014款 1.5L AT尊雅型</a></td>\r\n			<td width="60">\r\n				7.98万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20101" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.30万</span></td>\r\n			<td width="60">\r\n				7.68万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20101" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				3.75%</td>\r\n			<!--TD>有</TD-->\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20103/index.shtml" target="_blank"><img alt="风神S30 2014款 1.5L AT尊贵型" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_150153_32603640_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20103/index.shtml" target="_blank">风神S30 2014款 1.5L AT尊贵型</a></td>\r\n			<td width="60">\r\n				8.88万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20103" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.30万</span></td>\r\n			<td width="60">\r\n				8.58万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20103" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				3.37%</td>\r\n			<!--TD>有</TD-->\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20100/index.shtml" target="_blank"><img alt="风神S30 2014款 1.5L MT尊雅型" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_145344_73955430_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20100/index.shtml" target="_blank">风神S30 2014款 1.5L MT尊雅型</a></td>\r\n			<td width="60">\r\n				7.18万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20100" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.30万</span></td>\r\n			<td width="60">\r\n				6.88万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20100" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				4.17%</td>\r\n			<!--TD>有</TD-->\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20102/index.shtml" target="_blank"><img alt="风神S30 2014款 1.5L MT尊贵型" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_150038_33564700_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20102/index.shtml" target="_blank">风神S30 2014款 1.5L MT尊贵型</a></td>\r\n			<td width="60">\r\n				7.98万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20102" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.30万</span></td>\r\n			<td width="60">\r\n				7.68万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20102" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				3.75%</td>\r\n			<!--TD>有</TD-->\r\n		</tr>\r\n		<tr>\r\n			<td style="padding-bottom: 0px; padding-left: 0px; padding-right: 0px; padding-top: 0px" width="80">\r\n				<a href="http://data.auto.qq.com/car_models/20099/index.shtml" target="_blank"><img alt="风神S30 2014款 1.5L MT感恩版" height="60" src="http://img1.gtimg.com/datalib_img/CarModel/20140718/20140718_144735_68608450_thumbnail_280_200.jpg" width="78" /></a></td>\r\n			<td width="160">\r\n				<a href="http://data.auto.qq.com/car_models/20099/index.shtml" target="_blank">风神S30 2014款 1.5L MT感恩版</a></td>\r\n			<td width="60">\r\n				5.98万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20099" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="40">\r\n				<span style="color: #ff0000">0.01万</span></td>\r\n			<td width="60">\r\n				5.97万\r\n				<p>\r\n					<a href="http://data.auto.qq.com/car_public/1/calc.shtml#stype=quankuan&amp;brandid=97&amp;seriesid=530&amp;modelid=20099" target="_blank" title="计算购买价格"><img alt="[腾讯行情]南京 风神S30最高优惠3000元" src="http://mat1.gtimg.com/auto/datalib/new_auto_all/cacu.gif" style="vertical-align: -2px" /></a></p>\r\n			</td>\r\n			<td width="60">\r\n				0.16%</td>\r\n			<!--TD>有</TD-->\r\n		</tr>\r\n		<tr>\r\n			<td colspan="7">\r\n				<div align="right">\r\n					制表 腾讯汽车</div>\r\n			</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p align="center">\r\n	<a href="http://data.auto.qq.com/car_public/hq/areanewslist_jiangsu.shtml" target="_blank">查看更多降价信息请进&gt;&gt;降价栏目首页</a></p>\r\n<p style="text-indent: 2em">\r\n	<SCRIPT language=JavaScript type=text/javascript>if(typeof getUin === "undefined"){ function getUin() { var arr = document.cookie.match(new RegExp("(^| )o_cookie=([^;]*)(;|$)")); var uin = \'; if (arr != null) { uin = arr[2]; uin = uin.replace(new RegExp("[^0-9]","gm"), ""); uin = uin.replace(new RegExp("^0+","gm"), ""); } return uin; }}if(typeof g_uin === "undefined"){ var g_uin = getUin();}if(typeof g_boss_img === "undefined"){ var g_boss_img = new Image(1,1);}if(typeof SerialBossLink === "undefined"){ function SerialBossLink(sid,type) { g_boss_img.src="http://btrace.qq.com/collect?sIp=&iQQ="+g_uin+"&sBiz=&sOp=&iSta=&iTy=256&iFlow=&iSerialID="+sid+"&iLinkType="+type; }}SerialBossLink(530,100);</SCRIPT>\r\n	<style type="text/css">\r\n#datat2 { padding-left:10px;padding-top:8px;font-size:12px;height:25px; color:5B5B5B}#datat2 a{color:#0033CC;text-decoration: none;}#datat2 .datar{color: #ff0000; font-weight:bold; font-size:16px; font-family:verdana; }#datat2 .mini{ font-family:Tahoma; font-size:9px ; }	</style>\r\n</p>\r\n<p align="center">\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<div class="mbArticleSharePic   " r="1" style="width: 552px">\r\n	<div class="mbArticleShareBtn">\r\n		<span>转播到腾讯微博</span></div>\r\n	<a alt="2014款 风神S30 1.6L MT感恩版" href="http://data.auto.qq.com/car_public/1/disp_pic_nl.shtml?sid=530&amp;tid=1&amp;pid=1322118" target="blank"><img alt="2014款 风神S30 1.6L MT感恩版" src="http://img1.gtimg.com/datalib_img/14-02-17/4/c8fd618b9ac2c00aeb57cbd74c2f7951.jpg" style="border-bottom: #000000 1px solid; border-left: #000000 1px solid; width: 550px; height: 366px; border-top: #000000 1px solid; border-right: #000000 1px solid" /></a></div>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<center>\r\n	<table bgcolor="#b9b9b9" border="0" cellpadding="3" cellspacing="1" id="datat2" width="550">\r\n		<tbody>\r\n			<tr bgcolor="#ffffff">\r\n				<td align="left" bgcolor="#ffffff" class="black" height="21" style="padding-left: 10px" valign="bottom">\r\n					<span style="float: left"><span style="font-size: 14px; font-weight: bold"><a class="black" href="http://data.auto.qq.com/car_serial/530/index.shtml" onclick="SerialBossLink(530,101);return true;" target="_blank">风神S30</a></span> 价格：<span class="datar"> 5.98-8.88 </span>万元品牌：<a href="http://data.auto.qq.com/car_brand/210/index.shtml" onclick="SerialBossLink(530,102);return true;" target="_blank">东风风神</a></span> <span style="margin-top: 5px; padding-right: 4px; float: right"><a href="http://club.auto.qq.com/forum-0-1.html" onclick="SerialBossLink(530,103);return true;" target="_blank">车友论坛&gt;&gt;</a></span></td>\r\n			</tr>\r\n			<tr bgcolor="#ffffff">\r\n				<td align="left" bgcolor="#f6f6f6" height="21" style="padding-left: 10px; padding-right: 10px">\r\n					<span style="float: left"><a href="http://data.auto.qq.com/car_serial/530/index.shtml" onclick="SerialBossLink(530,104);return true;" target="_blank">参数配置</a> | <a href="http://data.auto.qq.com/piclib/index.shtml#sid=530" onclick="SerialBossLink(530,105);return true;" target="_blank">车型图片</a> | <a href="http://data.auto.qq.com/car_serial/530/news.shtml" onclick="SerialBossLink(530,106);return true;" target="_blank">相关资讯</a> | <a href="http://cgi.data.auto.qq.com/php/index.php?mod=wom&amp;serial=530" onclick="SerialBossLink(530,107);return true;" target="_blank">车友点评</a> | <a href="http://data.auto.qq.com/car_serial/530/fuelcost.shtml" onclick="SerialBossLink(530,108);return true;" target="_blank">油耗</a> </span><span class="mini" style="float: right"><a href="http://auto.qq.com/" onclick="SerialBossLink(530,109);return true;" target="_blank">auto.qq.com</a> 2014-08-14</span></td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</center>\r\n<p style="text-indent: 2em">\r\n	东风风神S30的官方建议保养周期和4S店建议保养周期均为7500公里/次。 6万公里的常规保养费用为3292.6元，这个费用在同级别车型中处于比较适中的价格。价格比较高的2次保养是3万公里和6万公里的时候，需要更换的油液配件比较多，但好在该车型的每样配件价格都比较便宜，这类大保养的费用还能控制在千元以内。</p>\r\n<p align="center">\r\n	&nbsp;</p>\r\n<div class="mbArticleSharePic">\r\n	<div class="mbArticleShareBtn">\r\n		<span>转播到腾讯微博</span></div>\r\n	<a alt="2014款 东风风神S30 1.5L AT尊雅型" href="http://data.auto.qq.com/car_public/1/disp_pic_nl.shtml?sid=530&amp;tid=2&amp;pid=1409286" target="blank"><img alt="2014款 东风风神S30 1.5L AT尊雅型" src="http://img1.gtimg.com/datalib_img/14-08-01/6/c7c3db9987af8007bfeb5a88a6f98cc7.jpg" style="border-bottom: #000000 1px solid; border-left: #000000 1px solid; width: 550px; height: 366px; border-top: #000000 1px solid; border-right: #000000 1px solid" /></a></div>\r\n<p>\r\n	&nbsp;</p>\r\n<center>\r\n	<table bgcolor="#b9b9b9" border="0" cellpadding="3" cellspacing="1" id="datat2" width="550">\r\n		<tbody>\r\n			<tr bgcolor="#ffffff">\r\n				<td align="left" bgcolor="#ffffff" class="black" height="21" style="padding-left: 10px" valign="bottom">\r\n					<span style="float: left"><span style="font-size: 14px; font-weight: bold"><a class="black" href="http://data.auto.qq.com/car_serial/530/index.shtml" onclick="SerialBossLink(530,101);return true;" target="_blank">风神S30</a></span> 价格：<span class="datar"> 5.98-8.88 </span>万元品牌：<a href="http://data.auto.qq.com/car_brand/210/index.shtml" onclick="SerialBossLink(530,102);return true;" target="_blank">东风风神</a></span> <span style="margin-top: 5px; padding-right: 4px; float: right"><a href="http://club.auto.qq.com/forum-0-1.html" onclick="SerialBossLink(530,103);return true;" target="_blank">车友论坛&gt;&gt;</a></span></td>\r\n			</tr>\r\n			<tr bgcolor="#ffffff">\r\n				<td align="left" bgcolor="#f6f6f6" height="21" style="padding-left: 10px; padding-right: 10px">\r\n					<span style="float: left"><a href="http://data.auto.qq.com/car_serial/530/index.shtml" onclick="SerialBossLink(530,104);return true;" target="_blank">参数配置</a> | <a href="http://data.auto.qq.com/piclib/index.shtml#sid=530" onclick="SerialBossLink(530,105);return true;" target="_blank">车型图片</a> | <a href="http://data.auto.qq.com/car_serial/530/news.shtml" onclick="SerialBossLink(530,106);return true;" target="_blank">相关资讯</a> | <a href="http://cgi.data.auto.qq.com/php/index.php?mod=wom&amp;serial=530" onclick="SerialBossLink(530,107);return true;" target="_blank">车友点评</a> | <a href="http://data.auto.qq.com/car_serial/530/fuelcost.shtml" onclick="SerialBossLink(530,108);return true;" target="_blank">油耗</a> </span><span class="mini" style="float: right"><a href="http://auto.qq.com/" onclick="SerialBossLink(530,109);return true;" target="_blank">auto.qq.com</a> 2014-08-14</span></td>\r\n			</tr>\r\n		</tbody>\r\n	</table>\r\n</center>\r\n<p style="text-indent: 2em">\r\n	2014款S30采用了全新样式的进气格栅，官方称之为飞燕式，但新老款车型很难分别其细微的变化。而2014款风神S30最主要的变化在于除两款感恩版车型外，其余车型均配备了LED日间行车灯。新车车身尺寸分别为4526mm/1740mm/1465mm，轴距为2610mm。搭载了全新1.5L发动机和1.6L CNG双燃料动力系统，其中1.5L发动机最大功率85kW，最大扭矩145Nm。与发动机匹配的是5速手动或4速手自一体变速箱。</p>\r\n<p style="text-indent: 2em">\r\n	如需试驾请填写以下内容</p>\r\n<p>\r\n	&nbsp;</p>\r\n<table background="http://mat1.gtimg.com/autonanjing/css/wecar/wecar.jpg" cellpadding="0" cellspacing="0" height="420" width="640">\r\n	<tbody>\r\n		<tr>\r\n			<td height="60" width="57">\r\n				&nbsp;</td>\r\n			<td width="381">\r\n				&nbsp;</td>\r\n			<td width="200">\r\n				&nbsp;</td>\r\n		</tr>\r\n		<tr>\r\n			<td>\r\n				&nbsp;</td>\r\n			<td>\r\n				<iframe class="registrationIframe" frameborder="0" height="360" id="iframe_1408168366515" scrolling="no" src="http://wecar.qq.com/api/activity/regpreview?act_id=1859&amp;width=380&amp;height=360&amp;title=%5B%u817E%u8BAF%u884C%u60C5%5D%u5357%u4EAC%20%u98CE%u795ES30%u6700%u9AD8%u4F18%u60E03000%u5143_%u6C7D%u8F66_%u817E%u8BAF%u7F51&amp;url=http%3A%2F%2Fnanjing.auto.qq.com%2Fa%2F20140814%2F022852.htm&amp;bgcolor=ffffff&amp;color=676767&amp;button=http://mat1.gtimg.com/auto/images/car2013/dealer_admin/reg.png&amp;qq=&amp;rid=iframe_1408168366515" style="height: 276px" width="380"></iframe></td>\r\n			<td>\r\n				&nbsp;</td>\r\n		</tr>\r\n	</tbody>\r\n</table>\r\n<p style="text-indent: 2em">\r\n	经销商名称：江苏启辰汽车贸易有限公司</p>\r\n<p style="text-indent: 2em">\r\n	经销商地址：南京市江宁区润麒路9号、大明路37号</p>\r\n<p style="text-indent: 2em">\r\n	经销商电话：025-58323688</p>\r\n<p style="border-bottom: #e5e5e5 1px solid; text-indent: 2em; background: #fbfbfb; border-top: #e5e5e5 1px solid">\r\n	<strong><a href="http://data.auto.qq.com/car_public/1/hq.shtml" target="_blank">各地行情</a></strong>：<a href="http://data.auto.qq.com/car_public/hq/areanewslist_beijing.shtml" target="_blank">北京</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_tianjin.shtml" target="_blank">天津</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_shanghai.shtml" target="_blank">上海</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_guangdong.shtml" target="_blank">广东</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_jiangsu.shtml" target="_blank">江苏</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_gansu.shtml" target="_blank">甘肃</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_shanxi.shtml" target="_blank">陕西</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_shenzhen.shtml" target="_blank">深圳</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_heilongjiang.shtml" target="_blank">黑龙江</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_jilin.shtml" target="_blank">吉林</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_chongqing.shtml" target="_blank">重庆</a> <a href="http://data.auto.qq.com/car_public/hq/areanewslist_guangxi.shtml" target="_blank">广西</a></p>', '汽车', '', '腾讯汽车', 'recommend', '2014-08-16'),
	(265, '车与油的故事 CVT与5AT谁更省油？', 'upload/images/1412558433281.jpg', '<p>\r\n	　CVT一直以来给人传动效率高、省油的印象，然而是否省油？能比AT车型省油多少？一直没有机会证实。这次我们找到两台东风本田杰德（以下简称杰德），一台CVT车型，一台5AT车型，看看两种变速箱型式哪个更省油。</p>\r\n<p>\r\n	　　● 测试车型介绍<br />\r\n	　　同排量既提供CVT变速箱，又提供AT变速箱的车型，市面上非常少见。杰德全系搭载1.8L自然吸气发动机，低配车型搭载的是5AT变速箱，高配车型搭载CVT变速箱。我们的两台测试车分别是：杰德1.8L 自动舒适版 5座和杰德1.8L CVT豪华版 6座。</p>\r\n<p>\r\n	　　官方数据显示，两车的工信部综合油耗相差不大，5AT车型油耗为6.9L/100km，CVT车型油耗为6.8L/100km，CVT要稍微省油一点。</p>\r\n<p>\r\n	<br />\r\n	　　注：由于不同品牌、不同车型的变速箱匹配与程序设定并不相同。因此，这次对比测试不一定具有绝对的代表性，请各位酌情参考。<br />\r\n	　　● 测试方法及测试前期准备<br />\r\n	　　油耗测试采用我们常规的测试方式，在同一个加油站、同一支油枪加满油，之后两车走同样路段同时进行测试，连续跑100km左右，包括高速和城区拥堵路况，之后再次加满油，第二次加油量&divide;公里数&times;100，得到的就是平均油耗。</p>\r\n<p>\r\n	　　杰德高低配车型轮胎采用不同品牌，不过规格完全相同。5AT车型采用的是优科豪马ADVANdb decibel系列，CVT车型采用的是邓禄普SP SPORT 270，轮胎规格都是215/50 R17。原厂采用不同品牌轮胎，尽管这有可能造成油耗差异，不过因为规格相同，差异会比较小，我们暂不考虑这一因素。</p>\r\n<p>\r\n	<br />\r\n	　　在测试过程中我们驾驶方式接近，尽量减少因驾驶方式不同造成的油耗误差。测试中尽量模拟多数车主日常用车习惯，完全变速箱自己换挡，不人为干预；起步时缓给油；因测试当天气温不高，所以我们没有开启空调，不过在城区时偶尔开窗通风换气（两车同时）。</p>\r\n<p>\r\n	　　测试前开启ECON模式，全程不关闭，另外要说的是，我们试驾这款车的时候就发现，不管是5AT车型还是CVT车型，开启ECON模式和关闭ECON模式，动力输出的差别是非常大的，开启ECON时动力明显受到抑制，以达到节油的目的。</p>', '汽车', '汽车之家专业评测团队', '新华网', 'recommend', '2014-10-06'),
	(266, '精彩徐州 悦享钜惠 华晨亮相徐州汽车节', 'upload/images/1412558638796.jpg', '<p>\r\n	&nbsp;&nbsp; 2014年10月1日，中国徐州第十三届汽车节秋季展将于新长江物流园隆重启幕。中国自主品牌主力军华晨汽车闪亮来袭，为消费者奉献一场别具风格的汽车饕餮盛宴。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<br />\r\n	&nbsp;&nbsp;&nbsp; 品质科技 创新出击<br />\r\n	&nbsp;&nbsp;&nbsp; 本届车展，华晨汽车携8款精品车型强势登陆。由中华新V5、中华新H530、中华V5、中华H330、中华H220组成的超级阵容将从城市SUV、紧凑家轿多角度诠释品质性价比。金杯推出的金杯新海狮、金杯海狮、金杯阁瑞斯亦彰显非凡商务魅力。<br />\r\n	&nbsp;&nbsp;&nbsp; 中华新V5、中华新H530已率先在8月份的成都车展上首发上市，是华晨汽车最新的两款&ldquo;升级产品&rdquo;：以&ldquo;澎湃T动力&rdquo;著称的中华新V5将完美演绎&ldquo;高起点自主研发都市SUV&rdquo;的突出优势，从时尚外观、舒适空间到主被动安全配置、节能减排等方面均以超越者姿态领先同级竞品车；定位&ldquo;宽适品质家轿&rdquo;的中华新H530则充分彰显澎湃T动力与超大空间的创新特色。其超长车身、超竞品的轴距和轮距、人性化科技，以及520L行李箱、20余处储物空间等周到设计将带给国内消费者耳目一新的驾乘感。<br />\r\n	&nbsp;&nbsp;&nbsp; 金杯新海狮、金杯阁瑞斯也是车展的重大看点：金杯新海狮集充沛空间、舒适乘驾、动力承载三大优势，以&ldquo;新外观、新技术、新体验&rdquo;三大变革强势来袭，开启一个金杯新商务时代；金杯阁瑞斯则秉承金杯25年优秀品质，融入国际流行元素的设计，以低调务实的形象获得消费者的普遍认可，成为商务出行的首选车。</p>\r\n<p>\r\n	&nbsp;</p>\r\n<p>\r\n	<br />\r\n	&nbsp;&nbsp;&nbsp; 缤纷钜惠 贴心回馈<br />\r\n	&nbsp;&nbsp;&nbsp; 华晨汽车还推出了多种超值活动回馈广大车友及消费者的厚爱！车展期间，中华新V5、中华新H530将全面接受预订，热衷两款升级版车型的消费者将有机会大饱眼福！中华其他参展车型将实施3000元&mdash;&mdash;20000元优惠，另加送价值3000元大礼包。金杯品牌不仅实施低价起售政策，同时还奉献精彩豪礼：购买金杯阁瑞斯的消费者额外收获千元精品礼包；购买金杯新海狮、金杯海狮的消费者更将悦享&ldquo;套餐+&rdquo;服务，即分别获得&ldquo;1000元现金优惠+1000元精品礼包&rdquo;、&ldquo;5000元现金优惠+1000元精品礼包&rdquo;。<br />\r\n	&nbsp;&nbsp;&nbsp; 多年来，华晨汽车不仅坚守着&ldquo;德国技术传承，国际合作典范&rdquo;的品牌内涵，也始终致力改革创新，因此华晨展台将成为本届车展不容错失的风景线！</p>', '汽车', '', '爱卡汽车', 'recommend', '2014-10-06'),
	(267, '到底谁最安全？主流中型车安全配置对比', 'upload/images/1412558910984.jpg', '<p>\r\n	车型图片&nbsp;&nbsp;&nbsp;&nbsp;<br />\r\n	厂商指导价 26.58万 23.98万 23.69万 23.69万<br />\r\n	长&times;宽&times;高(mm) 4860&times;1854&times;1480 4870&times;1840&times;1450 4869&times;1854&times;1472 4805&times;1860&times;1458<br />\r\n	车型图片&nbsp;&nbsp;&nbsp;&nbsp;<br />\r\n	驾驶座安全气囊 ● ● ● ●<br />\r\n	副驾驶安全气囊 ● ● ● ●<br />\r\n	前排头部气囊(气帘) ● ● ● ●<br />\r\n	后排头部气囊(气帘) ● ● ● ●<br />\r\n	前排侧气囊 ● ● ● ●<br />\r\n	后排侧气囊 - - - ●<br />\r\n	膝部气囊 ● - - -<br />\r\n	后排安全带气囊 ● - - -<br />\r\n	车型图片&nbsp;&nbsp;&nbsp;&nbsp;<br />\r\n	iso fix儿童座椅接口(国际标准) ● ● ● ●<br />\r\n	latch儿童座椅接口(美国标准) - - - -<br />\r\n	胎压监测装置 ● - ● ●<br />\r\n	防盗报警器 - ● - ●<br />\r\n	发动机防盗锁止 ● ● ● ●<br />\r\n	车内中控锁 ● ● ● ●<br />\r\n	遥控钥匙 ● ● ● ●</p>', '汽车', '', '爱卡汽车', 'recommend', '2014-10-06'),
	(268, '宜宾房地产开发商突围之路', 'upload/images/1412559281375.jpg', '<p>\r\n	过惯了好日子的宜宾开发商们，面对困难局面，将如何度过这个寒冬？ 记者 甯立 摄<br />\r\n	&ldquo;疯狂&rdquo;多年的中国楼市，终于在2014年开始低下了高傲的头。过惯了好日子的宜宾开发商们，面对困难局面，用什么突围？将如何度过这个寒冬？<br />\r\n	&nbsp;<br />\r\n	其实在2014年宜宾主城区前两次土地拍卖过程中，开发商们对后市谨慎不乐观的心态已经展露无遗，2013年还是抢破头的主城区地块，今年共四块地居然就流拍了两块，可见开发商们主动收缩战线，手中多留现金过冬的态度已经形成了主流。<br />\r\n	&nbsp;<br />\r\n	在宜宾开发商中，对市场反应敏锐的正和集团是个典型代表，开发金帝庄园之后，最近两年都没在宜宾拿地，今年年初还把在宜宾多年开发保留的全部门面，车位等统统转让，全部换成现金，储备好粮草了。<br />\r\n	&nbsp;<br />\r\n	与此相对应的是，宜宾本土部分在头两年疯狂拿地，争当地王，四处出击的开发商，日子普遍都过得比较艰难。</p>', '创业', '', '中国宜宾网', 'recommend', '2014-10-06'),
	(269, '限贷松绑三天 南京楼市认购已超千套', 'upload/images/1412559500593.jpg', '<p>\r\n	昨天，市民在一楼盘促销点前询问行情。本报记者 吴彬摄<br />\r\n	　　9月30日，央行、银监会联合发布&ldquo;松贷&rdquo;通知，给楼市注入又一剂&ldquo;强心针&rdquo;。国庆黄金周前3天，南京商品住宅已累计认购1100余套，日均认购371套，同比增长36%。全市商品住宅的库存量也从此前的5.3万余套回落到5.2万余套。<br />\r\n	　　10月1日，楼市&ldquo;松贷&rdquo;后的第一天，浦口的正荣润江城率先推出一批新房源，结果半天就卖出了10套。&ldquo;没想到行情这么好。从客户的表现来看，他们出手明显果断多了，有的是第一次来看房就买了。&rdquo;正荣润江城项目相关负责人说。<br />\r\n	　　其他很多在国庆黄金周期间新开盘或举办促销活动的老盘，人气也都比较旺盛。其中，城东的中海国际社区举办了&ldquo;来看房，送螃蟹&rdquo;活动，连续3天每天吸引了上千人前来看房、领螃蟹。仙林的香悦澜山开展了&ldquo;来访就送加油卡、食用油&rdquo;以及7D电影和抽奖活动，每天前来看房的人也达到2000名左右。<br />\r\n	　　&ldquo;说心里话，松贷后，我感觉房价可能已经见底了。国庆节嫌人多也没出去旅游，正好来看看房子，我准备尽快把首套房贷还完，然后再买一套。&rdquo;在香悦澜山售楼处现场，市民朱先生说，他算是改善性需求，当然也多少带点投资的因素，还清房贷后，正好满足房贷新政的要求。<br />\r\n	　　面对松贷和突然又多起来的看房人，很多开发商都开心坏了。在南京地产界微信&ldquo;朋友圈&rdquo;上，不少营销负责人和老总都在晒售楼处人气、发笑脸、求点赞。<br />\r\n	　　南京网上房地产的统计数据显示，10月1日，全市商品住宅共认购471套，创下近年来国庆节单日认购新高；10月2日，认购量为376套；10月3日，截至下午5点，认购量就已达到266套。而在去年国庆黄金周期间，南京楼市日均认购量只有273套。在今年9月南京取消楼市限购之前，日均认购量也只有200套左右。<br />\r\n	　　证大喜玛拉雅营销总监张邺丹表示，松贷提振了开发商的信心，缓解了此前很多企业资金链紧张的问题，楼市前景可期。<br />\r\n	　　&ldquo;国庆7天去库存的情况，是判断松贷威力的主要指标。&rdquo;南京林业大学城市与房地产研究中心主任孟祥远分析，国庆前3天楼市认购走高，市场明显回暖。按照这个势头来看，整个黄金周期间楼市的业绩应该不会差。<br />\r\n	　　南京房地产开发建设促进会秘书长张辉表示，松贷通知发出后，正好碰上国庆节，很多银行都放假了。这是一个具有极大弹性的房贷新政，各地后面具体会怎样执行，还有待于国庆黄金周之后进一步观察。对于开发商来说，目前最主要的是趁着行情好赶紧跑量，切忌随意涨价。（邹伟 沙文蓉）</p>', '房地产', '邹伟 沙文蓉', '人民网', 'recommend', '2014-10-06'),
	(270, '国庆4天房产类刷卡交易200亿 廊坊最受外地人亲睐', 'upload/images/1412560133750.jpg', '<p>\r\n	[摘要]据银行卡跨行交易系统显示，截止至10月4日，全国购房刷卡交易的总金额为187.9亿元。统计数据中还显示了较为受外地购房者青睐的城市，排名居首的是距离北京较近的廊坊市，其他依次为成都、武汉、苏州、惠州。据了解，廊坊的房产84%都是卖给了北京人，苏州的房产交易里有52%卖给了上海人。</p>\r\n<p>\r\n	房地产行业一直有种说法叫做&ldquo;金九银十&rdquo;，十月份是购房的好时节，购房对于老百姓来说是件极其重要的事情。10月4日，中央台记者来到位于上海的中国银联总部信息中心，梳理十一期间全国房子成交的数据。<br />\r\n	据银行卡跨行交易系统显示，截止至10月4日，全国购房刷卡交易的总金额为187.9亿元。房产交易热力图显示，四川、重庆、上海三地房产交易的总金额居于全国前三位，其中，成都市以8.24亿元的成交金额居全国之首，重庆和上海分别为6.4亿元和5.91亿元。</p>\r\n<p>\r\n	国庆4天房产类刷卡交易200亿<br />\r\n	统计数据中还显示了较为受外地购房者青睐的城市，排名居首的是距离北京较近的廊坊市，其他依次为成都、武汉、苏州、惠州。据了解，廊坊的房产84%都是卖给了北京人，苏州的房产交易里有52%卖给了上海人。<br />\r\n	&nbsp;<br />\r\n	&nbsp;购房城市排行榜 廊坊最受外地人欢迎<br />\r\n	数据分析师带来了两组数据，一是与去年同期相比，今年房产类数据较去年下降了20.5%，而2013年较2012年则是上涨了30.6%，两年变化差异明显，银联交易系统分析发现，2013年楼市交易数据是最为火爆的一年，交易量上涨明显，2014年则出现明显回落，国庆四天房产交易变化的特点是整个楼市近几年来的缩影。第二组数据显示，国庆四天内，房产日均交易较平日下降36.4%，下降幅度较为明显。</p>\r\n<p>\r\n	2013相比较2012年上涨30.6% 2014相比较2013年下降20.5%<br />\r\n	让人产生疑问的是，在金九银十这样一个特殊的时段，并且在节前国家发布新的利于房地产的政策的同时，房产类交易数据为何下降如此明显？数据分析师解释道，第一，新的政策出台，市场和消费者还需要消化的过程，目前大部分消费者还是处于观望的心态。第二，从银联交易数据分析发现，在节假日期间，消费者更多的是选择看房，而到了节后，才会出现新的房产交易高峰。</p>', '房地产', '', '新华网', 'recommend', '2014-10-06'),
	(271, '新华房产权威发布 18家房企获"中国责任房企"殊荣', 'upload/images/1412560270406.jpg', '<p>\r\n	&nbsp; 新华房产9月28日北京讯（记者 王日晨）9月26日下午，由新华网主办、新华网房地产事业中心承办的&ldquo;回到常态：结构调整与责任意识&mdash;&mdash;2014年度中国责任房企颁奖典礼暨新华地产研究院启动仪式&rdquo;在北京举行。碧桂园、恒大、万达、万科等18家企业获得首批&ldquo;中国责任房企&rdquo;殊荣。</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 新华网副总裁魏紫川出席颁奖现场致辞<br />\r\n	&nbsp;&nbsp;&nbsp; 新华网副总裁魏紫川、新华网房地产事业中心总经理谷春宁、新华网房地产事业中心市场运营部总经理王欢、新华网房地产事业中心新闻编辑部总编辑陈卿以及包括万科等18家房地产企业的代表出席了本次颁奖典礼。</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 新华网副总裁魏紫川、新华网房地产事业中心总经理谷春宁出席颁奖现场<br />\r\n	&nbsp;&nbsp;&nbsp; 新华网副总裁魏紫川在致辞中表示，当前的房地产行业已经进入白银时代，房地产下半场对企业能力的考验会更加全面，不适应的企业会被淘汰，而优秀企业并不会缺少成长空间，绝大部分房地产企业仍然对整个行业抱有信心。随着市场的逐步成熟，房地产的存在必将更加专业化、市场化，这才是常态。&ldquo;同时，房地产企业在积极应对行业系统性风险的同时，也通过自身的坚持、积累、改变、创新，在建筑品质、设计方向、居住体验、服务意识、生活配备等方面尝试更多样性、多元化的开发思路，通过不同的方式在结构调整的同时，践行着企业责任和社会责任。&rdquo;<br />\r\n	&nbsp;&nbsp;&nbsp; 新华网副总裁魏紫川指出，新华网作为国家重点新闻网站的排头兵，关注责任房企倾听整个行业的告白，回到常态，推动整个行业健康发展。为此，新华网新华房产启动2014年度中国责任房企评选和新华地产研究院，希望通过对企业开发思路和开发细节的梳理，探寻房地产企业兑现承诺的必要性以及存在的社会价值。</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 新华网房地产事业中心总编辑陈卿发言<br />\r\n	&nbsp;&nbsp;&nbsp; 随后，新华网副总裁魏紫川现场为首批获得新华网&ldquo;中国责任房企&rdquo;公司代表一一颁奖。包括碧桂园集团、恒大集团、绿地控股集团、雅居乐地产控股有限公司、复地（集团）股份有限公司、万达集团佳兆业集团控股有限公司、天津房地产集团有限公司、万科企业股份有限公司、龙湖地产有限公司、朗诗集团、金科地产集团股份有限公司、中粮地产（集团）股份有限公司、融创中国控股有限公司、中信房地产股份有限公司、方兴地产（中国）有限公司、宝龙地产控股有限公司、中洲房地产有限公司总共18家获得新华网首批&ldquo;中国责任房企&rdquo;殊荣。（以上企业排名不分先后）</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 众多房企嘉宾出席颁奖现场</p>\r\n<p>\r\n	&nbsp;&nbsp;&nbsp; 颁奖现场</p>', '房地产', '杨森 杨力郡 曹艺', '新华网', 'recommend', '2014-10-06'),
	(272, '国庆节看亚运健儿 国产大屏电视机推荐', 'upload/images/1412560723843.gif', '<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　第十七届亚洲运动会于2014年9月19日在韩国仁川举行。目前亚运会赛程过半，中国代表团以105块金牌，216块奖牌的绝对优势领跑奖牌榜。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　现在这个多元化的时代，热衷体育的人自然在亚运会期间可以享受到一场视觉盛宴；即使不爱看体育运动的人，也可以在赛场上找到看点，不管是老牌男神林丹，还是新晋&ldquo;小鲜肉&rdquo;宁泽涛，或者是开闭幕式上的韩国欧巴们，都是一道特别的风景。</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://homea.people.com.cn/n/2014/0929/c41390-25757455-2.html" style="color: rgb(42,93,156); text-decoration: none"><img alt="140929" src="http://www.people.com.cn/mediafile/pic/20140929/67/17925259049382079159.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　虽然亚运会中国代表团称霸完全没有悬念，但十一长假，看着中国的体育健儿为了突破自我的极限和国家荣誉在赛场上拼搏，想必观众心中都是充满了自豪。本届亚运会又恰逢国庆，双喜临门的日子，当然要用国产大屏电视看亚运才叫爽。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　<strong>熊猫P51F31D等离子电视</strong></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　熊猫P51F31D是目前市面上少有的等离子大屏电视，该机支持USB蓝光高清解码，具有双3D处理引擎等新技术，在色彩和清晰度方面表现出色，操作方式简单，很容易被老人小孩所接受。等离子的特性就是没有拖尾，特别适合观看体育赛事。目前京东这款大屏等离子电视仅售2199元，极具性价比，值得购买。</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://homea.people.com.cn/n/2014/0929/c41390-25757455-2.html" style="color: rgb(42,93,156); text-decoration: none"><img alt="QQ截图20140806232851" src="http://www.people.com.cn/mediafile/pic/20140929/3/7276702758218658859.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p align="center" class="pictext" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	熊猫P51F31D等离子电视</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　外观方面，熊猫P51F31D采用超窄边框，为用户带来宽广视界，摒弃传统外观的厚重边缘，力求在细节之处彰显简洁美感，与您的时尚家居风格浑然相配。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　画质方面，熊猫P51F31D采用高端产品上搭载的迅锐图像处理引擎技术，通过对图像信息在色调、饱和度、亮度、对比度等细节方面进行智能对比，有效修复信号压缩传输过程中可能出现的细节损失，大幅提升画面质量，还原真实的图像效果。另外，熊猫double-3d技术，带来了平滑顺畅的动态显示效果，在播放3d画面时，也能轻松感受熊猫3d的震撼。</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://homea.people.com.cn/n/2014/0929/c41390-25757455-2.html" style="color: rgb(42,93,156); text-decoration: none"><img alt="rBEQYFNF9QoIAAAAAAF0s-ahh7wAAEIIQHhjwoAAXTL707" src="http://www.people.com.cn/mediafile/pic/20140929/96/5244800250565784324.gif" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　内置强劲的视频解码处理器，支持多种视频，高清视频格式文件，可以通过u盘，移动硬盘等多种外设接入播放，轻松享受3d大片，打造家庭影院舒适观影模式。</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://homea.people.com.cn/n/2014/0929/c41390-25757455-2.html" style="color: rgb(42,93,156); text-decoration: none"><img alt="rBEhWlNF9dkIAAAAAAFMkQQQdPUAALgSAOsS08AAUyp760" src="http://www.people.com.cn/mediafile/pic/20140929/90/2482089724341413398.gif" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　点评：作为一款超值产品，熊猫P51F31D电视在功能设置和性能表现上毫不含糊，有着优异的3d场景表现力，画面立体逼真，也无闪烁拖尾等现象，提升消费者的用户体验。</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　熊猫P51F31D</p>\r\n<p style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 10px 0px; word-spacing: 0px; font: 14px/25px 宋体; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); text-align: left; word-wrap: break-word; orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	　　[参考报价] 2199元</p>', '家电', '', '中国家电网', 'recommend', '2014-10-06'),
	(273, 'LG推全球首款曲面IPS屏21:9显示器 1299美元', 'upload/images/1412560913671.jpg', '<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　众所周知，在面板技术方面，IPS（In-plane&nbsp;Switching）&nbsp;相较&nbsp;TN&nbsp;（Twisted&nbsp;Nematic）拥有诸多明显优势，特别在可视角度上。如今&nbsp;IPS&nbsp;面板的产品已经相当丰富，身边很多显示器或电视机都有采用。不过，到目前为止，基于弧形曲面的&nbsp;IPS&nbsp;显示器还未曾出现。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　相信很多人会说，IPS&nbsp;和弧形面板基本扯不上关系，因为&nbsp;IPS&nbsp;最早便以硬屏著称，而且提供的广视角已经完全可以满足多角度阅读，抵消了屏幕内凹的效果，完全没有意义，然而主打&nbsp;IPS&nbsp;面板技术的&nbsp;LG&nbsp;却不这么认为。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	&nbsp;</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138491.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138491.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p>\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　威锋网&nbsp;10&nbsp;月&nbsp;3&nbsp;日消息&nbsp;近日，LG&nbsp;宣布全世界第一台采用曲面&nbsp;IPS&nbsp;屏幕和&nbsp;21:9&nbsp;宽屏高比的超宽屏显示器正式上市。该显示器具体名称为&nbsp;LG&nbsp;34UC97&nbsp;Curved&nbsp;UltraWide&nbsp;Monitor，34&nbsp;英寸大小，AH-IPS&nbsp;面板，屏幕采用略微弯曲的设计，同时作为一款超宽屏显示器，其屏幕长宽比例为&nbsp;21:9，相比目前主流的&nbsp;16:9&nbsp;提供了更宽的视角。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	&nbsp;</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138492.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138492.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p>\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　一些规格方面，&nbsp;LG&nbsp;34UC97&nbsp;显示器的实际尺寸为&nbsp;32.7&nbsp;英寸，3440&times;1440&nbsp;像素的分辨率，可视角度为&nbsp;178/178&deg;，300cd/m2&nbsp;亮度，设有传输速度是&nbsp;USB&nbsp;3.0&nbsp;4&nbsp;倍的&nbsp;Thunderbolt&nbsp;2&nbsp;接口、2&nbsp;个&nbsp;HDMI&nbsp;接口、1&nbsp;个&nbsp;DisplayPort&nbsp;接口和&nbsp;2&nbsp;个&nbsp;USB&nbsp;3.0&nbsp;接口，内置&nbsp;7W&nbsp;的&nbsp;&nbsp;MAXX&nbsp;AUDIO&nbsp;立体声扬声器。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	&nbsp;</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138493.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138493.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>\r\n<p>\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　LG&nbsp;表示该显示器性能</span><span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">出色</span><span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">、</span><span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">外观</span><span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">时尚。其实该显示器另一大亮点在于符合&nbsp;99%&nbsp;的&nbsp;Adobe&nbsp;RGB&nbsp;色域标准，并配有&nbsp;LG&nbsp;独家提供的真彩专业校准软件&nbsp;Dual&nbsp;Color&nbsp;Space。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　通常不按常理出牌的&nbsp;21:9&nbsp;颇具争议，比如这款&nbsp;LG&nbsp;34UC97&nbsp;显示器，虽然&nbsp;LG&nbsp;特别指定了此类型分辨率级别的标准简称为&nbsp;UQHD，但看起来很高分辨率但却没有达到真正的&nbsp;4K&nbsp;级别，而且极难适应多种媒体视图，除非自己的电视节目或影片符合此分辨率，或者数码摄影师、平面设计师和电影制作者的工作需求，要不然超宽屏会被浪费很多空间无法使用。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<span style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(17,17,17); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">　　LG&nbsp;34UC97&nbsp;显示器同时兼容&nbsp;PC&nbsp;和&nbsp;Mac，目前已经开始在全球范围内出货，官方报价&nbsp;1299&nbsp;美元，预计国内零售价格为&nbsp;7999&nbsp;元人民币。</span><br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	<br style="word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px" />\r\n	&nbsp;</p>\r\n<p align="center" style="padding-right: 0px; padding-left: 0px; padding-bottom: 0px; margin: 0px; word-spacing: 0px; font: 14px/25px Arial, &#65533;&#65533;&#65533;&#65533;, sans-serif; text-transform: none; color: rgb(51,51,51); text-indent: 0px; padding-top: 0px; white-space: normal; letter-spacing: normal; background-color: rgb(255,255,255); orphans: auto; widows: auto; webkit-text-stroke-width: 0px">\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138494.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138494.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a><br />\r\n	<br />\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138495.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138495.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a><br />\r\n	<br />\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138506.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138506.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a><br />\r\n	<br />\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138507.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138507.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a><br />\r\n	<br />\r\n	<a href="http://resource.feng.com/resource/h041/h04/img201410031138508.jpg" style="color: rgb(51,51,51); text-decoration: none; outline: none" title="LG推全球首款曲面IPS屏21:9显示器 1299美元"><img src="http://resource.feng.com/resource/h041/h04/img201410031138508.jpg" style="border-right: medium none; border-top: medium none; border-left: medium none; border-bottom: medium none" /></a></p>', '创业', '', '威锋网', 'recommend', '2014-10-06'),
	(274, 'MIT学者探访深圳：硬件制造业的追随者正转型为领导者', 'upload/images/1412561103984.jpg', '<p>\r\n	注：本文作者Joi Ito，为MIT媒体实验室主管。<br />\r\n	去年，一群Media Lab的学生访问了深圳，随行的还有我的老朋友，也是我的硬件导师&ldquo;bunnie&rdquo;（Andrew &quot;bunnie&quot; Huang：著名硬件黑客）。bunnie干过最经典的一件事可能要算黑掉了Xbox，他也是开源网络硬件设备Chuby的创造者之一，为许多人提供硬件，固件，以及软件设计的支持。我想不到有谁比他更熟悉中国的供应商和制造工厂生态系统了。<br />\r\n	在他的帮助下，我的学生看到也感受到了一个让我们每个人受益的硬件制造生态系统，但实际上，很多人并不知道有这样一个生态系统存在。之前我也是通过学生口述，或是相关报道间接感受到这个生态系统的强大，但是直到最近，我才和bunnie一起来到深圳，亲自探访了这个神奇的地方。Bunnie坚持说，我们组团去深圳的人不能太多，因为我们要去的地方不适合涌进太多人，而且人少也比较灵活方便。机缘巧合的是，我另外两位老朋友&mdash;&mdash;LinkedIn创始人Reid Hoffman和麻省理工大学的教务长Marty Schmidt都对深圳之旅充满兴趣，于是我们就组成了这么一个略显奇怪的&ldquo;旅行团&rdquo;。<br />\r\n	硬件工厂<br />\r\n	我们深圳之旅的第一站，是一家由AQS公司运营的小工厂，这家制造商在加州Fremont和深圳都设有工厂，主要工作是在电路板上安装芯片。该工厂的机器配备了表面装配技术（SMT），可以利用计算机编程的气体力学挑选芯片和其他组件，并把它们安装在电路板上。除了成排的SMT机器之外，生产线上还有很多工人，给设备编程，使用X射线测试结果，计算机和人工都是这条生产线的一部分。无论从经济角度，还是技术角度来看，这种生产线都是非常有意义的。AQS生产的电路板贴纸是由Media Lab学生Jie Qi和毕业生Ayah Bdeir（littleBits首席执行官）设计的。之前，他们的产量很小，风险也非常高，而且由于和创业者或学生合作，产量需求通常得不到保证，因此很难找到中国合作伙伴。但是在bunnie的帮助下，AQS开始与初创公司和其他项目紧密合作，业绩也越来越出色。<br />\r\n	让我感到印象深刻的并不是那些技术，而是bunnie介绍给我们认识的人，比如这家工厂的老板John，还有项目经理和工程师们。他们工作非常努力，也很有经验，值得信赖，这帮人对于和bunnie以及我们的朋友一起工作感到非常兴奋。他们愿意也有能力设计并尝试各种新的流程，生产那些从来没有制造过的东西。他们的职业道德，以及充满能量的工作精神感染着我，让我想到以前日本那些创业者和工程师，他们在战后构建了日本的制造工业。<br />\r\n	在所有探访的小工厂里面，工人们都居住在距离工厂较近的宿舍里面，他们在一起吃饭，一起生活。生活开支都依靠工厂，而他们则会把自己薪水的存起来。同样的，工厂所有管理层，甚至老板也和工人们生活在一起，我肯定访问的这家工厂是精挑细选出来的，因为貌似每个人都看上去非常高兴，很开朗，彼此也非常亲密。<br />\r\n	访问过AQS之后，我们来到了King Credie，他们是一家制造印制电路板（PCB）的工厂。PCB的制造过程非常复杂，除了添加电路层之外，还要蚀刻并打印各种材料，整个流程步骤繁多，控制也很复杂。这些工厂一般不让外人进入参观。<br />\r\n	我们还参观了一家注塑工厂，bunnie一直在帮我完成一个需要相对复杂注塑操作的项目。无论是手机还是汽车座椅，绝大多数塑料零件都需要注塑模具。整个制造需要创建一个巨大的钢塑料注入模具&ldquo;工具&rdquo;，你能想象过程会多么困难，因为如果你需要保持镜面光洁，那么模具也必须要镜面光洁；而如果你需要产品公差保持在千分之一的公差之内，那么就必须要让钢模具也达到那样的精度。此外，你要需要了解塑料是如何流入模具之中的，确保其冷却、均匀的进入模具漏洞之内，而不会发生扭曲或断裂。<br />\r\n	我们访问的这家工厂还有一个精密机械分厂和一批工程专家，他们共同设计、并制造我们的注塑模具工具，但是我们一开始的产量太低，他们根本不感兴趣。他们想要数百万的订单，而我们只需要几千个。<br />\r\n	有趣的是，这家工厂的老板建议我们可以在中国制造精密模具工具，然后把这些工具发送到美国，当地生产。由于我们要求净化间处理，他认为这样在美国生产反而更便宜，但是美国工厂并没有相关专业知识和能力，而且就算在真的在美国制造，在增值服务的成本上面也无法和中国工厂竞争。<br />\r\n	这种角色转换告诉我们，注塑模具制造的技术、贸易、以及专业知识都已经转移到了深圳。即便美国拥有这样的制造能力，但是只有深圳拥有最关键的制造知识生态系统。<br />\r\n	硬件市场<br />\r\n	bunnie之后带我们去看看了市场。我们花了半天时间才看到了整个市场的一小部分，那么有着巨大的建筑网络，各种小店铺，以及交易平台。那个市场是由数个巨大的城市街区组成的，在每个街区里有五到十个大楼，其中每层都有很多商户，他们经营着各种业务，比如销售LED等，手机解锁，手机维修。我知道自己又要老生常谈了，但是这的确是一个现实，许多厂商都专注在批发上面，他们忽略了零售领域，可是零售量其实也是非常巨大的，但是目前似乎和厂商还做不到较好地对接。<br />\r\n	我们来到市场的一个角落，那里的人们正在谈论破损和报废的手机，他们要把所有零件都拆解下来。一些依旧可以使用的手机零件会被拆掉，然后扔进一个大塑料袋里打包出售。那里的货源还有一部分是来自于工厂生产线上一些不合格的零件，或是在测试中不过关的印制电路板。iPhone的主键，无线芯片，三星屏幕，诺基亚主板，应有尽有。Bunnie指着一包芯片说，在美国它们要卖5万美金，在这里只需要500美元。那些芯片不会零卖，都是批发，称斤两，按重量计价。说不定，&ldquo;新手机&rdquo;里面的零件就是