/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.dao.impl;

import com.jspgou.common.hibernate3.HibernateBaseDao;
import com.jspgou.common.page.Pagination;
import com.jspgou.core.dao.MemberDao;
import com.jspgou.core.entity.Member;
import java.io.Serializable;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.springframework.stereotype.Repository;

@Repository
public class MemberDaoImpl
extends HibernateBaseDao<Member, Long>
implements MemberDao {
    @Override
    public Member getByUsername(String username) {
        String f = "from Member bean where bean.user.username=:username";
        return (Member)this.getSession().createQuery(f).setParameter("username", (Object)username).uniqueResult();
    }

    @Override
    public Member getByUserId(Long webId, Long userId) {
        String s = "from Member bean where bean.website.id=? and bean.user.id=?";
        return (Member)this.findUnique(s, new Object[]{webId, userId});
    }

    @Override
    public Member getByUserIdAndActive(String activationCode, Long userId) {
        String s = "from Member bean where bean.activationCode=? and bean.user.id=?";
        return (Member)this.findUnique(s, new Object[]{activationCode, userId});
    }

    @Override
    public Pagination getPage(int pageNo, int pageSize) {
        Criteria criteria = this.createCriteria(new Criterion[0]);
        Pagination pagination = this.findByCriteria(criteria, pageNo, pageSize);
        return pagination;
    }

    @Override
    public Member findById(Long id) {
        Member entity = (Member)this.get(id);
        return entity;
    }

    @Override
    public Member save(Member bean) {
        this.getSession().save((Object)bean);
        return bean;
    }

    @Override
    public Member deleteById(Long id) {
        Member entity = (Member)super.get((Serializable)id);
        if (entity != null) {
            this.getSession().delete((Object)entity);
        }
        return entity;
    }

    protected Class<Member> getEntityClass() {
        return Member.class;
    }
}

