/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.entity;

import com.jspgou.core.entity.Role;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.entity.base.BaseAdmin;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class Admin
extends BaseAdmin {
    private static final long serialVersionUID = 1L;

    public void init() {
        if (this.getCreateTime() == null) {
            this.setCreateTime(new Date());
        }
        if (this.getDisabled() == null) {
            this.setDisabled(false);
        }
    }

    public Set<String> getRolesPerms() {
        Set<Role> roles = this.getRoles();
        if (roles == null) {
            return null;
        }
        HashSet<String> allPerms = new HashSet<String>();
        for (Role role : this.getRoles()) {
            allPerms.addAll(role.getPerms());
        }
        return allPerms;
    }

    public Integer[] getRoleIds() {
        Set<Role> roles = this.getRoles();
        return Role.fetchIds(roles);
    }

    public void addToRoles(Role role) {
        if (role == null) {
            return;
        }
        Set<Role> set = this.getRoles();
        if (set == null) {
            set = new HashSet<Role>();
            this.setRoles(set);
        }
        set.add(role);
    }

    public boolean isSuper() {
        Set<Role> roles = this.getRoles();
        if (roles == null) {
            return false;
        }
        for (Role role : this.getRoles()) {
            if (!role.getSuper().booleanValue()) continue;
            return true;
        }
        return false;
    }

    public Admin() {
    }

    public Admin(Long id) {
        super(id);
    }

    public Admin(Long id, User user, Website website, Date date, Boolean boolean1) {
        super(id, user, website, date, boolean1);
    }

    public String getUsername() {
        User user = this.getUser();
        if (user != null) {
            return user.getUsername();
        }
        return null;
    }

    public String getEmail() {
        User user = this.getUser();
        if (user != null) {
            return user.getEmail();
        }
        return null;
    }

    public String getLastLoginIp() {
        User user = this.getUser();
        if (user != null) {
            return user.getLastLoginIp();
        }
        return null;
    }

    public Date getLastLoginTime() {
        User user = this.getUser();
        if (user != null) {
            return user.getLastLoginTime();
        }
        return null;
    }

    public String getCurrentLoginIp() {
        User user = this.getUser();
        if (user != null) {
            return user.getCurrentLoginIp();
        }
        return null;
    }

    public Date getCurrentLoginTime() {
        User user = this.getUser();
        if (user != null) {
            return user.getCurrentLoginTime();
        }
        return null;
    }
}

