/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.entity;

import com.jspgou.core.entity.Global;
import com.jspgou.core.entity.WebsiteAttr;
import com.jspgou.core.entity.base.BaseWebsite;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Website
extends BaseWebsite {
    private static final long serialVersionUID = 1L;
    public static final String RES_BASE = "r/gou/www";
    public static final String USER_BASE = "t";
    public static final String UPLOAD_PATH = "u";
    public static final String TEMPLATE_PATH = "gou/tpl";
    public static final String DEFAULT = "default";
    public static final String TPL_SUFFIX = ".html";
    public static final String TPL_PREFIX_SYS = "sys_";
    public static final String TPL_PREFIX_TAG = "tag_";
    public static final String TPL_BASE = "/WEB-INF/t/gou/tpl";

    public Website() {
    }

    public Website(Long id) {
        super(id);
    }

    public Website(Long id, Global global, String domain, String name, String currentSystem, String suffix, Integer lft, Integer rgt, Date createTime, Boolean close, Boolean relativePath, String frontEncoding, String frontContentType, String localeFront, String localeAdmin, Integer controlNameMinlen, String company, String copyright, String recordCode, String email, String phone, String mobile) {
        super(id, global, domain, name, currentSystem, suffix, lft, rgt, createTime, close, relativePath, frontEncoding, frontContentType, localeFront, localeAdmin, controlNameMinlen, company, copyright, recordCode, email, phone, mobile);
    }

    public String getTemplate(String dir, String name, String s2, String s3) {
        StringBuilder stringbuilder = this.getTemplateRelBuff().append("/").append(dir).append("/");
        if (!StringUtils.isBlank((String)s3)) {
            stringbuilder.append(s3);
        }
        stringbuilder.append(name);
        if (!StringUtils.isBlank((String)s2)) {
            stringbuilder.append("_").append(s2);
        }
        return stringbuilder.append(TPL_SUFFIX).toString();
    }

    public String getUrl() {
        return this.getUrlBuff(false).append("/").toString();
    }

    public String getUploadRel(String s) {
        StringBuilder stringbuilder = new StringBuilder("/").append(UPLOAD_PATH);
        if (!StringUtils.isBlank((String)s)) {
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public String getUploadUrls(String s) {
        StringBuilder stringbuilder = this.getResBaseUrlBuff().append("/").append(UPLOAD_PATH);
        if (!StringUtils.isBlank((String)s)) {
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public String getUploadUrl(String s) {
        StringBuilder stringbuilder = this.getResBaseUrlBuff();
        if (!StringUtils.isBlank((String)s)) {
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public String getTplPath() {
        return TPL_BASE;
    }

    public String getTemplateRel(String s) {
        StringBuilder stringbuilder = this.getTemplateRelBuff();
        if (!StringUtils.isBlank((String)s)) {
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public String getResBaseRel(String s) {
        StringBuilder stringbuilder = this.getResBaseRelBuff();
        if (!StringUtils.isBlank((String)s)) {
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    public Boolean getSsoEnable() {
        String ssoenable = null;
        try {
            ssoenable = this.getAttr().get("ssoEnable");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
        if (StringUtils.isBlank((String)ssoenable)) {
            return false;
        }
        if (ssoenable.equals("true")) {
            return true;
        }
        return false;
    }

    public Map<String, String> getSsoAttr() {
        HashMap<String, String> ssoMap = new HashMap<String, String>();
        Map<String, String> attr = this.getAttr();
        for (String ssoKey : attr.keySet()) {
            if (!ssoKey.startsWith("sso_")) continue;
            ssoMap.put(ssoKey, attr.get(ssoKey));
        }
        return ssoMap;
    }

    public List<String> getSsoAuthenticateUrls() {
        Map<String, String> ssoMap = this.getSsoAttr();
        ArrayList<String> values = new ArrayList<String>();
        for (String key : ssoMap.keySet()) {
            values.add(ssoMap.get(key));
        }
        return values;
    }

    public WebsiteAttr getWebsiteAttr() {
        WebsiteAttr websiteAttr = new WebsiteAttr(this.getAttr());
        return websiteAttr;
    }

    public String getResBaseUrl(String s) {
        StringBuilder stringbuilder = this.getResBaseUrlBuff();
        if (!StringUtils.isBlank((String)s)) {
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
            stringbuilder.append(s);
        }
        return stringbuilder.toString();
    }

    private StringBuilder getUserBaseRelBuff() {
        return new StringBuilder("/").append("WEB-INF").append("/").append(USER_BASE);
    }

    private StringBuilder getResBaseRelBuff() {
        return new StringBuilder("/").append(RES_BASE);
    }

    private StringBuilder getResBaseUrlBuff() {
        return this.getUrlBuff(false).append("/").append(RES_BASE);
    }

    public String getResBaseUrl() {
        return this.getResBaseUrlBuff().toString();
    }

    public StringBuilder getTemplateRelBuff() {
        StringBuilder stringbuilder = this.getUserBaseRelBuff().append("/").append(TEMPLATE_PATH);
        return stringbuilder;
    }

    public String getTemplateRel() {
        return this.getTemplateRel(null);
    }

    public StringBuilder getUrlBuff(boolean flag) {
        StringBuilder stringbuilder = new StringBuilder();
        if (flag || !this.getRelativePath().booleanValue()) {
            stringbuilder = new StringBuilder("http://").append(this.getDomain());
            Integer integer = this.getGlobal().getPort();
            if (integer != null && integer != 80) {
                stringbuilder.append(":").append(integer);
            }
        }
        if (this.getContextPath() != null) {
            stringbuilder.append(this.getContextPath());
        }
        return stringbuilder;
    }

    public String getResBaseRel() {
        return this.getResBaseRelBuff().toString();
    }

    public String getUploadRel() {
        return this.getUploadRel(null);
    }

    public String getUploadUrl() {
        return this.getUploadUrl(null);
    }

    public String getTemplate(String dir, String name) {
        return this.getTemplate(dir, name, null, null);
    }

    public String getTplSys(String s, String s1) {
        return this.getTemplate(s, s1, null, null);
    }

    public String getTplTag(String s, String s1, String s2) {
        return this.getTemplate(s, s1, s2, null);
    }

    public String getContextPath() {
        String s = this.getGlobal().getContextPath();
        return StringUtils.isBlank((String)s) ? "" : s;
    }

    public Integer getPort() {
        return this.getGlobal().getPort();
    }

    public String[] getDomainAliasArray() {
        String s = this.getDomainAlias();
        if (!StringUtils.isBlank((String)s)) {
            return s.split(",");
        }
        return null;
    }
}

