/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.manager.impl;

import com.jspgou.cms.manager.ShopMemberGroupMng;
import com.jspgou.cms.manager.WebserviceMng;
import com.jspgou.common.hibernate3.Updater;
import com.jspgou.core.dao.AdminDao;
import com.jspgou.core.entity.Admin;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.AdminMng;
import com.jspgou.core.manager.RoleMng;
import com.jspgou.core.manager.UserMng;
import java.sql.Timestamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class AdminMngImpl
implements AdminMng {
    @Autowired
    private WebserviceMng webserviceMng;
    @Autowired
    private ShopMemberGroupMng shopmemberGroupMng;
    private UserMng userMng;
    private AdminDao dao;
    protected RoleMng roleMng;

    @Override
    public Admin getByUsername(String username) {
        return this.dao.getByUsername(username);
    }

    @Override
    public Admin getByUserId(Long userId, Long webId) {
        return this.dao.getByUserId(userId, webId);
    }

    @Override
    public Admin register(String username, String password, String email, String ip, Boolean disabled, Website website, Boolean viewonlyAdmin) {
        Admin entity = new Admin();
        Timestamp timestamp = new Timestamp(System.currentTimeMillis());
        User user = this.userMng.register(username, password, email, ip, timestamp);
        entity.setCreateTime(timestamp);
        entity.setUser(user);
        entity.setWebsite(website);
        entity.setDisabled(disabled);
        entity.setViewonlyAdmin(viewonlyAdmin);
        return this.save(entity);
    }

    @Override
    public Admin findById(Long id) {
        return this.dao.findById(id);
    }

    @Override
    public Admin save(Admin bean) {
        bean.init();
        return this.dao.save(bean);
    }

    @Override
    public Admin update(Admin bean) {
        return this.dao.updateByUpdater((Updater<Admin>)new Updater((Object)bean));
    }

    @Override
    public Admin deleteById(Long id) {
        return this.dao.deleteById(id);
    }

    @Override
    public Admin[] deleteByIds(Long[] ids) {
        Admin[] beans = new Admin[ids.length];
        int i = 0;
        while (i < ids.length) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public void updateRole(Admin admin, Integer[] roleIds) {
        admin.getRoles().clear();
        if (roleIds != null) {
            Integer[] integerArray = roleIds;
            int n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer rid = integerArray[n2];
                admin.addToRoles(this.roleMng.findById(rid));
                ++n2;
            }
        }
    }

    @Override
    public void addRole(Admin admin, Integer[] roleIds) {
        if (roleIds != null) {
            Integer[] integerArray = roleIds;
            int n = roleIds.length;
            int n2 = 0;
            while (n2 < n) {
                Integer rid = integerArray[n2];
                admin.addToRoles(this.roleMng.findById(rid));
                ++n2;
            }
        }
    }

    @Autowired
    public void setDao(AdminDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setUserMng(UserMng userMng) {
        this.userMng = userMng;
    }

    @Autowired
    public void setRoleMng(RoleMng roleMng) {
        this.roleMng = roleMng;
    }
}

