/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.manager.impl;

import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.security.UsernameNotFoundException;
import com.jspgou.common.security.userdetails.UserDetails;
import com.jspgou.common.security.userdetails.UserDetailsService;
import com.jspgou.core.dao.MemberDao;
import com.jspgou.core.entity.Member;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.MemberMng;
import com.jspgou.core.manager.UserMng;
import java.sql.Timestamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class MemberMngImpl
implements MemberMng,
UserDetailsService {
    private UserMng userMng;
    private MemberDao dao;

    public UserDetails loadUser(Long id, String s) throws UsernameNotFoundException {
        Member member = this.findById(id);
        if (member == null) {
            throw new UsernameNotFoundException("member id not found '" + id + "'");
        }
        return member;
    }

    @Override
    public Member getByUsername(Long webId, String username) {
        User entity = this.userMng.getByUsername(username);
        if (entity == null) {
            return null;
        }
        return this.getByUserId(webId, entity.getId());
    }

    @Override
    public Member getByUsername(String username) {
        return this.dao.getByUsername(username);
    }

    @Override
    public Member getByUserIdAndActive(String activationCode, Long userId) {
        return this.dao.getByUserIdAndActive(activationCode, userId);
    }

    @Override
    public Member getByUserId(Long webId, Long userId) {
        return this.dao.getByUserId(webId, userId);
    }

    @Override
    public Member register(String username, String password, String email, Boolean active, String activationCode, String ip, Boolean disabled, Website website) {
        Member member = new Member();
        Timestamp createtime = new Timestamp(System.currentTimeMillis());
        User user = this.userMng.register(username, password, email, ip, createtime);
        member.setCreateTime(createtime);
        member.setUser(user);
        member.setWebsite(website);
        member.setDisabled(disabled);
        member.setActive(active);
        member.setActivationCode(activationCode);
        return this.save(member);
    }

    @Override
    public Member join(String username, Website website) {
        User entity = this.userMng.getByUsername(username);
        if (entity == null) {
            throw new IllegalStateException("User not found: " + username);
        }
        return this.join(entity, website);
    }

    @Override
    public Member join(User user, Website website) {
        Member entity = this.getByUserId(website.getId(), user.getId());
        if (entity != null) {
            return entity;
        }
        Member member = new Member();
        member.setUser(user);
        member.setWebsite(website);
        return this.save(member);
    }

    @Override
    public Pagination getPage(int pageNo, int pageSize) {
        return this.dao.getPage(pageNo, pageSize);
    }

    @Override
    public Member findById(Long id) {
        return this.dao.findById(id);
    }

    @Override
    public Member save(Member bean) {
        bean.init();
        return this.dao.save(bean);
    }

    @Override
    public Member update(Member bean) {
        return this.dao.updateByUpdater((Updater<Member>)new Updater((Object)bean));
    }

    @Override
    public Member deleteById(Long id) {
        return this.dao.deleteById(id);
    }

    @Override
    public Member[] deleteByIds(Long[] ids) {
        Member[] beans = new Member[ids.length];
        int i = 0;
        while (i < ids.length) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Autowired
    public void setDao(MemberDao dao) {
        this.dao = dao;
    }

    @Autowired
    public void setUserMng(UserMng userMng) {
        this.userMng = userMng;
    }
}

