/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.manager.impl;

import com.jspgou.common.file.FileWrap;
import com.jspgou.core.manager.TemplateMng;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class TemplateMngImpl
implements TemplateMng {
    private static final Logger log = LoggerFactory.getLogger(TemplateMngImpl.class);
    private FileFilter resFilter = new FileFilter(){

        @Override
        public boolean accept(File paramFile) {
            if (paramFile.isDirectory()) {
                return true;
            }
            String str = FilenameUtils.getExtension((String)paramFile.getName());
            return FileWrap.allowEdit((String)str);
        }
    };

    @Override
    public FileWrap getTplFileWrap(String s, String rootPath) {
        FileWrap filewrap = new FileWrap(new File(s), s);
        filewrap.setFilename(rootPath);
        return filewrap;
    }

    @Override
    public FileWrap getResFileWrap(String s, String rootPath) {
        FileWrap filewrap = new FileWrap(new File(s), s, this.resFilter);
        filewrap.setFilename(rootPath);
        return filewrap;
    }

    @Override
    public int uploadResourceFile(String s, MultipartFile[] files) {
        if (files == null || files.length == 0) {
            return 0;
        }
        File localFile = new File(s);
        int i = 0;
        try {
            MultipartFile[] multipartFileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                MultipartFile file = multipartFileArray[n2];
                String str = file.getOriginalFilename();
                if (!file.isEmpty() && this.allowUpload(FilenameUtils.getExtension((String)str))) {
                    file.transferTo(new File(localFile, str));
                    ++i;
                }
                ++n2;
            }
        }
        catch (IOException e) {
            log.error("upload resource failed", (Throwable)e);
        }
        return i;
    }

    public boolean allowUpload(String s) {
        return true;
    }
}

