/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.manager.impl;

import com.jspgou.common.page.Pagination;
import com.jspgou.common.security.encoder.PwdEncoder;
import com.jspgou.core.dao.UserDao;
import com.jspgou.core.entity.EmailSender;
import com.jspgou.core.entity.MessageTemplate;
import com.jspgou.core.entity.User;
import com.jspgou.core.entity.WebsiteExt;
import com.jspgou.core.manager.UserMng;
import com.jspgou.core.manager.WebsiteExtMng;
import java.io.UnsupportedEncodingException;
import java.sql.Timestamp;
import java.util.Date;
import java.util.UUID;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.mail.MailException;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.mail.javamail.MimeMessagePreparator;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class UserMngImpl
implements UserMng {
    @Autowired
    private WebsiteExtMng websiteExtMng;
    private PwdEncoder pwdEncoder;
    private UserDao dao;

    @Override
    public User passwordForgotten(Long id, String base, EmailSender email, MessageTemplate tpl) {
        User entity = this.findById(id);
        String uuid = StringUtils.remove((String)UUID.randomUUID().toString(), (char)'-');
        entity.setResetKey(uuid);
        String resetPwd = RandomStringUtils.randomNumeric((int)10);
        entity.setResetPwd(resetPwd);
        this.senderEmail(entity.getId(), entity.getUsername(), base, entity.getEmail(), entity.getResetKey(), entity.getResetPwd(), email, tpl);
        return entity;
    }

    @Override
    public void senderActiveEmail(final String userName, final String base, final String receiverEmail, final String activationCode, final EmailSender email, final MessageTemplate tpl) throws MailException {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(email.getHost());
        sender.setUsername(email.getUsername());
        sender.setPassword(email.getPassword());
        sender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage mimemessage) throws MessagingException, UnsupportedEncodingException {
                MimeMessageHelper msg = new MimeMessageHelper(mimemessage, false, email.getEncoding());
                msg.setSubject(tpl.getActiveTitle());
                msg.setTo(receiverEmail);
                msg.setFrom(email.getUsername(), email.getPersonal());
                String text = tpl.getActiveTxt();
                text = StringUtils.replace((String)text, (String)"${userName}", (String)userName);
                text = StringUtils.replace((String)text, (String)"${activationCode}", (String)activationCode);
                text = StringUtils.replace((String)text, (String)"${base}", (String)base);
                msg.setText(text, true);
            }
        });
    }

    @Override
    public void senderEmail(final Long uid, final String username, final String base, final String to, final String resetKey, final String resetPwd, final EmailSender email, final MessageTemplate tpl) throws MailException {
        JavaMailSenderImpl sender = new JavaMailSenderImpl();
        sender.setHost(email.getHost());
        sender.setUsername(email.getUsername());
        sender.setPassword(email.getPassword());
        sender.send(new MimeMessagePreparator(){

            public void prepare(MimeMessage mimemessage) throws MessagingException, UnsupportedEncodingException {
                MimeMessageHelper msg = new MimeMessageHelper(mimemessage, false, email.getEncoding());
                msg.setSubject(tpl.getSubject());
                msg.setTo(to);
                msg.setFrom(email.getUsername(), email.getPersonal());
                String text = tpl.getText();
                text = StringUtils.replace((String)text, (String)"${uid}", (String)String.valueOf(uid));
                text = StringUtils.replace((String)text, (String)"${username}", (String)username);
                text = StringUtils.replace((String)text, (String)"${activationCode}", (String)resetKey);
                text = StringUtils.replace((String)text, (String)"${resetPwd}", (String)resetPwd);
                text = StringUtils.replace((String)text, (String)"${base}", (String)base);
                msg.setText(text, true);
            }
        });
    }

    @Override
    public User resetPassword(Long userId) {
        User entity = this.findById(userId);
        entity.setPassword(this.pwdEncoder.encodePassword(entity.getResetPwd()));
        entity.setResetKey(null);
        entity.setResetPwd(null);
        return entity;
    }

    @Override
    public boolean isPasswordValid(Long id, String password) {
        User entity = this.findById(id);
        return this.pwdEncoder.isPasswordValid(entity.getPassword(), password);
    }

    @Override
    public boolean usernameExist(String username) {
        return this.getByUsername(username) != null;
    }

    @Override
    public boolean emailExist(String email) {
        return this.getByEmail(email) != null;
    }

    @Override
    public User getByUsername(String username) {
        return this.dao.getByUsername(username);
    }

    @Override
    public User getByEmail(String email) {
        return this.dao.getByEmail(email);
    }

    @Override
    public void updateLoginInfo(Long userId, String ip) {
        User entity = this.findById(userId);
        entity.setLoginCount(entity.getLoginCount() + 1L);
        String s1 = entity.getCurrentLoginIp();
        Timestamp time = new Timestamp(System.currentTimeMillis());
        if (StringUtils.isBlank((String)s1)) {
            entity.setLastLoginIp(ip);
            entity.setLastLoginTime(time);
        } else {
            entity.setLastLoginIp(entity.getCurrentLoginIp());
            entity.setLastLoginTime(entity.getCurrentLoginTime());
        }
        entity.setCurrentLoginIp(ip);
        entity.setCurrentLoginTime(time);
    }

    @Override
    public void updateLoginSuccess(Long userId, String ip) {
        User user = this.findById(userId);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        user.setLoginCount(user.getLoginCount() + 1L);
        user.setLastLoginIp(ip);
        user.setLastLoginTime(now);
        user.setErrCount(0);
        user.setErrTime(null);
        user.setErrIp(null);
    }

    @Override
    public void updateLoginInfo(Long userId, String ip, Date loginTime, String sessionId) {
        User user = this.findById(userId);
        if (user != null) {
            user.setLoginCount(user.getLoginCount() + 1L);
            if (StringUtils.isNotBlank((String)ip)) {
                user.setLastLoginIp(ip);
            }
            if (loginTime != null) {
                user.setLastLoginTime(loginTime);
            }
            user.setSessionId(sessionId);
        }
    }

    @Override
    public void updateLoginError(Long userId, String ip) {
        User user = this.findById(userId);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        WebsiteExt.ConfigLogin configLogin = this.websiteExtMng.getConfigLogin();
        int errorInterval = configLogin.getErrorInterval();
        Date errorTime = user.getErrTime();
        user.setErrIp(ip);
        if (errorTime == null || errorTime.getTime() + (long)(errorInterval * 60 * 1000) < ((Date)now).getTime()) {
            user.setErrTime(now);
            user.setErrCount(1);
        } else {
            user.setErrCount(user.getErrCount() + 1);
        }
    }

    @Override
    public User register(String username, String password, String email, String ip, Date date) {
        User entity = new User();
        entity.setUsername(username);
        entity.setPassword(password);
        entity.setEmail(email);
        entity.setRegisterIp(ip);
        entity.setErrCount(0);
        if (date != null) {
            entity.setCreateTime(date);
        }
        return this.save(entity);
    }

    @Override
    public User register(String username, String password, String email, String ip) {
        return this.register(username, password, email, ip, new Date());
    }

    @Override
    public Pagination getPage(int pageNo, int pageSize) {
        return this.dao.getPage(pageNo, pageSize);
    }

    @Override
    public User findById(Long id) {
        return this.dao.findById(id);
    }

    @Override
    public User save(User bean) {
        String password = this.pwdEncoder.encodePassword(bean.getPassword());
        bean.setPassword(password);
        bean.init();
        return this.dao.save(bean);
    }

    @Override
    public User updateUser(Long id, String password, String email) {
        User entity = this.findById(id);
        if (!StringUtils.isBlank((String)password)) {
            entity.setPassword(this.pwdEncoder.encodePassword(password));
        }
        if (!StringUtils.isBlank((String)email)) {
            entity.setEmail(email);
        }
        return entity;
    }

    @Override
    public User deleteById(Long id) {
        return this.dao.deleteById(id);
    }

    @Override
    public User[] deleteByIds(Long[] ids) {
        User[] beans = new User[ids.length];
        int i = 0;
        while (i < ids.length) {
            beans[i] = this.deleteById(ids[i]);
            ++i;
        }
        return beans;
    }

    @Override
    public Integer errorRemaining(String username) {
        if (StringUtils.isBlank((String)username)) {
            return null;
        }
        User user = this.getByUsername(username);
        if (user == null) {
            return null;
        }
        Long now = System.currentTimeMillis();
        WebsiteExt.ConfigLogin configLogin = this.websiteExtMng.getConfigLogin();
        int maxErrorTimes = configLogin.getErrorTimes();
        int maxErrorInterval = configLogin.getErrorInterval() * 60 * 1000;
        Integer errCount = user.getErrCount();
        Date errTime = user.getErrTime();
        if (errCount <= 0 || errTime == null || errTime.getTime() + (long)maxErrorInterval < now) {
            return maxErrorTimes;
        }
        return maxErrorTimes - errCount;
    }

    @Autowired
    public void setPwdEncoder(PwdEncoder pwdEncoder) {
        this.pwdEncoder = pwdEncoder;
    }

    @Autowired
    public void setDao(UserDao dao) {
        this.dao = dao;
    }
}

