/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.manager.impl;

import com.jspgou.common.hibernate3.Updater;
import com.jspgou.common.page.Pagination;
import com.jspgou.core.cache.CoreCacheSvc;
import com.jspgou.core.cache.DomainCacheSvc;
import com.jspgou.core.dao.WebsiteDao;
import com.jspgou.core.entity.Website;
import com.jspgou.core.manager.WebsiteMng;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional
public class WebsiteMngImpl
implements WebsiteMng {
    private CoreCacheSvc coreCacheSvc;
    private DomainCacheSvc domainCacheSvc;
    private WebsiteDao dao;

    @Override
    @Transactional(readOnly=true)
    public Website getWebsite(String s) {
        Website website;
        int i;
        Integer count = this.coreCacheSvc.getWebsiteCount();
        if (count == null) {
            i = this.dao.countWebsite();
            this.coreCacheSvc.putWebsiteCount(new Integer(i));
        } else {
            i = count;
        }
        if (i == 1) {
            Long id = this.coreCacheSvc.getWebsiteId();
            if (id != null) {
                website = this.findById(id);
            } else {
                website = this.dao.getUniqueWebsite();
                this.coreCacheSvc.putWebsiteId(website.getId());
            }
        } else if (i > 1) {
            Long id = this.domainCacheSvc.get(s);
            if (id != null) {
                website = this.findById(id);
            } else {
                website = this.dao.findByDomain(s);
                if (website != null) {
                    this.domainCacheSvc.put(website.getDomain(), website.getDomainAliasArray(), website.getId());
                }
            }
        } else {
            throw new IllegalStateException("no website data in database, please init database!");
        }
        return website;
    }

    @Override
    public Pagination getAllPage(int pageNo, int pageSize) {
        return this.dao.getAllPage(pageNo, pageSize);
    }

    @Override
    public List<Website> getAllList() {
        return this.dao.getAllList();
    }

    @Override
    public Website findById(Long id) {
        return this.dao.findById(id);
    }

    @Override
    public Website save(Website bean) {
        Website entity = this.dao.save(bean);
        this.fireOnSave(entity);
        return entity;
    }

    @Override
    public Website update(Website bean) {
        Website entity = this.findById(bean.getId());
        String domain = entity.getDomain();
        String[] as = entity.getDomainAliasArray();
        entity = this.dao.updateByUpdater((Updater<Website>)new Updater((Object)bean));
        this.fireOnUpdate(domain, as, entity);
        return entity;
    }

    @Override
    public Website deleteById(Long id) {
        Website entity = this.dao.deleteById(id);
        this.fireOnDelete(entity);
        return entity;
    }

    @Override
    public Website[] deleteByIds(Long[] ids) {
        Website[] beans = new Website[ids.length];
        int i = 0;
        while (i < ids.length) {
            beans[i] = this.dao.deleteById(ids[i]);
            ++i;
        }
        this.fireOnDeleteBatch(beans);
        return beans;
    }

    private void resetWebsiteCache() {
        List<Website> list = this.dao.getAllList();
        int i = list.size();
        if (i == 0) {
            throw new IllegalStateException("no website data in database, please init database!");
        }
        this.coreCacheSvc.putWebsiteCount(i);
        if (i == 1) {
            Website entity = list.get(0);
            this.coreCacheSvc.putWebsiteId(entity.getId());
            this.domainCacheSvc.removeAll();
            this.domainCacheSvc.put(entity.getDomain(), entity.getDomainAliasArray(), entity.getId());
        } else {
            this.coreCacheSvc.removeWebsiteId();
            this.domainCacheSvc.removeAll();
            for (Website localWebsite : list) {
                this.domainCacheSvc.put(localWebsite.getDomain(), localWebsite.getDomainAliasArray(), localWebsite.getId());
            }
        }
    }

    private void onDomainUpdated(String s, String[] as, Website website) {
        String domain = website.getDomain();
        Object[] as1 = website.getDomainAliasArray();
        if (!domain.equals(s) || !Arrays.equals(as1, as)) {
            this.domainCacheSvc.remove(s, as);
            this.domainCacheSvc.put(domain, (String[])as1, website.getId());
        }
    }

    private void onDomainDelete(Website bean) {
        this.resetWebsiteCache();
    }

    private void onDomainDeleteBatch(Website[] beans) {
        this.resetWebsiteCache();
    }

    private void onDomainSave(Website bean) {
        this.resetWebsiteCache();
    }

    private void fireOnUpdate(String s, String[] as, Website bean) {
        this.onDomainUpdated(s, as, bean);
    }

    private void fireOnDelete(Website bean) {
        this.onDomainDelete(bean);
    }

    private void fireOnDeleteBatch(Website[] beans) {
        this.onDomainDeleteBatch(beans);
    }

    private void fireOnSave(Website bean) {
        this.onDomainSave(bean);
    }

    @Autowired
    public void setCoreCacheSvc(CoreCacheSvc coreCacheSvc) {
        this.coreCacheSvc = coreCacheSvc;
    }

    @Autowired
    public void setDomainCacheSvc(DomainCacheSvc domainCacheSvc) {
        this.domainCacheSvc = domainCacheSvc;
    }

    @Override
    @Transactional(readOnly=true)
    public Website get() {
        Website entity = this.dao.findById(1L);
        return entity;
    }

    @Override
    public void updateSsoAttr(Map<String, String> ssoAttr) {
        Map<String, String> oldAttr = this.get().getAttr();
        Iterator<String> keys = oldAttr.keySet().iterator();
        String key = null;
        while (keys.hasNext()) {
            key = keys.next();
            if (!key.startsWith("sso_")) continue;
            keys.remove();
        }
        oldAttr.putAll(ssoAttr);
    }

    @Autowired
    public void setDao(WebsiteDao dao) {
        this.dao = dao;
    }
}

