/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.security;

import com.jspgou.common.security.DisabledException;
import com.jspgou.common.security.UserNotAcitveException;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.session.SessionProvider;
import com.jspgou.core.entity.Admin;
import com.jspgou.core.entity.Member;
import com.jspgou.core.entity.User;
import com.jspgou.core.manager.AdminMng;
import com.jspgou.core.manager.LogMng;
import com.jspgou.core.manager.MemberMng;
import com.jspgou.core.manager.UserMng;
import com.octo.captcha.service.image.ImageCaptchaService;
import java.sql.Timestamp;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.UnknownAccountException;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.FormAuthenticationFilter;
import org.apache.shiro.web.util.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class CmsAuthenticationFilter
extends FormAuthenticationFilter {
    private Logger logger = LoggerFactory.getLogger(CmsAuthenticationFilter.class);
    public static final String COOKIE_ERROR_REMAINING = "_error_remaining";
    public static final String CAPTCHA_PARAM = "captcha";
    public static final String RETURN_URL = "returnUrl";
    public static final String FAILURE_URL = "failureUrl";
    @Autowired
    private MemberMng memberMng;
    @Autowired
    private AdminMng adminMng;
    @Autowired
    private UserMng userMng;
    @Autowired
    private SessionProvider session;
    @Autowired
    private ImageCaptchaService imageCaptchaService;
    @Autowired
    private LogMng cmsLogMng;
    private String adminPrefix;
    private String adminIndex;
    private String adminLogin;

    protected boolean executeLogin(ServletRequest request, ServletResponse response) throws UnknownAccountException, Exception {
        AuthenticationToken token = this.createToken(request, response);
        if (token == null) {
            String msg = "create AuthenticationToken error";
            throw new IllegalStateException(msg);
        }
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String username = (String)token.getPrincipal();
        boolean adminLogin = false;
        if (req.getRequestURI().startsWith(String.valueOf(req.getContextPath()) + this.getAdminPrefix())) {
            adminLogin = true;
        }
        String failureUrl = req.getParameter(FAILURE_URL);
        Admin admin = this.adminMng.getByUsername(username);
        Member member = this.memberMng.getByUsername(username);
        if (admin != null && this.isDisabled(admin)) {
            return this.onLoginFailure(token, failureUrl, adminLogin, (AuthenticationException)new DisabledException(), request, response);
        }
        if (member != null && !this.isActive(member)) {
            return this.onLoginFailure(token, failureUrl, adminLogin, (AuthenticationException)new UserNotAcitveException(), request, response);
        }
        try {
            Subject subject = this.getSubject(request, response);
            subject.login(token);
            return this.onLoginSuccess(token, adminLogin, subject, request, response);
        }
        catch (AuthenticationException e) {
            return this.onLoginFailure(token, failureUrl, adminLogin, e, request, response);
        }
    }

    public boolean onPreHandle(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        boolean isAllowed = this.isAccessAllowed(request, response, mappedValue);
        if (isAllowed && this.isLoginRequest(request, response)) {
            try {
                this.issueSuccessRedirect(request, response);
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
            return false;
        }
        return isAllowed || this.onAccessDenied(request, response, mappedValue);
    }

    protected void issueSuccessRedirect(ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String successUrl = req.getParameter(RETURN_URL);
        if (StringUtils.isBlank((String)successUrl)) {
            if (req.getRequestURI().startsWith(String.valueOf(req.getContextPath()) + this.getAdminPrefix())) {
                successUrl = this.getAdminIndex();
                WebUtils.getAndClearSavedRequest((ServletRequest)request);
                WebUtils.issueRedirect((ServletRequest)request, (ServletResponse)response, (String)successUrl, null, (boolean)true);
                return;
            }
            successUrl = this.getSuccessUrl();
        }
        WebUtils.redirectToSavedRequest((ServletRequest)req, (ServletResponse)res, (String)successUrl);
    }

    protected boolean isLoginRequest(ServletRequest req, ServletResponse resp) {
        return this.pathsMatch(this.getLoginUrl(), req) || this.pathsMatch(this.getAdminLogin(), req);
    }

    private boolean onLoginSuccess(AuthenticationToken token, boolean adminLogin, Subject subject, ServletRequest request, ServletResponse response) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse res = (HttpServletResponse)response;
        String username = (String)subject.getPrincipal();
        User user = this.userMng.getByUsername(username);
        String ip = RequestUtils.getIpAddr((HttpServletRequest)req);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String userSessionId = this.session.getSessionId((HttpServletRequest)request, (HttpServletResponse)response);
        this.userMng.updateLoginInfo(user.getId(), ip, now, userSessionId);
        if (adminLogin) {
            this.cmsLogMng.loginSuccess(req, user);
        }
        this.userMng.updateLoginSuccess(user.getId(), ip);
        this.loginCookie(username, req, res);
        return super.onLoginSuccess(token, subject, request, response);
    }

    private boolean onLoginFailure(AuthenticationToken token, String failureUrl, boolean adminLogin, AuthenticationException e, ServletRequest request, ServletResponse response) {
        String username = (String)token.getPrincipal();
        HttpServletRequest req = (HttpServletRequest)request;
        String ip = RequestUtils.getIpAddr((HttpServletRequest)req);
        User user = this.userMng.getByUsername(username);
        if (user != null) {
            this.userMng.updateLoginError(user.getId(), ip);
        }
        if (adminLogin) {
            this.cmsLogMng.loginFailure(req, "username=" + username);
        }
        return this.onLoginFailure(failureUrl, token, e, request, response);
    }

    private boolean onLoginFailure(String failureUrl, AuthenticationToken token, AuthenticationException e, ServletRequest request, ServletResponse response) {
        String className = ((Object)((Object)e)).getClass().getName();
        request.setAttribute(this.getFailureKeyAttribute(), (Object)className);
        if (failureUrl != null || StringUtils.isNotBlank((String)failureUrl)) {
            try {
                request.getRequestDispatcher(failureUrl).forward(request, response);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private void loginCookie(String username, HttpServletRequest request, HttpServletResponse response) {
        String domain = request.getServerName();
        if (domain.indexOf(".") > -1) {
            domain = domain.substring(domain.indexOf(".") + 1);
        }
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"JSESSIONID", (String)this.session.getSessionId(request, response), null, (String)domain, (String)"/");
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"username", (String)username, null, (String)domain, (String)"/");
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"sso_logout", null, (Integer)0, (String)domain, (String)"/");
    }

    private boolean isCaptchaRequired(String username, HttpServletRequest request, HttpServletResponse response) {
        Integer errorRemaining = this.userMng.errorRemaining(username);
        String captcha = RequestUtils.getQueryParam((HttpServletRequest)request, (String)CAPTCHA_PARAM);
        return !StringUtils.isBlank((String)captcha) || errorRemaining != null && errorRemaining < 0;
    }

    private boolean isDisabled(Admin admin) {
        return admin.getDisabled() != false;
    }

    private boolean isActive(Member member) {
        Member un = this.memberMng.findById(member.getId());
        if (un != null) {
            return member.getActive() != false;
        }
        return false;
    }

    public String getAdminPrefix() {
        return this.adminPrefix;
    }

    public void setAdminPrefix(String adminPrefix) {
        this.adminPrefix = adminPrefix;
    }

    public String getAdminIndex() {
        return this.adminIndex;
    }

    public void setAdminIndex(String adminIndex) {
        this.adminIndex = adminIndex;
    }

    public String getAdminLogin() {
        return this.adminLogin;
    }

    public void setAdminLogin(String adminLogin) {
        this.adminLogin = adminLogin;
    }
}

