/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.security;

import com.jspgou.core.entity.User;
import com.jspgou.core.manager.UserMng;
import java.util.HashSet;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authc.UsernamePasswordToken;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.springframework.beans.factory.annotation.Autowired;

public class CmsAuthorizingRealm
extends AuthorizingRealm {
    protected UserMng cmsUserMng;

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken authcToken) throws AuthenticationException {
        UsernamePasswordToken token = (UsernamePasswordToken)authcToken;
        User user = this.cmsUserMng.getByUsername(token.getUsername());
        if (user != null) {
            return new SimpleAuthenticationInfo((Object)user.getUsername(), (Object)user.getPassword(), this.getName());
        }
        return null;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        SimpleAuthorizationInfo auth = new SimpleAuthorizationInfo();
        HashSet<String> allPerms = new HashSet<String>();
        allPerms.clear();
        allPerms.add("*");
        auth.setStringPermissions(allPerms);
        return auth;
    }

    public void removeUserAuthorizationInfoCache(String username) {
        SimplePrincipalCollection pc = new SimplePrincipalCollection();
        pc.add((Object)username, super.getName());
        super.clearCachedAuthorizationInfo((PrincipalCollection)pc);
    }

    @Autowired
    public void setUserMng(UserMng cmsUserMng) {
        this.cmsUserMng = cmsUserMng;
    }
}

