/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.security;

import com.jspgou.common.web.CookieUtils;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.subject.Subject;
import org.apache.shiro.web.filter.authc.LogoutFilter;

public class CmsLogoutFilter
extends LogoutFilter {
    public static final String RETURN_URL = "returnUrl";
    public static final String USER_LOG_OUT_FLAG = "logout";
    private String adminPrefix;
    private String adminLogin;

    protected String getRedirectUrl(ServletRequest req, ServletResponse resp, Subject subject) {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)resp;
        String redirectUrl = request.getParameter(RETURN_URL);
        String domain = request.getServerName();
        if (domain.indexOf(".") > -1) {
            domain = domain.substring(domain.indexOf(".") + 1);
        }
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"JSESSIONID", null, (Integer)0, (String)domain, (String)"/");
        CookieUtils.addCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)"sso_logout", (String)"true", null, (String)domain, (String)"/");
        if (StringUtils.isBlank((String)redirectUrl)) {
            redirectUrl = request.getRequestURI().startsWith(String.valueOf(request.getContextPath()) + this.getAdminPrefix()) ? this.getAdminLogin() : this.getRedirectUrl();
        }
        return redirectUrl;
    }

    public String getAdminPrefix() {
        return this.adminPrefix;
    }

    public void setAdminPrefix(String adminPrefix) {
        this.adminPrefix = adminPrefix;
    }

    public String getAdminLogin() {
        return this.adminLogin;
    }

    public void setAdminLogin(String adminLogin) {
        this.adminLogin = adminLogin;
    }
}

