/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.core.web.front;

import com.jspgou.common.web.RequestUtils;
import com.jspgou.common.web.springmvc.MessageResolver;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.WebErrors;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.springframework.ui.ModelMap;

public abstract class FrontHelper {
    public static final String TPL_PAGE_NOT_FOUND = "tpl.pageNotFound";
    public static final String TPL_SUCCESS_PAGE = "tpl.successPage";
    public static final String TPL_ERROR_PAGE = "tpl.errorPage";
    public static final String TPL_MESSAGE_PAGE = "tpl.messagePage";

    public static String pageNotFound(Website website, ModelMap modelmap, HttpServletRequest request) {
        FrontHelper.setCommonData(request, modelmap, website, 1);
        return website.getTplSys("common", MessageResolver.getMessage((HttpServletRequest)request, (String)TPL_PAGE_NOT_FOUND, (Object[])new Object[0]));
    }

    public static String showSuccess(String s, String s1, Website website, ModelMap modelmap, HttpServletRequest request) {
        FrontHelper.setCommonData(request, modelmap, website, 1);
        modelmap.addAttribute("message", (Object)s);
        if (!StringUtils.isBlank((String)s1)) {
            modelmap.addAttribute("backUrl", (Object)s1);
        }
        return website.getTplSys("common", MessageResolver.getMessage((HttpServletRequest)request, (String)TPL_SUCCESS_PAGE, (Object[])new Object[0]));
    }

    public static String showError(WebErrors weberrors, Website website, ModelMap modelmap, HttpServletRequest request) {
        FrontHelper.setCommonData(request, modelmap, website, 1);
        weberrors.toModel((Map)modelmap);
        return website.getTplSys("common", MessageResolver.getMessage((HttpServletRequest)request, (String)TPL_ERROR_PAGE, (Object[])new Object[0]));
    }

    public static String showMessage(String s, Website website, ModelMap modelmap, HttpServletRequest request) {
        FrontHelper.setCommonData(request, modelmap, website, 1);
        modelmap.addAttribute("message", (Object)s);
        return website.getTplSys("common", MessageResolver.getMessage((HttpServletRequest)request, (String)TPL_MESSAGE_PAGE, (Object[])new Object[0]));
    }

    public static void setDynamicPageData(HttpServletRequest request, ModelMap model, Website web, String location, String urlPrefix, String urlSuffix, int pageNo) {
        model.addAttribute("urlPrefix", (Object)urlPrefix);
        model.addAttribute("urlSuffix", (Object)urlSuffix);
        FrontHelper.setCommonData(request, model, web, pageNo, location);
    }

    private static void setCommonData(HttpServletRequest request, ModelMap modelmap, Website website, int i, String s) {
        String s2;
        modelmap.addAttribute("location", (Object)s);
        modelmap.addAttribute("web", (Object)website);
        String s1 = (String)request.getAttribute("_base_domain_key");
        if (s1 != null) {
            modelmap.addAttribute("baseDomain", (Object)s1);
        }
        if ((s2 = (String)request.getAttribute("_login_url")) != null) {
            modelmap.addAttribute("loginUrl", (Object)FrontHelper.getLoginUrl(s2, request.getContextPath(), s));
        }
        modelmap.addAttribute("root", (Object)website.getResBaseUrl());
        modelmap.addAttribute("pageNo", (Object)i);
        modelmap.addAttribute("_start_time", request.getAttribute("_start_time"));
    }

    public static void setCommonData(HttpServletRequest request, ModelMap modelmap, Website website, int i) {
        StringBuffer originalURL = request.getRequestURL();
        Map parameters = request.getParameterMap();
        if (parameters != null && parameters.size() > 0) {
            originalURL.append("?");
            for (String key : parameters.keySet()) {
                String[] values = (String[])parameters.get(key);
                int j = 0;
                while (j < values.length) {
                    originalURL.append(key).append("=").append(values[j]).append("&");
                    ++j;
                }
            }
        }
        FrontHelper.setCommonData(request, modelmap, website, i, originalURL.toString());
    }

    public static void setCommon(HttpServletRequest request, ModelMap modelmap, Website website) {
        String location = RequestUtils.getLocation((HttpServletRequest)request);
        FrontHelper.setCommon(request, modelmap, website, location);
    }

    private static void setCommon(HttpServletRequest request, ModelMap modelmap, Website website, String location) {
        String loginUrl;
        modelmap.addAttribute("location", (Object)location);
        modelmap.addAttribute("web", (Object)website);
        String baseDomain = (String)request.getAttribute("_base_domain_key");
        if (baseDomain != null) {
            modelmap.addAttribute("baseDomain", (Object)baseDomain);
        }
        if ((loginUrl = (String)request.getAttribute("_login_url")) != null) {
            modelmap.addAttribute("loginUrl", (Object)FrontHelper.getLoginUrl(loginUrl, request.getContextPath(), location));
        }
        modelmap.addAttribute("root", (Object)website.getResBaseUrl());
        modelmap.addAttribute("_start_time", request.getAttribute("_start_time"));
    }

    public static String getLoginUrl(String s, String s1, String s2) {
        StringBuilder stringbuilder = new StringBuilder();
        if (!s.startsWith("http")) {
            stringbuilder.append(s1);
            if (!s.startsWith("/")) {
                stringbuilder.append("/");
            }
        }
        stringbuilder.append(s).append("?returnUrl=").append(s2);
        return stringbuilder.toString();
    }

    public static String getLoginUrl(HttpServletRequest request) {
        StringBuffer originalURL = request.getRequestURL();
        Map parameters = request.getParameterMap();
        if (parameters != null && parameters.size() > 0) {
            originalURL.append("?");
            for (String key : parameters.keySet()) {
                String[] values = (String[])parameters.get(key);
                int i = 0;
                while (i < values.length) {
                    originalURL.append(key).append("=").append(values[i]).append("&");
                    ++i;
                }
            }
        }
        return FrontHelper.getLoginUrl((String)request.getAttribute("_login_url"), "", originalURL.toString());
    }
}

