/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms;

import com.jspgou.common.httpClient.HttpProtocolHandler;
import com.jspgou.common.httpClient.HttpRequest;
import com.jspgou.common.httpClient.HttpResponse;
import com.jspgou.common.httpClient.HttpResultType;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.httpclient.NameValuePair;

public class Alipay {
    private static final String ALIPAY_GATEWAY_NEW = "https://mapi.alipay.com/gateway.do?";
    private static final String HTTPS_VERIFY_URL = "https://mapi.alipay.com/gateway.do?service=notify_verify&";

    public static String buildRequestMysign(Map<String, String> sPara, String key) {
        String prestr = Alipay.createLinkString(sPara);
        String mysign = "";
        mysign = Alipay.sign(prestr, key, "utf-8");
        return mysign;
    }

    private static Map<String, String> buildRequestPara(Map<String, String> sParaTemp, String key) {
        Map<String, String> sPara = Alipay.paraFilter(sParaTemp);
        String mysign = Alipay.buildRequestMysign(sPara, key);
        sPara.put("sign", mysign);
        sPara.put("sign_type", "MD5");
        return sPara;
    }

    public static String buildRequest(Map<String, String> sParaTemp, String key, String strMethod, String strButtonName) {
        Map<String, String> sPara = Alipay.buildRequestPara(sParaTemp, key);
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sbHtml = new StringBuffer();
        sbHtml.append("<form id=\"alipaysubmit\" name=\"alipaysubmit\" action=\"https://mapi.alipay.com/gateway.do?_input_charset=utf-8\" method=\"" + strMethod + "\">");
        int i = 0;
        while (i < keys.size()) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sbHtml.append("<input type=\"hidden\" name=\"" + name + "\" value=\"" + value + "\"/>");
            ++i;
        }
        sbHtml.append("<input type=\"submit\" value=\"" + strButtonName + "\" style=\"display:none;\"></form>");
        sbHtml.append("<script>document.forms['alipaysubmit'].submit();</script>");
        return sbHtml.toString();
    }

    public static String buildRequest(String strParaFileName, String strFilePath, Map<String, String> sParaTemp, String key) throws Exception {
        Map<String, String> sPara = Alipay.buildRequestPara(sParaTemp, key);
        HttpProtocolHandler httpProtocolHandler = HttpProtocolHandler.getInstance();
        HttpRequest request = new HttpRequest(HttpResultType.BYTES);
        request.setCharset("utf-8");
        request.setParameters(Alipay.generatNameValuePair(sPara));
        request.setUrl("https://mapi.alipay.com/gateway.do?_input_charset=utf-8");
        HttpResponse response = httpProtocolHandler.execute(request, strParaFileName, strFilePath);
        if (response == null) {
            return null;
        }
        String strResult = response.getStringResult();
        return strResult;
    }

    private static NameValuePair[] generatNameValuePair(Map<String, String> properties) {
        NameValuePair[] nameValuePair = new NameValuePair[properties.size()];
        int i = 0;
        for (Map.Entry<String, String> entry : properties.entrySet()) {
            nameValuePair[i++] = new NameValuePair(entry.getKey(), entry.getValue());
        }
        return nameValuePair;
    }

    public static boolean verify(Map<String, String> params, String partner, String key) {
        boolean isSign;
        String responseTxt = "true";
        if (params.get("notify_id") != null) {
            String notify_id = params.get("notify_id");
            responseTxt = Alipay.verifyResponse(notify_id, partner);
        }
        String sign = "";
        if (params.get("sign") != null) {
            sign = params.get("sign");
        }
        return (isSign = Alipay.getSignVeryfy(params, sign, key)) && responseTxt.equals("true");
    }

    private static boolean getSignVeryfy(Map<String, String> Params, String sign, String key) {
        Map<String, String> sParaNew = Alipay.paraFilter(Params);
        String preSignStr = Alipay.createLinkString(sParaNew);
        boolean isSign = false;
        isSign = Alipay.verify(preSignStr, sign, key, "utf-8");
        return isSign;
    }

    private static String verifyResponse(String notify_id, String partner) {
        String veryfy_url = "https://mapi.alipay.com/gateway.do?service=notify_verify&partner=" + partner + "&notify_id=" + notify_id;
        return Alipay.checkUrl(veryfy_url);
    }

    private static String checkUrl(String urlvalue) {
        String inputLine = "";
        try {
            URL url = new URL(urlvalue);
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            inputLine = in.readLine().toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            inputLine = "";
        }
        return inputLine;
    }

    public static Map<String, String> paraFilter(Map<String, String> sArray) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (sArray == null || sArray.size() <= 0) {
            return result;
        }
        for (String key : sArray.keySet()) {
            String value = sArray.get(key);
            if (value == null || value.equals("") || key.equalsIgnoreCase("sign") || key.equalsIgnoreCase("sign_type")) continue;
            result.put(key, value);
        }
        return result;
    }

    public static String createLinkString(Map<String, String> params) {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        String prestr = "";
        int i = 0;
        while (i < keys.size()) {
            String key = (String)keys.get(i);
            String value = params.get(key);
            prestr = i == keys.size() - 1 ? String.valueOf(prestr) + key + "=" + value : String.valueOf(prestr) + key + "=" + value + "&";
            ++i;
        }
        return prestr;
    }

    public static String sign(String text, String key, String input_charset) {
        text = String.valueOf(text) + key;
        return DigestUtils.md5Hex((byte[])Alipay.getContentBytes(text, input_charset));
    }

    public static boolean verify(String text, String sign, String key, String input_charset) {
        String mysign = DigestUtils.md5Hex((byte[])Alipay.getContentBytes(text = String.valueOf(text) + key, input_charset));
        return mysign.equals(sign);
    }

    private static byte[] getContentBytes(String content, String charset) {
        if (charset == null || "".equals(charset)) {
            return content.getBytes();
        }
        try {
            return content.getBytes(charset);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("MD5\u7b7e\u540d\u8fc7\u7a0b\u4e2d\u51fa\u73b0\u9519\u8bef,\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u4e0d\u5bf9,\u60a8\u76ee\u524d\u6307\u5b9a\u7684\u7f16\u7801\u96c6\u662f:" + charset);
        }
    }
}

