/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Address;
import com.jspgou.cms.manager.AddressMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.entity.Website;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AddressAct {
    private static final Logger log = LoggerFactory.getLogger(AddressAct.class);
    @Autowired
    private AddressMng manager;
    @Autowired
    private ProductMng productMng;

    @RequestMapping(value={"/address/v_list.do"})
    public String list(Long parentId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPageByParentId(parentId, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("parentId", (Object)parentId);
        return "address/list";
    }

    @RequestMapping(value={"/address/v_add.do"})
    public String add(Long parentId, ModelMap model) {
        model.addAttribute("parentId", (Object)parentId);
        return "address/add";
    }

    @RequestMapping(value={"/address/v_edit.do"})
    public String edit(Long id, Long parentId, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("address", (Object)this.manager.findById(id));
        model.addAttribute("parentId", (Object)parentId);
        return "address/edit";
    }

    @RequestMapping(value={"/address/o_save.do"})
    public String save(Long parentId, Address bean, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        if (parentId != null) {
            Address address = this.manager.findById(parentId);
            bean.setParent(address);
        }
        bean = this.manager.save(bean);
        log.info("save Address id={}", (Object)bean.getId());
        model.addAttribute("parentId", (Object)parentId);
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/address/o_update.do"})
    public String update(Long parentId, Address bean, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean.getId(), request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        bean = this.manager.update(bean);
        log.info("update Address id={}.", (Object)bean.getId());
        return this.list(parentId, pageNo, request, model);
    }

    @RequestMapping(value={"/address/o_delete.do"})
    public String delete(Long[] ids, Long parentId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Address[] beans;
            Address[] addressArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Address bean = addressArray[n2];
                log.info("delete Address id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.region.sub.region"));
            return errors.showErrorPage(model);
        }
        return this.list(parentId, pageNo, request, model);
    }

    @RequestMapping(value={"/address/o_priority.do"})
    public String priority(Long[] wids, Long parentId, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(parentId, pageNo, request, model);
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        Address entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Address.class, (Serializable)id);
    }

    private WebErrors validateSave(Address bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateUpdate(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        if (this.vldExist(id, web.getId(), errors)) {
            return errors;
        }
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Website web = SiteUtils.getWeb((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, web.getId(), errors);
            ++n2;
        }
        return errors;
    }

    private boolean vldExist(Long id, Long webId, WebErrors errors) {
        if (errors.ifNull((Object)id, "id")) {
            return true;
        }
        Address entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Address.class, (Serializable)id);
    }
}

