/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Adspace;
import com.jspgou.cms.manager.AdspaceMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AdspaceAct {
    private static final Logger log = LoggerFactory.getLogger(AdspaceAct.class);
    @Autowired
    private ProductMng productMng;
    @Autowired
    private AdspaceMng manager;

    @RequestMapping(value={"/adspace/v_list.do"})
    public String list(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        List<Adspace> list = this.manager.getList();
        model.addAttribute("list", list);
        return "adspace/list";
    }

    @RequestMapping(value={"/adspace/v_add.do"})
    public String add(HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        return "adspace/add";
    }

    @RequestMapping(value={"/adspace/v_edit.do"})
    public String edit(Integer pageNo, Integer id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Adspace bean = this.manager.findById(id);
        model.addAttribute("adspace", (Object)bean);
        return "adspace/edit";
    }

    @RequestMapping(value={"/adspace/o_update.do"})
    public String update(Adspace bean, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.manager.updateByUpdater(bean);
        return this.list(request, response, model);
    }

    @RequestMapping(value={"/adspace/o_save.do"})
    public String save(Integer pageNo, Adspace bean, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        this.manager.save(bean);
        return this.list(request, response, model);
    }

    @RequestMapping(value={"/adspace/o_delete.do"})
    public String delete(Integer[] ids, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Adspace[] beans;
            Adspace[] adspaceArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Adspace bean = adspaceArray[n2];
                log.info("delete Adspace. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.advertisement.to.contain.advertising.management.data"));
            return errors.showErrorPage(model);
        }
        return this.list(request, response, model);
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private void vldExist(Integer id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        Adspace entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, Adspace.class, (Serializable)id);
    }
}

