/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Adspace;
import com.jspgou.cms.entity.Advertise;
import com.jspgou.cms.manager.AdspaceMng;
import com.jspgou.cms.manager.AdvertiseMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.cms.web.RequestUtils1;
import com.jspgou.common.page.Pagination;
import com.jspgou.common.page.SimplePage;
import com.jspgou.common.web.CookieUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AdvertiseAct {
    private static final Logger log = LoggerFactory.getLogger(AdvertiseAct.class);
    @Autowired
    private ProductMng productMng;
    @Autowired
    private AdspaceMng adspaceMng;
    @Autowired
    private AdvertiseMng manager;

    @RequestMapping(value={"/advertise/v_list.do"})
    public String list(Integer queryAdspaceId, Boolean queryEnabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Pagination pagination = this.manager.getPage(queryAdspaceId, queryEnabled, SimplePage.cpn((Integer)pageNo), CookieUtils.getPageSize((HttpServletRequest)request));
        model.addAttribute("pagination", (Object)pagination);
        model.addAttribute("pageNo", (Object)pagination.getPageNo());
        if (queryAdspaceId != null) {
            model.addAttribute("queryAdspaceId", (Object)queryAdspaceId);
        }
        if (queryEnabled != null) {
            model.addAttribute("queryEnabled", (Object)queryEnabled);
        }
        return "advertise/list";
    }

    @RequestMapping(value={"/advertise/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        List<Adspace> adspaceList = this.adspaceMng.getList();
        model.addAttribute("adspaceList", adspaceList);
        return "advertise/add";
    }

    @RequestMapping(value={"/advertise/v_edit.do"})
    public String edit(Integer id, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Advertise advertise = this.manager.findById(id);
        model.addAttribute("advertise", (Object)advertise);
        model.addAttribute("attr", advertise.getAttr());
        model.addAttribute("adspaceList", this.adspaceMng.getList());
        model.addAttribute("pageNo", (Object)pageNo);
        return "advertise/edit";
    }

    @RequestMapping(value={"/advertise/o_save.do"})
    public String save(Advertise bean, Integer adspaceId, HttpServletRequest request, ModelMap model) {
        Map<String, String> attr = RequestUtils1.getRequestMap(request, "attr_");
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            if (!StringUtils.isBlank((String)entry.getValue())) continue;
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            attr.remove(key);
        }
        bean = this.manager.save(bean, adspaceId, attr);
        log.info("save advertise id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/advertise/o_update.do"})
    public String update(Integer queryAdspaceId, Boolean queryEnabled, Advertise bean, Integer adspaceId, Integer pageNo, HttpServletRequest request, ModelMap model) {
        Map<String, String> attr = RequestUtils1.getRequestMap(request, "attr_");
        HashSet<String> toRemove = new HashSet<String>();
        for (Map.Entry<String, String> entry : attr.entrySet()) {
            if (!StringUtils.isBlank((String)entry.getValue())) continue;
            toRemove.add(entry.getKey());
        }
        for (String key : toRemove) {
            attr.remove(key);
        }
        bean = this.manager.update(bean, adspaceId, attr);
        log.info("update advertise id={}.", (Object)bean.getId());
        return this.list(queryAdspaceId, queryEnabled, pageNo, request, model);
    }

    @RequestMapping(value={"/advertise/o_delete.do"})
    public String delete(Integer[] ids, Integer queryAdspaceId, Boolean queryEnabled, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Advertise[] beans;
            Advertise[] advertiseArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Advertise bean = advertiseArray[n2];
                log.info("delete advertise. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Please.delete.the.data.to.change.the.advertising.management"));
            return errors.showErrorPage(model);
        }
        return this.list(queryAdspaceId, queryEnabled, pageNo, request, model);
    }

    private WebErrors validateDelete(Integer[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Integer[] integerArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Integer id = integerArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private void vldExist(Integer id, WebErrors errors) {
        if (errors.hasErrors()) {
            return;
        }
        Advertise entity = this.manager.findById(id);
        errors.ifNotExist((Object)entity, Advertise.class, (Serializable)id);
    }
}

