/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.Alipay;
import com.jspgou.cms.entity.Order;
import com.jspgou.cms.entity.PaymentPlugins;
import com.jspgou.cms.entity.Shipments;
import com.jspgou.cms.entity.ShopAdmin;
import com.jspgou.cms.manager.OrderMng;
import com.jspgou.cms.manager.PaymentPluginsMng;
import com.jspgou.cms.manager.ShipmentsMng;
import com.jspgou.cms.web.threadvariable.AdminThread;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class AlipayAct
extends Alipay {
    @Autowired
    private OrderMng manager;
    @Autowired
    private PaymentPluginsMng paymentPluginsMng;
    @Autowired
    private ShipmentsMng shipmentMng;

    @RequestMapping(value={"/order/o_shipments.do"})
    public String shipments(Shipments bean, Long id, HttpServletRequest request, HttpServletResponse response, ModelMap model) {
        Order order = this.manager.findById(id);
        ShopAdmin admin = AdminThread.get();
        bean.setShopAdmin(admin);
        bean.setIndent(order);
        if (order.getPayment().getType() == 1) {
            if (order.getShippingStatus() == 1 && order.getStatus() == 2 && order.getPaymentStatus() == 2) {
                this.shipments(bean, order, id, response);
            }
        } else if (order.getShippingStatus() == 1 && order.getStatus() == 2) {
            this.shipments(bean, order, id, response);
        }
        model.addAttribute("order", (Object)order);
        return "order/view";
    }

    public void shipments(Shipments bean, Order order, Long id, HttpServletResponse response) {
        Shipments shipments = this.shipmentMng.save(bean);
        order.setShippingStatus(2);
        this.manager.updateByUpdater(order);
        this.manager.updateSaleCount(id);
        if (order.getPaymentCode() != null) {
            PaymentPlugins paymentPlugins = this.paymentPluginsMng.findByCode(order.getPaymentCode());
            if (!StringUtils.isBlank((String)order.getPaymentCode()) && order.getPaymentCode().equals("alipayPartner")) {
                try {
                    this.alipay(paymentPlugins, order, shipments.getWaybill());
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private String alipay(PaymentPlugins paymentPlugins, Order order, String waybill) throws Exception {
        String trade_no = order.getTradeNo();
        String logistics_name = order.getShipping().getLogistics().getName();
        String invoice_no = waybill;
        String transport_type = order.getShipping().getLogisticsType();
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "send_goods_confirm_by_platform");
        sParaTemp.put("partner", paymentPlugins.getPartner());
        sParaTemp.put("_input_charset", "utf-8");
        sParaTemp.put("trade_no", trade_no);
        sParaTemp.put("logistics_name", logistics_name);
        sParaTemp.put("invoice_no", invoice_no);
        sParaTemp.put("transport_type", transport_type);
        String sHtmlText = AlipayAct.buildRequest("", "", sParaTemp, paymentPlugins.getSellerKey());
        return sHtmlText;
    }
}

