/*
 * Decompiled with CFR 0.152.
 */
package com.jspgou.cms.action.admin.main;

import com.jspgou.cms.entity.Brand;
import com.jspgou.cms.manager.BrandMng;
import com.jspgou.cms.manager.CategoryMng;
import com.jspgou.cms.manager.ProductMng;
import com.jspgou.common.util.CnToSpell;
import com.jspgou.common.util.StrUtils;
import com.jspgou.common.web.ResponseUtils;
import com.jspgou.core.web.SiteUtils;
import com.jspgou.core.web.WebErrors;
import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.ModelMap;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
public class BrandAct {
    private static final Logger log = LoggerFactory.getLogger(BrandAct.class);
    @Autowired
    private ProductMng productMng;
    @Autowired
    private BrandMng manager;
    @Autowired
    private CategoryMng categoryMng;

    @RequestMapping(value={"/brand/v_list.do"})
    public String list(Integer pageNo, HttpServletRequest request, ModelMap model) {
        List<Brand> list = this.manager.getAllList();
        model.addAttribute("list", list);
        return "brand/list";
    }

    @RequestMapping(value={"/brand/v_add.do"})
    public String add(HttpServletRequest request, ModelMap model) {
        return "brand/add";
    }

    @RequestMapping(value={"/brand/v_edit.do"})
    public String edit(Long id, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateEdit(id, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        model.addAttribute("brand", (Object)this.manager.findById(id));
        return "brand/edit";
    }

    @RequestMapping(value={"/brand/o_save.do"})
    public String save(Brand bean, String text, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateSave(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        String name = bean.getName();
        CnToSpell cts = new CnToSpell();
        bean.setFirstCharacter(cts.getBeginCharacter(name).substring(0, 1));
        bean = this.manager.save(bean, text);
        log.info("save brand. id={}", (Object)bean.getId());
        return "redirect:v_list.do";
    }

    @RequestMapping(value={"/brand/o_update.do"})
    public String update(Brand bean, String text, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateUpdate(bean, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        String name = bean.getName();
        CnToSpell cts = new CnToSpell();
        bean.setFirstCharacter(cts.getBeginCharacter(name).substring(0, 1));
        bean = this.manager.update(bean, text);
        log.info("update brand. id={}.", (Object)bean.getId());
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/brand/o_delete.do"})
    public String delete(Long[] ids, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validateDelete(ids, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        try {
            Brand[] beans;
            Brand[] brandArray = beans = this.manager.deleteByIds(ids);
            int n = beans.length;
            int n2 = 0;
            while (n2 < n) {
                Brand bean = brandArray[n2];
                log.info("delete brand. id={}", (Object)bean.getId());
                ++n2;
            }
        }
        catch (Exception e) {
            errors.addErrorString(this.productMng.getTipFile("Pleaseselectedoperation"));
            return errors.showErrorPage(model);
        }
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/brand/o_priority.do"})
    public String priority(Long[] wids, Integer[] priority, Integer pageNo, HttpServletRequest request, ModelMap model) {
        WebErrors errors = this.validatePriority(wids, priority, request);
        if (errors.hasErrors()) {
            return errors.showErrorPage(model);
        }
        this.manager.updatePriority(wids, priority);
        model.addAttribute("message", (Object)"global.success");
        return this.list(pageNo, request, model);
    }

    @RequestMapping(value={"/brand/v_check_brandName.do"})
    public void checkUsername(String name, HttpServletResponse response) {
        String pass = StringUtils.isBlank((String)name) ? "false" : (this.manager.brandNameNotExist(name) ? "true" : "false");
        ResponseUtils.renderJson((HttpServletResponse)response, (String)pass);
    }

    private WebErrors validateSave(Brand bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        bean.setWebUrl(StrUtils.handelUrl((String)bean.getWebUrl()));
        bean.setWebsite(SiteUtils.getWeb((HttpServletRequest)request));
        return errors;
    }

    private WebErrors validateEdit(Long id, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateUpdate(Brand bean, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        Long id = bean.getId();
        bean.setWebUrl(StrUtils.handelUrl((String)bean.getWebUrl()));
        errors.ifNull((Object)id, "id");
        this.vldExist(id, errors);
        return errors;
    }

    private WebErrors validateDelete(Long[] ids, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        errors.ifEmpty((Object[])ids, "ids");
        Long[] longArray = ids;
        int n = ids.length;
        int n2 = 0;
        while (n2 < n) {
            Long id = longArray[n2];
            this.vldExist(id, errors);
            ++n2;
        }
        return errors;
    }

    private WebErrors validatePriority(Long[] wids, Integer[] priority, HttpServletRequest request) {
        WebErrors errors = WebErrors.create((HttpServletRequest)request);
        if (errors.ifEmpty((Object[])wids, "wids")) {
            return errors;
        }
        if (errors.ifEmpty((Object[])priority, "priority")) {
            return errors;
        }
        if (wids.length != priority.length) {
            errors.addErrorString("wids length not equals priority length");
            return errors;
        }
        int i = 0;
        int len = wids.length;
        while (i < len) {
            this.vldExist(wids[i], errors);
            if (priority[i] == null) {
                priority[i] = 0;
            }
            ++i;
        }
        return errors;
    }

    private boolean vldExist(Long id, WebErrors errors) {
        Brand entity = this.manager.findById(id);
        return errors.ifNotExist((Object)entity, Brand.class, (Serializable)id);
    }
}

